# `Zov Карты` Интеграция - InterProcessCommunication (IPC)

## [Passing objects over IPC](https://developer.android.com/develop/background-work/services/aidl#PassingObjects)

### Подключение к проекту для интеграции

- Добавить модуль 'zovMapsIpc'
- Объявить в 'AndroidManifest'

```
    <queries>
        <intent>
            <action android:name="com.zov.maps.ipc.ZovMapsIpcBase"/>
        </intent>
        <intent>
            <action android:name="com.zov.maps.ipc.ZovMapsIpcGeo"/>
        </intent>
        <intent>
            <action android:name="com.zov.maps.ipc.ZovMapsIpcLayers"/>
        </intent>
        <intent>
            <action android:name="com.zov.maps.ipc.ZovMapsIpcStyles"/>
        </intent>
    </queries>
```

### ZovMapsIpcBase - базовый функционал для работы с картой

- зумирование карты на точку

### ZovMapsIpcGeo - нанесение объектов на карту

- нанесение всех типов объектов
- удаление объекта
- изменение объекта (типа, геометрии, стиля)

### ZovMapsIpcLayers - работа с графическими слоями

- создание графического слоя
- удаление графического слоя (слой должен быть неактивным и незаблокированным)
- удаление всех объектов графического слоя (слой должен быть незаблокированным)

### ZovMapsIpcStyles - получение стилей

- получение всех стилей объектов (id стиля надо для нанесения объектов)

# Releases

## v1.0 `ZovКарты - 12.7` (11.09.2024)

## v2.0 `ZovКарты - 13.0` (28.11.2024)
- Поддержка Сектора 
  - для построения необходимо передать точки (центр радиуса и центр дуги) и угол сектора
  - при запросе сектора возвращается 5 точек замкнутого полигона - центр, старт дуги, центр дуги, окончание дуги и снова центр
    (при необходимости угол сектора вычисляется самостоятельно)
