package com.zov.maps.integration.demo.zovMaps

import android.content.ComponentName
import android.content.Context
import android.content.Intent
import android.content.ServiceConnection
import android.os.IBinder
import com.zov.maps.ipc.ZovMapsIpcBase
import com.zov.maps.ipc.models.base.ZovMapCenter

class ZovMapsIpcBaseHelper(
    private val ctx: Context,
) {

    var connected: Boolean = false
        private set

    fun checkAndConnect() {
        if (!connected) {
            connect()
        }
    }

    fun connect() {
        createExplicitIntent()?.also {
            ctx.bindService(
                it, serviceConnection, Context.BIND_AUTO_CREATE + Context.BIND_IMPORTANT
            )
            connected = true
        }
    }

    fun disconnect() {
        if (connected) {
            ctx.unbindService(serviceConnection)
        }
        connected = false
    }

    private var ipc: ZovMapsIpcBase? = null

    private var serviceConnection = object : ServiceConnection {

        override fun onServiceConnected(name: ComponentName?, service: IBinder?) {
            ipc = ZovMapsIpcBase.Stub.asInterface(service)
        }

        override fun onServiceDisconnected(name: ComponentName?) {
            ipc = null
        }
    }

    private fun createExplicitIntent(): Intent? {
        val intent = Intent(IPC_NAME)
        val services = ctx.packageManager.queryIntentServices(intent, 0)
        if (services.isEmpty()) {
            return null
        }
        return Intent(intent).apply {
            val resolveInfo = services[0]
            val packageName = resolveInfo.serviceInfo.packageName
            val className = resolveInfo.serviceInfo.name
            component = ComponentName(packageName, className)
        }
    }

    fun setMapCenter(center: ZovMapCenter) {
        ipc!!.setMapCenter(center)
    }

    private companion object {

        const val IPC_NAME = "com.zov.maps.ipc.ZovMapsIpcBase"
    }
}
