package com.zov.maps.integration.demo.utils.livedata

import androidx.lifecycle.LifecycleOwner
import androidx.lifecycle.LiveData
import androidx.lifecycle.Observer

fun <T> LiveData<T>.nonNullObserve(lifecycleOwner: LifecycleOwner, observer: (t: T) -> Unit) =
    observe(lifecycleOwner, Observer { it?.let(observer) })

fun <T> LiveData<T>.nonNullObserveForever(observer: (t: T) -> Unit) =
    observeForever(Observer { it?.let(observer) })

fun LiveData<Boolean>.observeIfTrue(lifecycleOwner: LifecycleOwner, observer: () -> Unit) =
    nonNullObserve(lifecycleOwner) { if (it) observer() }

inline fun <T> LiveData<T>.observeForever(crossinline observer: (t: T) -> Unit) =
    observeForever { observer(it) }
