package com.zov.maps.integration.demo.utils.extensions

import android.view.View

fun View.clickWithDebounce(debounceTime: Long = 500L, action: () -> Unit) {

    setOnClickListener(object : View.OnClickListener {
        private var lastClickTime: Long = 0

        override fun onClick(v: View) {
            val clickTime = System.currentTimeMillis()
            if (clickTime - lastClickTime > debounceTime) action() else return
            lastClickTime = clickTime
        }
    })
}
