package com.zov.maps.integration.demo.utils.extensions

import android.app.Activity
import android.view.WindowManager
import android.view.inputmethod.InputMethodManager
import android.widget.Toast
import androidx.annotation.StringRes
import androidx.fragment.app.Fragment

fun Fragment.toast(str: String, length: Int = Toast.LENGTH_SHORT) {
    Toast.makeText(requireContext(), str, length).show()
}

fun Fragment.toast(@StringRes resId: Int, length: Int = Toast.LENGTH_SHORT) {
    Toast.makeText(requireContext(), resId, length).show()
}

fun Fragment.hideKeyboard() {
    val activity = activity ?: return
    val view = activity.currentFocus
    if (view != null) {
        val imm = activity.getSystemService(Activity.INPUT_METHOD_SERVICE) as InputMethodManager?
        imm?.hideSoftInputFromWindow(view.windowToken, 0)
    }
}

fun Fragment.showKeyboard() {
    val activity = activity ?: return
    val view = activity.currentFocus
    if (view != null) {
        val imm = activity.getSystemService(Activity.INPUT_METHOD_SERVICE) as InputMethodManager?
        imm?.showSoftInput(view, InputMethodManager.SHOW_IMPLICIT)
    }
}

fun Fragment.switchScreen(value: Boolean) {
    if (value) {
        requireActivity().window.addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON)
    } else {
        requireActivity().window.clearFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON)
    }
}

@Suppress("DEPRECATION")
fun Fragment.switchFullScreen(value: Boolean) {
    if (value) {
        requireActivity().window.addFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN)
    } else {
        requireActivity().window.clearFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN)
    }
}
