package com.zov.maps.integration.demo.utils.extensions

import android.annotation.SuppressLint
import android.content.Context
import android.content.Intent
import android.content.pm.PackageManager
import android.content.res.Configuration
import android.widget.Toast
import androidx.annotation.ColorRes
import androidx.annotation.DrawableRes
import androidx.annotation.Size
import androidx.annotation.StringRes
import androidx.core.content.ContextCompat

@Suppress("DEPRECATION")
fun Context.isPackageInstalled(packageName: String): Boolean =
    try {
        packageManager.getPackageInfo(packageName, 0)
        true
    } catch (e: PackageManager.NameNotFoundException) {
        false
    }

fun Context.getLaunchIntentForPackage(packageName: String): Intent? =
    packageManager.getLaunchIntentForPackage(packageName)

fun Context.appName(): String = applicationInfo.loadLabel(packageManager).toString()

@Suppress("DEPRECATION")
@SuppressLint("QueryPermissionsNeeded")
fun Context.isIntentSafe(intent: Intent): Boolean =
    packageManager.queryIntentActivities(intent, PackageManager.MATCH_DEFAULT_ONLY).isNotEmpty()

fun Context.hasPermissions(@Size(min = 1) vararg perms: String): Boolean = this.let {
    return perms.all { perm ->
        ContextCompat.checkSelfPermission(it, perm) == PackageManager.PERMISSION_GRANTED
    }
}

val Context.isDarkTheme
    get() = when (resources.configuration.uiMode and Configuration.UI_MODE_NIGHT_MASK) {
        Configuration.UI_MODE_NIGHT_NO, Configuration.UI_MODE_NIGHT_UNDEFINED -> false
        else -> true
    }

fun Context.toast(str: String, length: Int = Toast.LENGTH_SHORT) {
    Toast.makeText(this, str, length).show()
}

fun Context.toast(@StringRes resId: Int, length: Int = Toast.LENGTH_SHORT) {
    Toast.makeText(this, resId, length).show()
}

fun Context.getDrawableCompat(@DrawableRes resId: Int?) =
    resId?.let { ContextCompat.getDrawable(this, it) }

fun Context.getColorCompat(@ColorRes color: Int) = ContextCompat.getColor(this, color)
