package com.zov.maps.integration.demo.utils.coroutines

import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow

// https://elizarov.medium.com/shared-flows-broadcast-channels-899b675e805c
// https://habr.com/ru/post/529944/
// Смотрите на StateFlow как на изменяемую переменную, на изменения которой можно подписаться.
// Его последнее значение всегда доступно, и, фактически, последнее значение — единственное, что важно для observers.
// Разница в производительности StateFlow с Channel и обычным Flow становится очевидной — StateFlow обновляет состояние без выделения памяти.

@Suppress("UnnecessaryAbstractClass")
abstract class StateDispatcher<T>(
    init: T
) {

    private val _flow = MutableStateFlow(init)

    val flow: StateFlow<T>
        get() = _flow

    val value: T
        get() = _flow.value

    fun tryEmit(value: T) {
        _flow.tryEmit(value)
    }

    suspend fun emit(value: T) {
        _flow.emit(value)
    }
}
