package com.zov.maps.integration.demo.utils.coroutines

import kotlinx.coroutines.Dispatchers
import kotlin.coroutines.CoroutineContext

interface CoroutineContextProvider {

    val mainContext: CoroutineContext

    val bgContext: CoroutineContext
}

object CoroutineContextProviderImpl : CoroutineContextProvider {

    override val mainContext: CoroutineContext by lazy {
        Dispatchers.Main
    }

    override val bgContext: CoroutineContext by lazy {
        Dispatchers.IO
    }
}
