package com.zov.maps.integration.demo.utils.color

import android.graphics.Color

object ColorParser {

    fun parse(colorString: String, defaultColor: String = DEFAULT_COLOR): Int = try {
        Color.parseColor(colorString)
    } catch (e: java.lang.IllegalArgumentException) {
        Color.parseColor(defaultColor)
    }

    private const val DEFAULT_COLOR = "#FF000000"
}
