package com.zov.maps.integration.demo.ui.stylesIpc.sort

import com.zov.maps.ipc.models.styles.StyleType
import com.zov.maps.ipc.models.styles.ZovMapObjectStyle

internal class StylesSorterImpl : StylesSorter {

    override fun sortStyles(init: List<ZovMapObjectStyle>): List<ZovMapObjectStyle> {
        val textStyles = init.filter { it.typeId == StyleType.TEXT.id }
        val pointStyles = init.filter { it.typeId == StyleType.POINT.id }
        val lineStyles = init.filter { it.typeId == StyleType.LINE.id }
        val polygonStyles = init.filter { it.typeId == StyleType.POLYGON.id }

        val textSorted = sortByCategories(textStyles)
        val pointSorted = sortByCategories(pointStyles)
        val lineSorted = sortByCategories(lineStyles)
        val polygonSorted = sortByCategories(polygonStyles)

        return textSorted + pointSorted + lineSorted + polygonSorted
    }

    override fun sortByCategories(init: List<ZovMapObjectStyle>): List<ZovMapObjectStyle> {
        val result = mutableListOf<ZovMapObjectStyle>()
        val categories = init.map { it.category }.distinct().sorted()
        categories.forEach { category ->
            val stylesCategory = init.filter { it.category == category }
            val sorted = sortBySubCategories(stylesCategory)
            result.addAll(sorted)
        }
        return result
    }

    override fun sortBySubCategories(init: List<ZovMapObjectStyle>): List<ZovMapObjectStyle> {
        val result = mutableListOf<ZovMapObjectStyle>()
        val subCategories = init.map { it.subCategory }.distinct().sorted()
        subCategories.forEach { subCategory ->
            val stylesInSubCategory = init.filter { it.subCategory == subCategory }
            val sorted = sortByNames(stylesInSubCategory)
            result.addAll(sorted)
        }
        return result
    }

    override fun sortByNames(init: List<ZovMapObjectStyle>): List<ZovMapObjectStyle> = init.sortedWith(orderByName)

    val orderByName = Comparator<ZovMapObjectStyle> { item1, item2 ->
        item1.name.compareTo(item2.name)
    }
}
