package com.zov.maps.integration.demo.ui.stylesIpc

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.core.view.isInvisible
import androidx.fragment.app.Fragment
import com.zov.maps.integration.demo.databinding.FragmentStylesIpcBinding
import com.zov.maps.integration.demo.utils.extensions.clickWithDebounce
import com.zov.maps.integration.demo.utils.extensions.toast
import com.zov.maps.integration.demo.utils.livedata.nonNullObserve
import org.koin.androidx.viewmodel.ext.android.viewModel

class StylesIpcFragment : Fragment() {

    private var _binding: FragmentStylesIpcBinding? = null
    private val binding get() = _binding!!

    private val viewModel: StylesIpcViewModel by viewModel()

    private lateinit var adapter: StyleItemAdapter

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        lifecycle.addObserver(viewModel)
    }

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?
    ): View {
        _binding = FragmentStylesIpcBinding.inflate(inflater, container, false)
        return binding.root
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        observeData()
        initUI()
    }

    private fun initUI() {
        adapter = StyleItemAdapter()
        binding.styleList.adapter = adapter
        binding.run {
            buttonLoadStyle.clickWithDebounce { viewModel.loadStyle() }
            buttonLoadStyles.clickWithDebounce { viewModel.loadStyles() }
        }
    }

    private fun observeData() {
        viewModel.run {
            msg.nonNullObserve(viewLifecycleOwner) { toast(it) }
            progress.nonNullObserve(viewLifecycleOwner) {
                binding.progressBar.isInvisible = !it
            }
            stylesUI.nonNullObserve(viewLifecycleOwner) {
                adapter.items = it
            }
        }
    }

    override fun onDestroyView() {
        super.onDestroyView()
        _binding = null
    }
}
