package com.zov.maps.integration.demo.ui.stylesIpc

import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.zov.maps.integration.demo.databinding.StyleListItemBinding

internal class StyleItemAdapter : RecyclerView.Adapter<StyleItemAdapter.StyleItemViewHolder>() {

    var items = emptyList<StyleItemUI>()
        set(value) {
            field = value
            notifyDataSetChanged()
        }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): StyleItemViewHolder {
        val binding = StyleListItemBinding.inflate(LayoutInflater.from(parent.context), parent, false)
        return StyleItemViewHolder(binding)
    }

    override fun onBindViewHolder(holder: StyleItemViewHolder, position: Int) {
        holder.bind(items[position])
    }

    override fun getItemCount(): Int {
        return items.size
    }

    inner class StyleItemViewHolder(private val binding: StyleListItemBinding) : RecyclerView.ViewHolder(binding.root) {

        fun bind(item: StyleItemUI) {
            binding.styleName.text = item.name
            binding.styleId.text = item.id
            binding.textCategory.text = item.category
            binding.textSubCategory.text = item.subCategory
            binding.textSubDescription.text = item.description
            binding.textType.text = item.type
            item.icon?.also {
                binding.styleIcon.setImageDrawable(it)
            }
        }
    }
}
