package com.zov.maps.integration.demo.ui.layersIpc

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.Fragment
import com.zov.maps.integration.demo.databinding.FragmentLayersIpcBinding
import com.zov.maps.integration.demo.utils.extensions.clickWithDebounce
import com.zov.maps.integration.demo.utils.extensions.toast
import com.zov.maps.integration.demo.utils.livedata.nonNullObserve
import org.koin.androidx.viewmodel.ext.android.viewModel

class LayersIpcFragment : Fragment() {

    private var _binding: FragmentLayersIpcBinding? = null
    private val binding get() = _binding!!

    private val viewModel: LayersIpcViewModel by viewModel()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        lifecycle.addObserver(viewModel)
    }

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?
    ): View {
        _binding = FragmentLayersIpcBinding.inflate(inflater, container, false)
        return binding.root
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        observeData()
        initUI()
    }

    private fun observeData() {
        viewModel.run {
            msg.nonNullObserve(viewLifecycleOwner) { toast(it) }
            idLayerLiveData.observe(viewLifecycleOwner) {
                binding.textLayerIdValue.text = it
            }
        }
    }

    private fun initUI() {
        binding.run {
            buttonLoadLayer.clickWithDebounce { viewModel.loadLayer() }
            buttonNewLayerId.clickWithDebounce { viewModel.generateNewLayerId() }
            buttonCreateLayer.clickWithDebounce { viewModel.saveGraphicLayer() }
            buttonDeleteObjects.clickWithDebounce { viewModel.deleteObjects() }
            buttonDeleteLayer.clickWithDebounce { viewModel.deleteLayer() }
        }
    }

    override fun onDestroyView() {
        super.onDestroyView()
        _binding = null
    }
}