package com.zov.maps.integration.demo.ui.baseIpc

import androidx.lifecycle.DefaultLifecycleObserver
import androidx.lifecycle.LifecycleOwner
import com.zov.maps.integration.demo.utils.viewmodel.BaseViewModel
import com.zov.maps.integration.demo.zovMaps.ZovMapsIpcBaseHelper
import com.zov.maps.ipc.models.base.ZovMapCenter
import kotlin.coroutines.CoroutineContext

class BaseIpcViewModel(
    private val zovMapsIpcBaseHelper: ZovMapsIpcBaseHelper,
    mainContext: CoroutineContext,
    bgContext: CoroutineContext,
) : BaseViewModel(mainContext, bgContext), DefaultLifecycleObserver {

    override fun onResume(owner: LifecycleOwner) {
        zovMapsIpcBaseHelper.checkAndConnect()
    }

    override fun onStop(owner: LifecycleOwner) {
        zovMapsIpcBaseHelper.disconnect()
    }

    fun setMapCenter(center: ZovMapCenter) {
        try {
            zovMapsIpcBaseHelper.setMapCenter(center)
            _msg.value = "Отправлен центр"
        } catch (e: Exception) {
            _msg.value = "Проверьте установлено и запущено ли приложение `ZOV Карты`"
        }
    }
}
