package com.zov.maps.integration.demo.ui.baseIpc

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.Fragment
import com.zov.maps.integration.demo.databinding.FragmentBaseIpcBinding
import com.zov.maps.integration.demo.utils.extensions.clickWithDebounce
import com.zov.maps.integration.demo.utils.extensions.toast
import com.zov.maps.integration.demo.utils.livedata.nonNullObserve
import com.zov.maps.ipc.models.base.ZovMapCenter
import com.zov.maps.ipc.models.base.ZovMapGeoPoint
import com.zov.maps.ipc.utils.toGeometry
import org.koin.androidx.viewmodel.ext.android.viewModel

class BaseIpcFragment : Fragment() {

    private var _binding: FragmentBaseIpcBinding? = null
    private val binding get() = _binding!!

    private val viewModel: BaseIpcViewModel by viewModel()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        lifecycle.addObserver(viewModel)
    }

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?
    ): View {
        _binding = FragmentBaseIpcBinding.inflate(inflater, container, false)
        return binding.root
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        observeData()
        initUI()
    }

    private fun observeData() {
        viewModel.run {
            msg.nonNullObserve(viewLifecycleOwner) { toast(it) }
        }
    }

    private fun initUI() {
        binding.buttonCenter.clickWithDebounce {
            viewModel.setMapCenter(
                ZovMapCenter(
                    geometry = ZovMapGeoPoint(59.0, 29.0).toGeometry(),
                    userName = "demo app",
                )
            )
        }
    }

    override fun onDestroyView() {
        super.onDestroyView()
        _binding = null
    }
}