package com.zov.maps.integration.demo.di

import com.zov.maps.integration.demo.ui.baseIpc.BaseIpcViewModel
import com.zov.maps.integration.demo.ui.geoIpc.GeoIpcViewModel
import com.zov.maps.integration.demo.ui.layersIpc.LayersIpcViewModel
import com.zov.maps.integration.demo.ui.stylesIpc.StylesIpcViewModel
import com.zov.maps.integration.demo.utils.coroutines.CoroutineContextProvider
import org.koin.androidx.viewmodel.dsl.viewModel
import org.koin.dsl.module

val viewModelsModule = module {
    viewModel {
        BaseIpcViewModel(
            get(),
            get<CoroutineContextProvider>().mainContext,
            get<CoroutineContextProvider>().bgContext,
        )
    }
    viewModel {
        GeoIpcViewModel(
            get(), get(), get(), get(), get(),
            get<CoroutineContextProvider>().mainContext,
            get<CoroutineContextProvider>().bgContext,
        )
    }
    viewModel {
        LayersIpcViewModel(
            get(), get(), get(),
            get<CoroutineContextProvider>().mainContext,
            get<CoroutineContextProvider>().bgContext,
        )
    }
    viewModel {
        StylesIpcViewModel(
            get(), get(), get(),
            get<CoroutineContextProvider>().mainContext,
            get<CoroutineContextProvider>().bgContext,
        )
    }
}
