package com.zov.maps.integration.demo.di

import com.zov.maps.integration.demo.ui.common.IdLayerDispatcher
import com.zov.maps.integration.demo.ui.common.IdObjectDispatcher
import com.zov.maps.integration.demo.ui.stylesIpc.sort.StylesSorter
import com.zov.maps.integration.demo.ui.stylesIpc.sort.StylesSorterImpl
import com.zov.maps.integration.demo.zovMaps.ZovMapsIpcBaseHelper
import com.zov.maps.integration.demo.zovMaps.ZovMapsIpcGeoHelper
import com.zov.maps.integration.demo.zovMaps.ZovMapsIpcLayersHelper
import com.zov.maps.integration.demo.zovMaps.ZovMapsIpcStylesHelper
import org.koin.dsl.module

val ipcModule = module {
    single<ZovMapsIpcBaseHelper> { ZovMapsIpcBaseHelper(get()) }
    single<ZovMapsIpcGeoHelper> { ZovMapsIpcGeoHelper(get()) }
    single<ZovMapsIpcLayersHelper> { ZovMapsIpcLayersHelper(get()) }
    single<ZovMapsIpcStylesHelper> { ZovMapsIpcStylesHelper(get()) }

    single<IdObjectDispatcher> { IdObjectDispatcher(get()) }
    single<IdLayerDispatcher> { IdLayerDispatcher(get()) }
    single<StylesSorter> { StylesSorterImpl() }
}
