import com.project.starter.easylauncher.filter.ColorRibbonFilter

plugins {
    alias(libs.plugins.android.application)
    alias(libs.plugins.jetbrains.kotlin.android)
    alias(libs.plugins.easylauncher)
    alias(libs.plugins.kotlin.parcelize)
    alias(libs.plugins.kotlin.serialization)
}

// https://github.com/usefulness/easylauncher-gradle-plugin
easylauncher {
    buildTypes {
        register("debug") {
            filters(
                customRibbon(
                    gravity = ColorRibbonFilter.Gravity.TOP,
                    label = "debug",
                    ribbonColor = "#FF0000",
                    textSizeRatio = 0.15f,
                )
            )
        }
        register("release") {
            enable(false)
        }
    }
}

val mapsKeyFileName: String = "debug.keystore"
val mapsKeyAlias: String = "androiddebugkey"
val mapsKeyPwd: String = "android"
val mapsStorePwd: String = "android"

val buildNumber: String? = System.getenv("BUILD_COUNTER")

android {
    signingConfigs {
        create("signingConfigRelease") {
            storeFile = file(mapsKeyFileName)
            keyAlias = mapsKeyAlias
            keyPassword = mapsKeyPwd
            storePassword = mapsStorePwd
        }
    }

    namespace = "com.zov.maps.integration.demo"
    compileSdk = COMPILE_SDK

    defaultConfig {
        applicationId = "com.zov.maps.integration.demo"
        minSdk = MIN_SDK
        targetSdk = TARGET_SDK

        versionCode = rootProject.ext.get("APP_CODE_VERSION").toString().toInt()
        versionName = rootProject.ext.get("APP_NAME_VERSION").toString()

        val appPrefix = "zovmaps-integration-demo-$versionName"
        setProperty("archivesBaseName", buildNumber?.let { "${appPrefix}_$it" } ?: appPrefix)
    }

    buildTypes {
        debug {
            applicationIdSuffix = ".debug"
            isDebuggable = true
            isMinifyEnabled = false
            isShrinkResources = false
            proguardFiles(
                getDefaultProguardFile("proguard-android.txt"),
                "$rootDir/proguard/proguard-release.pro"
            )
        }
        release {
            isDebuggable = false
            isMinifyEnabled = true
            isShrinkResources = true
            proguardFiles(
                getDefaultProguardFile("proguard-android.txt"),
                "$rootDir/proguard/proguard-release.pro"
            )
            signingConfig = signingConfigs.getByName("signingConfigRelease")
        }
    }
    compileOptions {
        sourceCompatibility = JAVA_VERSION
        targetCompatibility = JAVA_VERSION
    }
    kotlinOptions {
        jvmTarget = JVM_TARGET
    }
    buildFeatures {
        viewBinding = true
    }
}

dependencies {
    implementation(project(":ipcZovMaps"))

    implementation(libs.androidx.core.ktx)
    implementation(libs.androidx.appcompat)
    implementation(libs.material)
    implementation(libs.androidx.constraintlayout)
    implementation(libs.androidx.lifecycle.livedata.ktx)
    implementation(libs.androidx.lifecycle.viewmodel.ktx)
    implementation(libs.androidx.navigation.fragment.ktx)
    implementation(libs.androidx.navigation.ui.ktx)

    implementation(libs.kotlinx.serialization.json)

    implementation(libs.koin.android)
}