-- Adminer 4.3.1 MySQL dump

SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';

CREATE DATABASE `iso_tra` /*!40100 DEFAULT CHARACTER SET utf8 */;
USE `iso_tra`;

SET NAMES utf8mb4;

DROP TABLE IF EXISTS `action_titles`;
CREATE TABLE `action_titles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `updated_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `action_titles` (`id`, `title`, `created_by`, `updated_by`, `created_at`, `updated_at`, `status`) VALUES
(1,	'Corrective',	1,	NULL,	'2018-10-10 11:31:08',	'2018-10-10 11:31:08',	1);

DROP TABLE IF EXISTS `activities`;
CREATE TABLE `activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module_id` int(10) unsigned NOT NULL,
  `icon` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` enum('list','create','details','edit','delete','generate','import','export','submit_for_review','reviewed','submit_for_approval','rejected','approved','release','review_comment','check_out','check_in','reopen','consolidate','empty','upload_document','download_document','revert','change_password','select_item','select_user','revert') COLLATE utf8mb4_unicode_ci NOT NULL,
  `ui_sref` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `button_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activities_module_id_foreign` (`module_id`),
  CONSTRAINT `activities_module_id_foreign` FOREIGN KEY (`module_id`) REFERENCES `modules` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `activities` (`id`, `code`, `title`, `module_id`, `icon`, `label`, `type`, `ui_sref`, `url`, `url_name`, `button_name`) VALUES
(1,	'CREATE_DOCUMENT',	'Document created',	6,	'fa fa-fw fa-file',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(2,	'EDIT_DOCUMENT',	'Document updated',	6,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(3,	'REVIEW_DOCUMENT_REVIEWED',	'Document reviewed',	6,	'fa fa-fw fa-send',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(4,	'REVIEW_DOCUMENT_REJECT',	'Document Rejected review user',	6,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(5,	'APPROVE_DOCUMENT_REJECT',	'Document Rejected  by approving user',	6,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(6,	'APPROVE_DOCUMENT',	'Document approved by  approving user',	6,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(7,	'CREATE_CHANGE_REQUEST',	'Change request created',	6,	'fa fa-fw fa-file',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(8,	'EDIT_CHANGE_REQUEST',	'Change request updated',	6,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(9,	'REVIEW_CHANGE_REQUEST_REVIEWED',	'Change request reviewed',	7,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(10,	'REVIEW_CHANGE_REQUEST_REJECT',	'Change request Rejected review user',	7,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(11,	'APPROVE_CHANGE_REQUEST_REJECT',	'Change request Rejected  by approving user',	7,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(12,	'APPROVE_CHANGE_REQUEST',	'Change request approved by  approving user',	7,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(13,	'CREATE_CONTEXT',	'Context created',	2,	'fa fa-fw fa-file',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(14,	'UPDATE_CONTEXT',	'Context updated',	2,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(15,	'REVIEW_CONTEXT',	'Context Reviewed',	2,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(16,	'CREATE_MRM_PROGRAM',	'MRM Program created',	56,	'fa fa-fw fa-file',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(17,	'EDIT_MRM_PROGRAM',	'MRM Program updated',	56,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(18,	'CREATE_MRM_PLAN',	'MRM Plan created',	56,	'fa fa-fw fa-file',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(19,	'EDIT_MRM_PLAN',	'MRM Plan updated',	56,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(20,	'PUBLISH_MRM_PLAN',	'MRM Plan published',	56,	'fa fa-fw fa-globe',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(21,	'CREATE_MRM_MEETING',	'MRM meeting created',	56,	'fa fa-fw fa-file',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(22,	'EDIT_MRM_MEETING',	'MRM meeting updated',	56,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(23,	'CREATE_MRM_MEETING_ACTION',	'MRM meeting action  created',	56,	'fa fa-fw fa-file',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(24,	'EDIT_MRM_MEETING_ACTION',	'MRM meeting action updated',	56,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(25,	'STATUS_UPDATION_MRM_MEETING_ACTION',	'',	56,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(26,	'CREATE_BUSINESS_PROFILE',	'Business profile created',	1,	'fa fa-fw fa-file',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(27,	'EDIT_BUSINESS_PROFILE',	'Business profile updated',	1,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(28,	'EDIT_VMV',	'updated',	1,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(29,	'CREATE_COMPLIANCE_REGISTER',	'Compliance register created',	1,	'fa fa-fw fa-file',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(30,	'EDIT_COMPLIANCE_REGISTER',	'Compliance register updated',	1,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(31,	'REVIEW_COMPLIANCE_REGISTER',	'Compliance register reviewed',	1,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(32,	'CREATE_CERTIFICATE',	'',	1,	'fa fa-fw fa-file',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(33,	'EDIT_CERTIFICATE',	'',	1,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(34,	'REVIEW_CERTIFICATE',	'',	1,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(35,	'CREATE_POLICY',	'Policy created',	1,	'fa fa-fw fa-file',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(36,	'EDIT_POLICY',	'Policy updated',	1,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(37,	'CLOSE_CONTEXT',	'Context closed',	1,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(38,	'CREATE_STRATEGY_PLAN',	'Strategy plan created',	136,	'fa fa-fw fa-file',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(39,	'EDIT_STRATEGY_PLAN',	'Strategy plan updated',	136,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(40,	'CLOSE_STRATEGY_PLAN',	'Strategy plan closed',	136,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(41,	'CREATE_SATISFACTION_RESULT',	'Satisfaction result created',	102,	'fa fa-fw fa-file',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(42,	'UPDATE_SATISFACTION_RESULT',	'Satisfaction result updated',	102,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(43,	'CREATE_SATISFACTION_REPORT',	'Satisfaction report created',	164,	'fa fa-fw fa-file',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(44,	'UPDATE_SATISFACTION_REPORT',	'Satisfaction report updated',	164,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(45,	'CREATE_USER',	'',	3,	'fa fa-fw fa-file',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(46,	'UPDATE_USER',	'',	3,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(47,	'CREATE_KM_INTERNAL_DOCUMENT',	'KM internal document created',	108,	'fa fa-fw fa-file',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(48,	'UPDATE_KM_INTERNAL_DOCUMENT',	'KM internal document updated',	108,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(49,	'CREATE_KM_EXTERNAL_DOCUMENT',	'KM External Documents created',	109,	'fa fa-fw fa-file',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(50,	'UPDATE_KM_EXTERNAL_DOCUMENT',	'KM External Documents updated',	109,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(51,	'CREATE_RISK_CONTEXT',	'Context created',	31,	'fa fa-fw fa-file',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(52,	'UPDATE_RISK_CONTEXT',	'Context updated',	31,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(53,	'CREATE_RISK_ASSESMENT',	'Assesment created',	31,	'fa fa-fw fa-file',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(54,	'UPDATE_RISK_ASSESMENT',	'Assesment updated',	31,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(55,	'CREATE_RISK_TREATMENT',	'Treatment created',	31,	'fa fa-fw fa-file',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(56,	'UPDATE_RISK_TREATMENT',	'Treatment updated',	31,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(57,	'SUBMIT_REVIEW_RISK_TREATMENT',	'Treatment submitted for review',	31,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(58,	'SUBMIT_REVIEW_RISK_TREATMENT_APPROVE',	'Treatment review approved',	31,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(59,	'SUBMIT_REVIEW_RISK_TREATMENT_REJECT',	'Treatment review rejected',	31,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(60,	'SUBMIT_CLOSE_RISK_TREATMENT',	'Treatment submitted for close',	31,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(61,	'SUBMIT_CLOSE_RISK_TREATMENT_APPROVE',	'Treatment  approved',	31,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(62,	'SUBMIT_CLOSE_RISK_TREATMENT_REJECT',	'Treatment  rejected',	31,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(63,	'CREATE_AUDIT_PROGRAM',	'Audit program created',	9,	'fa fa-fw fa-file',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(64,	'EDIT_AUDIT_PROGRAM',	'Audit program updated',	9,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(65,	'CREATE_AUDIT_PLAN',	'Audit plan created',	9,	'fa fa-fw fa-file',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(66,	'UPDATE_AUDIT_PLAN',	'Audit plan updated',	9,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(67,	'PUBLISH_AUDIT_PLAN',	'Audit plan published',	9,	'fa fa-fw fa-globe',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(68,	'CREATE_AUDIT',	'Audit  created',	9,	'fa fa-fw fa-file',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(69,	'UPDATE_AUDIT',	'Audit updated',	9,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(70,	'ACCEPT_AUDIT_PLAN',	'Audit plan accepted',	9,	'fa fa-fw fa-check',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(71,	'AUDIT_REPORT_SUBMIT_FOR_REVIEW',	'Audit report submit for review',	9,	'fa fa-fw fa-globe',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(72,	'AUDIT_REPORT_SUBMIT_FOR_REVIEW_ACCEPT',	'Audit report submit for review accepted',	9,	'fa fa-fw fa-globe',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(73,	'AUDIT_REPORT_SUBMIT_FOR_REVIEW_REJECT',	'Audit report submit for review rejected',	9,	'fa fa-fw fa-globe',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(74,	'AUDIT_FINDING_RESPONSIBLE_USER_SAVE',	'Audit finding responsible user added',	10,	'fa fa-fw fa-file',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(75,	'AUDIT_FINDING_RESPONSIBLE_USER_UPDATE',	'Audit finding responsible user updated',	10,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(76,	'AUDIT_FINDING_CREATE',	'Audit finding created',	10,	'fa fa-fw fa-file',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(77,	'AUDIT_FINDING_UPDATE',	'Audit finding updated',	10,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(78,	'RCA_CREATE',	'Root cause analysis created',	10,	'fa fa-fw fa-file',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(79,	'RCA_UPDATE',	'Root cause analysis  updated',	10,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(80,	'IA_CREATE',	'Impact  analysis  created',	10,	'fa fa-fw fa-file',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(81,	'IA_UPDATE',	'Impact  analysis  updated',	10,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(82,	'FINDING_CA_CREATE',	'Corrective action  created',	10,	'fa fa-fw fa-file',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(83,	'FINDING_CA_UPDATE',	'Corrective action updated',	10,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(84,	'FINDING_FA_RESOLVED',	'Followup actions resolved',	10,	'fa fa-fw fa-globe',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(85,	'EXTERNAL_AUDIT_CREATED',	'External audit created',	106,	'fa fa-fw fa-file',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(86,	'EXTERNAL_AUDIT_UPDATED',	'External audit updated',	106,	'fa fa-fw fa-edit',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(87,	'ACTION_STRATEGY_PLAN',	'Strategy plan action performed',	136,	'fa fa-check-circle',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(88,	'SUBMIT_FOR_REVIEW_DOCUMENT',	'Document submit for review',	6,	'fa fa-fw fa-send',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(89,	'SUBMIT_FOR_REVIEW_CHANGE_REQUEST',	'Change request  submit for review',	7,	'fa fa-fw fa-send',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(90,	'MRM_REPORT_PUBLISH',	'Meeting report published',	56,	'fa fa-fw fa-globe',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(91,	'AUDIT_AUTO_ACCEPTED',	'audit plan auto accepted by',	9,	'fa fa-fw fa-check',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(92,	'AUDIT_FA_ACCEPTED',	'Followup actions accepted',	9,	'fa fa-fw fa-check',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(93,	'AUDIT_FA_REJECTED',	'Followup actions rejected',	9,	'fa fa-fw fa-times',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL),
(94,	'REOPEN_CONTEXT',	'Context reopened',	1,	'fa fa-fw fa-check',	'label-success',	'list',	NULL,	NULL,	NULL,	NULL);

DROP TABLE IF EXISTS `activity_logs`;
CREATE TABLE `activity_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `activity_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `sub_module_id` int(10) unsigned DEFAULT NULL,
  `title` mediumtext COLLATE utf8mb4_unicode_ci,
  `document_id` int(11) DEFAULT NULL,
  `change_request_id` int(11) DEFAULT NULL,
  `context_id` int(11) DEFAULT NULL,
  `mrm_program_id` int(11) DEFAULT NULL,
  `mrm_plan_id` int(11) DEFAULT NULL,
  `mrm_meeting_id` int(11) DEFAULT NULL,
  `mrm_meeting_action_id` int(11) DEFAULT NULL,
  `business_profile_id` int(11) DEFAULT NULL,
  `strategy_vision_mission_id` int(11) DEFAULT NULL,
  `compliance_register_id` int(11) DEFAULT NULL,
  `management_system_policies_id` int(11) DEFAULT NULL,
  `strategy_plan_id` int(11) DEFAULT NULL,
  `customer_satisfaction_id` int(11) DEFAULT NULL,
  `satisfaction_report_id` int(11) DEFAULT NULL,
  `user_management_id` int(11) DEFAULT NULL,
  `iso_certificate_id` int(11) DEFAULT NULL,
  `km_internal_document_id` int(11) DEFAULT NULL,
  `km_external_document_id` int(11) DEFAULT NULL,
  `risk_context_risks_id` int(11) DEFAULT NULL,
  `risk_context_risk_treatments` int(11) DEFAULT NULL,
  `audit_program_id` int(11) DEFAULT NULL,
  `audit_plan_id` int(11) DEFAULT NULL,
  `audit_id` int(11) DEFAULT NULL,
  `audit_report_id` int(11) DEFAULT NULL,
  `external_audit_id` int(11) DEFAULT NULL,
  `audit_finding_id` int(11) DEFAULT NULL,
  `params` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `object_old` text COLLATE utf8mb4_unicode_ci,
  `object_new` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `activity_logs` (`id`, `activity_id`, `user_id`, `sub_module_id`, `title`, `document_id`, `change_request_id`, `context_id`, `mrm_program_id`, `mrm_plan_id`, `mrm_meeting_id`, `mrm_meeting_action_id`, `business_profile_id`, `strategy_vision_mission_id`, `compliance_register_id`, `management_system_policies_id`, `strategy_plan_id`, `customer_satisfaction_id`, `satisfaction_report_id`, `user_management_id`, `iso_certificate_id`, `km_internal_document_id`, `km_external_document_id`, `risk_context_risks_id`, `risk_context_risk_treatments`, `audit_program_id`, `audit_plan_id`, `audit_id`, `audit_report_id`, `external_audit_id`, `audit_finding_id`, `params`, `object_old`, `object_new`, `created_at`, `updated_at`) VALUES
(1,	16,	8,	NULL,	'2019- PR37Enhancement cat 1- MRM Program created',	NULL,	NULL,	NULL,	37,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-12-31 15:40:34',	'2019-12-31 15:40:34'),
(2,	17,	8,	NULL,	'2019- PR37Enhancement cat 1- MRM Program updated',	NULL,	NULL,	NULL,	37,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-12-31 15:46:25',	'2019-12-31 15:46:25'),
(3,	16,	1,	NULL,	'2019- PR38test- MRM Program created',	NULL,	NULL,	NULL,	38,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-12-31 16:19:53',	'2019-12-31 16:19:53'),
(4,	16,	1,	NULL,	'2020- PR39Enhancement cat 2- MRM Program created',	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:19:56',	'2020-01-01 08:19:56'),
(5,	17,	1,	NULL,	'2020- PR39Enhancement cat 2- MRM Program updated',	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:28:09',	'2020-01-01 08:28:09'),
(6,	17,	1,	NULL,	'2020- PR39Enhancement cat 2- MRM Program updated',	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:28:40',	'2020-01-01 08:28:40'),
(7,	17,	1,	NULL,	'2020- PR39Enhancement cat 2- MRM Program updated',	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:29:17',	'2020-01-01 08:29:17'),
(8,	17,	1,	NULL,	'2020- PR39Enhancement cat 2- MRM Program updated',	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:29:35',	'2020-01-01 08:29:35'),
(9,	17,	1,	NULL,	'2020- PR39Enhancement cat 2- MRM Program updated',	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:29:42',	'2020-01-01 08:29:42'),
(10,	17,	1,	NULL,	'2020- PR39Enhancement cat 2- MRM Program updated',	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:29:42',	'2020-01-01 08:29:42'),
(11,	17,	1,	NULL,	'2020- PR39Enhancement cat 2- MRM Program updated',	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:29:43',	'2020-01-01 08:29:43'),
(12,	17,	1,	NULL,	'2020- PR39Enhancement cat 2- MRM Program updated',	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:29:43',	'2020-01-01 08:29:43'),
(13,	17,	1,	NULL,	'2020- PR39Enhancement cat 2- MRM Program updated',	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:29:43',	'2020-01-01 08:29:43'),
(14,	17,	1,	NULL,	'2020- PR39Enhancement cat 2- MRM Program updated',	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:29:43',	'2020-01-01 08:29:43'),
(15,	17,	1,	NULL,	'2020- PR39Enhancement cat 2- MRM Program updated',	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:29:43',	'2020-01-01 08:29:43'),
(16,	17,	1,	NULL,	'2020- PR39Enhancement cat 2- MRM Program updated',	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:29:43',	'2020-01-01 08:29:43'),
(17,	17,	1,	NULL,	'2020- PR39Enhancement cat 2- MRM Program updated',	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:29:43',	'2020-01-01 08:29:43'),
(18,	17,	1,	NULL,	'2020- PR39Enhancement cat 2- MRM Program updated',	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:29:43',	'2020-01-01 08:29:43'),
(19,	17,	1,	NULL,	'2020- PR39Enhancement cat 2- MRM Program updated',	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:29:44',	'2020-01-01 08:29:44'),
(20,	17,	1,	NULL,	'2020- PR39Enhancement cat 2- MRM Program updated',	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:29:44',	'2020-01-01 08:29:44'),
(21,	17,	1,	NULL,	'2020- PR39Enhancement cat 2- MRM Program updated',	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:29:44',	'2020-01-01 08:29:44'),
(22,	17,	1,	NULL,	'2020- PR39Enhancement cat 2- MRM Program updated',	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:29:44',	'2020-01-01 08:29:44'),
(23,	17,	1,	NULL,	'2020- PR39Enhancement cat 2- MRM Program updated',	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:29:44',	'2020-01-01 08:29:44'),
(24,	17,	1,	NULL,	'2020- PR39Enhancement cat 2- MRM Program updated',	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:29:44',	'2020-01-01 08:29:44'),
(25,	17,	1,	NULL,	'2020- PR39Enhancement cat 2- MRM Program updated',	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:29:45',	'2020-01-01 08:29:45'),
(26,	17,	1,	NULL,	'2020- PR39Enhancement cat 2- MRM Program updated',	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:29:45',	'2020-01-01 08:29:45'),
(27,	17,	1,	NULL,	'2020- PR39Enhancement cat 2- MRM Program updated',	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:29:45',	'2020-01-01 08:29:45'),
(28,	17,	1,	NULL,	'2020- PR39Enhancement cat 2- MRM Program updated',	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:29:45',	'2020-01-01 08:29:45'),
(29,	17,	1,	NULL,	'2020- PR39Enhancement cat 2- MRM Program updated',	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:29:45',	'2020-01-01 08:29:45'),
(30,	17,	1,	NULL,	'2020- PR39Enhancement cat 2- MRM Program updated',	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:29:45',	'2020-01-01 08:29:45'),
(31,	17,	1,	NULL,	'2020- PR39Enhancement cat 2- MRM Program updated',	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:29:46',	'2020-01-01 08:29:46'),
(32,	17,	1,	NULL,	'2020- PR39Enhancement cat 2- MRM Program updated',	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:29:46',	'2020-01-01 08:29:46'),
(33,	17,	1,	NULL,	'2020- PR39Enhancement cat 2- MRM Program updated',	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:29:46',	'2020-01-01 08:29:46'),
(34,	16,	70,	NULL,	'2020- PR40Enhancement cat 1- MRM Program created',	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:34:52',	'2020-01-01 08:34:52'),
(35,	17,	70,	NULL,	'2020- PR40Enhancement cat 1- MRM Program updated',	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:35:25',	'2020-01-01 08:35:25'),
(36,	17,	70,	NULL,	'2020- PR40Enhancement cat 1- MRM Program updated',	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:35:26',	'2020-01-01 08:35:26'),
(37,	17,	70,	NULL,	'2020- PR40Enhancement cat 1- MRM Program updated',	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:35:27',	'2020-01-01 08:35:27'),
(38,	17,	70,	NULL,	'2020- PR40Enhancement cat 1- MRM Program updated',	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:35:28',	'2020-01-01 08:35:28'),
(39,	17,	70,	NULL,	'2020- PR40Enhancement cat 1- MRM Program updated',	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:35:29',	'2020-01-01 08:35:29'),
(40,	17,	70,	NULL,	'2020- PR40Enhancement cat 1- MRM Program updated',	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:35:30',	'2020-01-01 08:35:30'),
(41,	17,	70,	NULL,	'2020- PR40Enhancement cat 1- MRM Program updated',	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:35:31',	'2020-01-01 08:35:31'),
(42,	17,	70,	NULL,	'2020- PR40Enhancement cat 1- MRM Program updated',	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:35:31',	'2020-01-01 08:35:31'),
(43,	17,	70,	NULL,	'2020- PR40Enhancement cat 1- MRM Program updated',	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:35:32',	'2020-01-01 08:35:32'),
(44,	17,	70,	NULL,	'2020- PR40Enhancement cat 1- MRM Program updated',	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:35:33',	'2020-01-01 08:35:33'),
(45,	17,	70,	NULL,	'2020- PR40Enhancement cat 1- MRM Program updated',	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:35:33',	'2020-01-01 08:35:33'),
(46,	17,	70,	NULL,	'2020- PR40Enhancement cat 1- MRM Program updated',	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:35:34',	'2020-01-01 08:35:34'),
(47,	17,	70,	NULL,	'2020- PR40Enhancement cat 1- MRM Program updated',	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:35:34',	'2020-01-01 08:35:34'),
(48,	17,	70,	NULL,	'2020- PR40Enhancement cat 1- MRM Program updated',	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:35:35',	'2020-01-01 08:35:35'),
(49,	17,	70,	NULL,	'2020- PR40Enhancement cat 1- MRM Program updated',	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:35:35',	'2020-01-01 08:35:35'),
(50,	17,	70,	NULL,	'2020- PR40Enhancement cat 1- MRM Program updated',	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:35:36',	'2020-01-01 08:35:36'),
(51,	17,	70,	NULL,	'2020- PR40Enhancement cat 1- MRM Program updated',	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:35:36',	'2020-01-01 08:35:36'),
(52,	17,	70,	NULL,	'2020- PR40Enhancement cat 1- MRM Program updated',	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:35:37',	'2020-01-01 08:35:37'),
(53,	17,	70,	NULL,	'2020- PR40Enhancement cat 1- MRM Program updated',	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:35:38',	'2020-01-01 08:35:38'),
(54,	17,	70,	NULL,	'2020- PR40Enhancement cat 1- MRM Program updated',	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:35:39',	'2020-01-01 08:35:39'),
(55,	17,	70,	NULL,	'2020- PR40Enhancement cat 1- MRM Program updated',	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:35:39',	'2020-01-01 08:35:39'),
(56,	17,	70,	NULL,	'2020- PR40Enhancement cat 1- MRM Program updated',	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:35:40',	'2020-01-01 08:35:40'),
(57,	1,	1,	NULL,	'Notification test- Document created',	33,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 08:38:40',	'2020-01-01 08:38:40'),
(58,	4,	61,	NULL,	'Notification test- Document Rejected review user',	33,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 09:37:26',	'2020-01-01 09:37:26'),
(59,	18,	70,	NULL,	'confirmation- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	17,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 09:49:28',	'2020-01-01 09:49:28'),
(60,	18,	70,	NULL,	'Test confirmstion- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	18,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 09:50:34',	'2020-01-01 09:50:34'),
(61,	19,	70,	NULL,	'Test confirmstion- MRM Plan updated',	NULL,	NULL,	NULL,	NULL,	18,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 09:51:21',	'2020-01-01 09:51:21'),
(62,	3,	61,	NULL,	'Notification test- Document reviewed',	33,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 10:03:23',	'2020-01-01 10:03:23'),
(63,	19,	70,	NULL,	'Test confirmstion- MRM Plan updated',	NULL,	NULL,	NULL,	NULL,	18,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 10:05:03',	'2020-01-01 10:05:03'),
(64,	20,	70,	NULL,	'Test confirmstion- MRM Plan published',	NULL,	NULL,	NULL,	NULL,	18,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 10:21:23',	'2020-01-01 10:21:23'),
(65,	5,	529,	NULL,	'Notification test- Document Rejected  by approving user',	33,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 10:23:42',	'2020-01-01 10:23:42'),
(66,	18,	1,	NULL,	'hyrtyh- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	19,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 10:28:01',	'2020-01-01 10:28:01'),
(67,	19,	1,	NULL,	'hyrtyh- MRM Plan updated',	NULL,	NULL,	NULL,	NULL,	19,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 10:28:33',	'2020-01-01 10:28:33'),
(68,	6,	529,	NULL,	'Notification test- Document approved by  approving user',	33,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 10:28:43',	'2020-01-01 10:28:43'),
(69,	19,	1,	NULL,	'hyrtyh- MRM Plan updated',	NULL,	NULL,	NULL,	NULL,	19,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 10:28:44',	'2020-01-01 10:28:44'),
(70,	18,	1,	NULL,	'fdf- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	20,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 10:29:24',	'2020-01-01 10:29:24'),
(71,	7,	1,	NULL,	'Notification test- Change request created',	NULL,	7,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 10:35:15',	'2020-01-01 10:35:15'),
(72,	20,	1,	NULL,	'fdf- MRM Plan published',	NULL,	NULL,	NULL,	NULL,	20,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 10:41:47',	'2020-01-01 10:41:47'),
(73,	10,	61,	NULL,	'Notification test- Change request Rejected review user',	NULL,	7,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 10:57:46',	'2020-01-01 10:57:46'),
(74,	21,	1,	NULL,	'fdf- MRM meeting created',	NULL,	NULL,	NULL,	NULL,	NULL,	15,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 11:02:16',	'2020-01-01 11:02:16'),
(75,	18,	1,	NULL,	'bbnbnb- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	21,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 11:03:37',	'2020-01-01 11:03:37'),
(76,	20,	1,	NULL,	'bbnbnb- MRM Plan published',	NULL,	NULL,	NULL,	NULL,	21,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 11:03:45',	'2020-01-01 11:03:45'),
(77,	9,	61,	NULL,	'Notification test- Change request reviewed',	NULL,	7,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 11:05:56',	'2020-01-01 11:05:56'),
(78,	21,	1,	NULL,	'bbnbnb- MRM meeting created',	NULL,	NULL,	NULL,	NULL,	NULL,	16,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 11:06:32',	'2020-01-01 11:06:32'),
(79,	21,	70,	NULL,	'Test confirmstion- MRM meeting created',	NULL,	NULL,	NULL,	NULL,	NULL,	17,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 11:12:23',	'2020-01-01 11:12:23'),
(80,	22,	70,	NULL,	'Test confirmstion- MRM meeting updated',	NULL,	NULL,	NULL,	NULL,	NULL,	17,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 11:14:28',	'2020-01-01 11:14:28'),
(81,	11,	529,	NULL,	'Notification test- Change request Rejected  by approving user',	NULL,	7,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 11:15:29',	'2020-01-01 11:15:29'),
(82,	12,	529,	NULL,	'Notification test- Change request approved by  approving user',	NULL,	7,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 11:20:25',	'2020-01-01 11:20:25'),
(83,	16,	70,	NULL,	'2020- PR41HSE- MRM Program created',	NULL,	NULL,	NULL,	41,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 11:21:22',	'2020-01-01 11:21:22'),
(84,	18,	70,	NULL,	'hse -confirmation popup testing- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	22,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 11:23:34',	'2020-01-01 11:23:34'),
(85,	20,	70,	NULL,	'hse -confirmation popup testing- MRM Plan published',	NULL,	NULL,	NULL,	NULL,	22,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 11:23:46',	'2020-01-01 11:23:46'),
(86,	27,	1,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 11:57:10',	'2020-01-01 11:57:10'),
(87,	27,	1,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 12:51:49',	'2020-01-01 12:51:49'),
(88,	27,	529,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 13:12:40',	'2020-01-01 13:12:40'),
(89,	16,	1,	NULL,	'2020- PR42test category- MRM Program created',	NULL,	NULL,	NULL,	42,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 13:15:48',	'2020-01-01 13:15:48'),
(90,	18,	1,	NULL,	'test- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	23,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 13:16:52',	'2020-01-01 13:16:52'),
(91,	20,	1,	NULL,	'test- MRM Plan published',	NULL,	NULL,	NULL,	NULL,	23,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 13:17:08',	'2020-01-01 13:17:08'),
(92,	21,	1,	NULL,	'test- MRM meeting created',	NULL,	NULL,	NULL,	NULL,	NULL,	18,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 13:17:49',	'2020-01-01 13:17:49'),
(93,	27,	8,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 13:19:32',	'2020-01-01 13:19:32'),
(94,	36,	1,	NULL,	'Information security policies- Policy updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	9,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 13:32:34',	'2020-01-01 13:32:34'),
(95,	36,	8,	NULL,	'Information security policies- Policy updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	9,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 13:35:13',	'2020-01-01 13:35:13'),
(96,	1,	1,	NULL,	'Incident management process is established and implemented to ensure that all breaches of information security, actual or suspected are reported and investigated- Document created',	34,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 13:39:58',	'2020-01-01 13:39:58'),
(97,	30,	1,	NULL,	'sample docs- Compliance register updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	6,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 14:35:35',	'2020-01-01 14:35:35'),
(98,	30,	1,	NULL,	'sample docs- Compliance register updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	6,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 14:36:43',	'2020-01-01 14:36:43'),
(99,	30,	1,	NULL,	'sample docs- Compliance register updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	6,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 14:39:11',	'2020-01-01 14:39:11'),
(100,	29,	1,	NULL,	'new compliance register document- Compliance register created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	7,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 14:44:47',	'2020-01-01 14:44:47'),
(101,	30,	8,	NULL,	'new compliance register document- Compliance register updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	7,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 15:03:46',	'2020-01-01 15:03:46'),
(102,	30,	8,	NULL,	'new compliance register document- Compliance register updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	7,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 15:07:03',	'2020-01-01 15:07:03'),
(103,	30,	8,	NULL,	'new compliance register document- Compliance register updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	7,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 15:07:30',	'2020-01-01 15:07:30'),
(104,	30,	1,	NULL,	'new compliance register document- Compliance register updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	7,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 15:07:51',	'2020-01-01 15:07:51'),
(105,	30,	1,	NULL,	'new compliance register document- Compliance register updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	7,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 15:08:42',	'2020-01-01 15:08:42'),
(106,	30,	1,	NULL,	'new compliance register document- Compliance register updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	7,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 15:09:04',	'2020-01-01 15:09:04'),
(107,	33,	1,	NULL,	'ISO certificate updated ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	20,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 15:21:59',	'2020-01-01 15:21:59'),
(108,	32,	1,	NULL,	'ISO certificate created ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	21,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 15:24:42',	'2020-01-01 15:24:42'),
(109,	13,	1,	NULL,	'BGS-II-0039- Context created',	NULL,	NULL,	24,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 15:35:49',	'2020-01-01 15:35:49'),
(110,	14,	1,	NULL,	'BGS-II-0040- Context updated',	NULL,	NULL,	24,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 15:43:14',	'2020-01-01 15:43:14'),
(111,	14,	1,	NULL,	'BGS-II-0041- Context updated',	NULL,	NULL,	24,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 15:43:40',	'2020-01-01 15:43:40'),
(112,	14,	1,	NULL,	'BGS-II-0042- Context updated',	NULL,	NULL,	24,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 15:44:21',	'2020-01-01 15:44:21'),
(113,	13,	1,	NULL,	'BGS-II-0043- Context created',	NULL,	NULL,	25,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-01 15:45:12',	'2020-01-01 15:45:12'),
(114,	14,	1,	NULL,	'BGS-II-0044- Context updated',	NULL,	NULL,	25,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 08:57:22',	'2020-01-02 08:57:22'),
(115,	14,	1,	NULL,	'BGS-II-0045- Context updated',	NULL,	NULL,	25,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 09:05:30',	'2020-01-02 09:05:30'),
(116,	15,	1,	NULL,	'BGS-II-0045- Context Reviewed',	NULL,	NULL,	25,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 09:08:49',	'2020-01-02 09:08:49'),
(117,	37,	1,	NULL,	'BGS-II-0045- Context closed',	NULL,	NULL,	25,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 09:09:18',	'2020-01-02 09:09:18'),
(118,	23,	1,	NULL,	'Action- MRM meeting action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	19,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 09:12:42',	'2020-01-02 09:12:42'),
(119,	38,	1,	NULL,	'As a result of the study of the dealers- Strategy plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	108,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 09:24:17',	'2020-01-02 09:24:17'),
(120,	24,	1,	NULL,	'Action- MRM meeting action updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	19,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 09:24:44',	'2020-01-02 09:24:44'),
(121,	23,	1,	NULL,	'ACtion 1- MRM meeting action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	20,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 09:26:07',	'2020-01-02 09:26:07'),
(122,	40,	1,	NULL,	'As a result of the study of the dealers- Strategy plan closed',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	108,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 09:30:57',	'2020-01-02 09:30:57'),
(123,	16,	101,	NULL,	'2020- PR43Enhancement cat 3- MRM Program created',	NULL,	NULL,	NULL,	43,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 09:33:51',	'2020-01-02 09:33:51'),
(124,	17,	101,	NULL,	'2020- PR43Enhancement cat 3- MRM Program updated',	NULL,	NULL,	NULL,	43,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 09:34:56',	'2020-01-02 09:34:56'),
(125,	17,	101,	NULL,	'2020- PR43Enhancement cat 3- MRM Program updated',	NULL,	NULL,	NULL,	43,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 09:34:58',	'2020-01-02 09:34:58'),
(126,	17,	101,	NULL,	'2020- PR43Enhancement cat 3- MRM Program updated',	NULL,	NULL,	NULL,	43,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 09:35:18',	'2020-01-02 09:35:18'),
(127,	17,	101,	NULL,	'2020- PR43Enhancement cat 3- MRM Program updated',	NULL,	NULL,	NULL,	43,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 09:35:20',	'2020-01-02 09:35:20'),
(128,	38,	1,	NULL,	'Network Readiness Index (NRI) is measured or converted to TII- Strategy plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	109,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 09:43:52',	'2020-01-02 09:43:52'),
(129,	40,	1,	NULL,	'Network Readiness Index (NRI) is measured or converted to TII- Strategy plan closed',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	109,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 09:44:53',	'2020-01-02 09:44:53'),
(130,	38,	1,	NULL,	'National Indicator: The Index of Electronic Services (Smart) (OSI)- Strategy plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	110,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 10:00:20',	'2020-01-02 10:00:20'),
(131,	44,	1,	NULL,	'Happiness meter- Satisfaction report updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	3,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 10:05:59',	'2020-01-02 10:05:59'),
(132,	43,	1,	NULL,	'PMO- Satisfaction report created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	6,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 10:21:15',	'2020-01-02 10:21:15'),
(133,	1,	1,	NULL,	'My notification document- Document created',	35,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 10:26:28',	'2020-01-02 10:26:28'),
(134,	2,	1,	NULL,	'My notification document- Document updated',	35,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 10:26:58',	'2020-01-02 10:26:58'),
(135,	2,	1,	NULL,	'My notification document- Document updated',	35,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 10:27:25',	'2020-01-02 10:27:25'),
(136,	18,	53,	NULL,	'Test content in mail notification- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	24,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 10:27:37',	'2020-01-02 10:27:37'),
(137,	2,	1,	NULL,	'My notification document- Document updated',	35,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 10:28:46',	'2020-01-02 10:28:46'),
(138,	2,	1,	NULL,	'My notification document- Document updated',	35,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 11:28:14',	'2020-01-02 11:28:14'),
(139,	2,	1,	NULL,	'My notification document- Document updated',	35,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 12:51:01',	'2020-01-02 12:51:01'),
(140,	46,	1,	NULL,	'Compentency added by User updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	76,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 12:54:11',	'2020-01-02 12:54:11'),
(141,	2,	1,	NULL,	'My notification document- Document updated',	35,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 12:54:59',	'2020-01-02 12:54:59'),
(142,	46,	1,	NULL,	'Compentency added by User updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 12:56:44',	'2020-01-02 12:56:44'),
(143,	40,	1,	NULL,	'National Indicator: The Index of Electronic Services (Smart) (OSI)- Strategy plan closed',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	110,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 12:56:54',	'2020-01-02 12:56:54'),
(144,	64,	1,	NULL,	'2020- PR19 Other Audit- Audit program updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	19,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 12:57:23',	'2020-01-02 12:57:23'),
(145,	2,	1,	NULL,	'My notification document- Document updated',	35,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 12:58:10',	'2020-01-02 12:58:10'),
(146,	2,	1,	NULL,	'My notification document- Document updated',	35,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 13:06:25',	'2020-01-02 13:06:25'),
(147,	47,	1,	NULL,	'activity log docs- KM internal document created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	36,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 13:24:26',	'2020-01-02 13:24:26'),
(148,	16,	243,	NULL,	'2020- PR44IMS review meeting- MRM Program created',	NULL,	NULL,	NULL,	44,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 13:24:29',	'2020-01-02 13:24:29'),
(149,	48,	1,	NULL,	'activity log docs- KM internal document updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	36,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 13:24:42',	'2020-01-02 13:24:42'),
(150,	17,	243,	NULL,	'2020- PR44IMS review meeting- MRM Program updated',	NULL,	NULL,	NULL,	44,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 13:30:48',	'2020-01-02 13:30:48'),
(151,	17,	243,	NULL,	'2020- PR44IMS review meeting- MRM Program updated',	NULL,	NULL,	NULL,	44,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 13:31:13',	'2020-01-02 13:31:13'),
(152,	18,	243,	NULL,	'Test- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	26,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 13:34:22',	'2020-01-02 13:34:22'),
(153,	20,	243,	NULL,	'Test- MRM Plan published',	NULL,	NULL,	NULL,	NULL,	26,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 13:34:31',	'2020-01-02 13:34:31'),
(154,	21,	243,	NULL,	'Test- MRM meeting created',	NULL,	NULL,	NULL,	NULL,	NULL,	22,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 13:36:56',	'2020-01-02 13:36:56'),
(155,	2,	1,	NULL,	'My notification document- Document updated',	35,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 13:38:16',	'2020-01-02 13:38:16'),
(156,	2,	1,	NULL,	'My notification document- Document updated',	35,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 13:41:48',	'2020-01-02 13:41:48'),
(157,	46,	1,	NULL,	'Update By User updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 13:47:10',	'2020-01-02 13:47:10'),
(158,	2,	1,	NULL,	'My notification document- Document updated',	35,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 13:54:47',	'2020-01-02 13:54:47'),
(159,	23,	243,	NULL,	'Action- MRM meeting action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	21,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 13:56:38',	'2020-01-02 13:56:38'),
(160,	25,	1,	NULL,	'Action-MRM meeting action status updated toOn Hold ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	21,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 14:05:45',	'2020-01-02 14:05:45'),
(161,	25,	1,	NULL,	'Action-MRM meeting action status updated toClosed ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	21,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 14:07:30',	'2020-01-02 14:07:30'),
(162,	1,	1,	NULL,	'compliance document- Document created',	37,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 14:30:00',	'2020-01-02 14:30:00'),
(163,	2,	1,	NULL,	'compliance document- Document updated',	37,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 14:30:18',	'2020-01-02 14:30:18'),
(164,	4,	1,	NULL,	'compliance document- Document Rejected review user',	37,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 14:30:38',	'2020-01-02 14:30:38'),
(165,	2,	1,	NULL,	'compliance document- Document updated',	37,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 14:33:56',	'2020-01-02 14:33:56'),
(166,	3,	1,	NULL,	'compliance document- Document reviewed',	37,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 14:41:42',	'2020-01-02 14:41:42'),
(167,	2,	1,	NULL,	'compliance document- Document updated',	37,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 14:50:04',	'2020-01-02 14:50:04'),
(168,	5,	53,	NULL,	'compliance document- Document Rejected  by approving user',	37,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 15:11:02',	'2020-01-02 15:11:02'),
(169,	2,	1,	NULL,	'compliance document- Document updated',	37,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 15:12:55',	'2020-01-02 15:12:55'),
(170,	30,	1,	NULL,	'new compliance register document- Compliance register updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	7,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 15:18:05',	'2020-01-02 15:18:05'),
(171,	29,	1,	NULL,	'Multiple section- Compliance register created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	8,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 15:19:19',	'2020-01-02 15:19:19'),
(172,	30,	1,	NULL,	'Multiple section- Compliance register updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	8,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 15:21:04',	'2020-01-02 15:21:04'),
(173,	30,	1,	NULL,	'Multiple section- Compliance register updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	8,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 15:21:24',	'2020-01-02 15:21:24'),
(174,	30,	1,	NULL,	'Multiple section- Compliance register updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	8,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 15:22:11',	'2020-01-02 15:22:11'),
(175,	30,	1,	NULL,	'Multiple section- Compliance register updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	8,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 15:23:35',	'2020-01-02 15:23:35'),
(176,	30,	1,	NULL,	'Multiple section- Compliance register updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	8,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 15:24:30',	'2020-01-02 15:24:30'),
(177,	30,	1,	NULL,	'new compliance register document- Compliance register updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	7,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 15:25:06',	'2020-01-02 15:25:06'),
(178,	33,	1,	NULL,	'ISO certificate updated ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	17,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 15:25:29',	'2020-01-02 15:25:29'),
(179,	33,	1,	NULL,	'ISO certificate updated ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	21,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 15:36:13',	'2020-01-02 15:36:13'),
(180,	46,	1,	NULL,	'Compentency added by User updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 15:46:49',	'2020-01-02 15:46:49'),
(181,	45,	1,	NULL,	'Created By- User created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	534,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 15:49:06',	'2020-01-02 15:49:06'),
(182,	30,	1,	NULL,	'Multiple section- Compliance register updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	8,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 15:49:35',	'2020-01-02 15:49:35'),
(183,	30,	1,	NULL,	'Multiple section- Compliance register updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	8,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 15:49:45',	'2020-01-02 15:49:45'),
(184,	33,	1,	NULL,	'ISO certificate updated ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	21,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 15:51:22',	'2020-01-02 15:51:22'),
(185,	46,	1,	NULL,	'Compentency added by User updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	361,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 08:54:06',	'2020-01-03 08:54:06'),
(186,	38,	1,	NULL,	'Intelligent e-transformation ratio for federal government services- Strategy plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	111,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 09:56:03',	'2020-01-03 09:56:03'),
(187,	63,	101,	NULL,	'2020- PR20 Legal Audit- Audit program created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	20,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 10:02:42',	'2020-01-03 10:02:42'),
(188,	51,	1,	NULL,	'BGS-R-0004- Context created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	33,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 10:48:08',	'2020-01-03 10:48:08'),
(189,	52,	1,	NULL,	'BGS-R-0004- Context updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	33,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 10:49:13',	'2020-01-03 10:49:13'),
(190,	53,	1,	NULL,	'BGS-R-0004- Assessment created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	33,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 10:50:08',	'2020-01-03 10:50:08'),
(191,	54,	1,	NULL,	'BGS-R-0004- Assessment updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	33,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 10:50:55',	'2020-01-03 10:50:55'),
(192,	53,	1,	NULL,	'BGS-R-0004- Assessment created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	33,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 10:51:26',	'2020-01-03 10:51:26'),
(193,	55,	1,	NULL,	'BGS-R-0004- Treatment created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	33,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 10:56:12',	'2020-01-03 10:56:12'),
(194,	57,	1,	NULL,	'BGS-R-0004- Risk treatment submitted for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	33,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 10:58:01',	'2020-01-03 10:58:01'),
(195,	59,	1,	NULL,	'BGS-R-0004- Risk treatment review rejected',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	33,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 10:58:21',	'2020-01-03 10:58:21'),
(196,	57,	1,	NULL,	'BGS-R-0004- Risk treatment submitted for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	33,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 10:58:34',	'2020-01-03 10:58:34'),
(197,	59,	1,	NULL,	'BGS-R-0004- Risk treatment review rejected',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	33,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 10:59:00',	'2020-01-03 10:59:00'),
(198,	57,	1,	NULL,	'BGS-R-0004- Risk treatment submitted for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	33,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 10:59:10',	'2020-01-03 10:59:10'),
(199,	58,	1,	NULL,	'BGS-R-0004- Risk treatment review approved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	33,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 10:59:16',	'2020-01-03 10:59:16'),
(200,	56,	1,	NULL,	'BGS-R-0004- Treatment updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	33,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 10:59:43',	'2020-01-03 10:59:43'),
(201,	60,	1,	NULL,	'BGS-R-0004- Risk treatment submitted for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	33,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 10:59:54',	'2020-01-03 10:59:54'),
(202,	62,	1,	NULL,	'BGS-R-0004- Risk treatment  rejected',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	33,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 11:00:37',	'2020-01-03 11:00:37'),
(203,	60,	1,	NULL,	'BGS-R-0004- Risk treatment submitted for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	33,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 11:00:49',	'2020-01-03 11:00:49'),
(204,	61,	1,	NULL,	'BGS-R-0004- Risk treatment  approved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	33,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 11:01:31',	'2020-01-03 11:01:31'),
(205,	49,	1,	NULL,	'External Audit finding testing user- KM External Documents created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	38,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 11:08:19',	'2020-01-03 11:08:19'),
(206,	50,	1,	NULL,	'External Audit finding testing user- KM External Documents updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	38,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 11:08:32',	'2020-01-03 11:08:32'),
(207,	63,	101,	NULL,	'2020- PR21 Enhancement cat 3- Audit program created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	21,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 11:37:19',	'2020-01-03 11:37:19'),
(208,	13,	1,	NULL,	'BGS-II-0046- Context created',	NULL,	NULL,	26,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 12:25:24',	'2020-01-03 12:25:24'),
(209,	63,	101,	NULL,	'2019- PR22 Technical Audit- Audit program created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	22,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 13:08:04',	'2020-01-03 13:08:04'),
(210,	24,	101,	NULL,	'action 0002- MRM meeting action updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	9,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 13:18:13',	'2020-01-03 13:18:13'),
(211,	25,	1,	NULL,	'action 0002-MRM meeting action status updated toOn Hold ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	9,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 13:24:08',	'2020-01-03 13:24:08'),
(212,	15,	53,	NULL,	'BGS-II-0046- Context Reviewed',	NULL,	NULL,	26,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 13:24:32',	'2020-01-03 13:24:32'),
(213,	23,	1,	NULL,	'activity log action- MRM meeting action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	22,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 13:25:58',	'2020-01-03 13:25:58'),
(214,	14,	1,	NULL,	'BGS-II-0047- Context updated',	NULL,	NULL,	26,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 13:27:35',	'2020-01-03 13:27:35'),
(215,	24,	1,	NULL,	'activity log action- MRM meeting action updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	22,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 13:27:40',	'2020-01-03 13:27:40'),
(216,	25,	1,	NULL,	'activity log action-MRM meeting action status updated toOn Hold ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	22,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 13:29:59',	'2020-01-03 13:29:59'),
(217,	37,	53,	NULL,	'BGS-II-0047- Context closed',	NULL,	NULL,	26,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 13:35:45',	'2020-01-03 13:35:45'),
(218,	25,	1,	NULL,	'activity log action-MRM meeting action status updated toCompleted ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	22,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 13:35:55',	'2020-01-03 13:35:55'),
(219,	38,	1,	NULL,	'Percentage of Emiratization- Strategy plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	112,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 13:44:40',	'2020-01-03 13:44:40'),
(220,	16,	1,	NULL,	'2020- PR452018 mrm- MRM Program created',	NULL,	NULL,	NULL,	45,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 13:56:48',	'2020-01-03 13:56:48'),
(221,	16,	1,	NULL,	'2020- PR462019 mrm- MRM Program created',	NULL,	NULL,	NULL,	46,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 13:58:13',	'2020-01-03 13:58:13'),
(222,	40,	61,	NULL,	'Percentage of Emiratization- Strategy plan closed',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	112,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 13:59:03',	'2020-01-03 13:59:03'),
(223,	1,	1,	NULL,	'Internal audit document- Document created',	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 14:21:09',	'2020-01-03 14:21:09'),
(224,	4,	53,	NULL,	'Internal audit document- Document Rejected review user',	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 14:33:33',	'2020-01-03 14:33:33'),
(225,	63,	101,	NULL,	'2020- PR23 Quality Audit- Audit program created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	23,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 14:33:58',	'2020-01-03 14:33:58'),
(226,	3,	53,	NULL,	'Internal audit document- Document reviewed',	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 14:36:16',	'2020-01-03 14:36:16'),
(227,	5,	53,	NULL,	'Internal audit document- Document Rejected  by approving user',	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 14:37:13',	'2020-01-03 14:37:13'),
(228,	6,	53,	NULL,	'Internal audit document- Document approved by  approving user',	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 15:41:20',	'2020-01-03 15:41:20'),
(229,	5,	1,	NULL,	'Internal audit document- Document Rejected  by approving user',	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 15:46:19',	'2020-01-03 15:46:19'),
(230,	6,	1,	NULL,	'Internal audit document- Document approved by  approving user',	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 15:47:15',	'2020-01-03 15:47:15'),
(231,	63,	101,	NULL,	'2019- PR24 IMS AUDIT- Audit program created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	24,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 16:07:30',	'2020-01-03 16:07:30'),
(232,	30,	1,	NULL,	'Multiple section- Compliance register updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	8,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 16:11:48',	'2020-01-03 16:11:48'),
(233,	36,	1,	NULL,	'IT Service Management system Policy- Policy updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	10,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 16:13:35',	'2020-01-03 16:13:35'),
(234,	63,	101,	NULL,	'2019- PR25 cat 2- Audit program created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	25,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 16:23:42',	'2020-01-03 16:23:42'),
(235,	85,	1,	NULL,	'2020- EA4 -- External audit created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	8,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 17:06:02',	'2020-01-03 17:06:02'),
(236,	77,	1,	NULL,	'Fiding by all -dept by super admin- Audit finding updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	25,	NULL,	NULL,	NULL,	'2020-01-03 17:22:29',	'2020-01-03 17:22:29'),
(237,	85,	1,	NULL,	'2020- EA5 -- External audit created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	9,	NULL,	NULL,	NULL,	NULL,	'2020-01-03 17:25:02',	'2020-01-03 17:25:02'),
(238,	16,	1,	NULL,	'2020- PR472019 mrm- MRM Program created',	NULL,	NULL,	NULL,	47,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 07:58:50',	'2020-01-04 07:58:50'),
(239,	28,	1,	NULL,	'VMV- updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 08:19:58',	'2020-01-04 08:19:58'),
(240,	65,	527,	NULL,	'test- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	69,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 08:47:53',	'2020-01-04 08:47:53'),
(241,	66,	527,	NULL,	'test1- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	69,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 08:48:08',	'2020-01-04 08:48:08'),
(242,	66,	527,	NULL,	'test1- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	69,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 08:48:31',	'2020-01-04 08:48:31'),
(243,	66,	527,	NULL,	'test1- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	69,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 08:49:20',	'2020-01-04 08:49:20'),
(244,	67,	527,	NULL,	'test1- Audit plan published',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	69,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 08:49:54',	'2020-01-04 08:49:54'),
(245,	28,	1,	NULL,	'VMV- updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 08:53:09',	'2020-01-04 08:53:09'),
(246,	28,	1,	NULL,	'VMV- updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 08:55:02',	'2020-01-04 08:55:02'),
(247,	28,	1,	NULL,	'VMV- updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 08:55:24',	'2020-01-04 08:55:24'),
(248,	28,	1,	NULL,	'VMV- updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 08:55:52',	'2020-01-04 08:55:52'),
(249,	66,	527,	NULL,	'test1- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	69,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 08:58:49',	'2020-01-04 08:58:49'),
(250,	66,	527,	NULL,	'test1- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	69,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 09:01:00',	'2020-01-04 09:01:00'),
(251,	36,	1,	NULL,	'Information security policies- Policy updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	9,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 09:01:23',	'2020-01-04 09:01:23'),
(252,	36,	1,	NULL,	'Information security policies- Policy updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	9,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 09:01:46',	'2020-01-04 09:01:46'),
(253,	29,	1,	NULL,	'sample document- Compliance register created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	9,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 09:15:18',	'2020-01-04 09:15:18'),
(254,	30,	1,	NULL,	'sample document- Compliance register updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	9,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 09:29:32',	'2020-01-04 09:29:32'),
(255,	30,	1,	NULL,	'sample document- Compliance register updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	9,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 09:29:51',	'2020-01-04 09:29:51'),
(256,	31,	1,	NULL,	'sample document- Compliance register reviewed',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	3,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 09:30:53',	'2020-01-04 09:30:53'),
(257,	31,	1,	NULL,	'sample document- Compliance register reviewed',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	3,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 09:33:26',	'2020-01-04 09:33:26'),
(258,	13,	1,	NULL,	'BGS-II-0048- Context created',	NULL,	NULL,	27,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 09:45:56',	'2020-01-04 09:45:56'),
(259,	76,	1,	NULL,	'jkjhk- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	26,	NULL,	NULL,	NULL,	'2020-01-04 09:55:16',	'2020-01-04 09:55:16'),
(260,	70,	477,	NULL,	'test1- Audit plan accepted',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	69,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 09:57:18',	'2020-01-04 09:57:18'),
(261,	68,	329,	NULL,	'test1audi- Audit  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	52,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 10:14:47',	'2020-01-04 10:14:47'),
(262,	76,	527,	NULL,	'Internal audit status- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	27,	NULL,	NULL,	NULL,	'2020-01-04 10:49:40',	'2020-01-04 10:49:40'),
(263,	76,	527,	NULL,	'internal audit- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	28,	NULL,	NULL,	NULL,	'2020-01-04 10:50:13',	'2020-01-04 10:50:13'),
(264,	71,	527,	NULL,	'#A 52test1audi- Audit report submit for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	52,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 10:50:46',	'2020-01-04 10:50:46'),
(265,	56,	1,	NULL,	'BGS-R-0004- Treatment updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	33,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 11:04:43',	'2020-01-04 11:04:43'),
(266,	56,	1,	NULL,	'BGS-R-0004- Treatment updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	33,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 11:04:58',	'2020-01-04 11:04:58'),
(267,	51,	1,	NULL,	'BGS-R-0005- Context created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	34,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 11:06:00',	'2020-01-04 11:06:00'),
(268,	53,	1,	NULL,	'BGS-R-0005- Assessment created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	34,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 11:06:32',	'2020-01-04 11:06:32'),
(269,	55,	1,	NULL,	'BGS-R-0005- Treatment created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	34,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 11:07:31',	'2020-01-04 11:07:31'),
(270,	57,	1,	NULL,	'BGS-R-0005- Risk treatment submitted for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	34,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 11:07:42',	'2020-01-04 11:07:42'),
(271,	58,	1,	NULL,	'BGS-R-0005- Risk treatment review approved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	34,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 11:07:52',	'2020-01-04 11:07:52'),
(272,	60,	1,	NULL,	'BGS-R-0005- Risk treatment submitted for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	34,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 11:08:49',	'2020-01-04 11:08:49'),
(273,	73,	70,	NULL,	'#A 52test1audi- Audit report submit for review rejected',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	52,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 11:09:36',	'2020-01-04 11:09:36'),
(274,	14,	1,	NULL,	'BGS-II-0049- Context updated',	NULL,	NULL,	27,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 11:11:11',	'2020-01-04 11:11:11'),
(275,	71,	527,	NULL,	'#A 52test1audi- Audit report submit for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	52,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 11:11:22',	'2020-01-04 11:11:22'),
(276,	15,	1,	NULL,	'BGS-II-0049- Context Reviewed',	NULL,	NULL,	27,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 11:11:48',	'2020-01-04 11:11:48'),
(277,	72,	70,	NULL,	'#A 52test1audi- Audit report submit for review accepted',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	52,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 11:14:35',	'2020-01-04 11:14:35'),
(278,	14,	1,	NULL,	'BGS-II-0050- Context updated',	NULL,	NULL,	27,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 11:15:30',	'2020-01-04 11:15:30'),
(279,	27,	1,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 11:16:08',	'2020-01-04 11:16:08'),
(280,	28,	1,	NULL,	'VMV- updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 11:16:46',	'2020-01-04 11:16:46'),
(281,	36,	1,	NULL,	'Information security policies- Policy updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	9,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 11:17:01',	'2020-01-04 11:17:01'),
(282,	30,	1,	NULL,	'sample document- Compliance register updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	9,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 11:17:19',	'2020-01-04 11:17:19'),
(283,	33,	1,	NULL,	'ISO certificate updated ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	21,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 11:17:39',	'2020-01-04 11:17:39'),
(284,	14,	1,	NULL,	'BGS-II-0051- Context updated',	NULL,	NULL,	27,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 11:18:20',	'2020-01-04 11:18:20'),
(285,	39,	1,	NULL,	'Intelligent e-transformation ratio for federal government services- Strategy plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	111,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 11:19:11',	'2020-01-04 11:19:11'),
(286,	74,	1,	NULL,	'internal audit- Audit finding responsible user added',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	28,	NULL,	NULL,	NULL,	'2020-01-04 11:19:18',	'2020-01-04 11:19:18'),
(287,	75,	1,	NULL,	'internal audit- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	28,	NULL,	NULL,	NULL,	'2020-01-04 11:19:18',	'2020-01-04 11:19:18'),
(288,	44,	1,	NULL,	'Happiness meter- Satisfaction report updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	3,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 11:19:53',	'2020-01-04 11:19:53'),
(289,	52,	1,	NULL,	'BGS-O-0002- Context updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	32,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 11:21:58',	'2020-01-04 11:21:58'),
(290,	61,	1,	NULL,	'BGS-R-0005- Risk treatment  approved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	34,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 11:22:20',	'2020-01-04 11:22:20'),
(291,	54,	1,	NULL,	'BGS-O-0002- Assessment updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	32,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 11:24:59',	'2020-01-04 11:24:59'),
(292,	56,	1,	NULL,	'BGS-O-0002- Treatment updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	32,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 11:25:08',	'2020-01-04 11:25:08'),
(293,	82,	1,	NULL,	'internal audit- Corrective action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	28,	NULL,	NULL,	NULL,	'2020-01-04 11:29:05',	'2020-01-04 11:29:05'),
(294,	7,	1,	NULL,	'Notification test- Change request created',	NULL,	10,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 11:53:35',	'2020-01-04 11:53:35'),
(295,	74,	1,	NULL,	'jkjhk- Audit finding responsible user added',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	26,	NULL,	NULL,	NULL,	'2020-01-04 12:01:44',	'2020-01-04 12:01:44'),
(296,	75,	1,	NULL,	'jkjhk- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	26,	NULL,	NULL,	NULL,	'2020-01-04 12:01:44',	'2020-01-04 12:01:44'),
(297,	74,	1,	NULL,	'Internal audit status- Audit finding responsible user added',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	27,	NULL,	NULL,	NULL,	'2020-01-04 12:02:38',	'2020-01-04 12:02:38'),
(298,	75,	1,	NULL,	'Internal audit status- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	27,	NULL,	NULL,	NULL,	'2020-01-04 12:02:38',	'2020-01-04 12:02:38'),
(299,	7,	1,	NULL,	'flow chart document- Change request created',	NULL,	11,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 12:35:51',	'2020-01-04 12:35:51'),
(300,	84,	1,	NULL,	'Internal audit status- Followup actions resolved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	27,	NULL,	NULL,	NULL,	'2020-01-04 12:43:45',	'2020-01-04 12:43:45'),
(301,	38,	1,	NULL,	'As a result of the study of the dealers- Strategy plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	113,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 13:06:10',	'2020-01-04 13:06:10'),
(302,	85,	527,	NULL,	'2020- EA6 -- External audit created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	10,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 13:38:07',	'2020-01-04 13:38:07'),
(303,	86,	527,	NULL,	'2020- EA6 -- External audit updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	10,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 13:40:39',	'2020-01-04 13:40:39'),
(304,	86,	527,	NULL,	'2020- EA6 -- External audit updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	10,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 13:40:42',	'2020-01-04 13:40:42'),
(305,	86,	527,	NULL,	'2020- EA6 -- External audit updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	10,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 13:41:35',	'2020-01-04 13:41:35'),
(306,	86,	527,	NULL,	'2020- EA6 -- External audit updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	10,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 13:42:19',	'2020-01-04 13:42:19'),
(307,	86,	527,	NULL,	'2020- EA6 -- External audit updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	10,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 13:42:21',	'2020-01-04 13:42:21'),
(308,	74,	1,	NULL,	'finding all department- Audit finding responsible user added',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	24,	NULL,	NULL,	NULL,	'2020-01-04 14:26:02',	'2020-01-04 14:26:02'),
(309,	75,	1,	NULL,	'finding all department- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	24,	NULL,	NULL,	NULL,	'2020-01-04 14:26:02',	'2020-01-04 14:26:02'),
(310,	84,	1,	NULL,	'finding all department- Followup actions resolved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	24,	NULL,	NULL,	NULL,	'2020-01-04 14:27:50',	'2020-01-04 14:27:50'),
(311,	85,	1,	NULL,	'2020- EA3 -- External audit created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	11,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 14:38:50',	'2020-01-04 14:38:50'),
(312,	76,	1,	NULL,	'EA Audit finding- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	29,	NULL,	NULL,	NULL,	'2020-01-04 14:39:21',	'2020-01-04 14:39:21'),
(313,	76,	1,	NULL,	'IA finding 2- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	30,	NULL,	NULL,	NULL,	'2020-01-04 14:40:56',	'2020-01-04 14:40:56'),
(314,	74,	1,	NULL,	'IA finding 2- Audit finding responsible user added',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	30,	NULL,	NULL,	NULL,	'2020-01-04 14:41:18',	'2020-01-04 14:41:18'),
(315,	75,	1,	NULL,	'IA finding 2- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	30,	NULL,	NULL,	NULL,	'2020-01-04 14:41:18',	'2020-01-04 14:41:18'),
(316,	84,	1,	NULL,	'IA finding 2- Followup actions resolved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	30,	NULL,	NULL,	NULL,	'2020-01-04 14:42:12',	'2020-01-04 14:42:12'),
(317,	85,	527,	NULL,	'2020- EA2 -- External audit created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	12,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 14:45:25',	'2020-01-04 14:45:25'),
(318,	86,	527,	NULL,	'2020- EA2 -- External audit updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	12,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 14:46:40',	'2020-01-04 14:46:40'),
(319,	76,	53,	NULL,	'test- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	31,	NULL,	NULL,	NULL,	'2020-01-04 14:48:19',	'2020-01-04 14:48:19'),
(320,	74,	8,	NULL,	'test- Audit finding responsible user added',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	31,	NULL,	NULL,	NULL,	'2020-01-04 14:49:35',	'2020-01-04 14:49:35'),
(321,	75,	8,	NULL,	'test- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	31,	NULL,	NULL,	NULL,	'2020-01-04 14:49:35',	'2020-01-04 14:49:35'),
(322,	84,	8,	NULL,	'test- Followup actions resolved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	31,	NULL,	NULL,	NULL,	'2020-01-04 14:51:07',	'2020-01-04 14:51:07'),
(323,	16,	8,	NULL,	'2020- PR48IMS review meeting- MRM Program created',	NULL,	NULL,	NULL,	48,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 15:28:01',	'2020-01-04 15:28:01'),
(324,	18,	1,	NULL,	'Test 04-01-2016- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	27,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 15:37:12',	'2020-01-04 15:37:12'),
(325,	20,	1,	NULL,	'Test 04-01-2016- MRM Plan published',	NULL,	NULL,	NULL,	NULL,	27,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 15:37:21',	'2020-01-04 15:37:21'),
(326,	21,	1,	NULL,	'Test 04-01-2016- MRM meeting created',	NULL,	NULL,	NULL,	NULL,	NULL,	23,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 15:38:40',	'2020-01-04 15:38:40'),
(327,	23,	1,	NULL,	'Action 1- MRM meeting action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	23,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 15:39:03',	'2020-01-04 15:39:03'),
(328,	17,	1,	NULL,	'2020- PR48IMS review meeting- MRM Program updated',	NULL,	NULL,	NULL,	48,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 15:39:48',	'2020-01-04 15:39:48'),
(329,	18,	1,	NULL,	'04-1-2019- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	28,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 15:40:19',	'2020-01-04 15:40:19'),
(330,	20,	1,	NULL,	'04-1-2019- MRM Plan published',	NULL,	NULL,	NULL,	NULL,	28,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 15:40:27',	'2020-01-04 15:40:27'),
(331,	16,	1,	NULL,	'2020- PR49Enhancement cat 1- MRM Program created',	NULL,	NULL,	NULL,	49,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 21:23:03',	'2020-01-04 21:23:03'),
(332,	18,	530,	NULL,	'new enhancement plan for test- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	29,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 21:25:56',	'2020-01-04 21:25:56'),
(333,	20,	530,	NULL,	'new enhancement plan for test- MRM Plan published',	NULL,	NULL,	NULL,	NULL,	29,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 21:26:06',	'2020-01-04 21:26:06'),
(334,	21,	530,	NULL,	'new enhancement plan for test- MRM meeting created',	NULL,	NULL,	NULL,	NULL,	NULL,	24,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 21:27:28',	'2020-01-04 21:27:28'),
(335,	23,	530,	NULL,	'new action- MRM meeting action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	24,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 21:30:41',	'2020-01-04 21:30:41'),
(336,	25,	530,	NULL,	'new action-MRM meeting action status updated toOn Hold ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	24,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 21:30:55',	'2020-01-04 21:30:55'),
(337,	25,	530,	NULL,	'new action-MRM meeting action status updated toCompleted ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	24,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 21:31:34',	'2020-01-04 21:31:34'),
(338,	23,	530,	NULL,	'enhancement action- MRM meeting action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	25,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-04 21:41:05',	'2020-01-04 21:41:05'),
(339,	7,	529,	NULL,	'general document- Change request created',	NULL,	12,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-05 13:04:42',	'2020-01-05 13:04:42'),
(340,	7,	1,	NULL,	'Internal audit document- Change request created',	NULL,	13,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 08:03:05',	'2020-01-06 08:03:05'),
(341,	13,	1,	NULL,	'BGS-II-0052- Context created',	NULL,	NULL,	28,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 08:16:44',	'2020-01-06 08:16:44'),
(342,	15,	1,	NULL,	'BGS-II-0052- Context Reviewed',	NULL,	NULL,	28,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 08:16:53',	'2020-01-06 08:16:53'),
(343,	16,	1,	NULL,	'2020- PR50HSE- MRM Program created',	NULL,	NULL,	NULL,	50,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 08:18:38',	'2020-01-06 08:18:38'),
(344,	18,	1,	NULL,	'Test- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	30,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 08:20:14',	'2020-01-06 08:20:14'),
(345,	20,	1,	NULL,	'Test- MRM Plan published',	NULL,	NULL,	NULL,	NULL,	30,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 08:23:44',	'2020-01-06 08:23:44'),
(346,	21,	1,	NULL,	'Test- MRM meeting created',	NULL,	NULL,	NULL,	NULL,	NULL,	25,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 08:24:20',	'2020-01-06 08:24:20'),
(347,	51,	1,	NULL,	'BGS-O-0003- Context created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	35,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 08:26:44',	'2020-01-06 08:26:44'),
(348,	16,	1,	NULL,	'2020- PR51OHSE meeting1- MRM Program created',	NULL,	NULL,	NULL,	51,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 08:27:40',	'2020-01-06 08:27:40'),
(349,	18,	1,	NULL,	'checking redirection- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	31,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 08:28:44',	'2020-01-06 08:28:44'),
(350,	20,	1,	NULL,	'checking redirection- MRM Plan published',	NULL,	NULL,	NULL,	NULL,	31,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 08:28:52',	'2020-01-06 08:28:52'),
(351,	21,	1,	NULL,	'checking redirection- MRM meeting created',	NULL,	NULL,	NULL,	NULL,	NULL,	26,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 08:29:06',	'2020-01-06 08:29:06'),
(352,	7,	1,	NULL,	'flow chart document- Change request created',	NULL,	14,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 08:35:21',	'2020-01-06 08:35:21'),
(353,	7,	1,	NULL,	'Internal audit document- Change request created',	NULL,	15,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 09:04:28',	'2020-01-06 09:04:28'),
(354,	13,	1,	NULL,	'BGS-EI-0053- Context created',	NULL,	NULL,	29,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 09:44:17',	'2020-01-06 09:44:17'),
(355,	15,	1,	NULL,	'BGS-EI-0053- Context Reviewed',	NULL,	NULL,	29,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 09:44:44',	'2020-01-06 09:44:44'),
(356,	31,	1,	NULL,	'Information management system- Compliance register reviewed',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 09:46:32',	'2020-01-06 09:46:32'),
(357,	51,	1,	NULL,	'BGS-O-0004- Context created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	36,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 09:49:12',	'2020-01-06 09:49:12'),
(358,	53,	1,	NULL,	'BGS-O-0004- Assessment created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	36,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 09:49:46',	'2020-01-06 09:49:46'),
(359,	55,	1,	NULL,	'BGS-O-0004- Treatment created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	36,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 09:50:43',	'2020-01-06 09:50:43'),
(360,	57,	1,	NULL,	'BGS-O-0004- Risk treatment submitted for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	36,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 09:51:00',	'2020-01-06 09:51:00'),
(361,	58,	1,	NULL,	'BGS-O-0004- Risk treatment review approved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	36,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 09:51:12',	'2020-01-06 09:51:12'),
(362,	63,	1,	NULL,	'2018- PR26 Technical Audit- Audit program created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	26,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 09:52:46',	'2020-01-06 09:52:46'),
(363,	67,	1,	NULL,	'checking condition- Audit plan published',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	70,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 09:56:14',	'2020-01-06 09:56:14'),
(364,	65,	1,	NULL,	'checking condition- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	70,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 09:56:14',	'2020-01-06 09:56:14'),
(365,	70,	383,	NULL,	'checking condition- Audit plan accepted',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	70,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 09:58:17',	'2020-01-06 09:58:17'),
(366,	68,	383,	NULL,	'checking condition- Audit  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	53,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 09:58:48',	'2020-01-06 09:58:48'),
(367,	76,	383,	NULL,	'checkin condition IA findinding- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	32,	NULL,	NULL,	NULL,	'2020-01-06 09:59:53',	'2020-01-06 09:59:53'),
(368,	76,	383,	NULL,	'checking 2- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	33,	NULL,	NULL,	NULL,	'2020-01-06 10:01:47',	'2020-01-06 10:01:47'),
(369,	71,	1,	NULL,	'#A 53checking condition- Audit report submit for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	53,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 10:06:05',	'2020-01-06 10:06:05'),
(370,	72,	80,	NULL,	'#A 53checking condition- Audit report submit for review accepted',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	53,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 10:09:57',	'2020-01-06 10:09:57'),
(371,	16,	80,	NULL,	'2018- PR522018 mrm- MRM Program created',	NULL,	NULL,	NULL,	52,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 10:11:28',	'2020-01-06 10:11:28'),
(372,	85,	70,	NULL,	'2020- EA2 -- External audit created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	13,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 10:16:43',	'2020-01-06 10:16:43'),
(373,	7,	1,	NULL,	'Notification test- Change request created',	NULL,	16,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 10:17:04',	'2020-01-06 10:17:04'),
(374,	86,	70,	NULL,	'2020- EA2 -- External audit updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	13,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 10:17:23',	'2020-01-06 10:17:23'),
(375,	76,	70,	NULL,	'salman issue- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	34,	NULL,	NULL,	NULL,	'2020-01-06 10:17:45',	'2020-01-06 10:17:45'),
(376,	18,	70,	NULL,	'ttesting mrm issues- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	32,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 10:19:02',	'2020-01-06 10:19:02'),
(377,	20,	70,	NULL,	'ttesting mrm issues- MRM Plan published',	NULL,	NULL,	NULL,	NULL,	32,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 10:19:11',	'2020-01-06 10:19:11'),
(378,	21,	70,	NULL,	'ttesting mrm issues- MRM meeting created',	NULL,	NULL,	NULL,	NULL,	NULL,	27,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 10:20:37',	'2020-01-06 10:20:37'),
(379,	16,	70,	NULL,	'2020- PR53HSE- MRM Program created',	NULL,	NULL,	NULL,	53,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 10:24:38',	'2020-01-06 10:24:38'),
(380,	18,	70,	NULL,	'HSE -1- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	33,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 10:26:45',	'2020-01-06 10:26:45'),
(381,	20,	70,	NULL,	'HSE -1- MRM Plan published',	NULL,	NULL,	NULL,	NULL,	33,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 10:26:53',	'2020-01-06 10:26:53'),
(382,	21,	70,	NULL,	'HSE -1- MRM meeting created',	NULL,	NULL,	NULL,	NULL,	NULL,	28,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 10:27:20',	'2020-01-06 10:27:20'),
(383,	56,	243,	NULL,	'BGS-O-0004- Treatment updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	36,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 10:57:51',	'2020-01-06 10:57:51'),
(384,	60,	243,	NULL,	'BGS-O-0004- Risk treatment submitted for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	36,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 10:58:16',	'2020-01-06 10:58:16'),
(385,	61,	1,	NULL,	'BGS-O-0004- Risk treatment  approved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	36,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 10:59:04',	'2020-01-06 10:59:04'),
(386,	16,	1,	NULL,	'2020- PR54mrm 2020- MRM Program created',	NULL,	NULL,	NULL,	54,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 11:04:12',	'2020-01-06 11:04:12'),
(387,	16,	1,	NULL,	'2020- PR55Enhancement cat 1- MRM Program created',	NULL,	NULL,	NULL,	55,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 11:06:10',	'2020-01-06 11:06:10'),
(388,	18,	1,	NULL,	'by jeeeeva- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	34,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 11:09:25',	'2020-01-06 11:09:25'),
(389,	20,	1,	NULL,	'by jeeeeva- MRM Plan published',	NULL,	NULL,	NULL,	NULL,	34,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 11:09:58',	'2020-01-06 11:09:58'),
(390,	21,	1,	NULL,	'by jeeeeva- MRM meeting created',	NULL,	NULL,	NULL,	NULL,	NULL,	29,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 11:11:04',	'2020-01-06 11:11:04'),
(391,	7,	1,	NULL,	'general document- Change request created',	NULL,	17,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 11:12:52',	'2020-01-06 11:12:52'),
(392,	7,	1,	NULL,	'Internal audit document- Change request created',	NULL,	18,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 12:00:47',	'2020-01-06 12:00:47'),
(393,	7,	1,	NULL,	'manual document- Change request created',	NULL,	19,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 12:54:01',	'2020-01-06 12:54:01'),
(394,	16,	70,	NULL,	'2020- PR562018 mrm- MRM Program created',	NULL,	NULL,	NULL,	56,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 12:54:12',	'2020-01-06 12:54:12'),
(395,	16,	70,	NULL,	'2020- PR57test- MRM Program created',	NULL,	NULL,	NULL,	57,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 13:00:15',	'2020-01-06 13:00:15'),
(396,	7,	1,	NULL,	'Notification test- Change request created',	NULL,	20,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 13:03:03',	'2020-01-06 13:03:03'),
(397,	64,	1,	NULL,	'2018- PR26 Technical Audit- Audit program updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	26,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 13:16:51',	'2020-01-06 13:16:51'),
(398,	64,	1,	NULL,	'2018- PR26 Technical Audit- Audit program updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	26,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 13:17:06',	'2020-01-06 13:17:06'),
(399,	64,	1,	NULL,	'2018- PR26 Technical Audit- Audit program updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	26,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 13:17:07',	'2020-01-06 13:17:07'),
(400,	64,	1,	NULL,	'2018- PR26 Technical Audit- Audit program updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	26,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 13:17:07',	'2020-01-06 13:17:07'),
(401,	64,	1,	NULL,	'2018- PR26 Technical Audit- Audit program updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	26,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 13:17:07',	'2020-01-06 13:17:07'),
(402,	64,	1,	NULL,	'2018- PR26 Technical Audit- Audit program updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	26,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 13:17:07',	'2020-01-06 13:17:07'),
(403,	64,	1,	NULL,	'2018- PR26 Technical Audit- Audit program updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	26,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 13:17:07',	'2020-01-06 13:17:07'),
(404,	64,	1,	NULL,	'2018- PR26 Technical Audit- Audit program updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	26,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 13:17:07',	'2020-01-06 13:17:07'),
(405,	64,	1,	NULL,	'2018- PR26 Technical Audit- Audit program updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	26,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 13:17:07',	'2020-01-06 13:17:07'),
(406,	64,	1,	NULL,	'2018- PR26 Technical Audit- Audit program updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	26,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 13:17:08',	'2020-01-06 13:17:08'),
(407,	64,	1,	NULL,	'2018- PR26 Technical Audit- Audit program updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	26,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 13:17:08',	'2020-01-06 13:17:08'),
(408,	64,	1,	NULL,	'2018- PR26 Technical Audit- Audit program updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	26,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 13:17:08',	'2020-01-06 13:17:08'),
(409,	64,	1,	NULL,	'2018- PR26 Technical Audit- Audit program updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	26,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 13:17:09',	'2020-01-06 13:17:09'),
(410,	7,	1,	NULL,	'Internal audit document- Change request created',	NULL,	21,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 13:18:17',	'2020-01-06 13:18:17'),
(411,	67,	1,	NULL,	'sawad issue- Audit plan published',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	71,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 13:22:21',	'2020-01-06 13:22:21'),
(412,	65,	1,	NULL,	'sawad issue- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	71,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 13:22:21',	'2020-01-06 13:22:21'),
(413,	66,	1,	NULL,	'sawad issue- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	71,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 13:22:55',	'2020-01-06 13:22:55'),
(414,	66,	1,	NULL,	'sawad issue- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	71,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 13:41:56',	'2020-01-06 13:41:56'),
(415,	67,	1,	NULL,	'sawad issue- Audit plan published',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	71,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 13:42:05',	'2020-01-06 13:42:05'),
(416,	66,	1,	NULL,	'sawad issue- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	71,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 13:42:24',	'2020-01-06 13:42:24'),
(417,	67,	1,	NULL,	'sawad issue- Audit plan published',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	71,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 13:42:42',	'2020-01-06 13:42:42'),
(418,	66,	1,	NULL,	'sawad issue- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	71,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 13:42:58',	'2020-01-06 13:42:58'),
(419,	67,	1,	NULL,	'sawad issue- Audit plan published',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	71,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 13:43:23',	'2020-01-06 13:43:23'),
(420,	66,	1,	NULL,	'sawad issue- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	71,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 13:43:23',	'2020-01-06 13:43:23'),
(421,	7,	1,	NULL,	'manual document- Change request created',	NULL,	22,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 13:50:44',	'2020-01-06 13:50:44'),
(422,	70,	383,	NULL,	'sawad issue- Audit plan accepted',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	71,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 13:53:35',	'2020-01-06 13:53:35'),
(423,	68,	1,	NULL,	'sawad issue- Audit  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	54,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 13:55:13',	'2020-01-06 13:55:13'),
(424,	7,	1,	NULL,	'Notification test- Change request created',	NULL,	23,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 13:57:09',	'2020-01-06 13:57:09'),
(425,	7,	1,	NULL,	'Notification test- Change request created',	NULL,	24,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 14:12:46',	'2020-01-06 14:12:46'),
(426,	7,	1,	NULL,	'Notification test- Change request created',	NULL,	25,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 14:34:31',	'2020-01-06 14:34:31'),
(427,	69,	1,	NULL,	'sawad issue- Audit updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	54,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 14:34:39',	'2020-01-06 14:34:39'),
(428,	76,	1,	NULL,	'activity finding- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	35,	NULL,	NULL,	NULL,	'2020-01-06 14:35:57',	'2020-01-06 14:35:57'),
(429,	7,	1,	NULL,	'sample work instructions- Change request created',	NULL,	26,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 14:44:30',	'2020-01-06 14:44:30'),
(430,	7,	1,	NULL,	'sample work instructions- Change request created',	NULL,	27,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 15:01:45',	'2020-01-06 15:01:45'),
(431,	74,	80,	NULL,	'checking 2- Audit finding responsible user added',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	33,	NULL,	NULL,	NULL,	'2020-01-06 15:54:11',	'2020-01-06 15:54:11'),
(432,	75,	80,	NULL,	'checking 2- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	33,	NULL,	NULL,	NULL,	'2020-01-06 15:54:11',	'2020-01-06 15:54:11'),
(433,	75,	80,	NULL,	'checking 2- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	33,	NULL,	NULL,	NULL,	'2020-01-06 15:54:25',	'2020-01-06 15:54:25'),
(434,	75,	80,	NULL,	'checking 2- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	33,	NULL,	NULL,	NULL,	'2020-01-06 15:54:54',	'2020-01-06 15:54:54'),
(435,	75,	80,	NULL,	'checking 2- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	33,	NULL,	NULL,	NULL,	'2020-01-06 15:55:29',	'2020-01-06 15:55:29'),
(436,	67,	101,	NULL,	'sawadddddd save& publish issue- Audit plan published',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	72,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 16:07:21',	'2020-01-06 16:07:21'),
(437,	65,	101,	NULL,	'sawadddddd save& publish issue- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	72,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-06 16:07:21',	'2020-01-06 16:07:21'),
(438,	78,	101,	NULL,	'checking 2- Root cause analysis created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	33,	NULL,	NULL,	NULL,	'2020-01-06 16:12:10',	'2020-01-06 16:12:10'),
(439,	75,	77,	NULL,	'checking 2- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	33,	NULL,	NULL,	NULL,	'2020-01-06 16:23:52',	'2020-01-06 16:23:52'),
(440,	74,	77,	NULL,	'checkin condition IA findinding- Audit finding responsible user added',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	32,	NULL,	NULL,	NULL,	'2020-01-06 16:31:55',	'2020-01-06 16:31:55'),
(441,	75,	77,	NULL,	'checkin condition IA findinding- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	32,	NULL,	NULL,	NULL,	'2020-01-06 16:31:55',	'2020-01-06 16:31:55'),
(442,	7,	1,	NULL,	'Notification test- Change request created',	NULL,	28,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 08:38:49',	'2020-01-07 08:38:49'),
(443,	63,	243,	NULL,	'2020- PR2 Cost Audit- Audit program created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	27,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 08:48:54',	'2020-01-07 08:48:54'),
(444,	67,	101,	NULL,	'2020-PR2-AP6 -test audit- Audit plan published',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	73,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 08:50:53',	'2020-01-07 08:50:53'),
(445,	65,	101,	NULL,	'2020-PR2-AP6 -- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	73,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 08:50:53',	'2020-01-07 08:50:53'),
(446,	68,	101,	NULL,	'#A55-test audit- Audit  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	55,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 08:51:06',	'2020-01-07 08:51:06'),
(447,	76,	101,	NULL,	'test finding- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	36,	NULL,	NULL,	NULL,	'2020-01-07 08:52:06',	'2020-01-07 08:52:06'),
(448,	76,	101,	NULL,	'checking task 15- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	37,	NULL,	NULL,	NULL,	'2020-01-07 08:52:35',	'2020-01-07 08:52:35'),
(449,	76,	101,	NULL,	'checking representative- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	38,	NULL,	NULL,	NULL,	'2020-01-07 08:52:57',	'2020-01-07 08:52:57'),
(450,	71,	101,	NULL,	'#A 55test audit- Audit report submit for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	55,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 08:53:15',	'2020-01-07 08:53:15'),
(451,	72,	39,	NULL,	'#A 55test audit- Audit report submit for review accepted',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	55,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 08:55:43',	'2020-01-07 08:55:43'),
(452,	74,	207,	NULL,	'checking representative- Audit finding responsible user added',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	38,	NULL,	NULL,	NULL,	'2020-01-07 08:58:31',	'2020-01-07 08:58:31'),
(453,	75,	207,	NULL,	'checking representative- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	38,	NULL,	NULL,	NULL,	'2020-01-07 08:58:31',	'2020-01-07 08:58:31'),
(454,	84,	207,	NULL,	'checking representative- Followup actions resolved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	38,	NULL,	NULL,	NULL,	'2020-01-07 08:59:09',	'2020-01-07 08:59:09'),
(455,	85,	437,	NULL,	'2020- EA3 -- External audit created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	14,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 09:16:17',	'2020-01-07 09:16:17'),
(456,	76,	101,	NULL,	'checking journey tab- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	'2020-01-07 09:18:15',	'2020-01-07 09:18:15'),
(457,	74,	101,	NULL,	'checking journey tab- Audit finding responsible user added',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	'2020-01-07 09:20:08',	'2020-01-07 09:20:08'),
(458,	75,	101,	NULL,	'checking journey tab- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	'2020-01-07 09:20:08',	'2020-01-07 09:20:08'),
(459,	84,	437,	NULL,	'checking journey tab- Followup actions resolved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	'2020-01-07 09:41:55',	'2020-01-07 09:41:55'),
(460,	76,	101,	NULL,	'recheck journey tab- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	'2020-01-07 09:46:38',	'2020-01-07 09:46:38'),
(461,	74,	101,	NULL,	'recheck journey tab- Audit finding responsible user added',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	'2020-01-07 09:47:18',	'2020-01-07 09:47:18'),
(462,	75,	101,	NULL,	'recheck journey tab- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	'2020-01-07 09:47:18',	'2020-01-07 09:47:18'),
(463,	82,	437,	NULL,	'recheck journey tab- Corrective action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	'2020-01-07 09:49:58',	'2020-01-07 09:49:58'),
(464,	84,	437,	NULL,	'recheck journey tab- Followup actions resolved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	'2020-01-07 09:51:02',	'2020-01-07 09:51:02'),
(465,	7,	1,	NULL,	'sample work instructions- Change request created',	NULL,	29,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 09:55:39',	'2020-01-07 09:55:39'),
(466,	76,	101,	NULL,	'journeyyyy- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	41,	NULL,	NULL,	NULL,	'2020-01-07 10:02:42',	'2020-01-07 10:02:42'),
(467,	74,	101,	NULL,	'journeyyyy- Audit finding responsible user added',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	41,	NULL,	NULL,	NULL,	'2020-01-07 10:03:15',	'2020-01-07 10:03:15'),
(468,	75,	101,	NULL,	'journeyyyy- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	41,	NULL,	NULL,	NULL,	'2020-01-07 10:03:15',	'2020-01-07 10:03:15'),
(469,	84,	437,	NULL,	'journeyyyy- Followup actions resolved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	41,	NULL,	NULL,	NULL,	'2020-01-07 10:05:18',	'2020-01-07 10:05:18'),
(470,	16,	101,	NULL,	'2013- PR58test- MRM Program created',	NULL,	NULL,	NULL,	58,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 10:09:31',	'2020-01-07 10:09:31'),
(471,	63,	101,	NULL,	'2013- PR1 cat 2- Audit program created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	28,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 10:13:52',	'2020-01-07 10:13:52'),
(472,	18,	253,	NULL,	'2013-PR58-MP35 -checking notification content- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	35,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 10:37:49',	'2020-01-07 10:37:49'),
(473,	18,	22,	NULL,	'2013-PR58-MP36 -Test  checking- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	36,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 10:58:30',	'2020-01-07 10:58:30'),
(474,	18,	65,	NULL,	'2013-PR58-MP37 -testingggggggggggg- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	37,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 11:02:43',	'2020-01-07 11:02:43'),
(475,	16,	65,	NULL,	'2020- PR59Enhancement cat 1- MRM Program created',	NULL,	NULL,	NULL,	59,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 11:09:02',	'2020-01-07 11:09:02'),
(476,	16,	345,	NULL,	'2020- PR60OHSE meeting1- MRM Program created',	NULL,	NULL,	NULL,	60,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 11:54:54',	'2020-01-07 11:54:54'),
(477,	16,	65,	NULL,	'2020- PR61test- MRM Program created',	NULL,	NULL,	NULL,	61,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 12:09:25',	'2020-01-07 12:09:25'),
(478,	18,	65,	NULL,	'2020-PR61-MP38 -Notificationnnnnnnnnnnnnnnnnnnnn- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	38,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 12:15:12',	'2020-01-07 12:15:12'),
(479,	18,	65,	NULL,	'2020-PR61-MP39 -revathyyyyy- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 12:21:04',	'2020-01-07 12:21:04'),
(480,	16,	65,	NULL,	'2020- PR622018 mrm- MRM Program created',	NULL,	NULL,	NULL,	62,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 12:22:36',	'2020-01-07 12:22:36'),
(481,	18,	65,	NULL,	'2020-PR62-MP40 -fahaddd- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 12:23:04',	'2020-01-07 12:23:04'),
(482,	18,	65,	NULL,	'2020-PR62-MP41 -eee- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	41,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 12:25:59',	'2020-01-07 12:25:59'),
(483,	16,	65,	NULL,	'2020- PR63mrm 2020- MRM Program created',	NULL,	NULL,	NULL,	63,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 12:31:30',	'2020-01-07 12:31:30'),
(484,	18,	65,	NULL,	'2020-PR63-MP42 -dsfdr- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	42,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 12:31:53',	'2020-01-07 12:31:53'),
(485,	16,	253,	NULL,	'2020- PR642018 mrm- MRM Program created',	NULL,	NULL,	NULL,	64,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 12:32:18',	'2020-01-07 12:32:18'),
(486,	18,	253,	NULL,	'2020-PR64-MP43 -f- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	43,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 12:32:48',	'2020-01-07 12:32:48'),
(487,	63,	65,	NULL,	'2020- PR3 notication category- Audit program created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	29,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 12:38:26',	'2020-01-07 12:38:26'),
(488,	65,	527,	NULL,	'notification plan- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	74,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 12:41:54',	'2020-01-07 12:41:54'),
(489,	65,	527,	NULL,	'notification plan- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	75,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 12:41:58',	'2020-01-07 12:41:58'),
(490,	65,	527,	NULL,	'2020-PR3-AP9 -notification plan- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	76,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 12:42:03',	'2020-01-07 12:42:03'),
(491,	66,	527,	NULL,	'2020-PR3-AP9 -notification plan- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	76,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 12:43:24',	'2020-01-07 12:43:24'),
(492,	65,	527,	NULL,	'2020-PR3-AP7 -notification issueee checkingg- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	77,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 12:44:45',	'2020-01-07 12:44:45'),
(493,	65,	527,	NULL,	'2020-PR3-AP8 -notification issueee checkingg- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	78,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 12:44:46',	'2020-01-07 12:44:46'),
(494,	65,	527,	NULL,	'2020-PR3-AP9 -notification issueee checkingg- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	79,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 12:44:46',	'2020-01-07 12:44:46'),
(495,	65,	527,	NULL,	'2020-PR3-AP10 -notification issueee checkingg- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	80,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 12:44:46',	'2020-01-07 12:44:46'),
(496,	65,	527,	NULL,	'2020-PR3-AP10 -notification issueee checkingg- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	81,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 12:44:46',	'2020-01-07 12:44:46'),
(497,	66,	527,	NULL,	'2020-PR3-AP7 -notification issueee checkingg- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	77,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 12:44:46',	'2020-01-07 12:44:46'),
(498,	66,	527,	NULL,	'2020-PR3-AP8 -notification issueee checkingg- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	78,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 12:44:46',	'2020-01-07 12:44:46'),
(499,	66,	527,	NULL,	'2020-PR3-AP10 -notification issueee checkingg- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	80,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 12:44:46',	'2020-01-07 12:44:46'),
(500,	67,	527,	NULL,	'2020-PR3-AP7 -notification issue checkingfgg- Audit plan published',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	82,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 12:48:09',	'2020-01-07 12:48:09'),
(501,	65,	527,	NULL,	'2020-PR3-AP7 -- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	82,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 12:48:09',	'2020-01-07 12:48:09'),
(502,	66,	527,	NULL,	'2020-PR3-AP7 -notification issue checkingfgg- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	82,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 12:49:08',	'2020-01-07 12:49:08'),
(503,	68,	527,	NULL,	'#A56-notification issue checkingfgg- Audit  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	56,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 13:01:56',	'2020-01-07 13:01:56'),
(504,	67,	527,	NULL,	'2020-PR3-AP8 -second testingg- Audit plan published',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	83,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 13:22:39',	'2020-01-07 13:22:39'),
(505,	65,	527,	NULL,	'2020-PR3-AP8 -- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	83,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 13:22:39',	'2020-01-07 13:22:39'),
(506,	70,	243,	NULL,	'second testingg- Audit plan accepted',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	83,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 13:22:54',	'2020-01-07 13:22:54'),
(507,	68,	527,	NULL,	'#A57-second testingg- Audit  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	57,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 13:36:38',	'2020-01-07 13:36:38'),
(508,	18,	65,	NULL,	'2020-PR63-MP44 -gg- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	44,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 13:52:05',	'2020-01-07 13:52:05'),
(509,	7,	1,	NULL,	'Internal audit document- Change request created',	NULL,	30,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 14:33:25',	'2020-01-07 14:33:25'),
(510,	18,	65,	NULL,	'2020-PR63-MP45 -ddd- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	45,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 14:35:47',	'2020-01-07 14:35:47'),
(511,	76,	527,	NULL,	'2020-IA57-AF6 -ffff- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	42,	NULL,	NULL,	NULL,	'2020-01-07 15:12:53',	'2020-01-07 15:12:53'),
(512,	76,	527,	NULL,	'2020-IA57-AF7 -finding 2- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	43,	NULL,	NULL,	NULL,	'2020-01-07 15:13:16',	'2020-01-07 15:13:16'),
(513,	71,	527,	NULL,	'#A 57second testingg- Audit report submit for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	57,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 15:15:41',	'2020-01-07 15:15:41'),
(514,	73,	53,	NULL,	'#A 57second testingg- Audit report submit for review rejected',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	57,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 15:20:21',	'2020-01-07 15:20:21'),
(515,	71,	527,	NULL,	'#A 57second testingg- Audit report submit for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	57,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 15:21:22',	'2020-01-07 15:21:22'),
(516,	72,	53,	NULL,	'#A 57second testingg- Audit report submit for review accepted',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	57,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 15:22:20',	'2020-01-07 15:22:20'),
(517,	10,	53,	NULL,	'Internal audit document- Change request Rejected review user',	NULL,	30,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 15:24:41',	'2020-01-07 15:24:41'),
(518,	89,	1,	NULL,	'Internal audit document- Change request  submit for review',	NULL,	30,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 15:26:01',	'2020-01-07 15:26:01'),
(519,	9,	53,	NULL,	'Internal audit document- Change request reviewed',	NULL,	30,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 15:27:38',	'2020-01-07 15:27:38'),
(520,	89,	53,	NULL,	'Internal audit document- Change request  submit for review',	NULL,	30,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 15:27:40',	'2020-01-07 15:27:40'),
(521,	11,	53,	NULL,	'Internal audit document- Change request Rejected  by approving user',	NULL,	30,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 15:34:25',	'2020-01-07 15:34:25'),
(522,	89,	1,	NULL,	'Internal audit document- Change request  submit for review',	NULL,	30,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 15:35:32',	'2020-01-07 15:35:32'),
(523,	74,	53,	NULL,	'2020-IA57-AF7 -finding 2- Audit finding responsible user added',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	43,	NULL,	NULL,	NULL,	'2020-01-07 15:36:42',	'2020-01-07 15:36:42'),
(524,	75,	53,	NULL,	'finding 2- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	43,	NULL,	NULL,	NULL,	'2020-01-07 15:36:42',	'2020-01-07 15:36:42'),
(525,	84,	53,	NULL,	'2020-IA57-AF7 -finding 2- Followup actions resolved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	43,	NULL,	NULL,	NULL,	'2020-01-07 15:37:04',	'2020-01-07 15:37:04'),
(526,	12,	53,	NULL,	'Internal audit document- Change request approved by  approving user',	NULL,	30,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 15:38:53',	'2020-01-07 15:38:53'),
(527,	11,	1,	NULL,	'Internal audit document- Change request Rejected  by approving user',	NULL,	30,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 15:40:21',	'2020-01-07 15:40:21'),
(528,	89,	1,	NULL,	'Internal audit document- Change request  submit for review',	NULL,	30,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 15:40:30',	'2020-01-07 15:40:30'),
(529,	84,	53,	NULL,	'2020-IA57-AF7 -finding 2- Followup actions resolved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	43,	NULL,	NULL,	NULL,	'2020-01-07 15:40:35',	'2020-01-07 15:40:35'),
(530,	12,	1,	NULL,	'Internal audit document- Change request approved by  approving user',	NULL,	30,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 15:40:44',	'2020-01-07 15:40:44'),
(531,	15,	53,	NULL,	'BGS-II-0042- Context Reviewed',	NULL,	NULL,	24,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 16:07:35',	'2020-01-07 16:07:35'),
(532,	14,	1,	NULL,	'BGS-II-0054- Context updated',	NULL,	NULL,	24,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 16:09:04',	'2020-01-07 16:09:04'),
(533,	37,	53,	NULL,	'BGS-II-0054- Context closed',	NULL,	NULL,	24,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 16:10:27',	'2020-01-07 16:10:27'),
(534,	38,	1,	NULL,	'Percentage of consumer disputes received by the Authority from the total subscriber base of telecommunications services in the country.- Strategy plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	114,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 16:12:26',	'2020-01-07 16:12:26'),
(535,	40,	53,	NULL,	'Percentage of consumer disputes received by the Authority from the total subscriber base of telecommunications services in the country.- Strategy plan closed',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	114,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 16:15:07',	'2020-01-07 16:15:07'),
(536,	85,	53,	NULL,	'2020- EA4 -- External audit created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	15,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 16:35:32',	'2020-01-07 16:35:32'),
(537,	16,	253,	NULL,	'2020- PR65HSE- MRM Program created',	NULL,	NULL,	NULL,	65,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 17:09:19',	'2020-01-07 17:09:19'),
(538,	18,	253,	NULL,	'2020-PR65-MP46 -bcvbv- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	46,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 17:09:44',	'2020-01-07 17:09:44'),
(539,	20,	253,	NULL,	'bcvbv- MRM Plan published',	NULL,	NULL,	NULL,	NULL,	46,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-07 17:10:29',	'2020-01-07 17:10:29'),
(540,	85,	361,	NULL,	'2020- EA5 -- External audit created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	16,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 08:29:59',	'2020-01-08 08:29:59'),
(541,	86,	361,	NULL,	'2020- EA5 -- External audit updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	16,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 08:31:26',	'2020-01-08 08:31:26'),
(542,	86,	361,	NULL,	'2020- EA5 -- External audit updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	16,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 08:31:28',	'2020-01-08 08:31:28'),
(543,	86,	387,	NULL,	'2020- EA5 -- External audit updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	16,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 08:36:29',	'2020-01-08 08:36:29'),
(544,	76,	467,	NULL,	'2020-EA5-AF7 -020 exteral audit finding- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	44,	NULL,	NULL,	NULL,	'2020-01-08 08:51:05',	'2020-01-08 08:51:05'),
(545,	76,	467,	NULL,	'2020-EA5-AF8 -2020finding 2- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	45,	NULL,	NULL,	NULL,	'2020-01-08 08:52:14',	'2020-01-08 08:52:14'),
(546,	76,	467,	NULL,	'2020-EA5-AF9 -external audit finding 44- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	46,	NULL,	NULL,	NULL,	'2020-01-08 08:53:09',	'2020-01-08 08:53:09'),
(547,	75,	1,	NULL,	'finding 2- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	43,	NULL,	NULL,	NULL,	'2020-01-08 09:01:23',	'2020-01-08 09:01:23'),
(548,	64,	467,	NULL,	'2019- PR8 Enhancement cat 2- Audit program updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	17,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 09:03:06',	'2020-01-08 09:03:06'),
(549,	63,	467,	NULL,	'2020- PR4 notication category- Audit program created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	30,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 09:06:30',	'2020-01-08 09:06:30'),
(550,	65,	101,	NULL,	'internal audit 8/1/2020- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	84,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 09:12:41',	'2020-01-08 09:12:41'),
(551,	65,	101,	NULL,	'2020-PR4-AP10 -internal audit 8/1/2020- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	85,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 09:12:49',	'2020-01-08 09:12:49'),
(552,	65,	101,	NULL,	'internal audit 8/1/2020- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	86,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 09:13:54',	'2020-01-08 09:13:54'),
(553,	66,	101,	NULL,	'2020-PR4-AP9 -internal audit 8/1/2020- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	86,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 09:15:18',	'2020-01-08 09:15:18'),
(554,	66,	101,	NULL,	'2020-PR4-AP9 -internal audit 8/1/2020- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	86,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 09:15:58',	'2020-01-08 09:15:58'),
(555,	67,	101,	NULL,	'internal audit 8/1/2020- Audit plan published',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	86,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 09:17:30',	'2020-01-08 09:17:30'),
(556,	70,	349,	NULL,	'2020-PR4-AP9 -internal audit 8/1/2020- Audit plan accepted',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	86,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 09:33:15',	'2020-01-08 09:33:15'),
(557,	68,	101,	NULL,	'#A58-internal audit 8/1/2020- Audit  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	58,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 09:35:56',	'2020-01-08 09:35:56'),
(558,	69,	101,	NULL,	'#A58-internal audit 8/1/2020- Audit updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	58,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 10:23:35',	'2020-01-08 10:23:35'),
(559,	76,	101,	NULL,	'2020-IA58-AF8 -2020internal audit finding- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	47,	NULL,	NULL,	NULL,	'2020-01-08 10:30:41',	'2020-01-08 10:30:41'),
(560,	76,	101,	NULL,	'2020-IA58-AF9 -2020 feb internal audit finding8/01/2020- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	48,	NULL,	NULL,	NULL,	'2020-01-08 10:34:01',	'2020-01-08 10:34:01'),
(561,	71,	101,	NULL,	'#A 58internal audit 8/1/2020- Audit report submit for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	58,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 10:40:41',	'2020-01-08 10:40:41'),
(562,	72,	525,	NULL,	'#A 58internal audit 8/1/2020- Audit report submit for review accepted',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	58,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 10:44:50',	'2020-01-08 10:44:50'),
(563,	74,	525,	NULL,	'2020-IA58-AF9 -2020 feb internal audit finding8/01/2020- Audit finding responsible user added',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	48,	NULL,	NULL,	NULL,	'2020-01-08 10:55:30',	'2020-01-08 10:55:30'),
(564,	75,	525,	NULL,	'2020 feb internal audit finding8/01/2020- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	48,	NULL,	NULL,	NULL,	'2020-01-08 10:55:30',	'2020-01-08 10:55:30'),
(565,	75,	525,	NULL,	'finding saif- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	8,	NULL,	NULL,	NULL,	'2020-01-08 10:56:56',	'2020-01-08 10:56:56'),
(566,	74,	525,	NULL,	'2020-IA57-AF6 -ffff- Audit finding responsible user added',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	42,	NULL,	NULL,	NULL,	'2020-01-08 10:57:40',	'2020-01-08 10:57:40'),
(567,	75,	525,	NULL,	'ffff- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	42,	NULL,	NULL,	NULL,	'2020-01-08 10:57:40',	'2020-01-08 10:57:40'),
(568,	64,	525,	NULL,	'2020- PR4 notication category- Audit program updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	30,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 11:01:31',	'2020-01-08 11:01:31'),
(569,	78,	243,	NULL,	'2020-IA58-AF9 -2020 feb internal audit finding8/01/2020- Root cause analysis created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	48,	NULL,	NULL,	NULL,	'2020-01-08 11:18:45',	'2020-01-08 11:18:45'),
(570,	79,	243,	NULL,	'2020-IA58-AF9 -2020 feb internal audit finding8/01/2020- Root cause analysis  updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	48,	NULL,	NULL,	NULL,	'2020-01-08 11:18:59',	'2020-01-08 11:18:59'),
(571,	80,	243,	NULL,	'2020-IA58-AF9 -2020 feb internal audit finding8/01/2020- Impact  analysis  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	48,	NULL,	NULL,	NULL,	'2020-01-08 11:19:29',	'2020-01-08 11:19:29'),
(572,	81,	243,	NULL,	'2020-IA58-AF9 -2020 feb internal audit finding8/01/2020- Impact  analysis  updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	48,	NULL,	NULL,	NULL,	'2020-01-08 11:19:47',	'2020-01-08 11:19:47'),
(573,	82,	243,	NULL,	'2020-IA58-AF9 -2020 feb internal audit finding8/01/2020- Corrective action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	48,	NULL,	NULL,	NULL,	'2020-01-08 11:20:51',	'2020-01-08 11:20:51'),
(574,	83,	243,	NULL,	'2020-IA58-AF9 -2020 feb internal audit finding8/01/2020- Corrective action updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	48,	NULL,	NULL,	NULL,	'2020-01-08 11:21:09',	'2020-01-08 11:21:09'),
(575,	84,	243,	NULL,	'2020-IA58-AF9 -2020 feb internal audit finding8/01/2020- Followup actions resolved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	48,	NULL,	NULL,	NULL,	'2020-01-08 11:22:01',	'2020-01-08 11:22:01'),
(576,	16,	243,	NULL,	'2020- PR66mrm 2020- MRM Program created',	NULL,	NULL,	NULL,	66,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 13:45:50',	'2020-01-08 13:45:50'),
(577,	18,	70,	NULL,	'2020-PR66-MP47 -mrm plan 8/1/2020- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	47,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 13:54:36',	'2020-01-08 13:54:36'),
(578,	20,	70,	NULL,	'mrm plan 8/1/2020- MRM Plan published',	NULL,	NULL,	NULL,	NULL,	47,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 13:57:24',	'2020-01-08 13:57:24'),
(579,	18,	70,	NULL,	'2020-PR66-MP48 -bb- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	48,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 14:12:36',	'2020-01-08 14:12:36'),
(580,	20,	70,	NULL,	'bb- MRM Plan published',	NULL,	NULL,	NULL,	NULL,	48,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 14:12:44',	'2020-01-08 14:12:44'),
(581,	21,	1,	NULL,	'2020-M30 -bb- MRM meeting created',	NULL,	NULL,	NULL,	NULL,	NULL,	30,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 14:13:57',	'2020-01-08 14:13:57'),
(582,	16,	70,	NULL,	'2020- PR67IMS review meeting- MRM Program created',	NULL,	NULL,	NULL,	67,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 14:16:35',	'2020-01-08 14:16:35'),
(583,	18,	243,	NULL,	'2020-PR67-MP49 -test81/2020- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	49,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 14:18:11',	'2020-01-08 14:18:11'),
(584,	20,	243,	NULL,	'test81/2020- MRM Plan published',	NULL,	NULL,	NULL,	NULL,	49,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 14:18:21',	'2020-01-08 14:18:21'),
(585,	21,	243,	NULL,	'2020-M31 -test81/2020- MRM meeting created',	NULL,	NULL,	NULL,	NULL,	NULL,	31,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 14:19:01',	'2020-01-08 14:19:01'),
(586,	22,	243,	NULL,	'2020-M31 -test81/2020- MRM meeting updated',	NULL,	NULL,	NULL,	NULL,	NULL,	31,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 14:19:15',	'2020-01-08 14:19:15'),
(587,	16,	243,	NULL,	'2020- PR682/8/2020- MRM Program created',	NULL,	NULL,	NULL,	68,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 14:33:08',	'2020-01-08 14:33:08'),
(588,	18,	65,	NULL,	'2020-PR68-MP50 -plan listing issue- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	50,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 15:12:04',	'2020-01-08 15:12:04'),
(589,	18,	65,	NULL,	'2020-PR68-MP51 -recheckinggggg- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	51,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 15:19:33',	'2020-01-08 15:19:33'),
(590,	19,	65,	NULL,	'2020-PR68-MP51 -recheckinggggg- MRM Plan updated',	NULL,	NULL,	NULL,	NULL,	51,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 15:20:27',	'2020-01-08 15:20:27'),
(591,	20,	65,	NULL,	'recheckinggggg- MRM Plan published',	NULL,	NULL,	NULL,	NULL,	51,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 15:21:02',	'2020-01-08 15:21:02'),
(592,	20,	65,	NULL,	'plan listing issue- MRM Plan published',	NULL,	NULL,	NULL,	NULL,	50,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 15:30:49',	'2020-01-08 15:30:49'),
(593,	21,	1,	NULL,	'2020-M32 -recheckinggggg- MRM meeting created',	NULL,	NULL,	NULL,	NULL,	NULL,	32,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 15:33:37',	'2020-01-08 15:33:37'),
(594,	16,	80,	NULL,	'2020- PR692/8/2020- MRM Program created',	NULL,	NULL,	NULL,	69,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 15:33:50',	'2020-01-08 15:33:50'),
(595,	18,	65,	NULL,	'2020-PR69-MP52 -unable add  meeting rechecking- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	52,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 15:37:14',	'2020-01-08 15:37:14'),
(596,	20,	65,	NULL,	'unable add  meeting rechecking- MRM Plan published',	NULL,	NULL,	NULL,	NULL,	52,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 15:37:27',	'2020-01-08 15:37:27'),
(597,	19,	1,	NULL,	'2020-PR69-MP52 -unable add  meeting rechecking- MRM Plan updated',	NULL,	NULL,	NULL,	NULL,	52,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 15:38:44',	'2020-01-08 15:38:44'),
(598,	19,	1,	NULL,	'2020-PR68-MP51 -recheckinggggg- MRM Plan updated',	NULL,	NULL,	NULL,	NULL,	51,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 15:39:14',	'2020-01-08 15:39:14'),
(599,	19,	1,	NULL,	'2020-PR68-MP51 -recheckinggggg- MRM Plan updated',	NULL,	NULL,	NULL,	NULL,	51,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 15:39:49',	'2020-01-08 15:39:49'),
(600,	19,	1,	NULL,	'2020-PR68-MP51 -recheckinggggg- MRM Plan updated',	NULL,	NULL,	NULL,	NULL,	51,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 15:42:09',	'2020-01-08 15:42:09'),
(601,	19,	1,	NULL,	'2020-PR68-MP51 -recheckinggggg- MRM Plan updated',	NULL,	NULL,	NULL,	NULL,	51,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 15:42:34',	'2020-01-08 15:42:34'),
(602,	19,	1,	NULL,	'2020-PR68-MP51 -recheckinggggg- MRM Plan updated',	NULL,	NULL,	NULL,	NULL,	51,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 15:43:44',	'2020-01-08 15:43:44'),
(603,	19,	1,	NULL,	'2020-PR68-MP51 -recheckinggggg- MRM Plan updated',	NULL,	NULL,	NULL,	NULL,	51,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 15:44:22',	'2020-01-08 15:44:22'),
(604,	18,	65,	NULL,	'2020-PR69-MP53 -issue- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	53,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 15:45:21',	'2020-01-08 15:45:21'),
(605,	19,	65,	NULL,	'2020-PR69-MP53 -issuerettttttt- MRM Plan updated',	NULL,	NULL,	NULL,	NULL,	53,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 15:48:06',	'2020-01-08 15:48:06'),
(606,	22,	1,	NULL,	'2020-M32 -recheckinggggg    edittttttttttttttttt- MRM meeting updated',	NULL,	NULL,	NULL,	NULL,	NULL,	32,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 15:50:57',	'2020-01-08 15:50:57'),
(607,	22,	1,	NULL,	'2020-M32 -recheckinggggg    edittttttttttttttttt- MRM meeting updated',	NULL,	NULL,	NULL,	NULL,	NULL,	32,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 15:51:19',	'2020-01-08 15:51:19'),
(608,	21,	65,	NULL,	'2020-M33 -unable add  meeting rechecking- MRM meeting created',	NULL,	NULL,	NULL,	NULL,	NULL,	33,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 16:25:23',	'2020-01-08 16:25:23'),
(609,	23,	1,	NULL,	'2020-A-26- Add action- MRM meeting action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	26,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 16:26:27',	'2020-01-08 16:26:27'),
(610,	25,	1,	NULL,	'Add action-MRM meeting action status updated toOn Hold ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	26,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 16:26:55',	'2020-01-08 16:26:55'),
(611,	63,	1,	NULL,	'2020- PR5 Enhancement cat 1- Audit program created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	31,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 16:36:12',	'2020-01-08 16:36:12'),
(612,	67,	101,	NULL,	'2020-PR4-AP10 -test title- Audit plan published',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	87,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 17:03:45',	'2020-01-08 17:03:45'),
(613,	65,	101,	NULL,	'2020-PR4-AP10 -- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	87,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 17:03:45',	'2020-01-08 17:03:45'),
(614,	70,	70,	NULL,	'2020-PR4-AP10 -test title- Audit plan accepted',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	87,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 17:05:07',	'2020-01-08 17:05:07'),
(615,	66,	101,	NULL,	'2020-PR4-AP10 -test title- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	87,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 17:06:45',	'2020-01-08 17:06:45'),
(616,	68,	101,	NULL,	'#A59-test title- Audit  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	59,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 17:07:12',	'2020-01-08 17:07:12'),
(617,	69,	101,	NULL,	'#A59-test title- Audit updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	59,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 17:07:29',	'2020-01-08 17:07:29'),
(618,	63,	101,	NULL,	'2020- PR6 IMS AUDIT- Audit program created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	32,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 17:10:00',	'2020-01-08 17:10:00'),
(619,	67,	101,	NULL,	'2020-PR6-AP11 -testtt- Audit plan published',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	88,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 17:11:08',	'2020-01-08 17:11:08'),
(620,	65,	101,	NULL,	'2020-PR6-AP11 -- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	88,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 17:11:08',	'2020-01-08 17:11:08'),
(621,	67,	101,	NULL,	'2020-PR6-AP12 -title- Audit plan published',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	89,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 17:14:06',	'2020-01-08 17:14:06'),
(622,	65,	101,	NULL,	'2020-PR6-AP12 -- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	89,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 17:14:06',	'2020-01-08 17:14:06'),
(623,	67,	101,	NULL,	'2020-PR6-AP13 -title- Audit plan published',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	90,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 17:14:07',	'2020-01-08 17:14:07'),
(624,	65,	101,	NULL,	'2020-PR6-AP13 -- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	90,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 17:14:07',	'2020-01-08 17:14:07'),
(625,	67,	101,	NULL,	'2020-PR6-AP14 -title- Audit plan published',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	91,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 17:14:08',	'2020-01-08 17:14:08'),
(626,	65,	101,	NULL,	'2020-PR6-AP14 -- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	91,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 17:14:08',	'2020-01-08 17:14:08'),
(627,	67,	101,	NULL,	'2020-PR6-AP15 -title- Audit plan published',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	92,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 17:14:08',	'2020-01-08 17:14:08'),
(628,	65,	101,	NULL,	'2020-PR6-AP15 -- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	92,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 17:14:08',	'2020-01-08 17:14:08'),
(629,	70,	70,	NULL,	'2020-PR6-AP14 -title- Audit plan accepted',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	91,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 17:14:54',	'2020-01-08 17:14:54'),
(630,	66,	101,	NULL,	'2020-PR6-AP14 -title- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	91,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 17:15:18',	'2020-01-08 17:15:18'),
(631,	68,	101,	NULL,	'#A60-title- Audit  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	60,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 17:16:43',	'2020-01-08 17:16:43'),
(632,	63,	70,	NULL,	'2012- PR1 Financial Audit- Audit program created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	33,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-09 08:37:46',	'2020-01-09 08:37:46'),
(633,	67,	527,	NULL,	'2012-PR1-AP1 -checking rashed issue- Audit plan published',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	93,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-09 08:44:12',	'2020-01-09 08:44:12'),
(634,	65,	527,	NULL,	'2012-PR1-AP1 -- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	93,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-09 08:44:12',	'2020-01-09 08:44:12'),
(635,	66,	70,	NULL,	'2012-PR1-AP1 -checking rashed issue- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	93,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-09 08:45:51',	'2020-01-09 08:45:51'),
(636,	66,	70,	NULL,	'2012-PR1-AP1 -checking rashed issue- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	93,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-09 08:45:55',	'2020-01-09 08:45:55'),
(637,	65,	527,	NULL,	'2012-PR1-AP2 -- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	94,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-09 08:51:26',	'2020-01-09 08:51:26'),
(638,	66,	527,	NULL,	'2012-PR1-AP2 -Recheking rashed issue- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	94,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-09 08:52:26',	'2020-01-09 08:52:26'),
(639,	67,	527,	NULL,	'Recheking rashed issue- Audit plan published',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	94,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-09 08:52:44',	'2020-01-09 08:52:44'),
(640,	70,	22,	NULL,	'2012-PR1-AP2 -Recheking rashed issue- Audit plan accepted',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	94,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-09 08:53:22',	'2020-01-09 08:53:22'),
(641,	68,	527,	NULL,	'#A61-Recheking rashed issue- Audit  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	61,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-09 08:54:11',	'2020-01-09 08:54:11'),
(642,	76,	527,	NULL,	'2012-IA61-AF1 -- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	49,	NULL,	NULL,	NULL,	'2020-01-09 10:14:45',	'2020-01-09 10:14:45'),
(643,	77,	527,	NULL,	'2012-IA61-AF1 -- Audit finding updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	49,	NULL,	NULL,	NULL,	'2020-01-09 10:15:26',	'2020-01-09 10:15:26'),
(644,	63,	527,	NULL,	'2012- PR2 cat 2- Audit program created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	34,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-09 11:01:22',	'2020-01-09 11:01:22'),
(645,	65,	527,	NULL,	'testtttttt- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	95,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-09 11:01:40',	'2020-01-09 11:01:40'),
(646,	13,	1,	NULL,	'BGS-II-0055- Context created',	NULL,	NULL,	30,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-09 11:21:18',	'2020-01-09 11:21:18'),
(647,	13,	1,	NULL,	'BGS-EI-0056- Context created',	NULL,	NULL,	31,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-09 11:34:51',	'2020-01-09 11:34:51'),
(648,	7,	1,	NULL,	'Internal audit document- Change request created',	NULL,	31,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-09 11:51:13',	'2020-01-09 11:51:13'),
(649,	63,	22,	NULL,	'2010- PR1 notication category- Audit program created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	35,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-09 12:29:21',	'2020-01-09 12:29:21'),
(650,	64,	22,	NULL,	'2010- PR1 notication category- Audit program updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	35,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-09 12:33:22',	'2020-01-09 12:33:22'),
(651,	65,	22,	NULL,	'2010-PR1-AP1 -- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	96,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-09 12:36:26',	'2020-01-09 12:36:26'),
(652,	67,	22,	NULL,	'karin donetti plsn- Audit plan published',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	96,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-09 12:36:50',	'2020-01-09 12:36:50'),
(653,	67,	101,	NULL,	'2010-PR1-AP2 -saif soubb- Audit plan published',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	97,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-09 12:41:18',	'2020-01-09 12:41:18'),
(654,	65,	101,	NULL,	'2010-PR1-AP2 -- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	97,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-09 12:41:18',	'2020-01-09 12:41:18'),
(655,	29,	1,	NULL,	'New document for test- Compliance register created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	10,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-09 12:58:18',	'2020-01-09 12:58:18'),
(656,	7,	1,	NULL,	'Internal audit document- Change request created',	NULL,	32,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-09 13:40:53',	'2020-01-09 13:40:53'),
(657,	75,	1,	NULL,	'2020-IA-AF8 -2020internal audit finding- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	47,	NULL,	NULL,	NULL,	'2020-01-09 16:49:58',	'2020-01-09 16:49:58'),
(658,	45,	1,	NULL,	'Created By- User created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	535,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-10 08:55:57',	'2020-01-10 08:55:57'),
(659,	63,	1,	NULL,	'2022- PR1 Enhancement cat 1- Audit program created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	36,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-10 09:02:29',	'2020-01-10 09:02:29'),
(660,	64,	535,	NULL,	'2022- PR1 Enhancement cat 1- Audit program updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	36,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-10 09:06:54',	'2020-01-10 09:06:54'),
(661,	67,	535,	NULL,	'2022-PR1-AP1 -An ISO 9001 audit checklist is a useful tool to ensure that nothing is missed when reviewing process records in order to confirm requirements are met- Audit plan published',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	98,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-10 09:11:12',	'2020-01-10 09:11:12'),
(662,	65,	535,	NULL,	'2022-PR1-AP1 -- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	98,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-10 09:11:12',	'2020-01-10 09:11:12'),
(663,	66,	535,	NULL,	'2022-PR1-AP1 -An ISO 9001 audit checklist is a useful tool to ensure that nothing is missed when reviewing process records in order to confirm requirements are met- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	98,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-10 09:11:49',	'2020-01-10 09:11:49'),
(664,	66,	535,	NULL,	'2022-PR1-AP1 -An ISO 9001 audit checklist is a useful tool to ensure that nothing is missed when reviewing process records in order to confirm requirements are met- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	98,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-10 09:13:08',	'2020-01-10 09:13:08'),
(665,	70,	147,	NULL,	'2022-PR1-AP1 -An ISO 9001 audit checklist is a useful tool to ensure that nothing is missed when reviewing process records in order to confirm requirements are met- Audit plan accepted',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	98,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-10 09:18:15',	'2020-01-10 09:18:15'),
(666,	28,	1,	NULL,	'VMV- updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-10 10:35:51',	'2020-01-10 10:35:51'),
(667,	36,	1,	NULL,	'Information security policies- Policy updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	9,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-10 10:37:00',	'2020-01-10 10:37:00'),
(668,	30,	1,	NULL,	'New document for test- Compliance register updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	10,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-10 10:38:14',	'2020-01-10 10:38:14'),
(669,	31,	1,	NULL,	'HSE Management System Legal and other requirements - TRA Dubai- Compliance register reviewed',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-10 10:39:25',	'2020-01-10 10:39:25'),
(670,	68,	535,	NULL,	'#A62-An ISO 9001 audit checklist is a useful tool to ensure that nothing is missed when reviewing process records in order to confirm requirements are met- Audit  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	62,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-10 10:40:33',	'2020-01-10 10:40:33'),
(671,	69,	535,	NULL,	'#A62-An ISO 9001 audit checklist is a useful tool to ensure that nothing is missed when reviewing process records in order to confirm requirements are met- Audit updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	62,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-10 10:45:03',	'2020-01-10 10:45:03'),
(672,	76,	535,	NULL,	'2022-IA62-AF1 -Test 2020 finding- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	50,	NULL,	NULL,	NULL,	'2020-01-10 10:48:39',	'2020-01-10 10:48:39'),
(673,	76,	535,	NULL,	'2022-IA62-AF2 -- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	51,	NULL,	NULL,	NULL,	'2020-01-10 10:50:58',	'2020-01-10 10:50:58'),
(674,	15,	1,	NULL,	'BGS-EI-0056- Context Reviewed',	NULL,	NULL,	31,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-10 11:31:02',	'2020-01-10 11:31:02'),
(675,	14,	1,	NULL,	'BGS-EI-0057- Context updated',	NULL,	NULL,	31,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-10 11:35:03',	'2020-01-10 11:35:03'),
(676,	37,	1,	NULL,	'BGS-EI-0057- Context closed',	NULL,	NULL,	31,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-10 11:35:11',	'2020-01-10 11:35:11'),
(677,	39,	1,	NULL,	'As a result of the study of the dealers- Strategy plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	113,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-10 11:38:28',	'2020-01-10 11:38:28'),
(678,	87,	1,	NULL,	'As a result of the study of the dealers- Strategy plan action performed',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	113,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-10 11:39:23',	'2020-01-10 11:39:23'),
(679,	40,	1,	NULL,	'As a result of the study of the dealers- Strategy plan closed',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	113,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-10 11:39:36',	'2020-01-10 11:39:36'),
(680,	51,	1,	NULL,	'BGS-R-0006- Context created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	37,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-10 12:50:55',	'2020-01-10 12:50:55'),
(681,	53,	1,	NULL,	'BGS-R-0006- Assessment created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	37,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-10 12:52:00',	'2020-01-10 12:52:00'),
(682,	55,	1,	NULL,	'BGS-R-0006- Treatment created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	37,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-10 12:53:19',	'2020-01-10 12:53:19'),
(683,	57,	1,	NULL,	'BGS-R-0006- Risk treatment submitted for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	37,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-10 12:55:18',	'2020-01-10 12:55:18'),
(684,	58,	1,	NULL,	'BGS-R-0006- Risk treatment review approved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	37,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-10 12:55:25',	'2020-01-10 12:55:25'),
(685,	56,	1,	NULL,	'BGS-R-0006- Treatment updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	37,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-10 12:55:38',	'2020-01-10 12:55:38'),
(686,	60,	1,	NULL,	'BGS-R-0006- Risk treatment submitted for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	37,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-10 12:55:45',	'2020-01-10 12:55:45'),
(687,	61,	1,	NULL,	'BGS-R-0006- Risk treatment  approved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	37,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-10 13:03:47',	'2020-01-10 13:03:47'),
(688,	7,	1,	NULL,	'Internal audit document- Change request created',	NULL,	33,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-13 12:54:22',	'2020-01-13 12:54:22'),
(689,	8,	1,	NULL,	'Internal audit document- Change request updated',	NULL,	33,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-13 12:54:49',	'2020-01-13 12:54:49'),
(690,	10,	53,	NULL,	'Internal audit document- Change request Rejected review user',	NULL,	33,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-13 13:14:55',	'2020-01-13 13:14:55'),
(691,	89,	1,	NULL,	'Internal audit document- Change request  submit for review',	NULL,	33,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-13 13:18:05',	'2020-01-13 13:18:05'),
(692,	9,	53,	NULL,	'Internal audit document- Change request reviewed',	NULL,	33,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-13 13:50:35',	'2020-01-13 13:50:35'),
(693,	89,	53,	NULL,	'Internal audit document- Change request  submit for review',	NULL,	33,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-13 13:50:49',	'2020-01-13 13:50:49'),
(694,	12,	53,	NULL,	'Internal audit document- Change request approved by  approving user',	NULL,	33,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-13 13:53:00',	'2020-01-13 13:53:00'),
(695,	12,	1,	NULL,	'Internal audit document- Change request approved by  approving user',	NULL,	33,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-13 13:53:53',	'2020-01-13 13:53:53'),
(696,	90,	1,	NULL,	'2020-M17 -Test confirmstion- Meeting report published',	NULL,	NULL,	NULL,	NULL,	NULL,	17,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-13 15:31:20',	'2020-01-13 15:31:20'),
(697,	38,	1,	NULL,	'Percentage of consumer disputes received by the Authority from the total subscriber base of telecommunications services in the country.- Strategy plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	115,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-13 17:35:20',	'2020-01-13 17:35:20'),
(698,	40,	1,	NULL,	'Percentage of consumer disputes received by the Authority from the total subscriber base of telecommunications services in the country.- Strategy plan closed',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	115,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-13 17:36:55',	'2020-01-13 17:36:55'),
(699,	87,	1,	NULL,	'Intelligent e-transformation ratio for federal government services- Strategy plan action performed',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	111,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-13 17:38:39',	'2020-01-13 17:38:39'),
(700,	40,	1,	NULL,	'Intelligent e-transformation ratio for federal government services- Strategy plan closed',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	111,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-13 17:38:46',	'2020-01-13 17:38:46'),
(701,	51,	1,	NULL,	'BGS-R-0007- Context created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	38,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-13 17:42:20',	'2020-01-13 17:42:20'),
(702,	51,	1,	NULL,	'BGS-R-0007- Context created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-13 17:43:55',	'2020-01-13 17:43:55'),
(703,	53,	1,	NULL,	'BGS-R-0007- Assessment created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-13 17:44:46',	'2020-01-13 17:44:46'),
(704,	55,	1,	NULL,	'BGS-R-0007- Treatment created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-13 17:45:20',	'2020-01-13 17:45:20'),
(705,	57,	1,	NULL,	'BGS-R-0007- Risk treatment submitted for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-13 17:45:32',	'2020-01-13 17:45:32'),
(706,	59,	1,	NULL,	'BGS-R-0007- Risk treatment review rejected',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-13 17:48:28',	'2020-01-13 17:48:28'),
(707,	57,	1,	NULL,	'BGS-R-0007- Risk treatment submitted for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-13 17:49:07',	'2020-01-13 17:49:07'),
(708,	59,	1,	NULL,	'BGS-R-0007- Risk treatment review rejected',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-13 17:49:44',	'2020-01-13 17:49:44'),
(709,	57,	1,	NULL,	'BGS-R-0007- Risk treatment submitted for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-13 17:52:05',	'2020-01-13 17:52:05'),
(710,	58,	53,	NULL,	'BGS-R-0007- Risk treatment review approved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-13 17:54:36',	'2020-01-13 17:54:36'),
(711,	56,	1,	NULL,	'BGS-R-0007- Treatment updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-13 18:15:28',	'2020-01-13 18:15:28'),
(712,	60,	1,	NULL,	'BGS-R-0007- Risk treatment submitted for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-13 18:15:33',	'2020-01-13 18:15:33'),
(713,	62,	1,	NULL,	'BGS-R-0007- Risk treatment  rejected',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-13 18:16:36',	'2020-01-13 18:16:36'),
(714,	39,	1,	NULL,	'Percentage of Emiratization- Strategy plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	107,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-14 08:03:05',	'2020-01-14 08:03:05'),
(715,	40,	1,	NULL,	'Percentage of Emiratization- Strategy plan closed',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	107,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-14 08:03:23',	'2020-01-14 08:03:23'),
(716,	51,	1,	NULL,	'BGS-R-0008- Context created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-14 08:05:36',	'2020-01-14 08:05:36'),
(717,	53,	1,	NULL,	'BGS-R-0008- Assessment created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-14 08:30:12',	'2020-01-14 08:30:12'),
(718,	55,	1,	NULL,	'BGS-R-0008- Treatment created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-14 08:31:44',	'2020-01-14 08:31:44'),
(719,	57,	1,	NULL,	'BGS-R-0008- Risk treatment submitted for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-14 08:31:49',	'2020-01-14 08:31:49'),
(720,	58,	1,	NULL,	'BGS-R-0008- Risk treatment review approved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-14 08:31:54',	'2020-01-14 08:31:54'),
(721,	56,	1,	NULL,	'BGS-R-0008- Treatment updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-14 08:32:09',	'2020-01-14 08:32:09'),
(722,	60,	1,	NULL,	'BGS-R-0008- Risk treatment submitted for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-14 08:32:18',	'2020-01-14 08:32:18'),
(723,	62,	1,	NULL,	'BGS-R-0008- Risk treatment  rejected',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-14 08:43:36',	'2020-01-14 08:43:36'),
(724,	2,	1,	NULL,	'sample docs- Document updated',	29,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-14 11:04:39',	'2020-01-14 11:04:39'),
(725,	2,	1,	NULL,	'aaaa- Document updated',	31,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-14 11:06:59',	'2020-01-14 11:06:59'),
(726,	2,	1,	NULL,	'issue- Document updated',	28,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-14 11:08:56',	'2020-01-14 11:08:56'),
(727,	1,	1,	NULL,	'test16- Document created',	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-14 11:16:14',	'2020-01-14 11:16:14'),
(728,	2,	1,	NULL,	'test16- Document updated',	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-14 11:17:22',	'2020-01-14 11:17:22'),
(729,	2,	1,	NULL,	'test16- Document updated',	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-14 11:18:21',	'2020-01-14 11:18:21'),
(730,	2,	1,	NULL,	'test- Document updated',	32,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-14 12:35:30',	'2020-01-14 12:35:30'),
(731,	1,	1,	NULL,	'Record- Document created',	41,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-14 12:58:53',	'2020-01-14 12:58:53'),
(732,	4,	1,	NULL,	'Record- Document Rejected review user',	41,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-14 12:59:52',	'2020-01-14 12:59:52'),
(733,	88,	1,	NULL,	'Record- Document submit for review',	41,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-14 13:00:10',	'2020-01-14 13:00:10'),
(734,	4,	1,	NULL,	'Record- Document Rejected review user',	41,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-14 13:00:59',	'2020-01-14 13:00:59'),
(735,	2,	1,	NULL,	'Record- Document updated',	41,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-14 13:01:12',	'2020-01-14 13:01:12'),
(736,	88,	1,	NULL,	'Record- Document submit for review',	41,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-14 13:01:35',	'2020-01-14 13:01:35'),
(737,	3,	1,	NULL,	'Record- Document reviewed',	41,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-14 13:01:40',	'2020-01-14 13:01:40'),
(738,	88,	1,	NULL,	'Record- Document submit for review',	41,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-14 13:01:41',	'2020-01-14 13:01:41'),
(739,	5,	53,	NULL,	'Record- Document Rejected  by approving user',	41,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-14 13:06:19',	'2020-01-14 13:06:19'),
(740,	2,	1,	NULL,	'Record- Document updated',	41,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-14 13:08:23',	'2020-01-14 13:08:23'),
(741,	88,	1,	NULL,	'Record- Document submit for review',	41,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-14 13:09:44',	'2020-01-14 13:09:44'),
(742,	6,	53,	NULL,	'Record- Document approved by  approving user',	41,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-14 13:10:09',	'2020-01-14 13:10:09'),
(743,	5,	1,	NULL,	'Record- Document Rejected  by approving user',	41,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-14 13:10:32',	'2020-01-14 13:10:32'),
(744,	2,	1,	NULL,	'Record- Document updated',	41,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-14 13:11:13',	'2020-01-14 13:11:13'),
(745,	88,	1,	NULL,	'Record- Document submit for review',	41,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-14 13:11:31',	'2020-01-14 13:11:31'),
(746,	6,	1,	NULL,	'Record- Document approved by  approving user',	41,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-14 13:11:54',	'2020-01-14 13:11:54'),
(747,	1,	1,	NULL,	'excel doc- Document created',	42,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-14 13:46:57',	'2020-01-14 13:46:57'),
(748,	39,	1,	NULL,	'Happiness Meter- Strategy plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	106,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-14 14:24:26',	'2020-01-14 14:24:26'),
(749,	2,	1,	NULL,	'test- Document updated',	32,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-15 09:13:10',	'2020-01-15 09:13:10'),
(750,	64,	101,	NULL,	'2020- PR6 IMS AUDIT- Audit program updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	32,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-15 10:52:32',	'2020-01-15 10:52:32'),
(751,	63,	1,	NULL,	'2020- PR7 Quality Audit- Audit program created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	37,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-15 14:53:59',	'2020-01-15 14:53:59'),
(752,	46,	1,	NULL,	'Update By User updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	529,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-15 17:11:43',	'2020-01-15 17:11:43'),
(753,	46,	1,	NULL,	'Update By User updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-15 18:24:43',	'2020-01-15 18:24:43'),
(754,	46,	1,	NULL,	'Update By User updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	528,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-15 18:26:00',	'2020-01-15 18:26:00'),
(755,	46,	1,	NULL,	'Update By User updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	529,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 07:54:26',	'2020-01-16 07:54:26'),
(756,	46,	1,	NULL,	'Update By User updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	531,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 08:25:26',	'2020-01-16 08:25:26'),
(757,	51,	1,	NULL,	'BGS-R-0009- Context created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	41,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 08:32:47',	'2020-01-16 08:32:47'),
(758,	46,	1,	NULL,	'Update By User updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	101,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 08:39:00',	'2020-01-16 08:39:00'),
(759,	46,	1,	NULL,	'Update By User updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	531,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 08:56:16',	'2020-01-16 08:56:16'),
(760,	46,	1,	NULL,	'Update By User updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	531,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 08:57:55',	'2020-01-16 08:57:55'),
(761,	46,	1,	NULL,	'Update By User updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	531,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 08:58:50',	'2020-01-16 08:58:50'),
(762,	71,	1,	NULL,	'#A 56notification issue checkingfgg- Audit report submit for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	56,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 08:59:13',	'2020-01-16 08:59:13'),
(763,	45,	1,	NULL,	'Created By- User created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	536,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 09:02:25',	'2020-01-16 09:02:25'),
(764,	73,	53,	NULL,	'#A 56notification issue checkingfgg- Audit report submit for review rejected',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	56,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 09:02:30',	'2020-01-16 09:02:30'),
(765,	71,	1,	NULL,	'#A 56notification issue checkingfgg- Audit report submit for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	56,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 09:05:54',	'2020-01-16 09:05:54'),
(766,	63,	1,	NULL,	'2032- PR1 Cost Audit- Audit program created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	38,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 09:16:57',	'2020-01-16 09:16:57'),
(767,	65,	527,	NULL,	'2032-PR1-AP1 -testttttttttttt16- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	99,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 09:18:27',	'2020-01-16 09:18:27'),
(768,	67,	527,	NULL,	'2032-PR1-AP2 -testttttttttttt16- Audit plan published',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	100,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 09:18:36',	'2020-01-16 09:18:36'),
(769,	65,	527,	NULL,	'2032-PR1-AP2 -- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	100,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 09:18:36',	'2020-01-16 09:18:36'),
(770,	70,	70,	NULL,	'2032-PR1-AP2 -testttttttttttt16- Audit plan accepted',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	100,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 09:21:19',	'2020-01-16 09:21:19'),
(771,	68,	527,	NULL,	'#A63-testttttttttttt16- Audit  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	63,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 09:24:01',	'2020-01-16 09:24:01'),
(772,	76,	527,	NULL,	'2032-IA63-AF1 -16 jan- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	52,	NULL,	NULL,	NULL,	'2020-01-16 09:24:21',	'2020-01-16 09:24:21'),
(773,	71,	527,	NULL,	'#A 63testttttttttttt16- Audit report submit for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	63,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 09:25:29',	'2020-01-16 09:25:29'),
(774,	63,	1,	NULL,	'2035- PR1 Management Audit- Audit program created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 09:52:20',	'2020-01-16 09:52:20'),
(775,	67,	527,	NULL,	'2035-PR1-AP1 -jeevas plan by sawad- Audit plan published',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	101,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 10:00:29',	'2020-01-16 10:00:29'),
(776,	65,	527,	NULL,	'2035-PR1-AP1 -- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	101,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 10:00:29',	'2020-01-16 10:00:29'),
(777,	46,	1,	NULL,	'Update By User updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	329,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 10:12:12',	'2020-01-16 10:12:12'),
(778,	46,	1,	NULL,	'Update By User updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	329,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 10:12:43',	'2020-01-16 10:12:43'),
(779,	46,	1,	NULL,	'Update By User updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	329,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 10:13:12',	'2020-01-16 10:13:12'),
(780,	63,	1,	NULL,	'2027- PR1 Technical Audit- Audit program created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	41,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 10:16:00',	'2020-01-16 10:16:00'),
(781,	63,	1,	NULL,	'2036- PR1 Management Audit- Audit program created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	42,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 10:24:37',	'2020-01-16 10:24:37'),
(782,	64,	1,	NULL,	'2036- PR1 Management Audit- Audit program updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	42,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 10:25:26',	'2020-01-16 10:25:26'),
(783,	67,	527,	NULL,	'2036-PR1-AP1 -jeeva test plan notiification- Audit plan published',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	102,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 10:28:44',	'2020-01-16 10:28:44'),
(784,	65,	527,	NULL,	'2036-PR1-AP1 -- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	102,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 10:28:44',	'2020-01-16 10:28:44'),
(785,	70,	1,	NULL,	'2036-PR1-AP1 -jeeva test plan notiification- Audit plan accepted',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	102,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 10:30:31',	'2020-01-16 10:30:31'),
(786,	68,	527,	NULL,	'#A64-jeeva test plan notiification sawad- Audit  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	64,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 10:32:53',	'2020-01-16 10:32:53'),
(787,	76,	527,	NULL,	'2036-IA64-AF1 -new audit finding by jeeva (sawad)- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	53,	NULL,	NULL,	NULL,	'2020-01-16 10:33:40',	'2020-01-16 10:33:40'),
(788,	76,	527,	NULL,	'2036-IA64-AF2 -new audit fimnding 2 by jeeva (sawad)- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	54,	NULL,	NULL,	NULL,	'2020-01-16 10:34:05',	'2020-01-16 10:34:05'),
(789,	71,	527,	NULL,	'#A 64jeeva test plan notiification sawad- Audit report submit for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	64,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 10:34:50',	'2020-01-16 10:34:50'),
(790,	71,	1,	NULL,	'#A 64jeeva test plan notiification sawad- Audit report submit for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	64,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 10:42:11',	'2020-01-16 10:42:11'),
(791,	71,	527,	NULL,	'#A 64jeeva test plan notiification sawad- Audit report submit for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	64,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 11:09:46',	'2020-01-16 11:09:46'),
(792,	73,	1,	NULL,	'#A 56notification issue checkingfgg- Audit report submit for review rejected',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	56,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 11:11:47',	'2020-01-16 11:11:47'),
(793,	71,	1,	NULL,	'#A 56notification issue checkingfgg- Audit report submit for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	56,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 11:12:50',	'2020-01-16 11:12:50'),
(794,	31,	1,	NULL,	'HSE Management System Legal and other requirements - TRA Dubai- Compliance register reviewed',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 11:14:22',	'2020-01-16 11:14:22'),
(795,	14,	1,	NULL,	'BGS-EI-0058- Context updated',	NULL,	NULL,	29,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 11:16:04',	'2020-01-16 11:16:04'),
(796,	73,	1,	NULL,	'#A 56notification issue checkingfgg- Audit report submit for review rejected',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	56,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 11:16:24',	'2020-01-16 11:16:24'),
(797,	73,	1,	NULL,	'#A 64jeeva test plan notiification sawad- Audit report submit for review rejected',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	64,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 11:16:48',	'2020-01-16 11:16:48'),
(798,	37,	1,	NULL,	'BGS-EI-0058- Context closed',	NULL,	NULL,	29,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 11:17:34',	'2020-01-16 11:17:34'),
(799,	13,	1,	NULL,	'BGS-II-0059- Context created',	NULL,	NULL,	32,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 11:20:59',	'2020-01-16 11:20:59'),
(800,	14,	1,	NULL,	'BGS-II-0060- Context updated',	NULL,	NULL,	32,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 11:21:10',	'2020-01-16 11:21:10'),
(801,	15,	1,	NULL,	'BGS-II-0060- Context Reviewed',	NULL,	NULL,	32,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 11:21:19',	'2020-01-16 11:21:19'),
(802,	37,	1,	NULL,	'BGS-II-0060- Context closed',	NULL,	NULL,	32,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 11:21:34',	'2020-01-16 11:21:34'),
(803,	71,	1,	NULL,	'#A 64jeeva test plan notiification sawad- Audit report submit for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	64,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 11:21:51',	'2020-01-16 11:21:51'),
(804,	87,	1,	NULL,	'Future Spectrum Growth Index (Spectrem Rich)- Strategy plan action performed',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	102,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 11:22:50',	'2020-01-16 11:22:50'),
(805,	72,	1,	NULL,	'#A 64jeeva test plan notiification sawad- Audit report submit for review accepted',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	64,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 11:23:42',	'2020-01-16 11:23:42'),
(806,	39,	1,	NULL,	'Future Spectrum Growth Index (Spectrem Rich)- Strategy plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	102,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 11:23:43',	'2020-01-16 11:23:43'),
(807,	40,	1,	NULL,	'Future Spectrum Growth Index (Spectrem Rich)- Strategy plan closed',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	102,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 11:23:59',	'2020-01-16 11:23:59'),
(808,	44,	1,	NULL,	'Happiness meter- Satisfaction report updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	3,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 11:25:05',	'2020-01-16 11:25:05'),
(809,	51,	1,	NULL,	'BGS-O-0005- Context created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	42,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 11:28:15',	'2020-01-16 11:28:15'),
(810,	52,	1,	NULL,	'BGS-O-0005- Context updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	42,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 11:29:22',	'2020-01-16 11:29:22'),
(811,	53,	1,	NULL,	'BGS-O-0005- Assessment created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	42,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 11:31:30',	'2020-01-16 11:31:30'),
(812,	54,	1,	NULL,	'BGS-O-0005- Assessment updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	42,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 11:32:11',	'2020-01-16 11:32:11'),
(813,	55,	1,	NULL,	'BGS-O-0005- Treatment created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	42,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 11:32:49',	'2020-01-16 11:32:49'),
(814,	57,	1,	NULL,	'BGS-O-0005- Risk treatment submitted for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	42,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 11:34:22',	'2020-01-16 11:34:22'),
(815,	59,	1,	NULL,	'BGS-O-0005- Risk treatment review rejected',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	42,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 11:34:40',	'2020-01-16 11:34:40'),
(816,	57,	1,	NULL,	'BGS-O-0005- Risk treatment submitted for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	42,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 11:35:06',	'2020-01-16 11:35:06'),
(817,	58,	1,	NULL,	'BGS-O-0005- Risk treatment review approved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	42,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 11:35:16',	'2020-01-16 11:35:16'),
(818,	56,	1,	NULL,	'BGS-O-0005- Treatment updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	42,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 11:35:28',	'2020-01-16 11:35:28'),
(819,	60,	1,	NULL,	'BGS-O-0005- Risk treatment submitted for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	42,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 11:35:36',	'2020-01-16 11:35:36'),
(820,	62,	1,	NULL,	'BGS-O-0005- Risk treatment  rejected',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	42,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 11:35:54',	'2020-01-16 11:35:54'),
(821,	60,	1,	NULL,	'BGS-O-0005- Risk treatment submitted for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	42,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 11:35:59',	'2020-01-16 11:35:59'),
(822,	61,	1,	NULL,	'BGS-O-0005- Risk treatment  approved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	42,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 11:36:06',	'2020-01-16 11:36:06'),
(823,	46,	1,	NULL,	'Update By User updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	536,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 12:02:11',	'2020-01-16 12:02:11'),
(824,	46,	1,	NULL,	'Job description added  by User updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	536,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 12:06:25',	'2020-01-16 12:06:25'),
(825,	46,	1,	NULL,	'Roles and Responsibility added  by User updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	536,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 12:08:07',	'2020-01-16 12:08:07'),
(826,	46,	1,	NULL,	'KPI added by User updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	536,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 12:09:08',	'2020-01-16 12:09:08'),
(827,	46,	1,	NULL,	'Compentency added by User updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	536,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 12:09:30',	'2020-01-16 12:09:30'),
(828,	46,	1,	NULL,	'Reports added  by User updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	536,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 12:12:13',	'2020-01-16 12:12:13'),
(829,	46,	1,	NULL,	'Job description updated  by User updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	536,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 12:13:04',	'2020-01-16 12:13:04'),
(830,	1,	1,	NULL,	'Activity log test- Document created',	43,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 12:47:18',	'2020-01-16 12:47:18'),
(831,	2,	1,	NULL,	'Activity log test- Document updated',	43,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 12:47:49',	'2020-01-16 12:47:49'),
(832,	4,	1,	NULL,	'Activity log test- Document Rejected review user',	43,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 12:59:37',	'2020-01-16 12:59:37'),
(833,	88,	1,	NULL,	'Activity log test- Document submit for review',	43,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 13:01:19',	'2020-01-16 13:01:19'),
(834,	3,	1,	NULL,	'Activity log test- Document reviewed',	43,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 13:01:33',	'2020-01-16 13:01:33'),
(835,	88,	1,	NULL,	'Activity log test- Document submit for review',	43,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 13:01:34',	'2020-01-16 13:01:34'),
(836,	5,	1,	NULL,	'Activity log test- Document Rejected  by approving user',	43,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 13:01:56',	'2020-01-16 13:01:56'),
(837,	88,	1,	NULL,	'Activity log test- Document submit for review',	43,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 13:02:03',	'2020-01-16 13:02:03'),
(838,	5,	1,	NULL,	'Activity log test- Document Rejected  by approving user',	43,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 13:04:00',	'2020-01-16 13:04:00'),
(839,	88,	1,	NULL,	'Activity log test- Document submit for review',	43,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 13:04:10',	'2020-01-16 13:04:10'),
(840,	6,	1,	NULL,	'Activity log test- Document approved by  approving user',	43,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 13:04:23',	'2020-01-16 13:04:23'),
(841,	27,	1,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 13:15:33',	'2020-01-16 13:15:33'),
(842,	38,	531,	NULL,	'Customers\' level of e-services / smart (converted to government)- Strategy plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	116,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 13:44:33',	'2020-01-16 13:44:33'),
(843,	46,	1,	NULL,	'Update By User updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	536,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 14:55:24',	'2020-01-16 14:55:24'),
(844,	86,	1,	NULL,	'2020- EA4 -- External audit updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	15,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 08:20:58',	'2020-01-17 08:20:58'),
(845,	86,	1,	NULL,	'2020- EA3 -- External audit updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	14,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 08:21:30',	'2020-01-17 08:21:30'),
(846,	86,	1,	NULL,	'2020- EA4 -- External audit updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	15,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 08:21:42',	'2020-01-17 08:21:42'),
(847,	86,	1,	NULL,	'2020- EA2 -- External audit updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	13,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 08:21:54',	'2020-01-17 08:21:54'),
(848,	86,	1,	NULL,	'2020- EA2 -- External audit updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	13,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 08:25:54',	'2020-01-17 08:25:54'),
(849,	86,	1,	NULL,	'2020- EA2 -- External audit updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	13,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 08:26:07',	'2020-01-17 08:26:07'),
(850,	28,	1,	NULL,	'VMV- updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 08:47:36',	'2020-01-17 08:47:36'),
(851,	46,	1,	NULL,	'Update By User updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	536,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 08:50:54',	'2020-01-17 08:50:54'),
(852,	46,	1,	NULL,	'Update By User updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	536,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 08:51:17',	'2020-01-17 08:51:17'),
(853,	63,	1,	NULL,	'2020- PR8 Legal Audit- Audit program created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	43,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 09:04:54',	'2020-01-17 09:04:54'),
(854,	64,	1,	NULL,	'2020- PR8 Legal Audit- Audit program updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	43,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 09:06:47',	'2020-01-17 09:06:47'),
(855,	77,	1,	NULL,	'2019-IA43-AF8 -finding saif- Audit finding updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	8,	NULL,	NULL,	NULL,	'2020-01-17 09:08:01',	'2020-01-17 09:08:01'),
(856,	78,	1,	NULL,	'2019-IA-AF8 -finding saif- Root cause analysis created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	8,	NULL,	NULL,	NULL,	'2020-01-17 09:08:47',	'2020-01-17 09:08:47'),
(857,	65,	527,	NULL,	'2020-PR8-AP16 -abcd- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	103,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 09:09:44',	'2020-01-17 09:09:44'),
(858,	66,	527,	NULL,	'2020-PR8-AP16 -abcd- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	103,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 09:10:47',	'2020-01-17 09:10:47'),
(859,	66,	527,	NULL,	'2020-PR8-AP16 -abcd- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	103,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 09:10:50',	'2020-01-17 09:10:50'),
(860,	66,	527,	NULL,	'2020-PR8-AP16 -abcd- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	103,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 09:11:00',	'2020-01-17 09:11:00'),
(861,	66,	527,	NULL,	'2020-PR8-AP16 -abcd- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	103,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 09:11:16',	'2020-01-17 09:11:16'),
(862,	66,	527,	NULL,	'2020-PR8-AP16 -abcd- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	103,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 09:12:11',	'2020-01-17 09:12:11'),
(863,	65,	527,	NULL,	'2020-PR8-AP16 -basith- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	104,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 09:14:18',	'2020-01-17 09:14:18'),
(864,	66,	527,	NULL,	'2020-PR8-AP16 -basith- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	104,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 09:15:51',	'2020-01-17 09:15:51'),
(865,	65,	527,	NULL,	'2020-PR8-AP16 -dsh- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	105,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 09:17:02',	'2020-01-17 09:17:02'),
(866,	66,	527,	NULL,	'2020-PR8-AP16 -dsh- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	105,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 09:18:09',	'2020-01-17 09:18:09'),
(867,	67,	527,	NULL,	'2020-PR8-AP13 -ASdasergs- Audit plan published',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	106,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 09:19:45',	'2020-01-17 09:19:45'),
(868,	65,	527,	NULL,	'2020-PR8-AP13 -- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	106,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 09:19:45',	'2020-01-17 09:19:45'),
(869,	66,	527,	NULL,	'2020-PR8-AP13 -ASdasergs- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	106,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 09:20:34',	'2020-01-17 09:20:34'),
(870,	70,	17,	NULL,	'2020-PR8-AP13 -ASdasergs- Audit plan accepted',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	106,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 09:24:00',	'2020-01-17 09:24:00'),
(871,	68,	527,	NULL,	'#A65-ASdasergs- Audit  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	65,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 09:26:47',	'2020-01-17 09:26:47'),
(872,	91,	527,	NULL,	'#A65-ASdasergs- audit plan auto accepted by',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	106,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 09:26:47',	'2020-01-17 09:26:47'),
(873,	76,	527,	NULL,	'2020-IA65-AF10 -qeafgtsrd,yfhg- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	55,	NULL,	NULL,	NULL,	'2020-01-17 09:27:39',	'2020-01-17 09:27:39'),
(874,	69,	527,	NULL,	'#A65-ASdasergs- Audit updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	65,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 09:28:03',	'2020-01-17 09:28:03'),
(875,	76,	527,	NULL,	'2020-IA65-AF11 -`2- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	56,	NULL,	NULL,	NULL,	'2020-01-17 09:29:01',	'2020-01-17 09:29:01'),
(876,	76,	527,	NULL,	'2020-IA65-AF12 -13wy- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	57,	NULL,	NULL,	NULL,	'2020-01-17 09:30:13',	'2020-01-17 09:30:13'),
(877,	71,	527,	NULL,	'#A 65ASdasergs- Audit report submit for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	65,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 09:32:35',	'2020-01-17 09:32:35'),
(878,	73,	70,	NULL,	'#A 65ASdasergs- Audit report submit for review rejected',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	65,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 09:40:09',	'2020-01-17 09:40:09'),
(879,	71,	527,	NULL,	'#A 65ASdasergs- Audit report submit for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	65,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 09:44:14',	'2020-01-17 09:44:14'),
(880,	64,	527,	NULL,	'2020- PR8 Legal Audit- Audit program updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	43,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 09:51:20',	'2020-01-17 09:51:20'),
(881,	64,	527,	NULL,	'2020- PR8 Legal Audit- Audit program updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	43,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 09:51:20',	'2020-01-17 09:51:20'),
(882,	65,	527,	NULL,	'2020-PR8-AP14 -rtshrt- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	107,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 09:51:44',	'2020-01-17 09:51:44'),
(883,	66,	527,	NULL,	'2020-PR8-AP14 -rtshrt- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	107,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 09:52:16',	'2020-01-17 09:52:16'),
(884,	68,	527,	NULL,	'#A66-rtshrt- Audit  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	66,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 09:57:16',	'2020-01-17 09:57:16'),
(885,	91,	527,	NULL,	'#A66-rtshrt- audit plan auto accepted by',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	107,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 09:57:16',	'2020-01-17 09:57:16'),
(886,	75,	1,	NULL,	'2020-IA-AF12 -13wy- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	57,	NULL,	NULL,	NULL,	'2020-01-17 10:02:54',	'2020-01-17 10:02:54'),
(887,	77,	1,	NULL,	'2020-IA65-AF12 -13wy- Audit finding updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	57,	NULL,	NULL,	NULL,	'2020-01-17 10:04:19',	'2020-01-17 10:04:19'),
(888,	78,	1,	NULL,	'2020-IA-AF12 -13wy- Root cause analysis created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	57,	NULL,	NULL,	NULL,	'2020-01-17 10:05:43',	'2020-01-17 10:05:43'),
(889,	80,	1,	NULL,	'2020-IA-AF12 -13wy- Impact  analysis  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	57,	NULL,	NULL,	NULL,	'2020-01-17 10:09:00',	'2020-01-17 10:09:00'),
(890,	71,	527,	NULL,	'#A 66rtshrt- Audit report submit for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	66,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 10:09:26',	'2020-01-17 10:09:26'),
(891,	81,	1,	NULL,	'2020-IA-AF12 -13wy- Impact  analysis  updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	57,	NULL,	NULL,	NULL,	'2020-01-17 10:10:17',	'2020-01-17 10:10:17'),
(892,	82,	1,	NULL,	'2020-IA-AF12 -13wy- Corrective action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	57,	NULL,	NULL,	NULL,	'2020-01-17 10:11:44',	'2020-01-17 10:11:44'),
(893,	83,	1,	NULL,	'2020-IA-AF12 -13wy- Corrective action updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	57,	NULL,	NULL,	NULL,	'2020-01-17 10:12:25',	'2020-01-17 10:12:25'),
(894,	84,	1,	NULL,	'2020-IA65-AF12 -13wy- Followup actions resolved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	57,	NULL,	NULL,	NULL,	'2020-01-17 10:13:22',	'2020-01-17 10:13:22'),
(895,	93,	1,	NULL,	'2020-IA65-AF12 -13wy- Followup actions rejected',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	57,	NULL,	NULL,	NULL,	'2020-01-17 10:14:08',	'2020-01-17 10:14:08'),
(896,	84,	1,	NULL,	'2020-IA65-AF12 -13wy- Followup actions resolved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	57,	NULL,	NULL,	NULL,	'2020-01-17 10:14:36',	'2020-01-17 10:14:36'),
(897,	92,	1,	NULL,	'2020-IA65-AF12 -13wy- Followup actions accepted',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	57,	NULL,	NULL,	NULL,	'2020-01-17 10:14:57',	'2020-01-17 10:14:57'),
(898,	75,	1,	NULL,	'2020-IA-AF11 -`2- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	56,	NULL,	NULL,	NULL,	'2020-01-17 10:15:37',	'2020-01-17 10:15:37'),
(899,	85,	1,	NULL,	'2020- EA6 -- External audit created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	17,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 10:16:46',	'2020-01-17 10:16:46'),
(900,	86,	1,	NULL,	'2020- EA6 -- External audit updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	17,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 10:17:47',	'2020-01-17 10:17:47'),
(901,	82,	1,	NULL,	'2020-IA-AF11 -`2- Corrective action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	56,	NULL,	NULL,	NULL,	'2020-01-17 10:18:49',	'2020-01-17 10:18:49'),
(902,	76,	1,	NULL,	'2020-EA6-AF10 -sawad- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	58,	NULL,	NULL,	NULL,	'2020-01-17 10:21:06',	'2020-01-17 10:21:06'),
(903,	77,	1,	NULL,	'2020-EA6-AF10 -sawad- Audit finding updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	58,	NULL,	NULL,	NULL,	'2020-01-17 10:21:45',	'2020-01-17 10:21:45'),
(904,	75,	1,	NULL,	'2020-EA6-AF10 -sawad- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	58,	NULL,	NULL,	NULL,	'2020-01-17 10:23:25',	'2020-01-17 10:23:25'),
(905,	77,	1,	NULL,	'2020-EA6-AF10 -sawad- Audit finding updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	58,	NULL,	NULL,	NULL,	'2020-01-17 10:24:01',	'2020-01-17 10:24:01'),
(906,	78,	1,	NULL,	'2020-EA6-AF10 -sawad- Root cause analysis created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	58,	NULL,	NULL,	NULL,	'2020-01-17 10:24:21',	'2020-01-17 10:24:21'),
(907,	79,	1,	NULL,	'2020-EA6-AF10 -sawad- Root cause analysis  updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	58,	NULL,	NULL,	NULL,	'2020-01-17 10:24:38',	'2020-01-17 10:24:38'),
(908,	80,	1,	NULL,	'2020-EA6-AF10 -sawad- Impact  analysis  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	58,	NULL,	NULL,	NULL,	'2020-01-17 10:25:37',	'2020-01-17 10:25:37'),
(909,	81,	1,	NULL,	'2020-EA6-AF10 -sawad- Impact  analysis  updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	58,	NULL,	NULL,	NULL,	'2020-01-17 10:26:07',	'2020-01-17 10:26:07'),
(910,	82,	1,	NULL,	'2020-EA6-AF10 -sawad- Corrective action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	58,	NULL,	NULL,	NULL,	'2020-01-17 10:26:43',	'2020-01-17 10:26:43'),
(911,	16,	1,	NULL,	'2020- PR702/8/2020- MRM Program created',	NULL,	NULL,	NULL,	70,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 10:33:14',	'2020-01-17 10:33:14'),
(912,	18,	1,	NULL,	'2020-PR70-MP54 -sawad- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	54,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 10:38:39',	'2020-01-17 10:38:39'),
(913,	19,	1,	NULL,	'2020-PR70-MP54 -sawad- MRM Plan updated',	NULL,	NULL,	NULL,	NULL,	54,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 10:39:14',	'2020-01-17 10:39:14'),
(914,	20,	1,	NULL,	'sawad- MRM Plan published',	NULL,	NULL,	NULL,	NULL,	54,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 10:39:34',	'2020-01-17 10:39:34'),
(915,	21,	1,	NULL,	'2020-M34 -sawad- MRM meeting created',	NULL,	NULL,	NULL,	NULL,	NULL,	34,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 10:40:04',	'2020-01-17 10:40:04'),
(916,	22,	1,	NULL,	'2020-M34 -sawad- MRM meeting updated',	NULL,	NULL,	NULL,	NULL,	NULL,	34,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 10:40:30',	'2020-01-17 10:40:30'),
(917,	23,	1,	NULL,	'2020-A-27- CGFHF- MRM meeting action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	27,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 10:41:34',	'2020-01-17 10:41:34'),
(918,	23,	1,	NULL,	'2020-A-28- AGSR- MRM meeting action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	28,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 10:41:59',	'2020-01-17 10:41:59'),
(919,	90,	1,	NULL,	'2020-M34 -sawad- Meeting report published',	NULL,	NULL,	NULL,	NULL,	NULL,	34,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 10:42:44',	'2020-01-17 10:42:44'),
(920,	24,	1,	NULL,	'2020-A-28 AGSRG- MRM meeting action updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	28,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 10:48:00',	'2020-01-17 10:48:00'),
(921,	46,	1,	NULL,	'Job description added  by User updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	361,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 10:48:23',	'2020-01-17 10:48:23'),
(922,	25,	1,	NULL,	'AGSRG-MRM meeting action status updated toOn Hold ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	28,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 10:48:29',	'2020-01-17 10:48:29'),
(923,	46,	1,	NULL,	'Update By User updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	53,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 11:40:27',	'2020-01-17 11:40:27'),
(924,	38,	53,	NULL,	' Retail Price Index- Strategy plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	117,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 11:42:28',	'2020-01-17 11:42:28'),
(925,	38,	1,	NULL,	'Happiness Meter- Strategy plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	118,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 11:45:24',	'2020-01-17 11:45:24'),
(926,	76,	1,	NULL,	'2020-EA6-AF11 -tec- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	59,	NULL,	NULL,	NULL,	'2020-01-17 12:11:00',	'2020-01-17 12:11:00'),
(927,	85,	1,	NULL,	'2020- EA7 -- External audit created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	18,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 12:27:16',	'2020-01-17 12:27:16'),
(928,	85,	1,	NULL,	'2020- EA8 -- External audit created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	19,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 12:29:59',	'2020-01-17 12:29:59'),
(929,	86,	1,	NULL,	'2020- EA8 -- External audit updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	19,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 12:30:22',	'2020-01-17 12:30:22'),
(930,	46,	1,	NULL,	'Update By ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	53,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 13:05:41',	'2020-01-17 13:05:41'),
(931,	30,	1,	NULL,	'New document for test- Compliance register updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	10,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 13:25:46',	'2020-01-17 13:25:46'),
(932,	30,	1,	NULL,	'New document for test- Compliance register updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	10,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 13:26:48',	'2020-01-17 13:26:48'),
(933,	30,	1,	NULL,	'New document for test- Compliance register updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	10,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 13:27:10',	'2020-01-17 13:27:10'),
(934,	30,	1,	NULL,	'New document for test- Compliance register updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	10,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 13:27:11',	'2020-01-17 13:27:11'),
(935,	30,	1,	NULL,	'New document for test- Compliance register updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	10,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 13:27:47',	'2020-01-17 13:27:47'),
(936,	31,	1,	NULL,	'HSE Management System Legal and other requirements - TRA Dubai- Compliance register reviewed',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 13:32:13',	'2020-01-17 13:32:13'),
(937,	14,	1,	NULL,	'ADM-II-0003- Context updated',	NULL,	NULL,	35,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 13:33:30',	'2020-01-17 13:33:30'),
(938,	31,	1,	NULL,	'HSE Management System Legal and other requirements - TRA Dubai- Compliance register reviewed',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 13:40:11',	'2020-01-17 13:40:11'),
(939,	13,	1,	NULL,	'BGS-II-0061- Context created',	NULL,	NULL,	36,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 13:42:56',	'2020-01-17 13:42:56'),
(940,	14,	1,	NULL,	'BGS-II-0062- Context updated',	NULL,	NULL,	36,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 13:45:38',	'2020-01-17 13:45:38'),
(941,	14,	1,	NULL,	'BGS-II-0063- Context updated',	NULL,	NULL,	36,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 13:46:08',	'2020-01-17 13:46:08'),
(942,	15,	1,	NULL,	'BGS-II-0063- Context Reviewed',	NULL,	NULL,	36,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 13:49:07',	'2020-01-17 13:49:07'),
(943,	14,	1,	NULL,	'BGS-II-0064- Context updated',	NULL,	NULL,	5,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 13:50:48',	'2020-01-17 13:50:48'),
(944,	27,	1,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 13:55:25',	'2020-01-17 13:55:25'),
(945,	14,	1,	NULL,	'BGS-II-0065- Context updated',	NULL,	NULL,	36,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 14:03:13',	'2020-01-17 14:03:13'),
(946,	27,	1,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 14:07:35',	'2020-01-17 14:07:35'),
(947,	27,	1,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 14:07:50',	'2020-01-17 14:07:50'),
(948,	27,	1,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 14:08:04',	'2020-01-17 14:08:04'),
(949,	14,	1,	NULL,	'CDD-I&EI-0004- Context updated',	NULL,	NULL,	4,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 14:10:22',	'2020-01-17 14:10:22'),
(950,	46,	1,	NULL,	'Update By ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	536,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 14:20:05',	'2020-01-17 14:20:05'),
(951,	45,	1,	NULL,	'New user newuser123  created ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	537,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 14:23:41',	'2020-01-17 14:23:41'),
(952,	46,	1,	NULL,	'Update By ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	537,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 14:24:23',	'2020-01-17 14:24:23'),
(953,	46,	1,	NULL,	'Job description added ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	537,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 14:25:10',	'2020-01-17 14:25:10'),
(954,	46,	1,	NULL,	'Roles and Responsibility added ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	537,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 14:27:30',	'2020-01-17 14:27:30'),
(955,	46,	1,	NULL,	'KPI added by ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	537,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 14:28:30',	'2020-01-17 14:28:30'),
(956,	46,	1,	NULL,	'Compentency added by ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	537,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 14:28:55',	'2020-01-17 14:28:55'),
(957,	46,	1,	NULL,	'Reports added  by ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	537,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 14:29:16',	'2020-01-17 14:29:16'),
(958,	46,	1,	NULL,	'Job description updated ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	537,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 14:32:06',	'2020-01-17 14:32:06'),
(959,	46,	1,	NULL,	'KPI updated ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	537,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 14:33:10',	'2020-01-17 14:33:10'),
(960,	46,	1,	NULL,	'Compentency updated ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	537,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 14:33:19',	'2020-01-17 14:33:19'),
(961,	46,	1,	NULL,	'Reports update ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	537,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 14:33:33',	'2020-01-17 14:33:33'),
(962,	46,	1,	NULL,	'Job description updated ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	537,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 14:34:09',	'2020-01-17 14:34:09'),
(963,	51,	1,	NULL,	'BGS-R-10- Risk Context created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	43,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 14:35:52',	'2020-01-17 14:35:52'),
(964,	51,	1,	NULL,	'BGS-O-0006- Risk Context created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	44,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 14:42:38',	'2020-01-17 14:42:38'),
(965,	16,	101,	NULL,	'2020- PR71Enhancement cat 2- MRM Program created',	NULL,	NULL,	NULL,	71,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 14:43:19',	'2020-01-17 14:43:19'),
(966,	53,	1,	NULL,	'BGS-O-0006- Risk Assessment created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	44,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 14:59:14',	'2020-01-17 14:59:14'),
(967,	55,	1,	NULL,	'BGS-O-0006- Risk Treatment created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	44,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 15:01:33',	'2020-01-17 15:01:33'),
(968,	57,	1,	NULL,	'BGS-O-0006- Risk treatment submitted for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	44,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 15:06:48',	'2020-01-17 15:06:48'),
(969,	59,	1,	NULL,	'BGS-O-0006- Risk treatment review rejected',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	44,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 15:06:56',	'2020-01-17 15:06:56'),
(970,	57,	1,	NULL,	'BGS-O-0006- Risk treatment submitted for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	44,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 15:07:04',	'2020-01-17 15:07:04'),
(971,	58,	1,	NULL,	'BGS-O-0006- Risk treatment review approved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	44,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 15:07:08',	'2020-01-17 15:07:08'),
(972,	56,	1,	NULL,	'BGS-O-0006- Risk Treatment updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	44,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 15:07:17',	'2020-01-17 15:07:17'),
(973,	60,	1,	NULL,	'BGS-O-0006- Risk treatment submitted for close',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	44,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 15:07:23',	'2020-01-17 15:07:23'),
(974,	62,	1,	NULL,	'BGS-O-0006- Risk treatment  rejected',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	44,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 15:07:31',	'2020-01-17 15:07:31'),
(975,	60,	1,	NULL,	'BGS-O-0006- Risk treatment submitted for close',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	44,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 15:07:38',	'2020-01-17 15:07:38'),
(976,	61,	1,	NULL,	'BGS-O-0006- Risk treatment  approved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	44,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 15:07:43',	'2020-01-17 15:07:43'),
(977,	37,	1,	NULL,	'BGS-II-0065- Context closed',	NULL,	NULL,	36,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 15:15:50',	'2020-01-17 15:15:50'),
(978,	85,	527,	NULL,	'2020- EA9 -sawad- External audit created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	20,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 15:46:16',	'2020-01-17 15:46:16'),
(979,	85,	1,	NULL,	'2020- EA10 -sawad- External audit created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	21,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 15:47:32',	'2020-01-17 15:47:32'),
(980,	76,	1,	NULL,	'2020-EA10-AF12 -sawad- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	60,	NULL,	NULL,	NULL,	'2020-01-17 15:49:29',	'2020-01-17 15:49:29'),
(981,	77,	1,	NULL,	'2020-EA10-AF12 -sawad- Audit finding updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	60,	NULL,	NULL,	NULL,	'2020-01-17 15:50:16',	'2020-01-17 15:50:16'),
(982,	75,	1,	NULL,	'2020-EA10-AF12 -sawad- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	60,	NULL,	NULL,	NULL,	'2020-01-17 15:55:25',	'2020-01-17 15:55:25'),
(983,	76,	1,	NULL,	'2020-EA9-AF13 -sdfseffffffffffff- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	61,	NULL,	NULL,	NULL,	'2020-01-17 16:08:20',	'2020-01-17 16:08:20'),
(984,	75,	1,	NULL,	'2020-EA9-AF13 -sdfseffffffffffff- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	61,	NULL,	NULL,	NULL,	'2020-01-17 16:08:52',	'2020-01-17 16:08:52'),
(985,	78,	1,	NULL,	'2020-EA9-AF13 -sdfseffffffffffff- Root cause analysis created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	61,	NULL,	NULL,	NULL,	'2020-01-17 16:10:56',	'2020-01-17 16:10:56'),
(986,	80,	1,	NULL,	'2020-EA9-AF13 -sdfseffffffffffff- Impact  analysis  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	61,	NULL,	NULL,	NULL,	'2020-01-17 16:11:41',	'2020-01-17 16:11:41'),
(987,	82,	1,	NULL,	'2020-EA9-AF13 -sdfseffffffffffff- Corrective action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	61,	NULL,	NULL,	NULL,	'2020-01-17 16:12:33',	'2020-01-17 16:12:33'),
(988,	39,	1,	NULL,	'Network Readiness Index (NRI) is measured or converted to TII- Strategy plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	104,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 16:13:53',	'2020-01-17 16:13:53'),
(989,	7,	1,	NULL,	'Record- Change request created',	NULL,	35,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 16:21:06',	'2020-01-17 16:21:06'),
(990,	85,	1,	NULL,	'2040- EA1 -notificiation in redis- External audit created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	22,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 16:22:55',	'2020-01-17 16:22:55'),
(991,	85,	1,	NULL,	'2037- EA1 -asdfasdfsdf- External audit created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	23,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 16:26:58',	'2020-01-17 16:26:58'),
(992,	30,	1,	NULL,	'sample docs- Compliance register updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	6,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 08:43:25',	'2020-01-18 08:43:25'),
(993,	28,	1,	NULL,	'VMV- updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 08:45:18',	'2020-01-18 08:45:18'),
(994,	16,	101,	NULL,	'2020- PR72 test category- MRM Program created',	NULL,	NULL,	NULL,	72,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 08:56:10',	'2020-01-18 08:56:10'),
(995,	16,	101,	NULL,	'2020- PR73 Enhancement cat 3- MRM Program created',	NULL,	NULL,	NULL,	73,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 08:59:49',	'2020-01-18 08:59:49'),
(996,	17,	101,	NULL,	'2020- PR73 Enhancement cat 3- MRM Program updated',	NULL,	NULL,	NULL,	73,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 08:59:56',	'2020-01-18 08:59:56'),
(997,	17,	101,	NULL,	'2020- PR73 Enhancement cat 3- MRM Program updated',	NULL,	NULL,	NULL,	73,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 08:59:56',	'2020-01-18 08:59:56'),
(998,	17,	101,	NULL,	'2020- PR73 Enhancement cat 3- MRM Program updated',	NULL,	NULL,	NULL,	73,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 08:59:57',	'2020-01-18 08:59:57'),
(999,	17,	101,	NULL,	'2020- PR73 Enhancement cat 3- MRM Program updated',	NULL,	NULL,	NULL,	73,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 08:59:57',	'2020-01-18 08:59:57'),
(1000,	17,	101,	NULL,	'2020- PR73 Enhancement cat 3- MRM Program updated',	NULL,	NULL,	NULL,	73,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 08:59:57',	'2020-01-18 08:59:57'),
(1001,	17,	101,	NULL,	'2020- PR73 Enhancement cat 3- MRM Program updated',	NULL,	NULL,	NULL,	73,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 08:59:57',	'2020-01-18 08:59:57'),
(1002,	17,	101,	NULL,	'2020- PR73 Enhancement cat 3- MRM Program updated',	NULL,	NULL,	NULL,	73,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 09:00:14',	'2020-01-18 09:00:14'),
(1003,	14,	1,	NULL,	'BGS-EI-0001- Context updated',	NULL,	NULL,	37,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 09:00:56',	'2020-01-18 09:00:56'),
(1004,	14,	1,	NULL,	'BGS-EI-0001- Context updated',	NULL,	NULL,	37,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 09:01:37',	'2020-01-18 09:01:37'),
(1005,	13,	1,	NULL,	'BGS-II-0066- Context created',	NULL,	NULL,	38,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 09:13:22',	'2020-01-18 09:13:22'),
(1006,	14,	1,	NULL,	'BGS-II-0001- Context updated',	NULL,	NULL,	38,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 09:13:52',	'2020-01-18 09:13:52'),
(1007,	14,	1,	NULL,	'BGS-II-0001- Context updated',	NULL,	NULL,	38,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 09:14:09',	'2020-01-18 09:14:09'),
(1008,	14,	1,	NULL,	'BGS-II-0001- Context updated',	NULL,	NULL,	38,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 09:17:51',	'2020-01-18 09:17:51'),
(1009,	13,	1,	NULL,	'ADM-EI-0004- Context created',	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 09:18:54',	'2020-01-18 09:18:54'),
(1010,	14,	1,	NULL,	'ADM-EI-0001- Context updated',	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 09:19:03',	'2020-01-18 09:19:03'),
(1011,	15,	1,	NULL,	'BGS-II-0001- Context Reviewed',	NULL,	NULL,	38,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 09:23:13',	'2020-01-18 09:23:13'),
(1012,	37,	1,	NULL,	'BGS-II-0001- Context closed',	NULL,	NULL,	38,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 09:23:19',	'2020-01-18 09:23:19'),
(1013,	13,	1,	NULL,	'CCD-EI-0001- Context created',	NULL,	NULL,	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 09:24:06',	'2020-01-18 09:24:06'),
(1014,	14,	1,	NULL,	'CCD-EI-0001- Context updated',	NULL,	NULL,	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 09:24:20',	'2020-01-18 09:24:20'),
(1015,	13,	1,	NULL,	'ADM-II-0004- Context created',	NULL,	NULL,	41,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 09:26:05',	'2020-01-18 09:26:05'),
(1016,	14,	1,	NULL,	'ADM-II-0001- Context updated',	NULL,	NULL,	41,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 09:26:25',	'2020-01-18 09:26:25'),
(1017,	47,	1,	NULL,	'test1- KM internal document created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	44,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 10:06:39',	'2020-01-18 10:06:39'),
(1018,	27,	1,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 10:24:01',	'2020-01-18 10:24:01'),
(1019,	27,	1,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 10:33:37',	'2020-01-18 10:33:37'),
(1020,	27,	1,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 10:42:30',	'2020-01-18 10:42:30'),
(1021,	27,	1,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 11:28:03',	'2020-01-18 11:28:03'),
(1022,	27,	1,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 11:28:55',	'2020-01-18 11:28:55'),
(1023,	14,	1,	NULL,	'ADM-II-0001- Context updated',	NULL,	NULL,	41,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 11:46:11',	'2020-01-18 11:46:11'),
(1024,	63,	101,	NULL,	'2020- PR9 NEW CATEGORY 18/01/2020- Audit program created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	54,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 13:07:23',	'2020-01-18 13:07:23'),
(1025,	64,	101,	NULL,	'2020- PR9 NEW CATEGORY 18/01/2020- Audit program updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	54,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 13:08:27',	'2020-01-18 13:08:27'),
(1026,	65,	527,	NULL,	'2020-PR9-AP15 -checking audit flow- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	108,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 13:31:20',	'2020-01-18 13:31:20'),
(1027,	67,	527,	NULL,	'2020-PR9-AP15 -checking audit flow- Audit plan published',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	108,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 13:31:25',	'2020-01-18 13:31:25'),
(1028,	66,	527,	NULL,	'2020-PR9-AP15 -checking audit flow- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	108,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 13:31:25',	'2020-01-18 13:31:25'),
(1029,	70,	393,	NULL,	'2020-PR9-AP15 -checking audit flow- Audit plan accepted',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	108,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 13:44:33',	'2020-01-18 13:44:33'),
(1030,	68,	527,	NULL,	'#A67-checking audit flow- Audit  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	67,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 13:49:49',	'2020-01-18 13:49:49'),
(1031,	69,	527,	NULL,	'#A67-checking audit flow- Audit updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	67,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 13:54:17',	'2020-01-18 13:54:17'),
(1032,	13,	53,	NULL,	'ADM-EI-0004- Context created',	NULL,	NULL,	42,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 14:27:39',	'2020-01-18 14:27:39'),
(1033,	14,	53,	NULL,	'ADM-EI-0004- Context updated',	NULL,	NULL,	42,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 14:27:59',	'2020-01-18 14:27:59'),
(1034,	14,	53,	NULL,	'ADM-EI-0004- Context updated',	NULL,	NULL,	42,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 14:28:15',	'2020-01-18 14:28:15'),
(1035,	76,	527,	NULL,	'2020-IA67-AF13 -Finding 18-01-2020- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	62,	NULL,	NULL,	NULL,	'2020-01-18 14:31:28',	'2020-01-18 14:31:28'),
(1036,	76,	527,	NULL,	'2020-IA67-AF14 -finding 222222------18/01/2020- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	63,	NULL,	NULL,	NULL,	'2020-01-18 14:37:55',	'2020-01-18 14:37:55'),
(1037,	71,	527,	NULL,	'#A 67checking audit flow- Audit report submit for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	67,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 14:44:58',	'2020-01-18 14:44:58'),
(1038,	73,	81,	NULL,	'#A 67checking audit flow- Audit report submit for review rejected',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	67,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 14:50:47',	'2020-01-18 14:50:47'),
(1039,	71,	527,	NULL,	'#A 67checking audit flow- Audit report submit for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	67,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 14:52:32',	'2020-01-18 14:52:32'),
(1040,	72,	81,	NULL,	'#A 67checking audit flow- Audit report submit for review accepted',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	67,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 14:52:55',	'2020-01-18 14:52:55'),
(1041,	75,	1,	NULL,	'2020-IA-AF14 -finding 222222------18/01/2020- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	63,	NULL,	NULL,	NULL,	'2020-01-18 14:54:49',	'2020-01-18 14:54:49'),
(1042,	78,	1,	NULL,	'2020-IA67-AF14 -finding 222222------18/01/2020- Root cause analysis created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	63,	NULL,	NULL,	NULL,	'2020-01-18 14:55:35',	'2020-01-18 14:55:35'),
(1043,	80,	1,	NULL,	'2020-IA67-AF14 -finding 222222------18/01/2020- Impact  analysis  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	63,	NULL,	NULL,	NULL,	'2020-01-18 14:56:21',	'2020-01-18 14:56:21'),
(1044,	81,	1,	NULL,	'2020-IA67-AF14 -finding 222222------18/01/2020- Impact  analysis  updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	63,	NULL,	NULL,	NULL,	'2020-01-18 14:57:44',	'2020-01-18 14:57:44'),
(1045,	82,	1,	NULL,	'2020-IA67-AF14 -finding 222222------18/01/2020- Corrective action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	63,	NULL,	NULL,	NULL,	'2020-01-18 14:58:49',	'2020-01-18 14:58:49'),
(1046,	46,	1,	NULL,	'Update By ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	297,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 15:01:05',	'2020-01-18 15:01:05'),
(1047,	84,	1,	NULL,	'2020-IA67-AF14 -finding 222222------18/01/2020- Followup actions resolved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	63,	NULL,	NULL,	NULL,	'2020-01-18 15:03:47',	'2020-01-18 15:03:47'),
(1048,	93,	527,	NULL,	'2020-IA67-AF14 -finding 222222------18/01/2020- Followup actions rejected',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	63,	NULL,	NULL,	NULL,	'2020-01-18 15:05:22',	'2020-01-18 15:05:22'),
(1049,	84,	1,	NULL,	'2020-IA67-AF14 -finding 222222------18/01/2020- Followup actions resolved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	63,	NULL,	NULL,	NULL,	'2020-01-18 15:05:56',	'2020-01-18 15:05:56'),
(1050,	92,	527,	NULL,	'2020-IA67-AF14 -finding 222222------18/01/2020- Followup actions accepted',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	63,	NULL,	NULL,	NULL,	'2020-01-18 15:06:51',	'2020-01-18 15:06:51'),
(1051,	85,	527,	NULL,	'2020- EA11 -External audit- External audit created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	24,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 15:08:46',	'2020-01-18 15:08:46'),
(1052,	86,	527,	NULL,	'2020- EA11 -External audit- External audit updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	24,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 15:09:19',	'2020-01-18 15:09:19'),
(1053,	76,	81,	NULL,	'2020-EA11-AF14 -Exteranl audit finding- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	64,	NULL,	NULL,	NULL,	'2020-01-18 15:17:10',	'2020-01-18 15:17:10'),
(1054,	75,	81,	NULL,	'2020-EA11-AF14 -Exteranl audit finding- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	64,	NULL,	NULL,	NULL,	'2020-01-18 15:17:48',	'2020-01-18 15:17:48'),
(1055,	78,	1,	NULL,	'2020-EA11-AF14 -Exteranl audit finding- Root cause analysis created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	64,	NULL,	NULL,	NULL,	'2020-01-18 15:18:33',	'2020-01-18 15:18:33'),
(1056,	80,	1,	NULL,	'2020-EA11-AF14 -Exteranl audit finding- Impact  analysis  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	64,	NULL,	NULL,	NULL,	'2020-01-18 15:18:49',	'2020-01-18 15:18:49'),
(1057,	82,	1,	NULL,	'2020-EA11-AF14 -Exteranl audit finding- Corrective action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	64,	NULL,	NULL,	NULL,	'2020-01-18 15:19:18',	'2020-01-18 15:19:18'),
(1058,	84,	1,	NULL,	'2020-EA11-AF14-Exteranl audit finding Followup actions resolved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	64,	NULL,	NULL,	NULL,	'2020-01-18 15:19:37',	'2020-01-18 15:19:37'),
(1059,	76,	81,	NULL,	'2020-EA11-AF15 -ertet- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	65,	NULL,	NULL,	NULL,	'2020-01-18 15:21:32',	'2020-01-18 15:21:32'),
(1060,	46,	1,	NULL,	'Update By ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 23:13:35',	'2020-01-18 23:13:35'),
(1061,	94,	1,	NULL,	'BGS-II-0065- Context reopened',	NULL,	NULL,	36,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 23:29:42',	'2020-01-18 23:29:42'),
(1062,	94,	1,	NULL,	'BGS-II-0001- Context reopened',	NULL,	NULL,	38,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 23:44:59',	'2020-01-18 23:44:59'),
(1063,	94,	1,	NULL,	'BGS-II-0060- Context reopened',	NULL,	NULL,	32,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 23:53:49',	'2020-01-18 23:53:49'),
(1064,	15,	1,	NULL,	'BGS-II-0060- Context Reviewed',	NULL,	NULL,	32,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 23:54:56',	'2020-01-18 23:54:56'),
(1065,	51,	1,	NULL,	'BGS-R-0011- Risk Context created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	45,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 23:57:58',	'2020-01-18 23:57:58'),
(1066,	46,	243,	NULL,	'Update By ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	243,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 08:04:28',	'2020-01-20 08:04:28'),
(1067,	46,	1,	NULL,	'Update By ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	243,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 08:05:04',	'2020-01-20 08:05:04'),
(1068,	16,	101,	NULL,	'2019- PR74 Enhancement cat 3- MRM Program created',	NULL,	NULL,	NULL,	74,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 08:19:13',	'2020-01-20 08:19:13'),
(1069,	17,	101,	NULL,	'2019- PR74 Enhancement cat 3- MRM Program updated',	NULL,	NULL,	NULL,	74,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 08:20:16',	'2020-01-20 08:20:16'),
(1070,	17,	101,	NULL,	'2019- PR74 Enhancement cat 3- MRM Program updated',	NULL,	NULL,	NULL,	74,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 08:20:18',	'2020-01-20 08:20:18'),
(1071,	27,	1,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 08:24:52',	'2020-01-20 08:24:52'),
(1072,	18,	68,	NULL,	'2019-PR74-MP55 -Testing 20-01-2020- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	55,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 08:27:57',	'2020-01-20 08:27:57'),
(1073,	13,	243,	NULL,	'CSS-II-0001- Context created',	NULL,	NULL,	43,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 08:30:02',	'2020-01-20 08:30:02'),
(1074,	20,	68,	NULL,	'Testing 20-01-2020- MRM Plan published',	NULL,	NULL,	NULL,	NULL,	55,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 08:30:59',	'2020-01-20 08:30:59'),
(1075,	94,	1,	NULL,	'BGS-II-0045- Context reopened',	NULL,	NULL,	25,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 08:33:55',	'2020-01-20 08:33:55'),
(1076,	14,	1,	NULL,	'ADM-II-0045- Context updated',	NULL,	NULL,	25,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 08:34:33',	'2020-01-20 08:34:33'),
(1077,	21,	68,	NULL,	'2019-M35 -Testing 20-01-2020- MRM meeting created',	NULL,	NULL,	NULL,	NULL,	NULL,	35,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 08:37:20',	'2020-01-20 08:37:20'),
(1078,	18,	68,	NULL,	'2019-PR74-MP56 -testing newwwwwwwwww- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	56,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 08:38:46',	'2020-01-20 08:38:46'),
(1079,	21,	68,	NULL,	'2019-M36 -testing newwwwwwwwww- MRM meeting created',	NULL,	NULL,	NULL,	NULL,	NULL,	36,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 08:40:47',	'2020-01-20 08:40:47'),
(1080,	28,	1,	NULL,	'VMV- updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 08:54:02',	'2020-01-20 08:54:02'),
(1081,	36,	1,	NULL,	'Information security policies- Policy updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	9,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 08:54:19',	'2020-01-20 08:54:19'),
(1082,	30,	1,	NULL,	'Policy document- Compliance register updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	5,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 08:56:25',	'2020-01-20 08:56:25'),
(1083,	33,	1,	NULL,	'ISO certificate updated ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	17,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 09:06:00',	'2020-01-20 09:06:00'),
(1084,	33,	1,	NULL,	'ISO certificate updated ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	17,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 09:06:31',	'2020-01-20 09:06:31'),
(1085,	30,	1,	NULL,	'sample docs- Compliance register updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	6,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 09:07:15',	'2020-01-20 09:07:15'),
(1086,	30,	1,	NULL,	'sample docs- Compliance register updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	6,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 09:10:05',	'2020-01-20 09:10:05'),
(1087,	30,	1,	NULL,	'sample docs- Compliance register updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	6,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 09:10:46',	'2020-01-20 09:10:46'),
(1088,	90,	68,	NULL,	'2019-M36 -testing newwwwwwwwww- Meeting report published',	NULL,	NULL,	NULL,	NULL,	NULL,	36,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 09:34:40',	'2020-01-20 09:34:40'),
(1089,	18,	1,	NULL,	'2020-PR79-MP57 -aq- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	57,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 09:53:59',	'2020-01-20 09:53:59'),
(1090,	21,	1,	NULL,	'2020-M37 -aq- MRM meeting created',	NULL,	NULL,	NULL,	NULL,	NULL,	37,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 09:55:26',	'2020-01-20 09:55:26'),
(1091,	24,	68,	NULL,	'2019-A-30 Lorem ipsum dolor- MRM meeting action updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	30,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 10:00:18',	'2020-01-20 10:00:18'),
(1092,	24,	68,	NULL,	'2019-A-30 Lorem ipsum dolor1- MRM meeting action updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	30,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 10:00:49',	'2020-01-20 10:00:49'),
(1093,	24,	68,	NULL,	'2019-A-31 acttionnnnnnnnnnnnnnnnnnnnnnnnnnnn- MRM meeting action updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	31,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 10:06:09',	'2020-01-20 10:06:09'),
(1094,	24,	68,	NULL,	'2019-A-31 acttionnnnnnnnnnnnnnnnnnnnnnnnnnnn- MRM meeting action updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	31,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 10:06:31',	'2020-01-20 10:06:31'),
(1095,	24,	68,	NULL,	'2019-A-30 Lorem ipsum dolor1- MRM meeting action updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	30,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 10:12:12',	'2020-01-20 10:12:12'),
(1096,	24,	61,	NULL,	'2019-A-32 action 1- MRM meeting action updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	32,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 10:20:55',	'2020-01-20 10:20:55'),
(1097,	24,	61,	NULL,	'2019-A-31 acttionnnnnnnnnnnnnnnnnnnnnnnnnnnn- MRM meeting action updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	31,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 10:21:41',	'2020-01-20 10:21:41'),
(1098,	24,	61,	NULL,	'2019-A-30 Lorem ipsum dolor1- MRM meeting action updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	30,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 10:21:53',	'2020-01-20 10:21:53'),
(1099,	24,	61,	NULL,	'2019-A-29 Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt- MRM meeting action updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	29,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 10:22:07',	'2020-01-20 10:22:07'),
(1100,	37,	1,	NULL,	'BGS-II-0001- Context closed',	NULL,	NULL,	38,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 10:39:55',	'2020-01-20 10:39:55'),
(1101,	37,	297,	NULL,	'BGS-II-0001- Context closed',	NULL,	NULL,	43,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 10:48:10',	'2020-01-20 10:48:10'),
(1102,	24,	68,	NULL,	'2019-A-33 activity log created- MRM meeting action updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	33,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 10:48:41',	'2020-01-20 10:48:41'),
(1103,	53,	1,	NULL,	'DGO-R-0001- Risk Assessment created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	46,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 11:26:18',	'2020-01-20 11:26:18'),
(1104,	55,	1,	NULL,	'DGO-R-0001- Risk Treatment created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	46,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 11:26:42',	'2020-01-20 11:26:42'),
(1105,	37,	22,	NULL,	'DGO-II-0001- Context closed',	NULL,	NULL,	44,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 11:37:54',	'2020-01-20 11:37:54'),
(1106,	53,	1,	NULL,	'DGO-R-0002- Risk Assessment created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	47,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 12:56:17',	'2020-01-20 12:56:17'),
(1107,	55,	1,	NULL,	'DGO-R-0002- Risk Treatment created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	47,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 12:56:52',	'2020-01-20 12:56:52'),
(1108,	63,	68,	NULL,	'2000- PR1 Cost Audit- Audit program created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	55,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 13:09:43',	'2020-01-20 13:09:43'),
(1109,	56,	1,	NULL,	'DGO-R-0002- Risk Treatment updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	47,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 13:12:57',	'2020-01-20 13:12:57'),
(1110,	60,	1,	NULL,	'DGO-R-0002- Risk treatment submitted for close',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	47,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 13:13:01',	'2020-01-20 13:13:01'),
(1111,	61,	1,	NULL,	'DGO-R-0002- Risk treatment  approved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	47,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 13:13:05',	'2020-01-20 13:13:05'),
(1112,	45,	1,	NULL,	'New user sawad R  created ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	538,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 13:22:36',	'2020-01-20 13:22:36'),
(1113,	38,	243,	NULL,	'Percentage of Emiratization- Strategy plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	119,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 13:26:45',	'2020-01-20 13:26:45'),
(1114,	45,	1,	NULL,	'New user anju  created ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	539,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 13:28:49',	'2020-01-20 13:28:49'),
(1115,	63,	1,	NULL,	'2020- PR10 Forensic Audit- Audit program created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	56,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 13:39:02',	'2020-01-20 13:39:02'),
(1116,	64,	1,	NULL,	'2020- PR10 Forensic Audit- Audit program updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	56,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 13:39:23',	'2020-01-20 13:39:23'),
(1117,	45,	1,	NULL,	'New user Naseeha Sahla  created ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	540,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 14:05:45',	'2020-01-20 14:05:45'),
(1118,	46,	1,	NULL,	'Update By ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	540,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 14:06:47',	'2020-01-20 14:06:47'),
(1119,	46,	1,	NULL,	'Update By ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	540,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 14:08:02',	'2020-01-20 14:08:02'),
(1120,	65,	539,	NULL,	'2020-PR10-AP16 -test- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	109,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 14:33:08',	'2020-01-20 14:33:08'),
(1121,	66,	539,	NULL,	'2020-PR10-AP16 -test- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	109,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 14:33:15',	'2020-01-20 14:33:15'),
(1122,	67,	539,	NULL,	'2020-PR10-AP16 -test- Audit plan published',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	109,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 14:43:56',	'2020-01-20 14:43:56'),
(1123,	68,	539,	NULL,	'#A68-test- Audit  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	68,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 14:50:30',	'2020-01-20 14:50:30'),
(1124,	91,	539,	NULL,	'#A68-test- audit plan auto accepted by',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	109,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 14:50:30',	'2020-01-20 14:50:30'),
(1125,	76,	539,	NULL,	'2020-IA68-AF15 -finding 1- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	66,	NULL,	NULL,	NULL,	'2020-01-20 14:52:29',	'2020-01-20 14:52:29'),
(1126,	76,	539,	NULL,	'2020-IA68-AF16 -tra special dept .finding- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	67,	NULL,	NULL,	NULL,	'2020-01-20 15:03:33',	'2020-01-20 15:03:33'),
(1127,	71,	539,	NULL,	'#A 68test- Audit report submit for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	68,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 15:03:55',	'2020-01-20 15:03:55'),
(1128,	72,	538,	NULL,	'#A 68test- Audit report submit for review accepted',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	68,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 15:10:44',	'2020-01-20 15:10:44'),
(1129,	75,	538,	NULL,	'2020-IA-AF16 -tra special dept .finding- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	67,	NULL,	NULL,	NULL,	'2020-01-20 15:19:14',	'2020-01-20 15:19:14'),
(1130,	85,	539,	NULL,	'2020- EA12 -EXternal audit finding 2- External audit created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	25,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 15:48:59',	'2020-01-20 15:48:59'),
(1131,	2,	1,	NULL,	'test16- Document updated',	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 16:38:52',	'2020-01-20 16:38:52'),
(1132,	2,	1,	NULL,	'test16- Document updated',	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 16:39:57',	'2020-01-20 16:39:57'),
(1133,	85,	539,	NULL,	'2020- EA13 -External audit 2020- External audit created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	26,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 08:28:49',	'2020-01-21 08:28:49'),
(1134,	85,	539,	NULL,	'2020- EA13 -External audit 2020- External audit created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	27,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 08:33:34',	'2020-01-21 08:33:34'),
(1135,	85,	539,	NULL,	'2020- EA13 -survelance audit 2020- External audit created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	28,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 08:35:32',	'2020-01-21 08:35:32'),
(1136,	86,	1,	NULL,	'2020- EA1 -External audit- External audit updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	4,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 08:53:56',	'2020-01-21 08:53:56'),
(1137,	39,	1,	NULL,	'Percentage of consumer disputes received by the Authority from the total subscriber base of telecommunications services in the country.- Strategy plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	120,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 09:08:02',	'2020-01-21 09:08:02'),
(1138,	39,	1,	NULL,	'Percentage of consumer disputes received by the Authority from the total subscriber base of telecommunications services in the country.- Strategy plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	120,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 09:08:45',	'2020-01-21 09:08:45'),
(1139,	87,	1,	NULL,	'Percentage of consumer disputes received by the Authority from the total subscriber base of telecommunications services in the country.- Strategy plan action performed',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	120,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 09:09:57',	'2020-01-21 09:09:57'),
(1140,	76,	1,	NULL,	'2020-EA13-AF16 -Finding by year- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	68,	NULL,	NULL,	NULL,	'2020-01-21 09:13:17',	'2020-01-21 09:13:17'),
(1141,	82,	539,	NULL,	'2020-EA13-AF16 -Finding by year- Corrective action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	68,	NULL,	NULL,	NULL,	'2020-01-21 10:04:28',	'2020-01-21 10:04:28'),
(1142,	46,	1,	NULL,	'Update By ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	80,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 10:09:05',	'2020-01-21 10:09:05'),
(1143,	16,	539,	NULL,	'2020- PR80 Health & safty review meeting- MRM Program created',	NULL,	NULL,	NULL,	80,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 11:12:02',	'2020-01-21 11:12:02'),
(1144,	17,	539,	NULL,	'2020- PR80 Health & safty review meeting- MRM Program updated',	NULL,	NULL,	NULL,	80,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 11:12:22',	'2020-01-21 11:12:22'),
(1145,	18,	538,	NULL,	'2020-PR80-MP58 -test  title- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	58,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 12:40:49',	'2020-01-21 12:40:49'),
(1146,	19,	538,	NULL,	'2020-PR80-MP58 -test  title- MRM Plan updated',	NULL,	NULL,	NULL,	NULL,	58,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 12:45:50',	'2020-01-21 12:45:50'),
(1147,	18,	538,	NULL,	'2020-PR80-MP59 -5656y- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	59,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 12:48:44',	'2020-01-21 12:48:44'),
(1148,	19,	538,	NULL,	'2020-PR80-MP59 -5656y- MRM Plan updated',	NULL,	NULL,	NULL,	NULL,	59,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 12:49:10',	'2020-01-21 12:49:10'),
(1149,	19,	538,	NULL,	'2020-PR80-MP58 -test  title- MRM Plan updated',	NULL,	NULL,	NULL,	NULL,	58,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 12:49:48',	'2020-01-21 12:49:48'),
(1150,	20,	538,	NULL,	'test  title- MRM Plan published',	NULL,	NULL,	NULL,	NULL,	58,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 12:49:56',	'2020-01-21 12:49:56'),
(1151,	24,	1,	NULL,	'2019-A-39 testing for activity log- MRM meeting action updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 13:25:24',	'2020-01-21 13:25:24'),
(1152,	24,	1,	NULL,	'2019-A-39 testing for activity log- MRM meeting action updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 13:27:09',	'2020-01-21 13:27:09'),
(1153,	24,	1,	NULL,	'2019-A-38 testing for activity log- MRM meeting action updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	38,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 13:28:45',	'2020-01-21 13:28:45'),
(1154,	24,	1,	NULL,	'2019-A-39 testing for activity log- MRM meeting action updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 13:29:10',	'2020-01-21 13:29:10'),
(1155,	24,	1,	NULL,	'2019-A-39 testing for activity log- MRM meeting action updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 13:36:07',	'2020-01-21 13:36:07'),
(1156,	24,	1,	NULL,	'2019-A-39 testing for activity log edit by fahad- MRM meeting action updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 13:45:10',	'2020-01-21 13:45:10'),
(1157,	24,	1,	NULL,	'2019-A-38 testing for activity log hope is- MRM meeting action updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	38,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 13:45:34',	'2020-01-21 13:45:34'),
(1158,	27,	1,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 14:49:33',	'2020-01-21 14:49:33'),
(1159,	27,	1,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 14:51:21',	'2020-01-21 14:51:21'),
(1160,	27,	1,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 14:51:36',	'2020-01-21 14:51:36'),
(1161,	27,	1,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 14:51:56',	'2020-01-21 14:51:56'),
(1162,	27,	1,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 14:51:57',	'2020-01-21 14:51:57'),
(1163,	27,	1,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 14:51:57',	'2020-01-21 14:51:57'),
(1164,	27,	1,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 14:51:58',	'2020-01-21 14:51:58'),
(1165,	27,	1,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 14:51:58',	'2020-01-21 14:51:58'),
(1166,	27,	1,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 14:51:58',	'2020-01-21 14:51:58'),
(1167,	27,	1,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 14:51:58',	'2020-01-21 14:51:58'),
(1168,	27,	1,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 14:51:58',	'2020-01-21 14:51:58'),
(1169,	27,	1,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 14:51:58',	'2020-01-21 14:51:58'),
(1170,	27,	1,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 14:51:58',	'2020-01-21 14:51:58'),
(1171,	27,	1,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 14:51:59',	'2020-01-21 14:51:59'),
(1172,	27,	1,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 14:51:59',	'2020-01-21 14:51:59'),
(1173,	30,	1,	NULL,	'sample docs- Compliance register updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	6,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 15:01:20',	'2020-01-21 15:01:20'),
(1174,	21,	538,	NULL,	'2020-M38 -test  title- MRM meeting created',	NULL,	NULL,	NULL,	NULL,	NULL,	38,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 15:08:24',	'2020-01-21 15:08:24'),
(1175,	23,	538,	NULL,	'2020-A-40- Action report count testing 1- MRM meeting action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 15:09:09',	'2020-01-21 15:09:09'),
(1176,	18,	1,	NULL,	'2020-PR78-MP60 -yffgfgt- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	60,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 15:11:35',	'2020-01-21 15:11:35'),
(1177,	19,	1,	NULL,	'2020-PR78-MP60 -yffgfgt- MRM Plan updated',	NULL,	NULL,	NULL,	NULL,	60,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 15:11:49',	'2020-01-21 15:11:49'),
(1178,	23,	538,	NULL,	'2020-A-41- action report condition checking- MRM meeting action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	41,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 15:14:37',	'2020-01-21 15:14:37'),
(1179,	76,	1,	NULL,	'2020-EA13-AF17 -hghgh- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	69,	NULL,	NULL,	NULL,	'2020-01-21 15:22:57',	'2020-01-21 15:22:57'),
(1180,	66,	101,	NULL,	'2020-PR6-AP11 -testtt- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	88,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 15:32:33',	'2020-01-21 15:32:33'),
(1181,	66,	101,	NULL,	'2020-PR6-AP11 -testtt- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	88,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 15:32:43',	'2020-01-21 15:32:43'),
(1182,	24,	538,	NULL,	'2020-A-40 Action report count testing 1- MRM meeting action updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 15:42:59',	'2020-01-21 15:42:59'),
(1183,	24,	538,	NULL,	'2020-A-41 action report condition checking- MRM meeting action updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	41,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 15:44:30',	'2020-01-21 15:44:30'),
(1184,	90,	538,	NULL,	'2020-M38 -test  title- Meeting report published',	NULL,	NULL,	NULL,	NULL,	NULL,	38,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 16:01:04',	'2020-01-21 16:01:04'),
(1185,	25,	538,	NULL,	'2020-A -41 action report condition checking-MRM meeting action status updated to Completed ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	41,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 16:02:07',	'2020-01-21 16:02:07'),
(1186,	25,	538,	NULL,	'2020-A -40 Action report count testing 1-MRM meeting action status updated to Completed ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 16:03:12',	'2020-01-21 16:03:12'),
(1187,	25,	1,	NULL,	'2019-A -38 testing for activity log hope is-MRM meeting action status updated to Completed ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	38,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 16:04:34',	'2020-01-21 16:04:34'),
(1188,	18,	538,	NULL,	'2020-PR80-MP61 -test issue- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	61,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 16:08:03',	'2020-01-21 16:08:03'),
(1189,	20,	538,	NULL,	'test issue- MRM Plan published',	NULL,	NULL,	NULL,	NULL,	61,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 16:08:12',	'2020-01-21 16:08:12'),
(1190,	21,	538,	NULL,	'2020-M39 -test issue- MRM meeting created',	NULL,	NULL,	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 16:09:07',	'2020-01-21 16:09:07'),
(1191,	23,	538,	NULL,	'2020-A-42- ACtiomnnn fahadd- MRM meeting action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	42,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 16:09:33',	'2020-01-21 16:09:33'),
(1192,	23,	538,	NULL,	'2020-A-43- action  swaddd issue- MRM meeting action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	43,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 16:10:26',	'2020-01-21 16:10:26'),
(1193,	16,	538,	NULL,	'2015- PR81 Qms meeting- MRM Program created',	NULL,	NULL,	NULL,	81,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 17:09:54',	'2020-01-21 17:09:54'),
(1194,	18,	538,	NULL,	'2015-PR81-MP62 -checking filter notification- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	62,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 17:15:16',	'2020-01-21 17:15:16'),
(1195,	20,	538,	NULL,	'checking filter notification- MRM Plan published',	NULL,	NULL,	NULL,	NULL,	62,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-21 17:15:25',	'2020-01-21 17:15:25'),
(1196,	27,	1,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-22 08:04:31',	'2020-01-22 08:04:31'),
(1197,	27,	1,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-22 08:04:50',	'2020-01-22 08:04:50'),
(1198,	21,	538,	NULL,	'2015-M40 -checking filter notification- MRM meeting created',	NULL,	NULL,	NULL,	NULL,	NULL,	40,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-22 08:24:53',	'2020-01-22 08:24:53'),
(1199,	18,	538,	NULL,	'2015-PR81-MP63 -testing notification- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	63,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-22 08:45:27',	'2020-01-22 08:45:27'),
(1200,	20,	538,	NULL,	'testing notification- MRM Plan published',	NULL,	NULL,	NULL,	NULL,	63,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-22 08:45:35',	'2020-01-22 08:45:35'),
(1201,	21,	538,	NULL,	'2015-M41 -testing notification- MRM meeting created',	NULL,	NULL,	NULL,	NULL,	NULL,	41,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-22 09:02:16',	'2020-01-22 09:02:16'),
(1202,	23,	538,	NULL,	'2015-A-46- Action fahad- MRM meeting action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	46,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-22 09:03:10',	'2020-01-22 09:03:10'),
(1203,	39,	1,	NULL,	'Network Readiness Index (NRI) is measured or converted to TII- Strategy plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	103,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-22 09:37:32',	'2020-01-22 09:37:32'),
(1204,	24,	538,	NULL,	'2020-A-27 CGFHF- MRM meeting action updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	27,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-22 09:38:57',	'2020-01-22 09:38:57'),
(1205,	24,	538,	NULL,	'2020-A-27 CGFHF- MRM meeting action updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	27,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-22 09:39:23',	'2020-01-22 09:39:23'),
(1206,	66,	101,	NULL,	'2020-PR6-AP11 -testtt- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	88,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-22 09:42:43',	'2020-01-22 09:42:43'),
(1207,	18,	538,	NULL,	'2015-PR81-MP64 -csfsfc- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	64,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-22 09:46:14',	'2020-01-22 09:46:14'),
(1208,	20,	538,	NULL,	'csfsfc- MRM Plan published',	NULL,	NULL,	NULL,	NULL,	64,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-22 09:48:15',	'2020-01-22 09:48:15'),
(1209,	27,	1,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-22 09:56:04',	'2020-01-22 09:56:04'),
(1210,	27,	1,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-22 09:56:22',	'2020-01-22 09:56:22'),
(1211,	27,	1,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-22 09:57:24',	'2020-01-22 09:57:24'),
(1212,	27,	1,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-22 09:57:42',	'2020-01-22 09:57:42'),
(1213,	21,	538,	NULL,	'2015-M42 -csfsfc- MRM meeting created',	NULL,	NULL,	NULL,	NULL,	NULL,	42,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-22 10:07:15',	'2020-01-22 10:07:15'),
(1214,	23,	538,	NULL,	'2015-A-47- Action- MRM meeting action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	47,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-22 10:08:48',	'2020-01-22 10:08:48'),
(1215,	29,	1,	NULL,	'test year- Compliance register created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	11,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-22 10:10:35',	'2020-01-22 10:10:35'),
(1216,	16,	539,	NULL,	'2020- PR82 Quality management meeting- MRM Program created',	NULL,	NULL,	NULL,	82,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-22 10:51:43',	'2020-01-22 10:51:43'),
(1217,	17,	539,	NULL,	'2020- PR82 Quality management meeting- MRM Program updated',	NULL,	NULL,	NULL,	82,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-22 10:52:20',	'2020-01-22 10:52:20'),
(1218,	18,	538,	NULL,	'2020-PR82-MP65 -mrm PLANN- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	65,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-22 10:58:17',	'2020-01-22 10:58:17'),
(1219,	25,	538,	NULL,	'2015-A -46 Action fahad-MRM meeting action status updated to On Hold ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	46,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-22 11:09:10',	'2020-01-22 11:09:10'),
(1220,	25,	538,	NULL,	'2015-A -46 Action fahad-MRM meeting action status updated to Closed ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	46,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-22 11:12:31',	'2020-01-22 11:12:31'),
(1221,	23,	538,	NULL,	'2015-A-48- bb- MRM meeting action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	48,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-22 11:25:30',	'2020-01-22 11:25:30'),
(1222,	24,	538,	NULL,	'2015-A-48 bb- MRM meeting action updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	48,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-22 11:25:41',	'2020-01-22 11:25:41'),
(1223,	24,	538,	NULL,	'2015-A-48 bb- MRM meeting action updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	48,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-22 11:26:02',	'2020-01-22 11:26:02'),
(1224,	23,	538,	NULL,	'2020-A-49- fsdf- MRM meeting action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	49,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-22 12:38:49',	'2020-01-22 12:38:49'),
(1225,	90,	538,	NULL,	'2020-M39 -test issue- Meeting report published',	NULL,	NULL,	NULL,	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-22 13:01:32',	'2020-01-22 13:01:32'),
(1226,	27,	1,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-22 13:44:22',	'2020-01-22 13:44:22'),
(1227,	20,	538,	NULL,	'mrm PLANN- MRM Plan published',	NULL,	NULL,	NULL,	NULL,	65,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-22 14:18:58',	'2020-01-22 14:18:58'),
(1228,	63,	538,	NULL,	'2020- PR11 Statutory Audit- Audit program created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	57,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-22 14:43:28',	'2020-01-22 14:43:28'),
(1229,	64,	538,	NULL,	'2020- PR11 Statutory Audit- Audit program updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	57,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-22 15:01:04',	'2020-01-22 15:01:04'),
(1230,	65,	539,	NULL,	'2020-PR11-AP17 -- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	110,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-22 15:33:04',	'2020-01-22 15:33:04'),
(1231,	38,	1,	NULL,	'National Indicator: The Index of Electronic Services (Smart) (OSI)- Strategy plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	122,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-22 15:38:04',	'2020-01-22 15:38:04'),
(1232,	67,	539,	NULL,	'2020-PR11-AP17 -testing filter- Audit plan published',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	110,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-22 16:46:44',	'2020-01-22 16:46:44'),
(1233,	46,	1,	NULL,	'Update By ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	62,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-22 16:52:35',	'2020-01-22 16:52:35'),
(1234,	21,	538,	NULL,	'2020-M43 -mrm PLANN- MRM meeting created',	NULL,	NULL,	NULL,	NULL,	NULL,	43,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-23 08:32:22',	'2020-01-23 08:32:22'),
(1235,	23,	538,	NULL,	'2020-A-50- Actionn- MRM meeting action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	50,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-23 08:32:48',	'2020-01-23 08:32:48'),
(1236,	23,	538,	NULL,	'2020-A-51- ggg- MRM meeting action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	51,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-23 08:33:49',	'2020-01-23 08:33:49'),
(1237,	70,	62,	NULL,	'2020-PR11-AP17 -testing filter- Audit plan accepted',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	110,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-23 08:51:49',	'2020-01-23 08:51:49'),
(1238,	46,	1,	NULL,	'Update By ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	79,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-23 10:31:40',	'2020-01-23 10:31:40'),
(1239,	46,	1,	NULL,	'Update By ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	79,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-23 10:32:16',	'2020-01-23 10:32:16'),
(1240,	46,	1,	NULL,	'Update By ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	79,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-23 10:32:47',	'2020-01-23 10:32:47'),
(1241,	13,	79,	NULL,	'CSS-II-0001- Context created',	NULL,	NULL,	46,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-23 10:43:51',	'2020-01-23 10:43:51'),
(1242,	68,	539,	NULL,	'#A69-testing filter- Audit  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	69,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-23 11:08:12',	'2020-01-23 11:08:12'),
(1243,	69,	539,	NULL,	'#A69-testing filter- Audit updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	69,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-23 13:10:10',	'2020-01-23 13:10:10'),
(1244,	76,	539,	NULL,	'2020-IA69-AF17 -finding filter- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	70,	NULL,	NULL,	NULL,	'2020-01-23 13:29:09',	'2020-01-23 13:29:09'),
(1245,	76,	539,	NULL,	'2020-IA69-AF18 -finding filter 2- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	71,	NULL,	NULL,	NULL,	'2020-01-23 13:29:24',	'2020-01-23 13:29:24'),
(1246,	76,	539,	NULL,	'2020-IA69-AF19 -finding filter3- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	72,	NULL,	NULL,	NULL,	'2020-01-23 13:29:45',	'2020-01-23 13:29:45'),
(1247,	76,	539,	NULL,	'2020-IA69-AF20 -finding filter3- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	73,	NULL,	NULL,	NULL,	'2020-01-23 13:29:45',	'2020-01-23 13:29:45'),
(1248,	51,	1,	NULL,	'ADM-R-0001- Risk Context created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	48,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-23 13:31:11',	'2020-01-23 13:31:11'),
(1249,	76,	539,	NULL,	'2020-IA69-AF21 -finding filter 4- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	74,	NULL,	NULL,	NULL,	'2020-01-23 13:32:37',	'2020-01-23 13:32:37'),
(1250,	71,	539,	NULL,	'#A 69testing filter- Audit report submit for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	69,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-23 13:46:46',	'2020-01-23 13:46:46'),
(1251,	72,	538,	NULL,	'#A 69testing filter- Audit report submit for review accepted',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	69,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-23 13:54:08',	'2020-01-23 13:54:08'),
(1252,	7,	1,	NULL,	'Notification test- Change request created',	NULL,	36,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-23 13:56:12',	'2020-01-23 13:56:12'),
(1253,	7,	1,	NULL,	'Notification test- Change request created',	NULL,	37,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-23 13:57:30',	'2020-01-23 13:57:30'),
(1254,	75,	538,	NULL,	'2020-IA-AF21 -finding filter 4- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	74,	NULL,	NULL,	NULL,	'2020-01-23 13:58:17',	'2020-01-23 13:58:17'),
(1255,	75,	538,	NULL,	'2020-IA-AF21 -finding filter 4- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	74,	NULL,	NULL,	NULL,	'2020-01-23 13:58:23',	'2020-01-23 13:58:23'),
(1256,	78,	62,	NULL,	'2020-IA69-AF21 -finding filter 4- Root cause analysis created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	74,	NULL,	NULL,	NULL,	'2020-01-23 14:25:56',	'2020-01-23 14:25:56'),
(1257,	80,	62,	NULL,	'2020-IA69-AF21 -finding filter 4- Impact  analysis  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	74,	NULL,	NULL,	NULL,	'2020-01-23 14:26:50',	'2020-01-23 14:26:50'),
(1258,	82,	62,	NULL,	'2020-IA69-AF21 -finding filter 4- Corrective action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	74,	NULL,	NULL,	NULL,	'2020-01-23 14:28:24',	'2020-01-23 14:28:24'),
(1259,	85,	538,	NULL,	'2020- EA14 -2020- External audit created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	29,	NULL,	NULL,	NULL,	NULL,	'2020-01-23 15:54:22',	'2020-01-23 15:54:22'),
(1260,	86,	539,	NULL,	'2020- EA14 -2020- External audit updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	29,	NULL,	NULL,	NULL,	NULL,	'2020-01-23 15:57:06',	'2020-01-23 15:57:06'),
(1261,	76,	539,	NULL,	'2020-EA14-AF18 -EXTERNAL AUDIT FINDING- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	75,	NULL,	NULL,	NULL,	'2020-01-23 16:01:20',	'2020-01-23 16:01:20'),
(1262,	76,	539,	NULL,	'2020-EA14-AF19 -EX FINDING SPECIAL- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	76,	NULL,	NULL,	NULL,	'2020-01-23 16:01:53',	'2020-01-23 16:01:53'),
(1263,	85,	538,	NULL,	'2020- EA15 -dfds- External audit created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	30,	NULL,	NULL,	NULL,	NULL,	'2020-01-24 10:15:48',	'2020-01-24 10:15:48'),
(1264,	86,	538,	NULL,	'2019- EA15 -dfds- External audit updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	30,	NULL,	NULL,	NULL,	NULL,	'2020-01-24 10:22:51',	'2020-01-24 10:22:51'),
(1265,	76,	101,	NULL,	'2019-EA15-AF1 -ex- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	77,	NULL,	NULL,	NULL,	'2020-01-24 10:38:08',	'2020-01-24 10:38:08'),
(1266,	76,	101,	NULL,	'2019-EA15-AF2 -hgfhfgcg- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	78,	NULL,	NULL,	NULL,	'2020-01-24 10:38:39',	'2020-01-24 10:38:39'),
(1267,	85,	538,	NULL,	'2020- EA15 -anwar- External audit created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	31,	NULL,	NULL,	NULL,	NULL,	'2020-01-24 10:53:28',	'2020-01-24 10:53:28'),
(1268,	76,	538,	NULL,	'2020-EA15-AF20 -external audit filter finding 1- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	79,	NULL,	NULL,	NULL,	'2020-01-24 10:54:49',	'2020-01-24 10:54:49'),
(1269,	76,	538,	NULL,	'2020-EA15-AF21 -external audit filter finding 2- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	80,	NULL,	NULL,	NULL,	'2020-01-24 10:55:14',	'2020-01-24 10:55:14'),
(1270,	76,	538,	NULL,	'2020-EA15-AF22 -external audit filter finding 3- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	81,	NULL,	NULL,	NULL,	'2020-01-24 10:55:38',	'2020-01-24 10:55:38'),
(1271,	86,	538,	NULL,	'2016- EA15 -anwar- External audit updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	31,	NULL,	NULL,	NULL,	NULL,	'2020-01-24 10:56:45',	'2020-01-24 10:56:45'),
(1272,	46,	1,	NULL,	'Update By ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	231,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-24 11:07:16',	'2020-01-24 11:07:16'),
(1273,	46,	1,	NULL,	'Update By ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	361,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-24 16:08:44',	'2020-01-24 16:08:44'),
(1274,	46,	1,	NULL,	'Update By ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	361,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-24 16:09:08',	'2020-01-24 16:09:08'),
(1275,	86,	538,	NULL,	'2020- EA12 -EXternal audit finding 2- External audit updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	25,	NULL,	NULL,	NULL,	NULL,	'2020-01-25 10:48:15',	'2020-01-25 10:48:15'),
(1276,	85,	539,	NULL,	'2020- EA15 -xterna audit 25jn- External audit created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	32,	NULL,	NULL,	NULL,	NULL,	'2020-01-25 12:40:41',	'2020-01-25 12:40:41'),
(1277,	76,	539,	NULL,	'2020-EA15-AF20 -external indin by jn 2020- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	82,	NULL,	NULL,	NULL,	'2020-01-25 12:41:47',	'2020-01-25 12:41:47'),
(1278,	77,	539,	NULL,	'2020-EA15-AF20 -external indin by jn 2020- Audit finding updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	82,	NULL,	NULL,	NULL,	'2020-01-25 12:43:11',	'2020-01-25 12:43:11'),
(1279,	76,	539,	NULL,	'2020-EA15-AF21 -findin g addded on jan 25- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	83,	NULL,	NULL,	NULL,	'2020-01-25 12:44:11',	'2020-01-25 12:44:11'),
(1280,	76,	539,	NULL,	'2020-EA15-AF22 -external audit jan 25 th- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	84,	NULL,	NULL,	NULL,	'2020-01-25 12:47:40',	'2020-01-25 12:47:40'),
(1281,	75,	539,	NULL,	'2020-EA15-AF22 -external audit jan 25 th- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	84,	NULL,	NULL,	NULL,	'2020-01-25 13:08:42',	'2020-01-25 13:08:42'),
(1282,	82,	539,	NULL,	'2020-EA15-AF22 -external audit jan 25 th- Corrective action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	84,	NULL,	NULL,	NULL,	'2020-01-25 13:12:46',	'2020-01-25 13:12:46'),
(1283,	84,	539,	NULL,	'2020-EA15-AF22-external audit jan 25 th Followup actions resolved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	84,	NULL,	NULL,	NULL,	'2020-01-25 13:27:08',	'2020-01-25 13:27:08'),
(1284,	30,	1,	NULL,	'Information management system- Compliance register updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-25 15:20:42',	'2020-01-25 15:20:42'),
(1285,	30,	1,	NULL,	'Information management system- Compliance register updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-25 15:22:40',	'2020-01-25 15:22:40'),
(1286,	63,	539,	NULL,	'2020- PR12 Tax Audit- Audit program created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	58,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-25 15:32:31',	'2020-01-25 15:32:31'),
(1287,	65,	527,	NULL,	'2020-PR12-AP18 -tax audit- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	111,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-25 15:35:05',	'2020-01-25 15:35:05'),
(1288,	66,	527,	NULL,	'2020-PR12-AP18 -tax audit- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	111,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-25 15:36:23',	'2020-01-25 15:36:23'),
(1289,	67,	527,	NULL,	'2020-PR12-AP18 -tax audit- Audit plan published',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	111,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-25 15:37:01',	'2020-01-25 15:37:01'),
(1290,	66,	527,	NULL,	'2020-PR12-AP18 -tax audit- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	111,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-25 15:41:03',	'2020-01-25 15:41:03'),
(1291,	65,	527,	NULL,	'2020-PR12-AP19 -jan25- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	112,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-25 15:41:56',	'2020-01-25 15:41:56'),
(1292,	67,	527,	NULL,	'2020-PR12-AP19 -jan25- Audit plan published',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	112,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-25 15:42:39',	'2020-01-25 15:42:39'),
(1293,	70,	538,	NULL,	'2020-PR12-AP18 -tax audit- Audit plan accepted',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	111,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-25 15:47:21',	'2020-01-25 15:47:21'),
(1294,	68,	527,	NULL,	'#A70-tax audit- Audit  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	70,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-25 15:52:33',	'2020-01-25 15:52:33'),
(1295,	69,	527,	NULL,	'#A70-tax audit- Audit updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	70,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-25 15:53:27',	'2020-01-25 15:53:27'),
(1296,	76,	527,	NULL,	'2020-IA70-AF22 -interna indin jan 25- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	85,	NULL,	NULL,	NULL,	'2020-01-25 15:55:31',	'2020-01-25 15:55:31'),
(1297,	76,	527,	NULL,	'2020-IA70-AF23 -interna indin jan 25-second- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	86,	NULL,	NULL,	NULL,	'2020-01-25 15:56:14',	'2020-01-25 15:56:14'),
(1298,	76,	527,	NULL,	'2020-IA70-AF24 -interndda indin jan 25-thirdd- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	87,	NULL,	NULL,	NULL,	'2020-01-25 15:59:47',	'2020-01-25 15:59:47'),
(1299,	76,	527,	NULL,	'2020-IA70-AF25 -interna indin jan 25-fourth- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	88,	NULL,	NULL,	NULL,	'2020-01-25 16:00:47',	'2020-01-25 16:00:47'),
(1300,	76,	527,	NULL,	'2020-IA70-AF26 -interna indin jan 25-ofi- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	89,	NULL,	NULL,	NULL,	'2020-01-25 16:01:33',	'2020-01-25 16:01:33'),
(1301,	76,	527,	NULL,	'2020-IA70-AF27 -interna indin jan 25-discrded- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	90,	NULL,	NULL,	NULL,	'2020-01-25 16:03:00',	'2020-01-25 16:03:00'),
(1302,	71,	527,	NULL,	'#A 70tax audit- Audit report submit for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	70,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-25 16:05:20',	'2020-01-25 16:05:20'),
(1303,	71,	527,	NULL,	'#A 70tax audit- Audit report submit for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	70,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-25 16:05:50',	'2020-01-25 16:05:50'),
(1304,	46,	1,	NULL,	'Update By ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	61,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-26 14:09:18',	'2020-01-26 14:09:18'),
(1305,	46,	1,	NULL,	'Update By ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	61,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-26 14:17:42',	'2020-01-26 14:17:42'),
(1306,	17,	539,	NULL,	'2020- PR82 Quality management meeting- MRM Program updated',	NULL,	NULL,	NULL,	82,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-27 13:01:20',	'2020-01-27 13:01:20'),
(1307,	24,	538,	NULL,	'2020-A-49 fsdf- MRM meeting action updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	49,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-27 13:14:15',	'2020-01-27 13:14:15'),
(1308,	25,	538,	NULL,	'2020-A -49 fsdf-MRM meeting action status updated to Closed ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	49,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-27 13:14:38',	'2020-01-27 13:14:38'),
(1309,	46,	1,	NULL,	'Update By ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	297,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-27 14:59:04',	'2020-01-27 14:59:04'),
(1310,	14,	1,	NULL,	'CSS-II-0001- Context updated',	NULL,	NULL,	46,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-28 09:39:26',	'2020-01-28 09:39:26'),
(1311,	14,	1,	NULL,	'BGS-II-0001- Context updated',	NULL,	NULL,	46,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-28 09:42:53',	'2020-01-28 09:42:53'),
(1312,	15,	1,	NULL,	'BGS-II-0001- Context Reviewed',	NULL,	NULL,	46,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-28 09:43:08',	'2020-01-28 09:43:08'),
(1313,	37,	1,	NULL,	'BGS-II-0001- Context closed',	NULL,	NULL,	46,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-28 09:43:33',	'2020-01-28 09:43:33'),
(1314,	94,	1,	NULL,	'BGS-II-0001- Context reopened',	NULL,	NULL,	46,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-28 09:43:56',	'2020-01-28 09:43:56'),
(1315,	15,	1,	NULL,	'BGS-II-0001- Context Reviewed',	NULL,	NULL,	46,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-28 09:44:13',	'2020-01-28 09:44:13'),
(1316,	37,	1,	NULL,	'BGS-II-0001- Context closed',	NULL,	NULL,	46,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-28 09:44:22',	'2020-01-28 09:44:22'),
(1317,	31,	1,	NULL,	'HSE Management System Legal and other requirements - TRA Dubai- Compliance register reviewed',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 09:28:27',	'2020-01-29 09:28:27'),
(1318,	4,	61,	NULL,	'issue- Document Rejected review user',	28,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 11:00:34',	'2020-01-29 11:00:34'),
(1319,	88,	1,	NULL,	'issue- Document submit for review',	28,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 11:01:10',	'2020-01-29 11:01:10'),
(1320,	3,	61,	NULL,	'issue- Document reviewed',	28,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 11:03:15',	'2020-01-29 11:03:15'),
(1321,	88,	61,	NULL,	'issue- Document submit for review',	28,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 11:03:16',	'2020-01-29 11:03:16'),
(1322,	5,	1,	NULL,	'issue- Document Rejected  by approving user',	28,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 11:03:58',	'2020-01-29 11:03:58'),
(1323,	88,	1,	NULL,	'issue- Document submit for review',	28,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 11:04:04',	'2020-01-29 11:04:04'),
(1324,	13,	1,	NULL,	'BGS-II-0067- Context created',	NULL,	NULL,	47,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 11:19:41',	'2020-01-29 11:19:41'),
(1325,	15,	1,	NULL,	'BGS-II-0067- Context Reviewed',	NULL,	NULL,	47,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 11:20:12',	'2020-01-29 11:20:12'),
(1326,	37,	1,	NULL,	'BGS-II-0067- Context closed',	NULL,	NULL,	47,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 11:20:31',	'2020-01-29 11:20:31'),
(1327,	94,	1,	NULL,	'BGS-II-0067- Context reopened',	NULL,	NULL,	47,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 11:21:00',	'2020-01-29 11:21:00'),
(1328,	15,	1,	NULL,	'BGS-II-0067- Context Reviewed',	NULL,	NULL,	47,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 11:32:55',	'2020-01-29 11:32:55'),
(1329,	51,	1,	NULL,	'BGS-R-0012- Risk Context created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	49,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 11:36:55',	'2020-01-29 11:36:55'),
(1330,	53,	1,	NULL,	'BGS-R-0012- Risk Assessment created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	49,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 11:38:09',	'2020-01-29 11:38:09'),
(1331,	55,	1,	NULL,	'BGS-R-0012- Risk Treatment created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	49,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 11:38:46',	'2020-01-29 11:38:46'),
(1332,	57,	1,	NULL,	'BGS-R-0012- Risk treatment submitted for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	49,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 11:38:53',	'2020-01-29 11:38:53'),
(1333,	58,	1,	NULL,	'BGS-R-0012- Risk treatment review approved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	49,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 11:39:29',	'2020-01-29 11:39:29'),
(1334,	56,	1,	NULL,	'BGS-R-0012- Risk Treatment updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	49,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 11:39:57',	'2020-01-29 11:39:57'),
(1335,	60,	1,	NULL,	'BGS-R-0012- Risk treatment submitted for close',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	49,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 11:40:08',	'2020-01-29 11:40:08'),
(1336,	61,	1,	NULL,	'BGS-R-0012- Risk treatment  approved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	49,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 11:40:18',	'2020-01-29 11:40:18'),
(1337,	51,	1,	NULL,	'BGS-R-0013- Risk Context created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	50,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 11:41:52',	'2020-01-29 11:41:52'),
(1338,	53,	1,	NULL,	'BGS-R-0013- Risk Assessment created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	50,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 11:42:21',	'2020-01-29 11:42:21'),
(1339,	55,	1,	NULL,	'BGS-R-0013- Risk Treatment created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	50,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 11:43:55',	'2020-01-29 11:43:55'),
(1340,	57,	1,	NULL,	'BGS-R-0013- Risk treatment submitted for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	50,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 11:44:01',	'2020-01-29 11:44:01'),
(1341,	58,	1,	NULL,	'BGS-R-0013- Risk treatment review approved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	50,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 11:44:05',	'2020-01-29 11:44:05'),
(1342,	60,	1,	NULL,	'BGS-R-0013- Risk treatment submitted for close',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	50,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 11:44:08',	'2020-01-29 11:44:08'),
(1343,	61,	1,	NULL,	'BGS-R-0013- Risk treatment  approved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	50,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 11:44:13',	'2020-01-29 11:44:13'),
(1344,	16,	8,	NULL,	'2020- PR83 Health & safty review meeting- MRM Program created',	NULL,	NULL,	NULL,	83,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 13:52:15',	'2020-01-29 13:52:15'),
(1345,	18,	8,	NULL,	'2020-PR83-MP66 -test- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	66,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 13:53:59',	'2020-01-29 13:53:59'),
(1346,	19,	8,	NULL,	'2020-PR83-MP66 -test- MRM Plan updated',	NULL,	NULL,	NULL,	NULL,	66,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 13:56:56',	'2020-01-29 13:56:56'),
(1347,	20,	8,	NULL,	'test- MRM Plan published',	NULL,	NULL,	NULL,	NULL,	66,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 14:47:20',	'2020-01-29 14:47:20'),
(1348,	21,	8,	NULL,	'2020-M44 -test- MRM meeting created',	NULL,	NULL,	NULL,	NULL,	NULL,	44,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 14:54:01',	'2020-01-29 14:54:01'),
(1349,	23,	8,	NULL,	'2020-A-50- Action- MRM meeting action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	50,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 14:55:25',	'2020-01-29 14:55:25'),
(1350,	63,	8,	NULL,	'2020- PR13 Special Audit- Audit program created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	59,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 15:22:57',	'2020-01-29 15:22:57'),
(1351,	63,	8,	NULL,	'2020- PR13 Special Audit- Audit program created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	60,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 15:35:00',	'2020-01-29 15:35:00'),
(1352,	38,	8,	NULL,	'Percentage of functional happiness- Strategy plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	125,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 15:59:27',	'2020-01-29 15:59:27'),
(1353,	65,	8,	NULL,	'2020-PR13-AP20 -- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	113,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 16:19:57',	'2020-01-29 16:19:57'),
(1354,	67,	8,	NULL,	'2020-PR13-AP20 -test audit- Audit plan published',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	113,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 16:20:22',	'2020-01-29 16:20:22'),
(1355,	66,	8,	NULL,	'2020-PR13-AP20 -test audit- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	113,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 16:20:22',	'2020-01-29 16:20:22'),
(1356,	14,	1,	NULL,	'DEV-II-0001- Context updated',	NULL,	NULL,	33,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 16:20:23',	'2020-01-29 16:20:23'),
(1357,	65,	8,	NULL,	'2020-PR13-AP20 -test audit- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	114,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 16:21:21',	'2020-01-29 16:21:21'),
(1358,	66,	8,	NULL,	'2020-PR13-AP20 -test audit- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	114,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-29 16:21:28',	'2020-01-29 16:21:28'),
(1359,	63,	539,	NULL,	'2020- PR14 Special Audit- Audit program created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	61,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-30 09:06:06',	'2020-01-30 09:06:06'),
(1360,	65,	527,	NULL,	'2020-PR14-AP21 -Special audit- Audit plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	115,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-30 13:52:25',	'2020-01-30 13:52:25'),
(1361,	66,	527,	NULL,	'2020-PR14-AP21 -Special audit- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	115,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-30 13:56:23',	'2020-01-30 13:56:23'),
(1362,	66,	527,	NULL,	'2020-PR14-AP21 -Special audit- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	115,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-30 13:57:17',	'2020-01-30 13:57:17'),
(1363,	66,	527,	NULL,	'2020-PR14-AP21 -Special audit- Audit plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	115,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-30 13:57:22',	'2020-01-30 13:57:22'),
(1364,	67,	527,	NULL,	'2020-PR14-AP21 -Special audit- Audit plan published',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	115,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-30 14:02:20',	'2020-01-30 14:02:20'),
(1365,	70,	46,	NULL,	'2020-PR14-AP21 -Special audit- Audit plan accepted',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	115,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-30 14:48:21',	'2020-01-30 14:48:21'),
(1366,	68,	527,	NULL,	'#A71-Special audit- Audit  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	71,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-31 08:50:38',	'2020-01-31 08:50:38'),
(1367,	76,	527,	NULL,	'2020-IA71-AF28 -Finding 1- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	91,	NULL,	NULL,	NULL,	'2020-01-31 09:20:48',	'2020-01-31 09:20:48'),
(1368,	71,	527,	NULL,	'#A 71Special audit- Audit report submit for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	71,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-31 09:30:35',	'2020-01-31 09:30:35'),
(1369,	73,	69,	NULL,	'#A 71Special audit- Audit report submit for review rejected',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	71,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-31 09:52:21',	'2020-01-31 09:52:21'),
(1370,	71,	527,	NULL,	'#A 71Special audit- Audit report submit for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	71,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-31 09:55:53',	'2020-01-31 09:55:53'),
(1371,	72,	69,	NULL,	'#A 71Special audit- Audit report submit for review accepted',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	71,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-31 09:59:03',	'2020-01-31 09:59:03'),
(1372,	75,	8,	NULL,	'2020-IA-AF28 -Finding 1- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	91,	NULL,	NULL,	NULL,	'2020-01-31 10:11:54',	'2020-01-31 10:11:54'),
(1373,	84,	8,	NULL,	'2020-IA71-AF28 -Finding 1- Followup actions resolved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	91,	NULL,	NULL,	NULL,	'2020-01-31 10:15:10',	'2020-01-31 10:15:10'),
(1374,	93,	527,	NULL,	'2020-IA71-AF28 -Finding 1- Followup actions rejected',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	91,	NULL,	NULL,	NULL,	'2020-01-31 10:22:02',	'2020-01-31 10:22:02'),
(1375,	84,	8,	NULL,	'2020-IA71-AF28 -Finding 1- Followup actions resolved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	91,	NULL,	NULL,	NULL,	'2020-01-31 10:35:10',	'2020-01-31 10:35:10'),
(1376,	92,	527,	NULL,	'2020-IA71-AF28 -Finding 1- Followup actions accepted',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	91,	NULL,	NULL,	NULL,	'2020-01-31 10:36:06',	'2020-01-31 10:36:06'),
(1377,	92,	8,	NULL,	'2020-IA71-AF28 -Finding 1- Followup actions accepted',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	91,	NULL,	NULL,	NULL,	'2020-01-31 10:37:54',	'2020-01-31 10:37:54'),
(1378,	75,	8,	NULL,	'2020-IA-AF26 -interna indin jan 25-ofi- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	89,	NULL,	NULL,	NULL,	'2020-01-31 10:41:23',	'2020-01-31 10:41:23'),
(1379,	85,	46,	NULL,	'2020- EA16 -External audit 2020- External audit created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	33,	NULL,	NULL,	NULL,	NULL,	'2020-01-31 10:47:15',	'2020-01-31 10:47:15'),
(1380,	76,	8,	NULL,	'2020-EA16-AF23 -Finding 2- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	92,	NULL,	NULL,	NULL,	'2020-01-31 12:16:41',	'2020-01-31 12:16:41'),
(1381,	75,	8,	NULL,	'2020-EA16-AF23 -Finding 2- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	92,	NULL,	NULL,	NULL,	'2020-01-31 12:18:07',	'2020-01-31 12:18:07'),
(1382,	84,	8,	NULL,	'2020-EA16-AF23-Finding 2 Followup actions resolved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	92,	NULL,	NULL,	NULL,	'2020-01-31 12:21:49',	'2020-01-31 12:21:49'),
(1383,	14,	1,	NULL,	'IMS-EI-0004- Context updated',	NULL,	NULL,	42,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-31 13:36:10',	'2020-01-31 13:36:10'),
(1384,	15,	1,	NULL,	'IMS-EI-0004- Context Reviewed',	NULL,	NULL,	42,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-31 13:36:17',	'2020-01-31 13:36:17'),
(1385,	37,	1,	NULL,	'IMS-EI-0068- Context closed',	NULL,	NULL,	48,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-31 13:40:13',	'2020-01-31 13:40:13'),
(1386,	13,	1,	NULL,	'new-II-0001- Context created',	NULL,	NULL,	49,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-31 14:20:39',	'2020-01-31 14:20:39'),
(1387,	14,	1,	NULL,	'new-II-0001- Context updated',	NULL,	NULL,	49,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-31 14:20:50',	'2020-01-31 14:20:50'),
(1388,	16,	1,	NULL,	'2020- PR86 Quality management meeting- MRM Program created',	NULL,	NULL,	NULL,	86,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-03 08:15:02',	'2020-02-03 08:15:02'),
(1389,	18,	65,	NULL,	'2020-PR86-MP67 -Tariq -user -MRM- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	67,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-03 08:22:26',	'2020-02-03 08:22:26'),
(1390,	20,	65,	NULL,	'Tariq -user -MRM- MRM Plan published',	NULL,	NULL,	NULL,	NULL,	67,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-03 08:23:40',	'2020-02-03 08:23:40'),
(1391,	21,	65,	NULL,	'2020-M45 -Tariq -user -MRM- MRM meeting created',	NULL,	NULL,	NULL,	NULL,	NULL,	45,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-03 08:37:13',	'2020-02-03 08:37:13'),
(1392,	23,	1,	NULL,	'2020-A-51- Action 1- MRM meeting action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	51,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-03 08:46:41',	'2020-02-03 08:46:41'),
(1393,	25,	1,	NULL,	'2020-A -51 Action 1-MRM meeting action status updated to On Hold ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	51,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-03 08:48:00',	'2020-02-03 08:48:00'),
(1394,	23,	1,	NULL,	'2020-A-52- Action 2--meeting Tariq- MRM meeting action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	52,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-03 08:49:54',	'2020-02-03 08:49:54'),
(1395,	25,	1,	NULL,	'2020-A -52 Action 2--meeting Tariq-MRM meeting action status updated to On Hold ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	52,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-03 09:17:13',	'2020-02-03 09:17:13'),
(1396,	90,	65,	NULL,	'2020-M45 -Tariq -user -MRM- Meeting report published',	NULL,	NULL,	NULL,	NULL,	NULL,	45,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-03 09:22:15',	'2020-02-03 09:22:15'),
(1397,	13,	1,	NULL,	'BGS-II-0069- Context created',	NULL,	NULL,	50,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-03 09:37:50',	'2020-02-03 09:37:50'),
(1398,	15,	1,	NULL,	'BGS-II-0069- Context Reviewed',	NULL,	NULL,	50,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-03 09:39:57',	'2020-02-03 09:39:57'),
(1399,	37,	1,	NULL,	'BGS-II-0069- Context closed',	NULL,	NULL,	50,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-03 09:53:49',	'2020-02-03 09:53:49'),
(1400,	51,	1,	NULL,	'BGS-R-0014- Risk Context created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	51,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-03 10:21:30',	'2020-02-03 10:21:30'),
(1401,	53,	1,	NULL,	'BGS-R-0014- Risk Assessment created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	51,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-03 10:26:05',	'2020-02-03 10:26:05'),
(1402,	55,	1,	NULL,	'BGS-R-0014- Risk Treatment created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	51,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-03 10:26:56',	'2020-02-03 10:26:56'),
(1403,	55,	1,	NULL,	'BGS-R-0014- Risk Treatment created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	51,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-03 10:27:32',	'2020-02-03 10:27:32'),
(1404,	57,	1,	NULL,	'BGS-R-0014- Risk treatment submitted for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	51,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-03 10:28:14',	'2020-02-03 10:28:14'),
(1405,	59,	297,	NULL,	'BGS-R-0014- Risk treatment review rejected',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	51,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-03 10:35:05',	'2020-02-03 10:35:05'),
(1406,	57,	1,	NULL,	'BGS-R-0014- Risk treatment submitted for review',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	51,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-03 10:37:34',	'2020-02-03 10:37:34'),
(1407,	58,	297,	NULL,	'BGS-R-0014- Risk treatment review approved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	51,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-03 10:43:49',	'2020-02-03 10:43:49'),
(1408,	60,	1,	NULL,	'BGS-R-0014- Risk treatment submitted for close',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	51,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-03 10:48:47',	'2020-02-03 10:48:47'),
(1409,	62,	1,	NULL,	'BGS-R-0014- Risk treatment  rejected',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	51,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-03 11:00:11',	'2020-02-03 11:00:11'),
(1410,	60,	1,	NULL,	'BGS-R-0014- Risk treatment submitted for close',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	51,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-03 11:02:41',	'2020-02-03 11:02:41'),
(1411,	45,	1,	NULL,	'New user Linu Mathew  created ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	542,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-03 12:30:10',	'2020-02-03 12:30:10'),
(1412,	46,	1,	NULL,	'Update By ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	542,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-03 12:34:54',	'2020-02-03 12:34:54'),
(1413,	14,	1,	NULL,	'PPD-II-0065- Context updated',	NULL,	NULL,	36,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-04 08:10:03',	'2020-02-04 08:10:03'),
(1414,	14,	1,	NULL,	'IMS-EI-0001- Context updated',	NULL,	NULL,	39,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-04 08:45:28',	'2020-02-04 08:45:28'),
(1415,	1,	1,	NULL,	'sample 21- Document created',	45,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-05 14:45:46',	'2020-02-05 14:45:46'),
(1416,	46,	1,	NULL,	'Update By ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	528,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-06 08:34:42',	'2020-02-06 08:34:42'),
(1417,	75,	1,	NULL,	'2020-EA15-AF21 -findin g addded on jan 25- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	83,	NULL,	NULL,	NULL,	'2020-02-06 10:11:53',	'2020-02-06 10:11:53'),
(1418,	82,	1,	NULL,	'2020-EA15-AF21 -findin g addded on jan 25- Corrective action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	83,	NULL,	NULL,	NULL,	'2020-02-06 10:12:48',	'2020-02-06 10:12:48'),
(1419,	83,	1,	NULL,	'2020-EA15-AF21 -findin g addded on jan 25- Corrective action updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	83,	NULL,	NULL,	NULL,	'2020-02-06 10:14:35',	'2020-02-06 10:14:35'),
(1420,	38,	1,	NULL,	'Percentage of consumer disputes received by the Authority from the total subscriber base of telecommunications services in the country.- Strategy plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	126,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-06 10:29:48',	'2020-02-06 10:29:48'),
(1421,	51,	1,	NULL,	'IMS-O-0006- Risk Context created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	53,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-06 10:32:02',	'2020-02-06 10:32:02'),
(1422,	47,	1,	NULL,	'External Audit finding testing user- KM internal document created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	46,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-06 10:35:00',	'2020-02-06 10:35:00'),
(1423,	29,	1,	NULL,	'New document for test- Compliance register created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	12,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-06 10:36:54',	'2020-02-06 10:36:54'),
(1424,	45,	1,	NULL,	'New user Department adding  created ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	543,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-06 10:40:31',	'2020-02-06 10:40:31'),
(1425,	46,	1,	NULL,	'Update By ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-06 11:06:53',	'2020-02-06 11:06:53'),
(1426,	47,	1,	NULL,	'ISO 45001 OHSMS- KM internal document created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	47,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-06 12:55:01',	'2020-02-06 12:55:01'),
(1427,	49,	1,	NULL,	'test- KM External Documents created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	48,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-06 12:56:36',	'2020-02-06 12:56:36'),
(1428,	94,	1,	NULL,	'IMS-EI-0068- Context reopened',	NULL,	NULL,	48,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-07 09:30:19',	'2020-02-07 09:30:19'),
(1429,	15,	1,	NULL,	'IMS-EI-0068- Context Reviewed',	NULL,	NULL,	48,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-07 09:36:28',	'2020-02-07 09:36:28'),
(1430,	14,	1,	NULL,	'IMS-EI-0068- Context updated',	NULL,	NULL,	48,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-07 09:36:53',	'2020-02-07 09:36:53'),
(1431,	15,	1,	NULL,	'IMS-II-0069- Context Reviewed',	NULL,	NULL,	50,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-07 09:52:08',	'2020-02-07 09:52:08'),
(1432,	14,	1,	NULL,	'IMS-II-0069- Context updated',	NULL,	NULL,	50,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-07 09:55:00',	'2020-02-07 09:55:00'),
(1433,	75,	538,	NULL,	'2020-IA-AF26 -interna indin jan 25-ofi- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	89,	NULL,	NULL,	NULL,	'2020-02-10 10:16:10',	'2020-02-10 10:16:10'),
(1434,	75,	8,	NULL,	'2020-EA15-AF21 -findin g addded on jan 25- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	83,	NULL,	NULL,	NULL,	'2020-02-10 10:40:49',	'2020-02-10 10:40:49'),
(1435,	82,	8,	NULL,	'2020-IA70-AF25 -interna indin jan 25-fourth- Corrective action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	88,	NULL,	NULL,	NULL,	'2020-02-10 11:04:53',	'2020-02-10 11:04:53'),
(1436,	83,	8,	NULL,	'2020-IA70-AF25 -interna indin jan 25-fourth- Corrective action updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	88,	NULL,	NULL,	NULL,	'2020-02-10 11:05:11',	'2020-02-10 11:05:11'),
(1437,	83,	8,	NULL,	'2020-IA70-AF25 -interna indin jan 25-fourth- Corrective action updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	88,	NULL,	NULL,	NULL,	'2020-02-10 11:07:01',	'2020-02-10 11:07:01'),
(1438,	82,	538,	NULL,	'2020-IA69-AF20 -finding filter3- Corrective action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	73,	NULL,	NULL,	NULL,	'2020-02-10 11:38:20',	'2020-02-10 11:38:20'),
(1439,	27,	8,	NULL,	'PROFILE- Business profile updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-10 14:58:56',	'2020-02-10 14:58:56'),
(1440,	82,	538,	NULL,	'2020-IA70-AF24 -interndda indin jan 25-thirdd- Corrective action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	87,	NULL,	NULL,	NULL,	'2020-02-10 17:22:23',	'2020-02-10 17:22:23'),
(1441,	46,	1,	NULL,	'Update By ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	538,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-14 10:59:08',	'2020-02-14 10:59:08'),
(1442,	18,	538,	NULL,	'2020-PR82-MP68 -test- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	68,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-14 11:21:36',	'2020-02-14 11:21:36'),
(1443,	46,	1,	NULL,	'Update By ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	513,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-14 11:23:01',	'2020-02-14 11:23:01'),
(1444,	20,	538,	NULL,	'test- MRM Plan published',	NULL,	NULL,	NULL,	NULL,	68,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-14 11:23:30',	'2020-02-14 11:23:30'),
(1445,	21,	538,	NULL,	'2020-M46 -test- MRM meeting created',	NULL,	NULL,	NULL,	NULL,	NULL,	46,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-14 11:24:34',	'2020-02-14 11:24:34'),
(1446,	22,	538,	NULL,	'2020-M43 -mrm PLANN- MRM meeting updated',	NULL,	NULL,	NULL,	NULL,	NULL,	43,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-14 12:25:58',	'2020-02-14 12:25:58'),
(1447,	1,	1,	NULL,	'testing 2/17- Document created',	49,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-17 10:05:26',	'2020-02-17 10:05:26'),
(1448,	19,	1,	NULL,	'2020-PR86-MP67 -Tariq -user -MRM- MRM Plan updated',	NULL,	NULL,	NULL,	NULL,	67,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-19 10:40:33',	'2020-02-19 10:40:33'),
(1449,	18,	1,	NULL,	'2020-PR87-MP69 -QMS Managemetn Review- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	69,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-19 10:46:32',	'2020-02-19 10:46:32'),
(1450,	21,	1,	NULL,	'2020-M47 -QMS Managemetn Review- MRM meeting created',	NULL,	NULL,	NULL,	NULL,	NULL,	47,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-19 11:09:52',	'2020-02-19 11:09:52'),
(1451,	90,	1,	NULL,	'2020-M47 -QMS Managemetn Review- Meeting report published',	NULL,	NULL,	NULL,	NULL,	NULL,	47,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-19 11:49:35',	'2020-02-19 11:49:35'),
(1452,	17,	1,	NULL,	'2020- PR87 Quality management meeting- MRM Program updated',	NULL,	NULL,	NULL,	87,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-19 12:26:33',	'2020-02-19 12:26:33'),
(1453,	85,	527,	NULL,	'2020- EA17 -Externsl audit 24-2-2020- External audit created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	34,	NULL,	NULL,	NULL,	NULL,	'2020-02-24 12:23:01',	'2020-02-24 12:23:01'),
(1454,	86,	527,	NULL,	'2020- EA17 -Externsl audit 24-2-2020- External audit updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	34,	NULL,	NULL,	NULL,	NULL,	'2020-02-24 12:24:16',	'2020-02-24 12:24:16'),
(1455,	76,	541,	NULL,	'2020-EA17-AF24 -finding 24-2-2020- Audit finding created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	93,	NULL,	NULL,	NULL,	'2020-02-24 12:27:09',	'2020-02-24 12:27:09'),
(1456,	77,	541,	NULL,	'2020-EA17-AF24 -finding 24-2-2020- Audit finding updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	93,	NULL,	NULL,	NULL,	'2020-02-24 12:33:01',	'2020-02-24 12:33:01'),
(1457,	75,	541,	NULL,	'2020-EA17-AF24 -finding 24-2-2020- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	93,	NULL,	NULL,	NULL,	'2020-02-24 12:33:50',	'2020-02-24 12:33:50'),
(1458,	78,	541,	NULL,	'2020-EA17-AF24 -finding 24-2-2020- Root cause analysis created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	93,	NULL,	NULL,	NULL,	'2020-02-24 12:35:05',	'2020-02-24 12:35:05'),
(1459,	80,	541,	NULL,	'2020-EA17-AF24 -finding 24-2-2020- Impact  analysis  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	93,	NULL,	NULL,	NULL,	'2020-02-24 12:36:04',	'2020-02-24 12:36:04'),
(1460,	82,	541,	NULL,	'2020-EA17-AF24 -finding 24-2-2020- Corrective action  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	93,	NULL,	NULL,	NULL,	'2020-02-24 12:36:56',	'2020-02-24 12:36:56'),
(1461,	83,	541,	NULL,	'2020-EA17-AF24 -finding 24-2-2020- Corrective action updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	93,	NULL,	NULL,	NULL,	'2020-02-24 12:37:05',	'2020-02-24 12:37:05'),
(1462,	84,	541,	NULL,	'2020-EA17-AF24-finding 24-2-2020 Followup actions resolved',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	93,	NULL,	NULL,	NULL,	'2020-02-24 12:38:09',	'2020-02-24 12:38:09'),
(1463,	38,	1,	NULL,	'As a result of the study of the dealers- Strategy plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	127,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-24 13:37:46',	'2020-02-24 13:37:46'),
(1464,	19,	8,	NULL,	'2020-PR69-MP53 -issuerettttttt- MRM Plan updated',	NULL,	NULL,	NULL,	NULL,	53,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-24 15:11:36',	'2020-02-24 15:11:36'),
(1465,	20,	8,	NULL,	'issuerettttttt- MRM Plan published',	NULL,	NULL,	NULL,	NULL,	53,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-24 15:11:44',	'2020-02-24 15:11:44'),
(1466,	21,	8,	NULL,	'2020-M48 -issuerettttttt- MRM meeting created',	NULL,	NULL,	NULL,	NULL,	NULL,	48,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-24 15:11:57',	'2020-02-24 15:11:57'),
(1467,	20,	8,	NULL,	'f- MRM Plan published',	NULL,	NULL,	NULL,	NULL,	43,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-24 15:13:30',	'2020-02-24 15:13:30'),
(1468,	21,	8,	NULL,	'2020-M49 -f- MRM meeting created',	NULL,	NULL,	NULL,	NULL,	NULL,	49,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-24 15:13:42',	'2020-02-24 15:13:42'),
(1469,	25,	8,	NULL,	'2020-A -51 Action 1-MRM meeting action status updated to Completed ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	51,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-24 15:30:46',	'2020-02-24 15:30:46'),
(1470,	18,	1,	NULL,	'2020-PR87-MP70 -Quality Management- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	70,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-25 08:55:02',	'2020-02-25 08:55:02'),
(1471,	20,	1,	NULL,	'Quality Management- MRM Plan published',	NULL,	NULL,	NULL,	NULL,	70,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-25 08:55:17',	'2020-02-25 08:55:17'),
(1472,	21,	1,	NULL,	'2020-M50 -Quality Management- MRM meeting created',	NULL,	NULL,	NULL,	NULL,	NULL,	50,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-25 08:56:34',	'2020-02-25 08:56:34'),
(1473,	19,	8,	NULL,	'2020-PR87-MP70 -Quality Management- MRM Plan updated',	NULL,	NULL,	NULL,	NULL,	70,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-25 10:37:14',	'2020-02-25 10:37:14'),
(1474,	19,	8,	NULL,	'2020-PR87-MP70 -Quality Management- MRM Plan updated',	NULL,	NULL,	NULL,	NULL,	70,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-25 10:43:57',	'2020-02-25 10:43:57'),
(1475,	53,	1,	NULL,	'BGS-O-0007- Risk Assessment created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	55,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-27 12:12:08',	'2020-02-27 12:12:08'),
(1476,	1,	8,	NULL,	'ddssdfdsf- Document created',	50,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-28 10:48:51',	'2020-02-28 10:48:51'),
(1477,	44,	8,	NULL,	'Happiness meter- Satisfaction report updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-28 12:44:16',	'2020-02-28 12:44:16'),
(1478,	44,	8,	NULL,	'Happiness meter- Satisfaction report updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-28 12:45:26',	'2020-02-28 12:45:26'),
(1479,	44,	8,	NULL,	'Happiness meter- Satisfaction report updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-28 12:46:11',	'2020-02-28 12:46:11'),
(1480,	19,	8,	NULL,	'2020-PR87-MP70 -Quality Management- MRM Plan updated',	NULL,	NULL,	NULL,	NULL,	70,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-28 14:51:11',	'2020-02-28 14:51:11'),
(1481,	19,	8,	NULL,	'2020-PR87-MP70 -Quality Management- MRM Plan updated',	NULL,	NULL,	NULL,	NULL,	70,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-28 14:51:31',	'2020-02-28 14:51:31'),
(1482,	15,	1,	NULL,	'BGS-II-0066- Context Reviewed',	NULL,	NULL,	45,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-03-04 08:06:17',	'2020-03-04 08:06:17'),
(1483,	37,	1,	NULL,	'BGS-II-0066- Context closed',	NULL,	NULL,	45,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-03-04 08:06:35',	'2020-03-04 08:06:35'),
(1484,	94,	1,	NULL,	'BGS-II-0066- Context reopened',	NULL,	NULL,	45,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-03-04 08:24:59',	'2020-03-04 08:24:59'),
(1485,	15,	1,	NULL,	'IMS-II-0069- Context Reviewed',	NULL,	NULL,	50,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-03-04 12:59:09',	'2020-03-04 12:59:09'),
(1486,	7,	1,	NULL,	'ddssdfdsf- Change request created',	NULL,	36,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-03-05 12:25:56',	'2020-03-05 12:25:56'),
(1487,	2,	1,	NULL,	'sample 10- Document updated',	20,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-03-05 13:01:17',	'2020-03-05 13:01:17'),
(1488,	1,	1,	NULL,	'101 docs- Document created',	51,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-03-05 13:08:11',	'2020-03-05 13:08:11'),
(1489,	2,	1,	NULL,	'101 docs- Document updated',	51,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-03-05 13:13:24',	'2020-03-05 13:13:24'),
(1490,	1,	1,	NULL,	'101 second doc- Document created',	52,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-03-05 13:18:29',	'2020-03-05 13:18:29'),
(1491,	7,	1,	NULL,	'101 second doc- Change request created',	NULL,	37,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-03-05 13:20:58',	'2020-03-05 13:20:58'),
(1492,	53,	1,	NULL,	'IMS-R-0015- Risk Assessment created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	56,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-03-05 15:52:45',	'2020-03-05 15:52:45'),
(1493,	55,	1,	NULL,	'IMS-R-0015- Risk Treatment created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	56,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-03-05 15:53:34',	'2020-03-05 15:53:34'),
(1494,	53,	8,	NULL,	'IMS-R-0016- Risk Assessment created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	57,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-03-12 08:32:18',	'2020-03-12 08:32:18'),
(1495,	55,	8,	NULL,	'IMS-R-0016- Risk Treatment created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	57,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-03-12 08:33:01',	'2020-03-12 08:33:01'),
(1496,	56,	8,	NULL,	'IMS-R-0016- Risk Treatment updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	57,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-03-12 08:34:51',	'2020-03-12 08:34:51'),
(1497,	53,	1,	NULL,	'IMS-R-0017- Risk Assessment created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	58,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-03-13 13:46:13',	'2020-03-13 13:46:13'),
(1498,	15,	1,	NULL,	'IMS-EI-0069- Context Reviewed',	NULL,	NULL,	50,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-04-16 18:03:28',	'2020-04-16 18:03:28'),
(1499,	25,	1,	NULL,	'2020-A -52 Action 1-MRM meeting action status updated to Closed ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	52,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-04-21 13:11:21',	'2020-04-21 13:11:21'),
(1500,	38,	1,	NULL,	' Retail Price Index- Strategy plan created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	128,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-04-23 09:00:04',	'2020-04-23 09:00:04'),
(1501,	46,	1,	NULL,	'Update By ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-04-23 09:03:24',	'2020-04-23 09:03:24'),
(1502,	39,	1,	NULL,	' Retail Price Index- Strategy plan updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	128,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-04-23 09:07:18',	'2020-04-23 09:07:18'),
(1503,	17,	1,	NULL,	'2020- PR87 Quality management meeting- MRM Program updated',	NULL,	NULL,	NULL,	87,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-05-07 14:42:57',	'2020-05-07 14:42:57'),
(1504,	18,	1,	NULL,	'2020-PR87-MP71 -test- MRM Plan created',	NULL,	NULL,	NULL,	NULL,	71,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-05-07 14:44:44',	'2020-05-07 14:44:44'),
(1505,	17,	1,	NULL,	'2020- PR87 Quality management meeting- MRM Program updated',	NULL,	NULL,	NULL,	87,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-05-07 14:45:39',	'2020-05-07 14:45:39'),
(1506,	46,	1,	NULL,	'Update By ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-06-15 11:52:18',	'2020-06-15 11:52:18'),
(1507,	46,	1,	NULL,	'Update By ',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-06-15 12:08:08',	'2020-06-15 12:08:08'),
(1508,	1,	1,	NULL,	'To approve test- Document created',	53,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-07-13 12:00:11',	'2020-07-13 12:00:11'),
(1509,	3,	537,	NULL,	'To approve test- Document reviewed',	53,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-07-13 12:07:33',	'2020-07-13 12:07:33'),
(1510,	1,	1,	NULL,	'approve test- Document created',	54,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-07-21 18:50:35',	'2020-07-21 18:50:35'),
(1511,	3,	79,	NULL,	'approve test- Document reviewed',	54,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-07-21 18:53:53',	'2020-07-21 18:53:53'),
(1512,	88,	79,	NULL,	'approve test- Document submit for review',	54,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-07-21 18:53:55',	'2020-07-21 18:53:55'),
(1513,	1,	8,	NULL,	'approve test- Document created',	55,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-07-21 19:25:02',	'2020-07-21 19:25:02'),
(1514,	75,	8,	NULL,	'2020-IA-AF23 -interna indin jan 25-second- Audit finding responsible user updated',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	86,	NULL,	NULL,	NULL,	'2020-07-28 13:54:31',	'2020-07-28 13:54:31'),
(1515,	80,	8,	NULL,	'2020-IA71-AF28 -Finding 1- Impact  analysis  created',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	91,	NULL,	NULL,	NULL,	'2020-09-24 08:08:12',	'2020-09-24 08:08:12');

DROP TABLE IF EXISTS `addresses`;
CREATE TABLE `addresses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `country_id` int(10) unsigned DEFAULT NULL,
  `type` tinyint(4) DEFAULT '1',
  `relationship` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `relative_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `street` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip` int(11) DEFAULT NULL,
  `mobile` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `land_phone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `addresses` (`id`, `user_id`, `country_id`, `type`, `relationship`, `relative_name`, `address`, `street`, `city`, `state`, `zip`, `mobile`, `land_phone`, `created_at`, `updated_at`, `deleted_at`, `status`) VALUES
(1,	1,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2018-10-03 14:34:42',	'2018-10-03 14:34:42',	NULL,	1),
(2,	1,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2018-10-03 14:34:42',	'2018-10-03 14:34:42',	NULL,	1),
(3,	2,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2018-10-10 09:44:39',	'2018-10-10 09:44:39',	NULL,	1),
(4,	2,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2018-10-10 09:44:39',	'2018-10-10 09:44:39',	NULL,	1),
(5,	90,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2018-10-15 03:54:05',	'2018-10-15 03:54:05',	NULL,	1),
(6,	90,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2018-10-15 03:54:05',	'2018-10-15 03:54:05',	NULL,	1),
(7,	91,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2018-10-15 08:37:38',	'2018-10-15 08:37:38',	NULL,	1),
(8,	91,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2018-10-15 08:37:38',	'2018-10-15 08:37:38',	NULL,	1),
(9,	85,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2018-10-26 09:26:57',	'2018-10-26 09:26:57',	NULL,	1),
(10,	85,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2018-10-26 09:26:57',	'2018-10-26 09:26:57',	NULL,	1),
(11,	92,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2018-10-29 10:53:59',	'2018-10-29 10:53:59',	NULL,	1),
(12,	92,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2018-10-29 10:53:59',	'2018-10-29 10:53:59',	NULL,	1),
(13,	93,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2018-10-30 03:45:37',	'2018-10-30 03:45:37',	NULL,	1),
(14,	93,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2018-10-30 03:45:37',	'2018-10-30 03:45:37',	NULL,	1),
(15,	94,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2018-10-30 03:47:51',	'2018-10-30 03:47:51',	NULL,	1),
(16,	94,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2018-10-30 03:47:51',	'2018-10-30 03:47:51',	NULL,	1),
(17,	4,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2018-11-19 08:56:50',	'2018-11-19 08:56:50',	NULL,	1),
(18,	4,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2018-11-19 08:56:50',	'2018-11-19 08:56:50',	NULL,	1),
(19,	95,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2018-11-19 09:11:43',	'2018-11-19 09:11:43',	NULL,	1),
(20,	95,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2018-11-19 09:11:43',	'2018-11-19 09:11:43',	NULL,	1),
(21,	96,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2018-11-19 09:12:49',	'2018-11-19 09:12:49',	NULL,	1),
(22,	96,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2018-11-19 09:12:49',	'2018-11-19 09:12:49',	NULL,	1),
(23,	97,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2018-12-10 04:43:17',	'2018-12-10 04:43:17',	NULL,	1),
(24,	97,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2018-12-10 04:43:17',	'2018-12-10 04:43:17',	NULL,	1),
(25,	8,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2018-12-16 04:03:57',	'2018-12-16 04:03:57',	NULL,	1),
(26,	8,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2018-12-16 04:03:57',	'2018-12-16 04:03:57',	NULL,	1),
(27,	31,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-02-06 05:35:05',	'2019-02-06 05:35:05',	NULL,	1),
(28,	31,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-02-06 05:35:05',	'2019-02-06 05:35:05',	NULL,	1),
(29,	58,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-03 05:21:04',	'2019-03-03 05:21:04',	NULL,	1),
(30,	58,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-03 05:21:04',	'2019-03-03 05:21:04',	NULL,	1),
(31,	71,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-03 05:22:31',	'2019-03-03 05:22:31',	NULL,	1),
(32,	71,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-03 05:22:31',	'2019-03-03 05:22:31',	NULL,	1),
(33,	68,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-03 05:25:05',	'2019-03-03 05:25:05',	NULL,	1),
(34,	68,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-03 05:25:05',	'2019-03-03 05:25:05',	NULL,	1),
(35,	59,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-03 05:28:06',	'2019-03-03 05:28:06',	NULL,	1),
(36,	59,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-03 05:28:06',	'2019-03-03 05:28:06',	NULL,	1),
(37,	57,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-03 05:29:49',	'2019-03-03 05:29:49',	NULL,	1),
(38,	57,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-03 05:29:49',	'2019-03-03 05:29:49',	NULL,	1),
(39,	66,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-03 05:30:42',	'2019-03-03 05:30:42',	NULL,	1),
(40,	66,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-03 05:30:42',	'2019-03-03 05:30:42',	NULL,	1),
(41,	53,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-03 05:31:16',	'2019-03-03 05:31:16',	NULL,	1),
(42,	53,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-03 05:31:16',	'2019-03-03 05:31:16',	NULL,	1),
(43,	98,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-03 07:00:00',	'2019-03-03 07:00:00',	NULL,	1),
(44,	98,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-03 07:00:00',	'2019-03-03 07:00:00',	NULL,	1),
(45,	89,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-03 07:13:17',	'2019-03-03 07:13:17',	NULL,	1),
(46,	89,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-03 07:13:17',	'2019-03-03 07:13:17',	NULL,	1),
(47,	99,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-03 07:16:12',	'2019-03-03 07:16:12',	NULL,	1),
(48,	99,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-03 07:16:12',	'2019-03-03 07:16:12',	NULL,	1),
(49,	13,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-05 03:05:21',	'2019-03-05 03:05:21',	NULL,	1),
(50,	13,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-05 03:05:21',	'2019-03-05 03:05:21',	NULL,	1),
(51,	100,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-11 03:04:43',	'2019-03-11 03:04:43',	NULL,	1),
(52,	100,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-11 03:04:43',	'2019-03-11 03:04:43',	NULL,	1),
(53,	101,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-11 03:05:59',	'2019-03-11 03:05:59',	NULL,	1),
(54,	101,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-11 03:05:59',	'2019-03-11 03:05:59',	NULL,	1),
(55,	44,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-17 09:20:31',	'2019-03-17 09:20:31',	NULL,	1),
(56,	44,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-17 09:20:31',	'2019-03-17 09:20:31',	NULL,	1),
(57,	26,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-17 09:24:01',	'2019-03-17 09:24:01',	NULL,	1),
(58,	26,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-17 09:24:01',	'2019-03-17 09:24:01',	NULL,	1),
(59,	17,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-17 09:25:17',	'2019-03-17 09:25:17',	NULL,	1),
(60,	17,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-17 09:25:17',	'2019-03-17 09:25:17',	NULL,	1),
(61,	77,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-17 09:26:21',	'2019-03-17 09:26:21',	NULL,	1),
(62,	77,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-17 09:26:21',	'2019-03-17 09:26:21',	NULL,	1),
(63,	30,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-17 09:26:55',	'2019-03-17 09:26:55',	NULL,	1),
(64,	30,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-17 09:26:55',	'2019-03-17 09:26:55',	NULL,	1),
(65,	75,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-17 09:27:57',	'2019-03-17 09:27:57',	NULL,	1),
(66,	75,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-17 09:27:57',	'2019-03-17 09:27:57',	NULL,	1),
(67,	27,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-17 09:32:38',	'2019-03-17 09:32:38',	NULL,	1),
(68,	27,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-17 09:32:38',	'2019-03-17 09:32:38',	NULL,	1),
(69,	10,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-17 09:33:42',	'2019-03-17 09:33:42',	NULL,	1),
(70,	10,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-17 09:33:42',	'2019-03-17 09:33:42',	NULL,	1),
(71,	102,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-17 09:39:29',	'2019-03-17 09:39:29',	NULL,	1),
(72,	102,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-17 09:39:29',	'2019-03-17 09:39:29',	NULL,	1),
(73,	103,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-17 09:44:38',	'2019-03-17 09:44:38',	NULL,	1),
(74,	103,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-17 09:44:38',	'2019-03-17 09:44:38',	NULL,	1),
(75,	104,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-17 09:47:15',	'2019-03-17 09:47:15',	NULL,	1),
(76,	104,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-17 09:47:15',	'2019-03-17 09:47:15',	NULL,	1),
(77,	38,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-17 09:48:31',	'2019-03-17 09:48:31',	NULL,	1),
(78,	38,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-17 09:48:31',	'2019-03-17 09:48:31',	NULL,	1),
(79,	105,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-17 09:50:00',	'2019-03-17 09:50:00',	NULL,	1),
(80,	105,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-17 09:50:00',	'2019-03-17 09:50:00',	NULL,	1),
(81,	106,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-17 09:51:46',	'2019-03-17 09:51:46',	NULL,	1),
(82,	106,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-17 09:51:46',	'2019-03-17 09:51:46',	NULL,	1),
(83,	107,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-17 09:52:56',	'2019-03-17 09:52:56',	NULL,	1),
(84,	107,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-17 09:52:56',	'2019-03-17 09:52:56',	NULL,	1),
(85,	83,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-20 09:08:10',	'2019-03-20 09:08:10',	NULL,	1),
(86,	83,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-20 09:08:10',	'2019-03-20 09:08:10',	NULL,	1),
(87,	76,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-20 09:10:35',	'2019-03-20 09:10:35',	NULL,	1),
(88,	76,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-20 09:10:35',	'2019-03-20 09:10:35',	NULL,	1),
(89,	9,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-20 09:33:51',	'2019-03-20 09:33:51',	NULL,	1),
(90,	9,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-20 09:33:51',	'2019-03-20 09:33:51',	NULL,	1),
(91,	42,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-27 07:48:39',	'2019-03-27 07:48:39',	NULL,	1),
(92,	42,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-27 07:48:39',	'2019-03-27 07:48:39',	NULL,	1),
(93,	15,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-31 08:16:08',	'2019-03-31 08:16:08',	NULL,	1),
(94,	15,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-31 08:16:08',	'2019-03-31 08:16:08',	NULL,	1),
(95,	73,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-31 08:17:46',	'2019-03-31 08:17:46',	NULL,	1),
(96,	73,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-31 08:17:46',	'2019-03-31 08:17:46',	NULL,	1),
(97,	87,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-31 08:18:05',	'2019-03-31 08:18:05',	NULL,	1),
(98,	87,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-31 08:18:05',	'2019-03-31 08:18:05',	NULL,	1),
(99,	78,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-31 08:18:29',	'2019-03-31 08:18:29',	NULL,	1),
(100,	78,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-03-31 08:18:29',	'2019-03-31 08:18:29',	NULL,	1),
(101,	80,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-04-01 10:06:15',	'2019-04-01 10:06:15',	NULL,	1),
(102,	80,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-04-01 10:06:15',	'2019-04-01 10:06:15',	NULL,	1),
(103,	523,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-05-23 08:37:34',	'2019-05-23 08:37:34',	NULL,	1),
(105,	523,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-05-23 08:37:34',	'2019-05-23 08:37:34',	NULL,	1),
(107,	5,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-10 10:15:06',	'2019-06-10 10:15:06',	NULL,	1),
(109,	5,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-10 10:15:06',	'2019-06-10 10:15:06',	NULL,	1),
(111,	70,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-18 06:38:56',	'2019-06-18 06:38:56',	NULL,	1),
(113,	70,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-18 06:38:56',	'2019-06-18 06:38:56',	NULL,	1),
(115,	79,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-18 06:40:34',	'2019-06-18 06:40:34',	NULL,	1),
(117,	79,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-18 06:40:34',	'2019-06-18 06:40:34',	NULL,	1),
(119,	61,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 12:16:50',	'2019-06-19 12:16:50',	NULL,	1),
(121,	61,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 12:16:50',	'2019-06-19 12:16:50',	NULL,	1),
(123,	34,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:19:49',	'2019-06-19 13:19:49',	NULL,	1),
(125,	34,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:19:49',	'2019-06-19 13:19:49',	NULL,	1),
(127,	50,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:20:56',	'2019-06-19 13:20:56',	NULL,	1),
(129,	50,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:20:56',	'2019-06-19 13:20:56',	NULL,	1),
(131,	48,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:21:31',	'2019-06-19 13:21:31',	NULL,	1),
(133,	48,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:21:31',	'2019-06-19 13:21:31',	NULL,	1),
(135,	18,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:28:57',	'2019-06-19 13:28:57',	NULL,	1),
(137,	18,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:28:57',	'2019-06-19 13:28:57',	NULL,	1),
(139,	39,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:30:18',	'2019-06-19 13:30:18',	NULL,	1),
(141,	39,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:30:18',	'2019-06-19 13:30:18',	NULL,	1),
(143,	24,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:31:20',	'2019-06-19 13:31:20',	NULL,	1),
(145,	24,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:31:20',	'2019-06-19 13:31:20',	NULL,	1),
(147,	40,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:32:06',	'2019-06-19 13:32:06',	NULL,	1),
(149,	40,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:32:06',	'2019-06-19 13:32:06',	NULL,	1),
(151,	88,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:32:29',	'2019-06-19 13:32:29',	NULL,	1),
(153,	88,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:32:29',	'2019-06-19 13:32:29',	NULL,	1),
(155,	19,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:33:33',	'2019-06-19 13:33:33',	NULL,	1),
(157,	19,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:33:33',	'2019-06-19 13:33:33',	NULL,	1),
(159,	81,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:35:54',	'2019-06-19 13:35:54',	NULL,	1),
(161,	81,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:35:54',	'2019-06-19 13:35:54',	NULL,	1),
(163,	49,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:36:51',	'2019-06-19 13:36:51',	NULL,	1),
(165,	49,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:36:51',	'2019-06-19 13:36:51',	NULL,	1),
(167,	33,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:37:33',	'2019-06-19 13:37:33',	NULL,	1),
(169,	33,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:37:33',	'2019-06-19 13:37:33',	NULL,	1),
(171,	23,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:38:36',	'2019-06-19 13:38:36',	NULL,	1),
(173,	23,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:38:36',	'2019-06-19 13:38:36',	NULL,	1),
(175,	56,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:39:02',	'2019-06-19 13:39:02',	NULL,	1),
(177,	56,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:39:02',	'2019-06-19 13:39:02',	NULL,	1),
(179,	7,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:39:58',	'2019-06-19 13:39:58',	NULL,	1),
(181,	7,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:39:58',	'2019-06-19 13:39:58',	NULL,	1),
(183,	69,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:44:16',	'2019-06-19 13:44:16',	NULL,	1),
(185,	69,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:44:16',	'2019-06-19 13:44:16',	NULL,	1),
(187,	41,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:44:46',	'2019-06-19 13:44:46',	NULL,	1),
(189,	41,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:44:46',	'2019-06-19 13:44:46',	NULL,	1),
(191,	52,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:45:23',	'2019-06-19 13:45:23',	NULL,	1),
(193,	52,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:45:23',	'2019-06-19 13:45:23',	NULL,	1),
(195,	55,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:45:44',	'2019-06-19 13:45:44',	NULL,	1),
(197,	55,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:45:44',	'2019-06-19 13:45:44',	NULL,	1),
(199,	67,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:47:14',	'2019-06-19 13:47:14',	NULL,	1),
(201,	67,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:47:14',	'2019-06-19 13:47:14',	NULL,	1),
(203,	35,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:49:37',	'2019-06-19 13:49:37',	NULL,	1),
(205,	35,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:49:37',	'2019-06-19 13:49:37',	NULL,	1),
(207,	72,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:50:45',	'2019-06-19 13:50:45',	NULL,	1),
(209,	72,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:50:45',	'2019-06-19 13:50:45',	NULL,	1),
(211,	6,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:51:35',	'2019-06-19 13:51:35',	NULL,	1),
(213,	6,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:51:35',	'2019-06-19 13:51:35',	NULL,	1),
(215,	11,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:52:06',	'2019-06-19 13:52:06',	NULL,	1),
(217,	11,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:52:06',	'2019-06-19 13:52:06',	NULL,	1),
(219,	16,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:53:22',	'2019-06-19 13:53:22',	NULL,	1),
(221,	16,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:53:22',	'2019-06-19 13:53:22',	NULL,	1),
(223,	21,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:54:22',	'2019-06-19 13:54:22',	NULL,	1),
(225,	21,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:54:22',	'2019-06-19 13:54:22',	NULL,	1),
(227,	25,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:56:12',	'2019-06-19 13:56:12',	NULL,	1),
(229,	25,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:56:12',	'2019-06-19 13:56:12',	NULL,	1),
(231,	47,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:56:50',	'2019-06-19 13:56:50',	NULL,	1),
(233,	47,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:56:50',	'2019-06-19 13:56:50',	NULL,	1),
(235,	86,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:57:34',	'2019-06-19 13:57:34',	NULL,	1),
(237,	86,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:57:34',	'2019-06-19 13:57:34',	NULL,	1),
(239,	82,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:58:22',	'2019-06-19 13:58:22',	NULL,	1),
(241,	82,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 13:58:22',	'2019-06-19 13:58:22',	NULL,	1),
(243,	28,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 14:00:01',	'2019-06-19 14:00:01',	NULL,	1),
(245,	28,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 14:00:01',	'2019-06-19 14:00:01',	NULL,	1),
(247,	32,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 14:01:05',	'2019-06-19 14:01:05',	NULL,	1),
(249,	32,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 14:01:05',	'2019-06-19 14:01:05',	NULL,	1),
(251,	45,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 14:01:35',	'2019-06-19 14:01:35',	NULL,	1),
(253,	45,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 14:01:35',	'2019-06-19 14:01:35',	NULL,	1),
(255,	43,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 14:03:17',	'2019-06-19 14:03:17',	NULL,	1),
(257,	43,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 14:03:17',	'2019-06-19 14:03:17',	NULL,	1),
(259,	51,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 14:04:09',	'2019-06-19 14:04:09',	NULL,	1),
(261,	51,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 14:04:09',	'2019-06-19 14:04:09',	NULL,	1),
(263,	37,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 14:04:31',	'2019-06-19 14:04:31',	NULL,	1),
(265,	37,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 14:04:31',	'2019-06-19 14:04:31',	NULL,	1),
(267,	65,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 14:05:09',	'2019-06-19 14:05:09',	NULL,	1),
(269,	65,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 14:05:09',	'2019-06-19 14:05:09',	NULL,	1),
(271,	62,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 14:05:43',	'2019-06-19 14:05:43',	NULL,	1),
(273,	62,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 14:05:43',	'2019-06-19 14:05:43',	NULL,	1),
(275,	74,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 14:11:02',	'2019-06-19 14:11:02',	NULL,	1),
(277,	74,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 14:11:02',	'2019-06-19 14:11:02',	NULL,	1),
(279,	12,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 14:11:37',	'2019-06-19 14:11:37',	NULL,	1),
(281,	12,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 14:11:37',	'2019-06-19 14:11:37',	NULL,	1),
(283,	54,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 14:12:15',	'2019-06-19 14:12:15',	NULL,	1),
(285,	54,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 14:12:15',	'2019-06-19 14:12:15',	NULL,	1),
(287,	64,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 14:20:08',	'2019-06-19 14:20:08',	NULL,	1),
(289,	64,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 14:20:08',	'2019-06-19 14:20:08',	NULL,	1),
(291,	84,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 14:22:15',	'2019-06-19 14:22:15',	NULL,	1),
(293,	84,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 14:22:15',	'2019-06-19 14:22:15',	NULL,	1),
(295,	60,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 14:23:02',	'2019-06-19 14:23:02',	NULL,	1),
(297,	60,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 14:23:02',	'2019-06-19 14:23:02',	NULL,	1),
(299,	63,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 14:25:03',	'2019-06-19 14:25:03',	NULL,	1),
(301,	63,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-06-19 14:25:03',	'2019-06-19 14:25:03',	NULL,	1),
(302,	522,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-08-28 09:23:45',	'2019-08-28 09:23:45',	NULL,	1),
(303,	522,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-08-28 09:23:45',	'2019-08-28 09:23:45',	NULL,	1),
(304,	523,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-08-28 09:42:50',	'2019-08-28 09:42:50',	NULL,	1),
(305,	523,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-08-28 09:42:50',	'2019-08-28 09:42:50',	NULL,	1),
(306,	524,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-08-28 10:00:13',	'2019-08-28 10:00:13',	NULL,	1),
(307,	524,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-08-28 10:00:13',	'2019-08-28 10:00:13',	NULL,	1),
(308,	525,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-08-28 10:38:28',	'2019-08-28 10:38:28',	NULL,	1),
(309,	525,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-08-28 10:38:28',	'2019-08-28 10:38:28',	NULL,	1),
(310,	46,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-08-28 12:42:02',	'2019-08-28 12:42:02',	NULL,	1),
(311,	46,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-08-28 12:42:02',	'2019-08-28 12:42:02',	NULL,	1),
(312,	329,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-08-28 16:06:23',	'2019-08-28 16:06:23',	NULL,	1),
(313,	329,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-08-28 16:06:23',	'2019-08-28 16:06:23',	NULL,	1),
(314,	297,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-08-28 16:14:20',	'2019-08-28 16:14:20',	NULL,	1),
(315,	297,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-08-28 16:14:20',	'2019-08-28 16:14:20',	NULL,	1),
(316,	109,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-08-28 16:20:28',	'2019-08-28 16:20:28',	NULL,	1),
(317,	109,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-08-28 16:20:28',	'2019-08-28 16:20:28',	NULL,	1),
(318,	281,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-08-28 16:32:51',	'2019-08-28 16:32:51',	NULL,	1),
(319,	281,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-08-28 16:32:51',	'2019-08-28 16:32:51',	NULL,	1),
(320,	361,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-08-29 09:28:36',	'2019-08-29 09:28:36',	NULL,	1),
(321,	361,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-08-29 09:28:36',	'2019-08-29 09:28:36',	NULL,	1),
(322,	411,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-08-29 09:36:49',	'2019-08-29 09:36:49',	NULL,	1),
(323,	411,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-08-29 09:36:49',	'2019-08-29 09:36:49',	NULL,	1),
(324,	129,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-08-29 09:59:56',	'2019-08-29 09:59:56',	NULL,	1),
(325,	129,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-08-29 09:59:56',	'2019-08-29 09:59:56',	NULL,	1),
(326,	129,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-08-29 10:01:56',	'2019-08-29 10:01:56',	NULL,	1),
(327,	129,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-08-29 10:01:56',	'2019-08-29 10:01:56',	NULL,	1),
(328,	337,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-08-29 10:16:12',	'2019-08-29 10:16:12',	NULL,	1),
(329,	337,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-08-29 10:16:12',	'2019-08-29 10:16:12',	NULL,	1),
(330,	526,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-08-31 14:50:38',	'2019-08-31 14:50:38',	NULL,	1),
(331,	526,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-08-31 14:50:38',	'2019-08-31 14:50:38',	NULL,	1),
(332,	231,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-09-23 10:36:03',	'2019-09-23 10:36:03',	NULL,	1),
(333,	231,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-09-23 10:36:03',	'2019-09-23 10:36:03',	NULL,	1),
(334,	123,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-10-07 11:51:01',	'2019-10-07 11:51:01',	NULL,	1),
(335,	123,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-10-07 11:51:01',	'2019-10-07 11:51:01',	NULL,	1),
(336,	527,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-10-08 08:18:45',	'2019-10-08 08:18:45',	NULL,	1),
(337,	527,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-10-08 08:18:45',	'2019-10-08 08:18:45',	NULL,	1),
(338,	528,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-10-08 08:22:26',	'2019-10-08 08:22:26',	NULL,	1),
(339,	528,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-10-08 08:22:26',	'2019-10-08 08:22:26',	NULL,	1),
(340,	22,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-10-08 08:38:56',	'2019-10-08 08:38:56',	NULL,	1),
(341,	22,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-10-08 08:38:56',	'2019-10-08 08:38:56',	NULL,	1),
(342,	20,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-10-08 08:39:36',	'2019-10-08 08:39:36',	NULL,	1),
(343,	20,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-10-08 08:39:36',	'2019-10-08 08:39:36',	NULL,	1),
(344,	353,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-10-09 09:38:23',	'2019-10-09 09:38:23',	NULL,	1),
(345,	353,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-10-09 09:38:23',	'2019-10-09 09:38:23',	NULL,	1),
(346,	191,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-10-14 09:30:22',	'2019-10-14 09:30:22',	NULL,	1),
(347,	191,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-10-14 09:30:22',	'2019-10-14 09:30:22',	NULL,	1),
(348,	373,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-10-16 12:20:40',	'2019-10-16 12:20:40',	NULL,	1),
(349,	373,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-10-16 12:20:40',	'2019-10-16 12:20:40',	NULL,	1),
(350,	243,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-10-17 11:00:38',	'2019-10-17 11:00:38',	NULL,	1),
(351,	243,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-10-17 11:00:38',	'2019-10-17 11:00:38',	NULL,	1),
(352,	417,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-11-04 15:40:33',	'2019-11-04 15:40:33',	NULL,	1),
(353,	417,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-11-04 15:40:33',	'2019-11-04 15:40:33',	NULL,	1),
(354,	529,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-11-19 16:56:35',	'2019-11-19 16:56:35',	NULL,	1),
(355,	529,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-11-19 16:56:35',	'2019-11-19 16:56:35',	NULL,	1),
(356,	530,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-11-19 16:57:56',	'2019-11-19 16:57:56',	NULL,	1),
(357,	530,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-11-19 16:57:56',	'2019-11-19 16:57:56',	NULL,	1),
(358,	531,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-11-21 13:43:14',	'2019-11-21 13:43:14',	NULL,	1),
(359,	531,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-11-21 13:43:14',	'2019-11-21 13:43:14',	NULL,	1),
(360,	532,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-11-21 13:48:29',	'2019-11-21 13:48:29',	NULL,	1),
(361,	532,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-11-21 13:48:29',	'2019-11-21 13:48:29',	NULL,	1),
(362,	387,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-12-17 11:05:26',	'2019-12-17 11:05:26',	NULL,	1),
(363,	387,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-12-17 11:05:26',	'2019-12-17 11:05:26',	NULL,	1),
(364,	359,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-12-23 18:53:30',	'2019-12-23 18:53:30',	NULL,	1),
(365,	359,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-12-23 18:53:30',	'2019-12-23 18:53:30',	NULL,	1),
(366,	175,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-12-24 11:27:43',	'2019-12-24 11:27:43',	NULL,	1),
(367,	175,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-12-24 11:27:43',	'2019-12-24 11:27:43',	NULL,	1),
(368,	533,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-12-30 11:27:38',	'2019-12-30 11:27:38',	NULL,	1),
(369,	533,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-12-30 11:27:38',	'2019-12-30 11:27:38',	NULL,	1),
(370,	534,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 15:49:06',	'2020-01-02 15:49:06',	NULL,	1),
(371,	534,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-02 15:49:06',	'2020-01-02 15:49:06',	NULL,	1),
(372,	535,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-10 08:55:57',	'2020-01-10 08:55:57',	NULL,	1),
(373,	535,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-10 08:55:57',	'2020-01-10 08:55:57',	NULL,	1),
(374,	536,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 09:02:25',	'2020-01-16 09:02:25',	NULL,	1),
(375,	536,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-16 09:02:25',	'2020-01-16 09:02:25',	NULL,	1),
(376,	537,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 14:23:41',	'2020-01-17 14:23:41',	NULL,	1),
(377,	537,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 14:23:41',	'2020-01-17 14:23:41',	NULL,	1),
(378,	538,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 13:22:36',	'2020-01-20 13:22:36',	NULL,	1),
(379,	538,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 13:22:36',	'2020-01-20 13:22:36',	NULL,	1),
(380,	539,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 13:28:49',	'2020-01-20 13:28:49',	NULL,	1),
(381,	539,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 13:28:49',	'2020-01-20 13:28:49',	NULL,	1),
(382,	540,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 14:05:45',	'2020-01-20 14:05:45',	NULL,	1),
(383,	540,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-20 14:05:45',	'2020-01-20 14:05:45',	NULL,	1),
(384,	541,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-03 11:22:42',	'2020-02-03 11:22:42',	NULL,	1),
(385,	541,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-03 11:22:42',	'2020-02-03 11:22:42',	NULL,	1),
(386,	542,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-03 12:30:10',	'2020-02-03 12:30:10',	NULL,	1),
(387,	542,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-03 12:30:10',	'2020-02-03 12:30:10',	NULL,	1),
(388,	543,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-06 10:40:31',	'2020-02-06 10:40:31',	NULL,	1),
(389,	543,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-06 10:40:31',	'2020-02-06 10:40:31',	NULL,	1),
(390,	544,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-10 13:34:09',	'2020-02-10 13:34:09',	NULL,	1),
(391,	544,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-10 13:34:09',	'2020-02-10 13:34:09',	NULL,	1),
(392,	513,	NULL,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-14 11:23:01',	'2020-02-14 11:23:01',	NULL,	1),
(393,	513,	NULL,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-14 11:23:01',	'2020-02-14 11:23:01',	NULL,	1);

DROP TABLE IF EXISTS `assets`;
CREATE TABLE `assets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `asset_group_id` int(10) unsigned DEFAULT NULL,
  `asset_category_id` int(10) unsigned DEFAULT NULL,
  `owner_id` int(10) unsigned DEFAULT NULL,
  `custodian_id` int(10) unsigned DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `updated_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `assets` (`id`, `title`, `asset_group_id`, `asset_category_id`, `owner_id`, `custodian_id`, `created_by`, `updated_by`, `created_at`, `updated_at`, `status`) VALUES
(1,	'test',	NULL,	NULL,	NULL,	NULL,	1,	NULL,	'2018-10-30 11:19:24',	'2018-10-30 11:19:24',	1);

DROP TABLE IF EXISTS `asset_categories`;
CREATE TABLE `asset_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `updated_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `asset_categories` (`id`, `title`, `created_by`, `updated_by`, `created_at`, `updated_at`, `status`) VALUES
(1,	'test asset',	1,	NULL,	'2018-10-30 11:27:39',	'2018-10-30 11:27:39',	1);

DROP TABLE IF EXISTS `asset_category`;
CREATE TABLE `asset_category` (
  `asset_id` int(10) unsigned DEFAULT NULL,
  `asset_category_id` int(10) unsigned DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `asset_department`;
CREATE TABLE `asset_department` (
  `asset_id` int(10) unsigned DEFAULT NULL,
  `department_id` int(10) unsigned DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `asset_groups`;
CREATE TABLE `asset_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `updated_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `asset_groups` (`id`, `title`, `created_by`, `updated_by`, `created_at`, `updated_at`, `status`) VALUES
(1,	'test',	91,	NULL,	'2018-10-31 09:26:07',	'2018-10-31 09:26:07',	1);

DROP TABLE IF EXISTS `asset_location`;
CREATE TABLE `asset_location` (
  `asset_id` int(10) unsigned DEFAULT NULL,
  `location_id` int(10) unsigned DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `audited_schedules`;
CREATE TABLE `audited_schedules` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `audit_id` int(10) unsigned NOT NULL,
  `audit_schedule_id` int(10) unsigned NOT NULL,
  `department_id` int(10) unsigned DEFAULT NULL,
  `audit_type_id` int(10) unsigned DEFAULT NULL,
  `division_id` int(11) DEFAULT NULL,
  `section_id` int(11) DEFAULT NULL,
  `project_id` int(11) DEFAULT NULL,
  `audit_scope_id` int(10) unsigned DEFAULT NULL,
  `supplier_id` int(10) unsigned DEFAULT NULL,
  `customer_id` int(10) unsigned DEFAULT NULL,
  `certification_body_id` int(10) unsigned DEFAULT NULL,
  `branch_id` int(10) unsigned DEFAULT NULL,
  `subsidiary_id` int(10) unsigned DEFAULT NULL,
  `location_id` int(10) unsigned DEFAULT NULL,
  `audit_area_id` int(10) unsigned DEFAULT NULL,
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `is_audited` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audited_schedules` (`id`, `audit_id`, `audit_schedule_id`, `department_id`, `audit_type_id`, `division_id`, `section_id`, `project_id`, `audit_scope_id`, `supplier_id`, `customer_id`, `certification_body_id`, `branch_id`, `subsidiary_id`, `location_id`, `audit_area_id`, `start_date`, `end_date`, `is_audited`, `created_at`, `updated_at`) VALUES
(1,	1,	1,	5,	0,	2,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2018-12-19 08:00:00',	'2018-12-19 15:00:00',	1,	'2019-12-12 13:16:21',	'2019-12-12 13:16:21'),
(2,	2,	2,	14,	0,	2,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2018-12-19 08:00:00',	'2018-12-19 15:00:00',	1,	'2019-12-12 13:16:21',	'2019-12-12 13:16:21'),
(3,	3,	3,	13,	0,	5,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2018-12-16 08:00:00',	'2018-12-16 15:00:00',	1,	'2019-12-12 13:16:21',	'2019-12-12 13:16:21'),
(4,	4,	4,	13,	0,	5,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2018-12-17 08:00:00',	'2018-12-17 15:00:00',	1,	'2019-12-12 13:16:21',	'2019-12-12 13:16:21'),
(5,	5,	5,	4,	0,	2,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2018-12-18 08:00:00',	'2018-12-18 15:00:00',	1,	'2019-12-12 13:16:21',	'2019-12-12 13:16:21'),
(6,	6,	6,	4,	0,	2,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2018-12-17 08:00:00',	'2018-12-17 15:00:00',	1,	'2019-12-12 13:16:21',	'2019-12-12 13:16:21'),
(7,	7,	7,	11,	0,	4,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2018-12-20 08:00:00',	'2018-12-20 15:00:00',	1,	'2019-12-12 13:16:21',	'2019-12-12 13:16:21'),
(8,	8,	8,	10,	0,	4,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2018-12-18 08:00:00',	'2018-12-18 15:00:00',	1,	'2019-12-12 13:16:21',	'2019-12-12 13:16:21'),
(9,	9,	9,	18,	0,	3,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2018-12-18 08:00:00',	'2018-12-18 15:00:00',	1,	'2019-12-12 13:16:22',	'2019-12-12 13:16:22'),
(10,	10,	10,	8,	0,	3,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2018-12-17 08:00:00',	'2018-12-17 15:00:00',	1,	'2019-12-12 13:16:22',	'2019-12-12 13:16:22'),
(11,	11,	11,	9,	0,	3,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2018-12-18 08:00:00',	'2018-12-18 15:00:00',	1,	'2019-12-12 13:16:22',	'2019-12-12 13:16:22'),
(12,	12,	12,	7,	0,	3,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2018-12-19 08:00:00',	'2018-12-19 15:00:00',	1,	'2019-12-12 13:16:22',	'2019-12-12 13:16:22'),
(13,	13,	13,	16,	0,	5,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2018-12-18 08:00:00',	'2018-12-18 15:00:00',	1,	'2019-12-12 13:16:22',	'2019-12-12 13:16:22'),
(14,	14,	14,	14,	0,	5,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2018-12-19 08:00:00',	'2018-12-19 15:00:00',	1,	'2019-12-12 13:16:22',	'2019-12-12 13:16:22'),
(15,	15,	15,	15,	0,	5,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2018-12-12 08:00:00',	'2018-12-12 15:00:00',	1,	'2019-12-12 13:16:22',	'2019-12-12 13:16:22'),
(16,	16,	16,	12,	0,	4,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2018-12-24 08:00:00',	'2018-12-24 15:00:00',	1,	'2019-12-12 13:16:22',	'2019-12-12 13:16:22'),
(17,	17,	17,	12,	0,	4,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2018-12-19 08:00:00',	'2018-12-19 15:00:00',	1,	'2019-12-12 13:16:22',	'2019-12-12 13:16:22'),
(18,	18,	18,	12,	0,	4,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2018-12-19 08:00:00',	'2018-12-19 15:00:00',	1,	'2019-12-12 13:16:22',	'2019-12-12 13:16:22'),
(19,	19,	19,	6,	0,	2,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2018-12-19 08:00:00',	'2018-12-19 15:00:00',	1,	'2019-12-12 13:16:22',	'2019-12-12 13:16:22'),
(20,	20,	20,	2,	0,	1,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2018-12-31 08:00:00',	'2018-12-31 15:00:00',	1,	'2019-12-12 13:16:22',	'2019-12-12 13:16:22'),
(21,	21,	21,	5,	0,	2,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2017-05-09 08:00:00',	'2017-05-09 15:00:00',	1,	'2019-12-12 13:16:22',	'2019-12-12 13:16:22'),
(22,	22,	22,	13,	0,	5,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2017-05-02 08:00:00',	'2017-05-02 15:00:00',	1,	'2019-12-12 13:16:22',	'2019-12-12 13:16:22'),
(23,	23,	23,	13,	0,	5,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2017-05-02 08:00:00',	'2017-05-02 15:00:00',	1,	'2019-12-12 13:16:22',	'2019-12-12 13:16:22'),
(24,	24,	24,	4,	0,	2,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2017-05-04 08:00:00',	'2017-05-04 15:00:00',	1,	'2019-12-12 13:16:22',	'2019-12-12 13:16:22'),
(25,	25,	25,	4,	0,	2,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2017-05-04 08:00:00',	'2017-05-04 15:00:00',	1,	'2019-12-12 13:16:22',	'2019-12-12 13:16:22'),
(26,	26,	26,	11,	0,	4,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2016-05-03 08:00:00',	'2016-05-03 15:00:00',	1,	'2019-12-12 13:16:22',	'2019-12-12 13:16:22'),
(27,	27,	27,	10,	0,	4,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2017-05-01 08:00:00',	'2017-05-01 15:00:00',	1,	'2019-12-12 13:16:22',	'2019-12-12 13:16:22'),
(28,	28,	28,	18,	0,	3,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2017-05-01 08:00:00',	'2017-05-01 15:00:00',	1,	'2019-12-12 13:16:22',	'2019-12-12 13:16:22'),
(29,	29,	29,	8,	0,	3,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2017-05-02 08:00:00',	'2017-05-02 15:00:00',	1,	'2019-12-12 13:16:22',	'2019-12-12 13:16:22'),
(30,	30,	30,	9,	0,	3,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2017-05-01 08:00:00',	'2017-05-01 15:00:00',	1,	'2019-12-12 13:16:23',	'2019-12-12 13:16:23'),
(31,	31,	31,	7,	0,	3,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2017-04-30 08:00:00',	'2017-04-30 15:00:00',	1,	'2019-12-12 13:16:23',	'2019-12-12 13:16:23'),
(32,	32,	32,	16,	0,	5,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2017-04-05 08:00:00',	'2017-04-05 15:00:00',	1,	'2019-12-12 13:16:23',	'2019-12-12 13:16:23'),
(33,	33,	33,	14,	0,	5,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2017-05-04 08:00:00',	'2017-05-04 15:00:00',	1,	'2019-12-12 13:16:23',	'2019-12-12 13:16:23'),
(34,	34,	34,	15,	0,	5,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2017-05-02 08:00:00',	'2017-05-02 15:00:00',	1,	'2019-12-12 13:16:23',	'2019-12-12 13:16:23'),
(35,	35,	35,	12,	0,	4,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2017-05-02 08:00:00',	'2017-05-02 15:00:00',	1,	'2019-12-12 13:16:23',	'2019-12-12 13:16:23'),
(36,	36,	36,	12,	0,	4,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2017-05-02 08:00:00',	'2017-05-02 15:00:00',	1,	'2019-12-12 13:16:23',	'2019-12-12 13:16:23'),
(37,	37,	37,	12,	0,	4,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2017-05-02 08:00:00',	'2017-05-02 15:00:00',	1,	'2019-12-12 13:16:23',	'2019-12-12 13:16:23'),
(38,	38,	38,	2,	0,	1,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2017-05-02 08:00:00',	'2017-05-02 15:00:00',	1,	'2019-12-12 13:16:23',	'2019-12-12 13:16:23'),
(39,	39,	39,	1,	0,	1,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	'2019-12-01 07:00:00',	'2019-12-31 08:00:00',	1,	'2019-12-17 14:58:22',	'2019-12-17 14:58:22'),
(40,	40,	40,	13,	0,	5,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	'2019-12-01 07:00:00',	'2019-12-31 10:00:00',	1,	'2019-12-18 10:32:02',	'2019-12-18 10:32:02'),
(41,	41,	44,	4,	0,	2,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2019-10-01 07:00:00',	'2019-10-01 08:00:00',	1,	'2019-12-20 08:58:15',	'2019-12-20 08:58:15'),
(42,	41,	45,	4,	0,	2,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2019-10-09 08:00:00',	'2019-10-09 10:30:00',	1,	'2019-12-20 08:58:15',	'2019-12-20 08:58:15'),
(43,	42,	53,	4,	0,	2,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	'2019-10-01 08:00:00',	'2019-10-01 16:00:00',	1,	'2019-12-23 09:52:21',	'2019-12-23 09:52:21'),
(44,	43,	54,	1,	0,	1,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	'2019-11-07 07:00:00',	'2019-11-08 10:00:00',	1,	'2019-12-23 10:10:46',	'2019-12-23 10:10:46'),
(45,	43,	55,	1,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	'2019-11-08 14:00:00',	'2019-11-08 14:00:00',	1,	'2019-12-23 10:10:46',	'2019-12-23 10:10:46'),
(46,	44,	56,	13,	0,	5,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	'2019-12-01 07:00:00',	'2019-12-31 07:30:00',	1,	'2019-12-23 12:47:23',	'2019-12-23 12:47:23'),
(47,	45,	57,	10,	0,	4,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	'2019-12-01 07:00:00',	'2019-12-31 08:00:00',	1,	'2019-12-23 13:53:59',	'2019-12-23 13:53:59'),
(48,	46,	58,	16,	0,	5,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	'2019-12-24 10:00:00',	'2019-12-24 13:00:00',	1,	'2019-12-24 10:42:13',	'2019-12-24 10:42:13'),
(49,	47,	62,	13,	0,	5,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	'2020-01-02 07:00:00',	'2020-01-02 07:30:00',	1,	'2019-12-30 09:44:51',	'2019-12-30 09:44:51'),
(50,	47,	63,	13,	0,	5,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2020-01-03 09:00:00',	'2020-01-03 12:00:00',	1,	'2019-12-30 09:44:51',	'2019-12-30 09:44:51'),
(51,	47,	64,	13,	0,	5,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2020-01-04 12:00:00',	'2020-01-04 16:00:00',	1,	'2019-12-30 09:44:51',	'2019-12-30 09:44:51'),
(52,	48,	65,	1,	0,	1,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	'2019-02-01 07:00:00',	'2019-02-28 07:30:00',	1,	'2019-12-30 10:18:02',	'2019-12-30 10:18:02'),
(53,	49,	68,	4,	0,	2,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	'2020-02-01 07:00:00',	'2020-02-28 14:30:00',	1,	'2019-12-31 09:39:06',	'2019-12-31 09:39:06'),
(54,	50,	69,	1,	0,	1,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	'2020-01-01 07:00:00',	'2020-01-01 09:30:00',	1,	'2020-01-01 15:06:28',	'2020-01-01 15:06:28'),
(55,	51,	74,	4,	0,	2,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	'2020-01-06 07:00:00',	'2020-01-31 13:30:00',	1,	'2020-01-03 10:56:59',	'2020-01-03 10:56:59'),
(56,	52,	81,	4,	0,	2,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	'2019-01-01 07:00:00',	'2019-01-31 09:00:00',	1,	'2020-01-04 10:14:47',	'2020-01-04 10:14:47'),
(57,	53,	82,	14,	0,	5,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	'2018-01-01 07:30:00',	'2018-01-31 14:30:00',	1,	'2020-01-06 09:58:48',	'2020-01-06 09:58:48'),
(58,	54,	89,	14,	0,	5,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	'2018-01-01 07:00:00',	'2018-01-31 15:30:00',	1,	'2020-01-06 13:55:13',	'2020-01-06 14:34:39'),
(59,	54,	90,	14,	0,	5,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	'2018-01-01 14:30:00',	'2018-01-31 14:30:00',	1,	'2020-01-06 13:55:13',	'2020-01-06 14:34:39'),
(60,	55,	92,	16,	0,	5,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	'2020-01-07 07:00:00',	'2020-01-07 08:00:00',	1,	'2020-01-07 08:51:06',	'2020-01-07 08:51:06'),
(61,	56,	93,	1,	0,	1,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	'2020-01-01 07:00:00',	'2020-01-01 08:00:00',	1,	'2020-01-07 13:01:56',	'2020-01-07 13:01:56'),
(62,	57,	94,	1,	0,	1,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	'2020-01-01 12:30:00',	'2020-01-31 15:30:00',	1,	'2020-01-07 13:36:38',	'2020-01-07 13:36:38'),
(63,	58,	95,	13,	0,	5,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2020-02-28 07:00:00',	'2020-02-28 10:30:00',	1,	'2020-01-08 09:35:56',	'2020-01-08 10:23:35'),
(64,	59,	97,	4,	0,	2,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	'2020-02-01 07:30:00',	'2020-02-28 08:00:00',	1,	'2020-01-08 17:07:12',	'2020-01-08 17:07:29'),
(65,	60,	103,	4,	0,	2,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	'2020-03-01 07:00:00',	'2020-03-31 07:30:00',	1,	'2020-01-08 17:16:43',	'2020-01-08 17:16:43'),
(66,	61,	108,	5,	0,	2,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2012-02-01 07:00:00',	'2012-02-28 08:00:00',	1,	'2020-01-09 08:54:11',	'2020-01-09 08:54:11'),
(67,	62,	113,	10,	0,	4,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	'2022-01-12 07:00:00',	'2022-01-12 10:00:00',	1,	'2020-01-10 10:40:33',	'2020-01-10 10:45:03'),
(68,	62,	114,	10,	0,	4,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2022-01-20 10:00:00',	'2022-01-20 12:00:00',	1,	'2020-01-10 10:40:33',	'2020-01-10 10:45:03'),
(69,	63,	116,	4,	0,	2,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	'2032-01-01 13:30:00',	'2032-01-31 14:00:00',	1,	'2020-01-16 09:24:01',	'2020-01-16 09:24:01'),
(70,	64,	118,	1,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	'2036-03-01 09:00:00',	'2036-03-31 18:30:00',	1,	'2020-01-16 10:32:53',	'2020-01-16 10:32:53'),
(71,	65,	123,	4,	0,	2,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	'2020-01-01 14:30:00',	'2020-01-31 15:30:00',	1,	'2020-01-17 09:26:47',	'2020-01-17 09:28:03'),
(72,	66,	124,	4,	0,	2,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2020-01-01 10:30:00',	'2020-01-31 07:30:00',	1,	'2020-01-17 09:57:16',	'2020-01-17 09:57:16'),
(73,	67,	127,	18,	0,	3,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2020-05-01 07:00:00',	'2020-05-01 09:00:00',	0,	'2020-01-18 13:49:49',	'2020-01-18 13:54:17'),
(74,	67,	128,	18,	0,	3,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2020-05-31 09:00:00',	'2020-05-31 10:00:00',	1,	'2020-01-18 13:49:49',	'2020-01-18 13:54:17'),
(75,	68,	130,	27,	0,	1,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	'2020-01-01 08:00:00',	'2020-01-15 09:00:00',	1,	'2020-01-20 14:50:30',	'2020-01-20 14:50:30'),
(76,	69,	133,	27,	0,	1,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	'2020-03-01 07:00:00',	'2020-03-17 10:00:00',	1,	'2020-01-23 11:08:12',	'2020-01-23 13:10:10'),
(77,	70,	134,	27,	0,	1,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	'2020-06-30 07:00:00',	'2020-06-30 12:00:00',	1,	'2020-01-25 15:52:33',	'2020-01-25 15:53:27'),
(78,	71,	140,	15,	0,	5,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	'2020-03-13 07:00:00',	'2020-03-24 10:00:00',	1,	'2020-01-31 08:50:38',	'2020-01-31 08:50:38');

DROP TABLE IF EXISTS `audited_schedule_auditee`;
CREATE TABLE `audited_schedule_auditee` (
  `audited_schedule_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `is_present` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`audited_schedule_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audited_schedule_auditee` (`audited_schedule_id`, `user_id`, `is_present`) VALUES
(1,	22,	1),
(2,	8,	1),
(3,	83,	1),
(4,	8,	1),
(5,	8,	1),
(5,	9,	1),
(5,	13,	1),
(5,	38,	1),
(6,	17,	1),
(7,	79,	1),
(8,	20,	1),
(9,	68,	1),
(10,	11,	1),
(10,	49,	1),
(10,	51,	1),
(11,	18,	1),
(12,	64,	1),
(12,	84,	1),
(13,	54,	1),
(13,	89,	1),
(14,	77,	1),
(14,	80,	1),
(15,	86,	1),
(16,	29,	1),
(17,	57,	1),
(18,	26,	1),
(18,	57,	1),
(19,	75,	1),
(20,	30,	1),
(20,	67,	1),
(21,	22,	1),
(22,	14,	1),
(22,	45,	1),
(22,	367,	1),
(23,	27,	1),
(24,	8,	1),
(24,	44,	1),
(24,	70,	1),
(24,	88,	1),
(25,	8,	1),
(25,	44,	1),
(25,	70,	1),
(25,	88,	1),
(26,	40,	1),
(26,	82,	1),
(27,	20,	1),
(28,	68,	1),
(28,	81,	1),
(29,	10,	1),
(30,	18,	1),
(31,	64,	1),
(31,	66,	1),
(32,	39,	1),
(32,	89,	1),
(33,	8,	1),
(34,	69,	1),
(34,	86,	1),
(35,	8,	1),
(36,	12,	1),
(37,	57,	1),
(38,	8,	1),
(39,	1,	1),
(40,	529,	1),
(41,	70,	1),
(42,	477,	1),
(43,	70,	1),
(43,	477,	1),
(44,	243,	1),
(44,	353,	1),
(44,	531,	1),
(45,	243,	1),
(46,	61,	1),
(47,	32,	1),
(48,	39,	1),
(48,	56,	1),
(48,	89,	1),
(49,	529,	1),
(50,	27,	1),
(51,	37,	1),
(52,	1,	1),
(53,	70,	1),
(54,	1,	1),
(54,	243,	1),
(54,	353,	1),
(55,	8,	1),
(56,	8,	1),
(56,	101,	0),
(56,	477,	1),
(57,	383,	1),
(58,	383,	1),
(59,	329,	1),
(59,	361,	0),
(59,	383,	1),
(60,	161,	1),
(61,	243,	1),
(61,	531,	1),
(62,	243,	1),
(62,	353,	1),
(63,	37,	1),
(63,	349,	1),
(64,	70,	1),
(65,	70,	1),
(65,	100,	1),
(66,	22,	1),
(66,	153,	1),
(67,	32,	1),
(67,	329,	1),
(67,	369,	1),
(67,	401,	1),
(68,	147,	1),
(68,	343,	1),
(69,	70,	1),
(70,	1,	1),
(71,	17,	1),
(72,	13,	1),
(73,	81,	0),
(73,	393,	1),
(73,	511,	1),
(74,	68,	0),
(74,	351,	1),
(75,	538,	1),
(76,	62,	1),
(76,	491,	1),
(77,	62,	1),
(77,	538,	1),
(77,	539,	0),
(78,	46,	1),
(78,	86,	0),
(78,	441,	1);

DROP TABLE IF EXISTS `audited_schedule_auditor`;
CREATE TABLE `audited_schedule_auditor` (
  `audited_schedule_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `is_present` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`audited_schedule_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audited_schedule_auditor` (`audited_schedule_id`, `user_id`, `is_present`) VALUES
(1,	53,	1),
(2,	53,	1),
(3,	68,	1),
(3,	89,	1),
(4,	68,	1),
(4,	89,	1),
(5,	71,	1),
(6,	71,	1),
(7,	8,	1),
(8,	8,	1),
(9,	22,	1),
(9,	66,	1),
(10,	22,	1),
(10,	66,	1),
(11,	22,	1),
(12,	22,	1),
(13,	66,	1),
(14,	89,	1),
(15,	10,	1),
(15,	66,	1),
(16,	42,	1),
(17,	42,	1),
(18,	42,	1),
(19,	53,	1),
(20,	71,	1),
(21,	53,	1),
(22,	20,	1),
(23,	20,	1),
(24,	71,	1),
(25,	71,	1),
(26,	42,	1),
(27,	42,	1),
(27,	44,	1),
(28,	42,	1),
(28,	44,	1),
(29,	66,	1),
(30,	8,	1),
(31,	8,	1),
(32,	68,	1),
(32,	71,	1),
(33,	14,	1),
(34,	10,	1),
(34,	66,	1),
(35,	8,	1),
(35,	58,	1),
(36,	8,	1),
(36,	58,	1),
(37,	8,	1),
(38,	14,	1),
(39,	8,	1),
(39,	101,	1),
(40,	8,	1),
(40,	101,	1),
(41,	8,	1),
(41,	101,	1),
(42,	8,	1),
(42,	101,	1),
(42,	527,	1),
(43,	329,	1),
(44,	79,	1),
(44,	101,	1),
(44,	527,	1),
(45,	66,	1),
(45,	79,	1),
(46,	46,	1),
(46,	101,	1),
(46,	297,	1),
(46,	527,	1),
(47,	527,	1),
(48,	8,	0),
(48,	53,	1),
(49,	22,	1),
(49,	297,	1),
(50,	5,	1),
(50,	297,	1),
(51,	102,	1),
(51,	297,	1),
(52,	527,	1),
(53,	101,	1),
(54,	5,	1),
(54,	527,	1),
(55,	101,	1),
(56,	329,	1),
(56,	527,	1),
(57,	1,	1),
(58,	1,	1),
(59,	1,	1),
(60,	101,	1),
(61,	527,	1),
(62,	527,	1),
(63,	101,	1),
(64,	101,	1),
(65,	101,	1),
(66,	53,	1),
(66,	527,	1),
(67,	535,	1),
(68,	535,	1),
(69,	527,	1),
(70,	527,	1),
(71,	527,	1),
(72,	527,	1),
(73,	527,	1),
(74,	527,	1),
(75,	539,	1),
(76,	539,	1),
(77,	8,	1),
(77,	527,	1),
(78,	8,	1),
(78,	527,	1);

DROP TABLE IF EXISTS `audited_schedule_closing_meeting_users`;
CREATE TABLE `audited_schedule_closing_meeting_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `audited_schedule_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `is_present` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `audited_schedule_opening_meeting_users`;
CREATE TABLE `audited_schedule_opening_meeting_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `audited_schedule_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `is_present` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `audited_schedule_process`;
CREATE TABLE `audited_schedule_process` (
  `audited_schedule_id` int(10) unsigned NOT NULL,
  `process_id` int(10) unsigned DEFAULT NULL,
  `parent_id` int(10) unsigned DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audited_schedule_process` (`audited_schedule_id`, `process_id`, `parent_id`) VALUES
(41,	64,	0),
(42,	64,	0),
(43,	64,	0),
(52,	65,	0),
(53,	64,	0),
(54,	65,	0),
(56,	64,	0),
(61,	65,	0),
(71,	64,	0),
(72,	64,	0);

DROP TABLE IF EXISTS `audited_schedule_sections`;
CREATE TABLE `audited_schedule_sections` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `audited_schedule_id` int(10) unsigned NOT NULL,
  `section_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audited_schedule_sections` (`id`, `audited_schedule_id`, `section_id`) VALUES
(1,	1,	45),
(2,	2,	2),
(3,	3,	28),
(4,	3,	26),
(5,	4,	51),
(6,	5,	3),
(7,	5,	2),
(8,	6,	1),
(9,	7,	20),
(10,	7,	19),
(11,	8,	16),
(12,	9,	29),
(13,	10,	9),
(14,	10,	10),
(15,	10,	11),
(16,	11,	14),
(17,	11,	13),
(18,	12,	57),
(19,	12,	7),
(20,	12,	6),
(21,	13,	36),
(22,	13,	35),
(23,	13,	37),
(24,	14,	62),
(25,	15,	61),
(26,	16,	60),
(27,	17,	24),
(28,	18,	22),
(29,	19,	47),
(30,	20,	41),
(31,	21,	45),
(32,	22,	28),
(33,	22,	26),
(34,	23,	59),
(35,	24,	2),
(36,	24,	3),
(37,	25,	1),
(38,	26,	19),
(39,	26,	20),
(40,	26,	21),
(41,	27,	16),
(42,	27,	17),
(43,	27,	18),
(44,	28,	29),
(45,	29,	9),
(46,	29,	10),
(47,	29,	11),
(48,	30,	14),
(49,	30,	13),
(50,	31,	5),
(51,	31,	6),
(52,	31,	7),
(53,	32,	35),
(54,	32,	36),
(55,	32,	37),
(56,	33,	30),
(57,	33,	31),
(58,	34,	32),
(59,	34,	33),
(60,	34,	34),
(61,	35,	22),
(62,	35,	23),
(63,	35,	24),
(64,	35,	25),
(65,	36,	22),
(66,	36,	23),
(67,	36,	24),
(68,	36,	25),
(69,	37,	22),
(70,	37,	23),
(71,	37,	24),
(72,	37,	25),
(73,	38,	41),
(74,	39,	39),
(75,	40,	49),
(76,	40,	26),
(77,	40,	51),
(78,	40,	28),
(79,	41,	1),
(80,	41,	2),
(81,	41,	3),
(82,	42,	1),
(83,	42,	2),
(84,	42,	3),
(85,	43,	1),
(86,	43,	2),
(87,	43,	3),
(88,	44,	39),
(89,	45,	39),
(90,	46,	49),
(91,	46,	26),
(92,	46,	51),
(93,	46,	28),
(94,	47,	17),
(95,	47,	16),
(96,	47,	18),
(97,	48,	35),
(98,	48,	36),
(99,	48,	37),
(100,	49,	49),
(101,	49,	26),
(102,	49,	51),
(103,	49,	28),
(104,	50,	49),
(105,	50,	26),
(106,	50,	51),
(107,	50,	28),
(108,	51,	49),
(109,	51,	26),
(110,	51,	51),
(111,	51,	28),
(112,	52,	39),
(113,	53,	1),
(114,	53,	2),
(115,	53,	3),
(116,	54,	39),
(117,	55,	1),
(118,	55,	2),
(119,	55,	3),
(120,	56,	1),
(121,	56,	2),
(122,	56,	3),
(123,	57,	30),
(124,	57,	31),
(125,	58,	30),
(126,	58,	31),
(127,	59,	30),
(128,	59,	31),
(129,	60,	35),
(130,	60,	36),
(131,	60,	37),
(132,	61,	39),
(133,	62,	39),
(134,	63,	49),
(135,	63,	26),
(136,	63,	51),
(137,	63,	28),
(138,	64,	1),
(139,	64,	2),
(140,	64,	3),
(141,	65,	1),
(142,	65,	2),
(143,	65,	3),
(144,	66,	45),
(145,	66,	60),
(146,	67,	17),
(147,	67,	16),
(148,	67,	18),
(149,	68,	17),
(150,	68,	16),
(151,	68,	18),
(152,	69,	1),
(153,	69,	2),
(154,	69,	3),
(155,	70,	39),
(156,	71,	1),
(157,	71,	2),
(158,	71,	3),
(159,	72,	1),
(160,	72,	2),
(161,	72,	3),
(162,	73,	29),
(163,	74,	29),
(164,	75,	66),
(165,	76,	66),
(166,	77,	66),
(167,	77,	65),
(168,	77,	64),
(169,	78,	32),
(170,	78,	33),
(171,	78,	34);

DROP TABLE IF EXISTS `auditor_ms_type`;
CREATE TABLE `auditor_ms_type` (
  `user_id` int(10) unsigned NOT NULL,
  `management_system_type_id` int(10) unsigned NOT NULL,
  KEY `auditor_ms_type_user_id_foreign` (`user_id`),
  KEY `auditor_ms_type_management_system_type_id_foreign` (`management_system_type_id`),
  CONSTRAINT `auditor_ms_type_management_system_type_id_foreign` FOREIGN KEY (`management_system_type_id`) REFERENCES `management_system_types` (`id`),
  CONSTRAINT `auditor_ms_type_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `auditor_ms_type` (`user_id`, `management_system_type_id`) VALUES
(527,	1),
(527,	2),
(527,	3),
(527,	4),
(527,	5),
(527,	6),
(527,	7),
(527,	8),
(527,	9),
(527,	10),
(527,	11),
(527,	12),
(527,	13),
(527,	15),
(102,	1),
(337,	1),
(5,	1),
(42,	2),
(57,	3),
(13,	3),
(107,	3),
(22,	1),
(20,	1),
(58,	1),
(59,	1),
(66,	1),
(89,	1),
(46,	1),
(83,	1),
(532,	12),
(8,	1),
(8,	2),
(8,	3),
(8,	4),
(8,	5),
(8,	6),
(8,	7),
(8,	8),
(8,	9),
(8,	10),
(8,	11),
(8,	12),
(8,	13),
(8,	15),
(8,	16),
(8,	17),
(8,	18),
(8,	19),
(8,	20),
(8,	21),
(533,	1),
(535,	4),
(529,	2),
(529,	3),
(101,	1),
(101,	2),
(531,	12),
(329,	1),
(329,	2),
(329,	3),
(329,	4),
(329,	5),
(329,	6),
(329,	7),
(329,	8),
(329,	9),
(329,	10),
(329,	11),
(329,	12),
(329,	13),
(329,	15),
(53,	1),
(539,	1),
(539,	2),
(539,	11),
(539,	5),
(79,	2),
(297,	2),
(541,	1),
(541,	2),
(541,	3),
(541,	4),
(541,	5),
(541,	6),
(541,	7),
(541,	8),
(541,	9),
(541,	10),
(541,	11),
(541,	12),
(541,	13),
(541,	15),
(541,	16),
(541,	17),
(541,	18),
(541,	19),
(541,	20),
(541,	21),
(542,	1),
(542,	2),
(542,	3),
(542,	4),
(542,	5),
(542,	6),
(542,	7),
(542,	8),
(542,	9),
(542,	10),
(542,	11),
(542,	12),
(542,	13),
(542,	15),
(543,	1),
(534,	4),
(361,	1);

DROP TABLE IF EXISTS `audits`;
CREATE TABLE `audits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `audit_plan_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `updated_by` int(10) unsigned DEFAULT NULL,
  `deleted_by` int(10) unsigned DEFAULT NULL,
  `audit_status_id` int(11) NOT NULL,
  `audit_program_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audits` (`id`, `audit_plan_id`, `created_at`, `updated_at`, `deleted_at`, `created_by`, `updated_by`, `deleted_by`, `audit_status_id`, `audit_program_id`) VALUES
(1,	1,	'2019-12-12 13:15:59',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL,	1,	1),
(2,	2,	'2019-12-12 13:15:59',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL,	1,	1),
(3,	3,	'2019-12-12 13:15:59',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL,	1,	1),
(4,	4,	'2019-12-12 13:15:59',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL,	1,	1),
(5,	5,	'2019-12-12 13:15:59',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL,	1,	1),
(6,	6,	'2019-12-12 13:15:59',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL,	1,	1),
(7,	7,	'2019-12-12 13:15:59',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL,	1,	1),
(8,	8,	'2019-12-12 13:15:59',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL,	1,	1),
(9,	9,	'2019-12-12 13:15:59',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL,	1,	1),
(10,	10,	'2019-12-12 13:15:59',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL,	1,	1),
(11,	11,	'2019-12-12 13:15:59',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL,	1,	1),
(12,	12,	'2019-12-12 13:15:59',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL,	1,	1),
(13,	13,	'2019-12-12 13:15:59',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL,	1,	1),
(14,	14,	'2019-12-12 13:15:59',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL,	1,	1),
(15,	15,	'2019-12-12 13:15:59',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL,	1,	1),
(16,	16,	'2019-12-12 13:15:59',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL,	1,	1),
(17,	17,	'2019-12-12 13:15:59',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL,	1,	1),
(18,	18,	'2019-12-12 13:15:59',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL,	1,	1),
(19,	19,	'2019-12-12 13:15:59',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL,	1,	1),
(20,	20,	'2019-12-12 13:15:59',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL,	1,	1),
(21,	21,	'2019-12-12 13:15:59',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL,	1,	2),
(22,	22,	'2019-12-12 13:15:59',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL,	1,	2),
(23,	23,	'2019-12-12 13:15:59',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL,	1,	2),
(24,	24,	'2019-12-12 13:15:59',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL,	1,	2),
(25,	25,	'2019-12-12 13:15:59',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL,	1,	2),
(26,	26,	'2019-12-12 13:15:59',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL,	1,	2),
(27,	27,	'2019-12-12 13:15:59',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL,	1,	2),
(28,	28,	'2019-12-12 13:15:59',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL,	1,	2),
(29,	29,	'2019-12-12 13:15:59',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL,	1,	2),
(30,	30,	'2019-12-12 13:15:59',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL,	1,	2),
(31,	31,	'2019-12-12 13:15:59',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL,	1,	2),
(32,	32,	'2019-12-12 13:15:59',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL,	1,	2),
(33,	33,	'2019-12-12 13:15:59',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL,	1,	2),
(34,	34,	'2019-12-12 13:15:59',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL,	1,	2),
(35,	35,	'2019-12-12 13:15:59',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL,	1,	2),
(36,	36,	'2019-12-12 13:15:59',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL,	1,	2),
(37,	37,	'2019-12-12 13:15:59',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL,	1,	2),
(38,	38,	'2019-12-12 13:15:59',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL,	1,	2),
(39,	39,	'2019-12-17 14:58:22',	'2019-12-17 14:58:22',	NULL,	101,	NULL,	NULL,	1,	3),
(40,	40,	'2019-12-18 10:32:02',	'2019-12-18 10:32:02',	NULL,	101,	NULL,	NULL,	1,	4),
(41,	41,	'2019-12-20 08:58:15',	'2019-12-20 08:58:15',	NULL,	527,	NULL,	NULL,	1,	7),
(42,	47,	'2019-12-23 09:52:21',	'2019-12-23 09:52:21',	NULL,	329,	NULL,	NULL,	1,	13),
(43,	48,	'2019-12-23 10:10:46',	'2019-12-23 10:10:46',	NULL,	79,	NULL,	NULL,	1,	13),
(44,	49,	'2019-12-23 12:47:23',	'2019-12-23 12:47:23',	NULL,	101,	NULL,	NULL,	1,	13),
(45,	50,	'2019-12-23 13:53:59',	'2019-12-30 15:17:32',	'2019-12-30 15:17:32',	527,	NULL,	1,	1,	14),
(46,	51,	'2019-12-24 10:42:13',	'2019-12-24 10:42:13',	NULL,	53,	NULL,	NULL,	1,	15),
(47,	52,	'2019-12-30 09:44:51',	'2019-12-30 09:44:51',	NULL,	297,	NULL,	NULL,	1,	16),
(48,	53,	'2019-12-30 10:18:02',	'2019-12-30 10:18:02',	NULL,	527,	NULL,	NULL,	1,	16),
(49,	62,	'2019-12-31 09:39:06',	'2019-12-31 09:39:06',	NULL,	101,	NULL,	NULL,	1,	17),
(50,	63,	'2020-01-01 15:06:28',	'2020-01-01 15:06:28',	NULL,	527,	NULL,	NULL,	1,	19),
(51,	65,	'2020-01-03 10:56:59',	'2020-01-03 10:56:59',	NULL,	101,	NULL,	NULL,	1,	20),
(52,	69,	'2020-01-04 10:14:47',	'2020-01-04 10:14:47',	NULL,	329,	NULL,	NULL,	1,	25),
(53,	70,	'2020-01-06 09:58:48',	'2020-01-06 09:58:48',	NULL,	383,	NULL,	NULL,	1,	26),
(54,	71,	'2020-01-06 13:55:13',	'2020-01-06 13:55:13',	NULL,	1,	NULL,	NULL,	1,	26),
(55,	73,	'2020-01-07 08:51:06',	'2020-01-07 08:51:06',	NULL,	101,	NULL,	NULL,	1,	27),
(56,	82,	'2020-01-07 13:01:56',	'2020-01-07 13:01:56',	NULL,	527,	NULL,	NULL,	1,	29),
(57,	83,	'2020-01-07 13:36:38',	'2020-01-07 13:36:38',	NULL,	527,	NULL,	NULL,	1,	29),
(58,	86,	'2020-01-08 09:35:56',	'2020-01-08 09:35:56',	NULL,	101,	NULL,	NULL,	1,	30),
(59,	87,	'2020-01-08 17:07:12',	'2020-01-08 17:07:12',	NULL,	101,	NULL,	NULL,	1,	30),
(60,	91,	'2020-01-08 17:16:43',	'2020-01-08 17:16:43',	NULL,	101,	NULL,	NULL,	1,	32),
(61,	94,	'2020-01-09 08:54:11',	'2020-01-09 08:54:11',	NULL,	527,	NULL,	NULL,	1,	33),
(62,	98,	'2020-01-10 10:40:33',	'2020-01-10 10:40:33',	NULL,	535,	NULL,	NULL,	1,	36),
(63,	100,	'2020-01-16 09:24:01',	'2020-01-16 09:24:01',	NULL,	527,	NULL,	NULL,	1,	38),
(64,	102,	'2020-01-16 10:32:53',	'2020-01-16 10:32:53',	NULL,	527,	NULL,	NULL,	1,	42),
(65,	106,	'2020-01-17 09:26:47',	'2020-01-17 09:26:47',	NULL,	527,	NULL,	NULL,	1,	43),
(66,	107,	'2020-01-17 09:57:16',	'2020-01-17 09:57:16',	NULL,	527,	NULL,	NULL,	1,	43),
(67,	108,	'2020-01-18 13:49:49',	'2020-01-18 13:49:49',	NULL,	527,	NULL,	NULL,	1,	54),
(68,	109,	'2020-01-20 14:50:30',	'2020-01-20 14:50:30',	NULL,	539,	NULL,	NULL,	1,	56),
(69,	110,	'2020-01-23 11:08:12',	'2020-01-23 11:08:12',	NULL,	539,	NULL,	NULL,	1,	57),
(70,	111,	'2020-01-25 15:52:33',	'2020-01-25 15:52:33',	NULL,	527,	NULL,	NULL,	1,	58),
(71,	115,	'2020-01-31 08:50:38',	'2020-01-31 08:50:38',	NULL,	527,	NULL,	NULL,	1,	61);

DROP TABLE IF EXISTS `audit_areas`;
CREATE TABLE `audit_areas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `audit_sub_category_id` int(11) DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `audit_categories`;
CREATE TABLE `audit_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_categories` (`id`, `title`, `created_at`, `updated_at`, `deleted_at`, `created_by`, `status`) VALUES
(1,	'Quality Audit',	'2018-10-03 14:29:18',	'2020-01-20 13:12:06',	NULL,	1,	2),
(2,	'Legal Audit',	'2018-10-03 14:29:18',	'2020-01-20 13:11:39',	NULL,	1,	2),
(3,	'Operational Audit',	'2018-10-03 14:29:18',	'2020-01-20 13:11:47',	NULL,	1,	2),
(4,	'Financial Audit',	'2018-10-03 14:29:18',	'2020-01-20 13:11:35',	NULL,	1,	2),
(5,	'Performance Audit',	'2018-10-03 14:29:18',	'2020-01-20 13:11:44',	NULL,	1,	2),
(6,	'Technical Audit',	'2018-10-03 14:29:18',	'2020-01-20 13:11:58',	NULL,	1,	2),
(7,	'Cost Audit',	'2018-10-03 14:29:18',	'2020-01-20 13:11:33',	NULL,	1,	2),
(8,	'Management Audit',	'2018-10-03 14:29:18',	'2020-01-20 13:11:41',	NULL,	1,	2),
(9,	'Risk-based Audit',	'2018-10-03 14:29:18',	'2020-01-20 13:12:09',	NULL,	1,	2),
(10,	'testtitle123',	'2018-10-30 06:29:03',	'2018-10-30 06:29:59',	'2018-10-30 06:29:59',	1,	1),
(11,	'test1',	'2018-10-30 06:43:46',	'2018-10-30 06:45:23',	'2018-10-30 06:45:23',	1,	1),
(12,	'test2',	'2018-10-30 06:43:51',	'2018-10-30 06:45:19',	'2018-10-30 06:45:19',	1,	1),
(13,	'test3',	'2018-10-30 06:43:58',	'2018-10-30 06:45:14',	'2018-10-30 06:45:14',	1,	1),
(14,	'test4',	'2018-10-30 06:44:03',	'2018-10-30 06:45:05',	'2018-10-30 06:45:05',	1,	1),
(15,	'test5',	'2018-10-30 06:44:14',	'2018-10-30 06:45:01',	'2018-10-30 06:45:01',	1,	1),
(16,	'test6',	'2018-10-30 06:44:23',	'2018-10-30 06:44:57',	'2018-10-30 06:44:57',	1,	1),
(17,	'test7',	'2018-10-30 06:44:28',	'2018-10-30 06:44:52',	'2018-10-30 06:44:52',	1,	1),
(18,	'test8',	'2018-10-30 06:44:34',	'2018-10-30 06:44:47',	'2018-10-30 06:44:47',	1,	1),
(19,	'The audit scope generally includes a description of the physical locations, organizational units, activities and processes, as well as the time period covered.',	'2018-10-30 08:56:04',	'2018-10-30 08:56:08',	'2018-10-30 08:56:08',	1,	1),
(20,	'ff',	'2018-11-10 09:46:04',	'2018-11-10 09:50:45',	'2018-11-10 09:50:45',	1,	1),
(21,	'ffr',	'2018-11-10 09:46:07',	'2018-11-10 09:50:49',	'2018-11-10 09:50:49',	1,	1),
(22,	'dfr',	'2018-11-10 09:46:11',	'2018-11-10 09:50:35',	'2018-11-10 09:50:35',	1,	1),
(23,	'rgr',	'2018-11-10 09:46:13',	'2018-11-10 09:51:08',	'2018-11-10 09:51:08',	1,	1),
(24,	'frr',	'2018-11-10 09:46:17',	'2018-11-10 09:51:02',	'2018-11-10 09:51:02',	1,	1),
(25,	'fdfr',	'2018-11-10 09:46:20',	'2018-11-10 09:50:40',	'2018-11-10 09:50:40',	1,	1),
(26,	'fgr',	'2018-11-10 09:46:25',	'2018-11-10 09:50:53',	'2018-11-10 09:50:53',	1,	1),
(27,	'Technichal audit',	'2018-11-10 09:46:48',	'2018-11-10 09:49:51',	'2018-11-10 09:49:51',	1,	1),
(28,	'Other Audit',	'2019-09-23 16:01:34',	'2020-01-20 13:11:46',	NULL,	1,	2),
(29,	'test',	'2019-10-14 12:12:37',	'2020-01-20 13:11:57',	NULL,	1,	2),
(30,	'IMS AUDIT',	'2019-12-21 10:57:27',	'2020-01-20 13:11:37',	NULL,	101,	2),
(31,	'Audit category',	'2019-12-23 13:28:43',	'2020-01-20 13:11:26',	NULL,	8,	2),
(32,	'cat 2',	'2019-12-23 13:28:47',	'2020-01-20 13:11:17',	NULL,	8,	2),
(33,	'Enhancement cat 1',	'2019-12-30 08:20:55',	'2020-01-20 13:11:22',	NULL,	1,	2),
(34,	'Enhancement cat 2',	'2019-12-30 08:20:59',	'2020-01-20 13:11:24',	NULL,	1,	2),
(35,	'Enhancement cat 3',	'2019-12-30 08:21:03',	'2020-01-20 13:11:32',	NULL,	1,	2),
(36,	'wewa',	'2019-12-30 15:40:14',	'2019-12-30 15:40:23',	'2019-12-30 15:40:23',	1,	1),
(37,	'notication category',	'2020-01-07 12:36:27',	'2020-01-20 13:11:49',	NULL,	1,	2),
(38,	'NEW CATEGORY 18/01/2020',	'2020-01-18 12:21:26',	'2020-01-20 13:11:52',	NULL,	101,	2),
(39,	'Forensic Audit',	'2020-01-20 13:13:24',	'2020-01-20 13:13:24',	NULL,	1,	1),
(40,	'Statutory Audit',	'2020-01-20 13:13:39',	'2020-01-20 13:13:39',	NULL,	1,	1),
(41,	'Tax Audit',	'2020-01-20 13:13:59',	'2020-01-20 13:13:59',	NULL,	1,	1),
(42,	'Information System Audit or Information Technology Audit (IT Audit)',	'2020-01-20 13:14:12',	'2020-01-20 13:14:12',	NULL,	1,	1),
(43,	'Value For Money Audit',	'2020-01-20 13:14:30',	'2020-01-20 13:14:30',	NULL,	1,	1),
(44,	'Review Financial Statements',	'2020-01-20 13:14:40',	'2020-01-20 13:14:40',	NULL,	1,	1),
(45,	'Agreed Upon Procedures',	'2020-01-20 13:14:52',	'2020-01-20 13:14:52',	NULL,	1,	1),
(46,	'Integrated Audit',	'2020-01-20 13:15:02',	'2020-01-20 13:15:02',	NULL,	1,	1),
(47,	'Special Audit',	'2020-01-20 13:15:10',	'2020-01-20 13:15:10',	NULL,	1,	1);

DROP TABLE IF EXISTS `audit_closing_meeting_users`;
CREATE TABLE `audit_closing_meeting_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `audit_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `is_present` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `audit_criteria`;
CREATE TABLE `audit_criteria` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_criteria` (`id`, `title`, `created_at`, `updated_at`, `deleted_at`, `status`) VALUES
(1,	'sample criteria 1',	'2018-10-03 14:29:19',	'2018-10-10 09:32:28',	'2018-10-10 09:32:28',	1),
(2,	'sample criteria 2',	'2018-10-03 14:29:19',	'2018-10-10 09:32:32',	'2018-10-10 09:32:32',	1),
(3,	'ISO Standards / International Standards / Manual / Procedure against which the finding is being raised',	'2018-10-10 09:33:06',	'2018-10-10 09:33:06',	NULL,	1),
(4,	'ISO 9001:2015, ISO 14001:2015, BS OHSAS 18001:2007 standards and Operational Procedures',	'2018-10-10 09:33:21',	'2019-06-18 16:26:44',	'2019-06-18 16:26:44',	1),
(5,	'new audit criteria',	'2018-10-30 08:47:02',	'2018-10-30 08:52:40',	'2018-10-30 08:52:40',	1),
(6,	'test',	'2018-10-30 08:49:43',	'2018-10-30 08:52:31',	'2018-10-30 08:52:31',	1),
(7,	'test1',	'2018-10-30 08:49:48',	'2018-10-30 08:52:27',	'2018-10-30 08:52:27',	1),
(8,	'test2',	'2018-10-30 08:49:53',	'2018-10-30 08:51:59',	'2018-10-30 08:51:59',	1),
(9,	'test3',	'2018-10-30 08:49:59',	'2018-10-30 08:51:55',	'2018-10-30 08:51:55',	1),
(10,	'test4',	'2018-10-30 08:50:04',	'2018-10-30 08:51:52',	'2018-10-30 08:51:52',	1),
(11,	'test5',	'2018-10-30 08:50:09',	'2018-10-30 08:51:48',	'2018-10-30 08:51:48',	1),
(12,	'test6',	'2018-10-30 08:50:13',	'2018-10-30 08:51:44',	'2018-10-30 08:51:44',	1),
(13,	'test7',	'2018-10-30 08:50:18',	'2018-10-30 08:51:39',	'2018-10-30 08:51:39',	1),
(14,	'test8',	'2018-10-30 08:50:22',	'2018-10-30 08:51:29',	'2018-10-30 08:51:29',	1),
(15,	'test9',	'2018-10-30 08:50:28',	'2018-10-30 08:51:24',	'2018-10-30 08:51:24',	1),
(16,	'test10',	'2018-10-30 08:50:39',	'2018-10-30 08:52:23',	'2018-10-30 08:52:23',	1),
(17,	'test11',	'2018-10-30 08:50:44',	'2018-10-30 08:52:19',	'2018-10-30 08:52:19',	1),
(18,	'test12',	'2018-10-30 08:50:50',	'2018-10-30 08:52:14',	'2018-10-30 08:52:14',	1),
(19,	'test13',	'2018-10-30 08:50:55',	'2018-10-30 08:52:06',	'2018-10-30 08:52:06',	1),
(20,	'test14',	'2018-10-30 08:51:01',	'2018-10-30 08:52:03',	'2018-10-30 08:52:03',	1),
(21,	'teaast15',	'2018-10-30 08:51:08',	'2018-10-30 08:52:34',	'2018-10-30 08:52:34',	1),
(22,	'The audit scope generally includes a description of the physical locations, organizational units, activities and processes, as well as the time period covered.',	'2018-10-30 08:53:41',	'2018-10-30 08:53:58',	'2018-10-30 08:53:58',	1),
(23,	'ISO 2018',	'2018-11-07 05:57:40',	'2018-11-07 05:57:40',	NULL,	1),
(25,	'ISO 9001:2015, ISO 14001:2015, OHSAS 18001:2007 Requirements',	'2019-06-18 16:23:03',	'2019-06-18 16:26:40',	'2019-06-18 16:26:40',	1),
(27,	'ISO 9001:2015 Requirements',	'2019-06-18 16:23:46',	'2019-06-18 16:23:46',	NULL,	1),
(29,	'ISO 9001:2015, ISO 14001:2015 new Requirements',	'2019-06-18 16:24:02',	'2019-06-18 16:26:32',	'2019-06-18 16:26:32',	1),
(31,	'ISO 14001:2015 new Requirements',	'2019-06-18 16:25:53',	'2019-06-18 16:25:53',	NULL,	1),
(33,	'ISO 14001:2015',	'2019-06-18 16:26:24',	'2019-06-18 16:26:24',	NULL,	1),
(35,	'OHSAS 18001:2007 Requirements',	'2019-06-18 16:26:27',	'2019-06-18 16:26:27',	NULL,	1),
(37,	'ISO 9001:2015',	'2019-06-18 16:27:17',	'2019-06-18 16:27:17',	NULL,	1);

DROP TABLE IF EXISTS `audit_details`;
CREATE TABLE `audit_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `audit_id` int(10) unsigned NOT NULL,
  `title` varchar(500) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `positive_comment` text COLLATE utf8mb4_unicode_ci,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `opening_meeting_start_time` datetime DEFAULT NULL,
  `opening_meeting_end_time` datetime DEFAULT NULL,
  `closing_meeting_start_time` datetime DEFAULT NULL,
  `closing_meeting_end_time` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `version` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'C',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_details` (`id`, `audit_id`, `title`, `description`, `positive_comment`, `start_date`, `end_date`, `opening_meeting_start_time`, `opening_meeting_end_time`, `closing_meeting_start_time`, `closing_meeting_end_time`, `created_at`, `updated_at`, `created_by`, `version`) VALUES
(1,	1,	'Internal Audit 1 - 2018',	NULL,	'1- Context of the department, internal& external issues, interested parties were defined and documented and updated. \n2- DG office staff are aware of their process and procdures. \n3- 2 process have been documented on iGrapix, and documented as SoPs, these are:  Manage inbound correspondence –DGO-G01-P01 (Version 1.0)  Manage outbound correspondence-DGO-G01-P02(Version 1.0) \n4- KPIs has been defined for these process,  \n5- Risks has been defined for the department and updated regularly. Opportunity ',	'2018-12-19',	'2018-12-19',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2018-12-19 00:00:00',	'2019-12-12 13:15:59',	14,	'C'),
(2,	2,	'Internal Audit 2 - 2018',	NULL,	'1-  Staff are fully aware of QHSE Management system, process and SoPs, and implementation & maintain of the system  \n2- Risks has been defined for the department and updated regularly. \n3- Management review is conducted on regular basis. \n4- Internal Audit program is established and maintained. \n5- Nonconformities identified in internal &external audits are closed according to plans. ',	'2018-12-19',	'2018-12-19',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2018-12-20 00:00:00',	'2019-12-12 13:15:59',	14,	'C'),
(3,	3,	'Internal Audit 3 - 2018',	NULL,	NULL,	'2018-12-16',	'2018-12-16',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2018-12-16 00:00:00',	'2019-12-12 13:15:59',	14,	'C'),
(4,	4,	'Internal Audit 4 - 2018',	NULL,	'1- All internal non confirmities for last audit plan has been closed\n2- Awareness session has been conducted for IT staff in respect of ISO standards\n-3 Please SoPs and forms to the gate as linked to Igraphics',	'2018-12-17',	'2018-12-17',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2018-12-17 00:00:00',	'2019-12-12 13:15:59',	14,	'C'),
(5,	5,	'Internal Audit 5 - 2018',	NULL,	'1- Process is identified for all the section (33 process is defined) \n2- 20 of the process have been flowcharted in Graphic system \n3- KPI is defined and reported for some of the process \n4- mPMO has full documentation of all the project in TRA  ',	'2018-12-18',	'2018-12-18',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2018-12-18 00:00:00',	'2019-12-12 13:15:59',	14,	'C'),
(6,	6,	'Internal Audit 6 - 2018',	NULL,	'1- Process is identified for all the section (6 process is defined) \n2- Comperhensive matrix of all the events is evidence  \n3- Automation system is underdevelopement to overcome some challenge in the department  \n4- 13 KPI is reported annually ',	'2018-12-17',	'2018-12-17',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2018-12-17 00:00:00',	'2019-12-12 13:15:59',	14,	'C'),
(7,	7,	'Internal Audit 7 - 2018',	NULL,	'1- Total of 50 processes and number of documented processes 29 \n2- Define and update cost service and service charging model process KPIs are being monitored in the Operational Plan \n3- The staff know the place of all processes in iGrafx and it is being reviewed and updated frequently. \n4- The needs and expectation of Interested parties are being reviewed on daily/weekly/monthly basis either externally and Internally \n5- The complains and cases from the different entity is being handled and monitored by the team daily and during their weekly meeting \n6- The staff is taking training courses based on their yearly training plan in align with his job roles and responsibilities. And there is a meeting with the staff to see what is their weakness that they need to focus on \n7- The staff know the fire exits and assembly point and where is the location of the first aid box ',	'2018-12-20',	'2018-12-20',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2018-12-20 00:00:00',	'2019-12-12 13:15:59',	14,	'C'),
(8,	8,	'Internal Audit 8 - 2018',	NULL,	NULL,	'2018-12-18',	'2018-12-18',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2018-12-18 00:00:00',	'2019-12-12 13:15:59',	14,	'C'),
(9,	9,	'Internal Audit 9 - 2018',	NULL,	NULL,	'2018-12-18',	'2018-12-18',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2018-12-18 00:00:00',	'2019-12-12 13:15:59',	14,	'C'),
(10,	10,	'Internal Audit 10 - 2018',	NULL,	'1- Spectrum Affairs process owner\'s demonstrated god awareness about the requirement of ISO 9001:2015, ISO 14001:2015, OHSAS 18001:2017\n2- Non-confirmities which have been identified by BSI in the previous external audit have been corrected\n3- Spectrum Affairs Department determined their interested parties and issues identified the issue description, risk assessment, relevant risk control, control frequency as well as the mitigation plan with implementation timelines.\n4- The Department Risk Regiser reconciles with the TRA\'s Risk Reister. Mitigation and treatment plans and controls is in place to address and to eliminate the recurrence of all identified risks.\n5- The Department KPI\'s reconciles with the KPI\'s listed under the department operational plan\n6- The quality objective Matrix is well monitored and reported',	'2018-12-17',	'2018-12-17',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2018-12-17 00:00:00',	'2019-12-12 13:15:59',	14,	'C'),
(11,	11,	'Internal Audit 11 - 2018',	NULL,	NULL,	'2018-12-18',	'2018-12-18',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2018-12-18 00:00:00',	'2019-12-12 13:15:59',	14,	'C'),
(12,	12,	'Internal Audit 12 - 2018',	NULL,	NULL,	'2018-12-19',	'2018-12-19',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2018-12-19 00:00:00',	'2019-12-12 13:15:59',	14,	'C'),
(13,	13,	'Internal Audit 13 - 2018',	NULL,	'Enter later',	'2018-12-18',	'2018-12-18',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2018-12-18 00:00:00',	'2019-12-12 13:15:59',	14,	'C'),
(14,	14,	'Internal Audit 14 - 2018',	NULL,	'1- All External and internal previous audit comments has been closed and rectified.\n2- CCD\'s Operational KPIs result are well presented, and updated into ADAA\'s system\n3- Awareness session has been conducted about ISO standards at the beginning of the year 2018.\n4- Risk Register is updated on a monthly basis to Internal Audit and Risk Management Dept.',	'2018-12-19',	'2018-12-19',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2018-12-19 00:00:00',	'2019-12-12 13:15:59',	14,	'C'),
(15,	15,	'Internal Audit 15 - 2018',	NULL,	'1- Finance Staff demonstrated good awareness about the update on the ISO 9001:2015, ISO 14001:2015, OHSAS 18001:2017. HOD demonstrated full awareness of the requirements and involvement throughout the audit session\n2- Due to the nature of Finance operations/processes, the department undergo the following audits which resulted in continuous monitoring, good documentation, good record keeping/evidence as well as continual improvement by the department.\n3- The external auditors have not observed any non-confirmity with Finance since 2004. All observations are closed and audits are therefore completed successfully.\nand audits are therefore completed successfully.\n4- Finance runs standardized operations, unlike projects, which in that case does not involve frequent changes and or updates to the identified items in relation to Article 4 of the ISO 9001:2017. However, despite that the team continues reviewing the requirements and the necessity for amendments.\n5- the requirements recorded by the Finance in relation to Article 4 of ISO 9001:2017 is in line with the TRA\'s risk register containing risk related to the Strategic and Operational Plan.',	'2018-12-12',	'2018-12-12',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2018-12-12 00:00:00',	'2019-12-12 13:15:59',	14,	'C'),
(16,	16,	'Internal Audit 16 - 2018',	NULL,	NULL,	'2018-12-24',	'2018-12-24',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2018-12-24 00:00:00',	'2019-12-12 13:15:59',	14,	'C'),
(17,	17,	'Internal Audit 17 - 2018',	NULL,	NULL,	'2018-12-19',	'2018-12-19',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2018-12-19 00:00:00',	'2019-12-12 13:15:59',	14,	'C'),
(18,	18,	'Internal Audit 18 - 2018',	NULL,	'1- Customer complaints are tracked through electronic system which takes easy to track and resolve raised issues.\n2- More KPIs were defined in the aeDomain operational plan to measure the performance of the documented processes.\n3- Good level of HSE awareness.',	'2018-12-19',	'2018-12-19',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2018-12-19 00:00:00',	'2019-12-12 13:15:59',	14,	'C'),
(19,	19,	'Internal Audit 19 - 2018',	NULL,	'1- Context of the department, internal& external issues, interested parties were defined and documented and updated. \n2- Legal department staff is fully aware of their process and procdures. \n3- 13 process have been documented on iGrapix, and legal department in process for merging it into 11 process. \n4- Risks has been defined for the department and updated regularly. ',	'2018-12-19',	'2018-12-19',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2018-12-19 00:00:00',	'2019-12-12 13:15:59',	14,	'C'),
(20,	20,	'Internal Audit 20 - 2018',	NULL,	'1- 30 Quality objective is defined \n2- Process are reengineered for better alignment \n3- Flowchart is developed for the process \n ',	'2018-12-31',	'2018-12-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2018-12-31 00:00:00',	'2019-12-12 13:15:59',	14,	'C'),
(21,	21,	'Other Audit 1 -2017',	NULL,	'1- Risks associated with DG Office process related to Manage Correspondence have been identified\n2- List of interested parties and their need and risk associated was available. ',	'2017-05-09',	'2017-05-09',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2017-05-09 00:00:00',	'2019-12-12 13:15:59',	14,	'C'),
(22,	22,	'Other Audit 2 -2017',	NULL,	'1- Well presenting section documentation\n2- Monitoring Dashboard well presented  ',	'2017-05-02',	'2017-05-02',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2017-05-02 00:00:00',	'2019-12-12 13:15:59',	14,	'C'),
(23,	23,	'Other Audit 3 -2017',	NULL,	'1- Well presenting section documentation',	'2017-05-02',	'2017-05-02',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2017-05-02 00:00:00',	'2019-12-12 13:15:59',	14,	'C'),
(24,	24,	'Other Audit 4 -2017',	NULL,	'1- Well documentation of the issues, interested parties needs and expectation, and the risk\n2- Opportunities is defined based on the review  of the process\n3- New system is being implemented for the documentation of the process (IGraphics)',	'2017-05-04',	'2017-05-04',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2017-05-04 00:00:00',	'2019-12-12 13:15:59',	14,	'C'),
(25,	25,	'Other Audit 5 -2017',	NULL,	'1- Well documentation of the issues, interested parties needs and expectation, and the risk\n2- Opportunities is defined based on the review  of the process\n3- New system is being implemented for the documentation of the process (IGraphics)',	'2017-05-04',	'2017-05-04',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2017-05-04 00:00:00',	'2019-12-12 13:15:59',	14,	'C'),
(26,	26,	'Other Audit 6 -2017',	NULL,	'1- All new requirments was well prepared by eGov Operation Department ISO coordinator',	'2016-05-03',	'2016-05-03',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2016-05-03 00:00:00',	'2019-12-12 13:15:59',	14,	'C'),
(27,	27,	'Other Audit 7 -2017',	NULL,	'1- All new requirments was well prepared by Development  Department ISO coordinator',	'2017-05-01',	'2017-05-01',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2017-05-01 00:00:00',	'2019-12-12 13:15:59',	14,	'C'),
(28,	28,	'Other Audit 8 -2017',	NULL,	'1- All new requirments was well prepared by Customers Happines Section ISO coordinator',	'2017-05-01',	'2017-05-01',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2017-05-01 00:00:00',	'2019-12-12 13:15:59',	14,	'C'),
(29,	29,	'Other Audit 9 -2017',	NULL,	'1- Spectrum Affairs process owner\'s demonstrated good awareness about the update of the ISO 9001:2015 and ISO 14001:2015.\n2- Maintenance of the monitoring system has resulted in reducing the use of  the generator and level of vehicle emission having adverse effect on the environment .\n3- Back up plan for the data center was established to ensure business continuith in the event of fire and or natural disaster.\n4- Providing access to the source of entrance prevented staff from delay in executing their work as well as protected them from any accusations and or harms, which they can be exposed to , from a non-authorized access. \n5- Observations which  have been detected in the prvious external audits have been reflected now as and is considered part of the department\'s continual improvement.',	'2017-05-02',	'2017-05-02',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2017-05-02 00:00:00',	'2019-12-12 13:15:59',	14,	'C'),
(30,	30,	'Other Audit 10 -2017',	NULL,	'1- There was a determination for Internal and external Issues based and classified based on a link with each operations\n2- Most of the issues were related to auditing Du/Etisalat and markets\n3- There is a process of monitoring some of these issues through issuing new polices and regulations to avoid incompliance. Additionally, the process of monitoring to consider issues changes is being implemented by getting directions from Top Management and regular departmental meetings.\n4- Interested parties were identified and most of them are external : Telecom Licensees  and Telecom Equipment dealer\n5- Needs and expectations of the interested parties were determined by issued policies and regulations and are being monitored and followed up by regular meetings and annual surveys outputs\n6-  Risks were addressed mainly on the operations level and being monitored and submitted on a monthly basis.\n7-  The requirements of customers being communicated inward and outward by conducting : surveys,, partnerships and agreements\n8-  Identification and traceability requirements are applied and met in some TDA operations like : Type Approval and Numbering allocation and most of the services were automated and requires less human Interference. RFID reader is being used for device tracking in Type Approval Lab\n9- • While approving a device, a notification is being sent to the customer that the device has been received and a notification also will be sending again to the customer in case the devise was damaged because of not passing the inspection process.\n10- Continual Improvement is being achieved by : Services Development Committee requirements, department processes re-engineering and Operational Plan initiatives',	'2017-05-01',	'2017-05-01',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2017-05-01 00:00:00',	'2019-12-12 13:15:59',	14,	'C'),
(31,	31,	'Other Audit 11 -2017',	NULL,	'1- There was a clear understanding of RAD and its context were 22 Issues have been determined. Four Interned Issues and the remaining 18 are external issues that are being monitored and revieed by RAD management team\n2- Some of the issues thatt might face the team with the licensees are either to get misleading information or incomplete list of requirments\n3- Interested parties an dthere needs have been identified and mostly are : TRA management, Lincensees, employees, ITU and consumers\n4- Risks and opportunities were addressed and being monitored and reviewed by the processes onwners and being submitted as requested on monthly/quarterly bassis \n5- Some examples of continual improvement in RAD system are : automation of price control process, reviewed regulartory framework and mapping the departments processes to iGrafx',	'2017-04-30',	'2017-04-30',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2017-04-30 00:00:00',	'2019-12-12 13:15:59',	14,	'C'),
(32,	32,	'Other Audit 12 -2017',	NULL,	'1- New automation of services\n2- Regular reporting on the performance of the operation\n3- Needs and expectation of interested parties is gathered though different means\n4- Simplification of some process for better performance ',	'2017-04-05',	'2017-04-05',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2017-04-05 00:00:00',	'2019-12-12 13:15:59',	14,	'C'),
(33,	33,	'Other Audit 13 -2017',	NULL,	NULL,	'2017-05-04',	'2017-05-04',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2017-05-04 00:00:00',	'2019-12-12 13:15:59',	14,	'C'),
(34,	34,	'Other Audit 14 -2017',	NULL,	'1- HOD and Finance Affairs process owners\' demonstrated good awareness about the update on the ISO 9001:2015 and ISO 14001:2015. HOD demonstrated full awareness of the requirments and involvement throughout the audit session.\n2- Due to the nature of Finance operations /processes, the department underg 1) a number  of different external audits throughtout the year; and 2) a 3-layer of checking compliance within the department itself. These activites resulted in continous monitoring, good documentation , good record keeping /evidence as well as continual improvement by the department.\n3- The external auditors have not observed any non-conformity with Finance since 2004.\n4- Finance runs standardized operations, unlike projects, which in that case does not involve frequent changes and or updates to the indentifed items in relation to Article 4 of the ISO 9001:2015. However, dspite that the team continues reviewing the rewirments and the necessity for amendments.\n5- The requirements recorded by the Finance in relation to Article 4 of ISO 9001:2015 is in line with the TRA\'s risk register containing risks related to the Strategic and Operational Plan. ',	'2017-05-02',	'2017-05-02',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2017-05-02 00:00:00',	'2019-12-12 13:15:59',	14,	'C'),
(35,	35,	'Other Audit 15 -2017',	NULL,	'1- Clear understanding of the roles and responsibilities which main focuses on : Internet Access governance and management, Internal Events representing ICT sector\n2- Internal and external  issues were determined \n3- Interested parties have been identified and they are mainly : Licensees, governmets entities and customers\n4- The Information of their needs and expectations have been listed \n5- Risks have been addressed and bing monitored and submitted on regular basis \n6- Continual Improvement is being Implemented by : section review, Include new procedure/service in the system like : removing accounts from social media websites',	'2017-05-02',	'2017-05-02',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2017-05-02 00:00:00',	'2019-12-12 13:15:59',	14,	'C'),
(36,	36,	'Other Audit 16 -2017',	NULL,	'1- There was a clear understanding of the roles and responsibilities of the section which are : Analyzing and monitoring, Information security quality services and education & awareness services\n2-  Internal and external issues have been determined\n3- Interested parties have been identified and mainly they are : government entities, private sectors, universities and TRA employees\n4- Their needs and expectations have been identified and reviewed\n5- Risk and opportunities have been addressed in a very unique way and are being monitored effectively\n6- Processes objectives have been planned, monitored and achieved\n7- Any services delivered through the system, a survey will be requested to be filled and all communication through the system with the service’s requester\n8- Continual Improvement is being Implemented by : awareness are accessible in e-portal, most of excel sheets have been automated into the system and a Collaborative Platform « IP Reputation« in one of the leading initiatives on GCC level',	'2017-05-02',	'2017-05-02',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2017-05-02 00:00:00',	'2019-12-12 13:15:59',	14,	'C'),
(37,	37,	'Other Audit 17 -2017',	NULL,	'1-There was a clear understanding  of the roles and responsibility of the decction which mainly focuses on : Registears servces administration, Domain names administration , Registrars  lincensing and consumers disputes\n2-Internal and external Issues were  determined and being monitored \n3- Information about the interested parties needs and expectations have been indentified. Examples of External Interested parties : Registrar and registrant , example of internal interested party : top management \n4- The process of monitor the needs and expectations of the interested prties is through the signed agreements and surveys\n5- There is a list of documented processes and policies \n6- Risks register, assessment and mitigations were addressed\n7- Quality objective  of the processes are available and reported quarterly \n8- Continual Improvements is being implemented by modifying the section processes based on customers feedback  ',	'2017-05-02',	'2017-05-02',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2017-05-02 00:00:00',	'2019-12-12 13:15:59',	14,	'C'),
(38,	38,	'Other Audit 18 -2017',	NULL,	'1- Regular reporting on the performance of the operation \n2- Needs and expectation of interested parties is gathered though different means\n3- Simplification of some process for better performance ',	'2017-05-02',	'2017-05-02',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2017-05-02 00:00:00',	'2019-12-12 13:15:59',	14,	'C'),
(39,	39,	'TEST',	NULL,	NULL,	'2019-12-01',	'2019-12-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2019-12-17 14:58:22',	'2019-12-17 14:58:22',	101,	'C'),
(40,	40,	'Technical audit',	NULL,	NULL,	'2019-12-01',	'2019-12-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2019-12-18 10:32:02',	'2019-12-18 10:32:02',	101,	'C'),
(41,	41,	'Test adit by jeeva',	'test description',	'<p><span style=\"font-size: 14px;text-align: justify;float: none;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum</span><!--EndFragment--><br/><br/><br/></p>',	'2019-10-01',	'2019-10-10',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2019-12-20 08:58:15',	'2019-12-20 08:58:15',	527,	'C'),
(42,	42,	'IMS audit',	'Test description',	'<p>positive comment 1</p>',	'2019-10-01',	'2019-10-01',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2019-12-23 09:52:21',	'2019-12-23 09:52:21',	329,	'C'),
(43,	43,	'IMS audit',	NULL,	NULL,	'2019-11-07',	'2019-11-08',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2019-12-23 10:10:46',	'2019-12-23 10:10:46',	79,	'C'),
(44,	44,	'test auto published',	NULL,	NULL,	'2019-12-01',	'2019-12-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2019-12-23 12:47:23',	'2019-12-23 12:47:23',	101,	'C'),
(45,	45,	'Audit cate test',	NULL,	NULL,	'2019-12-01',	'2019-12-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2019-12-23 13:53:59',	'2019-12-23 13:53:59',	527,	'C'),
(46,	46,	'tra server issue',	NULL,	NULL,	'2019-12-01',	'2019-12-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2019-12-24 10:42:13',	'2019-12-24 10:42:13',	53,	'C'),
(47,	47,	'IA 2019 August',	'Test description',	NULL,	'2020-01-01',	'2020-01-16',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2019-12-30 09:44:51',	'2019-12-30 09:44:51',	297,	'C'),
(48,	48,	'IA2020',	NULL,	NULL,	'2019-02-01',	'2019-02-28',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2019-12-30 10:18:02',	'2019-12-30 10:18:02',	527,	'C'),
(49,	49,	'Test 3',	'Lorem ipsum, or lipsum as it is sometimes known, is dummy text used in laying out print, graphic or web designs',	NULL,	'2020-02-01',	'2020-02-28',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2019-12-31 09:39:06',	'2019-12-31 09:39:06',	101,	'C'),
(50,	50,	'checking DB Notification',	NULL,	NULL,	'2020-01-01',	'2020-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2020-01-01 15:06:28',	'2020-01-01 15:06:28',	527,	'C'),
(51,	51,	'Test',	NULL,	NULL,	'2020-01-03',	'2020-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2020-01-03 10:56:59',	'2020-01-03 10:56:59',	101,	'C'),
(52,	52,	'test1audi',	NULL,	NULL,	'2019-01-01',	'2019-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2020-01-04 10:14:47',	'2020-01-04 10:14:47',	329,	'C'),
(53,	53,	'checking condition',	'test description',	'<p>test description</p>',	'2018-01-01',	'2018-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2020-01-06 09:58:48',	'2020-01-06 09:58:48',	383,	'C'),
(54,	54,	'sawad issue',	'test description',	'<p>tra</p>',	'2018-01-01',	'2018-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2020-01-06 13:55:13',	'2020-01-06 14:34:39',	1,	'C'),
(55,	55,	'test audit',	'description',	NULL,	'2020-01-07',	'2020-01-07',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2020-01-07 08:51:06',	'2020-01-07 08:51:06',	101,	'C'),
(56,	56,	'notification issue checkingfgg',	NULL,	NULL,	'2020-01-01',	'2020-01-03',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2020-01-07 13:01:56',	'2020-01-07 13:01:56',	527,	'C'),
(57,	57,	'second testingg',	NULL,	NULL,	'2020-01-01',	'2020-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2020-01-07 13:36:38',	'2020-01-07 13:36:38',	527,	'C'),
(58,	58,	'internal audit 8/1/2020',	'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum',	'<p></p><ul><li><span style=\"font-size: 14px;text-align: justify;float: none;\">Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae </span></li><li><span style=\"font-size: 14px;text-align: justify;float: none;\">vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia</span></li><li><span style=\"font-size: 14px;text-align: justify;float: none;\"> consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem </span></li><li><span style=\"font-size: 14px;text-align: justify;float: none;\">ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et </span></li><li><span style=\"font-size: 14px;text-align: justify;float: none;\">dolore magnam aliquam quaerat voluptatem. </span></li><li><span style=\"font-size: 14px;text-align: justify;float: none;\">Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? </span></li><li><span style=\"font-size: 14px;text-align: justify;float: none;\">Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat </span></li><li><span style=\"font-size: 14px;text-align: justify;float: none;\">quo voluptas nulla pariatu</span></li></ul><p>test</p><p><br/></p><p></p>',	'2020-02-01',	'2020-02-28',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2020-01-08 09:35:56',	'2020-01-08 10:23:35',	101,	'C'),
(59,	59,	'test title',	'test descriptionn',	NULL,	'2020-02-01',	'2020-02-28',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2020-01-08 17:07:12',	'2020-01-08 17:07:29',	101,	'C'),
(60,	60,	'title',	'tut8ut7i789o7908098test ytest',	NULL,	'2020-03-01',	'2020-03-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2020-01-08 17:16:43',	'2020-01-08 17:16:43',	101,	'C'),
(61,	61,	'Recheking rashed issue',	'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum',	NULL,	'2012-02-01',	'2012-02-28',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2020-01-09 08:54:11',	'2020-01-09 08:54:11',	527,	'C'),
(62,	62,	'An ISO 9001 audit checklist is a useful tool to ensure that nothing is missed when reviewing process records in order to confirm requirements are met',	'test description',	'<p>positive</p>',	'2022-01-12',	'2022-01-20',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2020-01-10 10:40:33',	'2020-01-10 10:45:03',	535,	'C'),
(63,	63,	'testttttttttttt16',	NULL,	NULL,	'2032-01-01',	'2032-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2020-01-16 09:24:01',	'2020-01-16 09:24:01',	527,	'C'),
(64,	64,	'jeeva test plan notiification sawad',	NULL,	NULL,	'2036-03-01',	'2036-03-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2020-01-16 10:32:53',	'2020-01-16 10:32:53',	527,	'C'),
(65,	65,	'ASdasergs',	'dfgrddtn',	'<p>QDQw</p>',	'2020-01-01',	'2020-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2020-01-17 09:26:47',	'2020-01-17 09:28:03',	527,	'C'),
(66,	66,	'rtshrt',	'hrt',	NULL,	'2020-01-01',	'2020-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2020-01-17 09:57:16',	'2020-01-17 09:57:16',	527,	'C'),
(67,	67,	'checking audit flow',	'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum',	'<p>Sed ut perspiciatis unde omnis iste natus error</p><ul><li> sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos</li><li> qui ratione voluptatem sequi nesciunt. Neque p</li><li>orro quisquam est, qui dolorem ipsum quia dol</li><li>or sit amet, consectetur, adipisci velit, sed quia n</li><li>on numquam eius modi tempora incidunt ut labo</li><li>re et dolore magnam aliquam quaerat voluptatem</li><li>. Ut enim ad minima veniam, quis nostrum exerc</li><li>itationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehend</li><li>derit qui in ea voluptate velit esse quam nihil mo</li><li>lestiae consequatur, vel illum qui dolorem eum fug</li><li>iat quo voluptas nulla pariatur​</li></ul>',	'2020-05-01',	'2020-05-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2020-01-18 13:49:49',	'2020-01-18 13:54:17',	527,	'C'),
(68,	68,	'test',	'test description',	NULL,	'2020-01-01',	'2020-01-15',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2020-01-20 14:50:30',	'2020-01-20 14:50:30',	539,	'C'),
(69,	69,	'testing filter',	'\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum',	'<ul><li><span style=\"font-size: 14px;text-align: justify;float: none;\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore e</span></li><li><span style=\"font-size: 14px;text-align: justify;float: none;\">t dolore magna aliqua.</span></li><li><span style=\"font-size: 14px;text-align: justify;float: none;\"> Ut enim ad minim venia</span></li><li><span style=\"font-size: 14px;text-align: justify;float: none;\">m, quis nostrud exercitatio</span></li><li><span style=\"font-size: 14px;text-align: justify;float: none;\">n ullamco laboris nisi ut aliquip e</span></li><li><span style=\"font-size: 14px;text-align: justify;float: none;\">x ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occa</span></li><li><span style=\"font-size: 14px;text-align: justify;float: none;\">ecat cupidatat non proident, sunt in culpa qui offic</span></li><li><span style=\"font-size: 14px;text-align: justify;float: none;\">ia deserunt mollit anim id est laborum</span><!--EndFragment--><br/><br/><br/></li></ul>',	'2020-03-01',	'2020-03-17',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2020-01-23 11:08:12',	'2020-01-23 13:10:10',	539,	'C'),
(70,	70,	'tax audit',	'test description',	'<p>positive omments</p>',	'2020-06-30',	'2020-06-30',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2020-01-25 15:52:33',	'2020-01-25 15:53:27',	527,	'C'),
(71,	71,	'Special audit',	'Test description',	NULL,	'2020-03-13',	'2020-03-24',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'2020-01-31 08:50:38',	'2020-01-31 08:50:38',	527,	'C');

DROP TABLE IF EXISTS `audit_findings`;
CREATE TABLE `audit_findings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `unique_id` int(11) DEFAULT NULL,
  `audit_id` int(10) unsigned NOT NULL,
  `audit_finding_category_id` int(10) unsigned DEFAULT NULL,
  `department_id` int(10) unsigned DEFAULT NULL,
  `responsible_department_id` int(11) DEFAULT NULL,
  `responsible_user_id` int(11) DEFAULT NULL,
  `schedule_id` int(10) unsigned DEFAULT NULL,
  `risk_rating_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `closed_by` int(10) unsigned DEFAULT NULL,
  `audit_finding_status_id` int(10) unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `evidence` text COLLATE utf8mb4_unicode_ci,
  `file_name` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL,
  `url_name` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL,
  `correction` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `correction_description` text COLLATE utf8mb4_unicode_ci,
  `is_external_findings` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `closed_at` date NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `updated_by` int(10) unsigned DEFAULT NULL,
  `deleted_by` int(10) unsigned DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1',
  `audit_program_id` int(10) unsigned NOT NULL,
  `recommendation` text COLLATE utf8mb4_unicode_ci,
  `positive_comment` text COLLATE utf8mb4_unicode_ci,
  `resolve_date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_findings` (`id`, `unique_id`, `audit_id`, `audit_finding_category_id`, `department_id`, `responsible_department_id`, `responsible_user_id`, `schedule_id`, `risk_rating_id`, `user_id`, `closed_by`, `audit_finding_status_id`, `title`, `description`, `evidence`, `file_name`, `url_name`, `correction`, `correction_description`, `is_external_findings`, `created_at`, `updated_at`, `closed_at`, `deleted_at`, `created_by`, `updated_by`, `deleted_by`, `status`, `audit_program_id`, `recommendation`, `positive_comment`, `resolve_date`) VALUES
(1,	1,	39,	2,	NULL,	4,	8,	39,	1,	101,	NULL,	3,	'test finding',	NULL,	NULL,	'',	'',	NULL,	NULL,	1,	'2019-12-17 14:58:51',	'2019-12-17 15:03:15',	'0000-00-00',	NULL,	101,	NULL,	NULL,	1,	3,	NULL,	NULL,	NULL),
(2,	2,	40,	3,	NULL,	4,	8,	40,	2,	101,	NULL,	3,	'test finding',	NULL,	NULL,	'',	'',	NULL,	NULL,	1,	'2019-12-18 10:32:37',	'2019-12-18 10:53:05',	'0000-00-00',	NULL,	101,	NULL,	NULL,	1,	4,	NULL,	NULL,	NULL),
(3,	3,	40,	10,	NULL,	4,	8,	40,	2,	101,	NULL,	2,	'test finding 3',	NULL,	NULL,	'',	'',	NULL,	NULL,	1,	'2019-12-18 10:32:56',	'2019-12-20 10:11:32',	'0000-00-00',	NULL,	101,	NULL,	NULL,	1,	4,	NULL,	NULL,	NULL),
(4,	4,	41,	2,	NULL,	NULL,	NULL,	41,	NULL,	527,	NULL,	2,	'AUdit finding1',	NULL,	NULL,	'',	'',	NULL,	NULL,	1,	'2019-12-20 09:56:16',	'2019-12-20 09:56:16',	'0000-00-00',	NULL,	527,	NULL,	NULL,	1,	7,	NULL,	NULL,	NULL),
(5,	5,	42,	2,	NULL,	NULL,	NULL,	43,	1,	329,	NULL,	1,	'finding 23-12-2019',	NULL,	'Evidence',	'Auditable item-master-preview &save.png',	'Wo8Rpp9495Z8bSpun5z2KuIJHyuppmcyjCcni9wN.png',	NULL,	NULL,	1,	'2019-12-23 09:53:12',	'2019-12-23 09:53:12',	'0000-00-00',	NULL,	329,	NULL,	NULL,	1,	13,	'recommedation',	NULL,	NULL),
(6,	6,	42,	10,	NULL,	NULL,	NULL,	43,	1,	1,	NULL,	7,	'finding IA',	NULL,	NULL,	'',	'',	NULL,	NULL,	1,	'2019-12-23 09:58:21',	'2019-12-23 10:56:52',	'0000-00-00',	NULL,	1,	NULL,	NULL,	1,	13,	NULL,	NULL,	NULL),
(7,	7,	43,	2,	NULL,	1,	1,	44,	2,	101,	NULL,	2,	'Find1',	'<p>test description</p>',	'test evidence',	'',	'',	NULL,	NULL,	1,	'2019-12-23 10:13:34',	'2019-12-31 12:56:44',	'0000-00-00',	NULL,	101,	NULL,	NULL,	1,	13,	'test recommedation',	NULL,	NULL),
(8,	8,	43,	10,	NULL,	1,	1,	45,	2,	1,	NULL,	2,	'finding saif',	NULL,	NULL,	'',	'',	NULL,	NULL,	1,	'2019-12-23 10:14:06',	'1970-01-01 04:00:01',	'0000-00-00',	NULL,	101,	NULL,	NULL,	1,	13,	NULL,	NULL,	NULL),
(9,	1,	1,	2,	4,	NULL,	NULL,	NULL,	1,	527,	NULL,	2,	'external audit finding',	'<p>Test description</p>',	NULL,	'',	'',	NULL,	NULL,	2,	'2019-12-23 10:19:17',	'2019-12-23 10:19:17',	'0000-00-00',	NULL,	527,	NULL,	NULL,	1,	0,	NULL,	NULL,	NULL),
(10,	2,	1,	3,	10,	NULL,	NULL,	NULL,	2,	527,	NULL,	2,	'External audit finding',	NULL,	NULL,	'',	'',	NULL,	NULL,	2,	'2019-12-23 10:19:47',	'2019-12-23 10:19:47',	'0000-00-00',	NULL,	527,	NULL,	NULL,	1,	0,	NULL,	NULL,	NULL),
(11,	3,	1,	10,	21,	4,	8,	NULL,	2,	1,	NULL,	6,	'External audit finding 25-10-2019',	NULL,	NULL,	'',	'',	NULL,	NULL,	2,	'2019-12-23 10:27:55',	'2019-12-23 10:37:27',	'0000-00-00',	NULL,	1,	NULL,	NULL,	1,	0,	NULL,	NULL,	'2019-12-23'),
(12,	4,	1,	4,	19,	NULL,	NULL,	NULL,	NULL,	8,	NULL,	2,	'test',	NULL,	NULL,	'',	'',	NULL,	NULL,	2,	'2019-12-23 10:38:37',	'2019-12-23 10:38:37',	'0000-00-00',	NULL,	8,	NULL,	NULL,	1,	0,	NULL,	NULL,	NULL),
(13,	9,	44,	2,	NULL,	1,	1,	46,	1,	1,	NULL,	2,	'pub.finding',	NULL,	NULL,	'Untitled-remove.png',	'V6bM6nJVKZs65ynTMIxIzHUylUfgZmcCKywavPJy.png',	NULL,	NULL,	1,	'2019-12-23 12:47:48',	'1970-01-01 04:00:01',	'0000-00-00',	NULL,	101,	NULL,	NULL,	1,	13,	NULL,	NULL,	NULL),
(14,	10,	46,	4,	NULL,	1,	1,	48,	1,	53,	NULL,	1,	'Checking tra server isssue 0001',	'<p>test description</p>',	NULL,	'',	'',	NULL,	NULL,	1,	'2019-12-24 10:43:49',	'2019-12-27 08:02:53',	'0000-00-00',	NULL,	53,	NULL,	NULL,	1,	15,	NULL,	NULL,	NULL),
(15,	11,	49,	3,	NULL,	NULL,	NULL,	53,	1,	101,	NULL,	1,	'confirmation popup',	'<p><em style=\"font-size: 14px;text-align: left;\"><b>Lorem</b></em><span style=\"font-size: 14px;text-align: left;float: none;\"> ipsum, or lipsum as it is sometimes known, is dummy text used in laying out print, graphic or web designs</span><!--EndFragment--><br/><br/><br/></p>',	'Evidence',	'aaaSample4 (2) (2) (1) (6) (1) (3).PDF',	'JR7lgri9uGxlYk5B9rCaz9eFZTgNBDLYO1p8Ui7J.pdf',	NULL,	NULL,	1,	'2019-12-31 09:59:15',	'1970-01-01 04:01:41',	'0000-00-00',	NULL,	101,	NULL,	NULL,	1,	17,	'recommedation',	NULL,	NULL),
(16,	12,	49,	10,	NULL,	NULL,	NULL,	53,	1,	101,	NULL,	1,	'test finding',	'<p>test description</p>',	'evidence',	'',	'',	NULL,	NULL,	1,	'2019-12-31 10:08:59',	'2019-12-31 10:08:59',	'0000-00-00',	NULL,	101,	NULL,	NULL,	1,	17,	'recommedation',	NULL,	NULL),
(17,	13,	49,	10,	NULL,	NULL,	NULL,	53,	2,	101,	NULL,	1,	'finding',	'<p>description</p>',	'evidence',	'',	'',	NULL,	NULL,	1,	'2019-12-31 10:10:34',	'2019-12-31 10:10:34',	'0000-00-00',	NULL,	101,	NULL,	NULL,	1,	17,	'recommedation',	NULL,	NULL),
(18,	5,	3,	3,	25,	NULL,	NULL,	NULL,	1,	1,	NULL,	2,	'find1',	NULL,	'fdsf',	'',	'',	NULL,	NULL,	2,	'2019-12-31 14:47:48',	'1970-01-01 04:00:01',	'0000-00-00',	NULL,	1,	NULL,	NULL,	1,	0,	'fsfsd',	NULL,	NULL),
(19,	1,	50,	2,	NULL,	1,	1,	54,	1,	527,	NULL,	2,	'Test finding',	NULL,	NULL,	'',	'',	NULL,	NULL,	1,	'2020-01-01 15:31:41',	'2020-01-03 09:01:42',	'0000-00-00',	NULL,	527,	NULL,	NULL,	1,	19,	NULL,	NULL,	NULL),
(20,	2,	50,	3,	NULL,	2,	389,	54,	2,	527,	NULL,	5,	'Find 2',	NULL,	NULL,	'',	'',	NULL,	NULL,	1,	'2020-01-01 15:32:13',	'2020-01-01 16:30:06',	'0000-00-00',	NULL,	527,	NULL,	NULL,	1,	19,	NULL,	NULL,	NULL),
(21,	1,	4,	3,	14,	NULL,	NULL,	NULL,	1,	389,	NULL,	2,	'checkin DB notification -External audit',	'<p>test description</p>',	'Test evidence',	'',	'',	NULL,	NULL,	2,	'2020-01-01 16:45:29',	'2020-01-01 16:45:29',	'0000-00-00',	NULL,	389,	NULL,	NULL,	1,	0,	'test recommedation',	NULL,	NULL),
(22,	2,	4,	10,	10,	1,	1,	NULL,	1,	389,	NULL,	6,	'eternal audit finding  -',	NULL,	NULL,	'',	'',	NULL,	NULL,	2,	'2020-01-01 16:47:59',	'2020-01-02 08:16:00',	'0000-00-00',	NULL,	389,	NULL,	NULL,	1,	0,	NULL,	NULL,	'2020-01-02'),
(23,	3,	5,	2,	1,	NULL,	NULL,	NULL,	1,	1,	NULL,	2,	'all user dept .Finding1',	NULL,	'Test evidence',	'aaaSample4 (2) (2) (1) (6) (1) (3) (1) (1).PDF',	'dBmPpOZxPabYkULCHO7SjLyCH3rnVrSmevqbnKOd.pdf',	NULL,	NULL,	2,	'2020-01-02 15:10:11',	'2020-01-02 15:31:28',	'0000-00-00',	'2020-01-02 15:31:28',	101,	NULL,	NULL,	1,	0,	'Test recommedation',	NULL,	NULL),
(24,	3,	6,	2,	1,	1,	1,	NULL,	1,	101,	NULL,	6,	'finding all department',	'<p>test description<br/></p>',	'Test evidence',	'aaaSample4 (2) (2) (1) (6) (1) (3) (1) (1).PDF',	'sH39xyqY9zHshvFbFhBP6voNdoT1MYoLD0Xmka8o.pdf',	NULL,	NULL,	2,	'2020-01-02 15:39:07',	'2020-01-04 14:27:49',	'0000-00-00',	NULL,	101,	NULL,	NULL,	1,	0,	'test recommedation',	NULL,	'2020-01-04'),
(25,	4,	6,	3,	1,	1,	1,	NULL,	1,	1,	NULL,	2,	'Fiding by all -dept by super admin',	NULL,	NULL,	'',	'',	NULL,	NULL,	2,	'2020-01-02 15:57:15',	'1970-01-01 04:00:01',	'0000-00-00',	NULL,	8,	NULL,	NULL,	1,	0,	NULL,	NULL,	NULL),
(26,	5,	9,	2,	25,	1,	1,	NULL,	NULL,	1,	NULL,	2,	'jkjhk',	NULL,	NULL,	'',	'',	NULL,	NULL,	2,	'2020-01-04 09:55:16',	'2020-01-04 12:01:44',	'0000-00-00',	NULL,	1,	NULL,	NULL,	1,	0,	NULL,	NULL,	NULL),
(27,	14,	52,	2,	NULL,	1,	1,	56,	1,	527,	NULL,	3,	'Internal audit status',	NULL,	NULL,	'',	'',	NULL,	NULL,	1,	'2020-01-04 10:49:40',	'2020-01-04 12:43:44',	'0000-00-00',	NULL,	527,	NULL,	NULL,	1,	25,	NULL,	NULL,	NULL),
(28,	15,	52,	10,	NULL,	1,	1,	56,	2,	527,	NULL,	3,	'internal audit',	NULL,	NULL,	'',	'',	NULL,	NULL,	1,	'2020-01-04 10:50:13',	'2020-01-04 11:29:46',	'0000-00-00',	NULL,	527,	NULL,	NULL,	1,	25,	NULL,	NULL,	NULL),
(29,	5,	11,	2,	10,	NULL,	NULL,	NULL,	1,	1,	NULL,	2,	'EA Audit finding',	NULL,	NULL,	'',	'',	NULL,	NULL,	2,	'2020-01-04 14:39:21',	'2020-01-04 14:39:21',	'0000-00-00',	NULL,	1,	NULL,	NULL,	1,	0,	NULL,	NULL,	NULL),
(30,	6,	11,	10,	4,	1,	1,	NULL,	NULL,	1,	NULL,	6,	'IA finding 2',	NULL,	NULL,	'',	'',	NULL,	NULL,	2,	'2020-01-04 14:40:56',	'2020-01-04 14:42:12',	'0000-00-00',	NULL,	1,	NULL,	NULL,	1,	0,	NULL,	NULL,	'2020-01-04'),
(31,	3,	12,	2,	10,	4,	8,	NULL,	1,	53,	NULL,	6,	'test',	NULL,	NULL,	'',	'',	NULL,	NULL,	2,	'2020-01-04 14:48:19',	'2020-01-04 14:51:07',	'0000-00-00',	NULL,	53,	NULL,	NULL,	1,	0,	NULL,	NULL,	'2020-01-04'),
(32,	1,	53,	2,	NULL,	4,	17,	57,	1,	383,	NULL,	2,	'checkin condition IA findinding',	NULL,	'Test',	'aaaSample4 (2) (2) (1) (6) (1) (3) (1) (1) (1) (1) (1).PDF',	'MNNAn1o7dBtLwwGAawy6mXkfwi0xiz6rQiJr8ArK.pdf',	NULL,	NULL,	1,	'2020-01-06 09:59:53',	'2020-01-06 16:31:55',	'0000-00-00',	NULL,	383,	NULL,	NULL,	1,	26,	'rcommedation',	NULL,	NULL),
(33,	2,	53,	4,	NULL,	2,	47,	57,	1,	383,	NULL,	2,	'checking 2',	NULL,	'test evidence',	'aaaSample4 (2) (2) (1) (6) (1) (3) (1) (1) (1) (1) (1).PDF',	'L1WpFImbHY6tJJt4t4gxXfmlguMDPIbTBJw80U8p.pdf',	NULL,	NULL,	1,	'2020-01-06 10:01:47',	'2020-01-06 16:23:52',	'0000-00-00',	NULL,	383,	NULL,	NULL,	1,	26,	'test recommedation',	NULL,	NULL),
(34,	3,	13,	4,	12,	NULL,	NULL,	NULL,	3,	70,	NULL,	2,	'salman issue',	NULL,	NULL,	'',	'',	NULL,	NULL,	2,	'2020-01-06 10:17:45',	'2020-01-06 10:17:45',	'0000-00-00',	NULL,	70,	NULL,	NULL,	1,	0,	NULL,	NULL,	NULL),
(35,	3,	54,	3,	NULL,	NULL,	NULL,	58,	1,	1,	NULL,	1,	'activity finding',	'<p>test description</p>',	'test evidence',	'aaaSample4 (2) (2) (1) (6) (1) (3) (1) (1) (1) (1) (1) (1).PDF',	'EKcN4zgDZIYxB1udBALGL1FcIzZFjNQh2ZbxF0cM.pdf',	NULL,	NULL,	1,	'2020-01-06 14:35:56',	'2020-01-06 14:35:56',	'0000-00-00',	NULL,	1,	NULL,	NULL,	1,	26,	'test recommedation',	NULL,	NULL),
(36,	3,	55,	3,	NULL,	NULL,	NULL,	60,	1,	101,	NULL,	2,	'test finding',	'<p>descriptionn</p>',	'test evidence',	'audit_report - 2020-01-06T113619.335.pdf',	'yXYSZQtPj284qypqkO83yxFxVlloGRxISeHMDan8.pdf',	NULL,	NULL,	1,	'2020-01-07 08:52:05',	'2020-01-07 08:52:05',	'0000-00-00',	NULL,	101,	NULL,	NULL,	1,	27,	'test recommedation',	NULL,	NULL),
(37,	4,	55,	2,	NULL,	NULL,	NULL,	60,	1,	101,	NULL,	2,	'checking task 15',	NULL,	NULL,	'',	'',	NULL,	NULL,	1,	'2020-01-07 08:52:35',	'2020-01-07 08:52:35',	'0000-00-00',	NULL,	101,	NULL,	NULL,	1,	27,	NULL,	NULL,	NULL),
(38,	5,	55,	10,	NULL,	16,	207,	60,	2,	101,	101,	6,	'checking representative',	NULL,	NULL,	'',	'',	NULL,	NULL,	1,	'2020-01-07 08:52:57',	'2020-01-07 09:04:12',	'2020-01-07',	NULL,	101,	NULL,	NULL,	1,	27,	NULL,	NULL,	NULL),
(39,	4,	14,	2,	16,	16,	437,	NULL,	1,	101,	NULL,	6,	'checking journey tab',	'<p>test description</p>',	'test evidence',	'aaaSample4 (2) (2) (1) (6) (1) (3) (1) (1) (1) (1) (1).PDF',	'fKqTiGQpRpkMmIzbUKe5W8ESmdpIxAQVfvJnxUXE.pdf',	NULL,	NULL,	2,	'2020-01-07 09:18:15',	'2020-01-07 09:41:55',	'0000-00-00',	NULL,	101,	NULL,	NULL,	1,	0,	'test recommedat8ion',	NULL,	'2020-01-07'),
(40,	5,	14,	10,	16,	16,	437,	NULL,	1,	101,	NULL,	6,	'recheck journey tab',	NULL,	NULL,	'',	'',	NULL,	NULL,	2,	'2020-01-07 09:46:38',	'2020-01-07 09:51:02',	'0000-00-00',	NULL,	101,	NULL,	NULL,	1,	0,	NULL,	NULL,	'2020-01-07'),
(41,	6,	14,	1,	16,	16,	437,	NULL,	1,	101,	437,	6,	'journeyyyy',	NULL,	NULL,	'',	'',	NULL,	NULL,	2,	'2020-01-07 10:02:42',	'2020-01-07 10:05:18',	'2020-01-07',	NULL,	101,	NULL,	NULL,	1,	0,	NULL,	NULL,	'2020-01-07'),
(42,	6,	57,	2,	NULL,	1,	243,	62,	2,	527,	NULL,	2,	'ffff',	NULL,	NULL,	'',	'',	NULL,	NULL,	1,	'2020-01-07 15:12:53',	'2020-01-08 10:57:40',	'0000-00-00',	NULL,	527,	NULL,	NULL,	1,	29,	NULL,	NULL,	NULL),
(43,	7,	57,	10,	NULL,	1,	243,	62,	2,	527,	527,	6,	'finding 2',	NULL,	NULL,	'',	'',	NULL,	NULL,	1,	'2020-01-07 15:13:16',	'2020-01-08 09:01:23',	'2020-01-07',	NULL,	527,	NULL,	NULL,	1,	29,	NULL,	NULL,	NULL),
(44,	7,	16,	2,	10,	NULL,	NULL,	NULL,	1,	467,	NULL,	2,	'020 exteral audit finding',	NULL,	NULL,	'',	'',	NULL,	NULL,	2,	'2020-01-08 08:51:05',	'2020-01-08 08:51:05',	'0000-00-00',	NULL,	467,	NULL,	NULL,	1,	0,	NULL,	NULL,	NULL),
(45,	8,	16,	3,	2,	NULL,	NULL,	NULL,	1,	467,	NULL,	2,	'2020finding 2',	NULL,	'evidenceeeeeee',	'aaaSample4 (2) (2) (1) (6) (1) (3) (1) (1) (1) (1).PDF',	'Q85sythFWDHN4HmvnpAzE8IqJfJf2LFkbEeVxSsb.pdf',	NULL,	NULL,	2,	'2020-01-08 08:52:14',	'2020-01-08 08:52:14',	'0000-00-00',	NULL,	467,	NULL,	NULL,	1,	0,	'recommedationb',	NULL,	NULL),
(46,	9,	16,	10,	5,	NULL,	NULL,	NULL,	2,	467,	NULL,	2,	'external audit finding 44',	'<p>test description</p>',	NULL,	'',	'',	NULL,	NULL,	2,	'2020-01-08 08:53:09',	'2020-01-08 08:53:09',	'0000-00-00',	NULL,	467,	NULL,	NULL,	1,	0,	NULL,	NULL,	NULL),
(47,	8,	58,	2,	NULL,	1,	1,	63,	1,	101,	NULL,	2,	'2020internal audit finding',	NULL,	NULL,	'',	'',	NULL,	NULL,	1,	'2020-01-08 10:30:41',	'2020-01-09 16:49:57',	'0000-00-00',	NULL,	101,	NULL,	NULL,	1,	30,	NULL,	NULL,	NULL),
(48,	9,	58,	10,	NULL,	1,	243,	63,	1,	101,	NULL,	5,	'2020 feb internal audit finding8/01/2020',	'<p>test description</p>',	NULL,	'',	'',	NULL,	NULL,	1,	'2020-01-08 10:34:01',	'2020-01-08 11:23:34',	'0000-00-00',	NULL,	101,	NULL,	NULL,	1,	30,	NULL,	NULL,	NULL),
(49,	1,	61,	3,	NULL,	NULL,	NULL,	66,	NULL,	527,	NULL,	1,	NULL,	NULL,	NULL,	'lorem-ipsum.pdf',	'FXpKG97kctGTv396oEmfEJY3x2Ws9DWWXQi9kR2H.pdf',	NULL,	NULL,	1,	'2020-01-09 10:14:45',	'1970-01-01 04:08:47',	'0000-00-00',	NULL,	527,	NULL,	NULL,	1,	33,	NULL,	NULL,	NULL),
(50,	1,	62,	2,	NULL,	NULL,	NULL,	67,	NULL,	535,	NULL,	1,	'Test 2020 finding',	'<p>Test description</p>',	'test vbidence',	'',	'',	NULL,	NULL,	1,	'2020-01-10 10:48:39',	'2020-01-10 10:48:39',	'0000-00-00',	NULL,	535,	NULL,	NULL,	1,	36,	'recommedation',	NULL,	NULL),
(51,	2,	62,	10,	NULL,	NULL,	NULL,	68,	NULL,	535,	NULL,	1,	NULL,	NULL,	NULL,	'',	'',	NULL,	NULL,	1,	'2020-01-10 10:50:58',	'2020-01-10 10:50:58',	'0000-00-00',	NULL,	535,	NULL,	NULL,	1,	36,	NULL,	NULL,	NULL),
(52,	1,	63,	3,	NULL,	NULL,	NULL,	69,	NULL,	527,	NULL,	1,	'16 jan',	NULL,	NULL,	'',	'',	NULL,	NULL,	1,	'2020-01-16 09:24:21',	'2020-01-16 09:24:21',	'0000-00-00',	NULL,	527,	NULL,	NULL,	1,	38,	NULL,	NULL,	NULL),
(53,	1,	64,	NULL,	NULL,	NULL,	NULL,	70,	NULL,	527,	NULL,	2,	'new audit finding by jeeva (sawad)',	NULL,	NULL,	'',	'',	NULL,	NULL,	1,	'2020-01-16 10:33:40',	'2020-01-16 10:33:40',	'0000-00-00',	NULL,	527,	NULL,	NULL,	1,	42,	NULL,	NULL,	NULL),
(54,	2,	64,	NULL,	NULL,	NULL,	NULL,	70,	NULL,	527,	NULL,	2,	'new audit fimnding 2 by jeeva (sawad)',	NULL,	NULL,	'',	'',	NULL,	NULL,	1,	'2020-01-16 10:34:05',	'2020-01-16 10:34:05',	'0000-00-00',	NULL,	527,	NULL,	NULL,	1,	42,	NULL,	NULL,	NULL),
(55,	10,	65,	3,	NULL,	NULL,	NULL,	71,	1,	527,	NULL,	2,	'qeafgtsrd,yfhg',	'<p>wrqehwretryjh</p>',	'egnhmy',	'',	'',	NULL,	NULL,	1,	'2020-01-17 09:27:39',	'2020-01-17 09:27:39',	'0000-00-00',	NULL,	527,	NULL,	NULL,	1,	43,	'srthtj',	NULL,	NULL),
(56,	11,	65,	2,	NULL,	1,	1,	71,	1,	527,	NULL,	2,	'`2',	'<p>et3yweh</p>',	'atrhwrth',	'',	'',	NULL,	NULL,	1,	'2020-01-17 09:29:01',	'2020-01-17 10:15:36',	'0000-00-00',	NULL,	527,	NULL,	NULL,	1,	43,	'srthsrtj',	NULL,	NULL),
(57,	12,	65,	2,	NULL,	1,	1,	71,	1,	1,	1,	6,	'13wy',	'<p>etyer</p>',	'yaetyaer',	'',	'',	NULL,	NULL,	1,	'2020-01-17 09:30:13',	'2020-01-17 10:14:57',	'2020-01-17',	NULL,	527,	NULL,	NULL,	1,	43,	'taeryesra',	NULL,	NULL),
(58,	10,	17,	3,	1,	1,	1,	NULL,	1,	1,	NULL,	2,	'sawad',	'<p>g4tgtg</p>',	'3gt',	'',	'',	NULL,	NULL,	2,	'2020-01-17 10:21:06',	'1970-01-01 04:00:01',	'0000-00-00',	NULL,	1,	NULL,	NULL,	1,	0,	'ergttj il',	NULL,	NULL),
(59,	11,	17,	2,	6,	1,	1,	NULL,	NULL,	1,	NULL,	2,	'tec',	NULL,	NULL,	'',	'',	NULL,	NULL,	2,	'2020-01-17 12:11:00',	'2020-01-17 15:57:15',	'0000-00-00',	NULL,	1,	NULL,	NULL,	1,	0,	NULL,	NULL,	NULL),
(60,	12,	21,	2,	13,	1,	1,	NULL,	1,	1,	NULL,	2,	'sawad',	'<p>wagetj</p>',	'dager',	'',	'',	NULL,	NULL,	2,	'2020-01-17 15:49:29',	'2020-01-17 15:54:55',	'0000-00-00',	NULL,	1,	NULL,	NULL,	1,	0,	'afewrget',	NULL,	NULL),
(61,	13,	20,	10,	1,	1,	1,	NULL,	1,	1,	NULL,	2,	'sdfseffffffffffff',	'<p>qwdw</p>',	'edfqw',	'',	'',	NULL,	NULL,	2,	'2020-01-17 16:08:20',	'2020-01-17 16:08:52',	'0000-00-00',	NULL,	1,	NULL,	NULL,	1,	0,	'qwdqw',	NULL,	NULL),
(62,	13,	67,	4,	NULL,	NULL,	NULL,	73,	1,	527,	NULL,	2,	'Finding 18-01-2020',	'<p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur<br/></p>',	'Evidence',	'aaaSample4 (2) (2) (1) (6) (1) (3) (1) (1) (1) (2).PDF',	'yT53aWayrPXKCFEct75ESwaCp3fXlDoCwZbhWdXq.pdf',	NULL,	NULL,	1,	'2020-01-18 14:31:28',	'2020-01-18 14:31:28',	'0000-00-00',	NULL,	527,	NULL,	NULL,	1,	54,	'Recommedation',	NULL,	NULL),
(63,	14,	67,	1,	NULL,	1,	1,	74,	4,	527,	527,	6,	'finding 222222------18/01/2020',	NULL,	NULL,	'',	'',	NULL,	NULL,	1,	'2020-01-18 14:37:55',	'2020-01-18 15:06:51',	'2020-01-18',	NULL,	527,	NULL,	NULL,	1,	54,	NULL,	NULL,	NULL),
(64,	14,	24,	4,	2,	1,	1,	NULL,	2,	81,	1,	6,	'Exteranl audit finding',	NULL,	'evidence',	'aaaSample4 (2) (2) (1) (6) (1) (3) (1) (1) (1) (1) (1).PDF',	'u5QnNmHpCZAyElNT36bwW3pbxhSYR8sVhNQM9x9Z.pdf',	NULL,	NULL,	2,	'2020-01-18 15:17:10',	'2020-01-18 15:19:37',	'2020-01-18',	NULL,	81,	NULL,	NULL,	1,	0,	'recommedation',	NULL,	'2020-01-18'),
(65,	15,	24,	1,	2,	NULL,	NULL,	NULL,	NULL,	81,	NULL,	2,	'ertet',	NULL,	NULL,	'',	'',	NULL,	NULL,	2,	'2020-01-18 15:21:32',	'2020-01-18 15:21:32',	'0000-00-00',	NULL,	81,	NULL,	NULL,	1,	0,	NULL,	NULL,	NULL),
(66,	15,	68,	2,	NULL,	NULL,	NULL,	75,	1,	539,	NULL,	2,	'finding 1',	'<p>test description</p>',	'evidence',	'aaaSample4 (2) (2) (1) (6) (1) (3) (1) (1) (1) (1) (1) (2).PDF',	'L1PHJbXOC7VVsUKddpFAcoetQkULkzpuhnWnG5JX.pdf',	NULL,	NULL,	1,	'2020-01-20 14:52:29',	'2020-01-20 14:52:29',	'0000-00-00',	NULL,	539,	NULL,	NULL,	1,	56,	'recommedation',	NULL,	NULL),
(67,	16,	68,	3,	NULL,	27,	539,	75,	1,	539,	NULL,	2,	'tra special dept .finding',	'<p>test description</p>',	NULL,	'',	'',	NULL,	NULL,	1,	'2020-01-20 15:03:33',	'2020-01-20 15:19:14',	'0000-00-00',	NULL,	539,	NULL,	NULL,	1,	56,	NULL,	NULL,	NULL),
(68,	16,	28,	4,	27,	27,	539,	NULL,	1,	1,	539,	6,	'Finding by year',	'<p>test decription</p>',	NULL,	'',	'',	NULL,	NULL,	2,	'2020-01-21 09:13:17',	'2020-01-21 09:16:29',	'2020-01-21',	NULL,	1,	NULL,	NULL,	1,	0,	NULL,	NULL,	'2020-01-21'),
(69,	17,	28,	3,	1,	NULL,	NULL,	NULL,	NULL,	1,	NULL,	2,	'hghgh',	NULL,	NULL,	'audit-calendar-pdf (11).pdf',	'fm7kSlZ4r2jOuDACCXtMM5Nzvyo1WPO6K5gRfaQy.pdf',	NULL,	NULL,	2,	'2020-01-21 15:22:57',	'2020-01-21 15:22:57',	'0000-00-00',	NULL,	1,	NULL,	NULL,	1,	0,	NULL,	NULL,	NULL),
(70,	17,	69,	4,	NULL,	NULL,	NULL,	76,	1,	539,	NULL,	2,	'finding filter',	NULL,	NULL,	'',	'',	NULL,	NULL,	1,	'2020-01-23 13:29:09',	'2020-01-23 13:29:09',	'0000-00-00',	NULL,	539,	NULL,	NULL,	1,	57,	NULL,	NULL,	NULL),
(71,	18,	69,	1,	NULL,	NULL,	NULL,	76,	2,	539,	NULL,	2,	'finding filter 2',	NULL,	NULL,	'',	'',	NULL,	NULL,	1,	'2020-01-23 13:29:24',	'2020-01-23 13:29:24',	'0000-00-00',	NULL,	539,	NULL,	NULL,	1,	57,	NULL,	NULL,	NULL),
(72,	19,	69,	4,	NULL,	NULL,	NULL,	76,	3,	539,	NULL,	2,	'finding filter3',	NULL,	NULL,	'',	'',	NULL,	NULL,	1,	'2020-01-23 13:29:45',	'2020-01-23 13:29:45',	'0000-00-00',	NULL,	539,	NULL,	NULL,	1,	57,	NULL,	NULL,	NULL),
(73,	20,	69,	4,	NULL,	27,	538,	76,	3,	539,	NULL,	5,	'finding filter3',	NULL,	NULL,	'',	'',	NULL,	NULL,	1,	'2020-01-23 13:29:45',	'2020-02-10 17:18:57',	'0000-00-00',	NULL,	539,	NULL,	NULL,	1,	57,	NULL,	NULL,	NULL),
(74,	21,	69,	4,	NULL,	27,	62,	76,	2,	539,	NULL,	2,	'finding filter 4',	NULL,	NULL,	'',	'',	NULL,	NULL,	1,	'2020-01-23 13:32:37',	'2020-01-23 13:57:49',	'0000-00-00',	NULL,	539,	NULL,	NULL,	1,	57,	NULL,	NULL,	NULL),
(75,	18,	29,	2,	27,	NULL,	NULL,	NULL,	1,	539,	NULL,	2,	'EXTERNAL AUDIT FINDING',	NULL,	NULL,	'',	'',	NULL,	NULL,	2,	'2020-01-23 16:01:20',	'2020-01-23 16:01:20',	'0000-00-00',	NULL,	539,	NULL,	NULL,	1,	0,	NULL,	NULL,	NULL),
(76,	19,	29,	3,	27,	NULL,	NULL,	NULL,	4,	539,	NULL,	2,	'EX FINDING SPECIAL',	NULL,	NULL,	'',	'',	NULL,	NULL,	2,	'2020-01-23 16:01:53',	'2020-01-23 16:01:53',	'0000-00-00',	NULL,	539,	NULL,	NULL,	1,	0,	NULL,	NULL,	NULL),
(77,	1,	30,	3,	27,	NULL,	NULL,	NULL,	NULL,	101,	NULL,	2,	'ex',	NULL,	NULL,	'',	'',	NULL,	NULL,	2,	'2020-01-24 10:38:08',	'2020-01-24 10:38:08',	'0000-00-00',	NULL,	101,	NULL,	NULL,	1,	0,	NULL,	NULL,	NULL),
(78,	2,	30,	3,	27,	NULL,	NULL,	NULL,	NULL,	101,	NULL,	2,	'hgfhfgcg',	NULL,	NULL,	'',	'',	NULL,	NULL,	2,	'2020-01-24 10:38:39',	'2020-01-24 10:38:39',	'0000-00-00',	NULL,	101,	NULL,	NULL,	1,	0,	NULL,	NULL,	NULL),
(79,	20,	31,	4,	27,	NULL,	NULL,	NULL,	1,	538,	NULL,	2,	'external audit filter finding 1',	NULL,	NULL,	'',	'',	NULL,	NULL,	2,	'2020-01-24 10:54:49',	'2020-01-24 10:54:49',	'0000-00-00',	NULL,	538,	NULL,	NULL,	1,	0,	NULL,	NULL,	NULL),
(80,	21,	31,	1,	27,	NULL,	NULL,	NULL,	1,	538,	NULL,	2,	'external audit filter finding 2',	NULL,	NULL,	'',	'',	NULL,	NULL,	2,	'2020-01-24 10:55:14',	'2020-01-24 10:55:14',	'0000-00-00',	NULL,	538,	NULL,	NULL,	1,	0,	NULL,	NULL,	NULL),
(81,	22,	31,	10,	27,	NULL,	NULL,	NULL,	NULL,	538,	NULL,	2,	'external audit filter finding 3',	NULL,	NULL,	'',	'',	NULL,	NULL,	2,	'2020-01-24 10:55:38',	'2020-01-24 10:55:38',	'0000-00-00',	NULL,	538,	NULL,	NULL,	1,	0,	NULL,	NULL,	NULL),
(82,	20,	32,	2,	10,	NULL,	NULL,	NULL,	1,	539,	NULL,	2,	'external indin by jn 2020',	NULL,	NULL,	'',	'',	NULL,	NULL,	2,	'2020-01-25 12:41:47',	'1970-01-01 04:08:59',	'0000-00-00',	NULL,	539,	NULL,	NULL,	1,	0,	NULL,	NULL,	NULL),
(83,	21,	32,	4,	2,	4,	8,	NULL,	1,	539,	8,	6,	'findin g addded on jan 25',	NULL,	NULL,	'',	'',	NULL,	NULL,	2,	'2020-01-25 12:44:11',	'2020-02-10 10:41:24',	'2020-02-10',	NULL,	539,	NULL,	NULL,	1,	0,	NULL,	NULL,	'2020-02-10'),
(84,	22,	32,	1,	15,	27,	539,	NULL,	NULL,	539,	539,	6,	'external audit jan 25 th',	NULL,	NULL,	'',	'',	NULL,	NULL,	2,	'2020-01-25 12:47:40',	'2020-01-25 13:27:08',	'2020-01-25',	NULL,	539,	NULL,	NULL,	1,	0,	NULL,	NULL,	'2020-01-25'),
(85,	22,	70,	2,	NULL,	NULL,	NULL,	77,	1,	527,	NULL,	2,	'interna indin jan 25',	'<p>interna indin jan 25 desrition</p><p><br/></p>',	NULL,	'',	'',	NULL,	NULL,	1,	'2020-01-25 15:55:31',	'2020-01-25 15:55:31',	'0000-00-00',	NULL,	527,	NULL,	NULL,	1,	58,	NULL,	NULL,	NULL),
(86,	23,	70,	3,	NULL,	4,	8,	77,	3,	527,	NULL,	2,	'interna indin jan 25-second',	NULL,	NULL,	'',	'',	NULL,	NULL,	1,	'2020-01-25 15:56:14',	'2020-02-10 10:56:17',	'0000-00-00',	NULL,	527,	NULL,	NULL,	1,	58,	NULL,	NULL,	NULL),
(87,	24,	70,	10,	NULL,	27,	538,	77,	2,	527,	NULL,	2,	'interndda indin jan 25-thirdd',	NULL,	NULL,	'',	'',	NULL,	NULL,	1,	'2020-01-25 15:59:47',	'2020-02-10 17:20:45',	'0000-00-00',	NULL,	527,	NULL,	NULL,	1,	58,	NULL,	NULL,	NULL),
(88,	25,	70,	1,	NULL,	4,	8,	77,	3,	527,	NULL,	5,	'interna indin jan 25-fourth',	NULL,	NULL,	'',	'',	NULL,	NULL,	1,	'2020-01-25 16:00:47',	'2020-02-10 11:07:39',	'0000-00-00',	NULL,	527,	NULL,	NULL,	1,	58,	NULL,	NULL,	NULL),
(89,	26,	70,	4,	NULL,	27,	538,	77,	4,	527,	8,	6,	'interna indin jan 25-ofi',	NULL,	NULL,	'',	'',	NULL,	NULL,	1,	'2020-01-25 16:01:33',	'2020-02-10 10:38:49',	'2020-02-10',	NULL,	527,	NULL,	NULL,	1,	58,	NULL,	NULL,	NULL),
(90,	27,	70,	1,	NULL,	NULL,	NULL,	77,	3,	527,	NULL,	7,	'interna indin jan 25-discrded',	NULL,	NULL,	'',	'',	NULL,	NULL,	1,	'2020-01-25 16:03:00',	'2020-01-25 16:09:24',	'0000-00-00',	NULL,	527,	NULL,	NULL,	1,	58,	NULL,	NULL,	NULL),
(91,	28,	71,	2,	NULL,	4,	8,	78,	1,	527,	8,	6,	'Finding 1',	NULL,	'Test evidence',	'',	'',	NULL,	NULL,	1,	'2020-01-31 09:20:48',	'2020-01-31 10:37:54',	'2020-01-31',	NULL,	527,	NULL,	NULL,	1,	61,	'Test recommedation',	NULL,	NULL),
(92,	23,	33,	2,	10,	4,	8,	NULL,	1,	8,	8,	6,	'Finding 2',	'<p>test descriptions</p>',	'evidence',	'aaaSample4 (2) (2) (1) (6) (1) (3) (1) (1) (1) (2) (1) (2).PDF',	'WNnwHc7uE9O2GWOHRepX1oiVEDVRDfH9Bzv4IH2l.pdf',	NULL,	NULL,	2,	'2020-01-31 12:16:41',	'2020-01-31 12:21:49',	'2020-01-31',	NULL,	8,	NULL,	NULL,	1,	0,	'recommedation',	NULL,	'2020-01-31'),
(93,	24,	34,	2,	14,	1,	541,	NULL,	2,	541,	541,	6,	'finding 24-2-2020',	NULL,	'test evidence',	'lorem word (2) (1) (2) (2) (4) (1).pdf',	'rKVsIg2c7Ffl7BuX46hU79q2TwdTLbN6hsXTxFKA.pdf',	NULL,	NULL,	2,	'2020-02-24 12:27:09',	'2020-02-24 12:38:09',	'2020-02-24',	NULL,	541,	NULL,	NULL,	1,	0,	'Test recommedation',	NULL,	'2020-02-24');

DROP TABLE IF EXISTS `audit_finding_categories`;
CREATE TABLE `audit_finding_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_observation` int(11) NOT NULL DEFAULT '0',
  `is_major_nc` int(11) NOT NULL DEFAULT '0',
  `is_minor_nc` int(11) NOT NULL DEFAULT '0',
  `is_ofi` int(11) NOT NULL DEFAULT '0',
  `is_nc` int(11) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `updated_by` int(10) unsigned DEFAULT NULL,
  `deleted_by` int(10) unsigned DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_finding_categories` (`id`, `title`, `label`, `is_observation`, `is_major_nc`, `is_minor_nc`, `is_ofi`, `is_nc`, `created_at`, `updated_at`, `deleted_at`, `created_by`, `updated_by`, `deleted_by`, `status`) VALUES
(1,	'Observations',	'warning',	1,	0,	0,	0,	0,	'2018-10-03 14:29:19',	'2019-09-29 21:20:28',	NULL,	1,	NULL,	NULL,	1),
(2,	'Major NC',	'danger',	0,	1,	0,	0,	0,	'2018-10-03 14:29:19',	'2019-09-29 21:20:28',	NULL,	1,	NULL,	NULL,	1),
(3,	'Minor NC',	'danger',	0,	0,	1,	0,	0,	'2018-10-03 14:29:19',	'2019-09-29 21:20:28',	NULL,	1,	NULL,	NULL,	1),
(4,	'oppurtunity for improvement(OFI)',	'primary',	0,	0,	0,	1,	0,	'2018-10-03 14:29:19',	'2019-09-29 21:20:28',	NULL,	1,	NULL,	NULL,	1),
(10,	'Non Conformity',	'',	0,	0,	0,	0,	0,	'2019-09-23 16:24:47',	'2019-09-23 16:24:47',	NULL,	0,	NULL,	NULL,	1);

DROP TABLE IF EXISTS `audit_finding_clauses`;
CREATE TABLE `audit_finding_clauses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `audit_finding_mstype_id` int(10) unsigned DEFAULT NULL,
  `audit_finding_id` int(10) unsigned DEFAULT NULL,
  `clause_id` int(10) unsigned DEFAULT NULL,
  `parent_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_finding_clauses` (`id`, `audit_finding_mstype_id`, `audit_finding_id`, `clause_id`, `parent_id`) VALUES
(1,	1,	1,	381,	0),
(2,	1,	1,	403,	381),
(3,	1,	1,	404,	403),
(4,	1,	1,	405,	403),
(5,	1,	1,	406,	381),
(6,	2,	3,	592,	0),
(7,	2,	3,	646,	592),
(8,	2,	3,	648,	646),
(9,	2,	3,	649,	646),
(10,	2,	3,	650,	646),
(11,	2,	3,	1234,	646),
(12,	2,	3,	651,	592),
(13,	2,	3,	653,	651),
(14,	2,	3,	1235,	651),
(15,	3,	5,	591,	0),
(16,	3,	5,	1232,	591),
(17,	3,	5,	1233,	591),
(18,	3,	5,	645,	591),
(19,	4,	7,	591,	0),
(20,	4,	7,	1232,	591),
(21,	4,	7,	1233,	591),
(22,	4,	7,	645,	591),
(23,	5,	8,	383,	0),
(24,	5,	8,	1723,	383),
(25,	6,	10,	381,	0),
(26,	6,	10,	403,	381),
(27,	6,	10,	404,	403),
(28,	6,	10,	405,	403),
(29,	6,	10,	406,	381),
(30,	7,	11,	381,	0),
(31,	7,	11,	403,	381),
(32,	7,	11,	404,	403),
(33,	7,	11,	405,	403),
(34,	7,	11,	406,	381),
(35,	8,	15,	381,	0),
(36,	8,	15,	403,	381),
(37,	8,	15,	404,	403),
(38,	8,	15,	405,	403),
(39,	8,	15,	406,	381),
(40,	9,	15,	381,	0),
(41,	9,	15,	403,	381),
(42,	9,	15,	404,	403),
(43,	9,	15,	405,	403),
(44,	9,	15,	406,	381),
(45,	10,	15,	381,	0),
(46,	10,	15,	403,	381),
(47,	10,	15,	404,	403),
(48,	10,	15,	405,	403),
(49,	10,	15,	406,	381),
(50,	10,	15,	381,	0),
(51,	10,	15,	403,	381),
(52,	10,	15,	404,	403),
(53,	10,	15,	405,	403),
(54,	10,	15,	406,	381),
(55,	11,	15,	381,	0),
(56,	11,	15,	403,	381),
(57,	11,	15,	404,	403),
(58,	11,	15,	405,	403),
(59,	11,	15,	406,	381),
(60,	11,	15,	381,	0),
(61,	11,	15,	403,	381),
(62,	11,	15,	404,	403),
(63,	11,	15,	405,	403),
(64,	11,	15,	406,	381),
(65,	11,	15,	381,	0),
(66,	11,	15,	403,	381),
(67,	11,	15,	404,	403),
(68,	11,	15,	405,	403),
(69,	11,	15,	406,	381),
(70,	11,	15,	381,	0),
(71,	11,	15,	403,	381),
(72,	11,	15,	404,	403),
(73,	11,	15,	405,	403),
(74,	11,	15,	406,	381),
(75,	12,	16,	591,	0),
(76,	12,	16,	1232,	591),
(77,	12,	16,	1233,	591),
(78,	12,	16,	645,	591),
(79,	13,	17,	382,	0),
(84,	15,	18,	591,	0),
(85,	15,	18,	1232,	591),
(86,	15,	18,	1233,	591),
(87,	15,	18,	645,	591),
(88,	16,	19,	591,	0),
(89,	16,	19,	1232,	591),
(90,	16,	19,	1233,	591),
(91,	16,	19,	645,	591),
(92,	17,	20,	382,	0),
(93,	17,	20,	383,	0),
(94,	17,	20,	1723,	383),
(95,	18,	21,	381,	0),
(96,	18,	21,	403,	381),
(97,	18,	21,	404,	403),
(98,	18,	21,	405,	403),
(99,	18,	21,	406,	381),
(100,	19,	22,	381,	0),
(101,	19,	22,	403,	381),
(102,	19,	22,	404,	403),
(103,	19,	22,	405,	403),
(104,	19,	22,	406,	381),
(107,	21,	23,	404,	403),
(108,	21,	23,	405,	403),
(109,	22,	24,	382,	0),
(110,	22,	24,	383,	0),
(111,	22,	24,	1723,	383),
(112,	23,	27,	381,	0),
(113,	23,	27,	403,	381),
(114,	23,	27,	404,	403),
(115,	23,	27,	405,	403),
(116,	23,	27,	406,	381),
(117,	24,	28,	591,	0),
(118,	24,	28,	1232,	591),
(119,	24,	28,	1233,	591),
(120,	24,	28,	645,	591),
(121,	25,	29,	381,	0),
(122,	25,	29,	403,	381),
(123,	25,	29,	404,	403),
(124,	25,	29,	405,	403),
(125,	25,	29,	406,	381),
(126,	26,	30,	381,	0),
(127,	26,	30,	403,	381),
(128,	26,	30,	404,	403),
(129,	26,	30,	405,	403),
(130,	26,	30,	406,	381),
(131,	27,	32,	1169,	0),
(132,	27,	32,	1293,	1169),
(133,	27,	32,	1171,	1169),
(134,	27,	32,	1172,	1169),
(135,	27,	32,	1173,	1169),
(136,	27,	32,	1174,	1169),
(137,	27,	32,	1175,	1169),
(138,	27,	32,	1176,	1169),
(139,	27,	32,	1177,	1169),
(140,	27,	32,	1178,	1169),
(141,	28,	33,	1179,	0),
(142,	28,	33,	1294,	1179),
(143,	28,	33,	1182,	1179),
(144,	29,	34,	1179,	0),
(145,	29,	34,	1294,	1179),
(146,	29,	34,	1182,	1179),
(147,	30,	35,	1169,	0),
(148,	30,	35,	1293,	1169),
(149,	30,	35,	1171,	1169),
(150,	30,	35,	1172,	1169),
(151,	30,	35,	1173,	1169),
(152,	30,	35,	1174,	1169),
(153,	30,	35,	1175,	1169),
(154,	30,	35,	1176,	1169),
(155,	30,	35,	1177,	1169),
(156,	30,	35,	1178,	1169),
(157,	31,	36,	591,	0),
(158,	31,	36,	1232,	591),
(159,	31,	36,	1233,	591),
(160,	31,	36,	645,	591),
(161,	32,	37,	646,	592),
(162,	32,	37,	648,	646),
(163,	32,	37,	649,	646),
(164,	32,	37,	650,	646),
(165,	32,	37,	1234,	646),
(166,	33,	39,	646,	592),
(167,	33,	39,	648,	646),
(168,	33,	39,	649,	646),
(169,	33,	39,	650,	646),
(170,	33,	39,	1234,	646),
(171,	34,	40,	591,	0),
(172,	34,	40,	1232,	591),
(173,	34,	40,	1233,	591),
(174,	34,	40,	645,	591),
(175,	35,	41,	646,	592),
(176,	35,	41,	648,	646),
(177,	35,	41,	649,	646),
(178,	35,	41,	650,	646),
(179,	35,	41,	1234,	646),
(180,	36,	43,	1179,	0),
(181,	36,	43,	1294,	1179),
(182,	36,	43,	1182,	1179),
(183,	37,	44,	1179,	0),
(184,	37,	44,	1294,	1179),
(185,	37,	44,	1182,	1179),
(186,	38,	44,	545,	0),
(187,	38,	44,	1212,	545),
(188,	38,	44,	547,	545),
(189,	38,	44,	1213,	547),
(190,	38,	44,	1214,	547),
(191,	38,	44,	1215,	547),
(192,	39,	45,	545,	0),
(193,	39,	45,	1212,	545),
(194,	39,	45,	547,	545),
(195,	39,	45,	1213,	547),
(196,	39,	45,	1214,	547),
(197,	39,	45,	1215,	547),
(198,	40,	46,	545,	0),
(199,	40,	46,	1212,	545),
(200,	40,	46,	547,	545),
(201,	40,	46,	1213,	547),
(202,	40,	46,	1214,	547),
(203,	40,	46,	1215,	547),
(204,	41,	47,	384,	0),
(205,	41,	47,	441,	384),
(206,	41,	47,	1746,	441),
(207,	41,	47,	1747,	1746),
(208,	41,	47,	449,	384),
(209,	41,	47,	450,	449),
(210,	41,	47,	456,	384),
(211,	41,	47,	457,	456),
(212,	41,	47,	458,	456),
(213,	41,	47,	459,	456),
(214,	41,	47,	460,	384),
(215,	41,	47,	461,	460),
(216,	41,	47,	462,	460),
(217,	41,	47,	463,	460),
(218,	41,	47,	465,	460),
(219,	41,	47,	466,	460),
(220,	41,	47,	467,	384),
(221,	41,	47,	468,	384),
(222,	41,	47,	469,	468),
(223,	41,	47,	470,	468),
(224,	42,	48,	449,	384),
(225,	42,	48,	450,	449),
(226,	43,	50,	834,	827),
(227,	43,	50,	835,	834),
(228,	43,	50,	836,	834),
(229,	43,	50,	837,	834),
(230,	43,	50,	838,	834),
(231,	43,	50,	840,	834),
(232,	43,	50,	841,	834),
(233,	44,	8,	383,	0),
(234,	44,	8,	1723,	383),
(235,	45,	55,	487,	385),
(236,	45,	55,	490,	487),
(237,	45,	55,	494,	487),
(238,	45,	55,	495,	487),
(239,	46,	56,	381,	0),
(240,	46,	56,	403,	381),
(241,	46,	56,	404,	403),
(242,	46,	56,	405,	403),
(243,	46,	56,	406,	381),
(244,	47,	57,	441,	384),
(245,	47,	57,	1746,	441),
(246,	47,	57,	1747,	1746),
(247,	48,	57,	441,	384),
(248,	48,	57,	1746,	441),
(249,	48,	57,	1747,	1746),
(260,	51,	58,	381,	0),
(261,	51,	58,	403,	381),
(262,	51,	58,	404,	403),
(263,	51,	58,	405,	403),
(264,	51,	58,	406,	381),
(269,	53,	60,	591,	0),
(270,	53,	60,	1232,	591),
(271,	53,	60,	1233,	591),
(272,	53,	60,	645,	591),
(273,	54,	61,	592,	0),
(274,	54,	61,	646,	592),
(275,	54,	61,	648,	646),
(276,	54,	61,	649,	646),
(277,	54,	61,	650,	646),
(278,	54,	61,	1234,	646),
(279,	54,	61,	651,	592),
(280,	54,	61,	653,	651),
(281,	54,	61,	1235,	651),
(282,	55,	62,	906,	0),
(283,	55,	62,	1262,	906),
(284,	55,	62,	920,	906),
(285,	56,	63,	1773,	0),
(286,	56,	63,	1771,	0),
(287,	57,	64,	752,	0),
(288,	57,	64,	764,	752),
(289,	57,	64,	765,	752),
(290,	57,	64,	766,	752),
(291,	58,	66,	384,	0),
(292,	58,	66,	441,	384),
(293,	58,	66,	1746,	441),
(294,	58,	66,	1747,	1746),
(295,	58,	66,	449,	384),
(296,	58,	66,	450,	449),
(297,	58,	66,	456,	384),
(298,	58,	66,	457,	456),
(299,	58,	66,	458,	456),
(300,	58,	66,	459,	456),
(301,	58,	66,	460,	384),
(302,	58,	66,	461,	460),
(303,	58,	66,	462,	460),
(304,	58,	66,	463,	460),
(305,	58,	66,	465,	460),
(306,	58,	66,	466,	460),
(307,	58,	66,	467,	384),
(308,	58,	66,	468,	384),
(309,	58,	66,	469,	468),
(310,	58,	66,	470,	468),
(311,	59,	67,	382,	0),
(312,	60,	68,	1479,	1472),
(313,	60,	68,	1480,	1479),
(314,	60,	68,	1481,	1479),
(315,	60,	68,	1482,	1479),
(316,	61,	70,	1479,	1472),
(317,	61,	70,	1480,	1479),
(318,	61,	70,	1481,	1479),
(319,	61,	70,	1482,	1479),
(320,	62,	72,	1486,	1472),
(321,	62,	72,	1487,	1486),
(322,	62,	72,	1488,	1486),
(323,	62,	72,	1489,	1486),
(324,	62,	72,	1490,	1486),
(325,	62,	72,	1491,	1490),
(326,	62,	72,	1492,	1490),
(327,	62,	72,	1493,	1490),
(328,	62,	72,	1494,	1486),
(329,	62,	72,	1495,	1494),
(330,	62,	72,	1496,	1494),
(331,	63,	73,	1486,	1472),
(332,	63,	73,	1487,	1486),
(333,	63,	73,	1488,	1486),
(334,	63,	73,	1489,	1486),
(335,	63,	73,	1490,	1486),
(336,	63,	73,	1491,	1490),
(337,	63,	73,	1492,	1490),
(338,	63,	73,	1493,	1490),
(339,	63,	73,	1494,	1486),
(340,	63,	73,	1495,	1494),
(341,	63,	73,	1496,	1494),
(342,	64,	75,	1761,	0),
(343,	65,	76,	1761,	0),
(344,	65,	76,	1763,	0),
(345,	65,	76,	1765,	0),
(346,	66,	79,	1763,	0),
(347,	66,	79,	1765,	0),
(348,	67,	80,	1771,	0),
(349,	67,	80,	1773,	0),
(350,	68,	81,	1781,	0),
(351,	68,	81,	1779,	0),
(352,	69,	86,	1374,	1372),
(353,	69,	86,	1376,	1374),
(354,	69,	86,	1377,	1374),
(355,	69,	86,	1378,	1374),
(356,	69,	86,	1379,	1374),
(357,	69,	86,	1380,	1374),
(358,	69,	86,	1381,	1374),
(359,	69,	86,	1382,	1374),
(360,	69,	86,	1383,	1374),
(361,	69,	86,	1393,	1374),
(362,	70,	87,	1380,	1374),
(363,	71,	88,	1399,	1398),
(364,	71,	88,	1401,	1399),
(365,	71,	88,	1403,	1399),
(366,	71,	88,	1404,	1399),
(367,	71,	88,	1405,	1399),
(368,	71,	88,	1406,	1399),
(369,	71,	88,	1407,	1399),
(370,	71,	88,	1408,	1399),
(371,	71,	88,	1409,	1399),
(372,	71,	88,	1410,	1399),
(373,	71,	88,	1411,	1410),
(374,	71,	88,	1412,	1410),
(375,	71,	88,	1413,	1410),
(376,	71,	88,	1414,	1410),
(377,	72,	90,	1370,	1367),
(378,	73,	91,	1351,	1333),
(379,	73,	91,	1352,	1333),
(380,	74,	92,	987,	957),
(381,	74,	92,	970,	957),
(399,	77,	93,	380,	0),
(400,	77,	93,	1705,	380),
(401,	77,	93,	1706,	380),
(402,	77,	93,	1707,	380),
(403,	77,	93,	1708,	380),
(404,	77,	93,	1709,	1708),
(405,	77,	93,	1710,	1708),
(406,	77,	93,	381,	0),
(407,	77,	93,	403,	381),
(408,	77,	93,	404,	403),
(409,	77,	93,	405,	403),
(410,	77,	93,	406,	381),
(411,	77,	93,	1712,	381),
(412,	77,	93,	1715,	1712),
(413,	77,	93,	1713,	1712),
(414,	78,	93,	1769,	0),
(415,	78,	93,	1771,	0);

DROP TABLE IF EXISTS `audit_finding_comments`;
CREATE TABLE `audit_finding_comments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `audit_finding_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `file_name` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_size` int(11) DEFAULT NULL,
  `file_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_finding_comments` (`id`, `audit_finding_id`, `user_id`, `description`, `file_name`, `file_size`, `file_url`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1,	46,	467,	'added,please check @ Salman.ict fund dept',	'aaaSample4 (2) (2) (1) (6) (1) (3) (1) (1) (1) (1) (1) (1).PDF',	75981,	'KG3sjuMcZylUiIqPAZeCcOwo2bgaKdigL8u2TveT.pdf',	'2020-01-08 08:54:30',	'2020-01-08 08:54:48',	NULL);

DROP TABLE IF EXISTS `audit_finding_followup`;
CREATE TABLE `audit_finding_followup` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `audit_finding_id` int(10) unsigned NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `audit_finding_followup_comments`;
CREATE TABLE `audit_finding_followup_comments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `audit_finding_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `file_name` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_size` int(11) DEFAULT NULL,
  `file_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_finding_followup_comments` (`id`, `audit_finding_id`, `user_id`, `description`, `file_name`, `file_size`, `file_url`, `created_at`, `updated_at`) VALUES
(1,	1,	8,	'resolved',	'Screenshot_42013year.png',	86700,	'5Nn8S7gHktStKQGIhYbIkIm0oTJCtpa7yDJUKg1L.png',	'2019-12-17 15:03:15',	'2019-12-17 15:03:15'),
(2,	2,	8,	'comment1',	'lorem word.pdf',	184332,	'8CaaWeeWr29yKS7LUrPzeCo78rUaoTgJUf20fQwK.pdf',	'2019-12-18 10:53:05',	'2019-12-18 10:53:05'),
(3,	11,	8,	'resolved',	'aaaSample4 (2) (2) (1) (6) (1) (3) (2).PDF',	75981,	'e144gLXXxiNozLLjGItJ9Mcx4jbhjNbY1RBaqbBZ.pdf',	'2019-12-23 10:37:27',	'2019-12-23 10:37:27'),
(4,	6,	70,	'not valid',	NULL,	NULL,	NULL,	'2019-12-23 10:56:52',	'2019-12-23 10:56:52'),
(5,	20,	389,	'resolved',	'aaaSample4 (2) (2) (1) (6) (1) (3) (1) (1).PDF',	75981,	'Ep1RJwW1s3I1OTKh7ooP7rlEzojDcls209VYE4UX.pdf',	'2020-01-01 16:21:51',	'2020-01-01 16:21:51'),
(6,	20,	5,	'Rejected',	NULL,	NULL,	NULL,	'2020-01-01 16:30:06',	'2020-01-01 16:30:06'),
(7,	22,	1,	'Resolved',	'aaaSample4 (2) (2) (1) (6) (1) (3) (1) (1).PDF',	75981,	'qZTixDvEDMcdQjyAUHaFsipShQqfXmQcT8eyiE30.pdf',	'2020-01-02 08:16:00',	'2020-01-02 08:16:00'),
(8,	28,	1,	'resolved',	'aaaSample4 (2) (2) (1) (6) (1) (3) (1) (1) (1).PDF',	75981,	'5himDE7GgCwWdWEoTMqDon2sPHKWkExJiODmKeIF.pdf',	'2020-01-04 11:29:46',	'2020-01-04 11:29:46'),
(9,	27,	1,	'resolved',	'aaaSample4 (2) (2) (1) (6) (1) (3) (1) (1) (1) (1).PDF',	75981,	'UHCSyB6K2xpfl6ZPHpGHNJl3di9mc25E9WtftvR0.pdf',	'2020-01-04 12:43:44',	'2020-01-04 12:43:44'),
(10,	24,	1,	'Resolved',	'aaaSample4 (2) (2) (1) (6) (1) (3) (1) (1) (1) (1) (1).PDF',	75981,	'Q0VrMLwA2lqxxQDkd3fCV6Iu1WcrgG7DSYzHd1Q8.pdf',	'2020-01-04 14:27:49',	'2020-01-04 14:27:49'),
(11,	30,	1,	'resolved',	'aaaSample4 (2) (2) (1) (6) (1) (3) (1) (1) (1).PDF',	75981,	'Lko8mp3KnUm5xlJwBzFVjJrijfq0QwZlPV2yRRki.pdf',	'2020-01-04 14:42:12',	'2020-01-04 14:42:12'),
(12,	31,	8,	'cooment',	'aaaSample4 (2) (2) (1) (6) (1) (3) (1) (1) (1) (1) (1).PDF',	75981,	'9FLlwaNlYqIYSMJjSulMbN4LHV10E48EoACArVQJ.pdf',	'2020-01-04 14:51:07',	'2020-01-04 14:51:07'),
(13,	38,	207,	'resplved',	'aaaSample4 (2) (2) (1) (6) (1) (3) (1) (1) (1) (1) (1) (1).PDF',	75981,	'gal380vCmTCe7ExS7siYGIKG0NgIyhN5DdsxLdib.pdf',	'2020-01-07 08:59:09',	'2020-01-07 08:59:09'),
(14,	38,	101,	'accepted',	'aaaSample4 (2) (2) (1) (6) (1) (3) (1) (1) (1) (1) (1) (1).PDF',	75981,	'mujg0vuQYeMu1McUA7hHIO8RYa7i9wELyhUpJDkp.pdf',	'2020-01-07 09:04:12',	'2020-01-07 09:04:12'),
(15,	39,	437,	'resolved',	'aaaSample4 (2) (2) (1) (6) (1) (3) (1) (1) (1) (1) (1) (1).PDF',	75981,	'uWCbJ1QA1T4YnsFRZbSA63mCrwmU7tDanPFs26We.pdf',	'2020-01-07 09:41:55',	'2020-01-07 09:41:55'),
(16,	40,	437,	'resolved',	'aaaSample4 (2) (2) (1) (6) (1) (3) (1) (1) (1) (1) (1) (1).PDF',	75981,	'O8224s50yErngYSOybuAlSSHER9wUyatAE5Ltk1G.pdf',	'2020-01-07 09:51:02',	'2020-01-07 09:51:02'),
(17,	41,	437,	'resolved',	'aaaSample4 (2) (2) (1) (6) (1) (3) (1) (1) (1) (1) (1).PDF',	75981,	'B1yMDTbjz8krTJvLyDL4BLWk6LNrC7rmMsfvRKGJ.pdf',	'2020-01-07 10:05:18',	'2020-01-07 10:05:18'),
(18,	43,	53,	'resolved',	'aaaSample4 (2) (2) (1) (6) (1) (3) (1) (1) (1) (1) (1) (1).PDF',	75981,	'adF6mzeE9Y2lOZ6W4AlbXKVXWexMYpgAW6gZKqxT.pdf',	'2020-01-07 15:37:04',	'2020-01-07 15:37:04'),
(19,	43,	527,	'rejected',	'aaaSample4 (2) (2) (1) (6) (1) (3) (1) (1) (1) (1) (1) (1).PDF',	75981,	'Z7cTvSFAVXw8sVmRueK2xDII0aAL3RQybXicq27y.pdf',	'2020-01-07 15:39:24',	'2020-01-07 15:39:24'),
(20,	43,	53,	'rejeted',	'aaaSample4 (2) (2) (1) (6) (1) (3) (1) (1) (1) (1) (1) (1).PDF',	75981,	'oknmhbopSxz2DjHtoNqhADxRGJk3j8UVDB754mDw.pdf',	'2020-01-07 15:40:34',	'2020-01-07 15:40:34'),
(21,	43,	527,	'accepted',	NULL,	NULL,	NULL,	'2020-01-07 15:41:06',	'2020-01-07 15:41:06'),
(22,	48,	243,	'resolved',	'aaaSample4 (2) (2) (1) (6) (1) (3) (1) (1) (1) (1).PDF',	75981,	'h3BzNRQZch3LOwmx5SFJGpW9vtJPciWjIJcKxfVE.pdf',	'2020-01-08 11:22:00',	'2020-01-08 11:22:00'),
(23,	48,	101,	'rejectedd',	'aaaSample4 (2) (2) (1) (6) (1) (3) (1) (1) (1) (1).PDF',	75981,	'MCNflkHLi54blf5kHuR5VPURkOy7gDy94wLgnbKk.pdf',	'2020-01-08 11:23:34',	'2020-01-08 11:23:34'),
(24,	57,	1,	'erghaerhrs',	'ud.png',	23463,	'hn0KQbS568iTkjY1E5Cdwmc1z4ZMogUvxrkqgvwM.png',	'2020-01-17 10:13:22',	'2020-01-17 10:13:22'),
(25,	57,	1,	'drtyaery',	'etisalat.png',	66773,	'60E0yrnUAld4me2fNHqLHwUHHrhEnJR7UgBfRkuo.png',	'2020-01-17 10:14:08',	'2020-01-17 10:14:08'),
(26,	57,	1,	'ukri',	'enoc.png',	17143,	'0EJFCpVN9dnl4yV8oceIwpdzF8CTdIWZZRKWiDLp.png',	'2020-01-17 10:14:36',	'2020-01-17 10:14:36'),
(27,	57,	1,	'1wfert',	'enoc.png',	17143,	'545SuRnAJ48Lam0IpqYN4y1vK4TJMnaFxHm5w8MI.png',	'2020-01-17 10:14:57',	'2020-01-17 10:14:57'),
(28,	63,	1,	'hi',	NULL,	NULL,	NULL,	'2020-01-18 14:59:17',	'2020-01-18 14:59:17'),
(29,	63,	1,	'resolved',	'aaaSample4 (2) (2) (1) (6) (1) (3) (1) (1) (1) (2).PDF',	75981,	'U0JDoYWpAxivjxSbMbXtHgFrQ7eC5By4MPpHruOM.pdf',	'2020-01-18 15:03:47',	'2020-01-18 15:03:47'),
(30,	63,	527,	'rejected',	NULL,	NULL,	NULL,	'2020-01-18 15:05:21',	'2020-01-18 15:05:21'),
(31,	63,	1,	'resolved',	'audit_report - 2020-01-18T102531.681.pdf',	121775,	'xvlceuN7KVLOjVeuaunA5P4oxfS0FVTnVZr9de02.pdf',	'2020-01-18 15:05:55',	'2020-01-18 15:05:55'),
(32,	63,	527,	'aaceptede',	NULL,	NULL,	NULL,	'2020-01-18 15:06:51',	'2020-01-18 15:06:51'),
(33,	64,	1,	'sdas',	'audit_report - 2020-01-18T102531.681 (1).pdf',	121775,	'VuFnun4Uv960e7hrKdFOwA0yuKEOKWpctdyJJCN4.pdf',	'2020-01-18 15:19:37',	'2020-01-18 15:19:37'),
(34,	68,	539,	'resolved',	'aaaSample4 (2) (2) (1) (6) (1) (3) (1) (1) (1) (1) (1) (2).PDF',	75981,	'WUr0C3ep4yPqnfHAo6A5ACchMZHPSAdNdsmRq32Y.pdf',	'2020-01-21 09:16:29',	'2020-01-21 09:16:29'),
(35,	84,	539,	'resolvedd',	'Desert.jpg',	845941,	'zg42cBqO8HzzVlAxP3GzZja5CpYLF5QuWf6Wu0kF.jpeg',	'2020-01-25 13:27:08',	'2020-01-25 13:27:08'),
(36,	90,	538,	'speial',	'Chrysanthemum.jpg',	879394,	'kwZxBZvOl9pZEUHyzaZH65xk5GomOJyHWxyfaNGH.jpeg',	'2020-01-25 16:09:24',	'2020-01-25 16:09:24'),
(37,	91,	8,	'resolved',	'aaaSample4 (2) (2) (1) (6) (1) (3) (1) (1) (1) (2) (1) (2).PDF',	75981,	'2MbhatQ865sVyTFtRQ0lPLLxzmBDTBGAAUbpTaKo.pdf',	'2020-01-31 10:15:09',	'2020-01-31 10:15:09'),
(38,	91,	527,	'rejected',	'aaaSample4 (2) (2) (1) (6) (1) (3) (1) (1) (1) (2) (1) (2).PDF',	75981,	'5yaKhaG42OAxIOmr9Mg2aOAdEnl1zxeEaYH2HJph.pdf',	'2020-01-31 10:22:02',	'2020-01-31 10:22:02'),
(39,	91,	8,	'resolved',	'lorem word (2) (1) (2) (2).pdf',	184332,	'9UgHivojr4GPmSjt7gJfxAv9m5l3w0zBFNYxJ0K0.pdf',	'2020-01-31 10:35:10',	'2020-01-31 10:35:10'),
(40,	91,	527,	'accepted',	'lorem word (2) (1) (2) (2).pdf',	184332,	'13bc46xke3AT1HvR5jMu3nCJ6ANfEctvWkNyEEAN.pdf',	'2020-01-31 10:36:06',	'2020-01-31 10:36:06'),
(41,	91,	8,	'acepted',	'audit_report - 2020-01-27T112823.800.pdf',	8586,	'0bfcpkhI65XAX57CjbxR5HICYHK3sE0FAcSWZxl5.pdf',	'2020-01-31 10:37:54',	'2020-01-31 10:37:54'),
(42,	92,	8,	'resolved',	'aaaSample4 (2) (2) (1) (6) (1) (3) (1) (1) (1) (2) (1) (2).PDF',	75981,	'pdm14spxLEfESMbm5fWUECLXaMPKIDLb8Sc5xX1D.pdf',	'2020-01-31 12:21:49',	'2020-01-31 12:21:49'),
(43,	89,	538,	'resolved',	'lorem word (2) (1) (2) (2) (4).pdf',	184332,	'GngcDoGg9CXcNIMZwx6RxD68knSLLTFdHQxClTZk.pdf',	'2020-02-10 10:17:32',	'2020-02-10 10:17:32'),
(44,	89,	8,	'Rejected',	'lorem word (2) (1) (2) (2) (4).pdf',	184332,	'TCi4Jjaor2AGD0AW0aiYULfzIvvijAgqde3K80YY.pdf',	'2020-02-10 10:28:57',	'2020-02-10 10:28:57'),
(45,	89,	538,	'resolved',	'lorem word (2) (1) (2) (2) (4).pdf',	184332,	'1KSBtn26eVBrZFdeLzM2Hfq10UOYXVdC2WEDVuGm.pdf',	'2020-02-10 10:32:16',	'2020-02-10 10:32:16'),
(46,	89,	8,	'accepted',	'lorem word (2) (1) (2) (2) (2).pdf',	184332,	'yjTvDhZxNPYnf9h4w0klg6Qu2ZJ3PPQGBufndbZY.pdf',	'2020-02-10 10:38:49',	'2020-02-10 10:38:49'),
(47,	83,	8,	'closed',	'lorem word (2) (1) (2) (2) (4).pdf',	184332,	'wYhQMwmhRcafSCZ2J0Klw4WD04JXYf3QhDb6sSAE.pdf',	'2020-02-10 10:41:24',	'2020-02-10 10:41:24'),
(48,	88,	8,	'resolved',	'aaaSample4 (2) (2) (1) (6) (1) (3) (1) (1) (1) (2) (1) (2).PDF',	75981,	'yQ0ZpO85SIOMCeOI3BfdjfTxcUDCpFg6UdIsXatz.pdf',	'2020-02-10 11:05:39',	'2020-02-10 11:05:39'),
(49,	88,	8,	'Rejected',	'lorem word (2) (1) (2) (2) (4).pdf',	184332,	'4BlPHFcqmdFrn8yaO9X2jvE4TE8sKeJR2GkyKFzv.pdf',	'2020-02-10 11:07:39',	'2020-02-10 11:07:39'),
(50,	73,	538,	'Resolved',	'lorem word (2) (1) (2) (2) (4).pdf',	184332,	'Oyt1295wZv9B8lAcKq15x0QHCeswpV4iv9lZ2ZMo.pdf',	'2020-02-10 11:38:54',	'2020-02-10 11:38:54'),
(51,	73,	538,	'Rejected',	'aaaSample4 (2) (2) (1) (6) (1) (3) (1) (1) (1) (2) (1) (2).PDF',	75981,	'eH16A1VjEW5tIOAnLABRcdBEsEXrK3oDoZjT6A4x.pdf',	'2020-02-10 17:07:52',	'2020-02-10 17:07:52'),
(52,	73,	538,	'resolved',	'lorem word (2) (1) (2) (2) (4).pdf',	184332,	'fCuEgr8oi3ASlBrW3XBZ6FWLgdbf27h0YG16Bv29.pdf',	'2020-02-10 17:17:19',	'2020-02-10 17:17:19'),
(53,	73,	538,	'Rejected',	'lorem word (2) (1) (2) (2) (4).pdf',	184332,	'LwjYDVQz7WWfQIx6fDM06lVzCLCk46Q8XiBtAbjR.pdf',	'2020-02-10 17:18:57',	'2020-02-10 17:18:57'),
(54,	93,	541,	'resolved',	'lorem word (2) (1) (2) (2) (4) (1).pdf',	184332,	'Cbkj00SOzcvBhY8OYz724XcS95NTl0eUM8Zgx3ca.pdf',	'2020-02-24 12:38:09',	'2020-02-24 12:38:09');

DROP TABLE IF EXISTS `audit_finding_impacts`;
CREATE TABLE `audit_finding_impacts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `audit_finding_id` int(10) unsigned NOT NULL,
  `impact_category_id` int(10) unsigned NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `cost` int(11) NOT NULL,
  `value` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `audit_finding_mstypes`;
CREATE TABLE `audit_finding_mstypes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `audit_finding_id` int(10) unsigned DEFAULT NULL,
  `mstype_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_finding_mstypes` (`id`, `audit_finding_id`, `mstype_id`) VALUES
(1,	1,	1),
(2,	3,	2),
(3,	5,	2),
(4,	7,	2),
(5,	8,	1),
(6,	10,	1),
(7,	11,	1),
(8,	15,	1),
(9,	15,	1),
(10,	15,	1),
(11,	15,	1),
(12,	16,	2),
(13,	17,	1),
(15,	18,	2),
(16,	19,	2),
(17,	20,	1),
(18,	21,	1),
(19,	22,	1),
(21,	23,	1),
(22,	24,	1),
(23,	27,	1),
(24,	28,	2),
(25,	29,	1),
(26,	30,	1),
(27,	32,	7),
(28,	33,	7),
(29,	34,	7),
(30,	35,	7),
(31,	36,	2),
(32,	37,	2),
(33,	39,	2),
(34,	40,	2),
(35,	41,	2),
(36,	43,	7),
(37,	44,	7),
(38,	44,	9),
(39,	45,	9),
(40,	46,	9),
(41,	47,	1),
(42,	48,	1),
(43,	50,	5),
(44,	8,	1),
(45,	55,	1),
(46,	56,	1),
(47,	57,	1),
(48,	57,	1),
(51,	58,	1),
(53,	60,	2),
(54,	61,	2),
(55,	62,	13),
(56,	63,	15),
(57,	64,	6),
(58,	66,	1),
(59,	67,	1),
(60,	68,	11),
(61,	70,	11),
(62,	72,	11),
(63,	73,	11),
(64,	75,	15),
(65,	76,	15),
(66,	79,	15),
(67,	80,	15),
(68,	81,	15),
(69,	86,	3),
(70,	87,	3),
(71,	88,	3),
(72,	90,	3),
(73,	91,	3),
(74,	92,	4),
(77,	93,	1),
(78,	93,	15);

DROP TABLE IF EXISTS `audit_finding_process`;
CREATE TABLE `audit_finding_process` (
  `audit_finding_id` int(10) unsigned NOT NULL,
  `process_id` int(10) unsigned NOT NULL,
  `parent_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`audit_finding_id`,`process_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_finding_process` (`audit_finding_id`, `process_id`, `parent_id`) VALUES
(4,	64,	0),
(15,	64,	0),
(16,	64,	0),
(17,	64,	0),
(19,	65,	0),
(20,	65,	0),
(27,	64,	0),
(55,	64,	0),
(56,	64,	0),
(57,	64,	0);

DROP TABLE IF EXISTS `audit_finding_report_versions`;
CREATE TABLE `audit_finding_report_versions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `audit_finding_id` int(11) DEFAULT NULL,
  `audit_report_id` int(11) DEFAULT NULL,
  `version_id` int(11) DEFAULT NULL,
  `report_version` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_finding_report_versions` (`id`, `audit_finding_id`, `audit_report_id`, `version_id`, `report_version`) VALUES
(1,	6,	42,	4,	1),
(2,	90,	70,	32,	1);

DROP TABLE IF EXISTS `audit_finding_sections`;
CREATE TABLE `audit_finding_sections` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `audit_finding_id` int(10) unsigned NOT NULL,
  `section_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_finding_sections` (`id`, `audit_finding_id`, `section_id`, `created_at`, `updated_at`) VALUES
(1,	3,	39,	NULL,	NULL),
(3,	5,	30,	NULL,	NULL),
(5,	7,	39,	NULL,	NULL),
(7,	260,	39,	NULL,	NULL),
(8,	139,	1,	NULL,	NULL),
(9,	139,	2,	NULL,	NULL),
(10,	140,	17,	NULL,	NULL),
(11,	140,	16,	NULL,	NULL),
(12,	140,	18,	NULL,	NULL),
(13,	141,	17,	NULL,	NULL),
(14,	141,	16,	NULL,	NULL),
(15,	141,	18,	NULL,	NULL),
(16,	142,	1,	NULL,	NULL),
(17,	142,	2,	NULL,	NULL),
(18,	142,	3,	NULL,	NULL),
(19,	146,	39,	NULL,	NULL),
(20,	147,	39,	NULL,	NULL),
(21,	155,	1,	NULL,	NULL),
(22,	155,	2,	NULL,	NULL),
(23,	155,	3,	NULL,	NULL),
(24,	156,	1,	NULL,	NULL),
(25,	156,	2,	NULL,	NULL),
(26,	161,	17,	NULL,	NULL),
(27,	161,	16,	NULL,	NULL),
(28,	161,	18,	NULL,	NULL),
(29,	9,	1,	NULL,	NULL),
(30,	9,	2,	NULL,	NULL),
(31,	9,	3,	NULL,	NULL),
(32,	10,	17,	NULL,	NULL),
(33,	10,	16,	NULL,	NULL),
(34,	10,	18,	NULL,	NULL),
(35,	11,	62,	NULL,	NULL),
(36,	11,	53,	NULL,	NULL),
(37,	12,	4,	NULL,	NULL),
(39,	18,	63,	NULL,	NULL),
(40,	21,	30,	NULL,	NULL),
(41,	21,	31,	NULL,	NULL),
(42,	22,	17,	NULL,	NULL),
(43,	22,	16,	NULL,	NULL),
(44,	22,	18,	NULL,	NULL),
(46,	23,	39,	NULL,	NULL),
(47,	24,	39,	NULL,	NULL),
(49,	25,	39,	NULL,	NULL),
(50,	26,	63,	NULL,	NULL),
(51,	29,	17,	NULL,	NULL),
(52,	29,	16,	NULL,	NULL),
(53,	29,	18,	NULL,	NULL),
(54,	30,	1,	NULL,	NULL),
(55,	30,	2,	NULL,	NULL),
(56,	30,	3,	NULL,	NULL),
(57,	31,	17,	NULL,	NULL),
(58,	31,	16,	NULL,	NULL),
(59,	31,	18,	NULL,	NULL),
(60,	34,	23,	NULL,	NULL),
(61,	39,	35,	NULL,	NULL),
(62,	39,	36,	NULL,	NULL),
(63,	39,	37,	NULL,	NULL),
(64,	40,	35,	NULL,	NULL),
(65,	40,	36,	NULL,	NULL),
(66,	40,	37,	NULL,	NULL),
(67,	41,	35,	NULL,	NULL),
(68,	41,	36,	NULL,	NULL),
(69,	41,	37,	NULL,	NULL),
(70,	44,	17,	NULL,	NULL),
(71,	44,	16,	NULL,	NULL),
(72,	44,	18,	NULL,	NULL),
(73,	45,	41,	NULL,	NULL),
(74,	46,	45,	NULL,	NULL),
(75,	46,	60,	NULL,	NULL),
(78,	58,	39,	NULL,	NULL),
(79,	59,	47,	NULL,	NULL),
(81,	60,	51,	NULL,	NULL),
(82,	61,	39,	NULL,	NULL),
(83,	64,	41,	NULL,	NULL),
(84,	65,	41,	NULL,	NULL),
(85,	68,	66,	NULL,	NULL),
(86,	69,	39,	NULL,	NULL),
(87,	75,	64,	NULL,	NULL),
(88,	76,	64,	NULL,	NULL),
(89,	77,	64,	NULL,	NULL),
(90,	78,	66,	NULL,	NULL),
(91,	79,	64,	NULL,	NULL),
(92,	80,	64,	NULL,	NULL),
(93,	81,	64,	NULL,	NULL),
(97,	82,	17,	NULL,	NULL),
(98,	82,	16,	NULL,	NULL),
(99,	82,	18,	NULL,	NULL),
(100,	83,	41,	NULL,	NULL),
(101,	84,	32,	NULL,	NULL),
(102,	84,	33,	NULL,	NULL),
(103,	84,	34,	NULL,	NULL),
(104,	92,	17,	NULL,	NULL),
(105,	92,	16,	NULL,	NULL),
(106,	92,	18,	NULL,	NULL),
(109,	93,	30,	NULL,	NULL),
(110,	93,	31,	NULL,	NULL);

DROP TABLE IF EXISTS `audit_finding_statuses`;
CREATE TABLE `audit_finding_statuses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_draft` int(11) NOT NULL DEFAULT '0',
  `is_new` tinyint(1) NOT NULL DEFAULT '0',
  `is_resolved` tinyint(1) NOT NULL DEFAULT '0',
  `is_accepted` tinyint(1) NOT NULL DEFAULT '0',
  `is_rejected` tinyint(1) NOT NULL DEFAULT '0',
  `is_open` tinyint(1) NOT NULL DEFAULT '0',
  `is_close` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `updated_by` int(10) unsigned DEFAULT NULL,
  `deleted_by` int(10) unsigned DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1',
  `is_discarded` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_finding_statuses` (`id`, `title`, `label`, `message`, `is_draft`, `is_new`, `is_resolved`, `is_accepted`, `is_rejected`, `is_open`, `is_close`, `created_at`, `updated_at`, `deleted_at`, `created_by`, `updated_by`, `deleted_by`, `status`, `is_discarded`) VALUES
(1,	'Draft',	'default',	'',	1,	0,	0,	0,	0,	0,	0,	'2018-12-12 09:48:29',	'2018-12-12 09:48:29',	NULL,	1,	NULL,	NULL,	1,	NULL),
(2,	'Open',	'primary',	'',	0,	0,	0,	0,	0,	1,	0,	'2018-12-12 09:48:29',	'2018-12-12 09:48:29',	NULL,	0,	NULL,	NULL,	1,	NULL),
(3,	'Resolved',	'warning',	'',	0,	0,	1,	0,	0,	1,	0,	'2018-12-12 09:48:29',	'2018-12-12 09:48:29',	NULL,	1,	NULL,	NULL,	1,	NULL),
(4,	'Accepted',	'success',	'',	0,	0,	0,	1,	0,	0,	0,	'2018-12-12 09:48:29',	'2018-12-12 09:48:29',	NULL,	1,	NULL,	NULL,	1,	NULL),
(5,	'Rejected',	'warning',	'',	0,	0,	0,	0,	1,	1,	0,	'2018-12-12 09:48:29',	'2018-12-12 09:48:29',	NULL,	1,	NULL,	NULL,	1,	NULL),
(6,	'Close',	'success',	'',	0,	0,	0,	0,	0,	0,	1,	'2018-12-12 09:48:29',	'2018-12-12 09:48:29',	NULL,	1,	NULL,	NULL,	1,	NULL),
(7,	'Discarded',	'warning',	'',	0,	0,	0,	0,	0,	0,	0,	'2019-02-04 08:12:34',	'2019-02-04 08:12:34',	NULL,	1,	NULL,	NULL,	1,	1);

DROP TABLE IF EXISTS `audit_objectives`;
CREATE TABLE `audit_objectives` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_objectives` (`id`, `title`, `created_at`, `updated_at`, `deleted_at`, `status`) VALUES
(1,	'Ensuring the compliance against standard requirement',	'2018-10-10 09:31:30',	'2018-10-10 09:31:30',	NULL,	1),
(2,	'test1',	'2018-10-30 06:45:45',	'2018-10-30 06:54:50',	'2018-10-30 06:54:50',	1),
(3,	'test2',	'2018-10-30 06:45:57',	'2018-10-30 06:54:15',	'2018-10-30 06:54:15',	1),
(4,	'test3',	'2018-10-30 06:46:09',	'2018-10-30 06:54:03',	'2018-10-30 06:54:03',	1),
(5,	'test4',	'2018-10-30 06:46:15',	'2018-10-30 06:54:10',	'2018-10-30 06:54:10',	1),
(6,	'test5',	'2018-10-30 06:46:19',	'2018-10-30 06:53:56',	'2018-10-30 06:53:56',	1),
(7,	'test6',	'2018-10-30 06:46:24',	'2018-10-30 06:53:50',	'2018-10-30 06:53:50',	1),
(8,	'test7',	'2018-10-30 06:46:28',	'2018-10-30 06:53:35',	'2018-10-30 06:53:35',	1),
(9,	'test8445',	'2018-10-30 06:46:34',	'2018-10-30 06:53:43',	'2018-10-30 06:53:43',	1),
(10,	'test9',	'2018-10-30 06:46:49',	'2018-10-30 06:47:48',	'2018-10-30 06:47:48',	1),
(11,	'test10',	'2018-10-30 06:46:56',	'2018-10-30 06:54:46',	'2018-10-30 06:54:46',	1),
(12,	'test11',	'2018-10-30 06:47:01',	'2018-10-30 06:54:41',	'2018-10-30 06:54:41',	1),
(13,	'test12',	'2018-10-30 06:47:07',	'2018-10-30 06:54:37',	'2018-10-30 06:54:37',	1),
(14,	'test13',	'2018-10-30 06:47:13',	'2018-10-30 06:54:33',	'2018-10-30 06:54:33',	1),
(15,	'test14',	'2018-10-30 06:47:19',	'2018-10-30 06:54:29',	'2018-10-30 06:54:29',	1),
(16,	'test15',	'2018-10-30 06:47:25',	'2018-10-30 06:54:21',	'2018-10-30 06:54:21',	1),
(17,	'test16',	'2018-10-30 06:47:40',	'2018-10-30 06:54:26',	'2018-10-30 06:54:26',	1),
(18,	'The audit scope generally includes a description of the physical locations, organizational units, activities and processes, as well as the time period covered.',	'2018-10-30 08:55:42',	'2018-10-30 08:55:53',	'2018-10-30 08:55:53',	1),
(19,	'Review activity for the mostly recent twelve-month period',	'2018-11-07 05:52:49',	'2018-11-10 09:55:09',	NULL,	1),
(20,	'Access the adequacy and effectiveness of internal controls over payroll processing',	'2018-11-07 05:54:01',	'2018-11-07 05:54:01',	NULL,	1),
(21,	'ISO 9001:2015  Internal Audit',	'2019-06-18 16:28:25',	'2019-06-18 16:28:25',	NULL,	1),
(23,	'ISO 9001:2015',	'2019-06-18 16:28:42',	'2019-06-18 16:28:42',	NULL,	1),
(25,	'ISO 14001:2015 Transition Internal Audit',	'2019-06-18 16:28:51',	'2019-06-18 16:28:51',	NULL,	1),
(27,	'OHSAS 18001:2007 Internal Audit',	'2019-06-18 16:29:06',	'2019-06-18 16:29:06',	NULL,	1),
(29,	'ISO 14001:2015',	'2019-06-18 16:29:54',	'2019-06-18 16:29:54',	NULL,	1);

DROP TABLE IF EXISTS `audit_opening_meeting_users`;
CREATE TABLE `audit_opening_meeting_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `audit_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `is_present` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `audit_parties`;
CREATE TABLE `audit_parties` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `is_opening` tinyint(4) NOT NULL DEFAULT '0',
  `is_closing` tinyint(4) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `updated_by` int(10) unsigned DEFAULT NULL,
  `deleted_by` int(10) unsigned DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_parties` (`id`, `title`, `description`, `is_opening`, `is_closing`, `created_at`, `updated_at`, `created_by`, `updated_by`, `deleted_by`, `status`) VALUES
(1,	'First Party',	NULL,	0,	0,	'2018-10-03 14:29:20',	'2018-10-03 14:29:20',	0,	NULL,	NULL,	1),
(2,	'Second Party',	NULL,	1,	1,	'2018-10-03 14:29:20',	'2018-10-03 14:29:20',	0,	NULL,	NULL,	1),
(3,	'Third Party',	NULL,	1,	1,	'2018-10-03 14:29:20',	'2018-10-03 14:29:20',	0,	NULL,	NULL,	1);

DROP TABLE IF EXISTS `audit_plans`;
CREATE TABLE `audit_plans` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `unique_id` int(11) NOT NULL DEFAULT '1',
  `audit_program_id` int(10) unsigned NOT NULL,
  `audit_pre_plan_id` int(10) unsigned DEFAULT NULL,
  `audit_plan_status_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `updated_by` int(10) unsigned DEFAULT NULL,
  `deleted_by` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_plans` (`id`, `unique_id`, `audit_program_id`, `audit_pre_plan_id`, `audit_plan_status_id`, `created_at`, `updated_at`, `deleted_at`, `created_by`, `updated_by`, `deleted_by`) VALUES
(1,	1,	1,	1,	4,	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	8,	NULL,	NULL),
(2,	2,	1,	2,	4,	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	8,	NULL,	NULL),
(3,	3,	1,	3,	4,	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	8,	NULL,	NULL),
(4,	4,	1,	4,	4,	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	8,	NULL,	NULL),
(5,	5,	1,	5,	4,	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	8,	NULL,	NULL),
(6,	6,	1,	6,	4,	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	8,	NULL,	NULL),
(7,	7,	1,	7,	4,	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	8,	NULL,	NULL),
(8,	8,	1,	8,	4,	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	8,	NULL,	NULL),
(9,	9,	1,	9,	4,	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	8,	NULL,	NULL),
(10,	10,	1,	10,	4,	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	8,	NULL,	NULL),
(11,	11,	1,	11,	4,	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	8,	NULL,	NULL),
(12,	12,	1,	12,	4,	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	8,	NULL,	NULL),
(13,	13,	1,	13,	4,	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	8,	NULL,	NULL),
(14,	14,	1,	14,	4,	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	8,	NULL,	NULL),
(15,	15,	1,	15,	4,	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	8,	NULL,	NULL),
(16,	16,	1,	16,	4,	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	8,	NULL,	NULL),
(17,	17,	1,	17,	4,	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	8,	NULL,	NULL),
(18,	18,	1,	18,	4,	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	8,	NULL,	NULL),
(19,	19,	1,	19,	4,	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	8,	NULL,	NULL),
(20,	20,	1,	20,	4,	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	8,	NULL,	NULL),
(21,	1,	2,	21,	4,	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	8,	NULL,	NULL),
(22,	2,	2,	22,	4,	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	8,	NULL,	NULL),
(23,	3,	2,	23,	4,	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	8,	NULL,	NULL),
(24,	4,	2,	24,	4,	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	8,	NULL,	NULL),
(25,	5,	2,	25,	4,	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	8,	NULL,	NULL),
(26,	6,	2,	26,	4,	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	8,	NULL,	NULL),
(27,	7,	2,	27,	4,	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	8,	NULL,	NULL),
(28,	8,	2,	28,	4,	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	8,	NULL,	NULL),
(29,	9,	2,	29,	4,	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	8,	NULL,	NULL),
(30,	10,	2,	30,	4,	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	8,	NULL,	NULL),
(31,	11,	2,	31,	4,	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	8,	NULL,	NULL),
(32,	12,	2,	32,	4,	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	8,	NULL,	NULL),
(33,	13,	2,	33,	4,	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	8,	NULL,	NULL),
(34,	14,	2,	34,	4,	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	8,	NULL,	NULL),
(35,	15,	2,	35,	4,	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	8,	NULL,	NULL),
(36,	16,	2,	36,	4,	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	8,	NULL,	NULL),
(37,	17,	2,	37,	4,	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	8,	NULL,	NULL),
(38,	18,	2,	38,	4,	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	8,	NULL,	NULL),
(39,	1,	3,	39,	4,	'2019-12-17 14:57:01',	'2019-12-17 14:58:22',	NULL,	101,	1,	NULL),
(40,	2,	4,	40,	4,	'2019-12-18 10:27:50',	'2019-12-18 10:32:02',	NULL,	101,	529,	NULL),
(41,	3,	7,	46,	4,	'2019-12-20 08:52:16',	'2019-12-20 08:58:15',	NULL,	101,	70,	NULL),
(42,	4,	7,	47,	2,	'2019-12-20 13:11:46',	'2020-01-06 16:05:03',	'2020-01-06 16:05:03',	101,	101,	1),
(45,	5,	12,	57,	2,	'2019-12-21 14:08:25',	'2019-12-21 14:09:05',	NULL,	329,	329,	NULL),
(46,	6,	12,	58,	2,	'2019-12-21 14:14:57',	'2019-12-21 14:15:06',	NULL,	329,	329,	NULL),
(47,	7,	13,	59,	4,	'2019-12-23 09:49:52',	'2019-12-23 09:52:21',	NULL,	329,	329,	NULL),
(48,	8,	13,	60,	4,	'2019-12-23 10:05:44',	'2019-12-23 10:10:46',	NULL,	79,	79,	NULL),
(49,	9,	13,	61,	4,	'2019-12-23 11:31:44',	'2019-12-23 12:47:23',	NULL,	297,	61,	NULL),
(50,	10,	14,	62,	4,	'2019-12-23 13:33:28',	'2019-12-30 15:17:32',	'2019-12-30 15:17:32',	527,	32,	1),
(51,	11,	15,	64,	4,	'2019-12-24 10:39:35',	'2019-12-24 10:42:13',	NULL,	53,	53,	NULL),
(52,	12,	16,	65,	4,	'2019-12-30 08:40:34',	'2019-12-30 12:41:58',	'2019-12-30 12:41:58',	297,	529,	1),
(53,	12,	16,	66,	4,	'2019-12-30 10:13:03',	'2019-12-30 12:41:10',	'2019-12-30 12:41:10',	527,	1,	1),
(54,	13,	16,	67,	1,	'2019-12-30 11:05:40',	'2019-12-30 11:05:59',	'2019-12-30 11:05:59',	527,	NULL,	527),
(57,	13,	16,	67,	1,	'2019-12-30 11:39:43',	'2019-12-30 11:40:53',	'2019-12-30 11:40:53',	527,	NULL,	527),
(58,	13,	16,	67,	1,	'2019-12-30 11:41:01',	'2019-12-30 11:41:47',	'2019-12-30 11:41:47',	527,	NULL,	527),
(59,	12,	16,	66,	1,	'2019-12-30 12:53:23',	'2019-12-30 13:05:15',	'2019-12-30 13:05:15',	527,	NULL,	1),
(60,	12,	16,	66,	2,	'2019-12-30 13:31:18',	'2019-12-30 15:23:06',	'2019-12-30 15:23:06',	527,	527,	1),
(61,	13,	17,	69,	1,	'2019-12-30 13:45:20',	'2019-12-30 13:45:20',	NULL,	527,	NULL,	NULL),
(62,	1,	17,	71,	4,	'2019-12-31 09:36:21',	'2019-12-31 09:39:06',	NULL,	101,	70,	NULL),
(63,	2,	19,	78,	4,	'2020-01-01 12:11:36',	'2020-01-01 15:06:28',	NULL,	527,	243,	NULL),
(64,	3,	19,	79,	2,	'2020-01-03 09:35:35',	'2020-01-06 16:02:18',	'2020-01-06 16:02:18',	22,	22,	1),
(65,	4,	20,	80,	4,	'2020-01-03 10:03:41',	'2020-01-03 10:56:59',	NULL,	101,	101,	NULL),
(67,	5,	20,	82,	3,	'2020-01-03 10:46:49',	'2020-01-03 11:18:16',	NULL,	101,	532,	NULL),
(68,	5,	21,	84,	2,	'2020-01-03 12:38:11',	'2020-01-03 12:39:23',	NULL,	101,	101,	NULL),
(69,	6,	25,	92,	4,	'2020-01-04 08:47:53',	'2020-01-04 10:14:47',	NULL,	527,	477,	NULL),
(70,	21,	26,	94,	4,	'2020-01-06 09:56:14',	'2020-01-06 09:58:48',	NULL,	1,	383,	NULL),
(71,	22,	26,	95,	4,	'2020-01-06 13:22:21',	'2020-01-06 13:55:13',	NULL,	1,	383,	NULL),
(72,	7,	7,	47,	2,	'2020-01-06 16:07:21',	'2020-01-06 16:07:21',	NULL,	101,	101,	NULL),
(73,	6,	27,	96,	4,	'2020-01-07 08:50:52',	'2020-01-07 08:51:06',	NULL,	101,	101,	NULL),
(74,	7,	29,	101,	1,	'2020-01-07 12:41:53',	'2020-01-07 12:44:16',	'2020-01-07 12:44:16',	527,	NULL,	527),
(75,	8,	29,	101,	1,	'2020-01-07 12:41:58',	'2020-01-07 12:44:07',	'2020-01-07 12:44:07',	527,	NULL,	527),
(76,	9,	29,	101,	1,	'2020-01-07 12:42:03',	'2020-01-07 12:43:43',	'2020-01-07 12:43:43',	527,	NULL,	527),
(77,	7,	29,	101,	1,	'2020-01-07 12:44:45',	'2020-01-07 12:46:01',	'2020-01-07 12:46:01',	527,	NULL,	527),
(78,	8,	29,	101,	1,	'2020-01-07 12:44:46',	'2020-01-07 12:45:27',	'2020-01-07 12:45:27',	527,	NULL,	527),
(79,	9,	29,	101,	1,	'2020-01-07 12:44:46',	'2020-01-07 12:45:36',	'2020-01-07 12:45:36',	527,	NULL,	527),
(80,	10,	29,	101,	1,	'2020-01-07 12:44:46',	'2020-01-07 12:45:44',	'2020-01-07 12:45:44',	527,	NULL,	527),
(81,	10,	29,	101,	1,	'2020-01-07 12:44:46',	'2020-01-07 12:45:53',	'2020-01-07 12:45:53',	527,	NULL,	527),
(82,	7,	29,	101,	4,	'2020-01-07 12:48:08',	'2020-01-07 13:01:56',	NULL,	527,	527,	NULL),
(83,	8,	29,	102,	4,	'2020-01-07 13:22:39',	'2020-01-07 13:36:38',	NULL,	527,	243,	NULL),
(84,	9,	30,	103,	1,	'2020-01-08 09:12:41',	'2020-01-08 09:13:11',	'2020-01-08 09:13:11',	101,	NULL,	101),
(85,	10,	30,	103,	1,	'2020-01-08 09:12:49',	'2020-01-08 09:13:22',	'2020-01-08 09:13:22',	101,	NULL,	101),
(86,	9,	30,	103,	4,	'2020-01-08 09:13:54',	'2020-01-08 09:35:56',	NULL,	101,	349,	NULL),
(87,	10,	30,	104,	4,	'2020-01-08 17:03:45',	'2020-01-08 17:07:12',	NULL,	101,	101,	NULL),
(88,	11,	32,	106,	2,	'2020-01-08 17:11:08',	'2020-01-08 17:11:08',	NULL,	101,	101,	NULL),
(89,	12,	32,	107,	2,	'2020-01-08 17:14:06',	'2020-01-08 17:14:06',	NULL,	101,	101,	NULL),
(90,	13,	32,	107,	2,	'2020-01-08 17:14:07',	'2020-01-08 17:14:07',	NULL,	101,	101,	NULL),
(91,	14,	32,	107,	4,	'2020-01-08 17:14:08',	'2020-01-08 17:16:43',	NULL,	101,	101,	NULL),
(92,	15,	32,	107,	2,	'2020-01-08 17:14:08',	'2020-01-08 17:14:08',	NULL,	101,	101,	NULL),
(93,	1,	33,	109,	2,	'2020-01-09 08:44:12',	'2020-01-09 08:45:55',	NULL,	70,	70,	NULL),
(94,	2,	33,	110,	4,	'2020-01-09 08:51:26',	'2020-01-09 08:54:11',	NULL,	527,	22,	NULL),
(95,	3,	34,	111,	1,	'2020-01-09 11:01:40',	'2020-01-09 11:01:40',	NULL,	527,	NULL,	NULL),
(96,	1,	35,	112,	2,	'2020-01-09 12:36:26',	'2020-01-09 12:36:50',	NULL,	22,	22,	NULL),
(97,	2,	35,	115,	2,	'2020-01-09 12:41:18',	'2020-01-09 12:41:18',	NULL,	101,	101,	NULL),
(98,	1,	36,	116,	4,	'2020-01-10 09:11:12',	'2020-01-10 10:40:33',	NULL,	535,	147,	NULL),
(99,	1,	38,	121,	1,	'2020-01-16 09:18:27',	'2020-01-16 09:18:27',	NULL,	527,	NULL,	NULL),
(100,	2,	38,	121,	4,	'2020-01-16 09:18:36',	'2020-01-16 09:24:01',	NULL,	527,	70,	NULL),
(101,	1,	39,	122,	2,	'2020-01-16 10:00:29',	'2020-01-16 10:00:29',	NULL,	527,	527,	NULL),
(102,	1,	42,	126,	4,	'2020-01-16 10:28:44',	'2020-01-16 10:32:53',	NULL,	527,	1,	NULL),
(103,	16,	43,	128,	1,	'2020-01-17 09:09:44',	'2020-01-17 09:12:54',	'2020-01-17 09:12:54',	527,	527,	527),
(104,	16,	43,	128,	1,	'2020-01-17 09:14:18',	'2020-01-17 09:16:07',	'2020-01-17 09:16:07',	527,	527,	527),
(105,	16,	43,	128,	1,	'2020-01-17 09:17:02',	'2020-01-17 09:18:54',	'2020-01-17 09:18:54',	527,	527,	527),
(106,	13,	43,	128,	4,	'2020-01-17 09:19:45',	'2020-01-17 09:26:47',	NULL,	527,	17,	NULL),
(107,	14,	43,	127,	4,	'2020-01-17 09:51:44',	'2020-01-17 09:57:16',	NULL,	527,	527,	NULL),
(108,	15,	54,	149,	4,	'2020-01-18 13:31:20',	'2020-01-18 13:49:49',	NULL,	527,	393,	NULL),
(109,	16,	56,	154,	4,	'2020-01-20 14:33:08',	'2020-01-20 14:50:30',	NULL,	539,	539,	NULL),
(110,	17,	57,	157,	4,	'2020-01-22 15:33:04',	'2020-01-23 11:08:12',	NULL,	539,	62,	NULL),
(111,	18,	58,	160,	4,	'2020-01-25 15:35:05',	'2020-01-25 15:52:33',	NULL,	527,	538,	NULL),
(112,	19,	58,	161,	2,	'2020-01-25 15:41:56',	'2020-01-25 15:42:39',	NULL,	527,	527,	NULL),
(113,	20,	60,	163,	2,	'2020-01-29 16:19:57',	'2020-01-29 16:20:31',	'2020-01-29 16:20:31',	8,	8,	8),
(114,	20,	60,	163,	1,	'2020-01-29 16:21:21',	'2020-01-29 16:21:28',	NULL,	8,	8,	NULL),
(115,	21,	61,	164,	4,	'2020-01-30 13:52:25',	'2020-01-31 08:50:38',	NULL,	527,	46,	NULL);

DROP TABLE IF EXISTS `audit_plan_audit_scopes`;
CREATE TABLE `audit_plan_audit_scopes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `audit_plan_id` int(10) unsigned NOT NULL,
  `audit_scope_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `audit_plan_audit_types`;
CREATE TABLE `audit_plan_audit_types` (
  `audit_plan_id` int(10) unsigned NOT NULL,
  `audit_type_id` int(10) unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `audit_plan_criterion`;
CREATE TABLE `audit_plan_criterion` (
  `audit_plan_id` int(10) unsigned NOT NULL,
  `audit_criterion_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`audit_plan_id`,`audit_criterion_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_plan_criterion` (`audit_plan_id`, `audit_criterion_id`) VALUES
(1,	33),
(1,	35),
(1,	37),
(2,	33),
(2,	35),
(2,	37),
(3,	33),
(3,	35),
(3,	37),
(4,	33),
(4,	35),
(4,	37),
(5,	27),
(6,	27),
(7,	33),
(7,	35),
(7,	37),
(8,	33),
(8,	35),
(8,	37),
(9,	33),
(9,	35),
(9,	37),
(10,	33),
(10,	35),
(10,	37),
(11,	33),
(11,	35),
(11,	37),
(12,	33),
(12,	35),
(12,	37),
(13,	33),
(13,	35),
(13,	37),
(14,	33),
(14,	35),
(14,	37),
(15,	33),
(15,	35),
(15,	37),
(16,	33),
(16,	35),
(16,	37),
(17,	33),
(17,	35),
(17,	37),
(18,	33),
(18,	35),
(18,	37),
(19,	33),
(19,	35),
(19,	37),
(20,	33),
(20,	35),
(20,	37),
(21,	31),
(21,	37),
(22,	31),
(22,	37),
(23,	31),
(23,	37),
(24,	31),
(24,	37),
(25,	31),
(25,	37),
(26,	31),
(26,	37),
(27,	31),
(27,	37),
(28,	31),
(28,	37),
(29,	31),
(29,	37),
(30,	31),
(30,	37),
(31,	31),
(31,	37),
(32,	31),
(32,	37),
(33,	31),
(33,	37),
(34,	31),
(34,	37),
(35,	31),
(35,	37),
(36,	31),
(36,	37),
(37,	31),
(37,	37),
(38,	31),
(38,	37),
(40,	23),
(41,	23),
(42,	3),
(45,	23),
(46,	31),
(47,	23),
(48,	27),
(50,	37),
(51,	23),
(51,	31),
(52,	3),
(62,	33),
(63,	23),
(63,	37),
(64,	33),
(69,	23),
(69,	31),
(70,	31),
(71,	3),
(71,	35),
(72,	3),
(72,	27),
(73,	35),
(74,	27),
(75,	27),
(76,	27),
(77,	27),
(77,	37),
(78,	27),
(78,	37),
(79,	27),
(79,	37),
(80,	27),
(80,	37),
(81,	27),
(81,	37),
(82,	27),
(84,	3),
(84,	27),
(85,	3),
(85,	27),
(86,	3),
(87,	23),
(89,	35),
(90,	35),
(91,	35),
(92,	35),
(93,	3),
(94,	3),
(94,	23),
(94,	35),
(98,	3),
(103,	33),
(104,	37),
(105,	3),
(106,	27),
(107,	27),
(108,	3),
(109,	3),
(115,	3),
(115,	27);

DROP TABLE IF EXISTS `audit_plan_details`;
CREATE TABLE `audit_plan_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `audit_plan_id` int(10) unsigned NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `opening_meeting_start_time` datetime DEFAULT NULL,
  `opening_meeting_end_time` datetime DEFAULT NULL,
  `closing_meeting_start_time` datetime DEFAULT NULL,
  `closing_meeting_end_time` datetime DEFAULT NULL,
  `opening_time` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `audit_party_id` int(11) DEFAULT NULL,
  `opening_end_time` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `closing_time` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `closing_end_time` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `objective` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1',
  `version` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'C',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_plan_details` (`id`, `audit_plan_id`, `start_date`, `end_date`, `opening_meeting_start_time`, `opening_meeting_end_time`, `closing_meeting_start_time`, `closing_meeting_end_time`, `opening_time`, `audit_party_id`, `opening_end_time`, `closing_time`, `closing_end_time`, `title`, `description`, `objective`, `created_at`, `updated_at`, `deleted_at`, `status`, `version`) VALUES
(1,	1,	'2018-12-16',	'2018-12-16',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Internal Audit 1 - 2018',	'All are requested to keep their documents updated and Schedule of Auditors & Auditees for the Internal Audit to be conducted is as under. ',	'',	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	1,	'C'),
(2,	2,	'2018-12-16',	'2018-12-16',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Internal Audit 2 - 2018',	'All are requested to keep their documents updated and Schedule of Auditors & Auditees for the Internal Audit to be conducted is as under. ',	'',	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	1,	'C'),
(3,	3,	'2018-12-16',	'2018-12-16',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Internal Audit 3 - 2018',	'All are requested to keep their documents updated and Schedule of Auditors & Auditees for the Internal Audit to be conducted is as under. ',	'',	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	1,	'C'),
(4,	4,	'2018-12-16',	'2018-12-16',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Internal Audit 4 - 2018',	'All are requested to keep their documents updated and Schedule of Auditors & Auditees for the Internal Audit to be conducted is as under. ',	'',	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	1,	'C'),
(5,	5,	'2018-12-16',	'2018-12-16',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Internal Audit 5 - 2018',	'All are requested to keep their documents updated and Schedule of Auditors & Auditees for the Internal Audit to be conducted is as under. ',	'',	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	1,	'C'),
(6,	6,	'2018-12-17',	'2018-12-17',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Internal Audit 6 - 2018',	'All are requested to keep their documents updated and Schedule of Auditors & Auditees for the Internal Audit to be conducted is as under. ',	'',	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	1,	'C'),
(7,	7,	'2018-12-17',	'2018-12-17',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Internal Audit 7 - 2018',	'All are requested to keep their documents updated and Schedule of Auditors & Auditees for the Internal Audit to be conducted is as under. ',	'',	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	1,	'C'),
(8,	8,	'2018-12-17',	'2018-12-17',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Internal Audit 8 - 2018',	'All are requested to keep their documents updated and Schedule of Auditors & Auditees for the Internal Audit to be conducted is as under. ',	'',	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	1,	'C'),
(9,	9,	'2018-12-17',	'2018-12-17',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Internal Audit 9 - 2018',	'All are requested to keep their documents updated and Schedule of Auditors & Auditees for the Internal Audit to be conducted is as under. ',	'',	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	1,	'C'),
(10,	10,	'2018-12-17',	'2018-12-17',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Internal Audit 10 - 2018',	'All are requested to keep their documents updated and Schedule of Auditors & Auditees for the Internal Audit to be conducted is as under. ',	'',	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	1,	'C'),
(11,	11,	'2018-12-18',	'2018-12-18',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Internal Audit 11 - 2018',	'All are requested to keep their documents updated and Schedule of Auditors & Auditees for the Internal Audit to be conducted is as under. ',	'',	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	1,	'C'),
(12,	12,	'2018-12-18',	'2018-12-18',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Internal Audit 12 - 2018',	'All are requested to keep their documents updated and Schedule of Auditors & Auditees for the Internal Audit to be conducted is as under. ',	'',	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	1,	'C'),
(13,	13,	'2018-12-18',	'2018-12-18',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Internal Audit 13 - 2018',	'All are requested to keep their documents updated and Schedule of Auditors & Auditees for the Internal Audit to be conducted is as under. ',	'',	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	1,	'C'),
(14,	14,	'2018-12-18',	'2018-12-18',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Internal Audit 14 - 2018',	'All are requested to keep their documents updated and Schedule of Auditors & Auditees for the Internal Audit to be conducted is as under. ',	'',	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	1,	'C'),
(15,	15,	'2018-12-18',	'2018-12-18',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Internal Audit 15 - 2018',	'All are requested to keep their documents updated and Schedule of Auditors & Auditees for the Internal Audit to be conducted is as under. ',	'',	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	1,	'C'),
(16,	16,	'2018-12-18',	'2018-12-18',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Internal Audit 16 - 2018',	'All are requested to keep their documents updated and Schedule of Auditors & Auditees for the Internal Audit to be conducted is as under. ',	'',	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	1,	'C'),
(17,	17,	'2018-12-19',	'2018-12-19',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Internal Audit 17 - 2018',	'All are requested to keep their documents updated and Schedule of Auditors & Auditees for the Internal Audit to be conducted is as under. ',	'',	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	1,	'C'),
(18,	18,	'2018-12-19',	'2018-12-19',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Internal Audit 18 - 2018',	'All are requested to keep their documents updated and Schedule of Auditors & Auditees for the Internal Audit to be conducted is as under. ',	'',	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	1,	'C'),
(19,	19,	'2018-12-19',	'2018-12-19',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Internal Audit 19 - 2018',	'All are requested to keep their documents updated and Schedule of Auditors & Auditees for the Internal Audit to be conducted is as under. ',	'',	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	1,	'C'),
(20,	20,	'2018-12-19',	'2018-12-19',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Internal Audit 20 - 2018',	'All are requested to keep their documents updated and Schedule of Auditors & Auditees for the Internal Audit to be conducted is as under. ',	'',	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	1,	'C'),
(21,	21,	'2017-04-30',	'2017-04-30',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Other Audit 1 -2017',	'All are requested to keep their documents updated and Schedule of Auditors & Auditees for the Internal Audit to be conducted is as under.',	'',	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	1,	'C'),
(22,	22,	'2017-05-02',	'2017-05-02',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Other Audit 2 -2017',	'All are requested to keep their documents updated and Schedule of Auditors & Auditees for the Internal Audit to be conducted is as under.',	'',	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	1,	'C'),
(23,	23,	'2017-05-02',	'2017-05-02',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Other Audit 3 -2017',	'All are requested to keep their documents updated and Schedule of Auditors & Auditees for the Internal Audit to be conducted is as under.',	'',	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	1,	'C'),
(24,	24,	'2017-04-30',	'2017-04-30',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Other Audit 4 -2017',	'All are requested to keep their documents updated and Schedule of Auditors & Auditees for the Internal Audit to be conducted is as under.',	'',	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	1,	'C'),
(25,	25,	'2017-05-01',	'2017-05-01',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Other Audit 5 -2017',	'All are requested to keep their documents updated and Schedule of Auditors & Auditees for the Internal Audit to be conducted is as under.',	'',	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	1,	'C'),
(26,	26,	'2017-04-30',	'2017-04-30',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Other Audit 6 -2017',	'All are requested to keep their documents updated and Schedule of Auditors & Auditees for the Internal Audit to be conducted is as under.',	'',	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	1,	'C'),
(27,	27,	'2017-05-01',	'2017-05-01',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Other Audit 7 -2017',	'All are requested to keep their documents updated and Schedule of Auditors & Auditees for the Internal Audit to be conducted is as under.',	'',	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	1,	'C'),
(28,	28,	'2017-04-30',	'2017-04-30',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Other Audit 8 -2017',	'All are requested to keep their documents updated and Schedule of Auditors & Auditees for the Internal Audit to be conducted is as under.',	'',	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	1,	'C'),
(29,	29,	'2017-05-01',	'2017-05-01',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Other Audit 9 -2017',	'All are requested to keep their documents updated and Schedule of Auditors & Auditees for the Internal Audit to be conducted is as under.',	'',	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	1,	'C'),
(30,	30,	'2017-05-01',	'2017-05-01',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Other Audit 10 -2017',	'All are requested to keep their documents updated and Schedule of Auditors & Auditees for the Internal Audit to be conducted is as under.',	'',	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	1,	'C'),
(31,	31,	'2017-05-01',	'2017-05-01',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Other Audit 11 -2017',	'All are requested to keep their documents updated and Schedule of Auditors & Auditees for the Internal Audit to be conducted is as under.',	'',	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	1,	'C'),
(32,	32,	'2017-05-01',	'2017-05-01',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Other Audit 12 -2017',	'All are requested to keep their documents updated and Schedule of Auditors & Auditees for the Internal Audit to be conducted is as under.',	'',	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	1,	'C'),
(33,	33,	'2017-05-01',	'2017-05-01',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Other Audit 13 -2017',	'All are requested to keep their documents updated and Schedule of Auditors & Auditees for the Internal Audit to be conducted is as under.',	'',	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	1,	'C'),
(34,	34,	'2017-05-02',	'2017-05-02',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Other Audit 14 -2017',	'All are requested to keep their documents updated and Schedule of Auditors & Auditees for the Internal Audit to be conducted is as under.',	'',	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	1,	'C'),
(35,	35,	'2017-05-02',	'2017-05-02',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Other Audit 15 -2017',	'All are requested to keep their documents updated and Schedule of Auditors & Auditees for the Internal Audit to be conducted is as under.',	'',	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	1,	'C'),
(36,	36,	'2017-05-02',	'2017-05-02',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Other Audit 16 -2017',	'All are requested to keep their documents updated and Schedule of Auditors & Auditees for the Internal Audit to be conducted is as under.',	'',	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	1,	'C'),
(37,	37,	'2017-05-02',	'2017-05-02',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Other Audit 17 -2017',	'All are requested to keep their documents updated and Schedule of Auditors & Auditees for the Internal Audit to be conducted is as under.',	'',	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	1,	'C'),
(38,	38,	'2017-05-02',	'2017-05-02',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Other Audit 18 -2017',	'All are requested to keep their documents updated and Schedule of Auditors & Auditees for the Internal Audit to be conducted is as under.',	'',	'2019-12-12 13:14:38',	'2019-12-12 13:14:38',	NULL,	1,	'C'),
(39,	39,	'2019-12-01',	'2019-12-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'TEST',	NULL,	'',	'2019-12-17 14:57:01',	'2019-12-17 14:57:01',	NULL,	1,	'C'),
(40,	40,	'2019-12-01',	'2019-12-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Technical audit',	NULL,	'',	'2019-12-18 10:27:50',	'2019-12-18 10:27:50',	NULL,	1,	'C'),
(41,	41,	'2019-10-01',	'2019-10-10',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Test adit by jeeva',	'test description',	'',	'2019-12-20 08:52:16',	'2019-12-20 08:55:44',	NULL,	1,	'C'),
(42,	42,	'2019-11-06',	'2019-11-15',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Test audit jeeva',	NULL,	'',	'2019-12-20 13:11:46',	'2019-12-20 13:50:53',	NULL,	1,	'C'),
(45,	45,	'2019-01-01',	'2019-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'ims plan -1',	NULL,	'',	'2019-12-21 14:08:25',	'2019-12-21 14:08:25',	NULL,	1,	'C'),
(46,	46,	'2019-02-01',	'2019-02-28',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'ssc',	NULL,	'',	'2019-12-21 14:14:57',	'2019-12-21 14:14:57',	NULL,	1,	'C'),
(47,	47,	'2019-10-01',	'2019-10-01',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'IMS audit',	NULL,	'',	'2019-12-23 09:49:52',	'2019-12-23 09:49:52',	NULL,	1,	'C'),
(48,	48,	'2019-11-07',	'2019-11-08',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'IMS audit',	NULL,	'',	'2019-12-23 10:05:44',	'2019-12-23 10:05:44',	NULL,	1,	'C'),
(49,	49,	'2019-12-01',	'2019-12-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'test auto published',	NULL,	'',	'2019-12-23 11:31:44',	'2019-12-23 11:31:44',	NULL,	1,	'C'),
(50,	50,	'2019-12-01',	'2019-12-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Audit cate test',	NULL,	'',	'2019-12-23 13:33:28',	'2019-12-23 13:33:28',	NULL,	1,	'C'),
(51,	51,	'2019-12-01',	'2019-12-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'tra server issue',	NULL,	'',	'2019-12-24 10:39:35',	'2019-12-24 10:39:35',	NULL,	1,	'C'),
(52,	52,	'2020-01-01',	'2020-01-16',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'IA 2019 August',	'Test description',	'',	'2019-12-30 08:40:34',	'2019-12-30 09:07:37',	NULL,	1,	'C'),
(53,	53,	'2019-02-01',	'2019-02-28',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'IA2020',	NULL,	'',	'2019-12-30 10:13:03',	'2019-12-30 10:14:57',	NULL,	1,	'C'),
(54,	54,	'2019-05-01',	'2019-05-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'save function',	NULL,	'',	'2019-12-30 11:05:40',	'2019-12-30 11:05:40',	NULL,	1,	'C'),
(55,	57,	'2019-05-01',	'2019-05-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'save',	NULL,	'',	'2019-12-30 11:39:43',	'2019-12-30 11:39:43',	NULL,	1,	'C'),
(56,	58,	'2019-05-01',	'2019-05-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'save',	NULL,	'',	'2019-12-30 11:41:01',	'2019-12-30 11:41:01',	NULL,	1,	'C'),
(57,	59,	'2019-02-01',	'2019-02-28',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'test',	NULL,	'',	'2019-12-30 12:53:23',	'2019-12-30 12:53:23',	NULL,	1,	'C'),
(58,	60,	'2019-02-01',	'2019-02-28',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'NMN',	NULL,	'',	'2019-12-30 13:31:18',	'2019-12-30 13:31:18',	NULL,	1,	'C'),
(59,	61,	'2019-12-01',	'2019-12-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'tEST JEEVA',	NULL,	'',	'2019-12-30 13:45:20',	'2019-12-30 13:47:04',	NULL,	1,	'O'),
(60,	61,	'2019-12-01',	'2019-12-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'tEST JEEVA',	NULL,	'',	'2019-12-30 13:47:04',	'2019-12-30 13:47:04',	NULL,	1,	'C'),
(61,	62,	'2020-02-01',	'2020-02-28',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Test 3',	'Lorem ipsum, or lipsum as it is sometimes known, is dummy text used in laying out print, graphic or web designs',	'',	'2019-12-31 09:36:21',	'2019-12-31 09:36:21',	NULL,	1,	'C'),
(62,	63,	'2020-01-01',	'2020-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'checking DB Notification',	NULL,	'',	'2020-01-01 12:11:36',	'2020-01-01 12:11:36',	NULL,	1,	'C'),
(63,	64,	'2020-01-06',	'2020-01-15',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Other Audit',	NULL,	'',	'2020-01-03 09:35:35',	'2020-01-03 09:37:05',	NULL,	1,	'C'),
(64,	65,	'2020-01-03',	'2020-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Test',	NULL,	'',	'2020-01-03 10:03:41',	'2020-01-03 10:23:29',	NULL,	1,	'C'),
(66,	67,	'2019-12-03',	'2019-12-02',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Anwar test',	NULL,	'',	'2020-01-03 10:46:49',	'2020-01-03 10:46:49',	NULL,	1,	'C'),
(67,	68,	'2020-01-01',	'2020-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Test',	NULL,	'',	'2020-01-03 12:38:11',	'2020-01-03 12:38:11',	NULL,	1,	'C'),
(68,	69,	'2019-01-01',	'2019-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'test',	NULL,	'',	'2020-01-04 08:47:53',	'2020-01-04 08:49:20',	NULL,	1,	'O'),
(69,	69,	'2019-01-01',	'2019-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'test1',	NULL,	'',	'2020-01-04 08:48:08',	'2020-01-04 08:49:20',	NULL,	1,	'O'),
(70,	69,	'2019-01-01',	'2019-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'test1',	NULL,	'',	'2020-01-04 08:48:31',	'2020-01-04 08:49:20',	NULL,	1,	'O'),
(71,	69,	'2019-01-01',	'2019-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'test1',	NULL,	'',	'2020-01-04 08:49:20',	'2020-01-04 09:01:00',	NULL,	1,	'C'),
(72,	70,	'2018-01-01',	'2018-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'checking condition',	'test description',	'',	'2020-01-06 09:56:14',	'2020-01-06 09:56:14',	NULL,	1,	'C'),
(73,	71,	'2018-01-01',	'2018-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'sawad issue',	NULL,	'',	'2020-01-06 13:22:21',	'2020-01-06 13:42:58',	NULL,	1,	'O'),
(74,	71,	'2018-01-01',	'2018-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'sawad issue',	NULL,	'',	'2020-01-06 13:22:55',	'2020-01-06 13:42:58',	NULL,	1,	'O'),
(75,	71,	'2018-01-01',	'2018-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'sawad issue',	NULL,	'',	'2020-01-06 13:41:56',	'2020-01-06 13:42:58',	NULL,	1,	'O'),
(76,	71,	'2018-01-01',	'2018-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'sawad issue',	NULL,	'',	'2020-01-06 13:42:24',	'2020-01-06 13:42:58',	NULL,	1,	'O'),
(77,	71,	'2018-01-01',	'2018-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'sawad issue',	NULL,	'',	'2020-01-06 13:42:58',	'2020-01-06 13:43:23',	NULL,	1,	'C'),
(78,	72,	'2019-11-01',	'2019-11-30',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'sawadddddd save& publish issue',	NULL,	'',	'2020-01-06 16:07:21',	'2020-01-06 16:07:21',	NULL,	1,	'C'),
(79,	73,	'2020-01-07',	'2020-01-07',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'test audit',	'description',	'',	'2020-01-07 08:50:52',	'2020-01-07 08:50:52',	NULL,	1,	'C'),
(80,	74,	'2020-01-01',	'2020-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'notification plan',	'Test description',	'',	'2020-01-07 12:41:53',	'2020-01-07 12:41:53',	NULL,	1,	'C'),
(81,	75,	'2020-01-01',	'2020-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'notification plan',	'Test description',	'',	'2020-01-07 12:41:58',	'2020-01-07 12:41:58',	NULL,	1,	'C'),
(82,	76,	'2020-01-01',	'2020-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'notification plan',	'Test description',	'',	'2020-01-07 12:42:03',	'2020-01-07 12:43:24',	NULL,	1,	'O'),
(83,	76,	'2020-01-01',	'2020-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'notification plan',	'Test description',	'',	'2020-01-07 12:43:24',	'2020-01-07 12:43:24',	NULL,	1,	'C'),
(84,	77,	'2020-01-01',	'2020-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'notification issueee checkingg',	NULL,	'',	'2020-01-07 12:44:45',	'2020-01-07 12:44:46',	NULL,	1,	'O'),
(85,	78,	'2020-01-01',	'2020-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'notification issueee checkingg',	NULL,	'',	'2020-01-07 12:44:46',	'2020-01-07 12:44:46',	NULL,	1,	'O'),
(86,	79,	'2020-01-01',	'2020-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'notification issueee checkingg',	NULL,	'',	'2020-01-07 12:44:46',	'2020-01-07 12:44:46',	NULL,	1,	'C'),
(87,	80,	'2020-01-01',	'2020-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'notification issueee checkingg',	NULL,	'',	'2020-01-07 12:44:46',	'2020-01-07 12:44:46',	NULL,	1,	'O'),
(88,	81,	'2020-01-01',	'2020-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'notification issueee checkingg',	NULL,	'',	'2020-01-07 12:44:46',	'2020-01-07 12:44:46',	NULL,	1,	'C'),
(89,	77,	'2020-01-01',	'2020-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'notification issueee checkingg',	NULL,	'',	'2020-01-07 12:44:46',	'2020-01-07 12:44:46',	NULL,	1,	'C'),
(90,	78,	'2020-01-01',	'2020-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'notification issueee checkingg',	NULL,	'',	'2020-01-07 12:44:46',	'2020-01-07 12:44:46',	NULL,	1,	'C'),
(91,	80,	'2020-01-01',	'2020-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'notification issueee checkingg',	NULL,	'',	'2020-01-07 12:44:46',	'2020-01-07 12:44:46',	NULL,	1,	'C'),
(92,	82,	'2020-01-01',	'2020-01-03',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'notification issue checkingfgg',	NULL,	'',	'2020-01-07 12:48:08',	'2020-01-07 12:49:08',	NULL,	1,	'O'),
(93,	82,	'2020-01-01',	'2020-01-03',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'notification issue checkingfgg',	NULL,	'',	'2020-01-07 12:49:08',	'2020-01-07 12:49:08',	NULL,	1,	'C'),
(94,	83,	'2020-01-01',	'2020-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'second testingg',	NULL,	'',	'2020-01-07 13:22:39',	'2020-01-07 13:22:39',	NULL,	1,	'C'),
(95,	84,	'2020-02-01',	'2020-02-28',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'internal audit 8/1/2020',	'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum',	'',	'2020-01-08 09:12:41',	'2020-01-08 09:12:41',	NULL,	1,	'C'),
(96,	85,	'2020-02-01',	'2020-02-28',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'internal audit 8/1/2020',	'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum',	'',	'2020-01-08 09:12:49',	'2020-01-08 09:12:49',	NULL,	1,	'C'),
(97,	86,	'2020-02-01',	'2020-02-28',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'internal audit 8/1/2020',	'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum',	'',	'2020-01-08 09:13:54',	'2020-01-08 09:15:58',	NULL,	1,	'O'),
(98,	86,	'2020-02-01',	'2020-02-28',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'internal audit 8/1/2020',	'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum',	'',	'2020-01-08 09:15:18',	'2020-01-08 09:15:58',	NULL,	1,	'O'),
(99,	86,	'2020-02-01',	'2020-02-28',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'internal audit 8/1/2020',	'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum',	'',	'2020-01-08 09:15:58',	'2020-01-08 09:15:58',	NULL,	1,	'C'),
(100,	87,	'2020-02-01',	'2020-02-28',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'test title',	NULL,	'',	'2020-01-08 17:03:45',	'2020-01-08 17:06:45',	NULL,	1,	'C'),
(101,	88,	'2020-03-01',	'2020-03-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'testtt',	NULL,	'',	'2020-01-08 17:11:08',	'2020-01-22 09:42:43',	NULL,	1,	'O'),
(102,	89,	'2020-03-01',	'2020-03-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'title',	'tut8ut7i789o7908098test ytest',	'',	'2020-01-08 17:14:06',	'2020-01-08 17:14:06',	NULL,	1,	'C'),
(103,	103,	'2020-01-01',	'2020-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'abcd',	'abcdefg',	'',	'2020-01-08 17:14:07',	'2020-01-17 09:12:11',	NULL,	1,	'O'),
(104,	104,	'2020-01-01',	'2020-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'basith',	'hello world',	'',	'2020-01-08 17:14:08',	'2020-01-17 09:15:50',	NULL,	1,	'C'),
(105,	105,	'2020-01-01',	'2020-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'dsh',	'sfhat',	'',	'2020-01-08 17:14:08',	'2020-01-17 09:18:09',	NULL,	1,	'C'),
(106,	93,	'2012-01-01',	'2012-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'checking rashed issue',	'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum',	'',	'2020-01-09 08:44:12',	'2020-01-09 08:45:55',	NULL,	1,	'O'),
(107,	107,	'2020-01-01',	'2020-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'rtshrt',	'hrt',	'',	'2020-01-09 08:45:51',	'2020-01-17 09:52:16',	NULL,	1,	'C'),
(108,	108,	'2020-05-01',	'2020-05-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'checking audit flow',	'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum',	'',	'2020-01-09 08:51:26',	'2020-01-18 13:31:24',	NULL,	1,	'C'),
(109,	109,	'2020-01-01',	'2020-01-15',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'test',	NULL,	'',	'2020-01-09 11:01:40',	'2020-01-20 14:33:15',	NULL,	1,	'C'),
(110,	96,	'2010-01-01',	'2010-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'karin donetti plsn',	NULL,	'',	'2020-01-09 12:36:26',	'2020-01-09 12:36:26',	NULL,	1,	'C'),
(111,	97,	'2010-04-01',	'2010-04-30',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'saif soubb',	NULL,	'',	'2020-01-09 12:41:18',	'2020-01-09 12:41:18',	NULL,	1,	'C'),
(112,	98,	'2022-01-01',	'2022-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'An ISO 9001 audit checklist is a useful tool to ensure that nothing is missed when reviewing process records in order to confirm requirements are met',	NULL,	'',	'2020-01-10 09:11:12',	'2020-01-10 09:13:08',	NULL,	1,	'O'),
(113,	98,	'2022-01-08',	'2022-01-15',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'An ISO 9001 audit checklist is a useful tool to ensure that nothing is missed when reviewing process records in order to confirm requirements are met',	NULL,	'',	'2020-01-10 09:11:49',	'2020-01-10 09:13:08',	NULL,	1,	'O'),
(114,	114,	'2020-01-30',	'2020-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'test audit',	NULL,	'',	'2020-01-10 09:13:08',	'2020-01-29 16:21:28',	NULL,	1,	'C'),
(115,	99,	'2032-01-01',	'2032-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'testttttttttttt16',	NULL,	'',	'2020-01-16 09:18:27',	'2020-01-16 09:18:27',	NULL,	1,	'C'),
(116,	100,	'2032-01-01',	'2032-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'testttttttttttt16',	NULL,	'',	'2020-01-16 09:18:36',	'2020-01-16 09:18:36',	NULL,	1,	'C'),
(117,	101,	'2035-01-01',	'2035-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'jeevas plan by sawad',	NULL,	'',	'2020-01-16 10:00:29',	'2020-01-16 10:00:29',	NULL,	1,	'C'),
(118,	102,	'2036-03-01',	'2036-03-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'jeeva test plan notiification',	NULL,	'',	'2020-01-16 10:28:44',	'2020-01-16 10:28:44',	NULL,	1,	'C'),
(119,	103,	'2020-01-01',	'2020-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'abcd',	'abcdefg',	'',	'2020-01-17 09:09:44',	'2020-01-17 09:12:11',	NULL,	1,	'O'),
(120,	103,	'2020-01-01',	'2020-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'abcd',	'abcdefg',	'',	'2020-01-17 09:10:47',	'2020-01-17 09:12:11',	NULL,	1,	'O'),
(121,	103,	'2020-01-01',	'2020-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'abcd',	'abcdefg',	'',	'2020-01-17 09:10:50',	'2020-01-17 09:12:11',	NULL,	1,	'O'),
(122,	103,	'2020-01-01',	'2020-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'abcd',	'abcdefg',	'',	'2020-01-17 09:11:00',	'2020-01-17 09:12:11',	NULL,	1,	'O'),
(123,	103,	'2020-01-01',	'2020-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'abcd',	'abcdefg',	'',	'2020-01-17 09:12:11',	'2020-01-17 09:12:11',	NULL,	1,	'C'),
(124,	104,	'2020-01-01',	'2020-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'basith',	'hello world',	'',	'2020-01-17 09:14:18',	'2020-01-17 09:14:18',	NULL,	1,	'C'),
(125,	105,	'2020-01-01',	'2020-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'dsh',	'sfhat',	'',	'2020-01-17 09:17:02',	'2020-01-17 09:17:02',	NULL,	1,	'C'),
(126,	106,	'2020-01-01',	'2020-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'ASdasergs',	'dfgrddtn',	'',	'2020-01-17 09:19:45',	'2020-01-17 09:20:34',	NULL,	1,	'C'),
(127,	107,	'2020-01-01',	'2020-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'rtshrt',	'hrt',	'',	'2020-01-17 09:51:44',	'2020-01-17 09:51:44',	NULL,	1,	'C'),
(128,	108,	'2020-05-01',	'2020-05-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'checking audit flow',	'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum',	'',	'2020-01-18 13:31:20',	'2020-01-18 13:31:20',	NULL,	1,	'C'),
(129,	109,	'2020-01-01',	'2020-01-15',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'test',	NULL,	'',	'2020-01-20 14:33:08',	'2020-01-20 14:33:08',	NULL,	1,	'C'),
(130,	88,	'2020-03-01',	'2020-03-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'testtt',	NULL,	'',	'2020-01-21 15:32:33',	'2020-01-22 09:42:43',	NULL,	1,	'O'),
(131,	88,	'2020-03-01',	'2020-03-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'testtt',	NULL,	'',	'2020-01-22 09:42:43',	'2020-01-22 09:42:43',	NULL,	1,	'C'),
(132,	110,	'2020-03-01',	'2020-03-17',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'testing filter',	NULL,	'',	'2020-01-22 15:33:04',	'2020-01-22 15:33:04',	NULL,	1,	'C'),
(133,	111,	'2020-06-01',	'2020-06-30',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'tax audit',	NULL,	'',	'2020-01-25 15:35:05',	'2020-01-25 15:41:03',	NULL,	1,	'O'),
(134,	111,	'2020-06-01',	'2020-06-30',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'tax audit',	NULL,	'',	'2020-01-25 15:36:23',	'2020-01-25 15:41:03',	NULL,	1,	'O'),
(135,	111,	'2020-06-30',	'2020-06-30',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'tax audit',	NULL,	'',	'2020-01-25 15:41:03',	'2020-01-25 15:41:03',	NULL,	1,	'C'),
(136,	112,	'2020-06-01',	'2020-06-30',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'jan25',	NULL,	'',	'2020-01-25 15:41:56',	'2020-01-25 15:41:56',	NULL,	1,	'C'),
(137,	113,	'2020-01-30',	'2020-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'test audit',	NULL,	'',	'2020-01-29 16:19:57',	'2020-01-29 16:20:22',	NULL,	1,	'C'),
(138,	114,	'2020-01-30',	'2020-01-31',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'test audit',	NULL,	'',	'2020-01-29 16:21:21',	'2020-01-29 16:21:21',	NULL,	1,	'C'),
(139,	115,	'2020-03-13',	'2020-03-24',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Special audit',	'Test description',	'',	'2020-01-30 13:52:25',	'2020-01-30 13:57:22',	NULL,	1,	'O'),
(140,	115,	'2020-03-13',	'2020-03-24',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Special audit',	'Test description',	'',	'2020-01-30 13:56:23',	'2020-01-30 13:57:17',	NULL,	1,	'O'),
(141,	115,	'2020-03-13',	'2020-03-24',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	'0000-00-00 00:00:00',	NULL,	0,	NULL,	NULL,	NULL,	'Special audit',	'Test description',	'',	'2020-01-30 13:57:17',	'2020-01-30 13:57:17',	NULL,	1,	'C');

DROP TABLE IF EXISTS `audit_plan_objectives`;
CREATE TABLE `audit_plan_objectives` (
  `audit_plan_id` int(10) unsigned NOT NULL,
  `audit_objective_id` int(10) unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_plan_objectives` (`audit_plan_id`, `audit_objective_id`) VALUES
(1,	23),
(1,	29),
(1,	27),
(2,	23),
(2,	29),
(2,	27),
(3,	23),
(3,	29),
(3,	27),
(4,	23),
(4,	29),
(4,	27),
(5,	21),
(6,	21),
(7,	23),
(7,	29),
(7,	27),
(8,	23),
(8,	29),
(8,	27),
(9,	23),
(9,	29),
(9,	27),
(10,	23),
(10,	29),
(10,	27),
(11,	23),
(11,	29),
(11,	27),
(12,	23),
(12,	29),
(12,	27),
(13,	23),
(13,	29),
(13,	27),
(14,	23),
(14,	29),
(14,	27),
(15,	23),
(15,	29),
(15,	27),
(16,	23),
(16,	29),
(16,	27),
(17,	23),
(17,	29),
(17,	27),
(18,	23),
(18,	29),
(18,	27),
(19,	23),
(19,	29),
(19,	27),
(20,	23),
(20,	29),
(20,	27),
(21,	23),
(21,	25),
(22,	23),
(22,	25),
(23,	23),
(23,	25),
(24,	23),
(24,	25),
(25,	23),
(25,	25),
(26,	23),
(26,	25),
(27,	23),
(27,	25),
(28,	23),
(28,	25),
(29,	23),
(29,	25),
(30,	23),
(30,	25),
(31,	23),
(31,	25),
(32,	23),
(32,	25),
(33,	23),
(33,	25),
(34,	23),
(34,	25),
(35,	23),
(35,	25),
(36,	23),
(36,	25),
(37,	23),
(37,	25),
(38,	23),
(38,	25),
(40,	1),
(41,	20),
(42,	29),
(45,	20),
(46,	20),
(46,	29),
(47,	25),
(48,	20),
(50,	20),
(51,	23),
(52,	20),
(62,	20),
(63,	20),
(63,	1),
(64,	20),
(69,	20),
(69,	1),
(70,	20),
(71,	20),
(71,	1),
(72,	29),
(73,	20),
(74,	25),
(75,	25),
(76,	25),
(79,	25),
(79,	23),
(81,	25),
(81,	23),
(77,	25),
(77,	23),
(78,	25),
(78,	23),
(80,	25),
(80,	23),
(82,	23),
(84,	20),
(84,	1),
(85,	20),
(85,	1),
(86,	21),
(87,	29),
(89,	19),
(90,	19),
(92,	19),
(91,	19),
(93,	27),
(93,	19),
(94,	19),
(94,	20),
(94,	29),
(98,	20),
(103,	23),
(104,	23),
(105,	27),
(105,	23),
(106,	27),
(107,	21),
(108,	1),
(108,	20),
(109,	20),
(115,	27),
(115,	21);

DROP TABLE IF EXISTS `audit_plan_statuses`;
CREATE TABLE `audit_plan_statuses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_draft` tinyint(1) NOT NULL DEFAULT '0',
  `is_new` tinyint(1) NOT NULL DEFAULT '0',
  `is_accepted` tinyint(1) NOT NULL DEFAULT '0',
  `is_audited` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `updated_by` int(10) unsigned DEFAULT NULL,
  `deleted_by` int(10) unsigned DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_plan_statuses` (`id`, `title`, `label`, `is_draft`, `is_new`, `is_accepted`, `is_audited`, `created_at`, `updated_at`, `deleted_at`, `created_by`, `updated_by`, `deleted_by`, `status`) VALUES
(1,	'Draft',	'default',	1,	0,	0,	0,	'2018-10-03 14:29:19',	'2018-10-03 14:29:19',	NULL,	1,	NULL,	NULL,	1),
(2,	'New',	'primary',	0,	1,	0,	0,	'2018-10-03 14:29:19',	'2018-10-03 14:29:19',	NULL,	1,	NULL,	NULL,	1),
(3,	'Accepted',	'success',	0,	0,	1,	0,	'2018-10-03 14:29:19',	'2018-10-03 14:29:19',	NULL,	1,	NULL,	NULL,	1),
(4,	'Audited',	'warning',	0,	0,	0,	1,	'2018-10-03 14:29:19',	'2018-10-03 14:29:19',	NULL,	1,	NULL,	NULL,	1);

DROP TABLE IF EXISTS `audit_pre_plans`;
CREATE TABLE `audit_pre_plans` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `audit_program_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `department_id` int(11) DEFAULT NULL,
  `date` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `audit_pre_plan_status_id` int(10) unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_pre_plans` (`id`, `audit_program_id`, `user_id`, `department_id`, `date`, `audit_pre_plan_status_id`, `title`, `created_at`, `updated_at`) VALUES
(1,	1,	53,	5,	'Dec 2018',	3,	'Internal Audit 1 - 2018',	'2019-12-12 13:14:05',	'2019-12-12 13:14:05'),
(2,	1,	53,	14,	'Dec 2018',	3,	'Internal Audit 2 - 2018',	'2019-12-12 13:14:05',	'2019-12-12 13:14:05'),
(3,	1,	89,	13,	'Dec 2018',	3,	'Internal Audit 3 - 2018',	'2019-12-12 13:14:05',	'2019-12-12 13:14:05'),
(4,	1,	89,	13,	'Dec 2018',	3,	'Internal Audit 4 - 2018',	'2019-12-12 13:14:05',	'2019-12-12 13:14:05'),
(5,	1,	71,	4,	'Dec 2018',	3,	'Internal Audit 5 - 2018',	'2019-12-12 13:14:05',	'2019-12-12 13:14:05'),
(6,	1,	71,	4,	'Dec 2018',	3,	'Internal Audit 6 - 2018',	'2019-12-12 13:14:05',	'2019-12-12 13:14:05'),
(7,	1,	8,	11,	'Dec 2018',	3,	'Internal Audit 7 - 2018',	'2019-12-12 13:14:05',	'2019-12-12 13:14:05'),
(8,	1,	8,	10,	'Dec 2018',	3,	'Internal Audit 8 - 2018',	'2019-12-12 13:14:05',	'2019-12-12 13:14:05'),
(9,	1,	66,	18,	'Dec 2018',	3,	'Internal Audit 9 - 2018',	'2019-12-12 13:14:05',	'2019-12-12 13:14:05'),
(10,	1,	22,	8,	'Dec 2018',	3,	'Internal Audit 10 - 2018',	'2019-12-12 13:14:05',	'2019-12-12 13:14:05'),
(11,	1,	22,	9,	'Dec 2018',	3,	'Internal Audit 11 - 2018',	'2019-12-12 13:14:05',	'2019-12-12 13:14:05'),
(12,	1,	22,	7,	'Dec 2018',	3,	'Internal Audit 12 - 2018',	'2019-12-12 13:14:05',	'2019-12-12 13:14:05'),
(13,	1,	66,	16,	'Dec 2018',	3,	'Internal Audit 13 - 2018',	'2019-12-12 13:14:05',	'2019-12-12 13:14:05'),
(14,	1,	89,	14,	'Dec 2018',	3,	'Internal Audit 14 - 2018',	'2019-12-12 13:14:05',	'2019-12-12 13:14:05'),
(15,	1,	66,	15,	'Dec 2018',	3,	'Internal Audit 15 - 2018',	'2019-12-12 13:14:05',	'2019-12-12 13:14:05'),
(16,	1,	42,	12,	'Dec 2018',	3,	'Internal Audit 16 - 2018',	'2019-12-12 13:14:05',	'2019-12-12 13:14:05'),
(17,	1,	42,	12,	'Dec 2018',	3,	'Internal Audit 17 - 2018',	'2019-12-12 13:14:05',	'2019-12-12 13:14:05'),
(18,	1,	42,	12,	'Dec 2018',	3,	'Internal Audit 18 - 2018',	'2019-12-12 13:14:05',	'2019-12-12 13:14:05'),
(19,	1,	53,	6,	'Dec 2018',	3,	'Internal Audit 19 - 2018',	'2019-12-12 13:14:05',	'2019-12-12 13:14:05'),
(20,	1,	71,	2,	'Dec 2018',	3,	'Internal Audit 20 - 2018',	'2019-12-12 13:14:05',	'2019-12-12 13:14:05'),
(21,	2,	53,	5,	'Apr 2017',	3,	'Other Audit 1 -2017',	'2019-12-12 13:14:05',	'2019-12-12 13:14:05'),
(22,	2,	20,	13,	'May 2017',	3,	'Other Audit 2 -2017',	'2019-12-12 13:14:05',	'2019-12-12 13:14:05'),
(23,	2,	20,	13,	'May 2017',	3,	'Other Audit 3 -2017',	'2019-12-12 13:14:05',	'2019-12-12 13:14:05'),
(24,	2,	71,	4,	'Apr 2017',	3,	'Other Audit 4 -2017',	'2019-12-12 13:14:05',	'2019-12-12 13:14:05'),
(25,	2,	71,	4,	'Apr 2017',	3,	'Other Audit 5 -2017',	'2019-12-12 13:14:05',	'2019-12-12 13:14:05'),
(26,	2,	42,	11,	'Apr 2017',	3,	'Other Audit 6 -2017',	'2019-12-12 13:14:05',	'2019-12-12 13:14:05'),
(27,	2,	42,	10,	'May 2017',	3,	'Other Audit 7 -2017',	'2019-12-12 13:14:05',	'2019-12-12 13:14:05'),
(28,	2,	42,	18,	'Apr 2017',	3,	'Other Audit 8 -2017',	'2019-12-12 13:14:05',	'2019-12-12 13:14:05'),
(29,	2,	66,	8,	'May 2017',	3,	'Other Audit 9 -2017',	'2019-12-12 13:14:05',	'2019-12-12 13:14:05'),
(30,	2,	22,	9,	'May 2017',	3,	'Other Audit 10 -2017',	'2019-12-12 13:14:05',	'2019-12-12 13:14:05'),
(31,	2,	22,	7,	'May 2017',	3,	'Other Audit 11 -2017',	'2019-12-12 13:14:05',	'2019-12-12 13:14:05'),
(32,	2,	71,	16,	'May 2017',	3,	'Other Audit 12 -2017',	'2019-12-12 13:14:05',	'2019-12-12 13:14:05'),
(33,	2,	89,	14,	'May 2017',	3,	'Other Audit 13 -2017',	'2019-12-12 13:14:05',	'2019-12-12 13:14:05'),
(34,	2,	66,	15,	'May 2017',	3,	'Other Audit 14 -2017',	'2019-12-12 13:14:05',	'2019-12-12 13:14:05'),
(35,	2,	8,	12,	'May 2017',	3,	'Other Audit 15 -2017',	'2019-12-12 13:14:05',	'2019-12-12 13:14:05'),
(36,	2,	8,	12,	'May 2017',	3,	'Other Audit 16 -2017',	'2019-12-12 13:14:05',	'2019-12-12 13:14:05'),
(37,	2,	8,	12,	'May 2017',	3,	'Other Audit 17 -2017',	'2019-12-12 13:14:05',	'2019-12-12 13:14:05'),
(38,	2,	89,	2,	'May 2017',	3,	'Other Audit 18 -2017',	'2019-12-12 13:14:05',	'2019-12-12 13:14:05'),
(39,	3,	101,	1,	'Dec 2019',	3,	'Performance Audit-1',	'2019-12-17 14:45:31',	'2019-12-17 14:58:22'),
(40,	4,	101,	13,	'Dec 2019',	3,	'Technical Audit-1',	'2019-12-18 10:26:24',	'2019-12-18 10:32:02'),
(41,	4,	101,	13,	'Feb 2020',	1,	'Technical Audit-2',	'2019-12-18 10:26:24',	'2019-12-18 10:26:24'),
(46,	7,	101,	4,	'Oct 2019',	3,	'Legal Audit-1',	'2019-12-19 15:46:20',	'2019-12-20 08:58:15'),
(47,	7,	101,	4,	'Nov 2019',	2,	'Legal Audit-2',	'2019-12-19 15:46:20',	'2020-01-06 16:07:21'),
(48,	7,	101,	4,	'Dec 2019',	1,	'Legal Audit-3',	'2019-12-20 12:39:56',	'2019-12-20 12:39:56'),
(49,	8,	101,	4,	'Dec 2020',	1,	'Performance Audit-1',	'2019-12-20 13:15:05',	'2019-12-20 13:15:05'),
(57,	12,	329,	14,	'Jan 2019',	2,	'IMS AUDIT-1',	'2019-12-21 13:43:52',	'2019-12-21 14:09:05'),
(58,	12,	329,	4,	'Feb 2019',	2,	'IMS AUDIT-2',	'2019-12-21 13:43:52',	'2019-12-21 14:15:06'),
(59,	13,	329,	4,	'Oct 2019',	3,	'IMS AUDIT-1',	'2019-12-23 09:45:58',	'2019-12-23 09:52:21'),
(60,	13,	79,	1,	'Nov 2019',	3,	'IMS AUDIT-2',	'2019-12-23 09:45:58',	'2019-12-23 10:10:46'),
(61,	13,	297,	13,	'Dec 2019',	3,	'IMS AUDIT-3',	'2019-12-23 09:45:58',	'2019-12-23 12:47:23'),
(62,	14,	527,	10,	'Dec 2019',	1,	'Audit cat 1-1',	'2019-12-23 13:30:12',	'2019-12-30 15:17:32'),
(63,	14,	527,	4,	'Aug 2020',	1,	'Audit cat 1-2',	'2019-12-23 13:30:12',	'2019-12-23 13:30:12'),
(64,	15,	53,	16,	'Dec 2019',	3,	'Quality audit',	'2019-12-24 10:33:24',	'2019-12-24 10:42:13'),
(65,	16,	297,	13,	'Jan 2020',	3,	'Enhancement cat 1-1',	'2019-12-30 08:25:39',	'2019-12-30 09:44:51'),
(66,	16,	527,	1,	'Feb 2019',	1,	'Enhancement cat 1-2',	'2019-12-30 08:25:39',	'2019-12-30 15:23:06'),
(67,	16,	527,	4,	'May 2019',	1,	'Enhancement cat 1-3',	'2019-12-30 08:25:39',	'2019-12-30 11:02:10'),
(68,	16,	101,	10,	'Apr 2019',	1,	'Enhancement cat 1-4',	'2019-12-30 08:25:39',	'2019-12-30 09:02:50'),
(69,	17,	527,	13,	'Dec 2019',	1,	'Test 1',	'2019-12-30 12:52:36',	'2019-12-30 13:36:43'),
(70,	17,	527,	1,	'Jan 2020',	1,	'test 2',	'2019-12-30 12:52:36',	'2019-12-30 13:36:43'),
(71,	17,	101,	13,	'Feb 2020',	3,	'test 3',	'2019-12-30 12:52:36',	'2020-01-08 09:03:06'),
(72,	17,	101,	4,	'Apr 2020',	1,	'test 4',	'2019-12-30 12:52:36',	'2019-12-30 12:52:36'),
(73,	17,	101,	10,	'Jul 2020',	1,	'test 5',	'2019-12-30 12:52:36',	'2019-12-30 12:52:36'),
(74,	17,	8,	23,	'Jun 2020',	1,	'test6',	'2019-12-30 12:52:36',	'2019-12-30 12:52:36'),
(75,	17,	297,	10,	'Jun 2020',	1,	'test 7',	'2019-12-30 12:52:36',	'2019-12-30 12:52:36'),
(76,	17,	22,	5,	'Apr 2020',	1,	'test 8',	'2019-12-30 12:52:36',	'2019-12-30 12:52:36'),
(77,	18,	101,	10,	'May 2020',	1,	'Financial Audit-1',	'2020-01-01 11:39:19',	'2020-01-01 11:39:19'),
(78,	19,	527,	1,	'Jan 2020',	3,	'Other Audit-1',	'2020-01-01 12:06:45',	'2020-01-01 15:06:28'),
(79,	19,	22,	4,	'Jan 2020',	1,	'Other Audit-2',	'2020-01-01 12:06:45',	'2020-01-06 16:02:18'),
(80,	20,	101,	4,	'Jan 2020',	3,	'Legal Audit-1',	'2020-01-03 10:02:41',	'2020-01-03 10:56:59'),
(81,	20,	1,	4,	'Feb 2020',	1,	'Legal Audit-2',	'2020-01-03 10:02:41',	'2020-01-03 10:02:41'),
(82,	20,	101,	4,	'Aug 2020',	2,	'Legal Audit-3',	'2020-01-03 10:02:41',	'2020-01-03 10:46:49'),
(83,	20,	101,	4,	'Feb 2020',	1,	'Legal Audit-4',	'2020-01-03 10:02:41',	'2020-01-03 10:02:41'),
(84,	21,	101,	13,	'Jan 2020',	2,	'Enhancement cat 3-1',	'2020-01-03 11:37:19',	'2020-01-03 12:39:23'),
(85,	21,	527,	14,	'Jan 2020',	1,	'Enhancement cat 3-2',	'2020-01-03 11:37:19',	'2020-01-03 11:37:19'),
(86,	22,	527,	4,	'Feb 2019',	1,	'Technical Audit-1',	'2020-01-03 13:08:04',	'2020-01-03 13:08:04'),
(87,	22,	527,	10,	'Feb 2019',	1,	'Technical Audit-2',	'2020-01-03 13:08:04',	'2020-01-03 13:08:04'),
(88,	23,	101,	4,	'Jan 2020',	1,	'Quality Audit-1',	'2020-01-03 14:33:58',	'2020-01-03 14:33:58'),
(89,	24,	527,	4,	'Jan 2019',	1,	'IMS AUDIT-1',	'2020-01-03 16:07:29',	'2020-01-03 16:07:29'),
(90,	24,	527,	4,	'Jan 2019',	1,	'IMS AUDIT-2',	'2020-01-03 16:07:29',	'2020-01-03 16:07:29'),
(91,	24,	527,	4,	'Jan 2019',	1,	'IMS AUDIT-3',	'2020-01-03 16:07:29',	'2020-01-03 16:07:29'),
(92,	25,	527,	4,	'Jan 2019',	3,	'cat 2-1',	'2020-01-03 16:23:42',	'2020-01-04 10:14:47'),
(93,	25,	527,	4,	'Jan 2019',	1,	'cat 2-2',	'2020-01-03 16:23:42',	'2020-01-03 16:23:42'),
(94,	26,	1,	14,	'Jan 2018',	3,	'Technical Audit-1',	'2020-01-06 09:52:46',	'2020-01-06 09:58:48'),
(95,	26,	1,	14,	'Jan 2018',	3,	'Technical Audit-2',	'2020-01-06 09:52:46',	'2020-01-06 13:55:13'),
(96,	27,	101,	16,	'Jan 2020',	3,	'Cost Audit-1',	'2020-01-07 08:48:54',	'2020-01-07 08:51:06'),
(97,	27,	101,	16,	'Mar 2020',	1,	'Cost Audit-2',	'2020-01-07 08:48:54',	'2020-01-07 08:48:54'),
(98,	27,	101,	16,	'Mar 2020',	1,	'Cost Audit-3',	'2020-01-07 08:48:54',	'2020-01-07 08:48:54'),
(99,	28,	101,	4,	'Jan 2013',	1,	'cat 2-1',	'2020-01-07 10:13:51',	'2020-01-07 10:13:51'),
(100,	29,	8,	1,	'Jan 2020',	1,	'notication category-1',	'2020-01-07 12:38:26',	'2020-01-07 12:38:26'),
(101,	29,	527,	1,	'Jan 2020',	3,	'notication category-2',	'2020-01-07 12:38:26',	'2020-01-07 13:01:56'),
(102,	29,	527,	1,	'Jan 2020',	3,	'notication category-3',	'2020-01-07 12:38:26',	'2020-01-07 13:36:38'),
(103,	30,	101,	13,	'Feb 2020',	3,	'notication category 8/1/2020',	'2020-01-08 09:06:30',	'2020-01-08 09:35:56'),
(104,	30,	101,	4,	'Feb 2020',	3,	'notication category-8/1/2020',	'2020-01-08 09:06:30',	'2020-01-08 17:07:12'),
(105,	31,	1,	5,	'Apr 2020',	1,	'Enhancement cat 1-1',	'2020-01-08 16:36:12',	'2020-01-08 16:36:12'),
(106,	32,	101,	4,	'Mar 2020',	2,	'IMS AUDIT-1',	'2020-01-08 17:10:00',	'2020-01-08 17:11:08'),
(107,	32,	101,	4,	'Mar 2020',	3,	'IMS AUDIT-2',	'2020-01-08 17:10:00',	'2020-01-08 17:16:43'),
(109,	33,	527,	4,	'Jan 2012',	2,	'Financial Audit-1',	'2020-01-09 08:37:46',	'2020-01-09 08:44:12'),
(110,	33,	527,	5,	'Feb 2012',	3,	'Financial Audit-2',	'2020-01-09 08:37:46',	'2020-01-09 08:54:11'),
(111,	34,	527,	4,	'Mar 2012',	1,	'cat 2-1',	'2020-01-09 11:01:22',	'2020-01-09 11:01:22'),
(112,	35,	22,	5,	'Jan 2010',	2,	'notication category-1',	'2020-01-09 12:29:21',	'2020-01-09 12:36:50'),
(113,	35,	527,	5,	'Feb 2010',	1,	'notication category-2',	'2020-01-09 12:33:22',	'2020-01-09 12:33:22'),
(114,	35,	329,	5,	'Mar 2010',	1,	'notication category-3',	'2020-01-09 12:33:22',	'2020-01-09 12:33:22'),
(115,	35,	101,	5,	'Apr 2010',	2,	'notication category-4',	'2020-01-09 12:33:22',	'2020-01-09 12:41:18'),
(116,	36,	535,	10,	'Jan 2022',	3,	'Enhancement cat 1-1',	'2020-01-10 09:02:29',	'2020-01-10 10:40:33'),
(117,	36,	535,	13,	'Feb 2022',	1,	'Enhancement cat 1-2',	'2020-01-10 09:02:29',	'2020-01-10 09:02:29'),
(118,	36,	535,	4,	'Mar 2022',	1,	'Enhancement cat 1-3',	'2020-01-10 09:02:29',	'2020-01-10 09:02:29'),
(119,	37,	527,	5,	'Feb 2020',	1,	'Quality Audit-1',	'2020-01-15 14:53:59',	'2020-01-15 14:53:59'),
(120,	38,	101,	4,	'Jan 2032',	1,	'Cost Audit-1',	'2020-01-16 09:16:57',	'2020-01-16 09:16:57'),
(121,	38,	527,	4,	'Jan 2032',	3,	'Cost Audit-2',	'2020-01-16 09:16:57',	'2020-01-16 09:24:01'),
(122,	39,	527,	1,	'Jan 2035',	2,	'Management Audit-1',	'2020-01-16 09:52:20',	'2020-01-16 10:00:29'),
(123,	39,	1,	1,	'Feb 2035',	1,	'Management Audit-2',	'2020-01-16 09:52:20',	'2020-01-16 09:52:20'),
(125,	41,	1,	1,	'Jan 2027',	1,	'Technical Audit-1',	'2020-01-16 10:16:00',	'2020-01-16 10:16:00'),
(126,	42,	527,	1,	'Mar 2036',	3,	'Management Audit-2',	'2020-01-16 10:24:37',	'2020-01-16 10:32:53'),
(127,	43,	527,	4,	'Jan 2020',	3,	'Legal Audit-1',	'2020-01-17 09:04:54',	'2020-01-17 09:57:16'),
(128,	43,	527,	4,	'Jan 2020',	3,	'Legal Audit-2',	'2020-01-17 09:04:54',	'2020-01-17 09:26:47'),
(149,	54,	527,	18,	'May 2020',	3,	'NEW CATEGORY 18/01/2020-1',	'2020-01-18 13:07:23',	'2020-01-18 13:49:49'),
(150,	54,	527,	7,	'Jun 2020',	1,	'NEW CATEGORY 18/01/2020-2',	'2020-01-18 13:07:23',	'2020-01-18 13:07:23'),
(151,	54,	527,	8,	'Jul 2020',	1,	'NEW CATEGORY 18/01/2020-3',	'2020-01-18 13:07:23',	'2020-01-18 13:07:23'),
(152,	54,	527,	9,	'Aug 2020',	1,	'NEW CATEGORY 18/01/2020-4',	'2020-01-18 13:07:23',	'2020-01-18 13:08:27'),
(153,	55,	529,	4,	'Jan 2000',	1,	'Cost Audit-1',	'2020-01-20 13:09:43',	'2020-01-20 13:09:43'),
(154,	56,	539,	27,	'Jan 2020',	3,	'Forensic Audit-1',	'2020-01-20 13:39:01',	'2020-01-20 14:50:30'),
(155,	56,	539,	27,	'Feb 2020',	1,	'Forensic Audit-2',	'2020-01-20 13:39:01',	'2020-01-20 13:39:01'),
(156,	56,	539,	1,	'Feb 2020',	1,	'Forensic Audit-3',	'2020-01-20 13:39:01',	'2020-01-20 13:39:01'),
(157,	57,	539,	27,	'Mar 2020',	3,	'Statutory Audit-1',	'2020-01-22 14:43:28',	'2020-01-23 11:08:12'),
(158,	57,	539,	27,	'Apr 2020',	1,	'Statutory Audit-2',	'2020-01-22 14:43:28',	'2020-01-22 14:43:28'),
(159,	57,	539,	27,	'May 2020',	1,	'Statutory Audit-3',	'2020-01-22 14:43:28',	'2020-01-22 14:43:28'),
(160,	58,	527,	27,	'Jun 2020',	3,	'Tax Audit-1',	'2020-01-25 15:32:30',	'2020-01-25 15:52:33'),
(161,	58,	527,	27,	'Jun 2020',	2,	'Tax Audit-2',	'2020-01-25 15:32:30',	'2020-01-25 15:42:39'),
(162,	59,	8,	4,	'Jan 2020',	1,	'Special Audit-1',	'2020-01-29 15:22:57',	'2020-01-29 15:22:57'),
(163,	60,	8,	4,	'Jan 2020',	1,	'Special Audit-1',	'2020-01-29 15:35:00',	'2020-01-29 16:20:31'),
(164,	61,	527,	15,	'Mar 2020',	3,	'Special Audit-1',	'2020-01-30 09:06:06',	'2020-01-31 08:50:38'),
(165,	61,	527,	16,	'Apr 2020',	1,	'Special Audit-2',	'2020-01-30 09:06:06',	'2020-01-30 09:06:06');

DROP TABLE IF EXISTS `audit_pre_plan_sections`;
CREATE TABLE `audit_pre_plan_sections` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `audit_pre_plan_id` int(10) unsigned NOT NULL,
  `section_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_pre_plan_sections` (`id`, `audit_pre_plan_id`, `section_id`) VALUES
(1,	1,	45),
(2,	2,	2),
(3,	3,	28),
(4,	3,	26),
(5,	4,	51),
(6,	5,	3),
(7,	5,	2),
(8,	6,	1),
(9,	7,	20),
(10,	7,	19),
(11,	8,	16),
(12,	9,	29),
(13,	10,	9),
(14,	10,	10),
(15,	10,	11),
(16,	11,	14),
(17,	11,	13),
(18,	12,	57),
(19,	12,	7),
(20,	12,	6),
(21,	13,	36),
(22,	13,	35),
(23,	13,	37),
(24,	14,	62),
(25,	15,	61),
(26,	16,	60),
(27,	17,	24),
(28,	18,	22),
(29,	19,	47),
(30,	20,	41),
(31,	21,	45),
(32,	22,	28),
(33,	22,	26),
(34,	23,	59),
(35,	24,	2),
(36,	24,	3),
(37,	25,	1),
(38,	26,	19),
(39,	26,	20),
(40,	26,	21),
(41,	27,	16),
(42,	27,	17),
(43,	27,	18),
(44,	28,	29),
(45,	29,	9),
(46,	29,	10),
(47,	29,	11),
(48,	30,	14),
(49,	30,	13),
(50,	31,	5),
(51,	31,	6),
(52,	31,	7),
(53,	32,	35),
(54,	32,	36),
(55,	32,	37),
(56,	33,	30),
(57,	33,	31),
(58,	34,	32),
(59,	34,	33),
(60,	34,	34),
(61,	35,	22),
(62,	35,	23),
(63,	35,	24),
(64,	35,	25),
(65,	36,	22),
(66,	36,	23),
(67,	36,	24),
(68,	36,	25),
(69,	37,	22),
(70,	37,	23),
(71,	37,	24),
(72,	37,	25),
(73,	38,	41),
(74,	39,	39),
(75,	40,	49),
(76,	40,	26),
(77,	40,	51),
(78,	40,	28),
(79,	41,	49),
(80,	41,	26),
(81,	41,	51),
(82,	41,	28),
(103,	46,	1),
(104,	46,	2),
(105,	46,	3),
(106,	47,	1),
(107,	47,	2),
(108,	47,	3),
(109,	48,	2),
(110,	49,	1),
(111,	49,	2),
(112,	49,	3),
(132,	57,	30),
(133,	57,	31),
(134,	58,	1),
(135,	58,	2),
(136,	58,	3),
(137,	59,	1),
(138,	59,	2),
(139,	59,	3),
(140,	60,	39),
(141,	61,	49),
(142,	61,	26),
(143,	61,	51),
(144,	61,	28),
(145,	62,	17),
(146,	62,	16),
(147,	62,	18),
(148,	63,	1),
(149,	63,	2),
(150,	63,	3),
(151,	64,	35),
(152,	64,	36),
(153,	64,	37),
(187,	65,	49),
(188,	65,	26),
(189,	65,	51),
(190,	65,	28),
(191,	66,	39),
(192,	67,	1),
(193,	67,	2),
(194,	67,	3),
(195,	68,	17),
(196,	68,	16),
(197,	68,	18),
(238,	77,	17),
(239,	77,	16),
(240,	77,	18),
(245,	78,	39),
(246,	79,	1),
(247,	79,	2),
(248,	79,	3),
(249,	80,	1),
(250,	80,	2),
(251,	80,	3),
(252,	81,	1),
(253,	81,	2),
(254,	81,	3),
(255,	82,	1),
(256,	82,	2),
(257,	82,	3),
(258,	83,	1),
(259,	83,	2),
(260,	83,	3),
(261,	84,	49),
(262,	84,	26),
(263,	84,	51),
(264,	84,	28),
(265,	85,	30),
(266,	85,	31),
(267,	86,	1),
(268,	86,	2),
(269,	86,	3),
(270,	87,	17),
(271,	87,	16),
(272,	88,	1),
(273,	88,	2),
(274,	88,	3),
(275,	89,	1),
(276,	89,	2),
(277,	89,	3),
(278,	90,	1),
(279,	90,	2),
(280,	90,	3),
(281,	91,	1),
(282,	91,	2),
(283,	91,	3),
(284,	92,	1),
(285,	92,	2),
(286,	92,	3),
(287,	93,	1),
(288,	93,	2),
(289,	93,	3),
(342,	94,	30),
(343,	94,	31),
(344,	95,	30),
(345,	95,	31),
(346,	96,	35),
(347,	96,	36),
(348,	96,	37),
(349,	97,	35),
(350,	97,	36),
(351,	97,	37),
(352,	98,	35),
(353,	98,	36),
(354,	98,	37),
(355,	99,	1),
(356,	99,	2),
(357,	99,	3),
(358,	100,	39),
(359,	101,	39),
(360,	102,	39),
(361,	69,	49),
(362,	69,	26),
(363,	69,	51),
(364,	69,	28),
(365,	70,	39),
(366,	71,	49),
(367,	71,	26),
(368,	71,	51),
(369,	71,	28),
(370,	72,	1),
(371,	72,	2),
(372,	72,	3),
(373,	73,	17),
(374,	73,	16),
(375,	73,	18),
(376,	74,	55),
(377,	75,	17),
(378,	75,	16),
(379,	75,	18),
(380,	76,	45),
(381,	76,	60),
(389,	103,	49),
(390,	103,	26),
(391,	103,	51),
(392,	103,	28),
(393,	104,	1),
(394,	104,	2),
(395,	104,	3),
(396,	105,	45),
(403,	108,	1),
(404,	108,	2),
(405,	108,	3),
(406,	109,	1),
(407,	109,	2),
(408,	109,	3),
(409,	110,	45),
(410,	110,	60),
(411,	111,	1),
(412,	111,	2),
(413,	111,	3),
(416,	112,	45),
(417,	112,	60),
(418,	113,	45),
(419,	114,	45),
(420,	115,	45),
(431,	116,	17),
(432,	116,	16),
(433,	116,	18),
(434,	117,	49),
(435,	117,	26),
(436,	117,	51),
(437,	117,	28),
(438,	118,	1),
(439,	118,	2),
(440,	118,	3),
(441,	106,	1),
(442,	106,	2),
(443,	106,	3),
(444,	107,	1),
(445,	107,	2),
(446,	107,	3),
(447,	119,	45),
(448,	120,	1),
(449,	120,	2),
(450,	120,	3),
(451,	121,	1),
(452,	121,	2),
(453,	121,	3),
(454,	122,	39),
(455,	123,	39),
(457,	125,	39),
(459,	126,	39),
(478,	127,	1),
(479,	127,	2),
(480,	127,	3),
(481,	128,	1),
(482,	128,	2),
(483,	128,	3),
(529,	149,	29),
(530,	150,	5),
(531,	150,	6),
(532,	151,	9),
(533,	151,	10),
(534,	152,	13),
(535,	152,	14),
(536,	153,	1),
(537,	153,	2),
(538,	153,	3),
(542,	154,	66),
(543,	155,	64),
(544,	156,	39),
(550,	157,	66),
(551,	158,	65),
(552,	159,	66),
(553,	159,	65),
(554,	159,	64),
(555,	160,	66),
(556,	160,	65),
(557,	160,	64),
(558,	161,	66),
(559,	161,	65),
(560,	161,	64),
(561,	162,	1),
(562,	162,	2),
(563,	162,	3),
(564,	163,	1),
(565,	163,	2),
(566,	163,	3),
(567,	164,	32),
(568,	164,	33),
(569,	164,	34),
(570,	165,	35),
(571,	165,	36),
(572,	165,	37);

DROP TABLE IF EXISTS `audit_pre_plan_statuses`;
CREATE TABLE `audit_pre_plan_statuses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_new` tinyint(1) NOT NULL DEFAULT '0',
  `is_planned` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `updated_by` int(10) unsigned DEFAULT NULL,
  `deleted_by` int(10) unsigned DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_pre_plan_statuses` (`id`, `title`, `label`, `is_new`, `is_planned`, `created_at`, `updated_at`, `deleted_at`, `created_by`, `updated_by`, `deleted_by`, `status`) VALUES
(1,	'New',	'primary',	1,	0,	'2018-10-03 14:29:19',	'2018-10-03 14:29:19',	NULL,	1,	NULL,	NULL,	1),
(2,	'Planned',	'success',	0,	1,	'2018-10-03 14:29:19',	'2018-10-03 14:29:19',	NULL,	1,	NULL,	NULL,	1),
(3,	'Audited',	'warning',	0,	0,	'2018-10-03 14:29:20',	'2018-10-03 14:29:20',	NULL,	1,	NULL,	NULL,	1);

DROP TABLE IF EXISTS `audit_programs`;
CREATE TABLE `audit_programs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `unique_id` int(11) NOT NULL DEFAULT '1',
  `audit_category_id` int(10) unsigned NOT NULL,
  `subsidiary_id` int(11) DEFAULT NULL,
  `branch_id` int(11) DEFAULT NULL,
  `leader_id` int(11) DEFAULT NULL,
  `division_id` int(11) DEFAULT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `no_of_audit_plans` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `updated_by` int(10) unsigned DEFAULT NULL,
  `deleted_by` int(10) unsigned DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_programs` (`id`, `unique_id`, `audit_category_id`, `subsidiary_id`, `branch_id`, `leader_id`, `division_id`, `start_date`, `end_date`, `no_of_audit_plans`, `created_at`, `updated_at`, `deleted_at`, `created_by`, `updated_by`, `deleted_by`, `status`) VALUES
(1,	1,	3,	NULL,	NULL,	8,	NULL,	'2018-12-09',	'2018-12-20',	20,	'2018-11-20 00:00:00',	'2019-12-12 13:13:24',	NULL,	8,	NULL,	NULL,	1),
(2,	1,	28,	NULL,	NULL,	8,	NULL,	'2017-04-30',	'2017-05-02',	18,	'2017-04-10 00:00:00',	'2019-12-12 13:13:24',	NULL,	8,	NULL,	NULL,	1),
(3,	1,	5,	NULL,	NULL,	8,	NULL,	'2019-12-17',	'2020-12-17',	1,	'2019-12-17 14:45:31',	'2019-12-17 14:45:31',	NULL,	8,	NULL,	NULL,	1),
(4,	2,	6,	NULL,	NULL,	8,	NULL,	'2019-12-18',	'2020-12-18',	2,	'2019-12-18 10:26:24',	'2019-12-18 10:26:24',	NULL,	8,	NULL,	NULL,	1),
(7,	3,	2,	NULL,	NULL,	8,	NULL,	'2019-10-19',	'2019-12-19',	3,	'2019-12-19 15:46:20',	'2019-12-20 12:39:56',	NULL,	8,	1,	NULL,	1),
(8,	1,	5,	NULL,	NULL,	101,	NULL,	'2020-12-20',	'2020-12-20',	1,	'2019-12-20 13:15:05',	'2019-12-21 13:37:26',	'2019-12-21 13:37:26',	101,	NULL,	NULL,	1),
(12,	4,	30,	NULL,	NULL,	101,	NULL,	'2019-01-21',	'2019-02-21',	2,	'2019-12-21 13:43:52',	'2019-12-23 09:39:18',	'2019-12-23 09:39:18',	101,	NULL,	NULL,	1),
(13,	4,	30,	NULL,	NULL,	1,	NULL,	'2019-10-23',	'2019-12-25',	3,	'2019-12-23 09:45:58',	'2019-12-23 09:45:58',	NULL,	1,	NULL,	NULL,	1),
(14,	5,	31,	NULL,	NULL,	8,	NULL,	'2019-12-23',	'2020-12-23',	2,	'2019-12-23 13:30:12',	'2019-12-23 13:30:12',	NULL,	8,	NULL,	NULL,	1),
(15,	6,	32,	NULL,	NULL,	8,	NULL,	'2019-12-24',	'2020-12-24',	1,	'2019-12-24 10:33:24',	'2019-12-24 10:33:24',	NULL,	8,	NULL,	NULL,	1),
(16,	7,	33,	NULL,	NULL,	1,	NULL,	'2019-01-30',	'2020-01-30',	4,	'2019-12-30 08:25:39',	'2019-12-30 11:02:10',	NULL,	1,	1,	NULL,	1),
(17,	8,	34,	NULL,	NULL,	527,	NULL,	'2019-12-30',	'2020-12-30',	8,	'2019-12-30 12:52:36',	'2020-01-08 09:03:06',	NULL,	527,	467,	NULL,	1),
(18,	1,	4,	NULL,	NULL,	70,	NULL,	'2020-01-01',	'2021-01-01',	1,	'2020-01-01 11:39:19',	'2020-01-01 12:04:55',	'2020-01-01 12:04:55',	70,	NULL,	NULL,	1),
(19,	1,	28,	NULL,	NULL,	101,	NULL,	'2020-01-01',	'2020-01-01',	2,	'2020-01-01 12:06:45',	'2020-01-02 12:57:23',	NULL,	101,	1,	NULL,	1),
(20,	2,	2,	NULL,	NULL,	101,	NULL,	'2020-01-03',	'2021-01-03',	4,	'2020-01-03 10:02:41',	'2020-01-03 16:00:33',	'2020-01-03 16:00:33',	101,	NULL,	NULL,	1),
(21,	3,	35,	NULL,	NULL,	101,	NULL,	'2020-01-03',	'2020-01-03',	2,	'2020-01-03 11:37:19',	'2020-01-03 13:39:38',	'2020-01-03 13:39:38',	101,	NULL,	NULL,	1),
(22,	9,	6,	NULL,	NULL,	101,	NULL,	'2019-02-28',	'2019-02-28',	2,	'2020-01-03 13:08:04',	'2020-01-03 13:08:04',	NULL,	101,	NULL,	NULL,	1),
(23,	3,	1,	NULL,	NULL,	101,	NULL,	'2020-01-03',	'2021-01-03',	1,	'2020-01-03 14:33:58',	'2020-01-03 16:00:23',	'2020-01-03 16:00:23',	101,	NULL,	NULL,	1),
(24,	10,	30,	NULL,	NULL,	101,	NULL,	'2019-01-03',	'2019-01-03',	3,	'2020-01-03 16:07:29',	'2020-01-03 16:22:11',	'2020-01-03 16:22:11',	101,	NULL,	NULL,	1),
(25,	10,	32,	NULL,	NULL,	101,	NULL,	'2019-01-03',	'2019-01-03',	2,	'2020-01-03 16:23:42',	'2020-01-03 16:23:42',	NULL,	101,	NULL,	NULL,	1),
(26,	2,	6,	NULL,	NULL,	1,	NULL,	'2018-01-06',	'2018-01-06',	2,	'2020-01-06 09:52:46',	'2020-01-06 13:16:51',	NULL,	1,	1,	NULL,	1),
(27,	2,	7,	NULL,	NULL,	243,	NULL,	'2020-01-07',	'2021-01-07',	3,	'2020-01-07 08:48:54',	'2020-01-07 08:48:54',	NULL,	243,	NULL,	NULL,	1),
(28,	1,	32,	NULL,	NULL,	101,	NULL,	'2013-01-07',	'2013-01-07',	1,	'2020-01-07 10:13:51',	'2020-01-07 10:13:51',	NULL,	101,	NULL,	NULL,	1),
(29,	3,	37,	NULL,	NULL,	65,	NULL,	'2020-01-07',	'2020-01-26',	3,	'2020-01-07 12:38:26',	'2020-01-07 12:38:26',	NULL,	65,	NULL,	NULL,	1),
(30,	4,	37,	NULL,	NULL,	467,	NULL,	'2020-02-08',	'2020-02-15',	2,	'2020-01-08 09:06:30',	'2020-01-08 11:01:31',	NULL,	467,	525,	NULL,	1),
(31,	5,	33,	NULL,	NULL,	1,	NULL,	'2020-04-23',	'2021-01-08',	1,	'2020-01-08 16:36:12',	'2020-01-08 16:36:12',	NULL,	1,	NULL,	NULL,	1),
(32,	6,	30,	NULL,	NULL,	101,	NULL,	'2020-01-08',	'2021-01-08',	2,	'2020-01-08 17:10:00',	'2020-01-15 10:52:32',	NULL,	101,	101,	NULL,	1),
(33,	1,	4,	NULL,	NULL,	70,	NULL,	'2012-01-09',	'2012-02-02',	2,	'2020-01-09 08:37:46',	'2020-01-09 08:37:46',	NULL,	70,	NULL,	NULL,	1),
(34,	2,	32,	NULL,	NULL,	527,	NULL,	'2012-03-09',	'2012-03-09',	1,	'2020-01-09 11:01:22',	'2020-01-09 11:01:22',	NULL,	527,	NULL,	NULL,	1),
(35,	1,	37,	NULL,	NULL,	22,	NULL,	'2010-01-09',	'2010-05-18',	4,	'2020-01-09 12:29:21',	'2020-01-09 12:33:22',	NULL,	22,	22,	NULL,	1),
(36,	1,	33,	NULL,	NULL,	1,	NULL,	'2022-01-10',	'2022-03-20',	3,	'2020-01-10 09:02:29',	'2020-01-10 09:06:54',	NULL,	1,	535,	NULL,	1),
(37,	7,	1,	NULL,	NULL,	1,	NULL,	'2020-01-15',	'2021-01-15',	1,	'2020-01-15 14:53:59',	'2020-01-15 14:53:59',	NULL,	1,	NULL,	NULL,	1),
(38,	1,	7,	NULL,	NULL,	1,	NULL,	'2032-01-16',	'2032-01-16',	2,	'2020-01-16 09:16:57',	'2020-01-16 09:16:57',	NULL,	1,	NULL,	NULL,	1),
(39,	1,	8,	NULL,	NULL,	1,	NULL,	'2035-01-16',	'2036-01-16',	2,	'2020-01-16 09:52:20',	'2020-01-16 09:52:20',	NULL,	1,	NULL,	NULL,	1),
(41,	1,	6,	NULL,	NULL,	1,	NULL,	'2027-01-16',	'2028-01-16',	1,	'2020-01-16 10:16:00',	'2020-01-16 10:16:00',	NULL,	1,	NULL,	NULL,	1),
(42,	1,	8,	NULL,	NULL,	1,	NULL,	'2036-03-16',	'2037-01-16',	1,	'2020-01-16 10:24:37',	'2020-01-16 10:25:26',	NULL,	1,	1,	NULL,	1),
(43,	8,	2,	NULL,	NULL,	1,	NULL,	'2020-01-17',	'2021-01-17',	2,	'2020-01-17 09:04:54',	'2020-01-17 09:51:20',	NULL,	1,	527,	NULL,	1),
(54,	9,	38,	NULL,	NULL,	101,	NULL,	'2020-05-18',	'2020-08-30',	4,	'2020-01-18 13:07:23',	'2020-01-18 13:08:27',	NULL,	101,	101,	NULL,	1),
(55,	1,	7,	NULL,	NULL,	68,	NULL,	'2000-01-20',	'2000-01-20',	1,	'2020-01-20 13:09:43',	'2020-01-20 13:10:22',	'2020-01-20 13:10:22',	68,	NULL,	NULL,	1),
(56,	10,	39,	NULL,	NULL,	1,	NULL,	'2020-01-20',	'2020-02-20',	3,	'2020-01-20 13:39:01',	'2020-01-20 13:39:23',	NULL,	1,	1,	NULL,	1),
(57,	11,	40,	NULL,	NULL,	538,	NULL,	'2020-03-16',	'2020-05-22',	3,	'2020-01-22 14:43:28',	'2020-01-22 15:01:04',	NULL,	538,	538,	NULL,	1),
(58,	12,	41,	NULL,	NULL,	539,	NULL,	'2020-06-25',	'2020-06-25',	2,	'2020-01-25 15:32:30',	'2020-01-25 15:32:30',	NULL,	539,	NULL,	NULL,	1),
(59,	13,	47,	NULL,	NULL,	8,	NULL,	'2020-01-30',	'2020-03-02',	1,	'2020-01-29 15:22:57',	'2020-01-29 15:33:12',	'2020-01-29 15:33:12',	8,	NULL,	NULL,	1),
(60,	13,	47,	NULL,	NULL,	8,	NULL,	'2020-01-30',	'2020-02-02',	1,	'2020-01-29 15:35:00',	'2020-01-30 13:50:52',	'2020-01-30 13:50:52',	8,	NULL,	NULL,	1),
(61,	14,	47,	NULL,	NULL,	539,	NULL,	'2020-03-01',	'2020-04-30',	2,	'2020-01-30 09:06:06',	'2020-01-30 09:06:06',	NULL,	539,	NULL,	NULL,	1);

DROP TABLE IF EXISTS `audit_program_branch`;
CREATE TABLE `audit_program_branch` (
  `audit_program_id` int(10) unsigned NOT NULL,
  `business_profile_id` int(10) unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `audit_program_departments`;
CREATE TABLE `audit_program_departments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `audit_program_id` int(10) unsigned NOT NULL,
  `department_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_program_departments` (`id`, `audit_program_id`, `department_id`) VALUES
(1,	1,	5),
(2,	1,	14),
(3,	1,	13),
(4,	1,	4),
(5,	1,	11),
(6,	1,	10),
(7,	1,	18),
(8,	1,	8),
(9,	1,	9),
(10,	1,	7),
(11,	1,	16),
(12,	1,	15),
(13,	1,	12),
(14,	1,	6),
(15,	1,	2),
(16,	2,	5),
(17,	2,	13),
(18,	2,	4),
(19,	2,	11),
(20,	2,	10),
(21,	2,	18),
(22,	2,	8),
(23,	2,	9),
(24,	2,	7),
(25,	2,	16),
(26,	2,	14),
(27,	2,	15),
(28,	2,	12),
(29,	2,	2),
(30,	3,	13),
(31,	3,	1),
(32,	3,	14),
(33,	3,	4),
(34,	3,	18),
(35,	3,	10),
(36,	3,	5),
(37,	3,	11),
(38,	3,	15),
(39,	3,	16),
(40,	3,	2),
(41,	3,	21),
(42,	3,	3),
(43,	3,	6),
(44,	3,	23),
(45,	3,	25),
(46,	3,	12),
(47,	3,	19),
(48,	3,	7),
(49,	3,	8),
(50,	3,	9),
(51,	3,	24),
(52,	4,	13),
(53,	4,	14),
(54,	4,	18),
(55,	4,	15),
(56,	4,	16),
(57,	4,	7),
(58,	4,	8),
(59,	4,	9),
(64,	7,	4),
(65,	8,	13),
(66,	8,	1),
(67,	8,	14),
(68,	8,	4),
(69,	8,	18),
(70,	8,	10),
(71,	8,	5),
(72,	8,	11),
(73,	8,	15),
(74,	8,	16),
(75,	8,	2),
(76,	8,	21),
(77,	8,	3),
(78,	8,	6),
(79,	8,	23),
(80,	8,	25),
(81,	8,	12),
(82,	8,	19),
(83,	8,	7),
(84,	8,	8),
(85,	8,	9),
(86,	8,	24),
(153,	12,	14),
(154,	12,	4),
(155,	12,	1),
(156,	13,	4),
(157,	13,	1),
(158,	13,	13),
(159,	14,	4),
(160,	14,	10),
(161,	15,	16),
(228,	16,	13),
(229,	16,	1),
(230,	16,	14),
(231,	16,	4),
(232,	16,	18),
(233,	16,	10),
(234,	16,	5),
(235,	16,	11),
(236,	16,	15),
(237,	16,	16),
(238,	16,	2),
(239,	16,	21),
(240,	16,	3),
(241,	16,	6),
(242,	16,	23),
(243,	16,	25),
(244,	16,	12),
(245,	16,	19),
(246,	16,	7),
(247,	16,	8),
(248,	16,	9),
(249,	16,	24),
(294,	18,	10),
(297,	19,	1),
(298,	19,	4),
(299,	20,	4),
(300,	21,	13),
(301,	21,	14),
(302,	22,	4),
(303,	22,	10),
(304,	23,	4),
(305,	24,	4),
(306,	25,	4),
(320,	26,	14),
(321,	27,	16),
(322,	28,	4),
(323,	29,	1),
(324,	17,	13),
(325,	17,	1),
(326,	17,	14),
(327,	17,	4),
(328,	17,	18),
(329,	17,	10),
(330,	17,	5),
(331,	17,	11),
(332,	17,	15),
(333,	17,	16),
(334,	17,	2),
(335,	17,	21),
(336,	17,	3),
(337,	17,	6),
(338,	17,	23),
(339,	17,	25),
(340,	17,	12),
(341,	17,	19),
(342,	17,	7),
(343,	17,	8),
(344,	17,	9),
(345,	17,	24),
(348,	30,	13),
(349,	30,	4),
(350,	31,	5),
(352,	33,	4),
(353,	33,	5),
(354,	33,	21),
(355,	33,	6),
(356,	33,	23),
(357,	33,	19),
(358,	34,	4),
(360,	35,	5),
(364,	36,	10),
(365,	36,	13),
(366,	36,	4),
(367,	32,	4),
(368,	37,	5),
(369,	38,	4),
(370,	39,	1),
(372,	41,	1),
(374,	42,	1),
(380,	43,	4),
(381,	43,	19),
(402,	54,	18),
(403,	54,	7),
(404,	54,	8),
(405,	54,	9),
(406,	55,	4),
(409,	56,	27),
(410,	56,	1),
(412,	57,	27),
(413,	58,	27),
(414,	59,	4),
(415,	60,	4),
(416,	61,	15),
(417,	61,	16);

DROP TABLE IF EXISTS `audit_program_divisions`;
CREATE TABLE `audit_program_divisions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `audit_program_id` int(10) unsigned NOT NULL,
  `division_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_program_divisions` (`id`, `audit_program_id`, `division_id`) VALUES
(1,	1,	2),
(2,	1,	5),
(3,	1,	4),
(4,	1,	3),
(5,	1,	1),
(6,	2,	2),
(7,	2,	5),
(8,	2,	4),
(9,	2,	3),
(10,	2,	1),
(11,	3,	2),
(12,	3,	4),
(13,	3,	5),
(14,	3,	3),
(15,	3,	1),
(16,	4,	5),
(17,	4,	3),
(33,	7,	1),
(34,	7,	2),
(35,	7,	3),
(36,	7,	4),
(37,	7,	5),
(38,	8,	2),
(39,	8,	4),
(40,	8,	5),
(41,	8,	3),
(42,	8,	1),
(58,	12,	2),
(59,	12,	4),
(60,	12,	5),
(61,	12,	3),
(62,	12,	1),
(63,	13,	2),
(64,	13,	4),
(65,	13,	5),
(66,	13,	3),
(67,	13,	1),
(68,	14,	2),
(69,	14,	4),
(70,	14,	5),
(71,	14,	3),
(72,	14,	1),
(73,	15,	5),
(89,	16,	1),
(90,	16,	2),
(91,	16,	3),
(92,	16,	4),
(93,	16,	5),
(104,	18,	2),
(105,	18,	4),
(106,	18,	5),
(107,	18,	3),
(108,	18,	1),
(114,	19,	1),
(115,	19,	2),
(116,	19,	3),
(117,	19,	4),
(118,	19,	5),
(119,	20,	2),
(120,	21,	2),
(121,	21,	4),
(122,	21,	5),
(123,	21,	3),
(124,	21,	1),
(125,	22,	2),
(126,	22,	4),
(127,	23,	2),
(128,	24,	2),
(129,	24,	5),
(130,	24,	4),
(131,	25,	2),
(197,	26,	1),
(198,	26,	2),
(199,	26,	3),
(200,	26,	4),
(201,	26,	5),
(202,	27,	2),
(203,	27,	4),
(204,	27,	5),
(205,	27,	3),
(206,	27,	1),
(207,	28,	2),
(208,	28,	4),
(209,	28,	5),
(210,	28,	3),
(211,	28,	1),
(212,	29,	2),
(213,	29,	4),
(214,	29,	5),
(215,	29,	3),
(216,	29,	1),
(217,	17,	1),
(218,	17,	2),
(219,	17,	3),
(220,	17,	4),
(221,	17,	5),
(223,	30,	2),
(224,	31,	2),
(227,	33,	2),
(228,	34,	2),
(230,	35,	2),
(236,	36,	1),
(237,	36,	2),
(238,	36,	3),
(239,	36,	4),
(240,	36,	5),
(241,	32,	2),
(242,	32,	4),
(243,	37,	2),
(244,	38,	2),
(245,	39,	1),
(247,	41,	1),
(249,	42,	1),
(253,	43,	2),
(269,	54,	3),
(270,	55,	2),
(272,	56,	1),
(274,	57,	1),
(275,	58,	1),
(276,	59,	2),
(277,	60,	2),
(278,	61,	5);

DROP TABLE IF EXISTS `audit_program_mstypes`;
CREATE TABLE `audit_program_mstypes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `audit_program_id` int(10) unsigned NOT NULL,
  `ms_type_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_program_mstypes` (`id`, `audit_program_id`, `ms_type_id`) VALUES
(1,	1,	1),
(2,	1,	2),
(3,	1,	12),
(4,	2,	1),
(5,	2,	2),
(6,	3,	1),
(7,	3,	4),
(8,	4,	2),
(13,	7,	2),
(14,	8,	1),
(15,	8,	2),
(16,	8,	3),
(17,	8,	4),
(18,	8,	5),
(19,	8,	6),
(20,	8,	7),
(21,	8,	8),
(22,	8,	9),
(23,	8,	10),
(24,	8,	11),
(25,	8,	12),
(26,	8,	13),
(27,	8,	15),
(28,	8,	16),
(29,	8,	17),
(30,	8,	18),
(31,	8,	19),
(32,	8,	20),
(33,	8,	21),
(76,	12,	1),
(77,	12,	2),
(78,	13,	2),
(79,	13,	1),
(80,	14,	2),
(81,	14,	1),
(82,	15,	1),
(83,	15,	2),
(84,	15,	12),
(91,	16,	1),
(92,	16,	2),
(99,	18,	1),
(100,	18,	2),
(103,	19,	2),
(104,	19,	1),
(105,	20,	1),
(106,	20,	2),
(107,	21,	1),
(108,	21,	2),
(109,	22,	1),
(110,	22,	2),
(111,	23,	1),
(112,	24,	1),
(113,	24,	2),
(114,	25,	1),
(115,	25,	2),
(142,	26,	7),
(143,	26,	8),
(144,	27,	2),
(145,	28,	1),
(146,	29,	7),
(147,	29,	8),
(148,	17,	1),
(149,	17,	2),
(150,	17,	3),
(152,	30,	1),
(153,	31,	1),
(155,	33,	12),
(156,	33,	13),
(157,	34,	3),
(159,	35,	1),
(180,	36,	1),
(181,	36,	2),
(182,	36,	3),
(183,	36,	4),
(184,	36,	5),
(185,	36,	6),
(186,	36,	7),
(187,	36,	8),
(188,	36,	9),
(189,	36,	10),
(190,	36,	11),
(191,	36,	12),
(192,	36,	13),
(193,	36,	15),
(194,	32,	1),
(195,	37,	1),
(196,	38,	2),
(197,	39,	1),
(199,	41,	1),
(201,	42,	1),
(205,	43,	1),
(218,	54,	13),
(219,	54,	15),
(220,	55,	3),
(221,	55,	6),
(223,	56,	1),
(225,	57,	11),
(226,	58,	3),
(227,	59,	1),
(228,	60,	1),
(229,	61,	3);

DROP TABLE IF EXISTS `audit_program_subsidiary`;
CREATE TABLE `audit_program_subsidiary` (
  `audit_program_id` int(10) unsigned NOT NULL,
  `business_profile_id` int(10) unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `audit_reports`;
CREATE TABLE `audit_reports` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `audit_id` int(10) unsigned NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `conclusion` text COLLATE utf8mb4_unicode_ci,
  `is_published` int(11) NOT NULL DEFAULT '0',
  `submitted_at` date DEFAULT NULL,
  `is_auto_published` int(11) NOT NULL DEFAULT '0',
  `auto_published_at` date DEFAULT NULL,
  `audit_report_status_id` int(11) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_by` int(10) unsigned DEFAULT NULL,
  `updated_by` int(10) unsigned DEFAULT NULL,
  `deleted_by` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_reports` (`id`, `audit_id`, `description`, `reference_id`, `conclusion`, `is_published`, `submitted_at`, `is_auto_published`, `auto_published_at`, `audit_report_status_id`, `created_at`, `updated_at`, `deleted_at`, `created_by`, `updated_by`, `deleted_by`) VALUES
(1,	1,	'',	'',	NULL,	0,	'2019-12-12',	0,	NULL,	5,	'2018-12-19 00:00:00',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL),
(2,	2,	'',	'',	NULL,	0,	'2019-12-12',	0,	NULL,	5,	'2018-12-20 00:00:00',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL),
(3,	3,	'',	'',	NULL,	0,	'2019-12-12',	0,	NULL,	5,	'2018-12-16 00:00:00',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL),
(4,	4,	'',	'',	NULL,	0,	'2019-12-12',	0,	NULL,	5,	'2018-12-17 00:00:00',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL),
(5,	5,	'',	'',	NULL,	0,	'2019-12-12',	0,	NULL,	5,	'2018-12-18 00:00:00',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL),
(6,	6,	'',	'',	NULL,	0,	'2019-12-12',	0,	NULL,	5,	'2018-12-17 00:00:00',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL),
(7,	7,	'',	'',	NULL,	0,	'2019-12-12',	0,	NULL,	5,	'2018-12-20 00:00:00',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL),
(8,	8,	'',	'',	NULL,	0,	'2019-12-12',	0,	NULL,	5,	'2018-12-18 00:00:00',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL),
(9,	9,	'',	'',	NULL,	0,	'2019-12-12',	0,	NULL,	5,	'2018-12-18 00:00:00',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL),
(10,	10,	'',	'',	NULL,	0,	'2019-12-12',	0,	NULL,	5,	'2018-12-17 00:00:00',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL),
(11,	11,	'',	'',	NULL,	0,	'2019-12-12',	0,	NULL,	5,	'2018-12-18 00:00:00',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL),
(12,	12,	'',	'',	NULL,	0,	'2019-12-12',	0,	NULL,	5,	'2018-12-19 00:00:00',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL),
(13,	13,	'',	'',	NULL,	0,	'2019-12-12',	0,	NULL,	5,	'2018-12-18 00:00:00',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL),
(14,	14,	'',	'',	NULL,	0,	'2019-12-12',	0,	NULL,	5,	'2018-12-19 00:00:00',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL),
(15,	15,	'',	'',	NULL,	0,	'2019-12-12',	0,	NULL,	5,	'2018-12-12 00:00:00',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL),
(16,	16,	'',	'',	NULL,	0,	'2019-12-12',	0,	NULL,	5,	'2018-12-24 00:00:00',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL),
(17,	17,	'',	'',	NULL,	0,	'2019-12-12',	0,	NULL,	5,	'2018-12-19 00:00:00',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL),
(18,	18,	'',	'',	NULL,	0,	'2019-12-12',	0,	NULL,	5,	'2018-12-19 00:00:00',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL),
(19,	19,	'',	'',	NULL,	0,	'2019-12-12',	0,	NULL,	5,	'2018-12-19 00:00:00',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL),
(20,	20,	'',	'',	NULL,	0,	'2019-12-12',	0,	NULL,	5,	'2018-12-31 00:00:00',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL),
(21,	21,	'',	'',	NULL,	0,	'2019-12-12',	0,	NULL,	5,	'2017-05-09 00:00:00',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL),
(22,	22,	'',	'',	NULL,	0,	'2019-12-12',	0,	NULL,	5,	'2017-05-02 00:00:00',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL),
(23,	23,	'',	'',	NULL,	0,	'2019-12-12',	0,	NULL,	5,	'2017-05-02 00:00:00',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL),
(24,	24,	'',	'',	NULL,	0,	'2019-12-12',	0,	NULL,	5,	'2017-05-04 00:00:00',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL),
(25,	25,	'',	'',	NULL,	0,	'2019-12-12',	0,	NULL,	5,	'2017-05-04 00:00:00',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL),
(26,	26,	'',	'',	NULL,	0,	'2019-12-12',	0,	NULL,	5,	'2016-05-03 00:00:00',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL),
(27,	27,	'',	'',	NULL,	0,	'2019-12-12',	0,	NULL,	5,	'2017-05-01 00:00:00',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL),
(28,	28,	'',	'',	NULL,	0,	'2019-12-12',	0,	NULL,	5,	'2017-05-01 00:00:00',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL),
(29,	29,	'',	'',	NULL,	0,	'2019-12-12',	0,	NULL,	5,	'2017-05-02 00:00:00',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL),
(30,	30,	'',	'',	NULL,	0,	'2019-12-12',	0,	NULL,	5,	'2017-05-01 00:00:00',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL),
(31,	31,	'',	'',	NULL,	0,	'2019-12-12',	0,	NULL,	5,	'2017-04-30 00:00:00',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL),
(32,	32,	'',	'',	NULL,	0,	'2019-12-12',	0,	NULL,	5,	'2017-04-05 00:00:00',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL),
(33,	33,	'',	'',	NULL,	0,	'2019-12-12',	0,	NULL,	5,	'2017-05-04 00:00:00',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL),
(34,	34,	'',	'',	NULL,	0,	'2019-12-12',	0,	NULL,	5,	'2017-05-02 00:00:00',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL),
(35,	35,	'',	'',	NULL,	0,	'2019-12-12',	0,	NULL,	5,	'2017-05-02 00:00:00',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL),
(36,	36,	'',	'',	NULL,	0,	'2019-12-12',	0,	NULL,	5,	'2017-05-02 00:00:00',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL),
(37,	37,	'',	'',	NULL,	0,	'2019-12-12',	0,	NULL,	5,	'2017-05-02 00:00:00',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL),
(38,	38,	'',	'',	NULL,	0,	'2019-12-12',	0,	NULL,	5,	'2017-05-02 00:00:00',	'2019-12-12 13:15:59',	NULL,	14,	NULL,	NULL),
(39,	39,	'',	'',	NULL,	0,	'2019-12-17',	0,	NULL,	5,	'2019-12-17 14:58:22',	'2019-12-17 15:00:56',	NULL,	101,	NULL,	NULL),
(40,	40,	'',	'',	NULL,	0,	'2019-12-18',	0,	NULL,	5,	'2019-12-18 10:32:02',	'2019-12-18 10:41:35',	NULL,	101,	NULL,	NULL),
(41,	41,	'',	'',	NULL,	0,	'2019-12-20',	0,	NULL,	5,	'2019-12-20 08:58:15',	'2019-12-20 10:22:15',	NULL,	527,	NULL,	NULL),
(42,	42,	'',	'',	NULL,	0,	'2019-12-23',	0,	NULL,	2,	'2019-12-23 09:52:21',	'2019-12-23 10:54:39',	NULL,	1,	NULL,	NULL),
(43,	43,	'',	'',	NULL,	0,	'2019-12-16',	1,	'2019-12-23',	5,	'2019-12-23 10:10:46',	'2019-12-23 11:27:26',	NULL,	1,	NULL,	NULL),
(44,	44,	'',	'',	NULL,	0,	'2019-12-16',	1,	'2019-12-23',	5,	'2019-12-23 12:47:23',	'2019-12-23 12:51:20',	NULL,	101,	NULL,	NULL),
(45,	45,	'',	'',	NULL,	0,	'2019-12-16',	1,	'2019-12-23',	5,	'2019-12-23 13:53:59',	'2019-12-23 14:16:08',	NULL,	527,	NULL,	NULL),
(46,	46,	'',	'',	NULL,	0,	NULL,	0,	NULL,	1,	'2019-12-24 10:42:13',	'2019-12-24 10:42:13',	NULL,	53,	NULL,	NULL),
(47,	47,	'',	'',	NULL,	0,	NULL,	0,	NULL,	1,	'2019-12-30 09:44:51',	'2019-12-30 09:44:51',	NULL,	297,	NULL,	NULL),
(48,	48,	'<p>1.1 The internal audit assignment was conducted in accordance with the approved internal auditplan.</p><p>1.2 This report records the results of our internal audit findings and recommendations looking atpossible ways in which the controls and operations could be improved to overcome identifiedweaknesses in control and increase the adequacy, efficiency and effectiveness of controls basedon the risk identified.</p><p>1.3 The matters raised in this report are only those, which have come to our attention arising fromour audit that we believe they need to be brought to your attention. It is not a comprehensiverecord of all the matters arising and in particular we cannot be held responsible for reporting allrisks and all internal control weaknesses.</p><p>1.4 The maintenance of effective control measures still remains the responsibility of managementand not that of Internal Audit.</p>',	'#PR16 - #AP52 - #A47',	'<p>In summary, the audit overall went fairly well with some issues concerning the notification of people being interviewed.The interviews went well and it was clearly seen that the understanding and acceptance of our quality management system is increasing.</p><p>All the audit findings are listed above  in this report. The implementation of a number of improvements to the internal audit process has enabled us to get a better understanding ofhow closely the processes and procedures are being followed.The survey of people interviewed, has indicated that even more job specific questions could be asked.</p><p>This audit has demonstrated that everyone’s understanding of the quality management system is improving.We have also seen that there are things we can improve and commit to the continual improvement process.</p>',	0,	NULL,	0,	NULL,	1,	'2019-12-30 10:18:02',	'2019-12-30 10:36:35',	NULL,	527,	527,	NULL),
(49,	49,	'',	'',	NULL,	0,	NULL,	0,	NULL,	1,	'2019-12-31 09:39:06',	'2019-12-31 09:39:06',	NULL,	101,	NULL,	NULL),
(50,	50,	'',	'',	NULL,	0,	'2020-01-01',	0,	NULL,	5,	'2020-01-01 15:06:28',	'2020-01-01 15:59:57',	NULL,	1,	NULL,	NULL),
(51,	51,	'',	'',	NULL,	0,	'2019-12-27',	1,	'2020-01-03',	5,	'2020-01-03 10:56:59',	'2020-01-03 11:03:17',	NULL,	101,	NULL,	NULL),
(52,	52,	'',	'',	NULL,	0,	'2020-01-04',	0,	NULL,	5,	'2020-01-04 10:14:47',	'2020-01-04 11:14:35',	NULL,	527,	NULL,	NULL),
(53,	53,	'',	'',	NULL,	0,	'2020-01-06',	0,	NULL,	5,	'2020-01-06 09:58:48',	'2020-01-06 10:09:57',	NULL,	1,	NULL,	NULL),
(54,	54,	'',	'',	NULL,	0,	NULL,	0,	NULL,	1,	'2020-01-06 13:55:13',	'2020-01-06 13:55:13',	NULL,	1,	NULL,	NULL),
(55,	55,	'',	'',	NULL,	0,	'2020-01-07',	0,	NULL,	5,	'2020-01-07 08:51:06',	'2020-01-07 08:55:43',	NULL,	101,	NULL,	NULL),
(56,	56,	'',	'',	NULL,	0,	'2020-01-16',	0,	NULL,	4,	'2020-01-07 13:01:56',	'2020-01-16 11:16:24',	NULL,	1,	NULL,	NULL),
(57,	57,	'',	'',	NULL,	0,	'2020-01-07',	0,	NULL,	5,	'2020-01-07 13:36:38',	'2020-01-07 15:22:20',	NULL,	527,	NULL,	NULL),
(58,	58,	'',	'',	NULL,	0,	'2020-01-08',	0,	NULL,	5,	'2020-01-08 09:35:56',	'2020-01-08 10:44:50',	NULL,	101,	NULL,	NULL),
(59,	59,	'',	'',	NULL,	0,	NULL,	0,	NULL,	1,	'2020-01-08 17:07:12',	'2020-01-08 17:07:12',	NULL,	101,	NULL,	NULL),
(60,	60,	'',	'',	NULL,	0,	NULL,	0,	NULL,	1,	'2020-01-08 17:16:43',	'2020-01-08 17:16:43',	NULL,	101,	NULL,	NULL),
(61,	61,	'',	'',	NULL,	0,	NULL,	0,	NULL,	1,	'2020-01-09 08:54:11',	'2020-01-09 08:54:11',	NULL,	527,	NULL,	NULL),
(62,	62,	'',	'',	NULL,	0,	NULL,	0,	NULL,	1,	'2020-01-10 10:40:33',	'2020-01-10 10:40:33',	NULL,	535,	NULL,	NULL),
(63,	63,	'',	'',	NULL,	0,	'2020-01-16',	0,	NULL,	2,	'2020-01-16 09:24:01',	'2020-01-16 09:25:29',	NULL,	527,	NULL,	NULL),
(64,	64,	'',	'',	NULL,	0,	'2020-01-16',	0,	NULL,	5,	'2020-01-16 10:32:53',	'2020-01-16 11:23:42',	NULL,	1,	NULL,	NULL),
(65,	65,	'',	'',	NULL,	0,	'2020-01-17',	0,	NULL,	5,	'2020-01-17 09:26:47',	'2020-01-17 09:45:46',	NULL,	527,	NULL,	NULL),
(66,	66,	'',	'',	NULL,	0,	'2020-01-17',	0,	NULL,	2,	'2020-01-17 09:57:16',	'2020-01-17 10:09:26',	NULL,	527,	NULL,	NULL),
(67,	67,	'<p>1.1 The internal audit assignment was conducted in accordance with the approved internal auditplan.</p><p>1.2 This report records the results of our internal audit findings and recommendations looking atpossible ways in which the controls and operations could be improved to overcome identifiedweaknesses in control and increase the adequacy, efficiency and effectiveness of controls basedon the risk identified.</p><p>1.3 The matters raised in this report are only those, which have come to our attention arising fromour audit that we believe they need to be brought to your attention. It is not a comprehensiverecord of all the matters arising and in particular we cannot be held responsible for reporting allrisks and all internal control weaknesses.</p><p>1.4 The maintenance of effective control measures still remains the responsibility of managementand not that of Internal Audit.</p>',	'',	'<p>In summary, the audit overall went fairly well with some issues concerning the notification of people being interviewed.The interviews went well and it was clearly seen that the understanding and acceptance of our quality management system is increasing.</p><p>All the audit findings are listed above  in this report. The implementation of a number of improvements to the internal audit process has enabled us to get a better understanding ofhow closely the processes and procedures are being followed.The survey of people interviewed, has indicated that even more job specific questions could be asked.</p><p>This audit has demonstrated that everyone’s understanding of the quality management system is improving.We have also seen that there are things we can improve and commit to the continual improvement process.</p><p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur</p>',	0,	'2020-01-18',	0,	NULL,	5,	'2020-01-18 13:49:49',	'2020-01-18 14:52:54',	NULL,	527,	527,	NULL),
(68,	68,	'',	'',	NULL,	0,	'2020-01-20',	0,	NULL,	5,	'2020-01-20 14:50:30',	'2020-01-20 15:10:44',	NULL,	539,	NULL,	NULL),
(69,	69,	'',	'',	NULL,	0,	'2020-01-23',	0,	NULL,	5,	'2020-01-23 11:08:12',	'2020-01-23 13:54:08',	NULL,	539,	NULL,	NULL),
(70,	70,	'',	'',	NULL,	0,	'2020-01-25',	0,	NULL,	5,	'2020-01-25 15:52:33',	'2020-01-25 16:09:45',	NULL,	527,	NULL,	NULL),
(71,	71,	'',	'',	NULL,	0,	'2020-01-31',	0,	NULL,	5,	'2020-01-31 08:50:38',	'2020-01-31 09:59:03',	NULL,	527,	NULL,	NULL);

DROP TABLE IF EXISTS `audit_report_comment`;
CREATE TABLE `audit_report_comment` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `audit_report_id` int(11) NOT NULL,
  `audit_id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `comment` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_report_comment` (`id`, `audit_report_id`, `audit_id`, `user_id`, `comment`) VALUES
(1,	40,	40,	525,	'accepted'),
(2,	41,	41,	527,	'submit for review'),
(3,	43,	43,	1,	'Audit report has been auto approved'),
(4,	44,	44,	101,	'submit for review'),
(5,	44,	44,	1,	'Audit report has been auto approved'),
(6,	45,	45,	527,	'submit to hod'),
(7,	45,	45,	32,	'rejected'),
(8,	45,	45,	527,	'resubmited'),
(9,	45,	45,	1,	'Audit report has been auto approved'),
(10,	50,	50,	527,	'submit to HOD'),
(11,	50,	50,	53,	'Reected'),
(12,	50,	50,	1,	'Resubmitted to Hod'),
(13,	50,	50,	53,	'accepted'),
(14,	51,	51,	101,	'submit for revie'),
(15,	51,	51,	1,	'Audit report has been auto approved'),
(16,	52,	52,	527,	'submit to review'),
(17,	52,	52,	70,	'rejected'),
(18,	52,	52,	527,	'resubmit to hod'),
(19,	52,	52,	70,	'accepted'),
(20,	53,	53,	80,	'publisheddddddddddddddddddd'),
(21,	55,	55,	101,	'submit to review'),
(22,	55,	55,	39,	'accepted'),
(23,	57,	57,	527,	'submit for review'),
(24,	57,	57,	53,	'rejected'),
(25,	57,	57,	527,	'submited'),
(26,	57,	57,	53,	'aaccepted'),
(27,	58,	58,	101,	'submit to review'),
(28,	58,	58,	525,	'accepted'),
(29,	56,	56,	53,	'gtt'),
(30,	56,	56,	1,	'submit to hod'),
(31,	63,	63,	527,	'dubmit to hod jan 16'),
(32,	64,	64,	1,	'ejekdj'),
(33,	64,	64,	1,	'submited fr reviw'),
(34,	64,	64,	1,	'rejected'),
(35,	64,	64,	527,	'submit for revire'),
(36,	56,	56,	1,	'rejectd'),
(37,	56,	56,	1,	'submit for review'),
(38,	56,	56,	1,	'rejected'),
(39,	64,	64,	1,	'rejectcvd'),
(40,	64,	64,	1,	'submitted for rreview'),
(41,	64,	64,	1,	'accepted'),
(42,	65,	65,	527,	'jg,fy'),
(43,	65,	65,	70,	'adfhzdf'),
(44,	65,	65,	527,	'thrty'),
(45,	65,	65,	70,	'dgg'),
(46,	66,	66,	527,	'submit to hod'),
(47,	67,	67,	527,	'submit to review'),
(48,	67,	67,	81,	'rejected'),
(49,	67,	67,	527,	'submit to review'),
(50,	67,	67,	81,	'accepted'),
(51,	69,	69,	539,	'submit to review'),
(52,	69,	69,	538,	'accepted..'),
(53,	70,	70,	527,	'submit for review'),
(54,	70,	70,	527,	'submit for review'),
(55,	71,	71,	527,	'submited to review'),
(56,	71,	71,	69,	'rejected'),
(57,	71,	71,	527,	'submit to review'),
(58,	71,	71,	69,	'accepted');

DROP TABLE IF EXISTS `audit_report_statuses`;
CREATE TABLE `audit_report_statuses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_draft` int(11) NOT NULL DEFAULT '0',
  `is_submitted` int(11) NOT NULL DEFAULT '0',
  `is_accepted` int(11) NOT NULL DEFAULT '0',
  `is_rejected` int(11) NOT NULL DEFAULT '0',
  `is_published` int(11) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `updated_by` int(10) unsigned DEFAULT NULL,
  `deleted_by` int(10) unsigned DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_report_statuses` (`id`, `title`, `label`, `is_draft`, `is_submitted`, `is_accepted`, `is_rejected`, `is_published`, `created_at`, `updated_at`, `created_by`, `updated_by`, `deleted_by`, `status`) VALUES
(1,	'Draft',	'default',	1,	0,	0,	0,	0,	'2019-05-20 09:55:15',	'2019-05-20 09:55:15',	1,	NULL,	NULL,	1),
(2,	'Submitted For Review',	'primary',	0,	1,	0,	0,	0,	'2019-05-20 09:55:15',	'2019-05-20 09:55:15',	0,	NULL,	NULL,	1),
(3,	'Accepted',	'success',	0,	0,	1,	0,	0,	'2019-05-20 09:55:15',	'2019-05-20 09:55:15',	1,	NULL,	NULL,	1),
(4,	'Rejected',	'warning',	0,	0,	0,	1,	0,	'2019-05-20 09:55:15',	'2019-05-20 09:55:15',	1,	NULL,	NULL,	1),
(5,	'Published',	'success',	0,	0,	0,	0,	1,	'2019-05-20 09:55:15',	'2019-05-20 09:55:15',	1,	NULL,	NULL,	1);

DROP TABLE IF EXISTS `audit_report_versions`;
CREATE TABLE `audit_report_versions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `audit_report_id` int(11) NOT NULL,
  `report_version` int(11) NOT NULL,
  `added_date` date DEFAULT NULL,
  `submitted_at` date DEFAULT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_report_versions` (`id`, `audit_report_id`, `report_version`, `added_date`, `submitted_at`, `status`) VALUES
(1,	39,	1,	'2019-12-17',	'2019-12-17',	'accepted'),
(2,	40,	1,	'2019-12-18',	'2019-12-18',	'accepted'),
(3,	41,	1,	'2019-12-20',	'2019-12-20',	'accepted'),
(4,	42,	1,	'2019-12-23',	'2019-12-23',	'rejected'),
(5,	43,	1,	'2019-12-23',	'2019-12-16',	'accepted'),
(6,	44,	1,	'2019-12-23',	'2019-12-16',	'accepted'),
(7,	45,	1,	'2019-12-23',	'2019-12-23',	'rejected'),
(8,	45,	2,	'2019-12-23',	'2019-12-16',	'accepted'),
(9,	50,	1,	'2020-01-01',	'2020-01-01',	'rejected'),
(10,	50,	2,	'2020-01-01',	'2020-01-01',	'accepted'),
(11,	51,	1,	'2020-01-03',	'2019-12-27',	'accepted'),
(12,	52,	1,	'2020-01-04',	'2020-01-04',	'rejected'),
(13,	52,	2,	'2020-01-04',	'2020-01-04',	'accepted'),
(14,	53,	1,	'2020-01-06',	'2020-01-06',	'accepted'),
(15,	55,	1,	'2020-01-07',	'2020-01-07',	'accepted'),
(16,	57,	1,	'2020-01-07',	'2020-01-07',	'rejected'),
(17,	57,	2,	'2020-01-07',	'2020-01-07',	'accepted'),
(18,	58,	1,	'2020-01-08',	'2020-01-08',	'accepted'),
(19,	56,	1,	'2020-01-16',	'2020-01-16',	'rejected'),
(20,	64,	1,	'2020-01-16',	'2020-01-16',	'rejected'),
(21,	64,	2,	'2020-01-16',	'2020-01-16',	'rejected'),
(22,	56,	2,	'2020-01-16',	'2020-01-16',	'rejected'),
(23,	56,	3,	'2020-01-16',	'2020-01-16',	'rejected'),
(24,	64,	3,	'2020-01-16',	'2020-01-16',	'rejected'),
(25,	64,	4,	'2020-01-16',	'2020-01-16',	'accepted'),
(26,	65,	1,	'2020-01-17',	'2020-01-17',	'rejected'),
(27,	65,	2,	'2020-01-17',	'2020-01-17',	'accepted'),
(28,	67,	1,	'2020-01-18',	'2020-01-18',	'rejected'),
(29,	67,	2,	'2020-01-18',	'2020-01-18',	'accepted'),
(30,	68,	1,	'2020-01-20',	'2020-01-20',	'accepted'),
(31,	69,	1,	'2020-01-23',	'2020-01-23',	'accepted'),
(32,	70,	1,	'2020-01-25',	'2020-01-25',	'rejected'),
(33,	70,	2,	'2020-01-25',	'2020-01-25',	'accepted'),
(34,	71,	1,	'2020-01-31',	'2020-01-31',	'rejected'),
(35,	71,	2,	'2020-01-31',	'2020-01-31',	'accepted');

DROP TABLE IF EXISTS `audit_schedules`;
CREATE TABLE `audit_schedules` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `audit_plan_id` int(10) unsigned NOT NULL,
  `audit_type_id` int(10) unsigned DEFAULT NULL,
  `division_id` int(11) DEFAULT NULL,
  `section_id` int(11) DEFAULT NULL,
  `project_id` int(11) DEFAULT NULL,
  `audit_scope_id` int(11) DEFAULT NULL,
  `supplier_id` int(10) unsigned DEFAULT NULL,
  `customer_id` int(10) unsigned DEFAULT NULL,
  `certification_body_id` int(10) unsigned DEFAULT NULL,
  `branch_id` int(10) unsigned DEFAULT NULL,
  `subsidiary_id` int(10) unsigned DEFAULT NULL,
  `location_id` int(11) DEFAULT NULL,
  `audit_area_id` int(10) unsigned DEFAULT NULL,
  `department_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_schedules` (`id`, `audit_plan_id`, `audit_type_id`, `division_id`, `section_id`, `project_id`, `audit_scope_id`, `supplier_id`, `customer_id`, `certification_body_id`, `branch_id`, `subsidiary_id`, `location_id`, `audit_area_id`, `department_id`, `created_at`, `updated_at`, `status`) VALUES
(1,	1,	0,	2,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	5,	'2019-12-12 13:15:18',	'2019-12-12 13:15:18',	1),
(2,	2,	0,	2,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	14,	'2019-12-12 13:15:18',	'2019-12-12 13:15:18',	1),
(3,	3,	0,	5,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	13,	'2019-12-12 13:15:18',	'2019-12-12 13:15:18',	1),
(4,	4,	0,	5,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	13,	'2019-12-12 13:15:18',	'2019-12-12 13:15:18',	1),
(5,	5,	0,	2,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	4,	'2019-12-12 13:15:18',	'2019-12-12 13:15:18',	1),
(6,	6,	0,	2,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	4,	'2019-12-12 13:15:18',	'2019-12-12 13:15:18',	1),
(7,	7,	0,	4,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	11,	'2019-12-12 13:15:18',	'2019-12-12 13:15:18',	1),
(8,	8,	0,	4,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	10,	'2019-12-12 13:15:18',	'2019-12-12 13:15:18',	1),
(9,	9,	0,	3,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	18,	'2019-12-12 13:15:18',	'2019-12-12 13:15:18',	1),
(10,	10,	0,	3,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	8,	'2019-12-12 13:15:18',	'2019-12-12 13:15:18',	1),
(11,	11,	0,	3,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	9,	'2019-12-12 13:15:18',	'2019-12-12 13:15:18',	1),
(12,	12,	0,	3,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	7,	'2019-12-12 13:15:18',	'2019-12-12 13:15:18',	1),
(13,	13,	0,	5,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	16,	'2019-12-12 13:15:18',	'2019-12-12 13:15:18',	1),
(14,	14,	0,	5,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	14,	'2019-12-12 13:15:18',	'2019-12-12 13:15:18',	1),
(15,	15,	0,	5,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	15,	'2019-12-12 13:15:18',	'2019-12-12 13:15:18',	1),
(16,	16,	0,	4,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	12,	'2019-12-12 13:15:18',	'2019-12-12 13:15:18',	1),
(17,	17,	0,	4,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	12,	'2019-12-12 13:15:18',	'2019-12-12 13:15:18',	1),
(18,	18,	0,	4,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	12,	'2019-12-12 13:15:18',	'2019-12-12 13:15:18',	1),
(19,	19,	0,	2,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	6,	'2019-12-12 13:15:19',	'2019-12-12 13:15:19',	1),
(20,	20,	0,	1,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	2,	'2019-12-12 13:15:19',	'2019-12-12 13:15:19',	1),
(21,	21,	0,	2,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	5,	'2019-12-12 13:15:19',	'2019-12-12 13:15:19',	1),
(22,	22,	0,	5,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	13,	'2019-12-12 13:15:19',	'2019-12-12 13:15:19',	1),
(23,	23,	0,	5,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	13,	'2019-12-12 13:15:19',	'2019-12-12 13:15:19',	1),
(24,	24,	0,	2,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	4,	'2019-12-12 13:15:19',	'2019-12-12 13:15:19',	1),
(25,	25,	0,	2,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	4,	'2019-12-12 13:15:19',	'2019-12-12 13:15:19',	1),
(26,	26,	0,	4,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	11,	'2019-12-12 13:15:19',	'2019-12-12 13:15:19',	1),
(27,	27,	0,	4,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	10,	'2019-12-12 13:15:19',	'2019-12-12 13:15:19',	1),
(28,	28,	0,	3,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	18,	'2019-12-12 13:15:19',	'2019-12-12 13:15:19',	1),
(29,	29,	0,	3,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	8,	'2019-12-12 13:15:19',	'2019-12-12 13:15:19',	1),
(30,	30,	0,	3,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	9,	'2019-12-12 13:15:19',	'2019-12-12 13:15:19',	1),
(31,	31,	0,	3,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	7,	'2019-12-12 13:15:19',	'2019-12-12 13:15:19',	1),
(32,	32,	0,	5,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	16,	'2019-12-12 13:15:19',	'2019-12-12 13:15:19',	1),
(33,	33,	0,	5,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	14,	'2019-12-12 13:15:19',	'2019-12-12 13:15:19',	1),
(34,	34,	0,	5,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	15,	'2019-12-12 13:15:19',	'2019-12-12 13:15:19',	1),
(35,	35,	0,	4,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	12,	'2019-12-12 13:15:19',	'2019-12-12 13:15:19',	1),
(36,	36,	0,	4,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	12,	'2019-12-12 13:15:19',	'2019-12-12 13:15:19',	1),
(37,	37,	0,	4,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	12,	'2019-12-12 13:15:19',	'2019-12-12 13:15:19',	1),
(38,	38,	0,	1,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	2,	'2019-12-12 13:15:19',	'2019-12-12 13:15:19',	1),
(39,	39,	0,	1,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	1,	'2019-12-17 14:57:01',	'2019-12-17 14:57:01',	1),
(40,	40,	0,	5,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	13,	'2019-12-18 10:27:50',	'2019-12-18 10:27:50',	1),
(44,	41,	0,	2,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	4,	'2019-12-20 08:55:44',	'2019-12-20 08:55:44',	1),
(45,	41,	0,	2,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	4,	'2019-12-20 08:55:44',	'2019-12-20 08:55:44',	1),
(47,	42,	0,	2,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	4,	'2019-12-20 13:50:53',	'2019-12-20 13:50:53',	1),
(48,	42,	0,	2,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	4,	'2019-12-20 13:50:53',	'2019-12-20 13:50:53',	1),
(51,	45,	0,	5,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	14,	'2019-12-21 14:08:25',	'2019-12-21 14:08:25',	1),
(52,	46,	0,	2,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	4,	'2019-12-21 14:14:57',	'2019-12-21 14:14:57',	1),
(53,	47,	0,	2,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	4,	'2019-12-23 09:49:52',	'2019-12-23 09:49:52',	1),
(54,	48,	0,	1,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	1,	'2019-12-23 10:05:44',	'2019-12-23 10:05:44',	1),
(55,	48,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	'2019-12-23 10:05:44',	'2019-12-23 10:05:44',	1),
(56,	49,	0,	5,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	13,	'2019-12-23 11:31:44',	'2019-12-23 11:31:44',	1),
(57,	50,	0,	4,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	10,	'2019-12-23 13:33:28',	'2019-12-23 13:33:28',	1),
(58,	51,	0,	5,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	16,	'2019-12-24 10:39:35',	'2019-12-24 10:39:35',	1),
(62,	52,	0,	5,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	13,	'2019-12-30 09:07:37',	'2019-12-30 09:07:37',	1),
(63,	52,	0,	5,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	13,	'2019-12-30 09:07:37',	'2019-12-30 09:07:37',	1),
(64,	52,	0,	5,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	13,	'2019-12-30 09:07:37',	'2019-12-30 09:07:37',	1),
(65,	53,	0,	1,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	1,	'2019-12-30 10:14:57',	'2019-12-30 10:14:57',	1),
(66,	59,	0,	1,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	1,	'2019-12-30 12:53:23',	'2019-12-30 12:53:23',	1),
(67,	60,	0,	1,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	1,	'2019-12-30 13:31:18',	'2019-12-30 13:31:18',	1),
(68,	62,	0,	2,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	4,	'2019-12-31 09:36:21',	'2019-12-31 09:36:21',	1),
(69,	63,	0,	1,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	1,	'2020-01-01 12:11:36',	'2020-01-01 12:11:36',	1),
(71,	64,	0,	2,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	4,	'2020-01-03 09:37:05',	'2020-01-03 09:37:05',	1),
(74,	65,	0,	2,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	4,	'2020-01-03 10:23:29',	'2020-01-03 10:23:29',	1),
(76,	67,	0,	2,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	4,	'2020-01-03 10:46:49',	'2020-01-03 10:46:49',	1),
(77,	68,	0,	5,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	13,	'2020-01-03 12:38:11',	'2020-01-03 12:38:11',	1),
(81,	69,	0,	2,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	4,	'2020-01-04 09:01:00',	'2020-01-04 09:01:00',	1),
(82,	70,	0,	5,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	14,	'2020-01-06 09:56:14',	'2020-01-06 09:56:14',	1),
(89,	71,	0,	5,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	14,	'2020-01-06 13:43:23',	'2020-01-06 13:43:23',	1),
(90,	71,	0,	5,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	14,	'2020-01-06 13:43:23',	'2020-01-06 13:43:23',	1),
(91,	72,	0,	2,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	4,	'2020-01-06 16:07:21',	'2020-01-06 16:07:21',	1),
(92,	73,	0,	5,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	16,	'2020-01-07 08:50:53',	'2020-01-07 08:50:53',	1),
(93,	82,	0,	1,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	1,	'2020-01-07 12:48:08',	'2020-01-07 12:48:08',	1),
(94,	83,	0,	1,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	1,	'2020-01-07 13:22:39',	'2020-01-07 13:22:39',	1),
(95,	86,	0,	5,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	13,	'2020-01-08 09:15:58',	'2020-01-08 09:15:58',	1),
(97,	87,	0,	2,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	4,	'2020-01-08 17:06:45',	'2020-01-08 17:06:45',	1),
(99,	89,	0,	2,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	4,	'2020-01-08 17:14:06',	'2020-01-08 17:14:06',	1),
(100,	90,	0,	2,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	4,	'2020-01-08 17:14:07',	'2020-01-08 17:14:07',	1),
(102,	92,	0,	2,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	4,	'2020-01-08 17:14:08',	'2020-01-08 17:14:08',	1),
(103,	91,	0,	2,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	4,	'2020-01-08 17:15:18',	'2020-01-08 17:15:18',	1),
(106,	93,	0,	2,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	4,	'2020-01-09 08:45:55',	'2020-01-09 08:45:55',	1),
(108,	94,	0,	2,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	5,	'2020-01-09 08:52:26',	'2020-01-09 08:52:26',	1),
(109,	96,	0,	2,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	5,	'2020-01-09 12:36:26',	'2020-01-09 12:36:26',	1),
(110,	97,	0,	2,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	5,	'2020-01-09 12:41:18',	'2020-01-09 12:41:18',	1),
(113,	98,	0,	4,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	10,	'2020-01-10 09:13:08',	'2020-01-10 09:13:08',	1),
(114,	98,	0,	4,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	10,	'2020-01-10 09:13:08',	'2020-01-10 09:13:08',	1),
(115,	99,	0,	2,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	4,	'2020-01-16 09:18:27',	'2020-01-16 09:18:27',	1),
(116,	100,	0,	2,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	4,	'2020-01-16 09:18:36',	'2020-01-16 09:18:36',	1),
(117,	101,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	'2020-01-16 10:00:29',	'2020-01-16 10:00:29',	1),
(118,	102,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	'2020-01-16 10:28:44',	'2020-01-16 10:28:44',	1),
(119,	103,	0,	2,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	4,	'2020-01-17 09:11:16',	'2020-01-17 09:11:16',	1),
(120,	104,	0,	2,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	4,	'2020-01-17 09:15:50',	'2020-01-17 09:15:50',	1),
(121,	105,	0,	2,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	4,	'2020-01-17 09:18:09',	'2020-01-17 09:18:09',	1),
(123,	106,	0,	2,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	4,	'2020-01-17 09:20:34',	'2020-01-17 09:20:34',	1),
(124,	107,	0,	2,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	4,	'2020-01-17 09:52:16',	'2020-01-17 09:52:16',	1),
(127,	108,	0,	3,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	18,	'2020-01-18 13:31:24',	'2020-01-18 13:31:24',	1),
(128,	108,	0,	3,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	18,	'2020-01-18 13:31:24',	'2020-01-18 13:31:24',	1),
(130,	109,	0,	1,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	27,	'2020-01-20 14:33:15',	'2020-01-20 14:33:15',	1),
(132,	88,	0,	2,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	4,	'2020-01-21 15:32:43',	'2020-01-21 15:32:43',	1),
(133,	110,	0,	1,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	27,	'2020-01-22 15:33:04',	'2020-01-22 15:33:04',	1),
(134,	111,	0,	1,	0,	0,	0,	0,	0,	0,	3,	0,	0,	0,	27,	'2020-01-25 15:36:23',	'2020-01-25 15:36:23',	1),
(136,	113,	0,	2,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	4,	'2020-01-29 16:20:22',	'2020-01-29 16:20:22',	1),
(138,	114,	0,	2,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	4,	'2020-01-29 16:21:28',	'2020-01-29 16:21:28',	1),
(140,	115,	0,	5,	0,	0,	0,	0,	0,	0,	2,	0,	0,	0,	15,	'2020-01-30 13:57:22',	'2020-01-30 13:57:22',	1);

DROP TABLE IF EXISTS `audit_schedule_auditee`;
CREATE TABLE `audit_schedule_auditee` (
  `audit_schedule_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`audit_schedule_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_schedule_auditee` (`audit_schedule_id`, `user_id`) VALUES
(1,	22),
(2,	8),
(3,	83),
(4,	8),
(5,	8),
(5,	9),
(5,	13),
(5,	38),
(6,	17),
(7,	79),
(8,	20),
(9,	68),
(10,	11),
(10,	49),
(10,	51),
(11,	18),
(12,	64),
(12,	84),
(13,	54),
(13,	89),
(14,	77),
(14,	80),
(15,	86),
(16,	29),
(17,	57),
(18,	26),
(18,	57),
(19,	75),
(20,	30),
(20,	67),
(21,	22),
(22,	14),
(22,	45),
(22,	367),
(23,	27),
(24,	8),
(24,	44),
(24,	70),
(24,	88),
(25,	8),
(25,	44),
(25,	70),
(25,	88),
(26,	40),
(26,	82),
(27,	20),
(28,	68),
(28,	81),
(29,	10),
(30,	18),
(31,	64),
(31,	66),
(32,	39),
(32,	89),
(33,	8),
(34,	69),
(34,	86),
(35,	8),
(36,	12),
(37,	57),
(38,	8),
(39,	1),
(40,	529),
(41,	70),
(42,	70),
(43,	477),
(44,	70),
(45,	477),
(46,	532),
(47,	532),
(48,	532),
(51,	513),
(52,	100),
(53,	70),
(53,	477),
(54,	243),
(54,	353),
(54,	531),
(55,	243),
(56,	61),
(57,	32),
(58,	39),
(59,	529),
(60,	27),
(61,	37),
(62,	529),
(63,	27),
(64,	37),
(65,	1),
(66,	1),
(67,	1),
(68,	70),
(69,	243),
(69,	353),
(70,	101),
(71,	101),
(72,	8),
(73,	8),
(74,	8),
(76,	532),
(77,	529),
(78,	101),
(79,	101),
(79,	477),
(80,	101),
(80,	477),
(81,	101),
(81,	477),
(82,	383),
(83,	383),
(84,	383),
(85,	383),
(86,	383),
(87,	383),
(88,	383),
(89,	383),
(90,	383),
(91,	17),
(92,	161),
(93,	243),
(93,	531),
(94,	243),
(95,	349),
(96,	70),
(97,	70),
(98,	70),
(99,	70),
(100,	70),
(101,	70),
(102,	70),
(103,	70),
(103,	100),
(104,	70),
(104,	281),
(105,	70),
(105,	281),
(106,	70),
(106,	281),
(107,	22),
(108,	22),
(108,	153),
(109,	88),
(110,	88),
(111,	32),
(111,	369),
(111,	401),
(112,	147),
(112,	343),
(113,	32),
(113,	369),
(113,	401),
(114,	147),
(114,	343),
(115,	70),
(116,	70),
(117,	531),
(118,	1),
(119,	532),
(120,	13),
(121,	281),
(122,	17),
(123,	17),
(124,	13),
(125,	393),
(125,	511),
(126,	68),
(126,	351),
(127,	393),
(127,	511),
(128,	68),
(128,	351),
(129,	538),
(130,	538),
(131,	70),
(132,	70),
(133,	62),
(134,	538),
(134,	539),
(135,	477),
(136,	477),
(137,	70),
(138,	70),
(139,	46),
(139,	86),
(139,	441),
(140,	46),
(140,	86),
(140,	441);

DROP TABLE IF EXISTS `audit_schedule_auditor`;
CREATE TABLE `audit_schedule_auditor` (
  `audit_schedule_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`audit_schedule_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_schedule_auditor` (`audit_schedule_id`, `user_id`) VALUES
(1,	53),
(2,	53),
(3,	68),
(3,	89),
(4,	68),
(4,	89),
(5,	71),
(6,	71),
(7,	8),
(8,	8),
(9,	66),
(10,	22),
(11,	22),
(12,	22),
(13,	17),
(13,	66),
(14,	89),
(15,	10),
(15,	66),
(16,	42),
(17,	42),
(18,	42),
(19,	53),
(20,	71),
(21,	53),
(22,	20),
(23,	20),
(24,	71),
(25,	71),
(26,	42),
(27,	42),
(27,	44),
(28,	42),
(28,	44),
(29,	66),
(30,	8),
(31,	8),
(32,	68),
(32,	71),
(33,	14),
(34,	10),
(34,	66),
(35,	8),
(35,	58),
(36,	8),
(36,	58),
(37,	8),
(38,	14),
(39,	8),
(39,	101),
(40,	8),
(40,	101),
(41,	8),
(41,	101),
(42,	8),
(42,	101),
(43,	8),
(43,	101),
(43,	527),
(44,	8),
(44,	101),
(45,	8),
(45,	101),
(45,	527),
(46,	8),
(46,	101),
(47,	8),
(47,	101),
(48,	8),
(48,	101),
(51,	101),
(51,	329),
(52,	101),
(52,	297),
(52,	329),
(53,	329),
(54,	79),
(54,	101),
(54,	527),
(55,	66),
(55,	79),
(56,	46),
(56,	101),
(56,	297),
(56,	527),
(57,	527),
(58,	8),
(58,	53),
(59,	22),
(59,	297),
(60,	5),
(60,	297),
(61,	102),
(61,	297),
(62,	22),
(62,	297),
(63,	5),
(63,	297),
(64,	102),
(64,	297),
(65,	527),
(66,	527),
(67,	527),
(68,	101),
(69,	5),
(69,	527),
(70,	22),
(71,	22),
(72,	101),
(73,	101),
(74,	101),
(76,	101),
(77,	101),
(78,	329),
(78,	527),
(79,	329),
(79,	527),
(80,	329),
(80,	527),
(81,	329),
(81,	527),
(82,	1),
(83,	1),
(84,	1),
(85,	1),
(86,	1),
(87,	1),
(88,	1),
(89,	1),
(90,	1),
(91,	101),
(92,	101),
(93,	527),
(94,	527),
(95,	101),
(96,	101),
(97,	101),
(98,	101),
(99,	101),
(100,	101),
(101,	101),
(102,	101),
(103,	101),
(104,	527),
(105,	527),
(106,	527),
(107,	527),
(108,	53),
(108,	527),
(109,	22),
(110,	101),
(111,	535),
(112,	535),
(113,	535),
(114,	535),
(115,	527),
(116,	527),
(117,	527),
(118,	527),
(119,	527),
(120,	527),
(121,	527),
(122,	527),
(123,	527),
(124,	527),
(125,	527),
(126,	527),
(127,	527),
(128,	527),
(129,	539),
(130,	539),
(131,	101),
(132,	101),
(133,	539),
(134,	8),
(134,	527),
(135,	8),
(136,	8),
(137,	8),
(138,	8),
(139,	8),
(139,	527),
(140,	8),
(140,	527);

DROP TABLE IF EXISTS `audit_schedule_chats`;
CREATE TABLE `audit_schedule_chats` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `audit_plan_id` int(10) unsigned NOT NULL,
  `audit_schedule_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `updated_by` int(10) unsigned DEFAULT NULL,
  `deleted_by` int(10) unsigned DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `audit_schedule_closing_meeting_users`;
CREATE TABLE `audit_schedule_closing_meeting_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `audit_schedule_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `audit_schedule_details`;
CREATE TABLE `audit_schedule_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `audit_schedule_id` int(10) unsigned NOT NULL,
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `opening_meeting_start_time` datetime DEFAULT NULL,
  `opening_meeting_end_time` datetime DEFAULT NULL,
  `closing_meeting_start_time` datetime DEFAULT NULL,
  `closing_meeting_end_time` datetime DEFAULT NULL,
  `version` char(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_schedule_details` (`id`, `audit_schedule_id`, `start_date`, `end_date`, `opening_meeting_start_time`, `opening_meeting_end_time`, `closing_meeting_start_time`, `closing_meeting_end_time`, `version`, `created_at`, `updated_at`) VALUES
(1,	1,	'2018-12-16 00:00:00',	'2018-12-16 00:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-12 13:15:18',	'2019-12-12 13:15:18'),
(2,	2,	'2018-12-16 00:00:00',	'2018-12-16 00:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-12 13:15:18',	'2019-12-12 13:15:18'),
(3,	3,	'2018-12-16 00:00:00',	'2018-12-16 00:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-12 13:15:18',	'2019-12-12 13:15:18'),
(4,	4,	'2018-12-16 00:00:00',	'2018-12-16 00:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-12 13:15:18',	'2019-12-12 13:15:18'),
(5,	5,	'2018-12-16 00:00:00',	'2018-12-16 00:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-12 13:15:18',	'2019-12-12 13:15:18'),
(6,	6,	'2018-12-17 00:00:00',	'2018-12-17 00:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-12 13:15:18',	'2019-12-12 13:15:18'),
(7,	7,	'2018-12-17 00:00:00',	'2018-12-17 00:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-12 13:15:18',	'2019-12-12 13:15:18'),
(8,	8,	'2018-12-17 00:00:00',	'2018-12-17 00:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-12 13:15:18',	'2019-12-12 13:15:18'),
(9,	9,	'2018-12-17 00:00:00',	'2018-12-17 00:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-12 13:15:18',	'2019-12-12 13:15:18'),
(10,	10,	'2018-12-17 00:00:00',	'2018-12-17 00:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-12 13:15:18',	'2019-12-12 13:15:18'),
(11,	11,	'2018-12-18 00:00:00',	'2018-12-18 00:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-12 13:15:18',	'2019-12-12 13:15:18'),
(12,	12,	'2018-12-18 00:00:00',	'2018-12-18 00:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-12 13:15:18',	'2019-12-12 13:15:18'),
(13,	13,	'2018-12-18 00:00:00',	'2018-12-18 00:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-12 13:15:18',	'2019-12-12 13:15:18'),
(14,	14,	'2018-12-18 00:00:00',	'2018-12-18 00:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-12 13:15:18',	'2019-12-12 13:15:18'),
(15,	15,	'2018-12-18 00:00:00',	'2018-12-18 00:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-12 13:15:18',	'2019-12-12 13:15:18'),
(16,	16,	'2018-12-18 00:00:00',	'2018-12-18 00:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-12 13:15:18',	'2019-12-12 13:15:18'),
(17,	17,	'2018-12-19 00:00:00',	'2018-12-19 00:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-12 13:15:18',	'2019-12-12 13:15:18'),
(18,	18,	'2018-12-19 00:00:00',	'2018-12-19 00:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-12 13:15:18',	'2019-12-12 13:15:18'),
(19,	19,	'2018-12-19 00:00:00',	'2018-12-19 00:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-12 13:15:19',	'2019-12-12 13:15:19'),
(20,	20,	'2018-12-19 00:00:00',	'2018-12-19 00:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-12 13:15:19',	'2019-12-12 13:15:19'),
(21,	21,	'2017-04-30 00:00:00',	'2017-04-30 00:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-12 13:15:19',	'2019-12-12 13:15:19'),
(22,	22,	'2017-05-02 00:00:00',	'2017-05-02 00:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-12 13:15:19',	'2019-12-12 13:15:19'),
(23,	23,	'2017-05-02 00:00:00',	'2017-05-02 00:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-12 13:15:19',	'2019-12-12 13:15:19'),
(24,	24,	'2017-04-30 00:00:00',	'2017-04-30 00:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-12 13:15:19',	'2019-12-12 13:15:19'),
(25,	25,	'2017-05-01 00:00:00',	'2017-05-01 00:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-12 13:15:19',	'2019-12-12 13:15:19'),
(26,	26,	'2017-04-30 00:00:00',	'2017-04-30 00:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-12 13:15:19',	'2019-12-12 13:15:19'),
(27,	27,	'2017-05-01 00:00:00',	'2017-05-01 00:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-12 13:15:19',	'2019-12-12 13:15:19'),
(28,	28,	'2017-04-30 00:00:00',	'2017-04-30 00:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-12 13:15:19',	'2019-12-12 13:15:19'),
(29,	29,	'2017-05-01 00:00:00',	'2017-05-01 00:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-12 13:15:19',	'2019-12-12 13:15:19'),
(30,	30,	'2017-05-01 00:00:00',	'2017-05-01 00:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-12 13:15:19',	'2019-12-12 13:15:19'),
(31,	31,	'2017-05-01 00:00:00',	'2017-05-01 00:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-12 13:15:19',	'2019-12-12 13:15:19'),
(32,	32,	'2017-05-01 00:00:00',	'2017-05-01 00:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-12 13:15:19',	'2019-12-12 13:15:19'),
(33,	33,	'2017-05-01 00:00:00',	'2017-05-01 00:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-12 13:15:19',	'2019-12-12 13:15:19'),
(34,	34,	'2017-05-02 00:00:00',	'2017-05-02 00:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-12 13:15:19',	'2019-12-12 13:15:19'),
(35,	35,	'2017-05-02 00:00:00',	'2017-05-02 00:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-12 13:15:19',	'2019-12-12 13:15:19'),
(36,	36,	'2017-05-02 00:00:00',	'2017-05-02 00:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-12 13:15:19',	'2019-12-12 13:15:19'),
(37,	37,	'2017-05-02 00:00:00',	'2017-05-02 00:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-12 13:15:19',	'2019-12-12 13:15:19'),
(38,	38,	'2017-05-02 00:00:00',	'2017-05-02 00:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-12 13:15:19',	'2019-12-12 13:15:19'),
(39,	39,	'2019-12-01 07:00:00',	'2019-12-31 08:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-17 14:57:01',	'2019-12-17 14:57:01'),
(40,	40,	'2019-12-01 07:00:00',	'2019-12-31 10:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-18 10:27:50',	'2019-12-18 10:27:50'),
(41,	41,	'2019-10-01 07:00:00',	'2019-10-31 08:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-20 08:52:16',	'2019-12-20 08:52:16'),
(42,	42,	'2019-10-01 07:00:00',	'2019-10-01 08:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-20 08:54:22',	'2019-12-20 08:54:22'),
(43,	43,	'2019-10-10 08:00:00',	'2019-10-10 10:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-20 08:54:22',	'2019-12-20 08:54:22'),
(44,	44,	'2019-10-01 07:00:00',	'2019-10-01 08:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-20 08:55:44',	'2019-12-20 08:55:44'),
(45,	45,	'2019-10-10 08:00:00',	'2019-10-10 10:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-20 08:55:44',	'2019-12-20 08:55:44'),
(46,	46,	'2019-11-06 07:00:00',	'2019-11-07 08:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-20 13:11:46',	'2019-12-20 13:11:46'),
(47,	47,	'2019-11-06 07:00:00',	'2019-11-07 08:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-20 13:50:53',	'2019-12-20 13:50:53'),
(48,	48,	'2019-11-06 09:00:00',	'2019-11-15 11:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-20 13:50:53',	'2019-12-20 13:50:53'),
(51,	51,	'2019-01-01 08:00:00',	'2019-01-31 11:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-21 14:08:25',	'2019-12-21 14:08:25'),
(52,	52,	'2019-02-01 07:00:00',	'2019-02-28 14:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-21 14:14:57',	'2019-12-21 14:14:57'),
(53,	53,	'2019-10-01 08:00:00',	'2019-10-01 16:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-23 09:49:52',	'2019-12-23 09:49:52'),
(54,	54,	'2019-11-07 07:00:00',	'2019-11-08 10:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-23 10:05:44',	'2019-12-23 10:05:44'),
(55,	55,	'2019-11-08 14:00:00',	'2019-11-08 14:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-23 10:05:44',	'2019-12-23 10:05:44'),
(56,	56,	'2019-12-01 07:00:00',	'2019-12-31 07:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-23 11:31:44',	'2019-12-23 11:31:44'),
(57,	57,	'2019-12-01 07:00:00',	'2019-12-31 08:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-23 13:33:28',	'2019-12-23 13:33:28'),
(58,	58,	'2019-12-24 10:00:00',	'2019-12-24 13:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-24 10:39:35',	'2019-12-24 10:39:35'),
(59,	59,	'2019-08-01 07:00:00',	'2019-08-01 07:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-30 08:40:34',	'2019-12-30 08:40:34'),
(60,	60,	'2019-08-02 09:00:00',	'2019-08-02 12:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-30 08:40:34',	'2019-12-30 08:40:34'),
(61,	61,	'2019-08-31 12:00:00',	'2019-08-31 16:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-30 08:40:34',	'2019-12-30 08:40:34'),
(62,	62,	'2020-01-02 07:00:00',	'2020-01-02 07:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-30 09:07:37',	'2019-12-30 09:07:37'),
(63,	63,	'2020-01-03 09:00:00',	'2020-01-03 12:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-30 09:07:37',	'2019-12-30 09:07:37'),
(64,	64,	'2020-01-04 12:00:00',	'2020-01-04 16:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-30 09:07:37',	'2019-12-30 09:07:37'),
(65,	65,	'2019-02-01 07:00:00',	'2019-02-28 07:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-30 10:14:57',	'2019-12-30 10:14:57'),
(66,	66,	'2019-02-01 07:00:00',	'2019-02-28 13:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-30 12:53:23',	'2019-12-30 12:53:23'),
(67,	67,	'2019-02-01 07:00:00',	'2019-02-28 07:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-30 13:31:18',	'2019-12-30 13:31:18'),
(68,	68,	'2020-02-01 07:00:00',	'2020-02-28 14:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2019-12-31 09:36:21',	'2019-12-31 09:36:21'),
(69,	69,	'2020-01-01 07:00:00',	'2020-01-01 09:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-01 12:11:36',	'2020-01-01 12:11:36'),
(70,	70,	'2020-01-01 07:00:00',	'2020-01-31 08:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-03 09:35:35',	'2020-01-03 09:35:35'),
(71,	71,	'2020-01-01 07:00:00',	'2020-01-31 08:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-03 09:37:05',	'2020-01-03 09:37:05'),
(72,	72,	'2020-01-06 07:00:00',	'2020-01-31 13:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-03 10:03:42',	'2020-01-03 10:03:42'),
(73,	73,	'2020-01-06 07:00:00',	'2020-01-31 13:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-03 10:04:50',	'2020-01-03 10:04:50'),
(74,	74,	'2020-01-06 07:00:00',	'2020-01-31 13:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-03 10:23:29',	'2020-01-03 10:23:29'),
(76,	76,	'2020-08-05 08:30:00',	'2020-08-31 11:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-03 10:46:49',	'2020-01-03 10:46:49'),
(77,	77,	'2020-01-01 07:00:00',	'2020-01-31 07:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-03 12:38:11',	'2020-01-03 12:38:11'),
(78,	78,	'2019-01-01 07:00:00',	'2019-01-31 09:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-04 08:47:53',	'2020-01-04 08:47:53'),
(79,	79,	'2019-01-01 07:00:00',	'2019-01-31 09:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-04 08:49:20',	'2020-01-04 08:49:20'),
(80,	80,	'2019-01-01 07:00:00',	'2019-01-31 09:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-04 08:58:49',	'2020-01-04 08:58:49'),
(81,	81,	'2019-01-01 07:00:00',	'2019-01-31 09:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-04 09:01:00',	'2020-01-04 09:01:00'),
(82,	82,	'2018-01-01 07:30:00',	'2018-01-31 14:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-06 09:56:14',	'2020-01-06 09:56:14'),
(83,	83,	'2018-01-01 07:00:00',	'2018-01-31 15:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-06 13:22:21',	'2020-01-06 13:22:21'),
(84,	84,	'2018-01-01 14:30:00',	'2018-01-31 14:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-06 13:22:21',	'2020-01-06 13:22:21'),
(85,	85,	'2018-01-01 07:00:00',	'2018-01-31 15:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-06 13:42:24',	'2020-01-06 13:42:24'),
(86,	86,	'2018-01-01 14:30:00',	'2018-01-31 14:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-06 13:42:24',	'2020-01-06 13:42:24'),
(87,	87,	'2018-01-01 07:00:00',	'2018-01-31 15:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-06 13:42:58',	'2020-01-06 13:42:58'),
(88,	88,	'2018-01-01 14:30:00',	'2018-01-31 14:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-06 13:42:58',	'2020-01-06 13:42:58'),
(89,	89,	'2018-01-01 07:00:00',	'2018-01-31 15:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-06 13:43:23',	'2020-01-06 13:43:23'),
(90,	90,	'2018-01-01 14:30:00',	'2018-01-31 14:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-06 13:43:23',	'2020-01-06 13:43:23'),
(91,	91,	'2019-11-01 12:30:00',	'2019-11-30 15:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-06 16:07:21',	'2020-01-06 16:07:21'),
(92,	92,	'2020-01-07 07:00:00',	'2020-01-07 08:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-07 08:50:53',	'2020-01-07 08:50:53'),
(93,	93,	'2020-01-01 07:00:00',	'2020-01-01 08:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-07 12:48:08',	'2020-01-07 12:48:08'),
(94,	94,	'2020-01-01 12:30:00',	'2020-01-31 15:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-07 13:22:39',	'2020-01-07 13:22:39'),
(95,	95,	'2020-02-28 07:00:00',	'2020-02-28 10:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-08 09:15:58',	'2020-01-08 09:15:58'),
(96,	96,	'2020-02-01 07:30:00',	'2020-02-28 08:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-08 17:03:45',	'2020-01-08 17:03:45'),
(97,	97,	'2020-02-01 07:30:00',	'2020-02-28 08:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-08 17:06:45',	'2020-01-08 17:06:45'),
(98,	98,	'2020-03-01 07:00:00',	'2020-03-31 14:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-08 17:11:08',	'2020-01-08 17:11:08'),
(99,	99,	'2020-03-01 07:00:00',	'2020-03-31 07:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-08 17:14:06',	'2020-01-08 17:14:06'),
(100,	100,	'2020-03-01 07:00:00',	'2020-03-31 07:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-08 17:14:07',	'2020-01-08 17:14:07'),
(101,	101,	'2020-03-01 07:00:00',	'2020-03-31 07:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-08 17:14:08',	'2020-01-08 17:14:08'),
(102,	102,	'2020-03-01 07:00:00',	'2020-03-31 07:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-08 17:14:08',	'2020-01-08 17:14:08'),
(103,	103,	'2020-03-01 07:00:00',	'2020-03-31 07:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-08 17:15:18',	'2020-01-08 17:15:18'),
(104,	104,	'2012-01-01 07:00:00',	'2012-01-31 10:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-09 08:44:12',	'2020-01-09 08:44:12'),
(105,	105,	'2012-01-01 07:00:00',	'2012-01-31 10:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-09 08:45:51',	'2020-01-09 08:45:51'),
(106,	106,	'2012-01-01 07:00:00',	'2012-01-31 10:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-09 08:45:55',	'2020-01-09 08:45:55'),
(107,	107,	'2012-02-01 07:00:00',	'2012-02-28 08:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-09 08:51:26',	'2020-01-09 08:51:26'),
(108,	108,	'2012-02-01 07:00:00',	'2012-02-28 08:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-09 08:52:26',	'2020-01-09 08:52:26'),
(109,	109,	'2010-01-01 09:00:00',	'2010-01-31 18:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-09 12:36:26',	'2020-01-09 12:36:26'),
(110,	110,	'2010-04-01 09:00:00',	'2010-04-30 18:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-09 12:41:18',	'2020-01-09 12:41:18'),
(111,	111,	'2022-01-12 07:00:00',	'2022-01-12 10:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-10 09:11:12',	'2020-01-10 09:11:12'),
(112,	112,	'2022-01-20 10:00:00',	'2022-01-20 12:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-10 09:11:12',	'2020-01-10 09:11:12'),
(113,	113,	'2022-01-12 07:00:00',	'2022-01-12 10:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-10 09:13:08',	'2020-01-10 09:13:08'),
(114,	114,	'2022-01-20 10:00:00',	'2022-01-20 12:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-10 09:13:08',	'2020-01-10 09:13:08'),
(115,	115,	'2032-01-01 13:30:00',	'2032-01-31 14:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-16 09:18:27',	'2020-01-16 09:18:27'),
(116,	116,	'2032-01-01 13:30:00',	'2032-01-31 14:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-16 09:18:36',	'2020-01-16 09:18:36'),
(117,	117,	'2035-01-01 09:00:00',	'2035-01-31 12:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-16 10:00:29',	'2020-01-16 10:00:29'),
(118,	118,	'2036-03-01 09:00:00',	'2036-03-31 18:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-16 10:28:44',	'2020-01-16 10:28:44'),
(119,	119,	'2020-01-01 07:30:00',	'2020-01-31 08:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-17 09:11:16',	'2020-01-17 09:11:16'),
(120,	120,	'2020-01-01 07:00:00',	'2020-01-31 10:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-17 09:15:50',	'2020-01-17 09:15:50'),
(121,	121,	'2020-01-01 07:30:00',	'2020-01-31 15:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-17 09:18:09',	'2020-01-17 09:18:09'),
(122,	122,	'2020-01-01 13:00:00',	'2020-01-31 08:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-17 09:19:45',	'2020-01-17 09:19:45'),
(123,	123,	'2020-01-01 13:00:00',	'2020-01-31 08:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-17 09:20:34',	'2020-01-17 09:20:34'),
(124,	124,	'2020-01-01 10:30:00',	'2020-01-31 07:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-17 09:52:16',	'2020-01-17 09:52:16'),
(125,	125,	'2020-05-01 07:00:00',	'2020-05-01 09:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-18 13:31:20',	'2020-01-18 13:31:20'),
(126,	126,	'2020-05-31 09:00:00',	'2020-05-31 10:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-18 13:31:20',	'2020-01-18 13:31:20'),
(127,	127,	'2020-05-01 07:00:00',	'2020-05-01 09:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-18 13:31:24',	'2020-01-18 13:31:24'),
(128,	128,	'2020-05-31 09:00:00',	'2020-05-31 10:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-18 13:31:24',	'2020-01-18 13:31:24'),
(129,	129,	'2020-01-01 08:00:00',	'2020-01-15 09:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-20 14:33:08',	'2020-01-20 14:33:08'),
(130,	130,	'2020-01-01 08:00:00',	'2020-01-15 09:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-20 14:33:15',	'2020-01-20 14:33:15'),
(131,	131,	'2020-03-01 07:00:00',	'2020-03-31 14:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-21 15:32:33',	'2020-01-21 15:32:33'),
(132,	132,	'2020-03-01 07:00:00',	'2020-03-31 14:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-21 15:32:43',	'2020-01-21 15:32:43'),
(133,	133,	'2020-03-01 07:00:00',	'2020-03-17 10:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-22 15:33:04',	'2020-01-22 15:33:04'),
(134,	134,	'2020-06-30 07:00:00',	'2020-06-30 12:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-25 15:36:23',	'2020-01-25 15:36:23'),
(135,	135,	'2020-01-30 07:30:00',	'2020-01-31 13:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-29 16:19:57',	'2020-01-29 16:19:57'),
(136,	136,	'2020-01-30 07:30:00',	'2020-01-31 13:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-29 16:20:22',	'2020-01-29 16:20:22'),
(137,	137,	'2020-01-30 07:00:00',	'2020-01-31 07:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-29 16:21:21',	'2020-01-29 16:21:21'),
(138,	138,	'2020-01-30 07:00:00',	'2020-01-31 07:30:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-29 16:21:28',	'2020-01-29 16:21:28'),
(139,	139,	'2020-03-13 07:00:00',	'2020-03-24 10:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-30 13:57:17',	'2020-01-30 13:57:17'),
(140,	140,	'2020-03-13 07:00:00',	'2020-03-24 10:00:00',	NULL,	NULL,	NULL,	NULL,	'',	'2020-01-30 13:57:22',	'2020-01-30 13:57:22');

DROP TABLE IF EXISTS `audit_schedule_divisions`;
CREATE TABLE `audit_schedule_divisions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `audit_schedule_id` int(10) unsigned NOT NULL,
  `division_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `audit_schedule_location`;
CREATE TABLE `audit_schedule_location` (
  `audit_schedule_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `audit_schedule_opening_meeting_users`;
CREATE TABLE `audit_schedule_opening_meeting_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `audit_schedule_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `audit_schedule_process`;
CREATE TABLE `audit_schedule_process` (
  `audit_schedule_id` int(10) unsigned NOT NULL,
  `process_id` int(10) unsigned NOT NULL,
  `parent_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`audit_schedule_id`,`process_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_schedule_process` (`audit_schedule_id`, `process_id`, `parent_id`) VALUES
(41,	64,	0),
(42,	64,	0),
(43,	64,	0),
(44,	64,	0),
(45,	64,	0),
(46,	64,	0),
(47,	64,	0),
(48,	64,	0),
(53,	64,	0),
(65,	65,	0),
(68,	64,	0),
(69,	65,	0),
(70,	64,	0),
(71,	64,	0),
(78,	64,	0),
(79,	64,	0),
(80,	64,	0),
(81,	64,	0),
(91,	64,	0),
(93,	65,	0),
(98,	64,	0),
(104,	64,	0),
(105,	64,	0),
(106,	64,	0),
(119,	64,	0),
(120,	64,	0),
(122,	64,	0),
(123,	64,	0),
(124,	64,	0),
(131,	64,	0),
(132,	64,	0);

DROP TABLE IF EXISTS `audit_schedule_sections`;
CREATE TABLE `audit_schedule_sections` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `audit_schedule_id` int(10) unsigned NOT NULL,
  `section_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_schedule_sections` (`id`, `audit_schedule_id`, `section_id`) VALUES
(1,	1,	45),
(2,	2,	2),
(3,	3,	28),
(4,	3,	26),
(5,	4,	51),
(6,	5,	3),
(7,	5,	2),
(8,	6,	1),
(9,	7,	20),
(10,	7,	19),
(11,	8,	16),
(12,	9,	29),
(13,	10,	9),
(14,	10,	10),
(15,	10,	11),
(16,	11,	14),
(17,	11,	13),
(18,	12,	57),
(19,	12,	7),
(20,	12,	6),
(21,	13,	36),
(22,	13,	35),
(23,	13,	37),
(24,	14,	62),
(25,	15,	61),
(26,	16,	60),
(27,	17,	24),
(28,	18,	22),
(29,	19,	47),
(30,	20,	41),
(31,	21,	45),
(32,	22,	28),
(33,	22,	26),
(34,	23,	59),
(35,	24,	2),
(36,	24,	3),
(37,	25,	1),
(38,	26,	19),
(39,	26,	20),
(40,	26,	21),
(41,	27,	16),
(42,	27,	17),
(43,	27,	18),
(44,	28,	29),
(45,	29,	9),
(46,	29,	10),
(47,	29,	11),
(48,	30,	14),
(49,	30,	13),
(50,	31,	5),
(51,	31,	6),
(52,	31,	7),
(53,	32,	35),
(54,	32,	36),
(55,	32,	37),
(56,	33,	30),
(57,	33,	31),
(58,	34,	32),
(59,	34,	33),
(60,	34,	34),
(61,	35,	22),
(62,	35,	23),
(63,	35,	24),
(64,	35,	25),
(65,	36,	22),
(66,	36,	23),
(67,	36,	24),
(68,	36,	25),
(69,	37,	22),
(70,	37,	23),
(71,	37,	24),
(72,	37,	25),
(73,	38,	41),
(74,	39,	39),
(75,	40,	49),
(76,	40,	26),
(77,	40,	51),
(78,	40,	28),
(79,	41,	1),
(80,	41,	2),
(81,	41,	3),
(82,	42,	1),
(83,	42,	2),
(84,	42,	3),
(85,	43,	1),
(86,	43,	2),
(87,	43,	3),
(88,	44,	1),
(89,	44,	2),
(90,	44,	3),
(91,	45,	1),
(92,	45,	2),
(93,	45,	3),
(94,	46,	1),
(95,	46,	2),
(96,	46,	3),
(97,	47,	1),
(98,	47,	2),
(99,	47,	3),
(100,	48,	1),
(101,	48,	2),
(102,	48,	3),
(107,	51,	30),
(108,	51,	31),
(109,	52,	1),
(110,	52,	2),
(111,	52,	3),
(112,	53,	1),
(113,	53,	2),
(114,	53,	3),
(115,	54,	39),
(116,	55,	39),
(117,	56,	49),
(118,	56,	26),
(119,	56,	51),
(120,	56,	28),
(121,	57,	17),
(122,	57,	16),
(123,	57,	18),
(124,	58,	35),
(125,	58,	36),
(126,	58,	37),
(127,	59,	49),
(128,	59,	26),
(129,	59,	51),
(130,	59,	28),
(131,	60,	49),
(132,	60,	26),
(133,	60,	51),
(134,	60,	28),
(135,	61,	49),
(136,	61,	26),
(137,	61,	51),
(138,	61,	28),
(139,	62,	49),
(140,	62,	26),
(141,	62,	51),
(142,	62,	28),
(143,	63,	49),
(144,	63,	26),
(145,	63,	51),
(146,	63,	28),
(147,	64,	49),
(148,	64,	26),
(149,	64,	51),
(150,	64,	28),
(151,	65,	39),
(152,	66,	39),
(153,	67,	39),
(154,	68,	1),
(155,	68,	2),
(156,	68,	3),
(157,	69,	39),
(158,	70,	1),
(159,	70,	2),
(160,	70,	3),
(161,	71,	1),
(162,	71,	2),
(163,	71,	3),
(164,	72,	1),
(165,	72,	2),
(166,	72,	3),
(167,	73,	1),
(168,	73,	2),
(169,	73,	3),
(170,	74,	1),
(171,	74,	2),
(172,	74,	3),
(176,	76,	1),
(177,	76,	2),
(178,	76,	3),
(179,	77,	49),
(180,	77,	26),
(181,	77,	51),
(182,	77,	28),
(183,	78,	1),
(184,	78,	2),
(185,	78,	3),
(186,	79,	1),
(187,	79,	2),
(188,	79,	3),
(189,	80,	1),
(190,	80,	2),
(191,	80,	3),
(192,	81,	1),
(193,	81,	2),
(194,	81,	3),
(195,	82,	30),
(196,	82,	31),
(197,	83,	30),
(198,	83,	31),
(199,	84,	30),
(200,	84,	31),
(201,	85,	30),
(202,	85,	31),
(203,	86,	30),
(204,	86,	31),
(205,	87,	30),
(206,	87,	31),
(207,	88,	30),
(208,	88,	31),
(209,	89,	30),
(210,	89,	31),
(211,	90,	30),
(212,	90,	31),
(213,	91,	1),
(214,	91,	2),
(215,	91,	3),
(216,	92,	35),
(217,	92,	36),
(218,	92,	37),
(219,	93,	39),
(220,	94,	39),
(221,	95,	49),
(222,	95,	26),
(223,	95,	51),
(224,	95,	28),
(225,	96,	1),
(226,	96,	2),
(227,	96,	3),
(228,	97,	1),
(229,	97,	2),
(230,	97,	3),
(231,	98,	1),
(232,	98,	2),
(233,	98,	3),
(234,	99,	1),
(235,	99,	2),
(236,	99,	3),
(237,	100,	1),
(238,	100,	2),
(239,	100,	3),
(240,	101,	1),
(241,	101,	2),
(242,	101,	3),
(243,	102,	1),
(244,	102,	2),
(245,	102,	3),
(246,	103,	1),
(247,	103,	2),
(248,	103,	3),
(249,	104,	1),
(250,	104,	2),
(251,	104,	3),
(252,	105,	1),
(253,	105,	2),
(254,	105,	3),
(255,	106,	1),
(256,	106,	2),
(257,	106,	3),
(258,	107,	45),
(259,	107,	60),
(260,	108,	45),
(261,	108,	60),
(262,	109,	45),
(263,	109,	60),
(264,	110,	45),
(265,	111,	17),
(266,	111,	16),
(267,	111,	18),
(268,	112,	17),
(269,	112,	16),
(270,	112,	18),
(271,	113,	17),
(272,	113,	16),
(273,	113,	18),
(274,	114,	17),
(275,	114,	16),
(276,	114,	18),
(277,	115,	1),
(278,	115,	2),
(279,	115,	3),
(280,	116,	1),
(281,	116,	2),
(282,	116,	3),
(283,	117,	39),
(284,	118,	39),
(285,	119,	1),
(286,	119,	2),
(287,	119,	3),
(288,	120,	1),
(289,	120,	2),
(290,	120,	3),
(291,	121,	1),
(292,	121,	2),
(293,	121,	3),
(294,	122,	1),
(295,	122,	2),
(296,	122,	3),
(297,	123,	1),
(298,	123,	2),
(299,	123,	3),
(300,	124,	1),
(301,	124,	2),
(302,	124,	3),
(303,	125,	29),
(304,	126,	29),
(305,	127,	29),
(306,	128,	29),
(307,	129,	66),
(308,	130,	66),
(309,	131,	1),
(310,	131,	2),
(311,	131,	3),
(312,	132,	1),
(313,	132,	2),
(314,	132,	3),
(315,	133,	66),
(316,	134,	66),
(317,	134,	65),
(318,	134,	64),
(319,	135,	1),
(320,	135,	2),
(321,	135,	3),
(322,	136,	1),
(323,	136,	2),
(324,	136,	3),
(325,	137,	1),
(326,	137,	2),
(327,	137,	3),
(328,	138,	1),
(329,	138,	2),
(330,	138,	3),
(331,	139,	32),
(332,	139,	33),
(333,	139,	34),
(334,	140,	32),
(335,	140,	33),
(336,	140,	34);

DROP TABLE IF EXISTS `audit_scopes`;
CREATE TABLE `audit_scopes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `is_company` tinyint(4) NOT NULL DEFAULT '0',
  `is_subsidiary` tinyint(4) NOT NULL DEFAULT '0',
  `is_supplier` tinyint(4) NOT NULL DEFAULT '0',
  `is_customer` tinyint(4) NOT NULL DEFAULT '0',
  `is_certification_body` tinyint(4) NOT NULL DEFAULT '0',
  `is_project` tinyint(4) NOT NULL DEFAULT '0',
  `is_branch` int(11) DEFAULT '0',
  `is_department` int(11) DEFAULT '0',
  `is_type_company` int(11) DEFAULT '0',
  `is_type_customer` int(11) DEFAULT '0',
  `is_type_supplier` int(11) DEFAULT '0',
  `is_type_certification` int(11) DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `updated_by` int(10) unsigned DEFAULT NULL,
  `deleted_by` int(10) unsigned DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_scopes` (`id`, `title`, `description`, `is_company`, `is_subsidiary`, `is_supplier`, `is_customer`, `is_certification_body`, `is_project`, `is_branch`, `is_department`, `is_type_company`, `is_type_customer`, `is_type_supplier`, `is_type_certification`, `created_at`, `updated_at`, `created_by`, `updated_by`, `deleted_by`, `status`) VALUES
(1,	'Company audit',	NULL,	1,	0,	0,	0,	0,	0,	0,	0,	1,	0,	0,	0,	'2018-10-03 14:29:20',	'2018-10-03 14:29:20',	1,	NULL,	NULL,	1),
(2,	'Subsidiary audit',	NULL,	0,	1,	0,	0,	0,	0,	0,	0,	1,	0,	0,	0,	'2018-10-03 14:29:20',	'2018-10-03 14:29:20',	1,	NULL,	NULL,	1),
(3,	'Supplier audit',	NULL,	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	1,	0,	'2018-10-03 14:29:20',	'2018-10-03 14:29:20',	1,	NULL,	NULL,	1),
(4,	'Customer audit',	NULL,	0,	0,	0,	1,	0,	0,	0,	0,	0,	1,	0,	0,	'2018-10-03 14:29:20',	'2018-10-03 14:29:20',	1,	NULL,	NULL,	1),
(5,	'Certification body audit',	NULL,	0,	0,	0,	0,	1,	0,	0,	0,	0,	0,	0,	1,	'2018-10-03 14:29:20',	'2018-10-03 14:29:20',	1,	NULL,	NULL,	1),
(6,	'Project audit',	NULL,	0,	0,	0,	0,	0,	1,	0,	0,	0,	1,	1,	0,	'2018-10-03 14:29:20',	'2018-10-03 14:29:20',	1,	NULL,	NULL,	1),
(7,	'Branch audit',	NULL,	0,	0,	0,	0,	0,	0,	1,	0,	1,	1,	1,	0,	'2018-10-03 14:29:20',	'2018-10-03 14:29:20',	1,	NULL,	NULL,	1),
(8,	'Department audit',	NULL,	0,	0,	0,	0,	0,	0,	0,	1,	1,	1,	1,	0,	'2018-10-03 14:29:20',	'2018-10-03 14:29:20',	1,	NULL,	NULL,	1);

DROP TABLE IF EXISTS `audit_statuses`;
CREATE TABLE `audit_statuses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_open` tinyint(1) NOT NULL DEFAULT '0',
  `is_closed` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_statuses` (`id`, `title`, `label`, `is_open`, `is_closed`, `created_at`, `updated_at`) VALUES
(1,	'Open',	'primary',	1,	0,	'2018-10-03 14:29:19',	'2018-10-03 14:29:19'),
(2,	'Closed',	'success',	0,	1,	'2018-10-03 14:29:19',	'2018-10-03 14:29:19');

DROP TABLE IF EXISTS `audit_sub_categories`;
CREATE TABLE `audit_sub_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `audit_category_id` int(11) DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `audit_types`;
CREATE TABLE `audit_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `is_company` tinyint(4) NOT NULL DEFAULT '0',
  `is_subsidiary` tinyint(4) NOT NULL DEFAULT '0',
  `is_supplier` tinyint(4) NOT NULL DEFAULT '0',
  `is_customer` tinyint(4) NOT NULL DEFAULT '0',
  `is_certification_body` tinyint(4) NOT NULL DEFAULT '0',
  `is_project` tinyint(4) NOT NULL DEFAULT '0',
  `audit_party_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `updated_by` int(10) unsigned DEFAULT NULL,
  `deleted_by` int(10) unsigned DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `audit_types` (`id`, `title`, `description`, `is_company`, `is_subsidiary`, `is_supplier`, `is_customer`, `is_certification_body`, `is_project`, `audit_party_id`, `created_at`, `updated_at`, `created_by`, `updated_by`, `deleted_by`, `status`) VALUES
(1,	'Company audit',	NULL,	1,	0,	0,	0,	0,	0,	1,	'2018-10-03 14:29:19',	'2018-10-03 14:29:20',	1,	NULL,	NULL,	1),
(3,	'Supplier audit',	NULL,	0,	0,	1,	0,	0,	0,	2,	'2018-10-03 14:29:19',	'2018-10-03 14:29:20',	1,	NULL,	NULL,	1),
(4,	'Customer audit',	NULL,	0,	0,	0,	1,	0,	0,	2,	'2018-10-03 14:29:19',	'2018-10-03 14:29:20',	1,	NULL,	NULL,	1),
(5,	'Certification body audit',	NULL,	0,	0,	0,	0,	1,	0,	3,	'2018-10-03 14:29:19',	'2018-10-03 14:29:20',	1,	NULL,	NULL,	1);

DROP TABLE IF EXISTS `branches`;
CREATE TABLE `branches` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `updated_by` int(10) unsigned DEFAULT NULL,
  `deleted_by` int(10) unsigned DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `business_contexts`;
CREATE TABLE `business_contexts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `department_id` int(10) unsigned DEFAULT NULL,
  `issue_category_id` int(10) unsigned DEFAULT NULL,
  `risk_issue_type_id` int(10) unsigned DEFAULT NULL,
  `risk_area_id` int(10) unsigned DEFAULT NULL,
  `review_frequency_id` int(11) DEFAULT NULL,
  `issue_domain_id` int(10) unsigned DEFAULT NULL,
  `issue` text COLLATE utf8mb4_unicode_ci,
  `issue_id` int(11) DEFAULT NULL,
  `reference_code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_no` int(11) NOT NULL,
  `main_process` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `asset_id` int(10) unsigned DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `updated_by` int(10) unsigned DEFAULT NULL,
  `reviewed_by` int(10) unsigned DEFAULT NULL,
  `closed_by` int(10) unsigned DEFAULT NULL,
  `deleted_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `reviewed_at` timestamp NULL DEFAULT NULL,
  `closed_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_context_index` (`id`,`issue_category_id`,`risk_issue_type_id`,`issue_domain_id`,`review_frequency_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `business_contexts` (`id`, `department_id`, `issue_category_id`, `risk_issue_type_id`, `risk_area_id`, `review_frequency_id`, `issue_domain_id`, `issue`, `issue_id`, `reference_code`, `reference_no`, `main_process`, `asset_id`, `created_by`, `updated_by`, `reviewed_by`, `closed_by`, `deleted_by`, `created_at`, `updated_at`, `reviewed_at`, `closed_at`, `deleted_at`) VALUES
(1,	NULL,	NULL,	NULL,	NULL,	2,	NULL,	NULL,	87,	'BGS-II-0001',	1,	NULL,	NULL,	1,	1,	1,	1,	NULL,	'2017-10-04 15:58:33',	'2019-10-04 16:01:06',	'2019-10-04 15:59:45',	'2019-10-04 16:01:06',	NULL),
(2,	NULL,	NULL,	NULL,	NULL,	2,	NULL,	NULL,	61,	'BGS-II-0002',	2,	NULL,	NULL,	1,	1,	NULL,	NULL,	NULL,	'2019-10-04 16:24:14',	'2020-01-20 08:38:17',	NULL,	NULL,	NULL),
(3,	NULL,	NULL,	NULL,	NULL,	2,	NULL,	NULL,	4,	'BGS-EI-0003',	3,	NULL,	NULL,	1,	1,	1,	1,	NULL,	'2019-10-04 16:28:40',	'2019-10-04 16:32:51',	'2019-10-04 16:31:30',	'2019-10-04 16:32:51',	NULL),
(4,	NULL,	NULL,	NULL,	NULL,	2,	NULL,	NULL,	91,	'CDD-I&EI-0004',	4,	NULL,	NULL,	101,	1,	NULL,	NULL,	NULL,	'2019-10-04 16:41:48',	'2020-01-17 14:10:22',	NULL,	NULL,	NULL),
(5,	NULL,	NULL,	NULL,	NULL,	2,	1,	'test',	160,	'BGS-II-0064',	64,	NULL,	NULL,	1,	1,	1,	NULL,	NULL,	'2019-10-12 20:47:00',	'2020-01-17 13:50:48',	'2019-10-23 05:00:04',	NULL,	NULL),
(6,	NULL,	NULL,	NULL,	NULL,	2,	5,	NULL,	121,	'BGS-EI-0005',	5,	NULL,	NULL,	1,	1,	NULL,	NULL,	NULL,	'2019-10-14 12:57:16',	'2019-10-14 12:58:27',	NULL,	NULL,	'2019-10-14 12:58:27'),
(7,	NULL,	NULL,	NULL,	NULL,	2,	4,	NULL,	129,	'BGS-II-0008',	8,	NULL,	NULL,	1,	1,	1,	1,	NULL,	'2019-11-21 09:37:11',	'2019-11-21 09:40:35',	'2019-11-21 09:40:22',	'2019-11-21 09:40:35',	NULL),
(8,	NULL,	NULL,	NULL,	NULL,	3,	2,	NULL,	91,	'BGS-I&EI-0009',	9,	NULL,	NULL,	1,	1,	NULL,	NULL,	NULL,	'2019-11-21 13:12:33',	'2019-11-21 13:12:33',	NULL,	NULL,	NULL),
(9,	NULL,	NULL,	NULL,	NULL,	2,	3,	'A risk matrix is a matrix that is used during risk assessment to define the level of risk by considering the category of probability or likelihood against the category of consequence severity.',	121,	'BGS-II-10',	10,	NULL,	NULL,	1,	1,	NULL,	NULL,	NULL,	'2019-12-09 10:21:17',	'2019-12-09 10:21:17',	NULL,	NULL,	NULL),
(10,	NULL,	NULL,	NULL,	NULL,	2,	1,	NULL,	129,	'BGS-II-0011',	11,	NULL,	NULL,	1,	1,	NULL,	NULL,	NULL,	'2019-12-16 15:33:19',	'2019-12-16 15:33:19',	NULL,	NULL,	NULL),
(11,	NULL,	NULL,	NULL,	NULL,	3,	NULL,	NULL,	121,	'BGS-II-0012',	12,	NULL,	NULL,	53,	53,	NULL,	NULL,	NULL,	'2019-12-16 16:10:44',	'2019-12-16 16:10:44',	NULL,	NULL,	NULL),
(12,	NULL,	NULL,	NULL,	NULL,	2,	1,	NULL,	119,	'BGS-II-0015',	15,	NULL,	NULL,	1,	1,	NULL,	NULL,	NULL,	'2019-12-18 13:39:20',	'2019-12-19 09:34:20',	NULL,	NULL,	NULL),
(13,	NULL,	NULL,	NULL,	NULL,	2,	1,	'test test',	4,	'BGS-II-0021',	21,	NULL,	NULL,	1,	1,	NULL,	NULL,	NULL,	'2019-12-23 08:31:31',	'2019-12-23 14:10:33',	NULL,	NULL,	NULL),
(14,	NULL,	NULL,	NULL,	NULL,	4,	NULL,	NULL,	121,	'BGS-II-0023',	23,	NULL,	NULL,	1,	1,	NULL,	NULL,	NULL,	'2019-12-23 14:18:41',	'2019-12-24 09:43:25',	NULL,	NULL,	NULL),
(15,	NULL,	NULL,	NULL,	NULL,	3,	1,	NULL,	91,	'BGS-II-0026',	26,	NULL,	NULL,	1,	1,	NULL,	NULL,	NULL,	'2019-12-24 09:44:17',	'2019-12-24 09:57:29',	NULL,	NULL,	NULL),
(16,	NULL,	NULL,	NULL,	NULL,	3,	2,	NULL,	87,	'BGS-I&EI-0030',	30,	NULL,	NULL,	1,	1,	NULL,	NULL,	NULL,	'2019-12-24 09:58:04',	'2020-01-20 08:40:16',	NULL,	NULL,	NULL),
(17,	NULL,	NULL,	NULL,	NULL,	3,	NULL,	NULL,	121,	'BGS-EI-0031',	31,	NULL,	NULL,	1,	1,	NULL,	NULL,	NULL,	'2019-12-24 13:13:02',	'2019-12-24 13:13:02',	NULL,	NULL,	NULL),
(18,	NULL,	NULL,	NULL,	NULL,	2,	NULL,	NULL,	61,	'BGS-II-0032',	32,	NULL,	NULL,	1,	1,	1,	NULL,	NULL,	'2019-12-27 09:03:26',	'2019-12-27 09:03:39',	'2019-12-27 09:03:39',	NULL,	NULL),
(19,	NULL,	NULL,	NULL,	NULL,	2,	NULL,	NULL,	4,	'BGS-II-0033',	33,	NULL,	NULL,	1,	1,	NULL,	NULL,	NULL,	'2019-12-27 13:21:04',	'2019-12-27 13:21:04',	NULL,	NULL,	NULL),
(20,	NULL,	NULL,	NULL,	NULL,	3,	NULL,	NULL,	91,	'BGS-II-0034',	34,	NULL,	NULL,	1,	1,	NULL,	NULL,	NULL,	'2019-12-27 13:24:25',	'2019-12-27 13:24:25',	NULL,	NULL,	NULL),
(21,	NULL,	NULL,	NULL,	NULL,	2,	1,	NULL,	129,	'BGS-II-0035',	35,	NULL,	NULL,	1,	1,	297,	297,	NULL,	'2019-12-31 10:14:12',	'2019-12-31 14:43:48',	'2019-12-31 14:14:44',	'2019-12-31 14:43:48',	NULL),
(22,	NULL,	NULL,	NULL,	NULL,	2,	NULL,	NULL,	91,	'BGS-II-0037',	37,	NULL,	NULL,	1,	1,	NULL,	NULL,	NULL,	'2019-12-31 10:57:18',	'2019-12-31 10:58:18',	NULL,	NULL,	NULL),
(23,	NULL,	NULL,	NULL,	NULL,	2,	1,	NULL,	87,	'BGS-II-0038',	38,	NULL,	NULL,	1,	1,	NULL,	NULL,	NULL,	'2019-12-31 11:48:34',	'2019-12-31 11:48:34',	NULL,	NULL,	NULL),
(24,	NULL,	NULL,	NULL,	NULL,	2,	1,	'sample docs',	129,	'BGS-II-0054',	54,	NULL,	NULL,	1,	1,	53,	53,	NULL,	'2020-01-01 15:35:49',	'2020-01-07 16:10:27',	'2020-01-07 16:07:35',	'2020-01-07 16:10:27',	NULL),
(25,	NULL,	NULL,	NULL,	NULL,	2,	NULL,	NULL,	129,	'ADM-II-0045',	45,	NULL,	NULL,	1,	1,	NULL,	NULL,	NULL,	'2020-01-01 15:45:12',	'2020-01-20 08:34:33',	NULL,	NULL,	NULL),
(26,	NULL,	NULL,	NULL,	NULL,	2,	1,	NULL,	119,	'BGS-II-0047',	47,	NULL,	NULL,	1,	1,	53,	53,	NULL,	'2020-01-03 12:25:24',	'2020-01-03 13:35:45',	'2020-01-03 13:24:32',	'2020-01-03 13:35:45',	NULL),
(27,	NULL,	NULL,	NULL,	NULL,	2,	1,	NULL,	119,	'BGS-II-0051',	51,	NULL,	NULL,	1,	1,	1,	NULL,	NULL,	'2020-01-04 09:45:56',	'2020-01-04 11:18:20',	'2020-01-04 11:11:48',	NULL,	NULL),
(28,	NULL,	NULL,	NULL,	NULL,	2,	NULL,	NULL,	91,	'BGS-II-0052',	52,	NULL,	NULL,	1,	1,	1,	NULL,	NULL,	'2020-01-06 08:16:44',	'2020-01-06 08:16:52',	'2020-01-06 08:16:52',	NULL,	NULL),
(29,	NULL,	NULL,	NULL,	NULL,	2,	1,	NULL,	9,	'BGS-EI-0058',	58,	NULL,	NULL,	1,	1,	1,	1,	NULL,	'2020-01-06 09:44:17',	'2020-01-16 11:17:34',	'2020-01-06 09:44:44',	'2020-01-16 11:17:34',	NULL),
(30,	NULL,	NULL,	NULL,	NULL,	2,	1,	'test',	4,	'BGS-II-0055',	55,	NULL,	NULL,	1,	1,	NULL,	NULL,	NULL,	'2020-01-09 11:21:18',	'2020-01-09 11:21:18',	NULL,	NULL,	NULL),
(31,	NULL,	NULL,	NULL,	NULL,	2,	1,	'test',	61,	'BGS-EI-0057',	57,	NULL,	NULL,	1,	1,	1,	1,	NULL,	'2020-01-09 11:34:51',	'2020-01-10 11:35:11',	'2020-01-10 11:31:02',	'2020-01-10 11:35:11',	NULL),
(32,	NULL,	NULL,	NULL,	NULL,	2,	1,	NULL,	121,	'BGS-II-0060',	60,	NULL,	NULL,	1,	1,	1,	NULL,	NULL,	'2020-01-16 11:20:59',	'2020-01-18 23:54:56',	'2020-01-18 23:54:56',	NULL,	NULL),
(33,	NULL,	NULL,	NULL,	NULL,	2,	NULL,	NULL,	61,	'DEV-II-0001',	1,	NULL,	NULL,	531,	1,	NULL,	NULL,	NULL,	'2020-01-16 13:37:40',	'2020-01-29 16:20:23',	NULL,	NULL,	NULL),
(34,	NULL,	NULL,	NULL,	NULL,	2,	1,	NULL,	87,	'ADM-II-0001',	1,	NULL,	NULL,	53,	53,	NULL,	NULL,	NULL,	'2020-01-17 11:47:12',	'2020-01-17 11:47:12',	NULL,	NULL,	NULL),
(35,	NULL,	NULL,	NULL,	NULL,	2,	1,	NULL,	4,	'ADM-II-0003',	3,	NULL,	NULL,	53,	1,	NULL,	NULL,	NULL,	'2020-01-17 13:08:12',	'2020-01-17 13:33:30',	NULL,	NULL,	NULL),
(36,	NULL,	NULL,	NULL,	NULL,	3,	NULL,	NULL,	9,	'PPD-II-0065',	65,	NULL,	NULL,	1,	1,	NULL,	NULL,	NULL,	'2020-01-17 13:42:56',	'2020-02-04 08:10:03',	NULL,	NULL,	NULL),
(37,	NULL,	NULL,	NULL,	NULL,	3,	2,	NULL,	141,	'BGS-EI-0001',	1,	NULL,	NULL,	1,	1,	NULL,	NULL,	NULL,	'2020-01-17 15:10:23',	'2020-01-18 09:01:37',	NULL,	NULL,	NULL),
(38,	NULL,	NULL,	NULL,	NULL,	2,	2,	NULL,	87,	'BGS-II-0001',	1,	NULL,	NULL,	1,	1,	1,	1,	NULL,	'2020-01-18 09:13:22',	'2020-01-20 10:39:55',	'2020-01-20 10:35:52',	'2020-01-20 10:39:55',	NULL),
(39,	NULL,	NULL,	NULL,	NULL,	2,	1,	NULL,	121,	'IMS-EI-0001',	1,	NULL,	NULL,	1,	1,	NULL,	NULL,	NULL,	'2020-01-18 09:18:54',	'2020-02-04 08:45:27',	NULL,	NULL,	NULL),
(40,	NULL,	NULL,	NULL,	NULL,	2,	NULL,	NULL,	87,	'CCD-EI-0001',	1,	NULL,	NULL,	1,	1,	1,	NULL,	NULL,	'2020-01-18 09:24:06',	'2020-01-24 08:02:20',	'2020-01-24 08:00:01',	NULL,	NULL),
(41,	NULL,	NULL,	NULL,	NULL,	2,	1,	NULL,	91,	'ADM-II-0001',	1,	NULL,	NULL,	1,	1,	NULL,	NULL,	NULL,	'2020-01-18 09:26:05',	'2020-01-18 11:46:10',	NULL,	NULL,	NULL),
(42,	NULL,	NULL,	NULL,	NULL,	3,	NULL,	NULL,	141,	'IMS-EI-0004',	4,	NULL,	NULL,	53,	1,	1,	NULL,	NULL,	'2020-01-18 14:27:39',	'2020-01-31 13:36:17',	'2020-01-31 13:36:17',	NULL,	NULL),
(43,	NULL,	NULL,	NULL,	NULL,	2,	1,	NULL,	61,	'BGS-II-0001',	1,	NULL,	NULL,	243,	243,	243,	NULL,	NULL,	'2020-01-20 08:30:02',	'2020-01-20 11:07:19',	'2020-01-20 11:02:34',	NULL,	NULL),
(44,	NULL,	NULL,	NULL,	NULL,	2,	NULL,	NULL,	9,	'DGO-II-0001',	1,	NULL,	NULL,	243,	1,	22,	NULL,	NULL,	'2020-01-20 11:09:21',	'2020-01-21 08:58:57',	'2020-01-20 12:50:08',	NULL,	NULL),
(45,	NULL,	NULL,	NULL,	NULL,	2,	1,	NULL,	87,	'BGS-II-0066',	66,	NULL,	NULL,	1,	1,	NULL,	NULL,	NULL,	'2020-01-21 09:13:56',	'2020-03-04 08:24:59',	NULL,	NULL,	NULL),
(46,	NULL,	NULL,	NULL,	NULL,	3,	3,	NULL,	73,	'BGS-II-0001',	1,	NULL,	NULL,	79,	1,	NULL,	NULL,	NULL,	'2020-01-23 10:43:51',	'2020-02-07 09:58:16',	NULL,	NULL,	NULL),
(47,	NULL,	NULL,	NULL,	NULL,	2,	1,	NULL,	161,	'BGS-II-0067',	67,	NULL,	NULL,	1,	1,	1,	NULL,	NULL,	'2020-01-29 11:19:41',	'2020-01-29 11:32:55',	'2020-01-29 11:32:55',	NULL,	NULL),
(48,	NULL,	NULL,	NULL,	NULL,	2,	NULL,	NULL,	87,	'IMS-EI-0068',	68,	NULL,	NULL,	1,	1,	NULL,	NULL,	NULL,	'2020-01-31 13:38:00',	'2020-02-07 09:36:53',	NULL,	NULL,	NULL),
(49,	NULL,	NULL,	NULL,	NULL,	3,	2,	NULL,	129,	'new-II-0001',	1,	NULL,	NULL,	1,	1,	NULL,	NULL,	NULL,	'2020-01-31 14:20:39',	'2020-01-31 14:20:50',	NULL,	NULL,	NULL),
(50,	NULL,	NULL,	NULL,	NULL,	2,	NULL,	NULL,	87,	'IMS-EI-0069',	69,	NULL,	NULL,	1,	1,	1,	NULL,	NULL,	'2020-02-03 09:37:50',	'2020-04-16 18:03:28',	'2020-04-16 18:03:28',	NULL,	NULL),
(51,	NULL,	NULL,	NULL,	NULL,	3,	2,	NULL,	87,	'BGS-EI-0070',	70,	NULL,	NULL,	1,	1,	NULL,	NULL,	NULL,	'2020-02-18 15:04:15',	'2020-02-18 15:05:43',	NULL,	NULL,	'2020-02-18 15:05:43');

DROP TABLE IF EXISTS `business_context_departments`;
CREATE TABLE `business_context_departments` (
  `business_context_id` int(10) unsigned NOT NULL,
  `department_id` int(10) unsigned NOT NULL,
  KEY `business_context_department_index` (`business_context_id`,`department_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `business_context_departments` (`business_context_id`, `department_id`) VALUES
(1,	1),
(2,	1),
(3,	1),
(4,	4),
(5,	1),
(7,	1),
(8,	1),
(9,	1),
(10,	1),
(11,	1),
(12,	1),
(13,	1),
(14,	1),
(15,	1),
(16,	1),
(17,	1),
(18,	1),
(19,	1),
(20,	1),
(21,	1),
(22,	1),
(23,	1),
(24,	1),
(25,	13),
(26,	1),
(27,	1),
(28,	1),
(29,	1),
(30,	1),
(31,	1),
(32,	1),
(33,	10),
(34,	13),
(35,	13),
(36,	12),
(37,	1),
(38,	1),
(39,	11),
(39,	13),
(40,	14),
(41,	13),
(42,	1),
(42,	4),
(42,	13),
(42,	14),
(43,	1),
(44,	5),
(45,	1),
(46,	1),
(47,	1),
(48,	1),
(48,	4),
(48,	14),
(49,	30),
(50,	1),
(50,	14);

DROP TABLE IF EXISTS `business_context_focus_areas`;
CREATE TABLE `business_context_focus_areas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_context_id` int(10) unsigned NOT NULL,
  `title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `business_context_issue_categories`;
CREATE TABLE `business_context_issue_categories` (
  `business_context_id` int(10) unsigned NOT NULL,
  `issue_category_id` int(10) unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `business_context_issue_categories` (`business_context_id`, `issue_category_id`) VALUES
(1,	9),
(1,	1),
(3,	8),
(7,	8),
(7,	3),
(8,	10),
(8,	6),
(9,	9),
(9,	1),
(10,	8),
(10,	3),
(11,	10),
(12,	8),
(12,	1),
(13,	9),
(13,	1),
(14,	9),
(15,	9),
(15,	5),
(17,	8),
(18,	8),
(19,	8),
(20,	9),
(21,	9),
(21,	1),
(22,	9),
(23,	8),
(26,	8),
(26,	2),
(27,	8),
(27,	3),
(28,	8),
(24,	8),
(24,	1),
(30,	8),
(30,	1),
(31,	8),
(31,	1),
(29,	8),
(29,	1),
(32,	8),
(32,	1),
(34,	8),
(34,	2),
(35,	8),
(35,	1),
(5,	8),
(5,	1),
(4,	8),
(37,	9),
(37,	1),
(38,	8),
(38,	1),
(41,	9),
(41,	2),
(25,	8),
(25,	2),
(2,	9),
(2,	1),
(16,	8),
(16,	2),
(43,	8),
(43,	1),
(44,	8),
(45,	8),
(45,	2),
(40,	8),
(40,	2),
(46,	9),
(46,	2),
(47,	8),
(47,	1),
(33,	9),
(33,	1),
(42,	8),
(42,	1),
(49,	9),
(49,	2),
(36,	8),
(36,	1),
(39,	8),
(39,	1),
(48,	9),
(50,	8);

DROP TABLE IF EXISTS `business_context_issue_types`;
CREATE TABLE `business_context_issue_types` (
  `business_context_id` int(10) unsigned NOT NULL,
  `risk_issue_type_id` int(10) unsigned NOT NULL,
  KEY `business_context_issue_type_index` (`business_context_id`,`risk_issue_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `business_context_issue_types` (`business_context_id`, `risk_issue_type_id`) VALUES
(1,	1),
(2,	1),
(3,	2),
(4,	1),
(4,	2),
(5,	1),
(7,	1),
(8,	1),
(8,	2),
(9,	1),
(10,	1),
(11,	1),
(12,	1),
(13,	1),
(14,	1),
(15,	1),
(16,	1),
(16,	2),
(17,	2),
(18,	1),
(19,	1),
(20,	1),
(21,	1),
(22,	1),
(23,	1),
(24,	1),
(25,	1),
(26,	1),
(27,	1),
(28,	1),
(29,	2),
(30,	1),
(31,	2),
(32,	1),
(33,	1),
(34,	1),
(35,	1),
(36,	1),
(37,	2),
(38,	1),
(39,	2),
(40,	2),
(41,	1),
(42,	2),
(43,	1),
(44,	1),
(45,	1),
(46,	1),
(47,	1),
(48,	2),
(49,	1),
(50,	2);

DROP TABLE IF EXISTS `business_context_management_systems`;
CREATE TABLE `business_context_management_systems` (
  `business_context_id` int(10) unsigned NOT NULL,
  `management_system_type_id` int(10) unsigned NOT NULL,
  KEY `business_context_management_system_index` (`business_context_id`,`management_system_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `business_context_management_systems` (`business_context_id`, `management_system_type_id`) VALUES
(1,	3),
(2,	2),
(3,	1),
(4,	1),
(5,	3),
(5,	4),
(5,	8),
(5,	13),
(7,	12),
(8,	12),
(9,	3),
(10,	1),
(11,	3),
(12,	3),
(13,	1),
(14,	3),
(15,	3),
(16,	3),
(17,	3),
(18,	3),
(19,	3),
(20,	2),
(21,	3),
(22,	1),
(23,	15),
(24,	2),
(25,	2),
(26,	3),
(27,	3),
(28,	12),
(28,	13),
(29,	7),
(29,	8),
(30,	2),
(31,	3),
(31,	9),
(32,	3),
(33,	2),
(34,	15),
(35,	2),
(36,	8),
(37,	3),
(38,	3),
(39,	2),
(40,	9),
(41,	3),
(42,	4),
(43,	2),
(44,	8),
(45,	3),
(46,	4),
(47,	3),
(49,	3),
(50,	2);

DROP TABLE IF EXISTS `business_context_responsible_users`;
CREATE TABLE `business_context_responsible_users` (
  `business_context_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `business_context_responsible_users` (`business_context_id`, `user_id`, `created_at`, `updated_at`) VALUES
(1,	1,	NULL,	NULL),
(3,	53,	NULL,	NULL),
(3,	1,	NULL,	NULL),
(7,	53,	NULL,	NULL),
(7,	1,	NULL,	NULL),
(8,	53,	NULL,	NULL),
(9,	53,	NULL,	NULL),
(10,	297,	NULL,	NULL),
(10,	353,	NULL,	NULL),
(11,	297,	NULL,	NULL),
(12,	297,	NULL,	NULL),
(12,	53,	NULL,	NULL),
(13,	1,	NULL,	NULL),
(14,	297,	NULL,	NULL),
(15,	297,	NULL,	NULL),
(17,	297,	NULL,	NULL),
(18,	297,	NULL,	NULL),
(19,	1,	NULL,	NULL),
(20,	297,	NULL,	NULL),
(20,	1,	NULL,	NULL),
(21,	297,	NULL,	NULL),
(22,	1,	NULL,	NULL),
(22,	53,	NULL,	NULL),
(23,	297,	NULL,	NULL),
(26,	53,	NULL,	NULL),
(27,	1,	NULL,	NULL),
(28,	297,	NULL,	NULL),
(24,	53,	NULL,	NULL),
(30,	297,	NULL,	NULL),
(31,	1,	NULL,	NULL),
(29,	1,	NULL,	NULL),
(32,	1,	NULL,	NULL),
(34,	61,	NULL,	NULL),
(35,	61,	NULL,	NULL),
(5,	53,	NULL,	NULL),
(5,	353,	NULL,	NULL),
(4,	17,	NULL,	NULL),
(4,	44,	NULL,	NULL),
(37,	1,	NULL,	NULL),
(38,	1,	NULL,	NULL),
(41,	529,	NULL,	NULL),
(25,	359,	NULL,	NULL),
(2,	1,	NULL,	NULL),
(16,	297,	NULL,	NULL),
(43,	297,	NULL,	NULL),
(44,	22,	NULL,	NULL),
(45,	1,	NULL,	NULL),
(45,	297,	NULL,	NULL),
(40,	119,	NULL,	NULL),
(46,	1,	NULL,	NULL),
(47,	1,	NULL,	NULL),
(33,	20,	NULL,	NULL),
(42,	1,	NULL,	NULL),
(49,	147,	NULL,	NULL),
(36,	26,	NULL,	NULL),
(36,	104,	NULL,	NULL),
(36,	59,	NULL,	NULL),
(39,	491,	NULL,	NULL),
(39,	102,	NULL,	NULL),
(48,	1,	NULL,	NULL),
(50,	231,	NULL,	NULL);

DROP TABLE IF EXISTS `business_context_review_histories`;
CREATE TABLE `business_context_review_histories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_context_id` int(11) NOT NULL,
  `reviewed_by` int(11) NOT NULL,
  `reviewed_at` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `business_context_review_histories` (`id`, `business_context_id`, `reviewed_by`, `reviewed_at`) VALUES
(3,	1,	1,	'2019-10-04'),
(4,	2,	1,	'2019-10-04'),
(5,	3,	1,	'2019-10-04'),
(6,	5,	1,	'2019-10-23'),
(7,	7,	1,	'2019-11-21'),
(8,	18,	1,	'2019-12-27'),
(9,	21,	297,	'2019-12-31'),
(10,	25,	1,	'2020-01-02'),
(11,	26,	53,	'2020-01-03'),
(12,	27,	1,	'2020-01-04'),
(13,	28,	1,	'2020-01-06'),
(14,	29,	1,	'2020-01-06'),
(15,	24,	53,	'2020-01-07'),
(16,	31,	1,	'2020-01-10'),
(17,	32,	1,	'2020-01-16'),
(18,	36,	1,	'2020-01-17'),
(19,	38,	1,	'2020-01-18'),
(20,	32,	1,	'2020-01-18'),
(21,	38,	1,	'2020-01-20'),
(22,	43,	297,	'2020-01-20'),
(23,	43,	243,	'2020-01-20'),
(24,	44,	243,	'2020-01-20'),
(25,	44,	22,	'2020-01-20'),
(26,	40,	1,	'2020-01-24'),
(27,	46,	1,	'2020-01-28'),
(28,	46,	1,	'2020-01-28'),
(29,	47,	1,	'2020-01-29'),
(30,	47,	1,	'2020-01-29'),
(31,	42,	1,	'2020-01-31'),
(32,	48,	1,	'2020-01-31'),
(33,	50,	1,	'2020-02-03'),
(34,	48,	1,	'2020-02-07'),
(35,	50,	1,	'2020-02-07'),
(36,	50,	1,	'2020-02-07'),
(37,	45,	1,	'2020-03-04'),
(38,	50,	1,	'2020-03-04'),
(39,	50,	1,	'2020-04-16');

DROP TABLE IF EXISTS `business_context_sections`;
CREATE TABLE `business_context_sections` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_context_id` int(10) unsigned NOT NULL,
  `section_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `business_context_sections` (`id`, `business_context_id`, `section_id`) VALUES
(1,	3,	39),
(8,	7,	39),
(9,	8,	39),
(10,	10,	39),
(11,	11,	39),
(16,	12,	39),
(22,	13,	39),
(26,	15,	39),
(27,	17,	39),
(28,	19,	39),
(29,	20,	39),
(30,	21,	39),
(32,	22,	39),
(38,	26,	39),
(42,	27,	39),
(43,	28,	39),
(45,	24,	39),
(46,	30,	39),
(48,	31,	39),
(49,	29,	39),
(51,	32,	39),
(53,	34,	49),
(55,	35,	49),
(59,	5,	39),
(61,	4,	1),
(65,	37,	39),
(69,	38,	39),
(76,	41,	26),
(81,	25,	49),
(83,	2,	49),
(84,	16,	39),
(86,	43,	39),
(88,	44,	45),
(91,	45,	39),
(93,	40,	30),
(95,	46,	39),
(96,	47,	39),
(97,	33,	17),
(98,	42,	26),
(101,	49,	67),
(103,	36,	23),
(104,	39,	26),
(106,	48,	1),
(109,	50,	39);

DROP TABLE IF EXISTS `business_context_stakeholders`;
CREATE TABLE `business_context_stakeholders` (
  `business_context_id` int(11) DEFAULT NULL,
  `stakeholder_id` int(11) DEFAULT NULL,
  `ms_type_id` int(11) DEFAULT NULL,
  `issue_id` int(11) DEFAULT NULL,
  `department_id` int(11) DEFAULT NULL,
  `focus_areas` text COLLATE utf8mb4_unicode_ci,
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `business_context_stakeholder_index` (`business_context_id`,`stakeholder_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `business_context_stakeholders` (`business_context_id`, `stakeholder_id`, `ms_type_id`, `issue_id`, `department_id`, `focus_areas`, `id`) VALUES
(1,	3,	3,	87,	1,	'user',	1042),
(3,	7,	1,	4,	1,	'system',	1044),
(NULL,	1,	17,	NULL,	1,	'xzc',	1053),
(7,	3,	12,	129,	1,	'test',	1072),
(8,	5,	12,	91,	1,	'test',	1073),
(9,	1,	3,	121,	1,	'klk',	1074),
(10,	1,	1,	129,	1,	'test',	1075),
(11,	7,	3,	121,	1,	'KJ',	1076),
(12,	5,	3,	119,	1,	'zx',	1079),
(13,	1,	1,	4,	1,	'test',	1094),
(13,	5,	1,	4,	1,	'test test',	1095),
(13,	7,	1,	4,	1,	'adasda',	1096),
(13,	7,	1,	4,	1,	'tst',	1097),
(14,	7,	3,	121,	1,	'asd',	1101),
(15,	7,	3,	91,	1,	'xcd',	1104),
(17,	5,	3,	121,	1,	'xzxz',	1109),
(18,	5,	3,	61,	1,	'aasdfasdf',	1110),
(19,	3,	3,	4,	1,	'test',	1111),
(20,	1,	2,	91,	1,	'ggh',	1112),
(21,	1,	3,	129,	1,	'assas',	1113),
(22,	3,	1,	91,	1,	'sample',	1115),
(23,	5,	15,	87,	1,	'nmm',	1116),
(26,	1,	3,	119,	1,	'sample',	1125),
(27,	1,	3,	119,	1,	'sample',	1129),
(28,	1,	12,	91,	1,	'Test',	1130),
(28,	3,	12,	91,	1,	'Test',	1131),
(28,	1,	13,	91,	1,	'Test',	1132),
(28,	3,	13,	91,	1,	'Test',	1133),
(24,	1,	2,	129,	1,	'sample docs',	1136),
(30,	7,	2,	4,	1,	'test',	1137),
(31,	5,	3,	61,	1,	'test',	1140),
(31,	5,	9,	61,	1,	'test',	1141),
(29,	3,	7,	9,	1,	'authorised',	1142),
(29,	3,	8,	9,	1,	'authorised',	1143),
(32,	3,	3,	121,	1,	'external',	1145),
(NULL,	1,	10,	NULL,	2,	'xcscs',	1147),
(NULL,	3,	10,	NULL,	4,	'xcxc',	1148),
(34,	3,	15,	87,	13,	'samples',	1149),
(35,	1,	2,	4,	13,	'sample',	1151),
(5,	1,	3,	160,	1,	'gd',	1155),
(5,	1,	3,	160,	1,	'test',	1156),
(5,	1,	3,	160,	1,	'xcxc',	1157),
(5,	1,	4,	160,	1,	'gd',	1158),
(5,	1,	4,	160,	1,	'test',	1159),
(5,	1,	4,	160,	1,	'xcxc',	1160),
(5,	1,	8,	160,	1,	'gd',	1161),
(5,	1,	8,	160,	1,	'test',	1162),
(5,	1,	8,	160,	1,	'xcxc',	1163),
(5,	1,	13,	160,	1,	'gd',	1164),
(5,	1,	13,	160,	1,	'test',	1165),
(5,	1,	13,	160,	1,	'xcxc',	1166),
(4,	1,	1,	91,	4,	'test',	1168),
(4,	1,	1,	91,	4,	'test 2',	1169),
(37,	7,	3,	141,	1,	'asasa',	1174),
(37,	9,	3,	141,	1,	'asas',	1175),
(38,	5,	3,	87,	1,	'sample',	1179),
(41,	3,	3,	91,	13,	'frr',	1186),
(41,	3,	3,	91,	13,	'grtgrtgtr',	1187),
(41,	3,	3,	91,	13,	'gtrgt',	1188),
(41,	1,	3,	91,	13,	'rgtrgr',	1189),
(41,	1,	3,	91,	13,	'rgtgtr',	1190),
(41,	1,	3,	91,	13,	'rgtgrt',	1191),
(41,	7,	3,	91,	13,	'gtrgtrgrt',	1192),
(41,	7,	3,	91,	13,	'grtgtrgr',	1193),
(41,	7,	3,	91,	13,	'grtgrt',	1194),
(25,	3,	2,	129,	13,	'nmm',	1199),
(2,	1,	2,	61,	1,	'issue',	1201),
(16,	7,	3,	87,	1,	'dsdsa',	1202),
(43,	5,	2,	61,	1,	'boards',	1204),
(44,	11,	8,	9,	5,	'dfe',	1206),
(45,	7,	3,	87,	1,	'cabinet',	1209),
(NULL,	1,	3,	NULL,	10,	'frtgty',	1210),
(40,	3,	9,	87,	14,	'dfdf',	1212),
(46,	15,	4,	73,	1,	'test',	1214),
(47,	3,	3,	161,	1,	'sample',	1215),
(33,	3,	2,	61,	10,	'external',	1216),
(42,	3,	4,	141,	13,	'gthy',	1217),
(42,	3,	4,	141,	1,	'gthy',	1218),
(42,	3,	4,	141,	14,	'gthy',	1219),
(42,	3,	4,	141,	4,	'gthy',	1220),
(49,	3,	3,	129,	30,	'gt',	1225),
(36,	1,	8,	9,	12,	'sazsas',	1227),
(39,	1,	2,	121,	13,	'sasd',	1228),
(39,	1,	2,	121,	11,	'sasd',	1229),
(50,	1,	2,	87,	1,	'test',	1248),
(50,	7,	2,	87,	1,	'tt',	1249),
(50,	1,	2,	87,	14,	'test',	1250),
(50,	7,	2,	87,	14,	'tt',	1251);

DROP TABLE IF EXISTS `business_context_sub_processes`;
CREATE TABLE `business_context_sub_processes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_context_id` int(10) unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `business_impact_analysis`;
CREATE TABLE `business_impact_analysis` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `audit_finding_id` int(10) unsigned NOT NULL,
  `impact_goal_id` int(10) unsigned NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `time` int(11) DEFAULT NULL,
  `count` int(11) DEFAULT NULL,
  `gain` int(11) DEFAULT NULL,
  `lost` int(11) DEFAULT NULL,
  `remarks` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `business_impact_analysis` (`id`, `audit_finding_id`, `impact_goal_id`, `description`, `time`, `count`, `gain`, `lost`, `remarks`, `created_at`, `updated_at`, `created_by`) VALUES
(1,	11,	1,	'In 2012, we created the Fair Education Impact Goals. These are five targets which, if achieved by 2022, will substantially reduce educational inequality. The goals follow the educational journey of a child from primary school through to higher education and employment. We measure progress against them every year, and present our findings in our annual report card.',	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-12-23 10:36:44',	'2019-12-23 10:36:44',	8),
(2,	11,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-12-23 10:36:44',	'2019-12-23 10:36:44',	8),
(3,	11,	3,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-12-23 10:36:44',	'2019-12-23 10:36:44',	8),
(4,	11,	4,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-12-23 10:36:44',	'2019-12-23 10:36:44',	8),
(5,	11,	5,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-12-23 10:36:44',	'2019-12-23 10:36:44',	8),
(6,	11,	6,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-12-23 10:36:44',	'2019-12-23 10:36:44',	8),
(7,	11,	7,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-12-23 10:36:44',	'2019-12-23 10:36:44',	8),
(23,	13,	1,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-12-31 12:32:23',	'2019-12-31 12:32:23',	1),
(24,	13,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-12-31 12:32:23',	'2019-12-31 12:32:23',	1),
(25,	13,	3,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-12-31 12:32:23',	'2019-12-31 12:32:23',	1),
(26,	13,	4,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-12-31 12:32:23',	'2019-12-31 12:32:23',	1),
(27,	13,	5,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-12-31 12:32:23',	'2019-12-31 12:32:23',	1),
(28,	13,	6,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-12-31 12:32:23',	'2019-12-31 12:32:23',	1),
(29,	13,	7,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2019-12-31 12:32:23',	'2019-12-31 12:32:23',	1),
(37,	48,	7,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-08 11:19:47',	'2020-01-08 11:19:47',	243),
(45,	57,	7,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 10:10:17',	'2020-01-17 10:10:17',	1),
(53,	58,	7,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 10:26:07',	'2020-01-17 10:26:07',	1),
(54,	61,	1,	'In 2012, we created the Fair Education Impact Goals. These are five targets which, if achieved by 2022, will substantially reduce educational inequality. The goals follow the educational journey of a child from primary school through to higher education and employment. We measure progress against them every year, and present our findings in our annual report card.',	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 16:11:41',	'2020-01-17 16:11:41',	1),
(55,	61,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 16:11:41',	'2020-01-17 16:11:41',	1),
(56,	61,	3,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 16:11:41',	'2020-01-17 16:11:41',	1),
(57,	61,	4,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 16:11:41',	'2020-01-17 16:11:41',	1),
(58,	61,	5,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 16:11:41',	'2020-01-17 16:11:41',	1),
(59,	61,	6,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 16:11:41',	'2020-01-17 16:11:41',	1),
(60,	61,	7,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-17 16:11:41',	'2020-01-17 16:11:41',	1),
(62,	63,	7,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-18 14:57:44',	'2020-01-18 14:57:44',	1),
(63,	64,	7,	NULL,	0,	0,	0,	0,	NULL,	'2020-01-18 15:18:49',	'2020-01-18 15:18:49',	1),
(64,	74,	1,	'In 2012, we created the Fair Education Impact Goals. These are five targets which, if achieved by 2022, will substantially reduce educational inequality. The goals follow the educational journey of a child from primary school through to higher education and employment. We measure progress against them every year, and present our findings in our annual report card.',	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-23 14:26:50',	'2020-01-23 14:26:50',	62),
(65,	74,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-23 14:26:50',	'2020-01-23 14:26:50',	62),
(66,	74,	3,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-23 14:26:50',	'2020-01-23 14:26:50',	62),
(67,	74,	4,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-23 14:26:50',	'2020-01-23 14:26:50',	62),
(68,	74,	5,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-23 14:26:50',	'2020-01-23 14:26:50',	62),
(69,	74,	6,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-23 14:26:50',	'2020-01-23 14:26:50',	62),
(70,	74,	7,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-01-23 14:26:50',	'2020-01-23 14:26:50',	62),
(71,	93,	1,	'In 2012, we created the Fair Education Impact Goals. These are five targets which, if achieved by 2022, will substantially reduce educational inequality. The goals follow the educational journey of a child from primary school through to higher education and employment. We measure progress against them every year, and present our findings in our annual report card.',	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-02-24 12:36:04',	'2020-02-24 12:36:04',	541),
(72,	91,	1,	'In 2012, we created the Fair Education Impact Goals. These are five targets which, if achieved by 2022, will substantially reduce educational inequality. The goals follow the educational journey of a child from primary school through to higher education and employment. We measure progress against them every year, and present our findings in our annual report card.',	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-09-24 08:08:12',	'2020-09-24 08:08:12',	8),
(73,	91,	2,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-09-24 08:08:12',	'2020-09-24 08:08:12',	8),
(74,	91,	3,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-09-24 08:08:12',	'2020-09-24 08:08:12',	8),
(75,	91,	4,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-09-24 08:08:12',	'2020-09-24 08:08:12',	8),
(76,	91,	5,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-09-24 08:08:12',	'2020-09-24 08:08:12',	8),
(77,	91,	6,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-09-24 08:08:12',	'2020-09-24 08:08:12',	8),
(78,	91,	7,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2020-09-24 08:08:12',	'2020-09-24 08:08:12',	8);

DROP TABLE IF EXISTS `business_impact_analysis_key`;
CREATE TABLE `business_impact_analysis_key` (
  `audit_finding_id` int(10) unsigned NOT NULL,
  `impact_goal_key_id` int(10) unsigned NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `time` int(11) DEFAULT NULL,
  `count` int(11) DEFAULT NULL,
  `gain` int(11) DEFAULT NULL,
  `lost` int(11) DEFAULT NULL,
  `remarks` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  PRIMARY KEY (`audit_finding_id`,`impact_goal_key_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `business_impact_analysis_key` (`audit_finding_id`, `impact_goal_key_id`, `description`, `time`, `count`, `gain`, `lost`, `remarks`, `created_at`, `updated_at`, `created_by`) VALUES
(11,	1,	NULL,	0,	0,	0,	0,	NULL,	'2019-12-23 10:36:44',	'2019-12-23 10:36:44',	8),
(11,	2,	NULL,	0,	0,	0,	0,	NULL,	'2019-12-23 10:36:44',	'2019-12-23 10:36:44',	8),
(11,	3,	NULL,	0,	0,	0,	0,	NULL,	'2019-12-23 10:36:44',	'2019-12-23 10:36:44',	8),
(11,	4,	NULL,	0,	0,	0,	0,	NULL,	'2019-12-23 10:36:44',	'2019-12-23 10:36:44',	8),
(11,	5,	NULL,	0,	0,	0,	0,	NULL,	'2019-12-23 10:36:44',	'2019-12-23 10:36:44',	8),
(11,	6,	NULL,	0,	0,	0,	0,	NULL,	'2019-12-23 10:36:44',	'2019-12-23 10:36:44',	8),
(11,	7,	NULL,	0,	0,	0,	0,	NULL,	'2019-12-23 10:36:44',	'2019-12-23 10:36:44',	8),
(11,	8,	NULL,	0,	0,	0,	0,	NULL,	'2019-12-23 10:36:44',	'2019-12-23 10:36:44',	8),
(11,	9,	NULL,	0,	0,	0,	0,	NULL,	'2019-12-23 10:36:44',	'2019-12-23 10:36:44',	8),
(11,	10,	NULL,	0,	0,	0,	0,	NULL,	'2019-12-23 10:36:44',	'2019-12-23 10:36:44',	8),
(11,	11,	NULL,	0,	0,	0,	0,	NULL,	'2019-12-23 10:36:44',	'2019-12-23 10:36:44',	8),
(11,	13,	NULL,	0,	0,	10,	0,	NULL,	'2019-12-23 10:36:44',	'2019-12-23 10:36:44',	8),
(13,	1,	NULL,	0,	0,	0,	0,	NULL,	'2019-12-31 12:32:23',	'2019-12-31 12:32:23',	1),
(13,	2,	NULL,	0,	0,	0,	0,	NULL,	'2019-12-31 12:32:23',	'2019-12-31 12:32:23',	1),
(13,	4,	NULL,	0,	0,	0,	0,	NULL,	'2019-12-31 12:32:23',	'2019-12-31 12:32:23',	1),
(13,	5,	NULL,	0,	0,	0,	0,	NULL,	'2019-12-31 12:32:23',	'2019-12-31 12:32:23',	1),
(13,	6,	NULL,	0,	0,	0,	0,	NULL,	'2019-12-31 12:32:23',	'2019-12-31 12:32:23',	1),
(13,	7,	NULL,	0,	0,	10,	10,	NULL,	'2019-12-31 12:32:23',	'2019-12-31 12:32:23',	1),
(13,	8,	NULL,	200,	0,	0,	0,	NULL,	'2019-12-31 12:32:23',	'2019-12-31 12:32:23',	1),
(13,	9,	NULL,	0,	10,	0,	0,	NULL,	'2019-12-31 12:32:23',	'2019-12-31 12:32:23',	1),
(13,	13,	NULL,	10,	0,	0,	0,	NULL,	'2019-12-31 12:32:23',	'2019-12-31 12:32:23',	1),
(48,	13,	NULL,	0,	100,	0,	0,	NULL,	'2020-01-08 11:19:47',	'2020-01-08 11:19:47',	243),
(57,	13,	'wrh34u',	48545,	785,	785,	785,	'srey',	'2020-01-17 10:10:17',	'2020-01-17 10:10:17',	1),
(58,	13,	'fgjt',	5,	543,	5327,	73,	'dt',	'2020-01-17 10:26:07',	'2020-01-17 10:26:07',	1),
(61,	1,	NULL,	0,	0,	0,	0,	NULL,	'2020-01-17 16:11:41',	'2020-01-17 16:11:41',	1),
(61,	2,	NULL,	0,	0,	0,	0,	NULL,	'2020-01-17 16:11:41',	'2020-01-17 16:11:41',	1),
(61,	3,	NULL,	0,	0,	0,	0,	NULL,	'2020-01-17 16:11:41',	'2020-01-17 16:11:41',	1),
(61,	4,	NULL,	0,	0,	0,	0,	NULL,	'2020-01-17 16:11:41',	'2020-01-17 16:11:41',	1),
(61,	5,	NULL,	0,	0,	0,	0,	NULL,	'2020-01-17 16:11:41',	'2020-01-17 16:11:41',	1),
(61,	6,	NULL,	0,	0,	0,	0,	NULL,	'2020-01-17 16:11:41',	'2020-01-17 16:11:41',	1),
(61,	7,	NULL,	0,	0,	0,	0,	NULL,	'2020-01-17 16:11:41',	'2020-01-17 16:11:41',	1),
(61,	8,	NULL,	0,	0,	0,	0,	NULL,	'2020-01-17 16:11:41',	'2020-01-17 16:11:41',	1),
(61,	9,	NULL,	0,	0,	0,	0,	NULL,	'2020-01-17 16:11:41',	'2020-01-17 16:11:41',	1),
(61,	10,	NULL,	0,	0,	0,	0,	NULL,	'2020-01-17 16:11:41',	'2020-01-17 16:11:41',	1),
(61,	11,	NULL,	0,	0,	0,	0,	NULL,	'2020-01-17 16:11:41',	'2020-01-17 16:11:41',	1),
(61,	13,	'wefwe',	55,	55,	550,	550,	'jdthrt',	'2020-01-17 16:11:41',	'2020-01-17 16:11:41',	1),
(63,	13,	NULL,	0,	0,	10,	0,	NULL,	'2020-01-18 14:57:44',	'2020-01-18 14:57:44',	1),
(64,	13,	NULL,	0,	10,	0,	0,	NULL,	'2020-01-18 15:18:49',	'2020-01-18 15:18:49',	1),
(74,	1,	NULL,	0,	0,	0,	0,	NULL,	'2020-01-23 14:26:50',	'2020-01-23 14:26:50',	62),
(74,	2,	NULL,	0,	0,	0,	0,	NULL,	'2020-01-23 14:26:50',	'2020-01-23 14:26:50',	62),
(74,	3,	NULL,	0,	0,	0,	0,	NULL,	'2020-01-23 14:26:50',	'2020-01-23 14:26:50',	62),
(74,	4,	NULL,	0,	0,	0,	0,	NULL,	'2020-01-23 14:26:50',	'2020-01-23 14:26:50',	62),
(74,	5,	NULL,	0,	0,	0,	0,	NULL,	'2020-01-23 14:26:50',	'2020-01-23 14:26:50',	62),
(74,	6,	NULL,	0,	0,	0,	0,	NULL,	'2020-01-23 14:26:50',	'2020-01-23 14:26:50',	62),
(74,	7,	NULL,	0,	0,	0,	0,	NULL,	'2020-01-23 14:26:50',	'2020-01-23 14:26:50',	62),
(74,	8,	NULL,	0,	0,	0,	0,	NULL,	'2020-01-23 14:26:50',	'2020-01-23 14:26:50',	62),
(74,	9,	NULL,	0,	0,	0,	0,	NULL,	'2020-01-23 14:26:50',	'2020-01-23 14:26:50',	62),
(74,	10,	NULL,	0,	0,	0,	0,	NULL,	'2020-01-23 14:26:50',	'2020-01-23 14:26:50',	62),
(74,	11,	NULL,	0,	0,	0,	0,	NULL,	'2020-01-23 14:26:50',	'2020-01-23 14:26:50',	62),
(74,	13,	NULL,	0,	10,	0,	0,	NULL,	'2020-01-23 14:26:50',	'2020-01-23 14:26:50',	62),
(91,	1,	NULL,	0,	0,	0,	0,	NULL,	'2020-09-24 08:08:12',	'2020-09-24 08:08:12',	8),
(91,	2,	NULL,	0,	0,	0,	0,	NULL,	'2020-09-24 08:08:12',	'2020-09-24 08:08:12',	8),
(91,	3,	NULL,	0,	0,	0,	0,	NULL,	'2020-09-24 08:08:12',	'2020-09-24 08:08:12',	8),
(91,	4,	NULL,	0,	0,	0,	0,	NULL,	'2020-09-24 08:08:12',	'2020-09-24 08:08:12',	8),
(91,	5,	NULL,	0,	0,	0,	0,	NULL,	'2020-09-24 08:08:12',	'2020-09-24 08:08:12',	8),
(91,	6,	NULL,	0,	0,	0,	0,	NULL,	'2020-09-24 08:08:12',	'2020-09-24 08:08:12',	8),
(91,	7,	NULL,	0,	0,	0,	0,	NULL,	'2020-09-24 08:08:12',	'2020-09-24 08:08:12',	8),
(91,	8,	NULL,	0,	0,	0,	0,	NULL,	'2020-09-24 08:08:12',	'2020-09-24 08:08:12',	8),
(91,	9,	NULL,	0,	0,	0,	0,	NULL,	'2020-09-24 08:08:12',	'2020-09-24 08:08:12',	8),
(91,	10,	NULL,	0,	0,	0,	0,	NULL,	'2020-09-24 08:08:12',	'2020-09-24 08:08:12',	8),
(91,	11,	NULL,	0,	0,	0,	0,	NULL,	'2020-09-24 08:08:12',	'2020-09-24 08:08:12',	8),
(91,	13,	NULL,	0,	0,	0,	0,	NULL,	'2020-09-24 08:08:12',	'2020-09-24 08:08:12',	8),
(93,	1,	NULL,	0,	0,	0,	1000,	NULL,	'2020-02-24 12:36:04',	'2020-02-24 12:36:04',	541);

DROP TABLE IF EXISTS `business_profiles`;
CREATE TABLE `business_profiles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `established` date DEFAULT NULL,
  `industry_type` int(10) unsigned DEFAULT NULL,
  `employee_number` int(10) unsigned DEFAULT NULL,
  `branch_number` int(10) unsigned DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `facebook` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `twitter` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `linkedin` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `instagram` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_message` text COLLATE utf8mb4_unicode_ci,
  `company_message_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `service_number` int(11) DEFAULT NULL,
  `service_file_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `service_file_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_profile` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `organization_chart_file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `organization_chart_file_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `subsidiary_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `branch_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_profile_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '1' COMMENT '1-Business Profile, 2-Subsidiary , 3-Branch',
  `website` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT 'www.excelledia.com',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `business_profiles` (`id`, `title`, `code`, `logo_url`, `established`, `industry_type`, `employee_number`, `branch_number`, `description`, `address`, `email`, `facebook`, `twitter`, `linkedin`, `instagram`, `company_message`, `company_message_by`, `service_number`, `service_file_name`, `service_file_url`, `company_profile`, `organization_chart_file`, `organization_chart_file_url`, `created_at`, `updated_at`, `subsidiary_name`, `branch_name`, `logo_name`, `company_profile_url`, `status`, `website`) VALUES
(1,	'TRA',	NULL,	'TvTi66TUgSzByy4epbVIsDmEJ6n0Vj9pQki5vSVo.jpeg',	'2003-01-01',	1,	309,	3,	'The Telecommunications Regulatory Authority (TRA) of the United Arab Emirates (UAE) was established according to the UAE Federal Law by Decree No. 3 of 2003 – Telecom Law, on regulating the telecommunications sector in the UAE. Since its establishment, the TRA has exceeded expectations by achieving its projected goals in record time.',	NULL,	'https://www.tra.gov.ae',	'https://www.facebook.com/theuaetra',	'https://twitter.com/TheUAETRA',	'https://in.linkedin.com/company/tra-uae',	'http://instagram.com/theuaetra',	'ISOROBOT is the system that I was waiting for and finally I can depend on a reliable system to handle all management systems requirements with confidence and in a very user-friendly way',	'329',	65,	'List of Services.xls',	'lRkLeqdqZJQKjMuxQxsbiaJ0dBRsgalVHQrfyshY.xls',	'About TRA.pdf',	'ORG chart.jpeg',	'2K4vTvb5P6APLUdx4jdlBZio7vIlGXGrjJ14lFGS.jpeg',	'2018-10-09 15:31:00',	'2020-02-10 14:58:56',	NULL,	NULL,	'tra logo.jpg',	'ZMcnI78jTllDzxBLRIpV68HoftXtOFXHPwefmteZ.pdf',	1,	'http://www.tra.gov.ae'),
(2,	'TRA',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2018-10-09 15:31:21',	'2018-10-09 15:31:21',	NULL,	'Abu Dhabi',	NULL,	NULL,	3,	'www.excelledia.com'),
(3,	'TRA',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	'2018-10-09 15:31:21',	'2018-10-09 15:31:21',	NULL,	'Dubai',	NULL,	NULL,	3,	'www.excelledia.com');

DROP TABLE IF EXISTS `business_profile_management_system`;
CREATE TABLE `business_profile_management_system` (
  `business_profile_id` int(10) unsigned NOT NULL,
  `management_system_types_id` int(10) unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `business_profile_management_system` (`business_profile_id`, `management_system_types_id`) VALUES
(1,	6);

DROP TABLE IF EXISTS `business_profile_mstype_versions`;
CREATE TABLE `business_profile_mstype_versions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_profile_id` int(11) NOT NULL DEFAULT '1',
  `version_id` int(11) DEFAULT NULL,
  `mstype_id` int(11) DEFAULT NULL,
  `status` int(10) unsigned DEFAULT NULL,
  `updated_by` int(10) unsigned DEFAULT NULL,
  `deleted_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `business_profile_mstype_versions` (`id`, `business_profile_id`, `version_id`, `mstype_id`, `status`, `updated_by`, `deleted_by`, `created_at`, `updated_at`) VALUES
(1006,	1,	1,	1,	NULL,	NULL,	NULL,	NULL,	NULL),
(1007,	1,	2,	2,	NULL,	NULL,	NULL,	NULL,	NULL),
(1008,	1,	3,	3,	NULL,	NULL,	NULL,	NULL,	NULL),
(1009,	1,	4,	4,	NULL,	NULL,	NULL,	NULL,	NULL),
(1010,	1,	5,	5,	NULL,	NULL,	NULL,	NULL,	NULL),
(1011,	1,	6,	6,	NULL,	NULL,	NULL,	NULL,	NULL),
(1012,	1,	8,	8,	NULL,	NULL,	NULL,	NULL,	NULL),
(1013,	1,	7,	7,	NULL,	NULL,	NULL,	NULL,	NULL),
(1014,	1,	9,	9,	NULL,	NULL,	NULL,	NULL,	NULL),
(1015,	1,	10,	10,	NULL,	NULL,	NULL,	NULL,	NULL),
(1016,	1,	11,	11,	NULL,	NULL,	NULL,	NULL,	NULL),
(1017,	1,	13,	13,	NULL,	NULL,	NULL,	NULL,	NULL),
(1018,	1,	32,	12,	NULL,	NULL,	NULL,	NULL,	NULL),
(1019,	1,	33,	15,	NULL,	NULL,	NULL,	'2019-06-12 10:44:39',	'2019-06-12 10:44:39'),
(1020,	1,	34,	16,	NULL,	NULL,	NULL,	'2019-10-04 11:55:51',	'2019-10-04 11:55:51'),
(1021,	1,	35,	17,	NULL,	NULL,	NULL,	'2019-10-04 11:56:02',	'2019-10-04 11:56:02'),
(1022,	1,	36,	18,	NULL,	NULL,	NULL,	'2019-10-04 11:56:14',	'2019-10-04 11:56:14'),
(1023,	1,	37,	19,	NULL,	NULL,	NULL,	'2019-10-04 11:56:26',	'2019-10-04 11:56:26'),
(1024,	1,	38,	20,	NULL,	NULL,	NULL,	'2019-10-04 11:56:37',	'2019-10-04 11:56:37'),
(1025,	1,	39,	21,	NULL,	NULL,	NULL,	'2019-10-04 11:56:50',	'2019-10-04 11:56:50'),
(1026,	1,	40,	22,	NULL,	NULL,	NULL,	'2019-10-10 15:09:31',	'2019-10-10 15:09:31'),
(1027,	1,	41,	23,	NULL,	NULL,	NULL,	'2019-12-09 11:37:37',	'2019-12-09 11:37:37'),
(1028,	1,	42,	23,	NULL,	NULL,	NULL,	'2020-02-28 10:15:44',	'2020-02-28 10:15:44');

DROP TABLE IF EXISTS `business_profile_products`;
CREATE TABLE `business_profile_products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_profile_id` int(11) NOT NULL,
  `product_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `business_profile_services`;
CREATE TABLE `business_profile_services` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_profile_id` int(11) NOT NULL,
  `service_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `business_profile_services` (`id`, `business_profile_id`, `service_name`) VALUES
(97,	1,	'65');

DROP TABLE IF EXISTS `calculation_methods`;
CREATE TABLE `calculation_methods` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `updated_by` int(10) unsigned DEFAULT NULL,
  `deleted_by` int(10) unsigned DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `calculation_methods` (`id`, `title`, `created_at`, `updated_at`, `created_by`, `updated_by`, `deleted_by`, `status`) VALUES
(1,	'Top 2 Boxes',	'2018-11-27 09:21:40',	'2018-11-27 09:21:40',	1,	NULL,	NULL,	1),
(2,	'Top Box',	'2018-11-27 09:21:40',	'2018-11-27 09:21:40',	1,	NULL,	NULL,	1),
(3,	'PTM',	'2018-11-27 09:21:40',	'2018-11-27 09:21:40',	1,	NULL,	NULL,	1),
(4,	'Average',	'2018-11-27 09:21:40',	'2018-11-27 09:21:40',	1,	NULL,	NULL,	1),
(5,	'Weighted Average',	'2018-11-27 09:21:40',	'2018-11-27 09:21:40',	1,	NULL,	NULL,	1);

DROP TABLE IF EXISTS `categories`;
CREATE TABLE `categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `created_by` int(10) unsigned NOT NULL,
  `updated_by` int(10) unsigned DEFAULT NULL,
  `deleted_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `categories` (`id`, `title`, `status`, `created_by`, `updated_by`, `deleted_by`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1,	'Quality',	1,	1,	NULL,	NULL,	'2018-10-10 12:40:13',	'2018-10-10 12:40:13',	NULL);

DROP TABLE IF EXISTS `certification_bodies`;
CREATE TABLE `certification_bodies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `updated_by` int(10) unsigned DEFAULT NULL,
  `deleted_by` int(10) unsigned DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `certification_bodies` (`id`, `title`, `description`, `created_at`, `updated_at`, `created_by`, `updated_by`, `deleted_by`, `status`) VALUES
(1,	'Cirtification 1',	NULL,	'2018-10-03 14:29:19',	'2018-10-03 14:29:19',	1,	NULL,	NULL,	1),
(2,	'Cirtification 2',	NULL,	'2018-10-03 14:29:19',	'2018-10-03 14:29:19',	1,	NULL,	NULL,	1),
(3,	'Cirtification 1',	NULL,	'2018-10-03 14:29:20',	'2018-10-03 14:29:20',	1,	NULL,	NULL,	1),
(4,	'Cirtification 2',	NULL,	'2018-10-03 14:29:20',	'2018-10-03 14:29:20',	1,	NULL,	NULL,	1);

DROP TABLE IF EXISTS `checklists`;
CREATE TABLE `checklists` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `clause_id` int(11) DEFAULT NULL,
  `question` text COLLATE utf8mb4_unicode_ci,
  `status` int(11) DEFAULT NULL,
  `score` int(11) DEFAULT NULL,
  `checklist_score` int(11) NOT NULL DEFAULT '0',
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `comments` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `checklists` (`id`, `clause_id`, `question`, `status`, `score`, `checklist_score`, `created_by`, `updated_by`, `comments`, `created_at`, `updated_at`) VALUES
(109,	396,	'Have we determined external and internal issues relevant to the QMS achieving its aim',	0,	0,	0,	NULL,	1,	NULL,	'2019-02-20 08:45:01',	'2019-05-10 12:16:53'),
(110,	396,	'Do we monitor and review these issues',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 08:45:01',	'2019-02-20 08:45:01'),
(111,	396,	'Have you determined the external and internal issues that are relevant to your organization’s QMS?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 08:45:01',	'2019-02-20 08:45:01'),
(112,	396,	'SWOT Analysis done?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 08:45:01',	'2019-02-20 08:45:01'),
(113,	397,	'Have we determined what interested parties are relevant to the QMS and what are their requirements',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 08:45:47',	'2019-02-20 08:45:47'),
(114,	397,	'Do we monitor and review this',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 08:45:47',	'2019-02-20 08:45:47'),
(115,	398,	'Have we determined the boundaries of the QMS when establishing its scope. Did we consider: (a) external and internal issues (b) the requirements of relevant interested parties (c) our products and/or services',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 08:46:27',	'2019-02-20 08:46:27'),
(116,	398,	'Have we documented the scope?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 08:46:27',	'2019-02-20 08:46:27'),
(117,	398,	'Have we considered this standard and have we justified any exclusion?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 08:46:27',	'2019-02-20 08:46:27'),
(118,	399,	'Have we determined (a) the processes for the system and how they are to be applied (b) the inputs and outputs for those processes (c) how processes interrelate (d) methods to operate and control processes (e) resources and their availability and responsibilities',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 08:47:06',	'2019-02-20 08:47:06'),
(119,	399,	'Have we evaluated risks and opportunities, processes and their implementation As necessary, have we got documented information, that gives us confidence that we are carrying out activities as planned?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 08:47:06',	'2019-02-20 08:47:06'),
(121,	400,	'Can we demonstrate top management is providing leadership and commitment to the QMS including taking accountability for: (a) the QMS (b) policy and objectives being compatible with strategy (c) integration of the QMS into business systems (d) promoting process and risk approach (e) ensuring the QMS is resourced (f) communicating the QMS (g) ensuring the QMS achieves its intended results (h) promoting improvement (i) supporting others',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 08:48:58',	'2019-02-20 08:48:58'),
(122,	402,	'CUSTOMER FOCUS Can we demonstrate that top management actively provides leadership by ensuring: (a) customer requirements and applicable statutory and regulatory requirements are determined and met (b) risks and opportunities that can affect the products and services are determined and addressed (c) customer satisfaction determined, maintained and enhanced',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 08:49:20',	'2019-02-20 08:49:20'),
(123,	407,	'Have we determined the risks and opportunities that need to be addressed to: (a) assure the QMS achieves its intended results (b) avoid or mitigate negative effects, enhance positive effects (c) achieve improvement Have we planned: (a) actions to address these risks and opportunities (b) how to integrate these actions into the QMS',	0,	0,	0,	NULL,	NULL,	NULL,	'2019-02-20 08:50:12',	'2019-03-13 15:01:30'),
(124,	408,	'Have we established quality objectives at relevant functions and levels and are they: (a) consistent with the policy (b) measurable, monitored, communicated and updated as appropriate (c) relevant to conformity of products and services and the enhancement of customer satisfaction and take into account all applicable requirements',	0,	0,	0,	NULL,	NULL,	NULL,	'2019-02-20 08:50:50',	'2019-03-13 14:56:07'),
(125,	408,	'Do we retain documented information on the quality objectives?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 08:50:50',	'2019-02-20 08:50:50'),
(126,	408,	'In planning how to achieve our quality objectives, have we determined (a) what will be done (b) what resources will be required (c) who will be responsible (d) when it will be completed (e) how the results will be evaluated',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 08:50:50',	'2019-02-20 08:50:50'),
(127,	409,	'Where we need to make changes to the QMS is it planned and do we consider: (a) the purpose and potential consequences (b) the integrity of the QMS (c) the availability of resources (d) changes to responsibilities and authorities',	0,	0,	0,	NULL,	NULL,	NULL,	'2019-02-20 08:51:14',	'2019-03-13 14:54:52'),
(128,	410,	'Have we determined and provide the resources needed for the QMS? Have we considered (a) the capabilities of, and constraints on existing resources (b) what needs to be obtained from external providers',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 09:06:39',	'2019-02-20 09:06:39'),
(129,	411,	'Have we determined and provide the resources needed for the QMS? Have we considered (a) the capabilities of, and constraints on existing resources (b) what needs to be obtained from external providers',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 09:07:02',	'2019-02-20 09:07:02'),
(130,	412,	'Have we provided the persons necessary for the QMS',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 09:07:26',	'2019-02-20 09:07:26'),
(131,	413,	'Do we provide and maintain the necessary infrastructure (such as buildings, technology, equipment)',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 09:07:49',	'2019-02-20 09:07:49'),
(132,	414,	'Do we provide and maintain the environment necessary for operations (such as temperature, humidity, ergonomics and cleanliness).',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 09:08:26',	'2019-02-20 09:08:26'),
(133,	415,	'Have we ensured that the resources provided: (a) are suitable for the specific type of monitoring and measurement activities being undertaken (b) are maintained to ensure their continued fitness for their purpose',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 09:09:18',	'2019-02-20 09:09:18'),
(134,	415,	'Have we retained appropriate documented information as evidence?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 09:09:18',	'2019-02-20 09:09:18'),
(135,	415,	'Have we processes in place to (a) verify or calibrate measurement instruments against reliable standards (b) identify measurement instruments in order to determine their calibration status (c) safeguarded measurement instruments from adjustments, damage or deterioration',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 09:09:18',	'2019-02-20 09:09:18'),
(136,	415,	'Have corrective actions been undertaken when issues arise with measurement instruments ​',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 09:09:18',	'2019-02-20 09:09:18'),
(137,	418,	'Have we determined and made available the knowledge necessary for (a) the operation of our processes and (b) achieving conformity of products and services',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 09:15:52',	'2019-02-20 09:15:52'),
(138,	418,	'Do we determine how to access additional knowledge for addressing change in our business',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 09:15:52',	'2019-02-20 09:15:52'),
(139,	420,	'Do we (a) determine the necessary competence of person(s) that could affect the QMS (b) ensure that these person(s) are competent on the basis of appropriate education, training, or experience (c) take actions to access the necessary competence where applicable (d) retain appropriate documented information as evidence of competence',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 09:16:33',	'2019-02-20 09:16:33'),
(140,	421,	'Have we ensured that person(s) doing work under the control of our business are aware of (a) the quality policy and relevant quality objectives (b) their contribution to the effectiveness of the QMS, including the benefits of improved quality performance (c) the implications of not conforming with the quality management system requirements',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 09:16:55',	'2019-02-20 09:16:55'),
(141,	422,	'Have we determined the internal and external communications relevant to the QMS including: (a) what will be communicated (b) when to communicate (c) with whom to communicate (d) how to communicate (e) Who communicates',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 09:17:17',	'2019-02-20 09:17:17'),
(142,	424,	'Does our QMS include (a) documented information required by the standard (b) documented information necessary for the effectiveness of the QMS',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 09:17:45',	'2019-02-20 09:17:45'),
(143,	425,	'Do we ensure we have (a) identification and description (such as a title, date, author, or reference number) (b) review and approval',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 09:19:44',	'2019-02-20 09:19:44'),
(144,	426,	'Do we ensure documented information required by the QMS are controlled to ensure: (a) it is available and suitable for use (b) it is adequately protected',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 09:20:08',	'2019-02-20 09:20:08'),
(145,	426,	'Do we take into consideration these factors (a) distribution, access, retrieval and usage (b) storage and preservation (c) version control (d) retention and disposition (e) external documents are identified as appropriate, and controlled. ​',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 09:20:51',	'2019-02-20 09:20:51'),
(146,	440,	'Have we planned, implemented and controlled our processes Have we (a) determined the requirements for our products and services (b) established criteria for the processes and the acceptance of products and services (c) determined the resources needed (d) implemented controls (e) retained documented information as necessary to demonstrate processes have been carried out effectively and product conformance (f) planned changes and reviewed issues, (g) ensured that outsourced processes are controlled',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 09:24:50',	'2019-02-20 09:24:50'),
(147,	442,	'Have we established processes for communicating with customers about: (a) our products and services (b) enquiries, contracts or orders (c) feedback including complaints (d) handling their property (e) contingency processes',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 09:25:37',	'2019-02-20 09:25:37'),
(148,	443,	'For our products and services have we determined the following requirements: (a) applicable statutory and regulatory (b) those we feel are necessary',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 09:26:09',	'2019-02-20 09:26:09'),
(149,	443,	'Can we meet the claims for the products and services we offer?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 09:26:09',	'2019-02-20 09:26:09'),
(150,	444,	'Before committing to supply do we ensure can we meet: (a) requirements specified by the customer (b) requirements necessary for intended use (c) requirements specified by us (d) statutory and regulatory requirements (e) contract or order requirements',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 09:26:45',	'2019-02-20 09:26:45'),
(151,	444,	'Do we (a) ensure that contract or order requirements differing from those previously defined are resolved (b) confirm requirements before acceptance of the order (c) retain documented information as applicable describing the results of the review, including any new or changed requirements for the products and services',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 09:26:45',	'2019-02-20 09:26:45'),
(152,	448,	'Have we (a) ensured that documented information is amended and that relevant personnel are made aware of the changed requirements when requirements for products and services are changed ​ ​',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 09:27:33',	'2019-02-20 09:27:33'),
(153,	451,	'Have we have a design and development process for products and services that is appropriate ​ ​',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 09:28:41',	'2019-02-20 09:28:41'),
(154,	451,	'In determining the stages and controls for design and development, have we considered: (a) the nature, duration and complexity of the activities (b) stages including review (c) verification and validation (d) responsibilities and authorities (e) internal and external resources (f) involvement of customer and user groups (g) the subsequent production process (h) documented information required',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 09:32:56',	'2019-02-20 09:32:56'),
(155,	452,	'Have we considered: (a) functional and performance requirements (b) similar designs (c) statutory and regulatory requirements (d) standards or codes of practice (e) potential consequences of failure due to the nature of the products and services',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 09:33:40',	'2019-02-20 09:33:40'),
(156,	452,	'Have we ensured inputs are adequate, complete, and unambiguous and all conflicts are resolved',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 09:33:40',	'2019-02-20 09:33:40'),
(157,	452,	'Have we retained documented information on design and development inputs',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 09:33:40',	'2019-02-20 09:33:40'),
(158,	453,	'Do our controls ensure (a) the results to be achieved are defined (b) reviews are conducted to ensure designs will meet requirements (c) verification is conducted to ensure that design outputs will meet the defined inputs (d) validation ensures products and services are capable of meeting the specified requirements or intended use (e) actions are taken on problems (f) documented information of these activities is retained.',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 09:34:17',	'2019-02-20 09:34:17'),
(159,	454,	'Have we ensured that outputs: (a) meet the input requirements (b) are adequate for production (c) reference monitoring and measuring requirements, and acceptance criteria, as applicable (d) specify the characteristics of the products and services that are essential for their intended purpose and their safe and proper use',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 09:35:29',	'2019-02-20 09:35:29'),
(160,	454,	'Has documented information of outputs been retained',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 09:35:29',	'2019-02-20 09:35:29'),
(161,	455,	'Do we ensure there is no adverse impact on conformity when changes are made during design and development Do we keep documented information on (a) design and development changes (b) results of reviews (c) authorisation of changes (d) Actions taken to prevent adverse impacts ​',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-02-20 09:36:06',	'2019-02-20 09:36:06'),
(162,	386,	'Have we determined and selected opportunities for improvement and implement necessary actions including: (a) improving products and services (b) correcting, preventing or reducing undesired effects; (c) improving the performance and effectiveness of the QMS',	0,	0,	0,	NULL,	NULL,	NULL,	'2019-02-20 09:39:33',	'2019-03-13 14:32:08'),
(163,	496,	'question 01',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-03-13 14:44:40',	'2019-03-13 14:44:40'),
(164,	496,	'question 02',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-03-13 14:44:40',	'2019-03-13 14:44:40'),
(165,	497,	'corective action question 01',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-03-13 14:45:31',	'2019-03-13 14:45:31'),
(166,	497,	'corrective action question 02',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-03-13 14:45:31',	'2019-03-13 14:45:31'),
(167,	498,	'non conforrmity question 01',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-03-13 14:46:18',	'2019-03-13 14:46:18'),
(168,	498,	'non conforrmity question 02',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-03-13 14:46:18',	'2019-03-13 14:46:18'),
(169,	498,	'non conforrmity question 03',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-03-13 14:46:18',	'2019-03-13 14:46:18'),
(170,	499,	'retain doc info question 1',	0,	0,	0,	NULL,	NULL,	NULL,	'2019-03-13 14:47:13',	'2019-03-13 14:51:44'),
(171,	499,	'retain doc question 02',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-03-13 14:47:13',	'2019-03-13 14:47:13'),
(172,	501,	'question 1',	0,	0,	0,	NULL,	NULL,	NULL,	'2019-03-13 15:06:48',	'2019-03-13 15:07:49'),
(173,	502,	'question 2',	0,	0,	0,	NULL,	NULL,	NULL,	'2019-03-13 15:07:10',	'2019-03-13 15:13:29'),
(174,	396,	'Has your organization determined external and internal issues relevant to its purpose and its strategic direction that affect its ability to achieve the intended result(s) of its QMS?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-13 09:33:19',	'2019-04-13 09:33:19'),
(175,	396,	'Does your organization monitor and review information about these external and internal issues?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-13 09:33:19',	'2019-04-13 09:33:19'),
(176,	1543,	'When the organisation identifes a nonconformity does it react to it and take action to control and correct it and deal with the consequences?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-13 10:28:03',	'2019-04-13 10:28:03'),
(177,	1543,	'When the organisation identifes a nonconformity does it  evaluate the need for action to eliminate the causes of the nonconformity to ensure it does not reoccur or occur elsewhere?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-13 10:28:03',	'2019-04-13 10:28:03'),
(178,	1543,	'When the organisation identifies a nonconformity does it determine and implement the corrective action needed?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-13 10:28:03',	'2019-04-13 10:28:03'),
(179,	1543,	'Does the organisation review the effectiveness of any corrective action taken and make changes to the BCMS and business continuity procedures in particular,  if necessary?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-13 10:28:03',	'2019-04-13 10:28:03'),
(180,	1543,	'Does the organisation retain documented information as evidence of the nature of nonconformities, subsequent actions taken and the results of the corrective action?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-13 10:28:03',	'2019-04-13 10:28:03'),
(181,	1069,	'Does the organisation continually improve the suitability, adequacy or effectiveness of the BCMS?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-13 10:29:00',	'2019-04-13 10:29:00'),
(182,	1069,	'Does the organisation use the process of the BCMS such as leadership, planning and performance evaluation to achieve improvement?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-13 10:29:00',	'2019-04-13 10:29:00'),
(183,	1069,	'Does the organisation retain documented information as the evidence of continual improvement of its BCMS and business continuity procedures in particular?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-13 10:29:00',	'2019-04-13 10:29:00'),
(184,	760,	'Determine internal and external issues relevant to the organisation\'s purpose and that affect it\'s ability to achieve the intended outcome(s) of its ISMS.',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-13 10:42:27',	'2019-04-13 10:42:27'),
(185,	1025,	'Interested parties relevant to ISMS identified',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-13 10:44:11',	'2019-04-13 10:44:11'),
(186,	1025,	'Requirements of interested parties relevant to ISMS identified',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-13 10:44:11',	'2019-04-13 10:44:11'),
(187,	1618,	'Have you determined external and internal issues that are relevant to your purpose and your strategic direction and that affect your ability to achieve the intended outcomes of your Occupational Health and Safety Management System?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 14:02:13',	'2019-04-18 14:02:13'),
(188,	1618,	'How do you monitor and review information about these external and internal issues?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 14:02:13',	'2019-04-18 14:02:13'),
(189,	1619,	'Have you determined the following:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 14:07:34',	'2019-04-18 14:07:34'),
(190,	1619,	'a)	the interested parties in addition to workers that are relevant to the Occupational Health and Safety Management System?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 14:07:34',	'2019-04-18 14:07:34'),
(191,	1619,	'b)	the needs and expectations of these interested parties that are relevant to the Occupational Health and Safety Management System?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 14:07:34',	'2019-04-18 14:07:34'),
(192,	1619,	'c)	which of these needs and expectations are, or could become legal requirements and other requirements?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 14:07:34',	'2019-04-18 14:07:34'),
(193,	1619,	'How do you monitor and review information about these interested parties and their relevant needs and expectations?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 14:07:34',	'2019-04-18 14:07:34'),
(194,	1620,	'Have you determined the boundaries and applicability of the OH&S management system to establish your scope?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 14:10:36',	'2019-04-18 14:10:36'),
(195,	1620,	'When determining the scope of the OH&S management system how did you consider:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 14:10:36',	'2019-04-18 14:10:36'),
(196,	1620,	'a)	the external and internal issues referred to in 4.1?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 14:10:36',	'2019-04-18 14:10:36'),
(197,	1620,	'b)	the requirements of relevant interested parties referred to in 4.2?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 14:10:36',	'2019-04-18 14:10:36'),
(198,	1620,	'c)	take into account the planned or performed work related activities?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 14:10:36',	'2019-04-18 14:10:36'),
(199,	1620,	'Is the scope available as documented information?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 14:10:36',	'2019-04-18 14:10:36'),
(200,	1621,	'Have you implemented and have the system in place to maintain and continually improve your OH&S management system, including the processes needed and their interactions, in accordance with the requirements of ISO 45001?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 14:11:32',	'2019-04-18 14:11:32'),
(201,	1623,	'How does Top Management  demonstrate leadership and commitment with respect to the OH&S management system:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 14:17:37',	'2019-04-18 14:17:37'),
(202,	1623,	'a)	taking overall responsibility and accountability for the prevention of work related injury and ill health, as well as the provision of safe and healthy workplaces and activities?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 14:17:37',	'2019-04-18 14:17:37'),
(203,	1623,	'b)	ensuring that the OH&S policy and related OH&S objectives are established for the OH&S management system and are compatible with the strategic direction of the organization?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 14:17:37',	'2019-04-18 14:17:37'),
(204,	1623,	'c)	ensuring the integration of the OH&S management system requirements into the organization’s business processes?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 14:17:37',	'2019-04-18 14:17:37'),
(205,	1623,	'd)	ensuring that the resources needed for the OH&S management system are available?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 14:17:37',	'2019-04-18 14:17:37'),
(206,	1623,	'e)	communicating the importance of effective OH&S management and of conforming to the OH&S management system requirements?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 14:17:37',	'2019-04-18 14:17:37'),
(207,	1623,	'f)	ensuring that the OH&S management system achieves its intended outcomes?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 14:17:37',	'2019-04-18 14:17:37'),
(208,	1623,	'g)	directing and supporting workers to contribute to the effectiveness of the OH&S management system?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 14:17:37',	'2019-04-18 14:17:37'),
(209,	1623,	'h)	ensuring and promoting continual improvement?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 14:17:37',	'2019-04-18 14:17:37'),
(210,	1623,	'i)	supporting other relevant management roles to demonstrate their leadership as it applies to their areas of responsibility?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 14:17:37',	'2019-04-18 14:17:37'),
(211,	1623,	'j)	developing, leading and promoting a culture in the organisation that supports the intended outcomes of the OH&S management system?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 14:17:37',	'2019-04-18 14:17:37'),
(212,	1623,	'k)	protecting workers from reprisals when reporting incidents, hazards, risks and opportunities?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 14:17:37',	'2019-04-18 14:17:37'),
(213,	1623,	'l)	ensuring the organisation establishes and implements a process(es) for consultation and participation of workers?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 14:17:37',	'2019-04-18 14:17:37'),
(214,	1623,	'm)	supporting the establishment and functioning of health and safety committee?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 14:17:37',	'2019-04-18 14:17:37'),
(215,	1624,	'Have top management established, implemented and maintained a OH&S policy that:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 16:33:56',	'2019-04-18 16:33:56'),
(216,	1624,	'a)	includes a commitment to provide safe and healthy working conditions for the prevention of work related injury and ill health and is appropriate to the purpose, size and context of the organisation and to the specific nature of its OH&S risks and opportunities?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 16:33:56',	'2019-04-18 16:33:56'),
(217,	1624,	'b)	provides a framework for setting OH&S objectives?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 16:33:56',	'2019-04-18 16:33:56'),
(218,	1624,	'c)	includes a commitment to fulfil legal requirements and other requirements?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 16:33:56',	'2019-04-18 16:33:56'),
(219,	1624,	'd)	Includes a commitment to eliminate hazards and reduce OH&S risks?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 16:33:56',	'2019-04-18 16:33:56'),
(220,	1624,	'e)	includes commitment to continual improvement of the OH&S management system?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 16:33:56',	'2019-04-18 16:33:56'),
(221,	1624,	'f)	includes a commitment to consultation and participation of workers, and , where they exist workers representative?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 16:33:56',	'2019-04-18 16:33:56'),
(222,	1624,	'Is the OH&S policy',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 16:33:56',	'2019-04-18 16:33:56'),
(223,	1624,	'•	available as documented information',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 16:33:56',	'2019-04-18 16:33:56'),
(224,	1624,	'•	communicated within the organisation',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 16:33:56',	'2019-04-18 16:33:56'),
(225,	1624,	'•	available to interested parties',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 16:33:56',	'2019-04-18 16:33:56'),
(226,	1624,	'•	relevant and appropriate?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 16:33:56',	'2019-04-18 16:33:56'),
(227,	1701,	'Have top management established, implemented and maintained a OH&S policy that:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 16:40:20',	'2019-04-18 16:40:20'),
(228,	1701,	'a)	includes a commitment to provide safe and healthy working conditions for the prevention of work related injury and ill health and is appropriate to the purpose, size and context of the organisation and to the specific nature of its OH&S risks and opportunities?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 16:40:20',	'2019-04-18 16:40:20'),
(229,	1701,	'b)	provides a framework for setting OH&S objectives?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 16:40:20',	'2019-04-18 16:40:20'),
(230,	1701,	'c)	includes a commitment to fulfil legal requirements and other requirements?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 16:40:20',	'2019-04-18 16:40:20'),
(231,	1701,	'd)	Includes a commitment to eliminate hazards and reduce OH&S risks?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 16:40:20',	'2019-04-18 16:40:20'),
(232,	1701,	'e)	includes commitment to continual improvement of the OH&S management system?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 16:40:20',	'2019-04-18 16:40:20'),
(233,	1701,	'f)	includes a commitment to consultation and participation of workers, and , where they exist workers representative?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 16:40:20',	'2019-04-18 16:40:20'),
(234,	1701,	'Is the OH&S policy :',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 16:40:20',	'2019-04-18 16:40:20'),
(235,	1701,	'•	available as documented information ?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 16:40:20',	'2019-04-18 16:40:20'),
(236,	1701,	'•	communicated within the organisation ?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 16:40:20',	'2019-04-18 16:40:20'),
(237,	1701,	'•	available to interested parties ?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 16:40:20',	'2019-04-18 16:40:20'),
(238,	1701,	'•	relevant and appropriate?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 16:40:20',	'2019-04-18 16:40:20'),
(239,	1625,	'Does top management ensure that the responsibilities and authorities for relevant roles within the OH&S management system are assigned, available as documented information, communicated and understood at all levels within the organization?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 16:42:15',	'2019-04-18 16:42:15'),
(240,	1625,	'Do workers assume responsibility for those aspects of the OH&S management system for which they have control?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 16:42:15',	'2019-04-18 16:42:15'),
(241,	1625,	'Has top management assigned the responsibility and authority for:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 16:42:15',	'2019-04-18 16:42:15'),
(242,	1625,	'a)	ensuring that the OH&S management system conforms to the requirements of ISO 45001?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 16:42:15',	'2019-04-18 16:42:15'),
(243,	1625,	'b)	reporting on the performance of the OH&S management system to top management?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 16:42:15',	'2019-04-18 16:42:15'),
(244,	1626,	'Has your organisation established, implemented and maintained a process (es) for consultation and participation of workers at all applicable levels and functions, and where they exist, workers representatives, in the development, performance evaluation and actions for improvement of the OH&S system?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:07:49',	'2019-04-18 17:07:49'),
(245,	1626,	'Does the organisation:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:07:49',	'2019-04-18 17:07:49'),
(246,	1626,	'a.	provide mechanisms, time, training and resources necessary for consultation and participation?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:07:49',	'2019-04-18 17:07:49'),
(247,	1626,	'b.	provide timely access to clear, understandable and relevant information about the OS&H management system?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:07:49',	'2019-04-18 17:07:49'),
(248,	1626,	'c.	determine and remove obstacles or barriers to participation and minimise those that cannot be removed?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:07:49',	'2019-04-18 17:07:49'),
(249,	1626,	'd.	emphasize the consultation of non-managerial workers on the following:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:07:49',	'2019-04-18 17:07:49'),
(250,	1626,	'1.	determining the needs and expectations of interested parties?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:07:49',	'2019-04-18 17:07:49'),
(251,	1626,	'2.	establishing the OH&S policy?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:07:49',	'2019-04-18 17:07:49'),
(252,	1626,	'3.	assigning organisational roles, responsibilities and authorities, as applicable?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:07:49',	'2019-04-18 17:07:49'),
(253,	1626,	'4.	determining how to fulfil legal and other requirements?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:07:49',	'2019-04-18 17:07:49'),
(254,	1626,	'5.	establish and plan to achieve OH&S objectives?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:07:49',	'2019-04-18 17:07:49'),
(255,	1626,	'6.	determining applicable controls for outsourcing, procurement and contractors?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:07:49',	'2019-04-18 17:07:49'),
(256,	1626,	'7.	determining what needs to be monitored, measured and evaluated?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:07:49',	'2019-04-18 17:07:49'),
(257,	1626,	'8.	planning, establishing, implementing and maintaining an audit programme?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:07:49',	'2019-04-18 17:07:49'),
(258,	1626,	'9.	ensuring continual improvement?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:07:49',	'2019-04-18 17:07:49'),
(259,	1626,	'e.	emphasize participation of non-managerial workers in the following:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:07:49',	'2019-04-18 17:07:49'),
(260,	1626,	'1.	determining the mechanisms for their consultation and participation?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:07:49',	'2019-04-18 17:07:49'),
(261,	1626,	'2.	identifying hazards and assessing risks and opportunities?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:07:49',	'2019-04-18 17:07:49'),
(262,	1626,	'3.	determining actions to eliminate hazards and reduce OH&S risks?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:07:49',	'2019-04-18 17:07:49'),
(263,	1626,	'4.	determining competence requirements, training needs, training and evaluating training?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:07:49',	'2019-04-18 17:07:49'),
(264,	1626,	'5.	determining what needs to be communicated and how it is to be done?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:07:49',	'2019-04-18 17:07:49'),
(265,	1626,	'6.	determining control measures and their effective implementation and use?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:07:49',	'2019-04-18 17:07:49'),
(266,	1626,	'7.	investing incidents and nonconformities and determine corrective action?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:07:49',	'2019-04-18 17:07:49'),
(267,	1628,	'When planning for the OH&S management system, have you considered the issues referred to in 4.1 and the requirements referred to in 4.2 and 4.3 and determined the risks and opportunities that need to be addressed to:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:19:46',	'2019-04-18 17:19:46'),
(268,	1628,	'a)	give assurance that the OH&S management system can achieve its intended outcomes?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:19:46',	'2019-04-18 17:19:46'),
(269,	1628,	'b)	prevent, or reduce, undesired effects?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:19:46',	'2019-04-18 17:19:46'),
(270,	1628,	'c)	achieve continual improvement?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:19:46',	'2019-04-18 17:19:46'),
(271,	1628,	'When determining the risks and opportunities for the OH&S management system and its intended outcome has the organisation taken into account:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:19:46',	'2019-04-18 17:19:46'),
(272,	1628,	'•	hazards',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:19:46',	'2019-04-18 17:19:46'),
(273,	1628,	'•	OH&S risks and other risks',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:19:46',	'2019-04-18 17:19:46'),
(274,	1628,	'•	OH&S opportunities and other opportunities',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:19:46',	'2019-04-18 17:19:46'),
(275,	1628,	'•	Legal and other requirements?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:19:46',	'2019-04-18 17:19:46'),
(276,	1628,	'Has your organization in its planning process determined and assessed the risks and opportunities relevant to the intended outcomes of the OH&S system associated with planned changes permanent or temporary before the change is implemented?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:19:46',	'2019-04-18 17:19:46'),
(277,	1628,	'Does your organization maintain documented information on:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:19:46',	'2019-04-18 17:19:46'),
(278,	1628,	'•	risks and opportunities?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:19:46',	'2019-04-18 17:19:46'),
(279,	1628,	'•	the process and actions needed to determine and address its risks and opportunities to the extent necessary to have confidence that they are carried out as planned?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:19:46',	'2019-04-18 17:19:46'),
(280,	1630,	'Has the organisation established, implemented and maintained a process(s) for hazard identification that is ongoing and proactive? Do the processes take into account, but not be limited to:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:25:49',	'2019-04-18 17:25:49'),
(281,	1630,	'a)	how work is organised, social factors(including workload, work hours, victimization, harassment and bullying) leadership and the culture of the organisation?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:25:49',	'2019-04-18 17:25:49'),
(282,	1630,	'b)	routine and non-routine activities and situations, including hazards arising from:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:25:49',	'2019-04-18 17:25:49'),
(283,	1630,	'1.	infrastructure, equipment, materials, substances and the physical conditions of the workplace?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:25:49',	'2019-04-18 17:25:49'),
(284,	1630,	'2.	product and service design, research, development, testing, production, assembly, construction, service delivery, maintenance and disposal?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:25:49',	'2019-04-18 17:25:49'),
(285,	1630,	'3.	human factors?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:25:49',	'2019-04-18 17:25:49'),
(286,	1630,	'4.	how work is performed?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:25:49',	'2019-04-18 17:25:49'),
(287,	1630,	'c)	past relevant incidents, internal or external to the organisation, including emergencies, and there causes?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:25:49',	'2019-04-18 17:25:49'),
(288,	1630,	'd)	potential emergency situations?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:25:49',	'2019-04-18 17:25:49'),
(289,	1630,	'e)	people, including consideration off:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:25:49',	'2019-04-18 17:25:49'),
(290,	1630,	'1.	those with access to the workplace and their activities, including workers, contractors, visitors and other persons?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:25:49',	'2019-04-18 17:25:49'),
(291,	1630,	'2.	those in the vicinity of the workplace who can be affected by the activities of the organisation?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:25:49',	'2019-04-18 17:25:49'),
(292,	1630,	'3.	workers at a location not under the direct control of the organisation?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:25:49',	'2019-04-18 17:25:49'),
(293,	1630,	'f)	other issues, including consideration of:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:25:49',	'2019-04-18 17:25:49'),
(294,	1630,	'1.	the design of work areas, processes, installations, machinery/equipment, operating procedures and work organisation, including their adaptation to the needs and capabilities of the workers involved?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:25:49',	'2019-04-18 17:25:49'),
(295,	1630,	'2.	situations occurring in the vicinity of the workplace caused by work-related activities under the control of the organisation?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:25:49',	'2019-04-18 17:25:49'),
(296,	1630,	'3.	Situations not controlled by the organisation and occurring in the vicinity of the workplace that can cause injury and ill health to persons in the workplace?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:25:49',	'2019-04-18 17:25:49'),
(297,	1630,	'g)	actual or proposed changes in organisation, operations, processes, activities and the OH&S management system?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:25:49',	'2019-04-18 17:25:49'),
(298,	1630,	'h)	changes in knowledge of, and information about, hazards?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:25:49',	'2019-04-18 17:25:49'),
(299,	1631,	'Has the organisation established implemented and maintained a process to:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:26:58',	'2019-04-18 17:26:58'),
(300,	1631,	'a)	assess OH&S risks from the identified hazards, while taking into account the effectiveness of existing controls?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:26:58',	'2019-04-18 17:26:58'),
(301,	1631,	'b)	determine and assess the other risks related to the establishment, implementation, operation and maintenance of the OH&S management system?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:26:58',	'2019-04-18 17:26:58'),
(302,	1631,	'Has the organisation’s methodologies and criteria for the assessment of OH&S risks been defined with respect to the scope, nature and timing to ensure they are proactive rather than reactive and are used in a systematic way?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:26:58',	'2019-04-18 17:26:58'),
(303,	1631,	'Does the organisation maintain and retain documented information on the methodologies and criteria?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:26:58',	'2019-04-18 17:26:58'),
(304,	1632,	'Have the organisation established, implemented and maintained processes to assess:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:40:25',	'2019-04-18 17:40:25'),
(305,	1632,	'a)	OH&S opportunities to enhance OH&S performance, while taking into account planned changes to the organisation, its policies, its processes and its activities and:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:40:25',	'2019-04-18 17:40:25'),
(306,	1632,	'1.	opportunities to adapt work, work organisation and work environment to workers?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:40:25',	'2019-04-18 17:40:25'),
(307,	1632,	'2.	Opportunities to eliminate hazards and reduce OH&S risks?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:40:25',	'2019-04-18 17:40:25'),
(308,	1632,	'b)	Other opportunities for improving the OH&S system?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:40:25',	'2019-04-18 17:40:25'),
(309,	1633,	'Has the organisation established, implemented and maintained processes to:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:42:01',	'2019-04-18 17:42:01'),
(310,	1633,	'a)	determine and have access to up to date legal requirements and other requirements that are applicable to the hazards, OH&S risks and OH&S management system?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:42:01',	'2019-04-18 17:42:01'),
(311,	1633,	'b)	determine how these legal requirements and other requirements apply to the organisation and what needs to be communicated?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:42:01',	'2019-04-18 17:42:01'),
(312,	1633,	'c)	take legal and other requirements into account when establishing implementing, maintaining and continually improving its OH&S management system?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:42:01',	'2019-04-18 17:42:01'),
(313,	1633,	'Does the organisation maintain and retain information on its legal and other requirements?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:42:01',	'2019-04-18 17:42:01'),
(314,	1633,	'How does the organisation ensure its legal requirements are up to date and reflect any changes?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-18 17:42:01',	'2019-04-18 17:42:01'),
(315,	1634,	'Does the organisations plan include:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:13:49',	'2019-04-19 08:13:49'),
(316,	1634,	'a)	Actions to address these risks and opportunities, address legal and other requirements and prepare for and respond to emergency situations?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:13:49',	'2019-04-19 08:13:49'),
(317,	1634,	'b)	How to integrate and implement the actions into its OH&S management system processes or other business processes?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:13:49',	'2019-04-19 08:13:49'),
(318,	1634,	'Has the organisation taken into account the hierarchy of controls and outputs and outputs from OH&S management system when planning to take action?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:13:49',	'2019-04-19 08:13:49'),
(319,	1634,	'Does the organisation take into account best practice, technological options and financial, operational and business requirements when planning its actions?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:13:49',	'2019-04-19 08:13:49'),
(320,	1636,	'Has your organization established OH&S objectives at relevant functions, levels that are needed to maintain and continually improve the OH&S management system?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:15:36',	'2019-04-19 08:15:36'),
(321,	1636,	'Are the OH&S objectives:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:15:36',	'2019-04-19 08:15:36'),
(322,	1636,	'a)	consistent with the OH&S policy?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:15:36',	'2019-04-19 08:15:36'),
(323,	1636,	'b)	measurable or capable of performance evaluation?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:15:36',	'2019-04-19 08:15:36'),
(324,	1636,	'c)	take into account applicable requirements, the results of the assessment of risks and opportunities and the results of consultation with worker and workers representatives?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:15:36',	'2019-04-19 08:15:36'),
(325,	1636,	'd)	monitored?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:15:36',	'2019-04-19 08:15:36'),
(326,	1636,	'e)	communicated?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:15:36',	'2019-04-19 08:15:36'),
(327,	1636,	'f)	updated as appropriate?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:15:36',	'2019-04-19 08:15:36'),
(328,	1636,	'Do you maintain and retain documented information on the OH&S objectives?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:15:36',	'2019-04-19 08:15:36'),
(329,	1637,	'When planning how to achieve your OH&S objectives, has your organization determined:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:16:40',	'2019-04-19 08:16:40'),
(330,	1637,	'a)	What will be done?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:16:40',	'2019-04-19 08:16:40'),
(331,	1637,	'b)	What resources will be required?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:16:40',	'2019-04-19 08:16:40'),
(332,	1637,	'c)	Who will be responsible?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:16:40',	'2019-04-19 08:16:40'),
(333,	1637,	'd)	When it will be completed?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:16:40',	'2019-04-19 08:16:40'),
(334,	1637,	'e)	How the results will be evaluated including indicators for monitoring?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:16:40',	'2019-04-19 08:16:40'),
(335,	1637,	'f)	How the actions to achieve OH&S objectives will be integrated into the organisations business processes?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:16:40',	'2019-04-19 08:16:40'),
(336,	1637,	'Do you maintain and retain documented information on the OH&S plans?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:16:40',	'2019-04-19 08:16:40'),
(337,	1639,	'Has your organization determined and provided the resources needed for the establishment, implementation, maintenance and continual improvement of the OH&S management system?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:17:05',	'2019-04-19 08:17:05'),
(338,	1640,	'Has your organization:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:18:13',	'2019-04-19 08:18:13'),
(339,	1640,	'a)	determined the necessary competence of workers that affects the performance and effectiveness of the OH&S management system?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:18:13',	'2019-04-19 08:18:13'),
(340,	1640,	'b)	ensured that these workers are competent (including the ability to identify hazards)on the basis of appropriate education, training, or experience?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:18:13',	'2019-04-19 08:18:13'),
(341,	1640,	'c)	where applicable, taken actions to acquire and maintain the necessary competence, and evaluated the effectiveness of the actions taken?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:18:13',	'2019-04-19 08:18:13'),
(342,	1640,	'd)	retained appropriate documented information as evidence of competence?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:18:13',	'2019-04-19 08:18:13'),
(343,	1641,	'How does the organization ensure that workers are aware of:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:20:20',	'2019-04-19 08:20:20'),
(344,	1641,	'a)	the OH&S and objectives policy?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:20:20',	'2019-04-19 08:20:20'),
(345,	1641,	'b)	their contribution to the effectiveness of the OH&S system including the benefits of improved OH&S performance?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:20:20',	'2019-04-19 08:20:20'),
(346,	1641,	'c)	the implications of not conforming to the OH&S management system requirements?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:20:20',	'2019-04-19 08:20:20'),
(347,	1641,	'd)	Incidents and the outcomes of investigations that are relevant to them?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:20:20',	'2019-04-19 08:20:20'),
(348,	1641,	'e)	hazards, OH&S risks and actions determined that are relevant to them?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:20:20',	'2019-04-19 08:20:20'),
(349,	1641,	'f)	the ability to remove themselves from work situations that they consider present an imminent and serious danger to their life or health, as well as the arrangements for protecting them from undue consequences for doing so?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:20:20',	'2019-04-19 08:20:20'),
(350,	1643,	'How have you determined the internal and external communications relevant to the OH&S management system, including:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:25:18',	'2019-04-19 08:25:18'),
(351,	1643,	'a)	0n what it will communicate?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:25:18',	'2019-04-19 08:25:18'),
(352,	1643,	'b)	when to communicate?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:25:18',	'2019-04-19 08:25:18'),
(353,	1643,	'c)	with whom to communicate:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:25:18',	'2019-04-19 08:25:18'),
(354,	1643,	'1.	Internally among the various levels and functions of the organisation?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:25:18',	'2019-04-19 08:25:18'),
(355,	1643,	'2.	Among contractors and visitors to the workplace?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:25:18',	'2019-04-19 08:25:18'),
(356,	1643,	'3.	Among other interested parties?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:25:18',	'2019-04-19 08:25:18'),
(357,	1643,	'd)	how to communicate?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:25:18',	'2019-04-19 08:25:18'),
(358,	1643,	'How does the organisation take into account diversity (Gender, language, culture, literacy, disability) aspects when considering communication needs?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:25:18',	'2019-04-19 08:25:18'),
(359,	1643,	'How are the views of interested parties considered in establishing communication processes?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:25:18',	'2019-04-19 08:25:18'),
(360,	1643,	'In establishing communication processes has legal and other requirements been taken into account and that the information is consistent with other information generated from the system and reliable?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:25:18',	'2019-04-19 08:25:18'),
(361,	1643,	'Who responds to relevant communications on its OH&S management system?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:25:18',	'2019-04-19 08:25:18'),
(362,	1643,	'In what form is documented information retained as evidence of communications?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:25:18',	'2019-04-19 08:25:18'),
(363,	1644,	'Has the organisation ensured that:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:32:53',	'2019-04-19 08:32:53'),
(364,	1644,	'a)	Internally communicated information is relevant to the OH&S management system among various levels and functions of the organisation. Does it include changes to the OH&S management system?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:32:53',	'2019-04-19 08:32:53'),
(365,	1644,	'b)	Workers are able to contribute to continual improvement?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:32:53',	'2019-04-19 08:32:53'),
(366,	1645,	'Has the company got an external communication process?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:34:45',	'2019-04-19 08:34:45'),
(367,	1645,	'How does external communication of OH&S information take into account legal and other requirements?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:34:45',	'2019-04-19 08:34:45'),
(368,	1647,	'Does your organization’s OH&S management system include:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:35:31',	'2019-04-19 08:35:31'),
(369,	1647,	'a)	documented information required by ISO45001?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:35:31',	'2019-04-19 08:35:31'),
(370,	1647,	'b)	documented information determined by the organization as being necessary for the effectiveness of the OH&S management system?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:35:31',	'2019-04-19 08:35:31'),
(371,	1648,	'When creating and updating documented information, how does your organization ensure appropriate:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:36:34',	'2019-04-19 08:36:34'),
(372,	1648,	'a)	identification and description (e.g. a title, date, author, or reference number)?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:36:34',	'2019-04-19 08:36:34'),
(373,	1648,	'b)	format (e.g. language, software version, graphics) and media (e.g. paper, electronic)?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:36:34',	'2019-04-19 08:36:34'),
(374,	1648,	'c)	review and approval for suitability and adequacy?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:36:34',	'2019-04-19 08:36:34'),
(375,	1649,	'How do you ensure documented information required by your OH&S management system and by ISO45001 is controlled to ensure:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:37:37',	'2019-04-19 08:37:37'),
(376,	1649,	'a)	it is available and suitable for use, where and when it is needed?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:37:37',	'2019-04-19 08:37:37'),
(377,	1649,	'b)	it is adequately protected (e.g. from loss of confidentiality, improper use, or loss of integrity)?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:37:37',	'2019-04-19 08:37:37'),
(378,	1651,	'Does your organization plan, implement and control the processes (see 4.4) needed to meet the requirements of the OH&S management system and to implement the actions determined in Clause 6 by:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:56:17',	'2019-04-19 08:56:17'),
(379,	1651,	'a)	establishing criteria for the processes?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:56:17',	'2019-04-19 08:56:17'),
(380,	1651,	'b)	implementing control of the processes in accordance with the criteria?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:56:17',	'2019-04-19 08:56:17'),
(381,	1651,	'c)	maintaining and keeping documented information to the extent necessary to have confidence that processes are being carried out as planned?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:56:17',	'2019-04-19 08:56:17'),
(382,	1651,	'd)	adapting to workers?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:56:17',	'2019-04-19 08:56:17'),
(383,	1651,	'How does your organization coordinate the relevant parts of OH&S management system with other organisations in multi-employer situations?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:56:17',	'2019-04-19 08:56:17'),
(384,	1651,	'How does your organization ensure that outsourced processes are controlled (see 8.4)?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:56:17',	'2019-04-19 08:56:17'),
(385,	1652,	'Has the organisation established, implemented and maintained processes for the elimination of hazards and reduction of OH&S risks using the following hierarchy of controls:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:57:27',	'2019-04-19 08:57:27'),
(386,	1652,	'a)	eliminate the hazard?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:57:27',	'2019-04-19 08:57:27'),
(387,	1652,	'b)	substitute with less hazardous process, operations, materials or equipment?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:57:27',	'2019-04-19 08:57:27'),
(388,	1652,	'c)	use engineering controls and reorganisation of work?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:57:27',	'2019-04-19 08:57:27'),
(389,	1652,	'd)	use administration controls, including training?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:57:27',	'2019-04-19 08:57:27'),
(390,	1652,	'e)	use adequate personal protective equipment?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 08:57:27',	'2019-04-19 08:57:27'),
(391,	1653,	'Has the organisation established processes for the implementation and control of planned temporary and permanent changes that impact performance including:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:00:20',	'2019-04-19 09:00:20'),
(392,	1653,	'a)	new products, services and processes, or changes to existing products, services and processes, including:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:00:20',	'2019-04-19 09:00:20'),
(393,	1653,	'•	workplace locations and surroundings?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:00:20',	'2019-04-19 09:00:20'),
(394,	1653,	'•	working organisation?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:00:20',	'2019-04-19 09:00:20'),
(395,	1653,	'•	working conditions?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:00:20',	'2019-04-19 09:00:20'),
(396,	1653,	'•	Equipment?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:00:20',	'2019-04-19 09:00:20'),
(397,	1653,	'•	work force?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:00:20',	'2019-04-19 09:00:20'),
(398,	1653,	'b)	changes to legal requirements and other requirements?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:00:20',	'2019-04-19 09:00:20'),
(399,	1653,	'c)	changes to knowledge or information about hazards and OH&S risks?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:00:20',	'2019-04-19 09:00:20'),
(400,	1653,	'd)	developments in Knowledge and technology?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:00:20',	'2019-04-19 09:00:20'),
(401,	1653,	'Does the organisation review the consequences of unintended changes, taking action to mitigate any adverse effects, as necessary?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:00:20',	'2019-04-19 09:00:20'),
(402,	1655,	'Has the organisation established, implemented and maintained processes to control the procurement of products and services in order to ensure their conformity to its OH&S management system?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:00:51',	'2019-04-19 09:00:51'),
(403,	1656,	'Does the organisation coordinate its procurement processes with its contractors, in order to identify hazards and assess and control the OH&S risks arising from:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:02:10',	'2019-04-19 09:02:10'),
(404,	1656,	'a)	the contractors’ activities and operations that impact the organisation?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:02:10',	'2019-04-19 09:02:10'),
(405,	1656,	'b)	the organisation’s activities and operations that impact the contractors workers?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:02:10',	'2019-04-19 09:02:10'),
(406,	1656,	'c)	the contractors’ activities and operations that impact other interested parties in the workplace?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:02:10',	'2019-04-19 09:02:10'),
(407,	1656,	'How does the organisation ensure that the requirements of its OH&S management system are met by contractors and their workers?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:02:10',	'2019-04-19 09:02:10'),
(408,	1656,	'Does the organisations procurement processes define and apply occupational health and safety criteria for the selection of contractors?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:02:10',	'2019-04-19 09:02:10'),
(409,	1657,	'How does the organisation ensure outsourced functions and processes are controlled?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:03:33',	'2019-04-19 09:03:33'),
(410,	1657,	'Does the organisation ensure that its outsourcing arrangements are consistent with legal requirements and other requirements and with achieving the intended outcomes of the OH&S management system?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:03:33',	'2019-04-19 09:03:33'),
(411,	1657,	'Has the type and degree of control to be applied to these functions and processes been defined within the OH&S management system?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:03:33',	'2019-04-19 09:03:33'),
(412,	1658,	'Has the organisation established , implemented and maintained the processes needed to prepare for and respond to potential emergency situations identified in 6.1.2.1 and do they include:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:04:49',	'2019-04-19 09:04:49'),
(413,	1658,	'a)	establishing a planned response to emergency situations including provision of first aid?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:04:49',	'2019-04-19 09:04:49'),
(414,	1658,	'b)	providing training for the planned response?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:04:49',	'2019-04-19 09:04:49'),
(415,	1658,	'c)	periodically testing and exercising the planned response capability?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:04:49',	'2019-04-19 09:04:49'),
(416,	1658,	'd)	evaluating performance and as necessary, revising the planned response, including after testing and in particular after the occurrence of an emergency situation?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:04:49',	'2019-04-19 09:04:49'),
(417,	1658,	'e)	communicating and providing relevant information to all workers on their duties and responsibilities?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:04:49',	'2019-04-19 09:04:49'),
(418,	1658,	'f)	communicating relevant information to contractors, visitors, emergency response services, government authorities, and as appropriate local community?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:04:49',	'2019-04-19 09:04:49'),
(419,	1658,	'g)	taking into account the needs and capabilities of all relevant interested parties and ensuring their involvement, as appropriate, in the development of the planned response?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:04:49',	'2019-04-19 09:04:49'),
(420,	1658,	'Has the organisation maintained documented information on the process and on the plans for responding to potential emergency situations?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:04:49',	'2019-04-19 09:04:49'),
(421,	1661,	'The organisation shall establish, implement and maintain processes for monitoring, measurement analysis and performance evaluation. How does your organization determine:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:06:36',	'2019-04-19 09:06:36'),
(422,	1661,	'What needs to be monitored and measured:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:06:36',	'2019-04-19 09:06:36'),
(423,	1661,	'1.	the extent to which legal requirements and other requirements are met?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:06:36',	'2019-04-19 09:06:36'),
(424,	1661,	'2.	its activities and operations related to identified hazards, risks, and opportunities?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:06:36',	'2019-04-19 09:06:36'),
(425,	1661,	'3.	progress towards achieving OH&S objective?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:06:36',	'2019-04-19 09:06:36'),
(426,	1661,	'4.	effectiveness of operational and other controls?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:06:36',	'2019-04-19 09:06:36'),
(427,	1661,	'b)	the methods for monitoring, measurement, analysis and performance evaluation needed to ensure valid results?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:06:36',	'2019-04-19 09:06:36'),
(428,	1661,	'c)	the criteria against which the organisation will evaluate its OH&S performance?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:06:36',	'2019-04-19 09:06:36'),
(429,	1661,	'd)	when the monitoring and measuring shall be performed?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:06:36',	'2019-04-19 09:06:36'),
(430,	1661,	'e)	when the results from monitoring and measurement shall be analysed and evaluated and communicated?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:06:36',	'2019-04-19 09:06:36'),
(431,	1661,	'How does your organization evaluate the performance and the effectiveness of the OH&S management system?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:06:36',	'2019-04-19 09:06:36'),
(432,	1661,	'How does the organisation ensure that monitoring and measuring equipment is calibrated or verified as applicable, and used and maintained as appropriate?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:06:36',	'2019-04-19 09:06:36'),
(433,	1661,	'In what form does your organization retain appropriate documented information as evidence of the monitoring, measurement, analysis and performance evaluation and maintenance, calibration or verification of measuring equipment?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:07:33',	'2019-04-19 09:07:33'),
(434,	1662,	'How does your organization establish implement and maintain processes for evaluating compliance with legal and other requirements?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:09:14',	'2019-04-19 09:09:14'),
(435,	1662,	'Does the evaluation include:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:09:14',	'2019-04-19 09:09:14'),
(436,	1662,	'a)	determining the frequency and method(s) for the evaluation of compliance?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:09:14',	'2019-04-19 09:09:14'),
(437,	1662,	'b)	evaluate compliance and take action if needed?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:09:14',	'2019-04-19 09:09:14'),
(438,	1662,	'c)	maintaining knowledge and understanding of its compliance status with legal requirements and other requirements?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:09:14',	'2019-04-19 09:09:14'),
(439,	1662,	'd)	retaining documented information of the compliance evaluation results?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:09:14',	'2019-04-19 09:09:14'),
(440,	1664,	'Does your organization conduct internal audits at planned intervals to provide information on whether the OH&S management system:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:10:44',	'2019-04-19 09:10:44'),
(441,	1664,	'a)	Conforms to:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:10:44',	'2019-04-19 09:10:44'),
(442,	1664,	'1.	the organization’s own requirements for its OH&S management system, including policy and objectives?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:10:44',	'2019-04-19 09:10:44'),
(443,	1664,	'2.	the requirements of this International Standard?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:10:44',	'2019-04-19 09:10:44'),
(444,	1664,	'b)	Is effectively implemented and maintained?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:10:44',	'2019-04-19 09:10:44'),
(445,	1665,	'Does your organization:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:11:48',	'2019-04-19 09:11:48'),
(446,	1665,	'a)	plan, establish, implement and maintain an audit programme(s) including the frequency, methods, responsibilities, planning requirements and reporting, which shall take into consideration the importance of the processes concerned, and the results of previous audits?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:11:48',	'2019-04-19 09:11:48'),
(447,	1665,	'b)	define the audit criteria and scope for each audit?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:11:48',	'2019-04-19 09:11:48'),
(448,	1665,	'c)	select auditors and conduct audits to ensure objectivity and the impartiality of the audit process?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:11:48',	'2019-04-19 09:11:48'),
(449,	1665,	'd)	ensure that the results of the audits are reported to relevant management; ensure results of internal audits are reported to workers and where they exist, workers representatives, and other relevant interested parties?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:11:48',	'2019-04-19 09:11:48'),
(450,	1665,	'e)	take action to address nonconformity and continually improve its OH&S audit programme and the audit results?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:11:48',	'2019-04-19 09:11:48'),
(451,	1665,	'f)	retain documented information as evidence of the implementation of the audit programme and the audit results?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:11:48',	'2019-04-19 09:11:48'),
(452,	1666,	'ISO 45001 requires “Top management shall review the organization’s OH&S management system, at planned intervals, to ensure its continuing suitability, adequacy, effectiveness”. What format does this review(s) take?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:17:48',	'2019-04-19 09:17:48'),
(453,	1666,	'Is  your organizations management review planned and carried out taking into consideration:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:17:48',	'2019-04-19 09:17:48'),
(454,	1666,	'a)	The status of actions from previous management reviews?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:17:48',	'2019-04-19 09:17:48'),
(455,	1666,	'b)	Changes in external and internal issues that are relevant to the OH&S management system including:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:17:48',	'2019-04-19 09:17:48'),
(456,	1666,	'1.	Needs and expectations of interested parties?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:17:48',	'2019-04-19 09:17:48'),
(457,	1666,	'2.	Legal requirements and other requirements?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:17:48',	'2019-04-19 09:17:48'),
(458,	1666,	'3.	Risks and opportunities?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:17:48',	'2019-04-19 09:17:48'),
(459,	1666,	'c)	The extent to which OH&S policy and objectives have been met?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:17:48',	'2019-04-19 09:17:48'),
(460,	1666,	'd)	Information on the OH&S performance, including',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:17:48',	'2019-04-19 09:17:48'),
(461,	1666,	'1.	Incidents nonconformities and corrective actions and continual improvement?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:17:48',	'2019-04-19 09:17:48'),
(462,	1666,	'2.	Monitoring and measurement results?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:17:48',	'2019-04-19 09:17:48'),
(463,	1666,	'3.	Results of evaluation of compliance with legal requirements other requirements?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:17:48',	'2019-04-19 09:17:48'),
(464,	1666,	'4.	Audit results?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:17:48',	'2019-04-19 09:17:48'),
(465,	1666,	'5.	Consultation and participation of workers?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:17:48',	'2019-04-19 09:17:48'),
(466,	1666,	'6.	Risks and opportunities?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:17:48',	'2019-04-19 09:17:48'),
(467,	1666,	'e)	Adequacy of resources for maintaining an effective OH&S system?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:17:48',	'2019-04-19 09:17:48'),
(468,	1666,	'f)	Relevant communication with interested parties?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:17:48',	'2019-04-19 09:17:48'),
(469,	1666,	'g)	Opportunities for continual improvement?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:17:48',	'2019-04-19 09:17:48'),
(470,	1666,	'Do the outputs of the management review include decisions and actions related to:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:17:48',	'2019-04-19 09:17:48'),
(471,	1666,	'•	The continuing suitability, adequacy, and effectiveness in achieving the intended outcomes?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:17:48',	'2019-04-19 09:17:48'),
(472,	1666,	'•	Continual improvement opportunities?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:17:48',	'2019-04-19 09:17:48'),
(473,	1666,	'•	Any need for changes to the OH&S management system?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:17:48',	'2019-04-19 09:17:48'),
(474,	1666,	'•	Resource needs?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:17:48',	'2019-04-19 09:17:48'),
(475,	1666,	'•	Actions needed?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:17:48',	'2019-04-19 09:17:48'),
(476,	1666,	'•	Opportunities to improve integration of the OH&S system with other business processes?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:17:48',	'2019-04-19 09:17:48'),
(477,	1666,	'•	Any implications for the strategic direction of the organisation?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:17:48',	'2019-04-19 09:17:48'),
(478,	1666,	'How are the relevant outputs from management review communicated to workers and where they exist workers representatives?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:17:48',	'2019-04-19 09:17:48'),
(479,	1666,	'In what form does your organization retain documented information as evidence of the results of management reviews?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:17:48',	'2019-04-19 09:17:48'),
(480,	1667,	'How do you determine and select opportunities for improvement and implement any necessary actions to achieve intended outcomes of your OH&S management system?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:20:29',	'2019-04-19 09:20:29'),
(481,	1668,	'When an incident or nonconformity occurs, how does your organization:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:22:38',	'2019-04-19 09:22:38'),
(482,	1668,	'a)	React in a timely manner to the incident or nonconformity and, as applicable: 1) Take action to control and correct it? 2) Deal with the consequences?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:22:38',	'2019-04-19 09:22:38'),
(483,	1668,	'b)	Evaluate, with the participation of workers and the involvement of other relevant interested parties, the need for corrective action to eliminate the root cause(s) of the incident or nonconformity, in order that it does not recur or occur elsewhere, by:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:22:38',	'2019-04-19 09:22:38'),
(484,	1668,	'1) investigating the incident or reviewing the nonconformity?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:22:38',	'2019-04-19 09:22:38'),
(485,	1668,	'2) determining the causes of the incident or nonconformity?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:22:38',	'2019-04-19 09:22:38'),
(486,	1668,	'3) determining if similar incidents have occurred, if nonconformities exist, or if could potentially occur?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:22:38',	'2019-04-19 09:22:38'),
(487,	1668,	'c)	review existing assessments of OH&S risks and other risks, as appropriate?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:22:38',	'2019-04-19 09:22:38'),
(488,	1668,	'd)	determine and implement any action needed, including corrective action, in accordance with the hierarchy of controls and the management of change?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:22:38',	'2019-04-19 09:22:38'),
(489,	1668,	'e)	assess OH&S risks and that relate to new or changed hazards, prior to taking action?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:22:38',	'2019-04-19 09:22:38'),
(490,	1668,	'f)	review the effectiveness of any action taken, including corrective action?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:22:38',	'2019-04-19 09:22:38'),
(491,	1668,	'g)	make changes to the OH&S management system, if necessary?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:22:38',	'2019-04-19 09:22:38'),
(492,	1668,	'Does your organization take corrective actions appropriate to the effects or potential effects of the incidents or nonconformities encountered?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:22:38',	'2019-04-19 09:22:38'),
(493,	1668,	'In what form does your organization retain documented information evidence of:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:22:38',	'2019-04-19 09:22:38'),
(494,	1668,	'a)	the nature of the incidents or nonconformities and any subsequent actions taken?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:22:38',	'2019-04-19 09:22:38'),
(495,	1668,	'a)	the results of any action and corrective action including their effectiveness?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:22:38',	'2019-04-19 09:22:38'),
(496,	1668,	'How is this information communicated to relevant workers, and, where applicable, workers representatives, and other interested parties?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:22:38',	'2019-04-19 09:22:38'),
(497,	1669,	'How does your organization continually improve the suitability, adequacy and effectiveness of the OH&S management system?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:24:19',	'2019-04-19 09:24:19'),
(498,	1669,	'How does your organization:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:24:19',	'2019-04-19 09:24:19'),
(499,	1669,	'a)	enhance OH&S performance?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:24:19',	'2019-04-19 09:24:19'),
(500,	1669,	'b)	promote a culture that supports the OH&S management system?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:24:19',	'2019-04-19 09:24:19'),
(501,	1669,	'c)	promote the participation of workers in implementing actions for continual improvement of the OH&S management system?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:24:19',	'2019-04-19 09:24:19'),
(502,	1669,	'd)	communicating the results of continual improvement workers and if appropriate workers representatives?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:24:19',	'2019-04-19 09:24:19'),
(503,	1669,	'e)	maintain and retain documented information as evidence of continual improvement?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 09:24:19',	'2019-04-19 09:24:19'),
(504,	1702,	'Has your organization determined external and internal issues relevant to its purpose and its strategic direction that affect its ability to achieve the intended result(s) of its QMS?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 12:55:15',	'2019-04-19 12:55:15'),
(505,	1702,	'Have you determined the external and internal issues that are relevant to your organization’s QMS?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 12:55:15',	'2019-04-19 12:55:15'),
(506,	1702,	'SWOT Analysis done?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 12:55:15',	'2019-04-19 12:55:15'),
(507,	1703,	'Have we determined external and internal issues relevant to the QMS achieving its aim?',	0,	0,	0,	NULL,	NULL,	NULL,	'2019-04-19 13:01:02',	'2019-05-02 10:19:55'),
(508,	1703,	'Do we monitor and review these issues:',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 13:01:02',	'2019-04-19 13:01:02'),
(509,	1703,	'Have you determined the external and internal issues that are relevant to your organization’s QMS?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 13:01:02',	'2019-04-19 13:01:02'),
(510,	1703,	'SWOT Analysis done?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-04-19 13:01:02',	'2019-04-19 13:01:02'),
(511,	1530,	'Has the organisation determined the external internal issues that are relevant to its purpose and affect its ability to achieve the intended outcomes of its BCMS?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:29:37',	'2019-05-08 13:29:37'),
(512,	1530,	'Are the internal and external issues that impact and affect the organisation taken into account when establishing, implementing and maintaining the organisation’s BCMS?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:29:37',	'2019-05-08 13:29:37'),
(513,	1530,	'Has the organisation identified and documented its activities, functions, services, products, partnerships, supplychains, relationships with interested parties and the potential impact related to a disruptive incident?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:29:37',	'2019-05-08 13:29:37'),
(514,	1530,	'Has the organisation identified and documented the links between its business continuity policy and the organisations objectives and other policies?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:29:37',	'2019-05-08 13:29:37'),
(515,	1530,	'Has the organisation identified and documented the links between its business continuity policy and its overall risk management strategy?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:29:37',	'2019-05-08 13:29:37'),
(516,	1530,	'Has the organisation established and documented its risk appetite?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:29:37',	'2019-05-08 13:29:37'),
(517,	1530,	'Has the organisation defined the purpose of the BCMS?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:29:37',	'2019-05-08 13:29:37'),
(518,	1530,	'Does the organisation have a documented Policy concerning the procurement, provision and management of outsourced good and services via its supply chain?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:29:37',	'2019-05-08 13:29:37'),
(519,	1530,	'Does the organisation fully recognised that outsourcing a business function does not transfer the associated business risk to the supplier and/or service provider?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:29:37',	'2019-05-08 13:29:37'),
(520,	1530,	'Does the organisation have a documented process concerning the procurement of outsourced prioritised activities their support resources and dependencies?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:29:37',	'2019-05-08 13:29:37'),
(521,	1530,	'Does the organisation have a documented process concerning the management of outsourced prioritised activities their support resources and dependencies?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:29:37',	'2019-05-08 13:29:37'),
(522,	1530,	'Does the organisation periodically evaluate/audit the business continuity capability of its suppliers?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:29:37',	'2019-05-08 13:29:37'),
(523,	1530,	'Does the organisation engage in joint business continuity exercises with its outsourced suppliers?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:29:37',	'2019-05-08 13:29:37'),
(524,	1530,	'Are the business continuity, business impact assessment, operational risk assessment and due diligence processes integrated within the organisation\'s procurement process?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:29:37',	'2019-05-08 13:29:37'),
(525,	1530,	'Does the organisation have a standardised business continuity specification of requirements for tenders and contracts concerning is supply chain especially its prioritised activities their support resources and dependencies?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:29:37',	'2019-05-08 13:29:37'),
(526,	1530,	'Does the organisation\'s BCMS maintain a schedule of the internal and/or outsourced suppliers and/or service providers of prioritised activities and/or their dependencies and any single points of failure?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:29:37',	'2019-05-08 13:29:37'),
(527,	1530,	'Does the organisation have a standard set of contract terms and conditions in respect of business continuity that are a mandatory requirement within each supply chain contract or SLA of outsourced suppliers and/or service providers of prioritised activities and/or their dependencies?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:29:37',	'2019-05-08 13:29:37'),
(528,	1530,	'Does the organisation\'s standard terms and conditions of an outsourcing contract and/or SLA for prioritised activities their support resources and dependencies include a right to audit/assess the business continuity capability and resilience of the supplier against a predefined and agreed BCM standard/requirements?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:29:37',	'2019-05-08 13:29:37'),
(529,	1530,	'Does the organisation\'s procurement process contain a mandatory supply chain ‘due diligence process’ and report to verify that the provider of prioritised activities their support resources and dependencies has a proven business continuity capability and sourcing resilience in respect of each outsourced prioritised activity and/or  their dependencies?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:29:37',	'2019-05-08 13:29:37'),
(530,	1530,	'Does the organisation\'s contract performance management process have a mandatory  requirement to verify and validate at specific intervals that a provider of prioritised activities their support resources and dependencies has a proven business continuity capability and sourcing resilience in respect of each outsourced prioritised activitity their support resources their support resources and dependencies?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:29:37',	'2019-05-08 13:29:37'),
(531,	1530,	'Does the organisation have a supply chain sourcing exit strategy/plan to either switch its prioritised activity(ies) or dependency(ies) to another outsourced supplier or internal provision  for each of its outsourced prioritised activities their support resources and dependencies?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:29:37',	'2019-05-08 13:29:37'),
(532,	1530,	'Is the business continuity plan and capability of outsourced suppliers/providers of the organistion\'s prioritised activities their support resources and dependencies assessed by the organisation in respect of the internal and external types of scenario/incident impact that could affect the supplier/service provider and their potential or actual ability to deliver the contracted service or supplies?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:29:37',	'2019-05-08 13:29:37'),
(533,	1530,	'Does the organisation\'s supply chain management process provide for the total failure of outsourced supplies and/or services of prioritised activities their support resources and dependencies?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:29:37',	'2019-05-08 13:29:37'),
(534,	1530,	'Does the organisation\'s standard terms and conditions of an outsourcing contract and/or SLA  for the supply/provision of prioritised activities and/or their dependencies require the supplier/provider to immediately inform the organisation of any internal or external incident that impacts on them and their potential or actual ability to deliver the contracted service or supplies?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:29:37',	'2019-05-08 13:29:37'),
(535,	1530,	'Does the organisation receive annual certified copies of a supplier\'s/provider\'s business continuity testing, exercise and/or rehearsal reports and  improvement action plans as a part of the contract terms and conditions and contract management process of the outsourcing of prioritised activities their support resources and dependencies?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:29:37',	'2019-05-08 13:29:37'),
(536,	1530,	'Is business continuity a standing agenda item at contract performance management meetings with the organisation\'s outsourced suppliers/providers of prioritised activities their support resources and dependencies?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:29:37',	'2019-05-08 13:29:37'),
(537,	1530,	'Does the organisation retain documented information as the evidence of its procurement, supply chain and contract management?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:29:37',	'2019-05-08 13:29:37'),
(538,	1699,	'Has the organisation identified its stakeholders and interested parties that are relevant to the BCMS?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:31:08',	'2019-05-08 13:31:08'),
(539,	1699,	'Has the organisation established and incorporated the needs, requirements and expectations of the organisation’s stakeholders and interested parties in itsBCMS?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:31:08',	'2019-05-08 13:31:08'),
(540,	1700,	'Does the organisation have a process that identifies and applies its legal, regulatory, contractual and operating licence conditions that relate to the continuity of its operations, products, services and interests of relevant interested parties?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:31:54',	'2019-05-08 13:31:54'),
(541,	1700,	'Has the organisation taken into account the applicable, legal, regulatory and other requirements in establishing, implementing and maintaining the BCMS?  (Note: Organisations operating in multiple locations often have to satisfy the requirements of different jurisdictions).',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:31:54',	'2019-05-08 13:31:54'),
(542,	1700,	'Are new or variations of legal, regulatory and other requirements communicated to affected employees, managers and other interested parties in a timely manner?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:31:54',	'2019-05-08 13:31:54'),
(543,	1700,	'Is the BCMS consistent with recognised industry regulation or legislation? (if ‘yes’ please specify)',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:31:54',	'2019-05-08 13:31:54'),
(544,	1700,	'Does the BCMS satisfy and discharge the organisation\'s corporate governance, legal and regulatory obligations?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:31:54',	'2019-05-08 13:31:54'),
(545,	1028,	'Has the organisation determined and documented the scope of its BCMS?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:38:14',	'2019-05-08 13:38:14'),
(546,	1028,	'Has the organisation determined the boundaries and applicability of the BCMS in establishing its scope?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:38:14',	'2019-05-08 13:38:14'),
(547,	1028,	'Has the organisation established the parts of the organisation to be included in the BCMS e.g. is it based upon the whole-of-business?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:38:14',	'2019-05-08 13:38:14'),
(548,	1028,	'Has the organisation identified the products and services and all related activities within the scope of BCMS?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:38:14',	'2019-05-08 13:38:14'),
(549,	1028,	'Does the scope of the BCMS reflect the purpose of the BCMS?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:38:14',	'2019-05-08 13:38:14'),
(550,	1028,	'Does the scope of the BCMS reflect the external and external issues that are relevant to its purpose?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:38:14',	'2019-05-08 13:38:14'),
(551,	1028,	'Does the scope of the BCMS reflect the size, nature, scope and complexity of the organisation?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:38:14',	'2019-05-08 13:38:14'),
(552,	1028,	'Does the scope of the BCMS reflect its legal, regulatory, contractual and operating licence and any other requirements? (Note: Organisations operating in multiple locations often have to satisfy the requirements of different jurisdictions).',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:38:14',	'2019-05-08 13:38:14'),
(553,	1028,	'Does the scope of the BCMS reflect and incorporate the needs, requirements and expectations of the organisation’s stakeholders and interested parties?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:38:14',	'2019-05-08 13:38:14'),
(554,	1028,	'Does the scope of the BCMS reflect the organisation’s risk appetite?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:38:14',	'2019-05-08 13:38:14'),
(555,	1028,	'Does the scope of the BCMS document and explain any relevant exclusions?  (Note: Exclusions shall not affect the organisations ability and responsibility to provide continuity of business and operations that meet BCMS requirements, as determined by BIA and risk assessment and applicable legal, regulatory and other similar requirements. ISO 22301)',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:38:14',	'2019-05-08 13:38:14'),
(556,	1028,	'Does the scope of the BCMS include the organisation\'s supply chain?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:38:14',	'2019-05-08 13:38:14'),
(557,	1028,	'Is the scope of the organisation\'s BCMS proportionate to the organisation\'s risk and relect its risk appetite',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:38:14',	'2019-05-08 13:38:14'),
(558,	1545,	'Has the organisation established and implemented a Business Continuity Management System (BCMS)?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:40:59',	'2019-05-08 13:40:59'),
(559,	1545,	'Does the organisation have a process to maintain and improve its Business Continuity Management System (BCMS)?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:40:59',	'2019-05-08 13:40:59'),
(560,	1545,	'Has the organisation determined and provided the resources needed to establish, implement, operate, maintain and improve the BCMS?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:40:59',	'2019-05-08 13:40:59'),
(561,	1545,	'Is the BCMS aligned to ISO 22301 and/or ISO 22313  or any  legislation or other recognised standard and/or regulatory and/or other guidelines?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:40:59',	'2019-05-08 13:40:59'),
(562,	1545,	'Are the roles, responsibilities, accountabilities and authority of top management and employees within the BCMS clearly defined, documented and assigned?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:40:59',	'2019-05-08 13:40:59'),
(563,	1545,	'Has the organisation determined the external and  internal issues that are relevant to its purpose and affect its ability to achieve the intended outcomes of its BCMS?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:40:59',	'2019-05-08 13:40:59'),
(564,	1545,	'Is the focus of the BCMS aligned to the organisation\'s prioritised activities and their dependencies at a product and servi ce level?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:40:59',	'2019-05-08 13:40:59'),
(565,	1545,	'Is the BCMS Programme defined and designed within a BCM System?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:40:59',	'2019-05-08 13:40:59'),
(566,	1545,	'Are the BCMS objectives and outcomes established and defined within the BCMS?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:40:59',	'2019-05-08 13:40:59'),
(567,	1545,	'Does the BCMS apply the Plan-Do-Check-Act (PDCA) cycle model to implement and maintain the BCMS?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:40:59',	'2019-05-08 13:40:59'),
(568,	1545,	'Are the BCMS objectives and outcomes aligned to the corporate business strategies and plans?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:40:59',	'2019-05-08 13:40:59'),
(569,	1545,	'Does the BCMS establish and maintain records/information to provide ‘verified’ auditable evidence of the effective operation of the BCMS?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:40:59',	'2019-05-08 13:40:59'),
(570,	1545,	'Is there a dedicated annual budget and resources allocated to BCMS for its implementation, maintenance and improvement?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:40:59',	'2019-05-08 13:40:59'),
(571,	1545,	'Does the organisation retain documented information as the evidence of its BCMS?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:40:59',	'2019-05-08 13:40:59'),
(572,	1545,	'Does the BCMS have documented change control process/procedure to ensure it remains current, appropriate (fit for purpose) and plausible?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:40:59',	'2019-05-08 13:40:59'),
(573,	1545,	'Is the BCMS reviewed at least once every 12 months or at planned intervals or when significant changes occur to or within or that impact upon the organisation?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:40:59',	'2019-05-08 13:40:59'),
(574,	1545,	'Does the BCMS provide an annual assessment review report?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:40:59',	'2019-05-08 13:40:59'),
(575,	1545,	'Does the organisation ensure that all personnel that are assigned roles and responsibilities within the BCMS are competent and capable of performing their tasks?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:40:59',	'2019-05-08 13:40:59'),
(576,	1545,	'Are professionally qualified and experienced business continuity practitioners employed in the implementation, exercising and maintenance of the BCMS and its business continuity procedures and arrangements in particular?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:40:59',	'2019-05-08 13:40:59'),
(577,	1545,	'Does the BCMS maintain a schedule of the organisation\'s prioritised activities and/or their dependenceis and single points of failure?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:40:59',	'2019-05-08 13:40:59'),
(578,	1545,	'Has the organisation\'s to management appointed one or more persons who shall be reponsible for implementing and maintaining the BCMS irrespective of other responsibilities?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:40:59',	'2019-05-08 13:40:59'),
(579,	1533,	'Does the organisation\'s top management and other relevant management roles throughout the organisation demonstrate leadership, support and strong commitment with respect to the BCMS?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:52:36',	'2019-05-08 13:52:36'),
(580,	1533,	'Is the BCMS programme openly endorsed and fully and actively supported by top management?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:52:36',	'2019-05-08 13:52:36'),
(581,	1533,	'Is the organisation\'s top management proactively and visibly involved in the BCMS programme?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:52:36',	'2019-05-08 13:52:36'),
(582,	1533,	'Is the BCMS programme monitored and regularly evaluated by the organisation\'s top management?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:52:36',	'2019-05-08 13:52:36'),
(583,	1533,	'Is the BCMS a standing agenda item on the organisation’s Board meetings?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:52:36',	'2019-05-08 13:52:36'),
(584,	1533,	'Is the BCMS a standing agenda item at the organisation\'s Risk Management Committee meetings?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:52:36',	'2019-05-08 13:52:36'),
(585,	1533,	'Is business continuity a standing agenda item on the operational and business management meetings throughout the organisation?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:52:36',	'2019-05-08 13:52:36'),
(586,	1533,	'Does the organisation\'s top management and other relevant management roles strongly promote and ensure the integration of BCMS requirements into the organisation’s business processes?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:52:36',	'2019-05-08 13:52:36'),
(587,	1533,	'Does the organisation\'s top management and other relevant management roles ensure the resources needed for the BCMS are available?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:52:36',	'2019-05-08 13:52:36'),
(588,	1533,	'Does the organisation\'s  top management and other relevant management roles support other relevant management roles to demonstrate their leadership and commitment as it applies to their areas of responsibility?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:52:36',	'2019-05-08 13:52:36'),
(589,	1533,	'Has top management ensured there is an organisation BCM strategy and framework?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:52:36',	'2019-05-08 13:52:36'),
(590,	1533,	'Has top management endured that BCMS objectives and plans are established?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:52:36',	'2019-05-08 13:52:36'),
(591,	1533,	'Does top the  organisation\'s top management actively engage in the organisation\'s business continuity exercising and testing programme?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:52:36',	'2019-05-08 13:52:36'),
(592,	1533,	'Does the organisation\'s top management conduct management reviews of the BCMS?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:52:36',	'2019-05-08 13:52:36'),
(593,	1533,	'Does the organisation\'s top management ensure that policies and objectives are established for the BCMS?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:52:36',	'2019-05-08 13:52:36'),
(594,	1533,	'Does the organisation\'s top management ensure that the policies and objectives for the BCMS are compatible with the straegic direction of the organisation?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:52:36',	'2019-05-08 13:52:36'),
(595,	1033,	'Does the organisation\'s top management and other relevant management roles throughout the organisation demonstrate leadership, support and strong commitment with respect to the BCMS?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:54:28',	'2019-05-08 13:54:28'),
(596,	1033,	'Is the BCMS programme openly endorsed and fully and actively supported by top management?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:54:28',	'2019-05-08 13:54:28'),
(597,	1033,	'Is the organisation\'s top management proactively and visibly involved in the BCMS programme?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:54:28',	'2019-05-08 13:54:28'),
(598,	1033,	'Is the BCMS programme monitored and regularly evaluated by the organisation\'s top management?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:54:28',	'2019-05-08 13:54:28'),
(599,	1033,	'Is the BCMS a standing agenda item on the organisation’s Board meetings?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:54:28',	'2019-05-08 13:54:28'),
(600,	1033,	'Is the BCMS a standing agenda item at the organisation\'s Risk Management Committee meetings?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:54:28',	'2019-05-08 13:54:28'),
(601,	1033,	'Is business continuity a standing agenda item on the operational and business management meetings throughout the organisation?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:54:28',	'2019-05-08 13:54:28'),
(602,	1033,	'Does the organisation\'s top management and other relevant management roles strongly promote and ensure the integration of BCMS requirements into the organisation’s business processes?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:54:28',	'2019-05-08 13:54:28'),
(603,	1033,	'Does the organisation\'s top management and other relevant management roles ensure the resources needed for the BCMS are available?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:54:28',	'2019-05-08 13:54:28'),
(604,	1033,	'Does the organisation\'s  top management and other relevant management roles support other relevant management roles to demonstrate their leadership and commitment as it applies to their areas of responsibility?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:54:28',	'2019-05-08 13:54:28'),
(605,	1033,	'Has top management ensured there is an organisation BCM strategy and framework?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:54:28',	'2019-05-08 13:54:28'),
(606,	1033,	'Has top management endured that BCMS objectives and plans are established?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:54:28',	'2019-05-08 13:54:28'),
(607,	1033,	'Does top the  organisation\'s top management actively engage in the organisation\'s business continuity exercising and testing programme?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:54:28',	'2019-05-08 13:54:28'),
(608,	1033,	'Does the organisation\'s top management conduct management reviews of the BCMS?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:54:28',	'2019-05-08 13:54:28'),
(609,	1033,	'Does the organisation\'s top management ensure that policies and objectives are established for the BCMS?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:54:28',	'2019-05-08 13:54:28'),
(610,	1033,	'Does the organisation\'s top management ensure that the policies and objectives for the BCMS are compatible with the straegic direction of the organisation?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:54:28',	'2019-05-08 13:54:28'),
(611,	1034,	'Has the organisation\'s top management established and published a documented organisation business continuity policy?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:56:21',	'2019-05-08 13:56:21'),
(612,	1034,	'Has top management nominated or appointed a person with approprite seniority and authority to be accountable for BCM Policy and its implementation, monitoring and reporting?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:56:21',	'2019-05-08 13:56:21'),
(613,	1034,	'Does the policy include or make reference to the objectives of business continuity within the organisation?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:56:21',	'2019-05-08 13:56:21'),
(614,	1034,	'Does the policy include or make reference to the scope of business continuity, including limitations and exclusions?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:56:21',	'2019-05-08 13:56:21'),
(615,	1034,	'Do top management actively demonstrate commitment to the BCM Policy?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:56:21',	'2019-05-08 13:56:21'),
(616,	1034,	'Is the policy communicated to all persons working for or on behalf of the organisation?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:56:21',	'2019-05-08 13:56:21'),
(617,	1034,	'Is the policy made available to relevant stakeholders/interested parties?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:56:21',	'2019-05-08 13:56:21'),
(618,	1034,	'Is the policy reviewed at planned intervals and when significant changes occur to or within the organisation to ensure its continued suitability?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:56:21',	'2019-05-08 13:56:21'),
(619,	1034,	'Does the organisation retain documented information on its business continuity policy?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:56:21',	'2019-05-08 13:56:21'),
(620,	1034,	'Does the organisation have assurance procedures to ensure that all parts of the organisation are fully aware of and comply with the BCM policy?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:56:21',	'2019-05-08 13:56:21'),
(621,	1035,	'Has the organisation\'s top management appointed one or more management representatives with the appropriate authority, competencies and capability to be responsible for the BCMS and to be accountable for its establishment, implementation , maintenance and effective operation?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:57:45',	'2019-05-08 13:57:45'),
(622,	1035,	'Is an organisation role formally assigned as being responsible for the delivery and maintenance of the BCMS and business continuity procedures and arrangements?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:57:45',	'2019-05-08 13:57:45'),
(623,	1035,	'Are selected key employees assigned to support and implement the BCMS programme?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:57:45',	'2019-05-08 13:57:45'),
(624,	1035,	'Are the key employees briefed on and trained in their BCMS and/or business continuity procedure roles etc?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:57:45',	'2019-05-08 13:57:45'),
(625,	1035,	'Have the organisation\'s  top management appointed a steering committee to oversee the implementation and ongoing monitoring and performance evaluation of BCMS?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:57:45',	'2019-05-08 13:57:45'),
(626,	1035,	'Are business continuity roles, accountabilities, responsibilities and authorities integrated into job descriptions which may be reinforced by including them in the organisation’ s appraisal, reward and recognition policy?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:57:45',	'2019-05-08 13:57:45'),
(627,	1035,	'Has the organisation\'s top management assigned authority and responsibility for reporting on the performance of the BCMS to top management?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:57:45',	'2019-05-08 13:57:45'),
(628,	1035,	'Has top management assigned authority and responsibility for ensring the the BCMS conforms to the ISO standard/regulatory and legal requirements?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:57:45',	'2019-05-08 13:57:45'),
(629,	1534,	'When planning for its BCMS does the organisation consider the needs and expectations of interested parties that are relevant to its purpose and that affects its alility to achieve the intended outcomes of its BCMS?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:59:00',	'2019-05-08 13:59:00'),
(630,	1534,	'When planning for its BCMS does the organisation consider the internal and external issues that are relevant to its purpose and that affects its ability to achieve the intended outcomes of its BCMS?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:59:00',	'2019-05-08 13:59:00'),
(631,	1534,	'When planning for the BCMS does the organisation consider the risks and opportunites that are relevant to its purpose and that affects its alility to achieve the intended outcomes of its BCMS?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:59:00',	'2019-05-08 13:59:00'),
(632,	1534,	'Does the organisation plan actions to address its identified risks and opportunities ?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:59:00',	'2019-05-08 13:59:00'),
(633,	1534,	'Does the organisation plan how to integrate and implement the actions in respect of its identified risks and opportunities into its BCMS processes?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:59:00',	'2019-05-08 13:59:00'),
(634,	1534,	'Does the organisation evaluate the effectiveness of the actions in respect of its identifed risks and opportunities?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:59:00',	'2019-05-08 13:59:00'),
(635,	1534,	'Does the organisation ensure that documented information will be available to evaluate if the actions have been effective?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 13:59:00',	'2019-05-08 13:59:00'),
(636,	1037,	'Does the organisation have a plan for implementing and managing a BCMS (see Clause 8)?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 14:01:52',	'2019-05-08 14:01:52'),
(637,	1037,	'Has the organisation\'s top management established its business continuity objectives?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 14:01:52',	'2019-05-08 14:01:52'),
(638,	1037,	'Does the organisation\'s BCM objectives protect prioritised activities (products and services) their support resources and dependencies?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 14:01:52',	'2019-05-08 14:01:52'),
(639,	1037,	'Is the organistion\'s BCMS  implementation and management plan regularly reviewed and updated?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 14:01:52',	'2019-05-08 14:01:52'),
(640,	1037,	'Have the organisation\'s top management communicated the organisation\'s business continuity objectives throughout the organisation?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 14:01:52',	'2019-05-08 14:01:52'),
(641,	1037,	'Are the organisation\'s business continuity objectives consistent with the organisation\'s business continuity policy?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 14:01:52',	'2019-05-08 14:01:52'),
(642,	1037,	'Do the organisation\'s business continuity objectives take account of the minimum level of products and services that is acceptable to the organisation to achieve its objectives?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 14:01:52',	'2019-05-08 14:01:52'),
(643,	1037,	'Do the organisation\'s business continuity objectives take account of the needs and expectations of interested parties?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 14:01:52',	'2019-05-08 14:01:52'),
(644,	1037,	'Are the organisation\'s business continuity objectives consistent with and relect the organisation\'s legal, regulatory, corporate governance, contractual and operating licence conditions?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 14:01:52',	'2019-05-08 14:01:52'),
(645,	1037,	'Does the organisation\'s business continuity objectives take account of the organisation\'s supply chain?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 14:01:52',	'2019-05-08 14:01:52'),
(646,	1037,	'Are the organisation\'s business continuity objectives subjectively and/or objectively measureable?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 14:01:52',	'2019-05-08 14:01:52'),
(647,	1037,	'Does the organisation\'s business continuity objectives include its supply chain?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 14:01:52',	'2019-05-08 14:01:52'),
(648,	1037,	'Does the organisation\'s business continuity include its procurement process?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 14:01:52',	'2019-05-08 14:01:52'),
(649,	1037,	'Does the organisation\'s business continuity objectives include its outsourced service/products contract management?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 14:01:52',	'2019-05-08 14:01:52'),
(650,	1037,	'Are the organisation\'s business continuity objectives monitored, evaluated and updated as appropriate?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 14:01:52',	'2019-05-08 14:01:52'),
(651,	1037,	'Does the organisation determine what needs to be done to achieve its business continuity objectives?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 14:01:52',	'2019-05-08 14:01:52'),
(652,	1037,	'Does the organisation determine what resources are required to achieve its business continuity objectives?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 14:01:52',	'2019-05-08 14:01:52'),
(653,	1037,	'Does the organisation determine a time scale to achieve its business continuity objectives?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 14:01:52',	'2019-05-08 14:01:52'),
(654,	1037,	'Does the organisation determine  how the results of its business continuity objectives will be evaluated?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 14:01:52',	'2019-05-08 14:01:52'),
(655,	1037,	'Does the organisation retain documented information on its business continuity objectives?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 14:01:52',	'2019-05-08 14:01:52'),
(656,	1535,	'Has the organisation determined and provided the resources needed for the establishment, implementation, maintenance and continual improvement of the BCMS?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 15:27:02',	'2019-05-08 15:27:02'),
(657,	1535,	'Is there a dedicated annual budget allocated for the BCMS resources?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 15:27:02',	'2019-05-08 15:27:02'),
(658,	1535,	'Have the resources been allocated?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 15:27:02',	'2019-05-08 15:27:02'),
(659,	1535,	'Does the resources include people and people related resources?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 15:27:02',	'2019-05-08 15:27:02'),
(660,	1535,	'Does the resources include the provision of training, education, awareness and exercising?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 15:27:02',	'2019-05-08 15:27:02'),
(661,	1535,	'Does the resources include facilities including work locations and infrastructure?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 15:27:02',	'2019-05-08 15:27:02'),
(662,	1535,	'Does the resources include information and communications technology (ICT) including applications that support effective and efficient BCMS management?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 15:27:02',	'2019-05-08 15:27:02'),
(663,	1535,	'Are the resources and their allocation periodically reviewed to ensure their appropriateness and adequacy?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 15:27:02',	'2019-05-08 15:27:02'),
(664,	1535,	'Has the organisation nominated incident response personnel with the necessary responsibility, authority and competence to manage an incident?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 15:27:02',	'2019-05-08 15:27:02'),
(665,	1535,	'Has the organisation assigned personnel to teams according to their demonstrated competence/capability of dealing with different aspects of incident response?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 15:27:02',	'2019-05-08 15:27:02'),
(666,	1535,	'Has the organisation appointed a incident management and strategic management team?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 15:27:02',	'2019-05-08 15:27:02'),
(667,	1535,	'Has the organisation appointed a communications and media management  team in respect of incident response?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 15:27:02',	'2019-05-08 15:27:02'),
(668,	1535,	'Has the organisation appointed a safety and welfare management team in respect of incident response?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 15:27:02',	'2019-05-08 15:27:02'),
(669,	1535,	'Has the organisation appointed a customer/client/interested parties management team in respect of incident response?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 15:27:02',	'2019-05-08 15:27:02'),
(670,	1535,	'Has the organisation appointed a salvage and security management team in respect of incident response?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 15:27:02',	'2019-05-08 15:27:02'),
(671,	1535,	'Has the organisation appointed a resumption of prioritised activities and their support resources management team in respect of incident response?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 15:27:02',	'2019-05-08 15:27:02'),
(672,	1535,	'Has the organisation appointed an ICT resumption/recovery management team in respect of incident response?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 15:27:02',	'2019-05-08 15:27:02'),
(673,	1535,	'Has the organisation appointed a personnel management team in respect of incident response?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 15:27:02',	'2019-05-08 15:27:02'),
(674,	1535,	'Has the organisation appointed a safety and welfare team in respect of incident response?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 15:27:02',	'2019-05-08 15:27:02'),
(675,	1039,	'Does the organisation ensure that all personnel and/or teams that have been assigned roles and responsibilities in the BCMS especially business continuity procedures and arrangements, are competent and capable of performing their roles?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:36:54',	'2019-05-08 16:36:54'),
(676,	1039,	'Has the organisation determined the necessary competencies and capabilitiesof individuals and teams required for all BCMS roles and responsibilities that affects its BCMS and business continuity performance?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:36:54',	'2019-05-08 16:36:54'),
(677,	1039,	'Has the organisation determined the awareness, knowledge, understanding, skills and experience needed to fulfil the roles and responsibilities within its BCMS?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:36:54',	'2019-05-08 16:36:54'),
(678,	1039,	'Has the organisation ensured individuals and teams engaged in delivering its BCMS are competent and capable on the basis of appropriate education, training and experience?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:36:54',	'2019-05-08 16:36:54'),
(679,	1039,	'Does the organisation require contractors working on its behalf to demonstrate that person(s) doing work under its control have the requisite competence and capability for the BCMS and response that they will perform?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:36:54',	'2019-05-08 16:36:54'),
(680,	1039,	'Does the organisation retain appropriate documented informat as evidence of the competence/capability of individuals and teams?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:36:54',	'2019-05-08 16:36:54'),
(681,	1039,	'Has the organisation established a training programme for all current employees that may be affected by and/or have to deal with a disruptive incident?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:36:54',	'2019-05-08 16:36:54'),
(682,	1039,	'Does the organisation have a training needs analaysis  process for identifying and delivering the business continuity training requirements of all participants engaged in the planning, delivery and management of the BCMS and business continuity capability?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:36:54',	'2019-05-08 16:36:54'),
(683,	1039,	'Does the organisation provide a personal development programme for individuals or teams assigned roles within the BCMS that identifies training, education, development and other support needed to attain competences?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:36:54',	'2019-05-08 16:36:54'),
(684,	1039,	'Is business continuity training provided for key employees directly involved in the planning, delivery and management of the BCMS and business continuity procedures and arrangements?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:36:54',	'2019-05-08 16:36:54'),
(685,	1039,	'Is the business continuity training programme regularly evaluated to reflect changes and needs within the organisation?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:36:54',	'2019-05-08 16:36:54'),
(686,	1039,	'Are new developments in business continuity and/or the BCMS incorporated into the training programme?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:36:54',	'2019-05-08 16:36:54'),
(687,	1039,	'Does the organisation evaluate the effectiveness of training received against defined training needs and requirements in order to verify conformity with BCMS training requirements?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:36:54',	'2019-05-08 16:36:54'),
(688,	1039,	'Has the organisation evaluated the effectiveness of actions taken to ensure individuals and teams engaged in delivering its BCMS and business continuity have the appropriate education, training and experience?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:36:54',	'2019-05-08 16:36:54'),
(689,	1039,	'Does the organisation retain appropriate documented informat as evidence of the training of individuals and teams?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:36:54',	'2019-05-08 16:36:54'),
(690,	1040,	'Has the organisation established a business continuity awareness programme for all current employees to promote and create awareness of the organisation\'s BCMS?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:38:53',	'2019-05-08 16:38:53'),
(691,	1040,	'Is business continuity awareness an integral part of the organisation\'s induction programme for all new employees, managers and executives?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:38:53',	'2019-05-08 16:38:53'),
(692,	1040,	'Are the organisation\'s employees made aware of the their contribution to the effectiveness of the BCMS including the benefits of improved business continuity performance?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:38:53',	'2019-05-08 16:38:53'),
(693,	1040,	'Are organisation employees made aware of the implications of not conforming with the organisation\'s BCMS requirements?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:38:53',	'2019-05-08 16:38:53'),
(694,	1040,	'Are organisation employees aware of their own role during a disruptive incident?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:38:53',	'2019-05-08 16:38:53'),
(695,	1040,	'Does the organisation awareness programme include briefing key suppliers and distributors on the organisations business continuity procedures and arrangements?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:38:53',	'2019-05-08 16:38:53'),
(696,	1040,	'Are organisation emloyees aware of their role and responsibility with regard to incident prevention, detection, mitigation, self-protection, evacuation, response, continuty and recovery?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:38:53',	'2019-05-08 16:38:53'),
(697,	1040,	'Has the organisation established a process to build, promote, integrate and embed a business continity culture within the organisation?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:38:53',	'2019-05-08 16:38:53'),
(698,	1040,	'Is there a recognition/rewards system that reinforces employees involvement in the BCMS?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:38:53',	'2019-05-08 16:38:53'),
(699,	1040,	'Are business continuty performance indicators communicated to all employees?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:38:53',	'2019-05-08 16:38:53'),
(700,	1040,	'Do organisation employees  fully understand their roles, accountabilities, responsibilities and authorities within the BCMS?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:38:53',	'2019-05-08 16:38:53'),
(701,	1040,	'Are the roles, accountabilities and responsibilities of employees within the BCMS included within their job description?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:38:53',	'2019-05-08 16:38:53'),
(702,	1040,	'Are the contributions of employees to the BCMS reflected in their annual performance appraisals?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:38:53',	'2019-05-08 16:38:53'),
(703,	1040,	'Are the contributions of employees to the BCMS reflected in the organisation\'s annual performance reward system?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:38:53',	'2019-05-08 16:38:53'),
(704,	1040,	'Does the organisation regularly evaluate and update its business continuity awareness programme?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:38:53',	'2019-05-08 16:38:53'),
(705,	1040,	'Does the organisation regularly evaluate the effectiveness of  business continuity awareness programme?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:38:53',	'2019-05-08 16:38:53'),
(706,	1041,	'Has the organisation established and  implemented procedures for internal communication amongst interested parties and employees within the organisation?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:40:07',	'2019-05-08 16:40:07'),
(707,	1041,	'Has the organisation established and implemented procedures for external communication with customers, partners, local community and other interested parties including the media?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:40:07',	'2019-05-08 16:40:07'),
(708,	1041,	'Has the organisation established and implemented procedures for receiving, documenting and responding to communication from interested parties?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:40:07',	'2019-05-08 16:40:07'),
(709,	1041,	'Has the organisation established and implemented procedures for ensuring availability of the means of communication during a disruptive incident ?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:40:07',	'2019-05-08 16:40:07'),
(710,	1041,	'Has the organisation established and implemented procedures for facilitating structured communication with appropriate authorities and ensuring the interoperability of multiple responding organisation and personnel?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:40:07',	'2019-05-08 16:40:07'),
(711,	1041,	'Has the organisation established and implemented procedures for operating and testing communications capabilities intended for use during disruption or normal communications ?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:40:07',	'2019-05-08 16:40:07'),
(712,	1536,	'Does the organisation control documentation to ensure it creates, maintains and protects documents in a manner that is approprite and sufficient to implement and operate its BCMS?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:40:53',	'2019-05-08 16:40:53'),
(713,	1536,	'Does the organisation\'s BCMS include documented information required by ISO 22301 and ISO 22313?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:40:53',	'2019-05-08 16:40:53'),
(714,	1536,	'Does the organisation\'s documented information provide evidence of conformity to the requirements and effective operation of the organisation\'s BCMS?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:40:53',	'2019-05-08 16:40:53'),
(715,	1536,	'Does the organisation\'s BCMS include documented information determined by the organisation as being necessary for the effective operation and functioning of the BCMS?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:40:53',	'2019-05-08 16:40:53'),
(716,	1044,	'When creating and updating documented information does the organisation ensure appropriate identification and description e.g. Time, date, author or unique reference number?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:42:19',	'2019-05-08 16:42:19'),
(717,	1044,	'When creating and updating documented information does the organisation ensure appropriate format (e.g. Language,software version, graphics) and media (e.g. Paper or electronic)?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:42:19',	'2019-05-08 16:42:19'),
(718,	1044,	'When creating and updating documented information does the organisation ensure appropriate review and approval of suitability and adequacy?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:42:19',	'2019-05-08 16:42:19'),
(719,	1045,	'Can the control of documented information process be described as a complex document control system rather than its primary focus and purpose as described in clause 7.5.3 of ISO 22313?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:43:37',	'2019-05-08 16:43:37'),
(720,	1045,	'Is documented information required by the organisation\'s BCMS  controlled to ensure it is available and suitable for use, when are where it is needed?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:43:37',	'2019-05-08 16:43:37'),
(721,	1045,	'Is documented information required by the organisation\'s BCMS  controlled to ensure it is adequately protected e.g. from lost of confidentiality, improper use or loss of integrity?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:43:37',	'2019-05-08 16:43:37'),
(722,	1045,	'Does the controlling of documented information by the organisation address its disribution, access, retrival and use?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:43:37',	'2019-05-08 16:43:37'),
(723,	1045,	'Does the controlling of documented information by the organisation address its storage and preservation??',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:43:37',	'2019-05-08 16:43:37'),
(724,	1045,	'Does the controlling of documented information by the organisation address control of changes i.e. version control?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:43:37',	'2019-05-08 16:43:37'),
(725,	1045,	'Does the controlling of documented information by the organisation address its retrieval and use?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:43:37',	'2019-05-08 16:43:37'),
(726,	1045,	'Does the controlling of documented information by the organisation address its preservation of legibility?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:43:37',	'2019-05-08 16:43:37'),
(727,	1045,	'Does the controlling of documented information by the organisation address control the prevention of unintended use of obsolete information?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-08 16:43:37',	'2019-05-08 16:43:37'),
(728,	1537,	'Does the organisation have a documented business continuity operational planning and control process that enables it to determine, plan, implement and control those actions needed to fulfil its business continuity policy and objectives?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:15:54',	'2019-05-09 09:15:54'),
(729,	1537,	'Is the operational planning and control process defined as a programme to ensure that the organisation\'s business continuity is managed appropriately ad its effectiveness maintained?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:15:54',	'2019-05-09 09:15:54'),
(730,	1537,	'Is the operational planning process based upon a whole of business/organisation wide?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:15:54',	'2019-05-09 09:15:54'),
(731,	1537,	'Is the operational planning process co-ordinated and integrated with the organisation\'s supply chain?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:15:54',	'2019-05-09 09:15:54'),
(732,	1537,	'Is the operational planning process based upon the business continuity strategies derived from the BIA?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:15:54',	'2019-05-09 09:15:54'),
(733,	1537,	'Is the operational planning process primarily concerned with the organisation\'s prioritised activities and their dependencies?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:15:54',	'2019-05-09 09:15:54'),
(734,	1537,	'Does the operational planning process cover from initial response to full or an agreed level (performance and functionality) of restoration and recovery of prioritised activities and/or their dependencies?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:15:54',	'2019-05-09 09:15:54'),
(735,	1537,	'Is the operational planning process integrated and co-ordinated with other parts of the organisation e.g. geographically, divisions, departments, support functions that may be impacted and/or involved in the incident management,  business resumption and recovery process?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:15:54',	'2019-05-09 09:15:54'),
(736,	1537,	'Is the operational planning process integrated and co-ordinated with the relevant authorities and services e.g. industry regulators, emergency services and local authorities that may be involved in managing the impact and/or in the business resumption and recovery process?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:15:54',	'2019-05-09 09:15:54'),
(737,	1537,	'Does the current operational planning process specifically include pandemic influenza and other human resources and industry specific types of scenario?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:15:54',	'2019-05-09 09:15:54'),
(738,	1537,	'Is the operational planning process integrated and linked to the organisations business as usual problem solving processes e.g. technical response to an operational problem (RtOP)?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:15:54',	'2019-05-09 09:15:54'),
(739,	1537,	'Is the operational planning process co-ordinated and integrated with the corporate crisis management and communications and PR incident management process?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:15:54',	'2019-05-09 09:15:54'),
(740,	1049,	'Does the organisation have a formal documented standard procedure and evaluation process for conducting a BIA?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(741,	1049,	'Is the methodology, process, procedure and outcomes / outputs consistent with ISO 22301 and/or ISO 22313?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(742,	1049,	'Does the process/procedure define the required outputs from a BIA?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(743,	1049,	'Is the BIA process, methodology and outputs documented?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(744,	1049,	'Are there guidelines and criteria to help establish the organisation’s prioritised activities?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(745,	1049,	'Does the organisation use a software tool to carry out a BIA? (if \'yes\' please provide details)',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(746,	1049,	'Does the BIA determine business continuity and recovery priorities, objectives and targets?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(747,	1049,	'Does the organisation have standard process and template format to proved a BIA report?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(748,	1049,	'Does the organisation review the adequacy of the BIA at planned intervals or when key changes occur that affect the organisation or its prioritised activities and their dependencies?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(749,	1049,	'Is there a process to ensure that a BIA is conducted as part of new developments and major changes in systems, products, services and sourcing?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(750,	1049,	'Does the organisation retain documented information as evidence of its BIA activities?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(751,	1049,	'Has the organisation carried out a BIA to identify its prioritised activities?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(752,	1049,	'Have the prioritised activities of the organisation to provide its products and services been identified and documented?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(753,	1049,	'Has the BIA produced an IT application recovery gap analysis identifying the minimum time that the business divisions require an IT application (including data) to be recovered and the proven time that the IT department is currently able to recover the application?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(754,	1049,	'Has the BIA produced a telephony recovery gap analysis identifying the minimum time that the business divisions require telephony to be recovered and the proven time that IT is currently able to recover the minimum telephony requirement?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(755,	1049,	'Does the BIA include the organisation’s supply chain?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(756,	1049,	'Is a BIA used as part of the outsourcing procurement process?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(757,	1049,	'Does the BIA process include key dates, seasons, time of year and other business cycles?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(758,	1049,	'Has a standardised BIA been completed by each business division within the organisation at least once within the last 12 months and been signed-off by the relevant business and technical manager(s)?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(759,	1049,	'Have the financial and non-financial impacts and/or consequences of an incident or disruption, overtime, of not performing each of the organisation’s prioritised activities and/or their support and/or dependencies been identified and assessed?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(760,	1049,	'Does the BIA process define disruptive incident impact and evaluation criteria?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(761,	1049,	'Are the resulting impacts and consequences documented?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(762,	1049,	'Are the impacts and consequences regularly reviewed and evaluated?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(763,	1049,	'Are the impacts and consequences used in the organisation’s operational risk management process?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(764,	1049,	'Has the impact loss of IT and/or data and/or systems been analysed and documented?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(765,	1049,	'Has the impact loss of telecommunications systems been analysed and documented?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(766,	1049,	'Does the assessment include legal, contractual, regulatory and operating licence and other requirements?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(767,	1049,	'Has the BIA established the maximum tolerable period of disruption for each critical business activity by identifying the length of time within which normal levels of operation  need to be resumed for each critical business activity?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(768,	1049,	'Has the impact loss of the organisations JIT supply chain been analysed and documented?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(769,	1049,	'Have the Recovery Time Objective (RTO) for each prioritised activity been identified and agreed?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(770,	1049,	'Has the organisation set the minimum acceptable level of business resumption / recovery in terms of functionality and performance for each prioritised activity as the Minimum Business Continuity Objective (MBCO)',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(771,	1049,	'Has the organisation identified the maximum period of outage for each prioritised activity before it becomes a serious risk?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(772,	1049,	'Is each recovery time objective (RTO) set within the maximum tolerable period of disruption after which the impact)s) would be unacceptable?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(773,	1049,	'Has the identification of the resumption/recovery times for prioritised activities and their dependencies been used to create a prioritised business resumption and recovery profile?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(774,	1049,	'Has the organisation identified the dependencies and resources needed to maintain, restore, resume and/or recover each of its prioritised activities to an acceptable level of functionality and performance (MBCO)?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(775,	1049,	'Have the key personnel that carry out and/or are linked to these activities been identified and documented?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(776,	1049,	'Does the BIA identify replacement lead times e.g. equipment?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(777,	1049,	'Is there a long lead time for the replacement of prioritised activity equipment or plant?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(778,	1049,	'Has equipment and plant linked to these activities been identified and documented?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(779,	1049,	'Have all the internal and external dependencies relevant to and between each prioritised activity  been identified and documented?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(780,	1049,	'Have the key documents, records or data that are critical to each prioritised activity been identified and documented?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(781,	1049,	'Have key suppliers, service providers, outsourced partners and other relevant parties been identified and documented for each prioritised activity?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(782,	1049,	'Is there a full and complete list of prioritised activity telecommunications services and the critical systems that support them?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(783,	1049,	'Is there a full and complete list of IT, applications, data and the critical systems that support them?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(784,	1049,	'Do IT system, application and data recovery times align with the requirements of prioritised activities?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(785,	1049,	'Do communication system recovery times align with the requirements of prioritised activities?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(786,	1049,	'Are there arrangements in place to relocate to alternative premises or production site?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(787,	1049,	'Can restoration or recovery of the organisation\'s prioritied activity  and/or their support resources be achieved without depending on a 3rd party supplier?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:26:07',	'2019-05-09 09:26:07'),
(788,	1051,	'Does the organisation have a formal documented standardised procedure and process for carrying out risk assessment?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:30:41',	'2019-05-09 09:30:41'),
(789,	1051,	'Does the organisation retain documented information as evidence of its risk assessment programme and  activities?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:30:41',	'2019-05-09 09:30:41'),
(790,	1051,	'Has a role within the organisation been formally assigned the responsibility for the management of risk within the organisation?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:30:41',	'2019-05-09 09:30:41'),
(791,	1051,	'Is the methodology, process, procedure and outcomes / outputs consistent with ISO 22301 and/or ISO 22313?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:30:41',	'2019-05-09 09:30:41'),
(792,	1051,	'Does the organistion have a documented Operational Risk Management Policy?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:30:41',	'2019-05-09 09:30:41'),
(793,	1051,	'Does the organistion have a documented Risk Management Strategy and Programme?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:30:41',	'2019-05-09 09:30:41'),
(794,	1051,	'Does the organisation\'s top management define the organinsation\'s risk appetite i.e. acceptable levels of risk?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:30:41',	'2019-05-09 09:30:41'),
(795,	1051,	'Does the organisation have a formally documented risk appetite?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:30:41',	'2019-05-09 09:30:41'),
(796,	1051,	'Does the organisation use a software tool to carry out risk assessment? (if \'yes\' please provide details)',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:30:41',	'2019-05-09 09:30:41'),
(797,	1051,	'Does the risk assessment systematically identify, analyse and evaluate the risk disruptive incidents to the organisation’s prioritised activities and the resources that support them?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:30:41',	'2019-05-09 09:30:41'),
(798,	1051,	'Does the risk assessment process define the required output from the risk assessment?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:30:41',	'2019-05-09 09:30:41'),
(799,	1051,	'Does the risk assessment process define the types of risk, their impact and evaluation criteria?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:30:41',	'2019-05-09 09:30:41'),
(800,	1051,	'Has the organisation identified risks of disruption in respect of its prioritised activities and the resources that support the organisation’s products and services?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:30:41',	'2019-05-09 09:30:41'),
(801,	1051,	'Does the risk assessment differentiate between the identification of risks into specific threats and disruptive incidents?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:30:41',	'2019-05-09 09:30:41'),
(802,	1051,	'Has the organisation’s vulnerability to specific threats and disruptions of its prioritised activities, their support resources and dependencies been identified and documented?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:30:41',	'2019-05-09 09:30:41'),
(803,	1051,	'Does the risk assessment evaluate and establish which disruptive related threats/incidents require treatment?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:30:41',	'2019-05-09 09:30:41'),
(804,	1051,	'Does the risk assessment process include systematic analysis, prioritisation of risk treatments and their relative costs?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:30:41',	'2019-05-09 09:30:41'),
(805,	1051,	'Are the threats, vulnerabilities, risks and issues that have been identified documented within a risk / issues register or part of a risk management database?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:30:41',	'2019-05-09 09:30:41'),
(806,	1051,	'Are the BIA impacts and consequence in respect of prioritised activities used in the risk assessment process?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:30:41',	'2019-05-09 09:30:41'),
(807,	1051,	'Is a risk assessment completed by each business and operational support division within the organisation at least once every 6 (six) months and signed-off by the relevant business manager?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:30:41',	'2019-05-09 09:30:41'),
(808,	1051,	'Has a risk assessment been completed by each business and operational support division within the organisation at least once within the last 6 (six) months?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:30:41',	'2019-05-09 09:30:41'),
(809,	1051,	'Has the level and exposure (likelihood of occurrence) of prioritised activities and their dependencies to operational risk(s) in respect of threats, exposures, vulnerabilities and liabilities at an industry, geographic, regional etc level been identified, defined and documented?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:30:41',	'2019-05-09 09:30:41'),
(810,	1051,	'Have areas of high operational risk concentration (risk clusters) been identified and documented e.g. one building/site with and/or a supplier/provider of several prioritised activities their support resources and/or dependencies ?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:30:41',	'2019-05-09 09:30:41'),
(811,	1051,	'Does the risk assessment process provide a standardised risk assessment evaluation report template?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:30:41',	'2019-05-09 09:30:41'),
(812,	1051,	'Does the organisation\'s risk management process provide prioritiesed and documented action plan(s) to implement the agreed recommendations of the risk assessment evaluation report within agreed timescales?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:30:41',	'2019-05-09 09:30:41'),
(813,	1051,	'Have the preventative, loss mitigation and risk treatment measures needed to eliminate, control and/or manage the disruptive related risks in respect of each prioritised activity been identified and implemented?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:30:41',	'2019-05-09 09:30:41'),
(814,	1051,	'Have acceptable risk levels for the prioritised activities and their dependencies been established and documented?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:30:41',	'2019-05-09 09:30:41'),
(815,	1051,	'Have disruptive risk related risk treatments been evaluated for each prioritised activity their support resources and dependencies?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:30:41',	'2019-05-09 09:30:41'),
(816,	1051,	'Are risk treatments commensurate with the organisation’s business continuity objectives?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:30:41',	'2019-05-09 09:30:41'),
(817,	1051,	'Are risk treatments in accordance with the organisation’s risk appetite?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:30:41',	'2019-05-09 09:30:41'),
(818,	1051,	'Are regular reviews conducted to further prevent, minimise or eliminate the exposure of prioritised activities their support resources and dependencies to the threats and incidents identified?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:30:41',	'2019-05-09 09:30:41'),
(819,	1051,	'Are key outsourced suppliers required to have a demonstrable and effective business continuity capability and arrangements in place?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:30:41',	'2019-05-09 09:30:41'),
(820,	1051,	'Is scenario planning used as a part of the risk assessment and management process in respect of the organisation’s prioritised activities their support resources and dependencies?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:30:41',	'2019-05-09 09:30:41'),
(821,	1051,	'Have the plausible scenarios that may lead to a material impact on prioritised activities their dependencies, resources and infrastructure together with their probability of occurring been identified, defined and documented?',	NULL,	NULL,	0,	NULL,	NULL,	NULL,	'2019-05-09 09:30:41',	'2019-0