# 🤖 Starknet Bot
Бот для автоматизации действий в сети Starknet

## 🌟 Основные возможности

### 🌠 Сеть Starknet:
- **🔄 Свапы и работа с пулами:**
  - [Jediswap](https://jediswap.xyz/)
  - [mySwap](https://myswap.xyz/)
  - [10K Swap](https://10kswap.com)
- **🎨 Минтинг NFT:**
  - [Starknet.id](https://www.starknet.id/)
  - [StarkVerse](https://starkverse.art/)
- **💸 Лендинг:**
  - [zkLend](https://zklend.com/)
- **📧 Отправка почты:**
  - [Dmail](https://dmail.ai/)
- **💰 Переводы ETH:**
  - в сети Ethereum, Arbitrum, Optimism и обратно в Starknet через мост [Orbiter](https://www.orbiter.finance/)
  - в сети Ethereum, Arbitrum, Optimism и обратно в Starknet через мост [Layerswap](https://www.layerswap.io/)
  - в сеть Ethereum и из неё через официальный мост [StarkGate](https://starkgate.starknet.io/)

### 📊 Биржа OKX
- **💰 Вывод ETH** с биржи в сети Ethereum, Starknet, Arbitrum, Optimism
- **💰 Вывод ETH** с сетей Ethereum, Starknet, Arbitrum, Optimism на биржу
- **💰 Перевод ETH** с субаккаунтов на основной аккаунт

### 👛 Работа с кошельками
- **🔑 Создание кошельков** [ArgentX](https://www.argent.xyz/argent-x/) и [Braavos](https://braavos.app/)
- **🔑 Деплой кошельков** в сети Starknet

## 🛠 Особенности
Наш Starknet Bot отличается максимально гибкой настройкой! В данном боте можно настроить:
- Список действий как для всех аккаунтов сразу, так и для каждого аккаунта индивидуально
- Внесение любых модулей по желанию пользователя и настройка параметров для каждого из модулей
- Возможность генерации кошельков Braavos или ArgentX с их последующим деплоем в сети Starknet
- Возможность сохранения последнего действия и продолжения работы со следующего действия после перезапуска бота
- Возможность установки прокси для каждого аккаунта индивидуально
- Возможность использования мобильных прокси для каждого аккаунта индивидуально
- Возможность вывода средств в сети Ethereum, Starknet, Arbitrum и Optimism с биржи OKX, что значительно упрощает пополнение балансов аккаунтов
- Возможно вывода средств на субаккаунты OKX с последующим переводом ETH на основной аккаунт
- Возможность самостоятельно задать адреса серверов RPC в файле `RPC.json`
- Настройка времени ожидания между выполнениями каждого действия
- Количество повторов действия после ошибки для каждого аккаунта индивидуально
- Ограничение стоимости газа в сети Ethereum, которое прямо влияет на стоимость газа в сети Starknet

## 🚀 Установка и запуск
### ⚒ Установка зависимостей
- Для пользователей 🪟 Windows:
    1. Установите [chocholatey](https://chocolatey.org/install), введя команду, указанную на сайте в PowerShell от имени администратора
    2. Откройте терминал и выполните команду `choco install mingw`
    3. Закройте терминал
- Для пользователей 🐧 Linux:
    1. Откройте терминал и выполните команду `sudo apt install -y libgmp3-dev`
- Для пользователей 🍎 MacOS:
    1. Откройте терминал и выполните команду `brew install gmp`
    2. Для владельцев процессоров M1/M2 выполните команду ``CFLAGS=-I`brew --prefix gmp`/include LDFLAGS=-L`brew --prefix gmp`/lib``
    3. Установите [Git](https://www.atlassian.com/git/tutorials/install-git)

### 🐍 Установка Python
1. Перейдите на [официальный сайт Python](https://www.python.org/)
2. Наведя мышь на раздел "Downloads", скачайте последнюю версию 
3. Запустите установщик и обязательно поставьте галочку "Add Python to PATH"

### 🤖 Установка бота
1. На GitHub нажмите кнопку "Code" -> "Download ZIP" и разархивируйте в выбранную папку
2. Откройте терминал и перейдите в папку с ботом: `cd "path/to/bot"`, где `path/to/bot` - путь к папке с ботом
3. Выполните команду `python install_ed25519_blake2b.py`
4. Установите все необходимые библиотеки:
    - `pip install -r requirements_macos.txt` для пользователей 🍎 MacOS
    - `pip install -r requirements.txt` для пользователей 🪟 Windows и 🐧 Linux
5. Переименуйте файл `accounts_dest.xlsx` в `accounts.xlsx`
6. Настройте аккаунты и действия в файле `accounts.xlsx`
7. Запустите бота командой: `python main.py`

> 📃 **Лог о выполненных действиях**<br>
После работы программы история всех выполненных дейсвтий вместе со статусом завершения будет сохранена в файле `starknet.log` в папке с ботом

## 📋 Как настроить `accounts.xlsx`
В файле `accounts.xlsx` находятся несколько листов:
- `accounts`: аккаунты, для которых будет работать бот
- `accounts_example`: пример заполнения аккаунтов
- `tasks`: общий список действий для всех аккаунтов
- `tasks_example`: пример заполнения действий
- `tasks_description`: описание всех модулей и настроек. Здесь можно ввести желаемое значение в столбце "Необходимое значение", и в столбце "settings line" сформируется строка настроек, которую нужно вставить в столбец "settings" листа tasks.

## 📖 Описание листа `accounts`:
- **private_key**: приватный ключ аккаунта
- **address**: адрес аккаунта
- **min_sleep_time**: минимальное время ожидания между выполнениями действий (по умолчанию 1)
- **max_sleep_time**: максимальное время ожидания между выполнениями действий (по умолчанию 10)
- **max_retries**: количество повторов выполнения функции после ошибки (по умолчанию 0)
- **max_eth_gwei**: максимальная стоимость газа в сети Ethereum (по умолчанию не ограничено)
- **proxy**: прокси для аккаунта (по умолчанию не используется). Формат: `login:password@host:port`
- **mobile_proxy_changelink**: ссылка на смену мобильного прокси (по умолчанию не используется)
- **metamask_private_key**: приватный ключ аккаунта для аккаунтов в сети Ethereum и прочих. Используется в мостах
- **starknet_okx_deposit_address**: адрес суб-аккаунта OKX для пополнения баланса аккаунта в сети Starknet
- **evm_okx_deposit_address**: адрес суб-аккаунта OKX для пополнения баланса аккаунта в сетях Ethereum, Arbitrum, Optimism
- **okx_api_key**, **okx_secret_key**, **okx_passphrase**: ключи API для биржи OKX. Если не указать хотя бы одно из трёх значений, вывод работать не будет

## 🛠 Как настроить список задач
Перед настройкой списка задач рекомендуем ознакомиться с листом `tasks_description`, где описаны все модули и настройки.<br>
Далее есть 3 метода:
1. Использовать специальный [сайт](https://compich.github.io/Starknet-Bot-Web-GUI/) для генерации строк настроек для модулей (рекомендуемый способ):
   - Выберите желаемый модуль и функцию.
   - Введите параметры или оставьте их по умолчанию.
   - Нажмите "Generate Settings Line".
   - Если ошибок нет, нажмите "Copy to Clipboard".
   - После этого вставьте скопированную строку на лист `tasks`.
2. Вносить необходимые значения в столбец `G` листа `tasks_description` и в столбце `I` будет формироваться готовая строка настроек `settings`, которую нужно будет перенести на лист `tasks` в соответствующий столбец, при этом вручную написав названия модуля и фукнции
3. Писать настройки вручную по примеру с листа `tasks_example`. Этот способ не рекомендуется, так как есть высокий шанс допустить ошибку. Важно помнить, что разные параметры разделяются запятой, а значения внутри списков - пробелом

## 📋 Индивидуальные настройки для отдельных аккаунтов
Вы можете создавать индивидуальные настройки для аккаунтов, создавая листы с названиями формата `tasks_1`, где цифра - порядковый номер аккаунта из листа accounts (порядковый номер, а не строка), а лист `tasks_1` будет списком действий для самого первого записанного аккаунта.<br>
Помните, что нужно сохранять заголовки (module_name, function_name, settings) и не удалять их, иначе бот не сможет прочитать список действий.

> 📌 **Примечания** <br>
Если на листе `tasks_description` для модуля не указана функция, значит для этого модуля есть только одна основная функция<br>
Для параметров `swap_tokens`, `pool_tokens` по умолчанию используются все возможные токены. Если вы принудительно добавите в эти списки хотя бы 1 токен, будет использоваться только этот 1. Для параметра `exclude_tokens` наоборот - список пуст, но после добавления токенов в этот список даже в случае добавления таких же токенов в `approve_tokens` и прочие списковые настройки, они будут оттуда удалены ботом. Список всех возможных токенов для того или иного модуля указан на том же сайте<br>
Если вы укажете только один параметр из пар (`min/max_amount`, `min/max_amount_usd`), то этот параметр при работе бота учитываться не будет и будут использоваться проценты<br>
Если вы укажете все эти параметры, будут использоваться только параметры `min/max_amount_usd`<br>
В целом рекомендуется указывать только одну пару параметров, чтобы избежать неожиданного поведения бота.

## 🔑 Как получить ключ API для биржи OKX
1. Перейти на страницу [Ключи API](https://www.okx.com/account/my-api)
2. Нажать кнопку "Создать ключ API V5"
3. Выбрать "Торговля API", ввести любое имя (например, Starknet-Bot), ввести пасс-фразу (которую потом занести в столбец `okx_passphrase` листа `accounts`)
4. Добавить IP адрес (прокси для OKX не используется, поэтому указывайте IP-адрес, с которого будете запускать бота). Если IP-адрес не добавить, вывод средств будет невозможен
5. В разделе "Доступы" обязательно выбрать "Вывод", иначе бот не сможет выводить средства с биржи, а также "Торговля", если вы планируете использовать функцию перевода ETH с субаккаунтов на основной аккаунт OKX
6. Нажать "Подтвердить", ввести все подтверждения, и ключ будет создан
7. Добавить адреса, на которые будет совершаться вывод на странице [Книга адресов ETH](https://www.okx.com/ru/balance/withdrawal-address/eth/2) - также на ней нужно обязательно поставить галочку "Сохранить адрес как проверенный, чтобы пропустить будущую проверку"

## 👛 Как сгенерировать и задеплоить кошельки для Starknet
1. Откройте терминал и перейдите в папку с ботом: `cd "path/to/bot"`, где `path/to/bot` - путь к папке с ботом (как это делается при запуске бота)
2. Выполните команду `python create_wallets.py`
3. Введите значения, которые он будет запрашивать (тип кошельков, их количество и так далее)
4. Кошельки будут записаны в файл `wallets.csv` в папке с ботом. В нём будет 4 столбца: wallet_name (тип кошелька), mnemonic (сид-фраза), private_key (приватный ключ) и address (адрес кошелька)
5. Для того, чтобы его задеплоить, нужно добавить в список задач действие `Deploy`, указав тип кошелька (по умолчанию Braavos)

> 📌 **Примечания** <br>
> Если кошелек уже задеплоен, заново деплоиться он не будет, и ошибка не возникнет<br>
> Перед деплоем кошелька обязательно нужно пополнить баланс, так как деплой кошелька - это транзакция, на которую требуется газ<br>
> Настоятельно рекомендуется использовать на всех кошельках один и тот же тип, чтобы случайно не задеплоить кошелёк некорректно
