<?php

/*
* @package   s9e\TextFormatter
* @copyright Copyright (c) 2010-2016 The s9e Authors
* @license   http://www.opensource.org/licenses/mit-license.php The MIT License
*/
namespace s9e\TextFormatter\Plugins\MediaEmbed\Configurator;
class CachedSiteDefinitionProvider extends SiteDefinitionProvider
{
	protected $cache = array(
		'abcnews'=>'a:3:{s:4:"host";s:14:"abcnews.go.com";s:7:"extract";s:47:"!abcnews\\.go\\.com/[^/]+/video/[^/]+-(?\'id\'\\d+)!";s:6:"iframe";a:3:{s:5:"width";s:3:"640";s:6:"height";s:3:"360";s:3:"src";s:37:"//abcnews.go.com/video/embed?id={@id}";}}',
		'amazon'=>'a:3:{s:4:"host";a:8:{i:0;s:9:"amazon.ca";i:1;s:12:"amazon.co.uk";i:2;s:12:"amazon.co.jp";i:3;s:10:"amazon.com";i:4;s:9:"amazon.de";i:5;s:9:"amazon.es";i:6;s:9:"amazon.fr";i:7;s:9:"amazon.it";}s:7:"extract";a:2:{i:0;s:37:"#/(?:dp|gp/product)/(?\'id\'[A-Z0-9]+)#";i:1;s:47:"#amazon\\.(?:co\\.)?(?\'tld\'ca|de|es|fr|it|jp|uk)#";}s:6:"iframe";a:3:{s:5:"width";s:3:"120";s:6:"height";s:3:"240";s:3:"src";s:1631:"//rcm-<xsl:choose><xsl:when test="@tld=\'jp\'">fe</xsl:when><xsl:when test="@tld and contains(\'desfrituk\',@tld)">eu</xsl:when><xsl:otherwise>na</xsl:otherwise></xsl:choose>.amazon-adsystem.com/e/cm?lt1=_blank&amp;bc1=FFFFFF&amp;bg1=FFFFFF&amp;fc1=000000&amp;lc1=0000FF&amp;p=8&amp;l=as1&amp;f=ifr&amp;asins=<xsl:value-of select="@id"/>&amp;o=<xsl:choose><xsl:when test="@tld=\'ca\'">15</xsl:when><xsl:when test="@tld=\'de\'">3</xsl:when><xsl:when test="@tld=\'es\'">30</xsl:when><xsl:when test="@tld=\'fr\'">8</xsl:when><xsl:when test="@tld=\'it\'">29</xsl:when><xsl:when test="@tld=\'jp\'">9</xsl:when><xsl:when test="@tld=\'uk\'">2</xsl:when><xsl:otherwise>1</xsl:otherwise></xsl:choose>&amp;t=<xsl:choose><xsl:when test="@tld=\'ca\'and$AMAZON_ASSOCIATE_TAG_CA"><xsl:value-of select="$AMAZON_ASSOCIATE_TAG_CA"/></xsl:when><xsl:when test="@tld=\'de\'and$AMAZON_ASSOCIATE_TAG_DE"><xsl:value-of select="$AMAZON_ASSOCIATE_TAG_DE"/></xsl:when><xsl:when test="@tld=\'es\'and$AMAZON_ASSOCIATE_TAG_ES"><xsl:value-of select="$AMAZON_ASSOCIATE_TAG_ES"/></xsl:when><xsl:when test="@tld=\'fr\'and$AMAZON_ASSOCIATE_TAG_FR"><xsl:value-of select="$AMAZON_ASSOCIATE_TAG_FR"/></xsl:when><xsl:when test="@tld=\'it\'and$AMAZON_ASSOCIATE_TAG_IT"><xsl:value-of select="$AMAZON_ASSOCIATE_TAG_IT"/></xsl:when><xsl:when test="@tld=\'jp\'and$AMAZON_ASSOCIATE_TAG_JP"><xsl:value-of select="$AMAZON_ASSOCIATE_TAG_JP"/></xsl:when><xsl:when test="@tld=\'uk\'and$AMAZON_ASSOCIATE_TAG_UK"><xsl:value-of select="$AMAZON_ASSOCIATE_TAG_UK"/></xsl:when><xsl:when test="$AMAZON_ASSOCIATE_TAG"><xsl:value-of select="$AMAZON_ASSOCIATE_TAG"/></xsl:when><xsl:otherwise>_</xsl:otherwise></xsl:choose>";}}',
		'audioboom'=>'a:3:{s:4:"host";a:2:{i:0;s:11:"audioboo.fm";i:1;s:13:"audioboom.com";}s:7:"extract";s:40:"!audioboo(?:\\.f|m\\.co)m/boos/(?\'id\'\\d+)!";s:6:"iframe";a:4:{s:5:"width";s:4:"100%";s:6:"height";s:3:"150";s:9:"max-width";s:3:"700";s:3:"src";s:35:"//audioboom.com/boos/{@id}/embed/v3";}}',
		'audiomack'=>'a:3:{s:4:"host";s:13:"audiomack.com";s:7:"extract";s:57:"!audiomack\\.com/(?\'mode\'album|song)/(?\'id\'[-\\w]+/[-\\w]+)!";s:6:"choose";a:2:{s:4:"when";a:2:{s:4:"test";s:13:"@mode=\'album\'";s:6:"iframe";a:4:{s:5:"width";s:4:"100%";s:6:"height";s:3:"340";s:9:"max-width";s:3:"900";s:3:"src";s:38:"//www.audiomack.com/embed4-album/{@id}";}}s:9:"otherwise";a:1:{s:6:"iframe";a:4:{s:5:"width";s:4:"100%";s:6:"height";s:3:"110";s:9:"max-width";s:3:"900";s:3:"src";s:32:"//www.audiomack.com/embed4/{@id}";}}}}',
		'bandcamp'=>'a:3:{s:4:"host";s:12:"bandcamp.com";s:6:"scrape";a:2:{i:0;a:2:{s:5:"match";s:23:"!bandcamp\\.com/album/.!";s:7:"extract";s:25:"!/album=(?\'album_id\'\\d+)!";}i:1;a:2:{s:5:"match";s:23:"!bandcamp\\.com/track/.!";s:7:"extract";a:3:{i:0;s:29:"!"album_id":(?\'album_id\'\\d+)!";i:1;s:31:"!"track_num":(?\'track_num\'\\d+)!";i:2;s:25:"!/track=(?\'track_id\'\\d+)!";}}}s:6:"iframe";a:3:{s:5:"width";s:3:"400";s:6:"height";s:3:"400";s:3:"src";s:301:"//bandcamp.com/EmbeddedPlayer/size=large/minimal=true/<xsl:choose><xsl:when test="@album_id">album=<xsl:value-of select="@album_id"/><xsl:if test="@track_num">/t=<xsl:value-of select="@track_num"/></xsl:if></xsl:when><xsl:otherwise>track=<xsl:value-of select="@track_id"/></xsl:otherwise></xsl:choose>";}}',
		'bbcnews'=>'a:3:{s:4:"host";s:7:"bbc.com";s:6:"scrape";a:2:{s:5:"match";s:19:"!bbc\\.com/news/\\w+!";s:7:"extract";s:124:"!meta name="twitter:player".*?playlist=(?\'playlist\'[-/\\w]+)(?:&poster=(?\'poster\'[-/.\\w]+))?(?:&ad_site=(?\'ad_site\'[/\\w]+))?!";}s:6:"iframe";a:1:{s:3:"src";s:128:"https://ssl.bbc.co.uk/wwscripts/embed_player#playlist={@playlist}&poster={@poster}&ad_site={@ad_site}&ad_keyword=&source=twitter";}}',
		'blab'=>'a:3:{s:4:"host";s:7:"blab.im";s:7:"extract";s:68:"#blab\\.im/(?!about$|live$|replay$|scheduled$|search\\?)(?\'id\'[-\\w]+)#";s:6:"iframe";a:3:{s:5:"width";s:3:"400";s:6:"height";s:3:"400";s:3:"src";s:21:"https://blab.im/{@id}";}}',
		'bleacherreport'=>'a:3:{s:4:"host";s:18:"bleacherreport.com";s:6:"scrape";a:2:{s:5:"match";s:13:"!/articles/.!";s:7:"extract";s:25:"!id="video-(?\'id\'[-\\w]+)!";}s:6:"iframe";a:3:{s:5:"width";s:3:"640";s:6:"height";s:3:"360";s:3:"src";s:41:"//bleacherreport.com/video_embed?id={@id}";}}',
		'break'=>'a:3:{s:4:"host";s:9:"break.com";s:7:"extract";s:33:"!break\\.com/video/.*-(?\'id\'\\d+)$!";s:6:"iframe";a:3:{s:5:"width";s:3:"464";s:6:"height";s:3:"280";s:3:"src";s:23:"//break.com/embed/{@id}";}}',
		'cbsnews'=>'a:5:{s:4:"host";s:11:"cbsnews.com";s:7:"extract";s:42:"#cbsnews\\.com/video/watch/\\?id=(?\'id\'\\d+)#";s:6:"scrape";a:2:{s:5:"match";s:32:"#cbsnews\\.com/videos/(?!watch/)#";s:7:"extract";s:21:"#"pid":"(?\'pid\'\\w+)"#";}s:10:"attributes";a:1:{s:2:"id";a:1:{s:8:"required";s:5:"false";}}s:6:"choose";a:2:{s:4:"when";a:2:{s:4:"test";s:4:"@pid";s:5:"flash";a:3:{s:14:"padding-height";s:2:"38";s:3:"src";s:49:"//www.cbsnews.com/common/video/cbsnews_player.swf";s:9:"flashvars";s:29:"pType=embed&si=254&pid={@pid}";}}s:9:"otherwise";a:1:{s:5:"flash";a:3:{s:14:"padding-height";s:2:"40";s:3:"src";s:74:"//i.i.cbsi.com/cnwk.1d/av/video/cbsnews/atlantis2/cbsnews_player_embed.swf";s:9:"flashvars";s:25:"si=254&contentValue={@id}";}}}}',
		'cnbc'=>'a:3:{s:4:"host";s:14:"video.cnbc.com";s:7:"extract";s:38:"!cnbc\\.com/gallery/\\?video=(?\'id\'\\d+)!";s:5:"flash";a:3:{s:5:"width";s:3:"400";s:6:"height";s:3:"380";s:3:"src";s:74:"//plus.cnbc.com/rssvideosearch/action/player/id/{@id}/code/cnbcplayershare";}}',
		'cnn'=>'a:3:{s:4:"host";s:7:"cnn.com";s:7:"extract";a:2:{i:0;s:31:"!cnn.com/videos/(?\'id\'.*\\.cnn)!";i:1;s:47:"!cnn\\.com/video/data/2\\.0/video/(?\'id\'.*\\.cnn)!";}s:6:"iframe";a:1:{s:3:"src";s:56:"http://edition.cnn.com/video/api/embed.html#/video/{@id}";}}',
		'cnnmoney'=>'a:3:{s:4:"host";s:13:"money.cnn.com";s:7:"extract";s:43:"!money\\.cnn\\.com/video/(?\'id\'.*\\.cnnmoney)!";s:6:"iframe";a:3:{s:5:"width";s:3:"560";s:6:"height";s:3:"360";s:3:"src";s:110:"http://money.cnn.com/.element/ssi/video/7.0/players/embed.player.html?videoid=video/{@id}&width=560&height=360";}}',
		'collegehumor'=>'a:3:{s:4:"host";s:16:"collegehumor.com";s:7:"extract";s:46:"!collegehumor\\.com/(?:video|embed)/(?\'id\'\\d+)!";s:6:"iframe";a:3:{s:5:"width";s:3:"600";s:6:"height";s:3:"369";s:3:"src";s:30:"//www.collegehumor.com/e/{@id}";}}',
		'comedycentral'=>'a:3:{s:4:"host";a:2:{i:0;s:6:"cc.com";i:1;s:17:"comedycentral.com";}s:6:"scrape";a:2:{s:5:"match";s:56:"!c(?:c|omedycentral)\\.com/(?:full-episode|video-clip)s/!";s:7:"extract";s:35:"!(?\'id\'mgid:arc:\\w+:[.\\w]+:[-\\w]+)!";}s:6:"iframe";a:3:{s:5:"width";s:3:"640";s:6:"height";s:3:"360";s:3:"src";s:36:"//media.mtvnservices.com/embed/{@id}";}}',
		'coub'=>'a:3:{s:4:"host";s:8:"coub.com";s:7:"extract";s:27:"!coub\\.com/view/(?\'id\'\\w+)!";s:6:"iframe";a:1:{s:3:"src";s:22:"//coub.com/embed/{@id}";}}',
		'dailymotion'=>'a:3:{s:4:"host";s:15:"dailymotion.com";s:7:"extract";s:72:"!dailymotion\\.com/(?:live/|user/[^#]+#video=|video/)(?\'id\'[A-Za-z0-9]+)!";s:6:"iframe";a:1:{s:3:"src";s:39:"//www.dailymotion.com/embed/video/{@id}";}}',
		'democracynow'=>'a:4:{s:4:"host";s:16:"democracynow.org";s:7:"extract";s:66:"!democracynow.org/(?:embed/)?(?\'id\'(?:\\w+/)?\\d+/\\d+/\\d+(?:/\\w+)?)!";s:6:"scrape";a:2:{s:5:"match";s:33:"!m\\.democracynow\\.org/stories/\\d!";s:7:"extract";s:72:"!democracynow\\.org/(?\'id\'(?:\\w+/)?\\d+/\\d+/\\d+(?:/\\w+)?)\' rel=\'canonical!";}s:6:"iframe";a:3:{s:5:"width";s:3:"640";s:6:"height";s:3:"360";s:3:"src";s:428:"//www.democracynow.org/embed/<xsl:choose><xsl:when test="contains(@id,\'/headlines\')">headlines/<xsl:value-of select="substring-before(@id,\'/headlines\')"/></xsl:when><xsl:when test="starts-with(@id,\'2\')">story/<xsl:value-of select="@id"/></xsl:when><xsl:when test="starts-with(@id,\'shows/\')">show/<xsl:value-of select="substring-after(@id,\'/\')"/></xsl:when><xsl:otherwise><xsl:value-of select="@id"/></xsl:otherwise></xsl:choose>";}}',
		'dumpert'=>'a:3:{s:4:"host";s:10:"dumpert.nl";s:6:"scrape";a:2:{s:5:"match";s:31:"!dumpert\\.nl/mediabase/\\d+/\\w+!";s:7:"extract";s:25:"!data-itemid="(?\'id\'\\w+)!";}s:6:"iframe";a:1:{s:3:"src";s:53:"http://www.dumpert.nl/embed/{translate(@id,\'_\',\'/\')}/";}}',
		'eighttracks'=>'a:4:{s:4:"host";s:11:"8tracks.com";s:7:"extract";s:39:"!8tracks\\.com/[-\\w]+/(?\'id\'\\d+)(?=#|$)!";s:6:"scrape";a:2:{s:5:"match";s:28:"!8tracks\\.com/[-\\w]+/[-\\w]+!";s:7:"extract";s:30:"!eighttracks://mix/(?\'id\'\\d+)!";}s:6:"iframe";a:3:{s:5:"width";s:3:"400";s:6:"height";s:3:"400";s:3:"src";s:45:"//8tracks.com/mixes/{@id}/player_v3_universal";}}',
		'espn'=>'a:3:{s:4:"host";s:11:"espn.go.com";s:7:"extract";s:86:"#(?\'cms\'deportes|espn(?!d)).*(?:clip\\?|video\\?v|clipDeportes\\?)id=(?:\\w+:)?(?\'id\'\\d+)#";s:6:"iframe";a:1:{s:3:"src";s:61:"https://espn.go.com/video/iframe/twitter/?cms={@cms}&id={@id}";}}',
		'facebook'=>'a:3:{s:4:"host";s:12:"facebook.com";s:7:"extract";s:135:"@/(?!(?:apps|developers|graph)\\.)[-\\w.]*facebook\\.com/(?:[/\\w]+/permalink|(?!pages/|groups/).*?)(?:/|fbid=|\\?v=)(?\'id\'\\d+)(?=$|[/?&#])@";s:6:"iframe";a:2:{s:3:"src";s:52:"https://s9e.github.io/iframe/facebook.min.html#{@id}";s:6:"onload";s:177:"var a=Math.random();window.addEventListener(\'message\',function(b){{if(b.data.id==a)style.height=b.data.height+\'px\'}});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')";}}',
		'flickr'=>'a:3:{s:4:"host";s:10:"flickr.com";s:7:"extract";s:37:"!flickr\\.com/photos/[^/]+/(?\'id\'\\d+)!";s:6:"iframe";a:3:{s:5:"width";s:3:"500";s:6:"height";s:3:"500";s:3:"src";s:45:"https://www.flickr.com/photos/_/{@id}/player/";}}',
		'foxnews'=>'a:3:{s:4:"host";s:17:"video.foxnews.com";s:7:"extract";s:34:"!video\\.foxnews\\.com/v/(?\'id\'\\d+)!";s:6:"iframe";a:1:{s:3:"src";s:53:"//video.foxnews.com/v/video-embed.html?video_id={@id}";}}',
		'funnyordie'=>'a:3:{s:4:"host";s:14:"funnyordie.com";s:7:"extract";s:41:"!funnyordie\\.com/videos/(?\'id\'[0-9a-f]+)!";s:6:"iframe";a:3:{s:5:"width";s:3:"640";s:6:"height";s:3:"360";s:3:"src";s:37:"http://www.funnyordie.com/embed/{@id}";}}',
		'gamespot'=>'a:3:{s:4:"host";s:12:"gamespot.com";s:7:"extract";s:64:"!gamespot\\.com.*?/(?:events|videos)/.*?-(?\'id\'\\d+)/(?:[#?].*)?$!";s:6:"iframe";a:3:{s:5:"width";s:3:"640";s:6:"height";s:3:"400";s:3:"src";s:38:"//www.gamespot.com/videos/embed/{@id}/";}}',
		'gametrailers'=>'a:3:{s:4:"host";s:16:"gametrailers.com";s:6:"scrape";a:2:{s:5:"match";s:51:"!gametrailers\\.com/(?:full-episode|review|video)s/!";s:7:"extract";s:18:"!embed/(?\'id\'\\d+)!";}s:6:"iframe";a:3:{s:5:"width";s:3:"640";s:6:"height";s:3:"360";s:3:"src";s:256:"<xsl:choose><xsl:when test="starts-with(@id,\'mgid:\')">//media.mtvnservices.com/embed/<xsl:value-of select="@id"/></xsl:when><xsl:otherwise>//embed.gametrailers.com/embed/<xsl:value-of select="@id"/>?embed=1&amp;suppressBumper=1</xsl:otherwise></xsl:choose>";}}',
		'getty'=>'a:4:{s:4:"host";a:16:{i:0;s:14:"gettyimages.be";i:1;s:14:"gettyimages.cn";i:2;s:17:"gettyimages.co.jp";i:3;s:17:"gettyimages.co.uk";i:4;s:15:"gettyimages.com";i:5;s:18:"gettyimages.com.au";i:6;s:14:"gettyimages.de";i:7;s:14:"gettyimages.dk";i:8;s:14:"gettyimages.es";i:9;s:14:"gettyimages.fr";i:10;s:14:"gettyimages.ie";i:11;s:14:"gettyimages.it";i:12;s:14:"gettyimages.nl";i:13;s:14:"gettyimages.pt";i:14;s:14:"gettyimages.se";i:15;s:6:"gty.im";}s:7:"extract";a:2:{i:0;s:20:"!gty\\.im/(?\'id\'\\d+)!";i:1;s:47:"!gettyimages\\.[.\\w]+/detail(?=/).*?/(?\'id\'\\d+)!";}s:6:"scrape";a:2:{s:3:"url";s:42:"http://embed.gettyimages.com/preview/{@id}";s:7:"extract";a:4:{i:0;s:30:"!"height":[ "]*(?\'height\'\\d+)!";i:1;s:28:"!"width":[ "]*(?\'width\'\\d+)!";i:2;s:19:"!et=(?\'et\'[-=\\w]+)!";i:3;s:21:"!sig=(?\'sig\'[-=\\w]+)!";}}s:6:"iframe";a:4:{s:5:"width";s:8:"{@width}";s:6:"height";s:9:"{@height}";s:14:"padding-height";s:2:"49";s:3:"src";s:55:"//embed.gettyimages.com/embed/{@id}?et={@et}&sig={@sig}";}}',
		'gfycat'=>'a:5:{s:10:"attributes";a:2:{s:6:"height";a:1:{s:12:"defaultValue";s:3:"315";}s:5:"width";a:1:{s:12:"defaultValue";s:3:"560";}}s:4:"host";s:10:"gfycat.com";s:7:"extract";s:24:"!gfycat\\.com/(?\'id\'\\w+)!";s:6:"scrape";a:2:{s:3:"url";s:23:"http://gfycat.com/{@id}";s:7:"extract";a:2:{i:0;s:34:"!gfyHeight\\s*=\\s*"?(?\'height\'\\d+)!";i:1;s:32:"!gfyWidth\\s*=\\s*"?(?\'width\'\\d+)!";}}s:6:"iframe";a:3:{s:5:"width";s:8:"{@width}";s:6:"height";s:9:"{@height}";s:3:"src";s:25:"//gfycat.com/iframe/{@id}";}}',
		'gist'=>'a:3:{s:4:"host";s:10:"github.com";s:7:"extract";s:58:"!gist\\.github\\.com/(?\'id\'(?:\\w+/)?[\\da-f]+(?:/[\\da-f]+)?)!";s:6:"iframe";a:4:{s:5:"width";s:4:"100%";s:6:"height";s:3:"180";s:3:"src";s:48:"https://s9e.github.io/iframe/gist.min.html#{@id}";s:6:"onload";s:177:"var a=Math.random();window.addEventListener(\'message\',function(b){{if(b.data.id==a)style.height=b.data.height+\'px\'}});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')";}}',
		'globalnews'=>'a:3:{s:4:"host";s:13:"globalnews.ca";s:7:"extract";s:33:"!globalnews\\.ca/video/(?\'id\'\\d+)!";s:6:"iframe";a:3:{s:5:"width";s:3:"560";s:6:"height";s:3:"377";s:3:"src";s:39:"http://globalnews.ca/video/embed/{@id}/";}}',
		'gofundme'=>'a:3:{s:4:"host";s:12:"gofundme.com";s:7:"extract";s:35:"@gofundme\\.com/(?\'id\'\\w+)(?![^#?])@";s:5:"flash";a:4:{s:5:"width";s:3:"258";s:6:"height";s:3:"338";s:3:"src";s:35:"//funds.gofundme.com/Widgetflex.swf";s:9:"flashvars";s:10:"page={@id}";}}',
		'googledrive'=>'a:3:{s:4:"host";s:16:"drive.google.com";s:7:"extract";s:41:"!drive\\.google\\.com/file/d/(?\'id\'[-\\w]+)!";s:6:"iframe";a:3:{s:5:"width";s:3:"640";s:6:"height";s:3:"480";s:3:"src";s:39:"//drive.google.com/file/d/{@id}/preview";}}',
		'googleplus'=>'a:3:{s:4:"host";s:15:"plus.google.com";s:7:"extract";s:81:"!//plus\\.google\\.com/(?:u/\\d+/)?(?:\\+(?\'name\'\\w+)|(?\'oid\'\\d+))/posts/(?\'pid\'\\w+)!";s:6:"iframe";a:4:{s:5:"width";s:3:"450";s:6:"height";s:3:"240";s:6:"onload";s:177:"var a=Math.random();window.addEventListener(\'message\',function(b){{if(b.data.id==a)style.height=b.data.height+\'px\'}});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')";s:3:"src";s:234:"https://s9e.github.io/iframe/googleplus.min.html#<xsl:choose><xsl:when test="@oid"><xsl:value-of select="@oid"/></xsl:when><xsl:otherwise>+<xsl:value-of select="@name"/></xsl:otherwise></xsl:choose>/posts/<xsl:value-of select="@pid"/>";}}',
		'googlesheets'=>'a:3:{s:4:"host";s:15:"docs.google.com";s:7:"extract";s:89:"!docs\\.google\\.com/spreadsheet(?:/ccc\\?key=|s/d/)(?\'id\'[-\\w]+)[^#]*(?:#gid=(?\'gid\'\\d+))?!";s:6:"iframe";a:4:{s:5:"width";s:4:"100%";s:6:"height";s:3:"500";s:3:"src";s:97:"https://docs.google.com/spreadsheet/ccc?key={@id}&widget=true&headers=false&rm=minimal#gid={@gid}";s:5:"style";a:1:{s:6:"resize";s:8:"vertical";}}}',
		'hudl'=>'a:4:{s:4:"host";s:8:"hudl.com";s:7:"extract";s:64:"!hudl\\.com/athlete/(?\'athlete\'\\d+)/highlights/(?\'highlight\'\\d+)!";s:6:"scrape";a:2:{s:5:"match";s:14:"!hudl\\.com/v/!";s:7:"extract";s:64:"!hudl\\.com/athlete/(?\'athlete\'\\d+)/highlights/(?\'highlight\'\\d+)!";}s:6:"iframe";a:3:{s:5:"width";s:3:"640";s:6:"height";s:3:"360";s:3:"src";s:63:"//www.hudl.com/embed/athlete/{@athlete}/highlights/{@highlight}";}}',
		'hulu'=>'a:3:{s:4:"host";s:8:"hulu.com";s:6:"scrape";a:2:{s:5:"match";s:18:"!hulu\\.com/watch/!";s:7:"extract";s:19:"!eid=(?\'id\'[-\\w]+)!";}s:6:"iframe";a:3:{s:5:"width";s:3:"640";s:6:"height";s:3:"360";s:3:"src";s:35:"https://secure.hulu.com/embed/{@id}";}}',
		'humortvnl'=>'a:3:{s:4:"host";s:15:"humortv.vara.nl";s:7:"extract";s:45:"!humortv\\.vara\\.nl/\\w+\\.(?\'id\'[-.\\w]+)\\.html!";s:6:"iframe";a:1:{s:3:"src";s:39:"http://humortv.vara.nl/embed.{@id}.html";}}',
		'ign'=>'a:3:{s:4:"host";s:7:"ign.com";s:7:"extract";s:39:"!(?\'id\'https?://.*?ign\\.com/videos/.+)!";s:6:"iframe";a:3:{s:5:"width";s:3:"468";s:6:"height";s:3:"263";s:3:"src";s:57:"http://widgets.ign.com/video/embed/content.html?url={@id}";}}',
		'imdb'=>'a:3:{s:4:"host";s:8:"imdb.com";s:7:"extract";s:34:"!imdb\\.com/video/\\w+/vi(?\'id\'\\d+)!";s:6:"iframe";a:1:{s:3:"src";s:69:"//www.imdb.com/video/imdb/vi{@id}/imdb/embed?autoplay=false&width=560";}}',
		'imgur'=>'a:5:{s:10:"attributes";a:1:{s:4:"type";a:1:{s:4:"type";s:5:"alnum";}}s:4:"host";s:9:"imgur.com";s:7:"extract";s:62:"@imgur\\.com/(?:gallery/)?(?\'id\'(?:a/)?\\w+)(?!\\w|\\.(?:pn|jp)g)@";s:6:"scrape";a:2:{i:0;a:2:{s:5:"match";s:29:"!imgur\\.com/(?:a|gallery)/\\w!";s:7:"extract";a:3:{i:0;s:41:"!image\\s*:\\s*.*?"is_(?\'type\'album)":true!";i:1;s:26:"!<div id="(?\'type\'album)-!";i:2;s:29:"!class="(?\'type\'album)-image!";}}i:1;a:3:{s:3:"url";s:29:"http://i.imgur.com/{@id}.gifv";s:5:"match";s:35:"!imgur\\.com/\\w+\\.(?:gifv|mp4|webm)!";s:7:"extract";a:3:{i:0;s:24:"!width:\\s*(?\'width\'\\d+)!";i:1;s:26:"!height:\\s*(?\'height\'\\d+)!";i:2;s:15:"!(?\'type\'gifv)!";}}}s:6:"choose";a:2:{s:4:"when";a:2:{i:0;a:2:{s:4:"test";s:22:"starts-with(@id, \'a/\')";s:6:"iframe";a:3:{s:5:"width";s:4:"100%";s:6:"height";s:3:"550";s:3:"src";s:23:"//imgur.com/{@id}/embed";}}i:1;a:2:{s:4:"test";s:13:"@type=\'album\'";s:6:"iframe";a:3:{s:5:"width";s:4:"100%";s:6:"height";s:3:"550";s:3:"src";s:25:"//imgur.com/a/{@id}/embed";}}}s:9:"otherwise";a:1:{s:6:"iframe";a:4:{s:5:"width";s:4:"100%";s:6:"height";s:3:"550";s:3:"src";s:49:"https://s9e.github.io/iframe/imgur.min.html#{@id}";s:6:"onload";s:207:"var b=Math.random();window.addEventListener(\'message\',function(a){{a.data.id==b&&(style.height=a.data.height+\'px\',style.width=a.data.width+\'px\')}});contentWindow.postMessage(\'s9e:\'+b,\'https://s9e.github.io\')";}}}}',
		'indiegogo'=>'a:3:{s:4:"host";s:13:"indiegogo.com";s:7:"extract";s:39:"!indiegogo\\.com/projects/(?\'id\'[-\\w]+)!";s:6:"iframe";a:3:{s:5:"width";s:3:"222";s:6:"height";s:3:"445";s:3:"src";s:42:"//www.indiegogo.com/project/{@id}/embedded";}}',
		'instagram'=>'a:3:{s:4:"host";s:13:"instagram.com";s:7:"extract";s:32:"!instagram\\.com/p/(?\'id\'[-\\w]+)!";s:6:"iframe";a:4:{s:5:"width";s:3:"640";s:6:"height";s:3:"640";s:3:"src";s:53:"https://s9e.github.io/iframe/instagram.min.html#{@id}";s:6:"onload";s:177:"var a=Math.random();window.addEventListener(\'message\',function(b){{if(b.data.id==a)style.height=b.data.height+\'px\'}});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')";}}',
		'internetarchive'=>'a:3:{s:4:"host";s:11:"archive.org";s:6:"scrape";a:2:{s:5:"match";s:23:"!archive\\.org/details/!";s:7:"extract";a:3:{i:0;s:81:"!meta property="twitter:player" content="https://archive.org/embed/(?\'id\'[^/"]+)!";i:1;s:55:"!meta property="og:video:width" content="(?\'width\'\\d+)!";i:2;s:57:"!meta property="og:video:height" content="(?\'height\'\\d+)!";}}s:6:"iframe";a:3:{s:5:"width";s:8:"{@width}";s:6:"height";s:9:"{@height}";s:3:"src";s:31:"https://archive.org/embed/{@id}";}}',
		'izlesene'=>'a:3:{s:4:"host";s:12:"izlesene.com";s:7:"extract";s:39:"!izlesene\\.com/video/[-\\w]+/(?\'id\'\\d+)!";s:6:"iframe";a:1:{s:3:"src";s:36:"//www.izlesene.com/embedplayer/{@id}";}}',
		'khl'=>'a:3:{s:4:"host";s:12:"video.khl.ru";s:6:"scrape";a:2:{s:5:"match";s:36:"!video\\.khl\\.ru/(?:event|quote)s/\\d!";s:7:"extract";s:27:"!/feed/start/(?\'id\'[/\\w]+)!";}s:6:"iframe";a:1:{s:3:"src";s:70:"//video.khl.ru/iframe/feed/start/{@id}?type_id=18&width=560&height=315";}}',
		'kickstarter'=>'a:3:{s:4:"host";s:15:"kickstarter.com";s:7:"extract";s:93:"!kickstarter\\.com/projects/(?\'id\'[^/]+/[^/?]+)(?:/widget/(?:(?\'card\'card)|(?\'video\'video)))?!";s:6:"choose";a:2:{s:4:"when";a:2:{s:4:"test";s:6:"@video";s:6:"iframe";a:3:{s:5:"width";s:3:"480";s:6:"height";s:3:"360";s:3:"src";s:54:"//www.kickstarter.com/projects/{@id}/widget/video.html";}}s:9:"otherwise";a:1:{s:6:"iframe";a:3:{s:5:"width";s:3:"220";s:6:"height";s:3:"420";s:3:"src";s:53:"//www.kickstarter.com/projects/{@id}/widget/card.html";}}}}',
		'kissvideo'=>'a:3:{s:4:"host";s:15:"kissvideo.click";s:7:"extract";s:41:"!kissvideo\\.click/[^_]*_(?\'id\'[0-9a-f]+)!";s:6:"iframe";a:3:{s:5:"width";s:3:"640";s:6:"height";s:3:"360";s:3:"src";s:41:"//www.kissvideo.click/embed.php?vid={@id}";}}',
		'libsyn'=>'a:3:{s:4:"host";s:10:"libsyn.com";s:6:"scrape";a:2:{s:5:"match";s:16:"@(?!\\.mp3)....$@";s:7:"extract";s:29:"!embed/episode/id/(?\'id\'\\d+)!";}s:6:"iframe";a:4:{s:5:"width";s:4:"100%";s:6:"height";s:2:"45";s:9:"max-width";s:3:"900";s:3:"src";s:159:"//html5-player.libsyn.com/embed/episode/id/{@id}/height/45/width/900/theme/standard/direction/no/autoplay/no/autonext/no/thumbnail/no/preload/no/no_addthis/no/";}}',
		'liveleak'=>'a:3:{s:4:"host";s:12:"liveleak.com";s:7:"extract";s:41:"!liveleak\\.com/view\\?i=(?\'id\'[a-f_0-9]+)!";s:6:"iframe";a:3:{s:5:"width";s:3:"640";s:6:"height";s:3:"360";s:3:"src";s:40:"http://www.liveleak.com/ll_embed?i={@id}";}}',
		'livestream'=>'a:4:{s:4:"host";s:14:"livestream.com";s:7:"extract";a:2:{i:0;s:69:"!livestream\\.com/accounts/(?\'account_id\'\\d+)/events/(?\'event_id\'\\d+)!";i:1;s:26:"!/videos/(?\'video_id\'\\d+)!";}s:6:"scrape";a:1:{s:7:"extract";s:53:"!accounts/(?\'account_id\'\\d+)/events/(?\'event_id\'\\d+)!";}s:6:"iframe";a:3:{s:5:"width";s:3:"640";s:6:"height";s:3:"360";s:3:"src";s:206:"//new.livestream.com/accounts/<xsl:value-of select="@account_id"/>/events/<xsl:value-of select="@event_id"/><xsl:if test="@video_id">/videos/<xsl:value-of select="@video_id"/></xsl:if>/player?autoPlay=false";}}',
		'mailru'=>'a:3:{s:4:"host";s:10:"my.mail.ru";s:6:"scrape";a:2:{s:5:"match";s:35:"!my\\.mail\\.ru/\\w+/\\w+/video/\\w+/\\d!";s:7:"extract";s:36:"!mail\\.ru/video/(?\'id\'[/\\w]+)\\.html!";}s:6:"iframe";a:3:{s:5:"width";s:3:"560";s:6:"height";s:3:"342";s:3:"src";s:50:"http://videoapi.my.mail.ru/videos/embed/{@id}.html";}}',
		'medium'=>'a:3:{s:4:"host";s:10:"medium.com";s:7:"extract";s:47:"!medium\\.com/[^/]*/(?:[-\\w]+-)?(?\'id\'[\\da-f]+)!";s:6:"iframe";a:5:{s:5:"width";s:3:"400";s:6:"height";s:3:"400";s:3:"src";s:94:"https://api.medium.com/embed?type=story&path=%2F%2F{@id}&id={translate(@id,\'abcdef\',\'111111\')}";s:6:"onload";s:134:"window.addEventListener(\'message\',function(a){{a=a.data.split(\'::\');\'m\'===a[0]&&0<src.indexOf(a[1])&&a[2]&&(style.height=a[2]+\'px\')}})";s:5:"style";a:4:{s:6:"border";s:9:"1px solid";s:12:"border-color";s:14:"#eee #ddd #bbb";s:13:"border-radius";s:3:"5px";s:10:"box-shadow";s:25:"rgba(0,0,0,.15) 0 1px 3px";}}}',
		'metacafe'=>'a:3:{s:4:"host";s:12:"metacafe.com";s:7:"extract";s:32:"!metacafe\\.com/watch/(?\'id\'\\d+)!";s:6:"iframe";a:1:{s:3:"src";s:31:"//www.metacafe.com/embed/{@id}/";}}',
		'mixcloud'=>'a:4:{s:4:"host";s:12:"mixcloud.com";s:7:"extract";s:55:"@mixcloud\\.com/(?!categories|tag)(?\'id\'[-\\w]+/[^/&]+)/@";s:6:"scrape";a:2:{s:5:"match";s:25:"@//i\\.mixcloud\\.com/\\w+$@";s:7:"extract";s:65:"@link rel="canonical" href="https?://[^/]+/(?\'id\'[-\\w]+/[^/&]+)/@";}s:6:"iframe";a:3:{s:5:"width";s:3:"400";s:6:"height";s:3:"400";s:3:"src";s:106:"//www.mixcloud.com/widget/iframe/?feed=http%3A%2F%2Fwww.mixcloud.com%2F{@id}%2F&embed_type=widget_standard";}}',
		'msnbc'=>'a:3:{s:4:"host";s:9:"msnbc.com";s:6:"scrape";a:2:{s:5:"match";a:2:{i:0;s:26:"@msnbc\\.com/[-\\w]+/watch/@";i:1;s:18:"@on\\.msnbc\\.com/.@";}s:7:"extract";s:19:"@guid="?(?\'id\'\\w+)@";}s:6:"iframe";a:3:{s:5:"width";s:3:"635";s:6:"height";s:3:"440";s:3:"src";s:60:"//player.theplatform.com/p/2E2eJC/EmbeddedOffSite?guid={@id}";}}',
		'natgeochannel'=>'a:3:{s:4:"host";s:30:"channel.nationalgeographic.com";s:7:"extract";s:63:"@channel\\.nationalgeographic\\.com/(?\'id\'[-/\\w]+/videos/[-\\w]+)@";s:6:"iframe";a:1:{s:3:"src";s:45:"//channel.nationalgeographic.com/{@id}/embed/";}}',
		'natgeovideo'=>'a:3:{s:4:"host";s:28:"video.nationalgeographic.com";s:6:"scrape";a:2:{s:5:"match";s:48:"@video\\.nationalgeographic\\.com/(?:tv|video)/\\w@";s:7:"extract";s:22:"@guid="(?\'id\'[-\\w]+)"@";}s:6:"iframe";a:1:{s:3:"src";s:68:"//player.d.nationalgeographic.com/players/ngsvideo/share/?guid={@id}";}}',
		'nhl'=>'a:3:{s:4:"host";s:7:"nhl.com";s:7:"extract";s:44:"!nhl\\.com/videocenter/.*?\\Wid=(?\'id\'[-\\w]+)!";s:6:"iframe";a:3:{s:5:"width";s:3:"640";s:6:"height";s:3:"395";s:3:"src";s:48:"//video.nhl.com/videocenter/embed?playlist={@id}";}}',
		'npr'=>'a:3:{s:4:"host";a:2:{i:0;s:7:"npr.org";i:1;s:4:"n.pr";}s:6:"scrape";a:2:{s:5:"match";a:2:{i:0;s:21:"!npr\\.org/[/\\w]+/\\d+!";i:1;s:10:"!n\\.pr/\\w!";}s:7:"extract";s:34:"!player/embed/(?\'i\'\\d+)/(?\'m\'\\d+)!";}s:6:"iframe";a:4:{s:5:"width";s:4:"100%";s:6:"height";s:3:"228";s:9:"max-width";s:3:"800";s:3:"src";s:36:"//www.npr.org/player/embed/{@i}/{@m}";}}',
		'nytimes'=>'a:3:{s:4:"host";s:11:"nytimes.com";s:7:"extract";a:2:{i:0;s:50:"!nytimes\\.com/video/[a-z]+/(?:[a-z]+/)?(?\'id\'\\d+)!";i:1;s:50:"!nytimes\\.com/video/\\d+/\\d+/\\d+/[a-z]+/(?\'id\'\\d+)!";}s:6:"iframe";a:3:{s:5:"width";s:3:"480";s:6:"height";s:3:"373";s:3:"src";s:89:"http://graphics8.nytimes.com/bcvideo/1.0/iframe/embed.html?videoId={@id}&playerType=embed";}}',
		'oddshot'=>'a:3:{s:4:"host";s:10:"oddshot.tv";s:7:"extract";s:31:"!oddshot.tv/shot/(?\'id\'[-\\w]+)!";s:6:"iframe";a:1:{s:3:"src";s:29:"//oddshot.tv/shot/{@id}/embed";}}',
		'pastebin'=>'a:3:{s:4:"host";s:12:"pastebin.com";s:7:"extract";s:49:"@pastebin\\.com/(?!u/)(?:\\w+\\.php\\?i=)?(?\'id\'\\w+)@";s:6:"iframe";a:5:{s:5:"width";s:4:"100%";s:6:"height";s:3:"300";s:3:"src";s:39:"//pastebin.com/embed_iframe.php?i={@id}";s:9:"scrolling";s:0:"";s:5:"style";a:1:{s:6:"resize";s:8:"vertical";}}}',
		'playstv'=>'a:3:{s:4:"host";s:8:"plays.tv";s:7:"extract";s:27:"!plays.tv/video/(?\'id\'\\w+)!";s:6:"iframe";a:1:{s:3:"src";s:23:"//plays.tv/embeds/{@id}";}}',
		'podbean'=>'a:4:{s:4:"host";s:11:"podbean.com";s:7:"extract";s:55:"!podbean\\.com/site/player/index/pid/\\d+/eid/(?\'id\'\\d+)!";s:6:"scrape";a:2:{s:5:"match";s:17:"!podbean\\.com/e/!";s:7:"extract";s:25:"!embed/postId/(?\'id\'\\d+)!";}s:6:"iframe";a:4:{s:5:"width";s:4:"100%";s:6:"height";s:3:"100";s:9:"max-width";s:3:"900";s:3:"src";s:49:"//www.podbean.com/media/player/audio/postId/{@id}";}}',
		'prezi'=>'a:3:{s:4:"host";s:9:"prezi.com";s:7:"extract";s:221:"#//prezi\\.com/(?!(?:a(?:bout|mbassadors)|c(?:o(?:llaborate|mmunity|ntact)|reate)|exp(?:erts|lore)|ip(?:ad|hone)|jobs|l(?:ear|ogi)n|m(?:ac|obility)|pr(?:es(?:s|ent)|icing)|recommend|support|user|windows|your)/)(?\'id\'\\w+)/#";s:6:"iframe";a:3:{s:5:"width";s:3:"550";s:6:"height";s:3:"400";s:3:"src";s:24:"//prezi.com/embed/{@id}/";}}',
		'reddit'=>'a:3:{s:4:"host";s:10:"reddit.com";s:7:"extract";s:38:"!(?\'path\'/r/\\w+/comments/\\w+/\\w+/\\w+)!";s:6:"iframe";a:4:{s:5:"width";s:3:"800";s:6:"height";s:3:"165";s:3:"src";s:52:"https://s9e.github.io/iframe/reddit.min.html#{@path}";s:6:"onload";s:177:"var a=Math.random();window.addEventListener(\'message\',function(b){{if(b.data.id==a)style.height=b.data.height+\'px\'}});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')";}}',
		'rutube'=>'a:4:{s:4:"host";s:9:"rutube.ru";s:7:"extract";s:30:"!rutube\\.ru/tracks/(?\'id\'\\d+)!";s:6:"scrape";a:2:{s:5:"match";s:31:"!rutube\\.ru/video/[0-9a-f]{32}!";s:7:"extract";s:34:"!rutube\\.ru/play/embed/(?\'id\'\\d+)!";}s:6:"iframe";a:3:{s:5:"width";s:3:"720";s:6:"height";s:3:"405";s:3:"src";s:28:"//rutube.ru/play/embed/{@id}";}}',
		'scribd'=>'a:3:{s:4:"host";s:10:"scribd.com";s:7:"extract";s:28:"!scribd\\.com/doc/(?\'id\'\\d+)!";s:6:"iframe";a:4:{s:5:"width";s:4:"100%";s:6:"height";s:3:"500";s:3:"src";s:81:"//www.scribd.com/embeds/{@id}/content?view_mode=scroll&show_recommendations=false";s:5:"style";a:1:{s:6:"resize";s:8:"vertical";}}}',
		'slideshare'=>'a:4:{s:4:"host";s:14:"slideshare.net";s:7:"extract";s:45:"!slideshare\\.net/[^/]+/[-\\w]+-(?\'id\'\\d{6,})$!";s:6:"scrape";a:2:{s:5:"match";s:26:"!slideshare\\.net/[^/]+/\\w!";s:7:"extract";s:29:"!"presentationId":(?\'id\'\\d+)!";}s:6:"iframe";a:3:{s:5:"width";s:3:"427";s:6:"height";s:3:"356";s:3:"src";s:47:"//www.slideshare.net/slideshow/embed_code/{@id}";}}',
		'soundcloud'=>'a:4:{s:4:"host";s:14:"soundcloud.com";s:7:"extract";a:4:{i:0;s:83:"@(?\'id\'https?://(?:api\\.)?soundcloud\\.com/(?!pages/)[-/\\w]+/[-/\\w]+|^[^/]+/[^/]+$)@";i:1;s:50:"@api.soundcloud.com/playlists/(?\'playlist_id\'\\d+)@";i:2;s:87:"@api.soundcloud.com/tracks/(?\'track_id\'\\d+)(?:\\?secret_token=(?\'secret_token\'[-\\w]+))?@";i:3;s:81:"@soundcloud\\.com/(?!playlists|tracks)[-\\w]+/[-\\w]+/(?=s-)(?\'secret_token\'[-\\w]+)@";}s:6:"scrape";a:2:{s:5:"match";s:54:"@soundcloud\\.com/(?!playlists|tracks)[-\\w]+/[-\\w]+/s-@";s:7:"extract";s:36:"@soundcloud:tracks:(?\'track_id\'\\d+)@";}s:6:"choose";a:2:{s:4:"when";a:3:{i:0;a:2:{s:4:"test";s:12:"@playlist_id";s:6:"iframe";a:4:{s:5:"width";s:4:"100%";s:6:"height";s:3:"450";s:9:"max-width";s:3:"900";s:3:"src";s:90:"https://w.soundcloud.com/player/?url=https%3A//api.soundcloud.com/playlists/{@playlist_id}";}}i:1;a:2:{s:4:"test";s:9:"@track_id";s:6:"iframe";a:4:{s:5:"width";s:4:"100%";s:6:"height";s:3:"166";s:9:"max-width";s:3:"900";s:3:"src";s:113:"https://w.soundcloud.com/player/?url=https%3A//api.soundcloud.com/tracks/{@track_id}&secret_token={@secret_token}";}}i:2;a:2:{s:4:"test";s:25:"not(contains(@id, \'://\'))";s:6:"iframe";a:4:{s:5:"width";s:4:"100%";s:6:"height";s:3:"166";s:9:"max-width";s:3:"900";s:3:"src";s:67:"https://w.soundcloud.com/player/?url=https%3A//soundcloud.com/{@id}";}}}s:9:"otherwise";a:1:{s:6:"iframe";a:4:{s:5:"width";s:4:"100%";s:6:"height";s:3:"166";s:9:"max-width";s:3:"900";s:3:"src";s:42:"https://w.soundcloud.com/player/?url={@id}";}}}}',
		'sportsnet'=>'a:3:{s:4:"host";s:12:"sportsnet.ca";s:6:"scrape";a:1:{s:7:"extract";a:2:{i:0;s:25:"/vid(?:eoId)?=(?\'id\'\\d+)/";i:1;s:46:"/param name="@videoPlayer" value="(?\'id\'\\d+)"/";}}s:6:"iframe";a:1:{s:3:"src";s:173:"https://images.rogersdigitalmedia.com/video_service.php?videoId={@id}&playerKey=AQ~~,AAAAAGWRwLc~,cRCmKE8Utf7OFWP38XQcokFZ80fR-u_y&autoStart=false&width=100%25&height=100%25";}}',
		'spotify'=>'a:4:{s:6:"scheme";s:7:"spotify";s:4:"host";a:2:{i:0;s:16:"open.spotify.com";i:1;s:16:"play.spotify.com";}s:7:"extract";a:2:{i:0;s:61:"!(?\'uri\'spotify:(?:album|artist|user|track(?:set)?):[,:\\w]+)!";i:1;s:73:"!(?:open|play)\\.spotify\\.com/(?\'path\'(?:album|artist|track|user)/[/\\w]+)!";}s:6:"iframe";a:3:{s:5:"width";s:3:"400";s:6:"height";s:3:"480";s:3:"src";s:224:"https://embed.spotify.com/?view=coverart&amp;uri=<xsl:choose><xsl:when test="@uri"><xsl:value-of select="@uri"/></xsl:when><xsl:otherwise>spotify:<xsl:value-of select="translate(@path,\'/\',\':\')"/></xsl:otherwise></xsl:choose>";}}',
		'stitcher'=>'a:3:{s:4:"host";s:12:"stitcher.com";s:6:"scrape";a:2:{s:5:"match";s:11:"!/podcast/!";s:7:"extract";a:2:{i:0;s:23:"!data-eid="(?\'eid\'\\d+)!";i:1;s:23:"!data-fid="(?\'fid\'\\d+)!";}}s:6:"iframe";a:4:{s:5:"width";s:4:"100%";s:6:"height";s:3:"150";s:9:"max-width";s:3:"900";s:3:"src";s:42:"//app.stitcher.com/splayer/f/{@fid}/{@eid}";}}',
		'strawpoll'=>'a:3:{s:4:"host";s:12:"strawpoll.me";s:7:"extract";s:26:"!strawpoll\\.me/(?\'id\'\\d+)!";s:6:"iframe";a:3:{s:5:"width";s:3:"600";s:6:"height";s:3:"310";s:3:"src";s:33:"http://strawpoll.me/embed_1/{@id}";}}',
		'streamable'=>'a:3:{s:4:"host";s:14:"streamable.com";s:7:"extract";s:28:"!streamable\\.com/(?\'id\'\\w+)!";s:6:"iframe";a:1:{s:3:"src";s:24:"//streamable.com/e/{@id}";}}',
		'teamcoco'=>'a:4:{s:4:"host";s:12:"teamcoco.com";s:7:"extract";s:32:"!teamcoco\\.com/video/(?\'id\'\\d+)!";s:6:"scrape";a:2:{s:5:"match";s:23:"!teamcoco\\.com/video/.!";s:7:"extract";s:17:"!"id":(?\'id\'\\d+)!";}s:6:"iframe";a:3:{s:5:"width";s:3:"640";s:6:"height";s:3:"415";s:3:"src";s:28:"//teamcoco.com/embed/v/{@id}";}}',
		'ted'=>'a:3:{s:4:"host";s:7:"ted.com";s:7:"extract";s:46:"!ted\\.com/(?\'id\'(?:talk|playlist)s/[^\\s"?]+)!i";s:6:"iframe";a:1:{s:3:"src";s:100:"//embed.ted.com/<xsl:value-of select="@id"/><xsl:if test="not(contains(@id,\'.html\'))">.html</xsl:if>";}}',
		'theatlantic'=>'a:3:{s:4:"host";s:15:"theatlantic.com";s:7:"extract";s:41:"!theatlantic\\.com/video/index/(?\'id\'\\d+)!";s:6:"iframe";a:3:{s:5:"width";s:3:"640";s:6:"height";s:3:"360";s:3:"src";s:46:"http://www.theatlantic.com/video/iframe/{@id}/";}}',
		'theonion'=>'a:3:{s:4:"host";s:12:"theonion.com";s:7:"extract";s:42:"!theonion\\.com/video/[-\\w]+[-,](?\'id\'\\d+)!";s:6:"iframe";a:1:{s:3:"src";s:45:"http://www.theonion.com/video_embed/?id={@id}";}}',
		'tinypic'=>'a:3:{s:4:"host";s:11:"tinypic.com";s:7:"extract";s:52:"!tinypic\\.com/player\\.php\\?v=(?\'id\'\\w+)&s=(?\'s\'\\d+)!";s:5:"flash";a:3:{s:5:"width";s:3:"560";s:6:"height";s:3:"345";s:3:"src";s:47:"http://tinypic.com/player.swf?file={@id}&s={@s}";}}',
		'tmz'=>'a:3:{s:4:"host";s:7:"tmz.com";s:7:"extract";s:28:"@tmz\\.com/videos/(?\'id\'\\w+)@";s:6:"iframe";a:1:{s:3:"src";s:117:"//www.kaltura.com/index.php/kwidget/cache_st/133592691/wid/_591531/partner_id/591531/uiconf_id/9071262/entry_id/{@id}";}}',
		'traileraddict'=>'a:3:{s:4:"host";s:17:"traileraddict.com";s:6:"scrape";a:2:{s:5:"match";s:37:"@traileraddict\\.com/(?!tags/)[^/]+/.@";s:7:"extract";s:34:"@v\\.traileraddict\\.com/(?\'id\'\\d+)@";}s:6:"iframe";a:1:{s:3:"src";s:27:"//v.traileraddict.com/{@id}";}}',
		'tumblr'=>'a:4:{s:4:"host";s:10:"tumblr.com";s:7:"extract";s:46:"!(?\'name\'[-\\w]+)\\.tumblr\\.com/post/(?\'id\'\\d+)!";s:6:"scrape";a:3:{s:3:"url";s:42:"http://{@name}.tumblr.com/post/{@id}/embed";s:5:"match";s:25:"!\\w\\.tumblr\\.com/post/\\d!";s:7:"extract";a:2:{i:0;s:29:"!"embed_did":"(?\'did\'[-\\w]+)!";i:1;s:29:"!"embed_key":"(?\'key\'[-\\w]+)!";}}s:6:"iframe";a:4:{s:5:"width";s:3:"520";s:6:"height";s:3:"180";s:3:"src";s:57:"https://s9e.github.io/iframe/tumblr.min.html#{@key}/{@id}";s:6:"onload";s:177:"var a=Math.random();window.addEventListener(\'message\',function(b){{if(b.data.id==a)style.height=b.data.height+\'px\'}});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')";}}',
		'twitch'=>'a:3:{s:4:"host";s:9:"twitch.tv";s:7:"extract";a:2:{i:0;s:96:"#twitch\\.tv/(?\'channel\'\\w+)(?:/b/(?\'archive_id\'\\d+)|/c/(?\'chapter_id\'\\d+)|/v/(?\'video_id\'\\d+))?#";i:1;s:32:"#t=(?\'t\'(?:(?:\\d+h)?\\d+m)?\\d+s)#";}s:6:"iframe";a:1:{s:3:"src";s:445:"//player.twitch.tv/?autoplay=false&amp;<xsl:choose><xsl:when test="@archive_id">video=a<xsl:value-of select="@archive_id"/></xsl:when><xsl:when test="@chapter_id">video=c<xsl:value-of select="@chapter_id"/></xsl:when><xsl:when test="@video_id">video=v<xsl:value-of select="@video_id"/></xsl:when><xsl:otherwise>channel=<xsl:value-of select="@channel"/></xsl:otherwise></xsl:choose><xsl:if test="@t">&amp;time=<xsl:value-of select="@t"/></xsl:if>";}}',
		'twitter'=>'a:3:{s:4:"host";s:11:"twitter.com";s:7:"extract";s:51:"@twitter\\.com/(?:#!/)?\\w+/status(?:es)?/(?\'id\'\\d+)@";s:6:"iframe";a:4:{s:5:"width";s:3:"500";s:6:"height";s:3:"186";s:3:"src";s:51:"https://s9e.github.io/iframe/twitter.min.html#{@id}";s:6:"onload";s:177:"var a=Math.random();window.addEventListener(\'message\',function(b){{if(b.data.id==a)style.height=b.data.height+\'px\'}});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')";}}',
		'ustream'=>'a:4:{s:4:"host";s:10:"ustream.tv";s:7:"extract";s:34:"!ustream\\.tv/recorded/(?\'vid\'\\d+)!";s:6:"scrape";a:2:{s:5:"match";s:90:"#ustream\\.tv/(?!explore/|platform/|recorded/|search\\?|upcoming$|user/)(?:channel/)?[-\\w]+#";s:7:"extract";s:19:"!embed/(?\'cid\'\\d+)!";}s:6:"choose";a:2:{s:4:"when";a:2:{s:4:"test";s:4:"@vid";s:6:"iframe";a:1:{s:3:"src";s:46:"//www.ustream.tv/embed/recorded/{@vid}?html5ui";}}s:9:"otherwise";a:1:{s:6:"iframe";a:1:{s:3:"src";s:37:"//www.ustream.tv/embed/{@cid}?html5ui";}}}}',
		'vbox7'=>'a:3:{s:4:"host";s:9:"vbox7.com";s:7:"extract";s:33:"!vbox7\\.com/play:(?\'id\'[\\da-f]+)!";s:6:"iframe";a:1:{s:3:"src";s:43:"http://vbox7.com/emb/external.php?vid={@id}";}}',
		'vevo'=>'a:3:{s:4:"host";s:8:"vevo.com";s:7:"extract";s:45:"!vevo\\.com/watch/([-/\\w]+/)?(?\'id\'[A-Z0-9]+)!";s:6:"iframe";a:3:{s:5:"width";s:3:"575";s:6:"height";s:3:"324";s:3:"src";s:51:"http://cache.vevo.com/m/html/embed.html?video={@id}";}}',
		'viagame'=>'a:3:{s:4:"host";s:11:"viagame.com";s:7:"extract";s:40:"!viagame\\.com/channels/[^/]+/(?\'id\'\\d+)!";s:6:"iframe";a:3:{s:5:"width";s:3:"640";s:6:"height";s:3:"392";s:3:"src";s:29:"//www.viagame.com/embed/{@id}";}}',
		'videomega'=>'a:3:{s:4:"host";s:12:"videomega.tv";s:7:"extract";s:32:"!videomega\\.tv/\\?ref=(?\'id\'\\w+)!";s:6:"iframe";a:1:{s:3:"src";s:40:"http://videomega.tv/iframe.php?ref={@id}";}}',
		'vidme'=>'a:5:{s:10:"attributes";a:2:{s:6:"height";a:1:{s:12:"defaultValue";s:3:"360";}s:5:"width";a:1:{s:12:"defaultValue";s:3:"640";}}s:4:"host";s:6:"vid.me";s:7:"extract";s:20:"!vid\\.me/(?\'id\'\\w+)!";s:6:"scrape";a:1:{s:7:"extract";s:170:"!meta property="og:video:type" content="video/\\w+">\\s*<meta property="og:video:height" content="(?\'height\'\\d+)">\\s*<meta property="og:video:width" content="(?\'width\'\\d+)!";}s:6:"iframe";a:3:{s:5:"width";s:8:"{@width}";s:6:"height";s:9:"{@height}";s:3:"src";s:22:"https://vid.me/e/{@id}";}}',
		'vimeo'=>'a:3:{s:4:"host";s:9:"vimeo.com";s:7:"extract";s:50:"!vimeo\\.com/(?:channels/[^/]+/|video/)?(?\'id\'\\d+)!";s:6:"iframe";a:1:{s:3:"src";s:30:"//player.vimeo.com/video/{@id}";}}',
		'vine'=>'a:3:{s:4:"host";s:7:"vine.co";s:7:"extract";s:25:"!vine\\.co/v/(?\'id\'[^/]+)!";s:6:"iframe";a:3:{s:5:"width";s:3:"480";s:6:"height";s:3:"480";s:3:"src";s:44:"https://vine.co/v/{@id}/embed/simple?audio=1";}}',
		'vk'=>'a:4:{s:4:"host";a:2:{i:0;s:6:"vk.com";i:1;s:12:"vkontakte.ru";}s:7:"extract";a:2:{i:0;s:71:"!vk(?:\\.com|ontakte\\.ru)/(?:[\\w.]+\\?z=)?video(?\'oid\'-?\\d+)_(?\'vid\'\\d+)!";i:1;s:98:"!vk(?:\\.com|ontakte\\.ru)/video_ext\\.php\\?oid=(?\'oid\'-?\\d+)&id=(?\'vid\'\\d+)&hash=(?\'hash\'[0-9a-f]+)!";}s:6:"scrape";a:3:{s:3:"url";s:32:"http://vk.com/video{@oid}_{@vid}";s:5:"match";s:21:"!vk.*?video-?\\d+_\\d+!";s:7:"extract";s:35:"!\\\\"hash2\\\\":\\\\"(?\'hash\'[0-9a-f]+)!";}s:6:"iframe";a:3:{s:5:"width";s:3:"607";s:6:"height";s:3:"360";s:3:"src";s:61:"//vk.com/video_ext.php?oid={@oid}&id={@vid}&hash={@hash}&hd=1";}}',
		'vocaroo'=>'a:3:{s:4:"host";s:11:"vocaroo.com";s:7:"extract";s:27:"!vocaroo\\.com/i/(?\'id\'\\w+)!";s:5:"flash";a:3:{s:5:"width";s:3:"148";s:6:"height";s:2:"44";s:3:"src";s:53:"//vocaroo.com/player.swf?playMediaID={@id}&autoplay=0";}}',
		'vox'=>'a:3:{s:4:"host";s:7:"vox.com";s:7:"extract";s:31:"!vox.com/.*#ooid=(?\'id\'[-\\w]+)!";s:6:"iframe";a:1:{s:3:"src";s:78:"//player.ooyala.com/iframe.html#pbid=a637d53c5c0a43c7bf4e342886b9d8b0&ec={@id}";}}',
		'wshh'=>'a:4:{s:4:"host";s:19:"worldstarhiphop.com";s:7:"extract";s:42:"!worldstarhiphop\\.com/featured/(?\'id\'\\d+)!";s:6:"scrape";a:2:{s:5:"match";s:49:"!worldstarhiphop\\.com/(?:\\w+/)?video\\.php\\?v=\\w+!";s:7:"extract";s:35:"!disqus_identifier[ =\']+(?\'id\'\\d+)!";}s:6:"iframe";a:3:{s:5:"width";s:3:"640";s:6:"height";s:3:"360";s:3:"src";s:37:"//www.worldstarhiphop.com/embed/{@id}";}}',
		'wsj'=>'a:4:{s:4:"host";s:7:"wsj.com";s:7:"extract";a:2:{i:0;s:38:"@wsj\\.com/[^#]*#!(?\'id\'[-0-9A-F]{36})@";i:1;s:43:"@wsj\\.com/video/[^/]+/(?\'id\'[-0-9A-F]{36})@";}s:6:"scrape";a:2:{s:5:"match";s:17:"@on\\.wsj\\.com/\\w@";s:7:"extract";s:27:"@guid=(?\'id\'[-0-9A-F]{36})@";}s:6:"iframe";a:3:{s:5:"width";s:3:"512";s:6:"height";s:3:"288";s:3:"src";s:59:"//video-api.wsj.com/api-video/player/iframe.html?guid={@id}";}}',
		'xboxclips'=>'a:3:{s:4:"host";s:13:"xboxclips.com";s:7:"extract";s:49:"!xboxclips\\.com/(?\'user\'[^/]+)/(?\'id\'[-0-9a-f]+)!";s:6:"iframe";a:1:{s:3:"src";s:35:"//xboxclips.com/{@user}/{@id}/embed";}}',
		'xboxdvr'=>'a:3:{s:4:"host";s:11:"xboxdvr.com";s:7:"extract";s:52:"!xboxdvr\\.com/gamer/(?\'user\'[^/]+)/video/(?\'id\'\\d+)!";s:6:"iframe";a:3:{s:5:"width";s:3:"640";s:6:"height";s:3:"360";s:3:"src";s:45:"//xboxdvr.com/gamer/{@user}/video/{@id}/embed";}}',
		'yahooscreen'=>'a:3:{s:4:"host";s:16:"screen.yahoo.com";s:7:"extract";s:52:"!screen\\.yahoo\\.com/(?:[-\\w]+/)?(?\'id\'[-\\w]+)\\.html!";s:6:"iframe";a:3:{s:5:"width";s:3:"640";s:6:"height";s:3:"360";s:3:"src";s:48:"https://screen.yahoo.com/{@id}.html?format=embed";}}',
		'youku'=>'a:3:{s:4:"host";s:9:"youku.com";s:7:"extract";s:33:"!youku\\.com/v_show/id_(?\'id\'\\w+)!";s:6:"iframe";a:3:{s:5:"width";s:3:"512";s:6:"height";s:3:"328";s:3:"src";s:35:"http://player.youku.com/embed/{@id}";}}',
		'youtube'=>'a:3:{s:4:"host";a:2:{i:0;s:11:"youtube.com";i:1;s:8:"youtu.be";}s:7:"extract";a:4:{i:0;s:45:"!youtube\\.com/(?:watch.*?v=|v/)(?\'id\'[-\\w]+)!";i:1;s:25:"!youtu\\.be/(?\'id\'[-\\w]+)!";i:2;s:57:"![#&?]t=(?:(?:(?\'h\'\\d+)h)?(?\'m\'\\d+)m(?\'s\'\\d+)|(?\'t\'\\d+))!";i:3;s:23:"!&list=(?\'list\'[-\\w]+)!";}s:6:"iframe";a:1:{s:3:"src";s:471:"//www.youtube.com/embed/<xsl:value-of select="@id"/><xsl:if test="@list">?list=<xsl:value-of select="@list"/></xsl:if><xsl:if test="@t or@m"><xsl:choose><xsl:when test="@list">&amp;</xsl:when><xsl:otherwise>?</xsl:otherwise></xsl:choose>start=<xsl:choose><xsl:when test="@t"><xsl:value-of select="@t"/></xsl:when><xsl:when test="@h"><xsl:value-of select="@h*3600+@m*60+@s"/></xsl:when><xsl:otherwise><xsl:value-of select="@m*60+@s"/></xsl:otherwise></xsl:choose></xsl:if>";}}',
		'zippyshare'=>'a:3:{s:4:"host";s:14:"zippyshare.com";s:6:"scrape";a:2:{s:5:"match";s:5:"!/v/!";s:7:"extract";s:45:"!file=(?\'file\'\\w+)&amp;server=(?\'server\'\\d+)!";}s:5:"flash";a:5:{s:5:"width";s:4:"100%";s:6:"height";s:2:"80";s:9:"max-width";s:3:"900";s:3:"src";s:35:"//api.zippyshare.com/api/player.swf";s:9:"flashvars";s:45:"file={@file}&server={@server}&autostart=false";}}'
	);
	public function getIds()
	{
		return \array_keys($this->cache);
	}
	protected function getSiteConfig($siteId)
	{
		return \unserialize($this->cache[$siteId]);
	}
	protected function hasSiteConfig($siteId)
	{
		return isset($this->cache[$siteId]);
	}
}